/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - NewIndexOID.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx.subagent.index;

import org.snmp4j.smi.OID;

/**
 * The {@code AnyNewIndexOID} is a special OID subclass for shared table
 * indexes. This object can be used to create a locally unique index value
 * during sub-agent initialization that will be replaced by a globally unique
 * index (which has not been used before by any sub-agent) when AgentX
 * connection is being established.
 *
 * @author Frank Fock
 * @version 1.0
 */
public class NewIndexOID extends OID {

    private static final long serialVersionUID = -7941697204485878916L;

    /**
     * Empty index constructor.
     */
    public NewIndexOID() {
    }

    /**
     * Constructs an {@code NewIndexOID} from an array of integer values.
     *
     * @param index an array of {@code int} values. The array
     *               is copied. Later changes to {@code rawOID} will therefore not
     *               affect the OID's value.
     */
    public NewIndexOID(int[] index) {
        super(index);
    }

    /**
     * Constructs an {@code NewIndexOID} from a dotted string. The string can contain
     * embedded strings enclosed by a single quote (') that are converted to
     * the corresponding OIO value. See {@link OID#OID(String)}.
     *
     * @param index a dotted OID index String, for example "3.38.50.39"
     */
    public NewIndexOID(String index) {
        super(index);
    }

    @Override
    public Object clone() {
        return new NewIndexOID(getValue());
    }

}
