/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - IndexEntry.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx.master.index;

import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

/**
 * {@link IndexEntry} represents an INDEX value in a {@link IndexRegistryEntry} part of an {@link AgentXIndexRegistry}.
 */
public class IndexEntry implements Comparable<Object> {

    private final int sessionID;
    private final Variable indexValue;

    /**
     * Creates an index entry.
     * @param sessionID
     *    the session ID.
     * @param indexValue
     *    the index value.
     */
    public IndexEntry(int sessionID, Variable indexValue) {
        this.sessionID = sessionID;
        this.indexValue = indexValue;
    }

    /**
     * Gets the session ID.
     * @return
     *    a session ID.
     */
    public int getSessionID() {
        return sessionID;
    }

    /**
     * Gets the index value.
     * @return
     *    an index value.
     */
    public Variable getIndexValue() {
        return indexValue;
    }

    @Override
    public int hashCode() {
        return indexValue.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IndexEntry) {
            return ((indexValue.equals(((IndexEntry) o).indexValue)) && (sessionID == ((IndexEntry) o).sessionID));
        } else if (o instanceof Variable) {
            return indexValue.equals(o);
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        OID indexOID = indexValue.toSubIndex(true);
        if (o instanceof IndexEntry) {
            return indexOID.compareTo(((IndexEntry) o).indexValue.toSubIndex(true));
        } else if (o instanceof Variable) {
            return indexOID.compareTo(((Variable) o).toSubIndex(true));
        }
        throw new ClassCastException(o.getClass() + " != (IndexEntry or Variable)");
    }

}
