/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXPendingClose.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/
package org.snmp4j.agent.agentx.master;

import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.subagent.AgentXRequest;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SnmpSubRequest;
import org.snmp4j.agent.request.SubRequestIterator;

import java.util.Collections;

import org.snmp4j.agent.request.SubRequestIteratorSupport;
import org.snmp4j.agent.agentx.AgentXClosePDU;
import org.snmp4j.smi.Address;

/**
 * A {@link AgentXPendingClose} is a special {@link AbstractAgentXPending} message for AgentX Close requests.
 * @param <A>
 *     the address type.
 */
public class AgentXPendingClose<A extends Address> extends AbstractAgentXPending<A> {

    private static final long serialVersionUID = 6969612307657156605L;

    private final AgentXMasterSession<A> session;
    private final AgentXClosePDU pendingPDU;

    /**
     * Creates a {@link AgentXPendingClose} from session and close PDU.
     * @param session
     *    the session that received the close.
     * @param pendingClosePDU
     *    the close PDU.
     */
    public AgentXPendingClose(AgentXMasterSession<A> session, AgentXClosePDU pendingClosePDU) {
        super(null, null);
        this.session = session;
        this.pendingPDU = pendingClosePDU;
    }

    @Override
    public AgentXPDU getAgentXPDU() {
        return pendingPDU;
    }

    @Override
    public SubRequestIterator<SnmpRequest.SnmpSubRequest> getReferences() {
        return new SubRequestIteratorSupport<>(Collections.EMPTY_LIST.iterator());
    }

    @Override
    public AgentXMasterSession<A> getSession() {
        return session;
    }
}
