/*_############################################################################
  _## 
  _##  SNMP4J-AgentX - AgentXTestSetPDU.java  
  _## 
  _##  Copyright (C) 2005-2026  Frank Fock (SNMP4J.org)
  _##  
  _##  This program is free software; you can redistribute it and/or modify
  _##  it under the terms of the GNU General Public License version 2 as 
  _##  published by the Free Software Foundation.
  _##
  _##  This program is distributed in the hope that it will be useful,
  _##  but WITHOUT ANY WARRANTY; without even the implied warranty of
  _##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  _##  GNU General Public License for more details.
  _##
  _##  You should have received a copy of the GNU General Public License
  _##  along with this program; if not, write to the Free Software
  _##  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
  _##  MA  02110-1301  USA
  _##  
  _##########################################################################*/

package org.snmp4j.agent.agentx;

import org.snmp4j.smi.*;

import java.io.Serial;

/**
 * The {@link AgentXTestSetPDU} represents the agentx-TestSet-PDU defined by RFC 2741.
 */
public class AgentXTestSetPDU extends AgentXVariableBindingPDU {

    @Serial
    private static final long serialVersionUID = -1260273186753634224L;

    /**
     *
     * Create a {@link AgentXTestSetPDU} from context and variable bindings.
     * @param context
     *    the context.
     * @param vbs
     *    an array of {@link VariableBinding} instances.
     */
    public AgentXTestSetPDU(OctetString context, VariableBinding[] vbs) {
        super(AGENTX_TESTSET_PDU, context, vbs);
    }

    /**
     * Creates a {@link AgentXResponsePDU} from a {@link AgentXMessageHeader}.
     * @param header
     *    the message header.
     */
    public AgentXTestSetPDU(AgentXMessageHeader header) {
        super(header);
        if (header.getType() != AGENTX_TESTSET_PDU) {
            throw new IllegalArgumentException();
        }
    }

}
