/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.util.LinkedList;
import java.util.List;
import org.snmp4j.agent.agentx.AgentXCleanupSetPDU;
import org.snmp4j.agent.agentx.AgentXCommitSetPDU;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXTestSetPDU;
import org.snmp4j.agent.agentx.AgentXUndoSetPDU;
import org.snmp4j.agent.agentx.master.AbstractAgentXPending;
import org.snmp4j.agent.agentx.master.AgentXMasterSession;
import org.snmp4j.agent.agentx.master.AgentXRegEntry;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.agent.request.SubRequestIteratorSupport;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.VariableBinding;

public class AgentXPendingSet<A extends Address>
extends AbstractAgentXPending<A> {
    private static final long serialVersionUID = 6075492117112399140L;
    private final AgentXMasterSession<A> session;
    private final List<AgentXSetVB> vbs = new LinkedList<AgentXSetVB>();
    private AgentXPDU requestPDU;

    public AgentXPendingSet(AgentXRegEntry<A> regEntry, SnmpRequest request) {
        super(regEntry, request);
        this.session = regEntry.getSession();
    }

    public synchronized void add(SnmpRequest.SnmpSubRequest reference, VariableBinding vb) {
        this.vbs.add(new AgentXSetVB(vb, reference));
        this.requestPDU = null;
    }

    @Override
    public AgentXPDU getAgentXPDU() {
        if (this.requestPDU == null) {
            this.createRequestPDU();
        }
        return this.requestPDU;
    }

    private void createRequestPDU() {
        AgentXPDU reqPDU = null;
        SnmpRequest request = this.vbs.get(0).getReferenceSubRequest().getRequest();
        switch (request.getPhase()) {
            case -1: 
            case 0: 
            case 1: {
                reqPDU = new AgentXTestSetPDU(request.getContext(), this.vbs.toArray(new VariableBinding[0]));
                break;
            }
            case 2: {
                reqPDU = new AgentXCommitSetPDU();
                break;
            }
            case 4: {
                reqPDU = new AgentXCleanupSetPDU();
                break;
            }
            default: {
                reqPDU = new AgentXUndoSetPDU();
            }
        }
        reqPDU.setSessionID(this.session.getSessionID());
        reqPDU.setTransactionID(request.getTransactionID());
        this.requestPDU = reqPDU;
    }

    @Override
    public AgentXMasterSession<A> getSession() {
        return this.session;
    }

    @Override
    public SubRequestIterator<SnmpRequest.SnmpSubRequest> getReferences() {
        return new SetSubRequestIterator();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + super.toStringMembers() + ",vbs=" + String.valueOf(this.vbs) + "]";
    }

    static class AgentXSetVB
    extends VariableBinding {
        private static final long serialVersionUID = 9058499911536689081L;
        private final transient SnmpRequest.SnmpSubRequest referenceSubRequest;

        public AgentXSetVB(VariableBinding vb, SnmpRequest.SnmpSubRequest reference) {
            super(vb.getOid(), vb.getVariable());
            this.referenceSubRequest = reference;
        }

        public SnmpRequest.SnmpSubRequest getReferenceSubRequest() {
            return this.referenceSubRequest;
        }
    }

    class SetSubRequestIterator
    extends SubRequestIteratorSupport<SnmpRequest.SnmpSubRequest> {
        protected SetSubRequestIterator() {
            super(AgentXPendingSet.this.vbs.iterator());
        }

        protected SnmpRequest.SnmpSubRequest mapToSubRequest(Object element) {
            return ((AgentXSetVB)((Object)element)).getReferenceSubRequest();
        }
    }
}

