/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.tools.console;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class TableFormatter {
    private PrintStream printer;
    private List<Object[]> buffer = new ArrayList<Object[]>();
    private int limit = 5;
    private int[] colSizes;
    private int defaultColSize = 16;
    private int maxLineLength = 80;
    private String separator = " ";
    private boolean compact = false;
    private boolean leftAlign = false;

    public TableFormatter(PrintStream printer, int defaultColumnSize, int maxLineLength, String separator) {
        this.printer = printer;
        this.maxLineLength = maxLineLength;
        this.defaultColSize = defaultColumnSize;
        if (separator != null) {
            this.separator = separator;
        }
    }

    public void setBufferSize(int limit) {
        this.limit = Math.max(limit, 1);
    }

    public void setCompact(boolean compact) {
        this.compact = compact;
    }

    public synchronized void addRow(Object[] columns) {
        this.buffer.add(columns);
        if (this.buffer.size() > this.limit) {
            this.flush();
        }
    }

    private void computeColumnSizes() {
        Object[] o;
        int numcols = 0;
        Iterator<Object[]> iterator2 = this.buffer.iterator();
        while (iterator2.hasNext()) {
            Object[] aBuffer1;
            o = aBuffer1 = iterator2.next();
            numcols = Math.max(numcols, o.length);
        }
        this.colSizes = new int[numcols];
        iterator2 = this.buffer.iterator();
        while (iterator2.hasNext()) {
            Object[] aBuffer;
            Object[] c = o = (aBuffer = iterator2.next());
            for (int j = 0; j < c.length; ++j) {
                String s = TableFormatter.getString(c[j]);
                this.colSizes[j] = Math.max(s.length(), this.colSizes[j]);
            }
        }
    }

    private static String getString(Object o) {
        if (o instanceof VariableBinding) {
            return ((VariableBinding)o).toValueString();
        }
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public synchronized void flush() {
        if (this.colSizes == null) {
            this.computeColumnSizes();
        }
        this.printBuffer();
        this.buffer.clear();
    }

    public void setLeftAlign(boolean leftAlign) {
        this.leftAlign = leftAlign;
    }

    private void printBuffer() {
        Iterator<Object[]> iterator2 = this.buffer.iterator();
        while (iterator2.hasNext()) {
            Object[] aBuffer;
            Object[] o;
            Object[] c = o = (aBuffer = iterator2.next());
            int rsz = 0;
            for (int j = 0; j < c.length; ++j) {
                int k;
                String s = TableFormatter.getString(c[j]);
                int sz = s.length();
                int tsz = j < this.colSizes.length ? this.colSizes[j] : this.defaultColSize;
                rsz += tsz + this.separator.length();
                if (this.compact) {
                    this.printer.print(s);
                    this.printer.print(this.separator);
                    continue;
                }
                boolean padded = false;
                if (!this.leftAlign && this.isNumber(c[j])) {
                    for (k = 0; k < tsz - sz; ++k) {
                        this.printer.print(' ');
                    }
                    padded = true;
                }
                this.printer.print(s);
                if (rsz > this.maxLineLength) {
                    this.printer.println();
                    rsz = 0;
                    continue;
                }
                if (!padded) {
                    this.printer.print(this.separator);
                    for (k = 0; k < tsz - sz; ++k) {
                        this.printer.print(' ');
                    }
                    continue;
                }
                this.printer.print(this.separator);
            }
            this.printer.println();
        }
    }

    private boolean isNumber(Object o) {
        Variable v;
        return o instanceof VariableBinding && ((v = ((VariableBinding)o).getVariable()) instanceof AssignableFromLong || v instanceof AssignableFromInteger);
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

