/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.util;

import java.util.SortedMap;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOScopeComparator;
import org.snmp4j.smi.OID;

public class MOScopePriorityComparator
extends MOScopeComparator {
    private final SortedMap<OID, Integer> priorityMap;

    public MOScopePriorityComparator(SortedMap<OID, Integer> priorityMap) {
        this.priorityMap = priorityMap;
    }

    @Override
    public int compare(MOScope o1, MOScope o2) {
        int result;
        OID lowerBound1 = o1.getLowerBound();
        OID lowerBound2 = o2.getLowerBound();
        Integer prio1 = this.getPriority(lowerBound1);
        Integer prio2 = this.getPriority(lowerBound2);
        if (prio1 == null && prio2 != null) {
            return 1;
        }
        if (prio1 != null && prio2 == null) {
            return -1;
        }
        if (prio1 != null && (result = prio1 - prio2) != 0) {
            return result;
        }
        return super.compare(o1, o2);
    }

    private Integer getPriority(OID oid) {
        Integer priority = (Integer)this.priorityMap.get(oid);
        if (priority == null) {
            SortedMap<OID, Integer> headMap = this.priorityMap;
            OID predecessor = null;
            do {
                headMap = headMap.headMap(predecessor == null ? oid : predecessor);
            } while (headMap.size() > 0 && (predecessor = headMap.lastKey()).size() > 0 && !oid.startsWith(predecessor));
            if (predecessor != null && oid.startsWith(predecessor)) {
                return (Integer)headMap.get(predecessor);
            }
        }
        return priority;
    }
}

