/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.subagent.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jetbrains.exodus.env.Environments;
import org.snmp4j.agent.DefaultMOServer;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.agentx.AgentX;
import org.snmp4j.agent.agentx.AgentXMessageDispatcher;
import org.snmp4j.agent.agentx.AgentXMessageDispatcherImpl;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.subagent.AgentXSharedMOTable;
import org.snmp4j.agent.agentx.subagent.AgentXSubagent;
import org.snmp4j.agent.agentx.subagent.RegistrationCallback;
import org.snmp4j.agent.agentx.subagent.SubagentXConfigManager;
import org.snmp4j.agent.agentx.subagent.test.AgentppTestMib;
import org.snmp4j.agent.db.MOXodusPersistence;
import org.snmp4j.agent.db.MOXodusPersistenceProvider;
import org.snmp4j.agent.io.MOInputFactory;
import org.snmp4j.agent.io.prop.PropertyMOInput;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp4j.Snmp4jConfigMib;
import org.snmp4j.agent.mo.snmp4j.Snmp4jLogMib;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TcpAddress;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;
import org.snmp4j.transport.unix.UnixDomainAddress;
import org.snmp4j.transport.unix.UnixSocketStreamTransportMapping;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.ThreadPool;

public class TestSubagent
implements Runnable,
TransportStateListener,
RegistrationCallback {
    private static final LogAdapter LOGGER;
    public static final OID SUBAGENT_ID;
    private final AgentXSubagent subagent;
    private final AgentX agentX;
    private final AgentXMessageDispatcher dispatcher;
    private final Address masterAddress;
    private final Address localAddress;
    private AgentXSession<Address> session;
    private int sessionID = 0;
    private final MOServer server;
    private AgentppTestMib agentppTestMib;
    private Snmp4jConfigMib snmp4jConfigMib;
    private Snmp4jLogMib snmp4jLogMib;
    private final SNMPv2MIB.SysUpTimeImpl sessionContextUpTime = new SNMPv2MIB.SysUpTimeImpl();
    private SubagentXConfigManager configManager;
    private MOXodusPersistence moXodusPersistence;

    public TestSubagent(final Address masterAddress, final Address localAddress, String configFile) {
        this.masterAddress = masterAddress;
        this.localAddress = localAddress;
        this.dispatcher = new AgentXMessageDispatcherImpl();
        this.agentX = new AgentX(this.dispatcher){

            @Override
            public Map<AgentXSession<?>, Integer> closeAllSessions(byte reason) {
                return TestSubagent.this.subagent.closeAllSessions(reason);
            }
        };
        this.server = new DefaultMOServer();
        this.server.addContext(new OctetString());
        MOInputFactory configurationFactory = null;
        InputStream configInputStream = TestSubagent.class.getResourceAsStream("TestSubagentConfig.properties");
        if (configInputStream != null) {
            Properties props = new Properties();
            try {
                props.load(configInputStream);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            configurationFactory = () -> new PropertyMOInput(props, this.configManager);
        }
        MOXodusPersistenceProvider moXodusPersistenceProvider = null;
        if (configFile != null) {
            this.moXodusPersistence = new MOXodusPersistence(new MOServer[]{this.server}, Environments.newInstance(configFile));
            moXodusPersistenceProvider = new MOXodusPersistenceProvider(this.moXodusPersistence);
        }
        this.configManager = new SubagentXConfigManager(this, this.agentX, this.dispatcher, new MOServer[]{this.server}, ThreadPool.create("AgentXSubAgent", 3), configurationFactory, moXodusPersistenceProvider, DefaultMOFactory.getInstance()){
            final /* synthetic */ TestSubagent this$0;
            {
                this.this$0 = this$0;
                super(agentXCommandListener, messageDispatcher, moServers, workerPool, configurationFactory, persistenceProvider, moFactory);
            }

            @Override
            protected void registerMIBs(OctetString context) throws DuplicateRegistrationException {
                super.registerMIBs(context);
                MOFactory factory = AgentppTestMib.getSharedTableFactory();
                DefaultMOFactory.addSNMPv2TCs(factory);
                this.this$0.agentppTestMib = new AgentppTestMib(factory);
                this.this$0.agentppTestMib.registerMOs(this.this$0.server, null);
            }

            @Override
            public void launchAgentXSessions() throws IOException {
                this.this$0.unregisterSessionDependent();
                this.this$0.session = new AgentXSession(++this.this$0.sessionID);
                int status = this.this$0.subagent.connect(masterAddress, localAddress, this.this$0.session, Collections.singletonList(this.this$0));
                if (status == 0) {
                    this.this$0.subagent.addAgentCaps(this.this$0.session, new OctetString(), new OID("1.3.6.1.4.1.4976.10.1.1.100.4.1"), new OctetString("AgentX-Test-Subagent"));
                    this.this$0.registerSessionDependent();
                    this.this$0.subagent.registerRegions(this.this$0.session, new OctetString(), null, this.this$0);
                    TimeTicks upTime = new TimeTicks();
                    this.this$0.sessionContextUpTime.setValue(upTime);
                    this.this$0.subagent.setPingDelay(250);
                    this.this$0.subagent.notify(null, SnmpConstants.warmStart, new VariableBinding[]{new VariableBinding(SnmpConstants.sysDescr, new OctetString("SNMP4J-AgentX Test-Subagent"))});
                }
            }
        };
        this.subagent = new AgentXSubagent(this.agentX, SUBAGENT_ID, new OctetString("AgentX4J Test agent"), this.configManager);
        this.configManager.registerShutdownHook();
    }

    public static void main(String[] args2) {
        ArgumentParser parser = new ArgumentParser("-c[s{=SampleAgent.cfg}] +h +v", "#masteraddress[s{=tcp:0.0.0.0/705}<(unix|tcp):.*[/[0-9]+]?>]");
        Map<String, List<Object>> commandLineParameters = null;
        try {
            commandLineParameters = parser.parse(args2);
            if (commandLineParameters.containsKey("h")) {
                TestSubagent.printUsage();
                System.exit(0);
            }
            if (commandLineParameters.containsKey("v")) {
                System.out.println("Options: " + String.valueOf(commandLineParameters));
            }
            String configFile = (String)commandLineParameters.get("c").get(0);
            String agentXAddress = (String)commandLineParameters.get("masteraddress").get(0);
            Address agentXMasterAddress = GenericAddress.parse(agentXAddress);
            if (agentXMasterAddress != null) {
                TransportMappings.getInstance().registerTransportMapping(UnixSocketStreamTransportMapping.class, UnixDomainAddress.class);
                Address localAddress = GenericAddress.newLocalAddress(GenericAddress.getTDomainPrefix(agentXMasterAddress.getClass()));
                TestSubagent sampleAgent = new TestSubagent(agentXMasterAddress, localAddress, configFile);
                sampleAgent.agentX.addTransportMapping(TransportMappings.getInstance().createTransportMapping(localAddress));
                sampleAgent.run();
            } else {
                TestSubagent.printUsage();
                System.exit(1);
            }
        }
        catch (ArgumentParser.ArgumentParseException ax) {
            TestSubagent.printUsage();
            System.out.println(ax.getMessage());
        }
        catch (Exception ex) {
            LOGGER.fatal("Caught exception while starting the agent", ex);
            ex.printStackTrace();
        }
    }

    protected void unregisterSessionDependent() {
        if (this.session != null) {
            OctetString sessionContext = TestSubagent.getSessionContext(this.session.getSessionID());
            this.server.removeContext(sessionContext);
            if (this.snmp4jConfigMib != null) {
                this.snmp4jConfigMib.unregisterMOs(this.server, sessionContext);
            }
            if (this.snmp4jLogMib != null) {
                this.snmp4jLogMib.unregisterMOs(this.server, sessionContext);
            }
        }
    }

    protected void registerSessionDependent() {
        OctetString sessionContext = TestSubagent.getSessionContext(this.session.getSessionID());
        this.server.addContext(sessionContext);
        this.snmp4jConfigMib = new Snmp4jConfigMib(this.sessionContextUpTime);
        try {
            this.snmp4jConfigMib.registerMOs(this.server, sessionContext);
        }
        catch (DuplicateRegistrationException e) {
            LOGGER.error("Failed to register Snmp4jConfigMib: " + e.getMessage(), e);
        }
        this.snmp4jLogMib = new Snmp4jLogMib();
        try {
            this.snmp4jLogMib.registerMOs(this.server, sessionContext);
        }
        catch (DuplicateRegistrationException e) {
            LOGGER.error("Failed to register Snmp4jLogMib: " + e.getMessage(), e);
        }
    }

    private static OctetString getSessionContext(int sessionID) {
        return new OctetString("session=" + sessionID);
    }

    @Override
    public void connectionStateChanged(TransportStateEvent change) {
        switch (change.getNewState()) {
            case 1: {
                LOGGER.info("Connected to " + String.valueOf(change.getPeerAddress()));
                break;
            }
            case 2: {
                this.subagent.resetConnection((TcpAddress)change.getPeerAddress(), true);
                this.configManager.getState().setState(35);
                Thread t = new Thread(() -> {
                    Address addr = change.getPeerAddress();
                    boolean reconnected = false;
                    for (int i = 0; i < 10; ++i) {
                        try {
                            Thread.sleep(5000L);
                            if (this.subagent.connect(addr, this.localAddress, this.session) != 0) continue;
                            reconnected = true;
                            this.configManager.getState().advanceState(40);
                            this.registerSessionDependent();
                            TimeTicks upTime = new TimeTicks();
                            this.subagent.registerRegions(this.session, new OctetString(), upTime, this);
                            this.server.addContext(TestSubagent.getSessionContext(this.session.getSessionID()));
                            this.sessionContextUpTime.setValue(upTime);
                            break;
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                    }
                    if (!reconnected) {
                        this.configManager.shutdown();
                        System.exit(1);
                    }
                });
                t.start();
                break;
            }
        }
    }

    @Override
    public void registrationEvent(OctetString context, ManagedObject<?> mo, int status) {
        if (status != 0) {
            // empty if block
        }
    }

    @Override
    public <R extends MOTableRow, C extends MOColumn<?>, M extends MOTableModel<R>> boolean tableRegistrationEvent(OctetString context, AgentXSharedMOTable<R, C, M> mo, R row, boolean indexAllocation, int status, int retryCount) {
        if (status != 0 && indexAllocation && (context == null || context.length() == 0) && retryCount < 2 && AgentppTestMib.oidAgentppTestSparseEntry.equals(mo.getOID())) {
            OID failedIndex = row.getIndex();
            int n = failedIndex.get(1) - 48;
            if (mo.removeRow(failedIndex) != null) {
                do {
                    failedIndex.setValue(new OctetString("[" + this.session.getSessionID() + "]" + n++).toSubIndex(false).getValue());
                } while (mo.getModel().containsRow(failedIndex));
                mo.addRow(row);
                return true;
            }
        }
        return false;
    }

    @Override
    public void unregistrationEvent(OctetString context, ManagedObject<?> mo, int status) {
    }

    @Override
    public <R extends MOTableRow, C extends MOColumn<?>, M extends MOTableModel<R>> void tableUnregistrationEvent(OctetString context, AgentXSharedMOTable<R, C, M> mo, R row, boolean indexAllocation, int status) {
    }

    @Override
    public void run() {
        this.configManager.run();
    }

    private static void printUsage() {
        String[] txt;
        for (String line : txt = new String[]{"Usage: TestMasterAgent [-c <config-path>] [-h] [-v]", "                       [-X <masterAddress>] <address1> [<address2> ..]", "", "where ", "  <config-path>        is the directory where persistent MIB data is stored/read.", "  -h                   prints this usage help information and exit.", "  -v                   print command line parameters.", "  <masterAddress>      is the TCP AgentX master agent address of the local", "                       host following the format 'tcp:<host>/<port>'.", "  <address>            a listen address following the format ", "                       'udp|tcp:<host>/<port>', for example udp:0.0.0.0/161", ""}) {
            System.out.println(line);
        }
    }

    static {
        LogFactory.setLogFactory(new ConsoleLogFactory());
        LogFactory.getLogFactory().getRootLogger().setLogLevel(LogLevel.ALL);
        LOGGER = LogFactory.getLogger(TestSubagent.class);
        SUBAGENT_ID = new OID();
    }
}

