/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx.master;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.function.Function;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.agent.CommandProcessor;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.agentx.AgentX;
import org.snmp4j.agent.agentx.AgentXAddAgentCapsPDU;
import org.snmp4j.agent.agentx.AgentXClosePDU;
import org.snmp4j.agent.agentx.AgentXCommandEvent;
import org.snmp4j.agent.agentx.AgentXCommandListener;
import org.snmp4j.agent.agentx.AgentXContextPDU;
import org.snmp4j.agent.agentx.AgentXGetBulkPDU;
import org.snmp4j.agent.agentx.AgentXIndexAllocatePDU;
import org.snmp4j.agent.agentx.AgentXIndexDeallocatePDU;
import org.snmp4j.agent.agentx.AgentXNotifyPDU;
import org.snmp4j.agent.agentx.AgentXOpenPDU;
import org.snmp4j.agent.agentx.AgentXPDU;
import org.snmp4j.agent.agentx.AgentXPeer;
import org.snmp4j.agent.agentx.AgentXPingPDU;
import org.snmp4j.agent.agentx.AgentXRegion;
import org.snmp4j.agent.agentx.AgentXRegisterPDU;
import org.snmp4j.agent.agentx.AgentXRemoveAgentCapsPDU;
import org.snmp4j.agent.agentx.AgentXRequestPDU;
import org.snmp4j.agent.agentx.AgentXResponseEvent;
import org.snmp4j.agent.agentx.AgentXResponseListener;
import org.snmp4j.agent.agentx.AgentXResponsePDU;
import org.snmp4j.agent.agentx.AgentXSession;
import org.snmp4j.agent.agentx.AgentXUnregisterPDU;
import org.snmp4j.agent.agentx.master.AgentXMasterEvent;
import org.snmp4j.agent.agentx.master.AgentXMasterListener;
import org.snmp4j.agent.agentx.master.AgentXMasterSession;
import org.snmp4j.agent.agentx.master.AgentXNode;
import org.snmp4j.agent.agentx.master.AgentXNodeQuery;
import org.snmp4j.agent.agentx.master.AgentXPending;
import org.snmp4j.agent.agentx.master.AgentXPendingClose;
import org.snmp4j.agent.agentx.master.AgentXPendingGet;
import org.snmp4j.agent.agentx.master.AgentXQueue;
import org.snmp4j.agent.agentx.master.AgentXRegEntry;
import org.snmp4j.agent.agentx.master.MasterContextInfo;
import org.snmp4j.agent.agentx.master.index.AgentXIndexRegistry;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.snmp.AgentCapabilityList;
import org.snmp4j.agent.mo.snmp.SNMPv2MIB;
import org.snmp4j.agent.mo.snmp.SysUpTime;
import org.snmp4j.agent.request.RequestStatus;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SnmpSubRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.request.SubRequestIterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.TransportStateEvent;
import org.snmp4j.transport.TransportStateListener;

public class AgentXCommandProcessor
extends CommandProcessor
implements AgentXCommandListener,
TransportStateListener,
AgentXResponseListener {
    public static final int MAX_REPROCESSING_DEFAULT = 100;
    private static final LogAdapter LOGGER = LogFactory.getLogger(AgentXCommandProcessor.class);
    private static final OctetString DEFAULT_CONTEXT = new OctetString();
    private final AgentXQueue agentXQueue;
    private final AgentX agentX;
    private final Map<Integer, AgentXMasterSession<?>> sessions = new HashMap();
    private final Map<? super Address, AgentXPeer<?>> peers = new HashMap(10);
    private final Set<AgentXRegEntry<?>> registrations = new TreeSet(new AgentXRegEntryComparator());
    private int nextSessionID = 1;
    private byte defaultTimeout = (byte)5;
    private int maxConsecutiveTimeouts = 3;
    private int maxParseErrors = -1;
    private final Map<OctetString, MasterContextInfo> contextInfo = new HashMap<OctetString, MasterContextInfo>(10);
    private boolean acceptNewContexts = false;
    private int nextPacketID = 0;
    protected AgentXIndexRegistry indexRegistry = new AgentXIndexRegistry();
    private transient List<AgentXMasterListener> agentXMasterListeners;
    private int maxReprocessing = 100;

    public AgentXCommandProcessor(OctetString contextEngineID, AgentXQueue queue, AgentX agentX, MOServer[] server) {
        super(contextEngineID);
        this.agentXQueue = queue;
        this.agentX = agentX;
        if (this.agentXQueue.getServer4BulkOptimization() == null) {
            this.agentXQueue.setServer4BulkOptimization(server);
        }
    }

    private synchronized int createNextPacketID() {
        return this.nextPacketID++;
    }

    public void setMaxReprocessing(int maxReprocessing) {
        this.maxReprocessing = maxReprocessing;
    }

    public int getMaxReprocessing() {
        return this.maxReprocessing;
    }

    public void setMaxParseErrors(int maxParseErrors) {
        this.maxParseErrors = maxParseErrors;
    }

    public int getMaxParseErrors() {
        return this.maxParseErrors;
    }

    @Override
    protected <A extends Address> void finalizeRequest(CommandResponderEvent<A> command, SnmpRequest req, MOServer server) {
        boolean complete = req.isComplete();
        AgentXQueue.AgentXQueueEntry<?> entry = this.agentXQueue.get(req.getTransactionID());
        boolean waitingForResponse = false;
        if (entry != null) {
            Collection<AgentXPending<?>> pending = entry.getPending();
            entry.updateTimestamp();
            for (AgentXPending<?> p : pending) {
                AgentXPDU agentXPDU = p.getAgentXPDU();
                AgentXMasterSession<?> session = p.getSession();
                agentXPDU.setSessionID(session.getSessionID());
                agentXPDU.setTransactionID(req.getTransactionID());
                agentXPDU.setPacketID(this.createNextPacketID());
                p.updateTimestamp();
                boolean expectResponse = true;
                if (agentXPDU.getType() != 11) {
                    waitingForResponse = true;
                } else {
                    p.setPending(false);
                    complete = req.isComplete();
                    expectResponse = false;
                }
                try {
                    this.agentX.send(agentXPDU, session.createAgentXTarget(), session.getPeer().getTransport(), expectResponse ? p : null, expectResponse ? this : null);
                }
                catch (IOException ex) {
                    LOGGER.error((Serializable)((Object)("Failed to send AgentX subrequest: " + ex.getMessage())));
                    p.getReferences().next().getStatus().setErrorStatus(5);
                    break;
                }
            }
        }
        if (entry == null || !waitingForResponse) {
            if (complete) {
                this.agentXQueue.removeAll(req.getTransactionID());
            } else if (req.getReprocessCounter() < this.maxReprocessing) {
                this.reprocessRequest(server, req);
            } else {
                req.setErrorStatus(5);
                LOGGER.warn((Serializable)((Object)("The following request has been reprocessed " + req.getReprocessCounter() + " which exceeds the agent's upper limit of " + this.maxReprocessing + ": " + String.valueOf(req))));
            }
            super.finalizeRequest(command, req, server);
        }
    }

    protected synchronized int getNextSessionID() {
        return this.nextSessionID++;
    }

    @Deprecated
    public MOServer getServer() {
        return super.getServer(null);
    }

    public byte getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public int getMaxConsecutiveTimeouts() {
        return this.maxConsecutiveTimeouts;
    }

    public boolean isAcceptNewContexts() {
        return this.acceptNewContexts;
    }

    public void setDefaultTimeout(byte defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setMaxConsecutiveTimeouts(int maxConsecutiveTimeouts) {
        this.maxConsecutiveTimeouts = maxConsecutiveTimeouts;
    }

    public void setAcceptNewContexts(boolean acceptNewContexts) {
        this.acceptNewContexts = acceptNewContexts;
    }

    @Override
    public <A extends Address> void processCommand(AgentXCommandEvent<A> event) {
        boolean pendingClose = false;
        if (event.isException()) {
            AgentXPeer<A> peer = this.getPeer(event.getPeerAddress());
            if (peer != null) {
                peer.incParseErrors();
                LOGGER.warn((Serializable)((Object)("AgentX parse exception from peer '" + String.valueOf(peer) + "' : " + String.valueOf(event.getException()))));
                if (this.maxParseErrors >= 0 && peer.getParseErrors() > this.maxParseErrors) {
                    LOGGER.warn((Serializable)((Object)("Removing peer due to excessive parse errors: " + String.valueOf(peer))));
                    this.closePeer((Address)peer.getAddress(), (byte)2);
                }
            } else {
                LOGGER.error((Serializable)((Object)("AgentX parse exception from unknown peer '" + String.valueOf(event.getPeerAddress()) + "' : " + String.valueOf(event.getException()))));
            }
        } else {
            AgentXPDU pdu = event.getCommand();
            AgentXMasterSession<?> session = this.getSession(pdu);
            AgentXResponsePDU response = null;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Processing AgentX PDU " + String.valueOf(pdu) + " for session " + String.valueOf(session))));
            }
            switch (pdu.getType()) {
                case 18: {
                    LOGGER.error((Serializable)((Object)"Internal error: received AgentX response without request"));
                    return;
                }
                case 1: {
                    response = this.openSession((AgentXOpenPDU)pdu, event);
                    AgentXMasterSession<?> newAgentXSession = this.getSession(response.getSessionID());
                    session = newAgentXSession;
                    break;
                }
                case 2: {
                    response = this.closeSession((AgentXClosePDU)pdu, session);
                    pendingClose = true;
                    break;
                }
                case 3: {
                    response = this.register((AgentXRegisterPDU)pdu, event, session);
                    break;
                }
                case 4: {
                    response = this.unregister((AgentXUnregisterPDU)pdu, event, session);
                    break;
                }
                case 16: {
                    response = this.addAgentCaps((AgentXAddAgentCapsPDU)pdu, session);
                    break;
                }
                case 17: {
                    response = this.removeAgentCaps((AgentXRemoveAgentCapsPDU)pdu, session);
                    break;
                }
                case 12: {
                    response = this.notify((AgentXNotifyPDU)pdu, session);
                    break;
                }
                case 13: {
                    response = this.ping((AgentXPingPDU)pdu, session);
                    break;
                }
                case 14: {
                    response = this.indexAllocate((AgentXIndexAllocatePDU)pdu, session);
                    break;
                }
                case 15: {
                    response = this.indexDeallocate((AgentXIndexDeallocatePDU)pdu, session);
                    break;
                }
                default: {
                    LOGGER.warn((Serializable)((Object)("Unknown AgentX PDU type received: " + String.valueOf(pdu))));
                }
            }
            if (response != null && session != null) {
                this.sendResponse(response, session);
            }
            if (pendingClose && session != null) {
                AgentXCommandProcessor.closePeer(session.getPeer());
            }
        }
        event.setProcessed(true);
    }

    private static <A extends Address> void closePeer(AgentXPeer<A> peer) {
        ConnectionOrientedTransportMapping<A> transport = peer.getTransport();
        if (transport != null) {
            try {
                if (transport.close(peer.getAddress())) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Closed sub-agent connection to " + String.valueOf(peer.getAddress()));
                    }
                } else {
                    LOGGER.warn((Serializable)((Object)("Failed to close sub-agent connection to " + String.valueOf(peer.getAddress()))));
                }
            }
            catch (IOException ex) {
                LOGGER.error("Failed to close transport mapping " + String.valueOf(peer.getTransport()) + " because: " + ex.getMessage(), ex);
            }
        }
    }

    public AgentXResponsePDU indexDeallocate(AgentXIndexDeallocatePDU pdu, AgentXMasterSession<?> session) {
        AgentXResponsePDU response = this.createResponse(pdu, session);
        boolean contextSupported = this.isContextSupported(pdu.getContext());
        if (contextSupported) {
            VariableBinding[] vbs = pdu.getVariableBindings();
            this.deallocateIndexes(response, pdu, session, vbs, true);
            if (response.getErrorStatus() == 0) {
                this.deallocateIndexes(response, pdu, session, vbs, false);
                response.setVariableBindings(vbs);
            }
        } else {
            response.setErrorStatus(262);
        }
        return response;
    }

    private boolean isContextSupported(OctetString context) {
        MOServer s = this.getServer(context);
        return s != null && s.isContextSupported(context);
    }

    private boolean checkIfContextIsSupported(OctetString context) {
        boolean contextSupported = this.isContextSupported(context);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)("Checking context '" + String.valueOf(context) + "' is supported")));
        }
        if (this.isAcceptNewContexts() && !contextSupported) {
            MOServer server = this.getServer(null);
            if (server != null) {
                server.addContext(context);
                contextSupported = server.isContextSupported(context);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Adding new context '" + String.valueOf(context) + "' on subagent request returned: " + contextSupported);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Adding new context '" + String.valueOf(context) + "' on subagent request failed because no default server found")));
            }
        }
        return contextSupported;
    }

    public AgentXResponsePDU indexAllocate(AgentXIndexAllocatePDU pdu, AgentXMasterSession<?> session) {
        AgentXResponsePDU response = this.createResponse(pdu, session);
        response.setVariableBindings(pdu.getVariableBindings());
        boolean contextSupported = this.checkIfContextIsSupported(pdu.getContext());
        if (contextSupported) {
            VariableBinding[] vbs = pdu.getVariableBindings();
            this.allocateIndexes(response, pdu, session, vbs, true);
            if (response.getErrorStatus() == 0) {
                this.allocateIndexes(response, pdu, session, vbs, false);
                response.setVariableBindings(vbs);
            }
        } else {
            response.setErrorStatus(262);
        }
        return response;
    }

    private int allocateIndexes(AgentXResponsePDU response, AgentXIndexAllocatePDU pdu, AgentXMasterSession<?> session, VariableBinding[] vbs, boolean testOnly) {
        int i;
        int status = 0;
        for (i = 0; i < vbs.length && status == 0; ++i) {
            VariableBinding vb = vbs[i];
            status = pdu.isFlagSet(4) ? this.indexRegistry.anyIndex(session.getSessionID(), pdu.getContext(), vb, testOnly) : (pdu.isFlagSet(2) ? this.indexRegistry.newIndex(session.getSessionID(), pdu.getContext(), vb, testOnly) : this.indexRegistry.allocate(session.getSessionID(), pdu.getContext(), vb, testOnly));
        }
        response.setErrorStatus(status);
        if (status != 0) {
            response.setErrorIndex(i);
        }
        return status;
    }

    private int deallocateIndexes(AgentXResponsePDU response, AgentXIndexDeallocatePDU pdu, AgentXMasterSession<?> session, VariableBinding[] vbs, boolean testOnly) {
        int i;
        int status = 0;
        for (i = 0; i < vbs.length && status == 0; ++i) {
            VariableBinding vb = vbs[i];
            status = this.indexRegistry.release(session.getSessionID(), pdu.getContext(), vb, testOnly);
        }
        response.setErrorStatus(status);
        if (status != 0) {
            response.setErrorIndex(i);
        }
        return status;
    }

    private SubRequestIterator<SnmpRequest.SnmpSubRequest> processAgentXNextResponse(AgentXPending<?> pending, AgentXResponsePDU pdu, int subRequestIndexUpperBound) throws NoSuchElementException {
        VariableBinding[] vbs = pdu.getVariableBindings();
        AgentXRequestPDU axReqPDU = (AgentXRequestPDU)pending.getAgentXPDU();
        SubRequestIterator<SnmpRequest.SnmpSubRequest> subRequests = pending.getReferences();
        for (int i = 0; i < subRequestIndexUpperBound && subRequests.hasNext(); ++i) {
            Function<OID, Boolean> function;
            SnmpSubRequest sreq = subRequests.next();
            if (pending instanceof AgentXPendingGet) {
                AgentXPendingGet pendingGet = (AgentXPendingGet)pending;
                function = pendingGet.getOidFilter();
            } else {
                function = null;
            }
            this.processNextSubRequest(vbs, axReqPDU, i, i, sreq, function);
        }
        return subRequests;
    }

    private void processNextSubRequest(VariableBinding[] vbs, AgentXRequestPDU axReqPDU, int vbIndex, int rangeIndex, SnmpSubRequest<? extends SubRequest<?>> sreq, Function<OID, Boolean> oidFilter) {
        MOScope srange = axReqPDU.getRanges()[rangeIndex];
        if (vbIndex < vbs.length) {
            VariableBinding vb = vbs[vbIndex];
            if (vb.getSyntax() == 130) {
                AgentXCommandProcessor.processEndOfMibView(sreq, srange, vb.getOid());
            } else if (!srange.covers(vb.getOid())) {
                AgentXCommandProcessor.processEndOfMibView(sreq, srange, null);
            } else if (vb.isException() || oidFilter != null && !oidFilter.apply(vb.getOid()).booleanValue() || oidFilter == null && this.vacm.isAccessAllowed(sreq.getSnmpRequest().getViewName(), vb.getOid()) != 0) {
                DefaultMOContextScope nscope = (DefaultMOContextScope)sreq.getScope();
                nscope.subtractScope(srange);
                nscope.setUpperBound(null);
                nscope.setUpperIncluded(true);
                sreq.setQuery(null);
                sreq.getStatus().setProcessed(false);
            } else {
                sreq.getVariableBinding().setOid(vb.getOid());
                sreq.getVariableBinding().setVariable(vb.getVariable());
                sreq.getStatus().setPhaseComplete(true);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Serializable)((Object)("Assigned next subrequest " + String.valueOf(sreq))));
                }
                sreq.updateNextRepetition();
            }
        } else {
            AgentXCommandProcessor.processEndOfMibView(sreq, srange, null);
        }
    }

    private static void processEndOfMibView(SnmpSubRequest<? extends SubRequest<?>> sreq, MOScope srange, OID oid) {
        if (srange.getUpperBound() == null) {
            SubRequestIterator tail = sreq.repetitions();
            while (tail.hasNext()) {
                SubRequest sr = (SubRequest)tail.next();
                if (oid == null) {
                    sr.getVariableBinding().setOid(srange.getLowerBound());
                } else {
                    sreq.getVariableBinding().setOid(oid);
                }
                sr.getVariableBinding().setVariable(Null.endOfMibView);
                sr.getStatus().setPhaseComplete(true);
            }
            return;
        }
        sreq.getStatus().setProcessed(false);
        DefaultMOContextScope nscope = (DefaultMOContextScope)sreq.getScope();
        nscope.subtractScope(srange);
        nscope.setUpperBound(null);
        nscope.setUpperIncluded(true);
        sreq.setQuery(null);
    }

    protected void processAgentXBulkResponse(AgentXPending<?> pending, AgentXResponsePDU pdu) {
        if (pdu.getErrorStatus() != 0) {
            AgentXCommandProcessor.processsErrorResponse(pending, pdu);
        } else {
            AgentXGetBulkPDU requestPDU = (AgentXGetBulkPDU)pending.getAgentXPDU();
            VariableBinding[] vbs = pdu.getVariableBindings();
            int numBindings = vbs.length;
            int repeaters = requestPDU.getRanges().length - requestPDU.getNonRepeaters();
            if (numBindings - requestPDU.getNonRepeaters() > requestPDU.getMaxRepetitions() * repeaters) {
                LOGGER.warn((Serializable)((Object)("Bulk response with more repetitions (" + (numBindings - requestPDU.getNonRepeaters()) / repeaters + ") than max rep. " + requestPDU.getMaxRepetitions())));
                numBindings = requestPDU.getMaxRepetitions() * repeaters + requestPDU.getNonRepeaters();
            }
            if (numBindings == 0) {
                AgentXRequestPDU axReqPDU = (AgentXRequestPDU)pending.getAgentXPDU();
                SubRequestIterator<SnmpRequest.SnmpSubRequest> subRequests = pending.getReferences();
                int i = 0;
                while (subRequests.hasNext()) {
                    SnmpSubRequest sreq = subRequests.next();
                    MOScope srange = axReqPDU.getRanges()[i];
                    AgentXCommandProcessor.processEndOfMibView(sreq, srange, null);
                    ++i;
                }
            } else {
                SubRequestIterator<SnmpRequest.SnmpSubRequest> it = this.processAgentXNextResponse(pending, pdu, requestPDU.getNonRepeaters());
                short nonRep = requestPDU.getNonRepeaters();
                int c = 0;
                while (c + nonRep < requestPDU.getRanges().length && it.hasNext()) {
                    int rangeIndex = c + nonRep;
                    SnmpSubRequest sreq = it.next();
                    SubRequestIterator rsreq = sreq.repetitions();
                    int r = 0;
                    while (nonRep + r * repeaters + c < numBindings && rsreq.hasNext()) {
                        Function<OID, Boolean> function;
                        SnmpRequest.SnmpSubRequest repetition = (SnmpRequest.SnmpSubRequest)rsreq.next();
                        if (pending instanceof AgentXPendingGet) {
                            AgentXPendingGet pendingGet = (AgentXPendingGet)pending;
                            function = pendingGet.getOidFilter();
                        } else {
                            function = null;
                        }
                        this.processNextSubRequest(vbs, requestPDU, nonRep + r * repeaters + c, rangeIndex, repetition, function);
                        ++r;
                    }
                    ++c;
                }
            }
        }
    }

    protected static void processsErrorResponse(AgentXPending<?> pending, AgentXResponsePDU pdu) throws NoSuchElementException {
        SubRequestIterator<SnmpRequest.SnmpSubRequest> subRequests = pending.getReferences();
        for (int i = 1; i < pdu.getErrorIndex(); ++i) {
            if (!subRequests.hasNext()) {
                pending.getRequest().setErrorStatus(5);
                return;
            }
            subRequests.next();
        }
        if (subRequests.hasNext()) {
            SubRequest sreq = subRequests.next();
            RequestStatus status = sreq.getStatus();
            switch (pdu.getErrorStatus()) {
                case 258: 
                case 259: 
                case 260: 
                case 261: {
                    status.setErrorStatus(13);
                    break;
                }
                default: {
                    status.setErrorStatus(pdu.getErrorStatus());
                    break;
                }
            }
        } else {
            pending.getRequest().setErrorStatus(5);
        }
    }

    private static boolean checkAgentXResponse(AgentXResponsePDU pdu, AgentXPending<?> pending) {
        switch (pending.getAgentXPDU().getType()) {
            case 5: 
            case 6: {
                if (((AgentXRequestPDU)pending.getAgentXPDU()).getRanges().length == pdu.size()) break;
                pending.getRequest().setErrorStatus(5);
                return false;
            }
        }
        return true;
    }

    protected AgentXResponsePDU ping(AgentXPingPDU pdu, AgentXMasterSession<?> session) {
        AgentXResponsePDU response = this.createResponse(pdu, session);
        if (!this.checkIfContextIsSupported(pdu.getContext())) {
            response.setErrorStatus(262);
            return response;
        }
        return response;
    }

    protected AgentXResponsePDU notify(AgentXNotifyPDU pdu, AgentXMasterSession<?> session) {
        AgentXResponsePDU response = this.createResponse(pdu, session);
        if (session != null) {
            if (!this.checkIfContextIsSupported(pdu.getContext())) {
                response.setErrorStatus(262);
                return response;
            }
            VariableBinding[] vbs = pdu.getVariableBindings();
            response.setVariableBindings(vbs);
            int payloadIndex = 1;
            OID trapoid = null;
            TimeTicks timestamp = new TimeTicks(this.getContextSysUpTime(DEFAULT_CONTEXT));
            if (vbs.length >= 1) {
                if (SnmpConstants.sysUpTime.equals(vbs[0].getOid())) {
                    ++payloadIndex;
                    if (vbs.length < 2 || !SnmpConstants.snmpTrapOID.equals(vbs[1].getOid())) {
                        response.setErrorStatus(268);
                        response.setErrorIndex(2);
                    } else {
                        timestamp = (TimeTicks)vbs[0].getVariable();
                        trapoid = (OID)vbs[1].getVariable();
                    }
                } else if (SnmpConstants.snmpTrapOID.equals(vbs[0].getOid())) {
                    trapoid = (OID)vbs[0].getVariable();
                } else {
                    response.setErrorStatus(268);
                    response.setErrorIndex(1);
                }
            }
            if (trapoid != null) {
                VariableBinding[] pvbs = new VariableBinding[vbs.length - payloadIndex];
                System.arraycopy(vbs, payloadIndex, pvbs, 0, pvbs.length);
                this.notify(pdu.getContext(), trapoid, timestamp, pvbs);
            }
        }
        return response;
    }

    protected TimeTicks getContextSysUpTime(OctetString context) {
        SysUpTime contextSysUpTime;
        MasterContextInfo info = this.contextInfo.get(context);
        if (info == null) {
            DefaultMOContextScope scope = new DefaultMOContextScope(context, SnmpConstants.sysUpTime, true, SnmpConstants.sysUpTime, true);
            ManagedObject<?> mo = this.getManagedObject(context, new DefaultMOQuery(scope));
            if (mo instanceof SysUpTime) {
                contextSysUpTime = (SysUpTime)((Object)mo);
            } else if (mo instanceof AssignableFromLong) {
                LOGGER.info("SysUpTime could not be found in '" + String.valueOf(context) + "' context but managed object " + String.valueOf(mo) + " found which has a long value. Using this to init a new SysUpTime.");
                contextSysUpTime = new SNMPv2MIB.SysUpTimeImpl();
                ((SNMPv2MIB.SysUpTimeImpl)contextSysUpTime).setValue(new TimeTicks(((AssignableFromLong)((Object)mo)).toLong()));
            } else {
                LOGGER.warn((Serializable)((Object)("SysUpTime could not be found in '" + String.valueOf(context) + "' context, using a new instance instead")));
                contextSysUpTime = new SNMPv2MIB.SysUpTimeImpl();
            }
            this.contextInfo.put(context, new MasterContextInfo(context, contextSysUpTime));
        } else {
            contextSysUpTime = info.getUpTime();
        }
        if (contextSysUpTime != null) {
            return contextSysUpTime.get();
        }
        return null;
    }

    public AgentXResponsePDU addAgentCaps(AgentXAddAgentCapsPDU pdu, AgentXMasterSession<?> session) {
        AgentXResponsePDU response = this.createResponse(pdu, session);
        if (session != null) {
            if (!this.checkIfContextIsSupported(pdu.getContext())) {
                response.setErrorStatus(262);
                return response;
            }
            AgentCapabilityList agentCaps = this.getAgentCaps(pdu.getContext());
            if (agentCaps != null) {
                OID index2 = agentCaps.addSysOREntry(pdu.getId(), pdu.getDescr());
                session.addAgentCaps(pdu.getId(), index2);
            }
        }
        return response;
    }

    protected AgentCapabilityList getAgentCaps(OctetString contextName) {
        DefaultMOContextScope scope = new DefaultMOContextScope(contextName, SnmpConstants.sysOREntry, true, SnmpConstants.sysOREntry.nextPeer(), false);
        ManagedObject<?> mo = this.getManagedObject(contextName, new DefaultMOQuery(scope));
        if (!(mo instanceof AgentCapabilityList)) {
            LOGGER.warn((Serializable)((Object)("SysOREntry managed object for context " + String.valueOf(contextName) + " not found, instead found: " + String.valueOf(mo))));
            return null;
        }
        return (AgentCapabilityList)((Object)mo);
    }

    private ManagedObject<?> getManagedObject(OctetString contextName, MOQuery query) {
        ManagedObject mo = null;
        MOServer server = this.getServer(contextName);
        if (server != null) {
            mo = server.lookup(query, ManagedObject.class);
        }
        return mo;
    }

    public AgentXResponsePDU removeAgentCaps(AgentXRemoveAgentCapsPDU pdu, AgentXMasterSession<?> session) {
        AgentXResponsePDU response = this.createResponse(pdu, session);
        if (session != null) {
            OID index2 = session.removeAgentCaps(pdu.getId());
            AgentCapabilityList agentCaps = this.getAgentCaps(pdu.getContext());
            if (agentCaps != null) {
                MOTableRow ac = agentCaps.removeSysOREntry(index2);
                if (ac == null) {
                    response.setErrorStatus(265);
                }
            } else {
                response.setErrorStatus(265);
            }
        }
        return response;
    }

    public AgentXResponsePDU closeSession(AgentXClosePDU pdu, AgentXMasterSession<?> session) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Subagent is closing session " + String.valueOf(session) + " because " + pdu.getReason());
        }
        AgentXResponsePDU response = this.createResponse(pdu, session);
        if (session != null) {
            this.removeSession(session.getSessionID());
            this.removeAllRegistrations(session);
            session.setClosed(true);
        }
        return response;
    }

    @Override
    public Map<AgentXSession<?>, Integer> closeAllSessions(byte reason) {
        HashMap result = new HashMap(this.sessions.size());
        for (AgentXMasterSession<?> agentXSession : this.sessions.values()) {
            int status = this.closeSession(agentXSession, reason);
            result.put(agentXSession, status);
        }
        return result;
    }

    public <A extends Address> int closeSession(AgentXMasterSession<A> session, byte reason) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Closing sub-agent session " + String.valueOf(session) + " because " + reason);
        }
        AgentXClosePDU closePDU = new AgentXClosePDU(reason);
        int result = 0;
        try {
            this.agentX.send(closePDU, session.createAgentXTarget(), session.getPeer().getTransport(), new AgentXPendingClose<A>(session, closePDU), this);
        }
        catch (IOException ex) {
            result = -1;
            LOGGER.error("Failed to send CloseSessionPDU to close session " + String.valueOf(session) + ": " + ex.getMessage(), ex);
        }
        this.removeSession(session.getSessionID());
        this.removeAllRegistrations(session);
        session.setClosed(true);
        return result;
    }

    protected synchronized void removeAllRegistrations(AgentXMasterSession<?> session) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)("Removing all registrations (out of " + this.registrations.size() + ") of session " + String.valueOf(session))));
        }
        Iterator<AgentXRegEntry<?>> it = this.registrations.iterator();
        while (it.hasNext()) {
            AgentXRegEntry<?> r = it.next();
            if (!r.getSession().equals(session)) continue;
            this.removeRegistration(r, it);
        }
    }

    protected AgentXMasterSession<?> getSession(int sessionID) {
        return this.sessions.get(sessionID);
    }

    protected synchronized AgentXMasterSession<?> getSession(AgentXPDU pdu) {
        int sessionID = pdu.getSessionID();
        return this.getSession(sessionID);
    }

    protected <A extends Address> AgentXResponsePDU register(AgentXRegisterPDU pdu, AgentXCommandEvent<A> command, AgentXMasterSession<A> session) {
        AgentXResponsePDU response = this.createResponse(pdu, session);
        if (session != null) {
            if (!this.checkIfContextIsSupported(pdu.getContext())) {
                response.setErrorStatus(262);
                return response;
            }
            AgentXRegEntry<A> regEntry = new AgentXRegEntry<A>(session, pdu.getRegion(), pdu.getPriority() & 0xFF, pdu.getContext(), pdu.getTimeout());
            if (this.isDuplicate(regEntry)) {
                response.setErrorStatus(263);
                return response;
            }
            AgentXMasterEvent event = new AgentXMasterEvent(this, -5, regEntry);
            this.fireMasterChanged(event);
            if (event.getVetoReason() == 0) {
                try {
                    this.addRegistration(regEntry);
                }
                catch (DuplicateRegistrationException drex) {
                    if (LOGGER.isDebugEnabled()) {
                        drex.printStackTrace();
                    }
                    response.setErrorStatus(263);
                    return response;
                }
            } else {
                response.setErrorStatus(event.getVetoReason());
            }
        }
        return response;
    }

    protected <A extends Address> AgentXResponsePDU unregister(AgentXUnregisterPDU pdu, AgentXCommandEvent<A> event, AgentXMasterSession<A> session) {
        AgentXResponsePDU response = this.createResponse(pdu, session);
        if (session != null) {
            AgentXRegEntry<A> regEntry = new AgentXRegEntry<A>(session, pdu.getRegion(), pdu.getPriority() & 0xFF, pdu.getContext(), pdu.getTimeout());
            boolean found = false;
            Iterator<AgentXRegEntry<?>> it = this.registrations.iterator();
            while (it.hasNext()) {
                AgentXRegEntry<?> r = it.next();
                if (!r.equals(regEntry)) continue;
                found = true;
                if (this.removeRegistration(r, it)) break;
                response.setErrorStatus(264);
                break;
            }
            if (!found) {
                response.setErrorStatus(264);
            }
        }
        return response;
    }

    protected synchronized boolean isDuplicate(AgentXRegEntry<?> registration) {
        if (this.registrations.contains(registration)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Identical registration attempt for " + String.valueOf(registration) + " in " + String.valueOf(this.registrations))));
            }
            return true;
        }
        AgentXNodeQuery query = new AgentXNodeQuery(registration.getContext(), registration.getRegion(), 0);
        ManagedObject<?> mo = this.getManagedObject(registration.getContext(), query);
        if (mo != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("New registration is rejected as duplicate because it overlaps with non AgentX managed object: " + String.valueOf(mo))));
            }
            return true;
        }
        return false;
    }

    protected synchronized void addRegistration(AgentXRegEntry<?> registration) throws DuplicateRegistrationException {
        this.registrations.add(registration);
        if (registration.getRegion().isRange()) {
            long stop;
            AgentXRegion r = registration.getRegion();
            long start = (long)r.getLowerBoundSubID() & 0xFFFFFFFFL;
            if (start > (stop = (long)r.getUpperBoundSubID() & 0xFFFFFFFFL)) {
                LOGGER.warn((Serializable)((Object)("Empty range registration " + String.valueOf(registration))));
            } else {
                for (long s = start; s <= stop; ++s) {
                    OID root = new OID(r.getLowerBound());
                    root.set(r.getRangeSubID() - 1, (int)s);
                    AgentXRegion sr = new AgentXRegion(root, root.nextPeer());
                    this.addRegion(registration, sr);
                }
            }
        } else {
            this.addRegion(registration, registration.getRegion());
        }
        AgentXMasterEvent e = new AgentXMasterEvent(this, 5, registration);
        this.fireMasterChanged(e);
    }

    private static AgentXNodeQuery nextQuery(AgentXNodeQuery lastQuery, AgentXNode lastNode) {
        if (lastNode != null) {
            lastQuery.getMutableScope().setLowerBound(lastNode.getScope().getUpperBound());
            lastQuery.getMutableScope().setLowerIncluded(!lastNode.getScope().isUpperIncluded());
        }
        return lastQuery;
    }

    protected synchronized void addRegion(AgentXRegEntry<?> registration, AgentXRegion region) throws DuplicateRegistrationException {
        if (region.isRange()) {
            String errText = "Regions with range cannot be added";
            LOGGER.error((Serializable)((Object)errText));
            throw new IllegalArgumentException(errText);
        }
        AgentXNodeQuery query = new AgentXNodeQuery(registration.getContext(), region, 1);
        AgentXNode lastNode = null;
        MOServer server = this.getServer(registration.getContext());
        ManagedObject<?> managedObject = server.lookup(query);
        if (managedObject instanceof AgentXNode) {
            AgentXNode node = (AgentXNode)managedObject;
            LinkedList<AgentXNode> splitted = new LinkedList<AgentXNode>();
            AgentXRegion r1 = new AgentXRegion(region);
            while (node != null && r1 != null) {
                AgentXRegion r2 = new AgentXRegion(node.getScope().getLowerBound(), node.getScope().getUpperBound());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Serializable)((Object)("Affected region r2=" + String.valueOf(r2) + " from registered region r1=" + String.valueOf(r1))));
                }
                if (r2.covers(r1)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Serializable)((Object)("Region r2 covers r1 (r1=" + String.valueOf(r1) + ",r2=" + String.valueOf(r2) + ")")));
                    }
                    AgentXCommandProcessor.oldRegionCoversNew(registration, node, splitted, r1, r2);
                    r1 = null;
                } else if (r1.covers(r2)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Serializable)((Object)("Region r1 covers r2 (r1=" + String.valueOf(r1) + ",r2=" + String.valueOf(r2) + ")")));
                    }
                    r1 = AgentXCommandProcessor.newRegionCoversOld(registration, lastNode, node, splitted, r1, r2);
                } else if (r1.isOverlapping(r2) && r2.getLowerBound().compareTo(r1.getLowerBound()) < 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Serializable)((Object)("Region r1 overlaps r2 and r2 < r1 (r1=" + String.valueOf(r1) + ",r2=" + String.valueOf(r2) + ")")));
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Serializable)((Object)("Shrinking node " + String.valueOf(node) + " to " + String.valueOf(r1.getLowerBound()))));
                    }
                    node.shrink(r1.getLowerBound());
                    r2b = node.getClone(new AgentXRegion(r1.getLowerBound(), r2.getUpperBound()));
                    r2b.addRegistration(registration);
                    splitted.add(r2b);
                    r1 = new AgentXRegion(r2.getUpperBound(), r1.getLowerBound());
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Serializable)((Object)("Region r1 overlaps r2 and r1 < r2 (r1=" + String.valueOf(r1) + ",r2=" + String.valueOf(r2) + ")")));
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Serializable)((Object)("Shrinking node " + String.valueOf(node) + " to " + String.valueOf(r1.getUpperBound()))));
                    }
                    node.shrink(r1.getUpperBound());
                    r2b = node.getClone(new AgentXRegion(r1.getUpperBound(), r2.getUpperBound()));
                    node.addRegistration(registration);
                    splitted.add(r2b);
                    AgentXNode r1a = new AgentXNode(new AgentXRegion(r1.getLowerBound(), r2.getLowerBound()), registration);
                    splitted.add(r1a);
                    r1 = null;
                }
                if (r1 != null) {
                    if (r1.isEmpty()) {
                        splitted.add(new AgentXNode(region, registration));
                    } else {
                        splitted.add(new AgentXNode(r1, registration));
                    }
                }
                lastNode = node;
                node = (AgentXNode)server.lookup(AgentXCommandProcessor.nextQuery(query, lastNode));
            }
            for (AgentXNode n : splitted) {
                server.register(n, registration.getContext());
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug((Serializable)((Object)("Registered split AgentX node: " + String.valueOf(n))));
            }
        } else {
            AgentXNode node = new AgentXNode(region, registration);
            server.register(node, registration.getContext());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Registered AgentX node: " + String.valueOf(node))));
            }
        }
    }

    protected boolean removeRegistration(AgentXRegEntry<?> registration, Iterator<AgentXRegEntry<?>> regIterator) {
        LinkedList<AgentXNode> remove = new LinkedList<AgentXNode>();
        AgentXRegion queryRegion = new AgentXRegion(registration.getRegion());
        queryRegion.setUpperIncluded(true);
        AgentXNodeQuery query = new AgentXNodeQuery(registration.getContext(), queryRegion, 1);
        AgentXNode lastNode = null;
        MOServer server = this.getServer(registration.getContext());
        AgentXNode node = (AgentXNode)server.lookup(query);
        if (node != null) {
            while (node != null && node != lastNode) {
                if (node.removeRegistration(registration) && node.getRegistrationCount() == 0) {
                    remove.add(node);
                } else if (lastNode != null && lastNode.getRegistrationCount() == 1 && node.getRegistrationCount() == 1 && lastNode.getScope().getUpperBound().equals(node.getScope().getLowerBound()) && node.getActiveRegistration().equals(lastNode.getActiveRegistration())) {
                    AgentXRegion r = new AgentXRegion(node.getScope().getLowerBound(), lastNode.getScope().getUpperBound());
                    if (node.getActiveRegistration().getRegion().covers(r)) {
                        remove.add(node);
                        lastNode.expand(node.getScope().getUpperBound(), false);
                    }
                }
                lastNode = node;
                node = (AgentXNode)server.lookup(AgentXCommandProcessor.nextQuery(query, lastNode));
            }
        } else {
            LOGGER.warn((Serializable)((Object)("A registration is removed with not associated subtree: " + String.valueOf(registration))));
        }
        for (AgentXNode rnode : remove) {
            server.unregister(rnode, registration.getContext());
        }
        if (regIterator != null) {
            regIterator.remove();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Removed registration " + String.valueOf(registration) + " by session close, " + this.registrations.size() + " left.")));
            }
            this.fireMasterChanged(new AgentXMasterEvent(this, 6, registration));
            return true;
        }
        if (this.registrations.remove(registration)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Removed registration " + String.valueOf(registration) + ", " + this.registrations.size() + " left.")));
            }
            this.fireMasterChanged(new AgentXMasterEvent(this, 6, registration));
            return true;
        }
        return false;
    }

    private static AgentXRegion newRegionCoversOld(AgentXRegEntry<?> registration, AgentXNode lastNode, AgentXNode node, LinkedList<AgentXNode> splitted, AgentXRegion r1, AgentXRegion r2) {
        AgentXNode r1a;
        if (lastNode != null) {
            AgentXRegion r = new AgentXRegion(lastNode.getScope().getUpperBound(), r2.getLowerBound());
            r1a = new AgentXNode(r, registration);
        } else {
            AgentXRegion r = new AgentXRegion(r1.getLowerBound(), r2.getLowerBound());
            r1a = new AgentXNode(r, registration);
        }
        if (!splitted.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Shrinking node " + String.valueOf(splitted.getLast()) + " to " + String.valueOf(r2.getLowerBound()))));
            }
            splitted.getLast().shrink(r2.getLowerBound());
        }
        node.addRegistration(registration);
        if (r1.getLowerBound().equals(r2.getLowerBound()) || !splitted.isEmpty() && splitted.getLast().getScope().equals(r1a.getScope())) {
            r1a = null;
        } else {
            splitted.add(r1a);
        }
        return new AgentXRegion(r2.getUpperBound(), r1.getUpperBound());
    }

    private static void oldRegionCoversNew(AgentXRegEntry<?> registration, AgentXNode node, List<AgentXNode> splitted, AgentXRegion r1, AgentXRegion r2) {
        AgentXRegion r = new AgentXRegion(r1.getUpperBound(), node.getScope().getUpperBound());
        AgentXNode r2c = node.getClone(r);
        if (r2.getLowerBound().equals(r1.getLowerBound())) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Shrinking node " + String.valueOf(node) + " to " + String.valueOf(r1.getUpperBound()))));
            }
            node.shrink(r1.getUpperBound());
            node.addRegistration(registration);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Serializable)((Object)("Shrinking node " + String.valueOf(node) + " to " + String.valueOf(r1.getLowerBound()))));
            }
            node.shrink(r1.getLowerBound());
            AgentXNode r2b = node.getClone(r1);
            r2b.addRegistration(registration);
            splitted.add(r2b);
        }
        splitted.add(r2c);
    }

    public <A extends Address> AgentXResponsePDU openSession(AgentXOpenPDU pdu, AgentXCommandEvent<A> event) {
        AgentXMasterSession<A> session = new AgentXMasterSession<A>(this.getNextSessionID(), this.agentXQueue, pdu.getSubagentID(), pdu.getSubagentDescr());
        AgentXPeer<A> peer = this.getPeer(event.getPeerAddress());
        if (peer == null) {
            peer = event.createAgentXPeer();
            this.addPeer(peer);
            LOGGER.warn((Serializable)((Object)("Added peer during session opening: " + String.valueOf(peer) + " (peer should have been there already due to connection setup)")));
        }
        session.setPeer(peer);
        session.setAgentXVersion(pdu.getVersion() & 0xFF);
        if (pdu.getTimeout() != 0) {
            session.setTimeout(pdu.getTimeout());
        } else {
            session.setTimeout(this.defaultTimeout);
        }
        int sessionAccepted = this.acceptSession(session);
        if (sessionAccepted == 0) {
            this.addSession(session);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Session " + String.valueOf(session) + " opened from " + String.valueOf(peer.getAddress()));
            }
        } else {
            LOGGER.warn((Serializable)((Object)("Session open rejected because " + sessionAccepted + " for " + String.valueOf(session) + " from " + String.valueOf(event.getPeerAddress()))));
        }
        AgentXResponsePDU response = this.createResponse(pdu, session);
        response.setErrorStatus((short)sessionAccepted);
        return response;
    }

    protected synchronized void addPeer(AgentXPeer<?> peer) {
        this.peers.put((Address)peer.getAddress(), peer);
        this.fireMasterChanged(new AgentXMasterEvent(this, 1, peer));
    }

    protected synchronized <A extends Address> AgentXPeer<A> getPeer(A address) {
        AgentXPeer<?> foundPeer = this.peers.get(address);
        if (address.equals(foundPeer.getAddress())) {
            return foundPeer;
        }
        return null;
    }

    protected int acceptSession(AgentXMasterSession<?> session) {
        AgentXMasterEvent event = new AgentXMasterEvent(this, 3, session);
        this.fireMasterChanged(event);
        return event.getVetoReason();
    }

    protected synchronized void addSession(AgentXMasterSession<?> session) {
        this.sessions.put(session.getSessionID(), session);
        this.fireMasterChanged(new AgentXMasterEvent(this, 3, session));
    }

    protected synchronized AgentXMasterSession<?> removeSession(int sessionID) {
        AgentXMasterSession<?> session = this.sessions.remove(sessionID);
        if (session != null) {
            this.fireMasterChanged(new AgentXMasterEvent(this, 4, session));
        }
        return session;
    }

    protected AgentXResponsePDU createResponse(AgentXPDU request, AgentXSession<?> session) {
        OctetString reqContext;
        MOServer server;
        OctetString context = DEFAULT_CONTEXT;
        if (request instanceof AgentXContextPDU && (server = this.getServer(reqContext = ((AgentXContextPDU)request).getContext())) != null && server.isContextSupported(reqContext)) {
            context = reqContext;
        }
        AgentXResponsePDU response = new AgentXResponsePDU(this.getContextSysUpTime(context).toInt(), 0, 0);
        if (session == null) {
            response.setSessionID(request.getSessionID());
            response.setErrorStatus(257);
        } else {
            response.setSessionID(session.getSessionID());
        }
        response.setPacketID(request.getPacketID());
        response.setTransactionID(request.getTransactionID());
        response.setByteOrder(request.getByteOrder());
        return response;
    }

    protected <A extends Address> void sendResponse(AgentXPDU response, AgentXSession<A> session) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)("Sending AgentX response " + String.valueOf(response) + " to session " + String.valueOf(session))));
        }
        try {
            this.agentX.send(response, session.createAgentXTarget(), session.getPeer().getTransport());
        }
        catch (IOException ex) {
            if (LOGGER.isDebugEnabled()) {
                ex.printStackTrace();
            }
            LOGGER.error("Failed to send AgentX response " + String.valueOf(response) + " to session " + String.valueOf(session) + " because: " + ex.getMessage(), ex);
        }
    }

    @Override
    public synchronized void connectionStateChanged(TransportStateEvent change) {
        Address peerAddress = change.getPeerAddress();
        switch (change.getNewState()) {
            case 2: 
            case 3: 
            case 4: {
                AgentXPeer<?> removedPeer = this.removePeer(peerAddress);
                this.fireMasterChanged(new AgentXMasterEvent(this, 2, removedPeer));
                break;
            }
            default: {
                AgentXPeer<Address> newPeer = new AgentXPeer<Address>((ConnectionOrientedTransportMapping)change.getSource(), peerAddress);
                this.addPeer(newPeer);
            }
        }
    }

    protected synchronized AgentXPeer<?> removePeer(Address peerAddress) {
        AgentXPeer<?> peer = this.peers.remove(peerAddress);
        if (peer != null) {
            peer.setClosing(true);
            Iterator<AgentXMasterSession<?>> it = this.sessions.values().iterator();
            while (it.hasNext()) {
                AgentXMasterSession<?> session = it.next();
                if (!session.getPeer().equals(peer)) continue;
                it.remove();
                this.fireMasterChanged(new AgentXMasterEvent(this, 4, session));
                this.indexRegistry.release(session.getSessionID());
                this.removeAllRegistrations(session);
                session.setClosed(true);
                if (!(peer.getTransport() instanceof ConnectionOrientedTransportMapping)) continue;
                try {
                    peer.getTransport().close(peer.getAddress());
                }
                catch (IOException iox) {
                    LOGGER.warn((Serializable)((Object)("Caught exception while closing transport: " + iox.getMessage())));
                }
            }
        } else {
            LOGGER.warn((Serializable)((Object)("Tried to remove peer with address " + String.valueOf(peerAddress) + " which is not part of peer list: " + String.valueOf(this.peers))));
        }
        return peer;
    }

    protected synchronized AgentXPeer<?> closePeer(Address peerAddress, byte reason) {
        AgentXPeer<?> peer = this.peers.remove(peerAddress);
        if (peer != null) {
            peer.setClosing(true);
            HashMap s = new HashMap(this.sessions);
            for (AgentXMasterSession session : s.values()) {
                if (!session.getPeer().equals(peer)) continue;
                this.closeSession(session, reason);
                if (!(peer.getTransport() instanceof ConnectionOrientedTransportMapping)) continue;
                try {
                    peer.getTransport().close(peer.getAddress());
                }
                catch (IOException iox) {
                    LOGGER.warn((Serializable)((Object)("Caught exception while closing transport: " + iox.getMessage())));
                }
            }
        } else {
            LOGGER.warn((Serializable)((Object)("Tried to remove peer with address " + String.valueOf(peerAddress) + " which is not part of peer list: " + String.valueOf(this.peers))));
        }
        return peer;
    }

    public byte getAgentXVersion() {
        return 1;
    }

    public synchronized void addAgentXMasterListener(AgentXMasterListener l) {
        if (this.agentXMasterListeners == null) {
            this.agentXMasterListeners = new Vector<AgentXMasterListener>(2);
        }
        this.agentXMasterListeners.add(l);
    }

    public synchronized void removeAgentXMasterListener(AgentXMasterListener l) {
        if (this.agentXMasterListeners != null) {
            this.agentXMasterListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMasterChanged(AgentXMasterEvent event) {
        List<AgentXMasterListener> listenersFinalRef = this.agentXMasterListeners;
        if (listenersFinalRef != null) {
            ArrayList<AgentXMasterListener> listeners;
            List<AgentXMasterListener> list = listenersFinalRef;
            synchronized (list) {
                listeners = new ArrayList<AgentXMasterListener>(listenersFinalRef);
            }
            for (AgentXMasterListener listener : listeners) {
                try {
                    listener.masterChanged(event);
                }
                catch (RuntimeException ex) {
                    LOGGER.error("AgentXMasterListener " + String.valueOf(listener) + " threw exception on " + String.valueOf(event) + ": " + ex.getMessage(), ex);
                }
            }
        }
    }

    @Override
    public void onResponse(AgentXResponseEvent<?> event) {
        AgentXPending<?> p;
        AgentXResponsePDU pdu = event.getResponse();
        AgentXPending pending = (AgentXPending)event.getUserObject();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Serializable)((Object)("Processing AgentX response " + String.valueOf(pdu) + " for request " + String.valueOf(pending))));
        }
        if (pending.getRequest() != null && (p = this.agentXQueue.remove(pending.getAgentXPDU().getSessionID(), pending.getRequest().getTransactionID())) == null) {
            LOGGER.warn((Serializable)((Object)("Pending AgentX request not found (may be timed out already): Received AgentX response from " + String.valueOf(event.getPeerAddress()) + " for request " + String.valueOf(event.getUserObject()) + " does not match any pending request:" + String.valueOf(pdu))));
            return;
        }
        if (pdu == null && pending.getAgentXPDU().getType() != 2) {
            pending.getSession().incConsecutiveTimeouts();
            pending.getReferences().next().getStatus().setErrorStatus(5);
            if (pending.getSession().getConsecutiveTimeouts() > this.maxConsecutiveTimeouts) {
                this.closeSession(pending.getSession(), (byte)4);
            }
        }
        if (pdu != null) {
            pending.getSession().clearConsecutiveTimeouts();
        }
        if (pending.getRequest() != null) {
            MOServer server = this.getServer(pending.getRequest().getContext());
            if (this.requestList.contains(pending.getRequest())) {
                if (pdu != null) {
                    if (AgentXCommandProcessor.checkAgentXResponse(pdu, pending)) {
                        switch (pending.getAgentXPDU().getType()) {
                            case 5: {
                                this.processAgentXGetResponse(pending, pdu);
                                break;
                            }
                            case 6: {
                                this.processAgentXGetNextResponse(pending, pdu);
                                break;
                            }
                            case 7: {
                                this.processAgentXBulkResponse(pending, pdu);
                                break;
                            }
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                this.processAgentXSetResponse(pending, pdu);
                                break;
                            }
                            default: {
                                LOGGER.warn((Serializable)((Object)("Unhandled AgentX response " + String.valueOf(pdu))));
                                break;
                            }
                        }
                    } else {
                        LOGGER.warn((Serializable)((Object)("Invalid AgentX response " + String.valueOf(pdu) + " on request " + String.valueOf(pending))));
                    }
                }
                if (!pending.getRequest().isComplete()) {
                    this.reprocessRequest(server, pending.getRequest());
                }
                this.finalizeRequest((CommandResponderEvent)pending.getRequest().getSource(), pending.getRequest(), server);
            } else if (pending.getAgentXPDU().getType() == 2) {
                if (pdu != null) {
                    LOGGER.info("Subagent " + String.valueOf(event.getPeerAddress()) + " confirmed close, disconnection transport now");
                } else {
                    LOGGER.info("Subagent " + String.valueOf(event.getPeerAddress()) + " did not answered on session close, disconnection now");
                }
                AgentXPeer peer = pending.getSession().getPeer();
                if (peer != null) {
                    AgentXCommandProcessor.closePeer(peer);
                }
            } else {
                LOGGER.info("Received late response " + String.valueOf(pdu) + " on AgentX request: " + String.valueOf(pending));
                super.release(server, pending.getRequest());
            }
        }
    }

    protected void processAgentXGetResponse(AgentXPending<?> pending, AgentXResponsePDU pdu) {
        if (pdu.getErrorStatus() != 0) {
            AgentXCommandProcessor.processsErrorResponse(pending, pdu);
        } else {
            VariableBinding[] vbs = pdu.getVariableBindings();
            SubRequestIterator<SnmpRequest.SnmpSubRequest> subRequests = pending.getReferences();
            for (int i = 0; i < pending.getRequest().size() && subRequests.hasNext(); ++i) {
                SnmpSubRequest sreq = subRequests.next();
                sreq.getVariableBinding().setVariable(vbs[i].getVariable());
                sreq.getStatus().setPhaseComplete(true);
            }
        }
    }

    protected void processAgentXGetNextResponse(AgentXPending<?> pending, AgentXResponsePDU pdu) {
        if (pdu.getErrorStatus() != 0) {
            AgentXCommandProcessor.processsErrorResponse(pending, pdu);
        } else {
            this.processAgentXNextResponse(pending, pdu, pending.getRequest().size());
        }
    }

    protected void processAgentXSetResponse(AgentXPending<?> pending, AgentXResponsePDU pdu) {
        if (pdu.getErrorStatus() != 0) {
            AgentXCommandProcessor.processsErrorResponse(pending, pdu);
        } else {
            SubRequestIterator<SnmpRequest.SnmpSubRequest> it = pending.getReferences();
            while (it.hasNext()) {
                SubRequest sreq = it.next();
                sreq.getStatus().setPhaseComplete(true);
            }
        }
    }

    protected static class AgentXRegEntryComparator
    implements Comparator<AgentXRegEntry<?>> {
        protected AgentXRegEntryComparator() {
        }

        @Override
        public int compare(AgentXRegEntry<?> a, AgentXRegEntry<?> b2) {
            int c = a.getRegion().compareTo(b2.getRegion());
            if (c == 0) {
                c = a.getContext().compareTo(b2.getContext());
            }
            return c;
        }
    }
}

