/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.nio.file.Path;
import org.snmp4j.agent.mo.snmp.TDomainAddressFactoryImpl;
import org.snmp4j.agent.mo.snmp.TransportDomains;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.transport.unix.UnixDomainAddress;

public class AgentXTDomainAddressFactory
extends TDomainAddressFactoryImpl {
    private static final LogAdapter logger = LogFactory.getLogger(AgentXTDomainAddressFactory.class);

    @Override
    public Address createAddress(OID transportDomain, OctetString address) {
        if (TransportDomains.transportDomainLocal.equals(transportDomain)) {
            return new UnixDomainAddress(Path.of(address.toString(), new String[0]));
        }
        return super.createAddress(transportDomain, address);
    }

    @Override
    public boolean isValidAddress(OID transportDomain, OctetString address) {
        if (TransportDomains.transportDomainLocal.equals(transportDomain)) {
            new UnixDomainAddress(Path.of(address.toString(), new String[0])).isValid();
        }
        return super.isValidAddress(transportDomain, address);
    }

    @Override
    public OID[] getTransportDomain(Address address) {
        if (address instanceof UnixDomainAddress) {
            return new OID[]{TransportDomains.transportDomainLocal};
        }
        return super.getTransportDomain(address);
    }

    @Override
    public OctetString getAddress(Address address) {
        if (address instanceof UnixDomainAddress) {
            return new OctetString(address.toByteArray());
        }
        return super.getAddress(address);
    }
}

