/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.agentx.AgentXMessageHeader;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AssignableFromByteArray;
import org.snmp4j.smi.AssignableFromIntArray;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.MessageLength;
import org.snmp4j.transport.MessageLengthDecoder;

public class AgentXProtocol
implements MessageLengthDecoder {
    private static final LogAdapter logger = LogFactory.getLogger(AgentXProtocol.class);
    public static final byte VERSION_1_0 = 1;
    public static final byte REASON_OTHER = 1;
    public static final byte REASON_PARSE_ERROR = 2;
    public static final byte REASON_PROTOCOL_ERROR = 3;
    public static final byte REASON_TIMEOUTS = 4;
    public static final byte REASON_SHUTDOWN = 5;
    public static final byte REASON_BY_MANAGER = 6;
    public static final int AGENTX_OPEN_FAILED = 256;
    public static final int AGENTX_NOT_OPEN = 257;
    public static final int AGENTX_INDEX_WRONG_TYPE = 258;
    public static final int AGENTX_INDEX_ALREADY_ALLOCATED = 259;
    public static final int AGENTX_INDEX_NONE_AVAILABLE = 260;
    public static final int AGENTX_INDEX_NOT_ALLOCATED = 261;
    public static final int AGENTX_UNSUPPORTED_CONTEXT = 262;
    public static final int AGENTX_DUPLICATE_REGISTRATION = 263;
    public static final int AGENTX_UNKNOWN_REGISTRATION = 264;
    public static final int AGENTX_UNKNOWN_AGENTCAPS = 265;
    public static final int AGENTX_PARSE_ERROR = 266;
    public static final int AGENTX_REQUEST_DENIED = 267;
    public static final int AGENTX_PROCESSING_ERROR = 268;
    public static final int AGENTX_MAX_OID_LENGTH = 128;
    public static final int AGENTX_SUCCESS = 0;
    public static final int AGENTX_ERROR = -1;
    public static final int AGENTX_DISCONNECT = -5;
    public static final int AGENTX_BADVER = -10;
    public static final int AGENTX_TIMEOUT = -11;
    public static final int AGENTX_NOREG = -40;
    public static final int AGENTX_DUPMAP = -41;
    public static final int FLAG_ALLOCATE_INDEX = 0;
    public static final byte FLAG_INSTANCE_REGISTRATION = 1;
    public static final byte FLAG_NEW_INDEX = 2;
    public static final byte FLAG_ANY_INDEX = 4;
    public static final byte FLAG_NON_DEFAULT_CONTEXT = 8;
    public static final byte FLAG_NETWORK_BYTE_ORDER = 16;
    private static final OID INTERNET = new OID(new int[]{1, 3, 6, 1});
    private static final int IPADDRESS_OCTETS = 4;
    protected static final int AGENTX_INT_SIZE = 4;
    public static final int HEADER_LENGTH = 20;
    public static final int DEFAULT_TIMEOUT_SECONDS = 5;
    public static final int DEFAULT_MAX_CONSECUTIVE_TIMEOUTS = 3;
    public static final int DEFAULT_MAX_PARSE_ERRORS = -1;
    public static final int MAX_TIMEOUT_SECONDS = 255;
    public static final byte DEFAULT_PRIORITY = 127;
    private static boolean nonDefaultContextEnabled = true;

    public static void encodeOID(ByteBuffer buf, OID oid, boolean include) {
        if (oid == null) {
            buf.put(new byte[]{0, 0, 0, 0});
        } else {
            int startPos = 0;
            int size = oid.size();
            if (size > 128 || size < 0) {
                size = 128;
                logger.warn((Serializable)((Object)("Too long OID is trimmed to 128 sub-identifiers allowed by AgentX: " + String.valueOf(oid))));
            }
            if (size > INTERNET.size() && oid.startsWith(INTERNET)) {
                buf.put((byte)(size - (INTERNET.size() + 1)));
                buf.put((byte)oid.get(INTERNET.size()));
                startPos = INTERNET.size() + 1;
            } else {
                buf.put((byte)size);
                buf.put((byte)0);
            }
            if (include && size > 0) {
                buf.put((byte)1);
                buf.put((byte)0);
            } else {
                buf.put(new byte[]{0, 0});
            }
            for (int i = startPos; i < size; ++i) {
                buf.putInt(oid.get(i));
            }
        }
    }

    public static int getOIDLength(OID oid) {
        if (oid == null) {
            return 4;
        }
        int startPos = 0;
        int size = Math.min(oid.size(), 128);
        if (size > INTERNET.size() && oid.startsWith(INTERNET)) {
            startPos = INTERNET.size() + 1;
        }
        return 4 + 4 * (size - startPos);
    }

    public static int getOIDLength(int[] oid) {
        if (oid == null) {
            return 4;
        }
        int startPos = 0;
        int size = Math.min(oid.length, 128);
        if (size > INTERNET.size()) {
            boolean ok = true;
            for (int i = 0; ok && i < INTERNET.size(); ++i) {
                ok = oid[i] == INTERNET.get(i);
            }
            if (ok) {
                startPos = INTERNET.size() + 1;
            }
        }
        return 4 + 4 * (size - startPos);
    }

    public static boolean decodeOID(ByteBuffer buf, OID oid) {
        int size = Math.min(0xFF & buf.get(), 128);
        byte first = buf.get();
        int[] value = new int[size + (first != 0 ? INTERNET.size() + 1 : 0)];
        int startPos = 0;
        if (first != 0) {
            System.arraycopy(INTERNET.getValue(), 0, value, 0, INTERNET.size());
            value[AgentXProtocol.INTERNET.size()] = first;
            startPos = INTERNET.size() + 1;
        }
        boolean include = buf.get() != 0;
        buf.get();
        for (int i = 0; i < size; ++i) {
            value[startPos + i] = buf.getInt();
        }
        oid.setValue(value);
        return include;
    }

    public static void encodeVariableData(ByteBuffer buf, Variable v) {
        if (v == null) {
            return;
        }
        switch (v.getSyntax()) {
            case 65: 
            case 66: 
            case 67: {
                buf.putInt((int)(((AssignableFromLong)((Object)v)).toLong() & 0xFFFFFFFFL));
                break;
            }
            case 2: {
                buf.putInt(((AssignableFromInteger)((Object)v)).toInt());
                break;
            }
            case 70: {
                buf.putLong(((AssignableFromLong)((Object)v)).toLong());
                break;
            }
            case 4: 
            case 68: {
                AgentXProtocol.encodeOctetString(buf, (OctetString)v);
                break;
            }
            case 64: {
                AgentXProtocol.encodeOctetString(buf, new OctetString(((IpAddress)v).getInetAddress().getAddress()));
                break;
            }
            case 6: {
                AgentXProtocol.encodeOID(buf, (OID)v, false);
                break;
            }
        }
    }

    public static int getVariableDataLength(Variable v) {
        if (v == null) {
            return 0;
        }
        switch (v.getSyntax()) {
            case 2: 
            case 65: 
            case 66: 
            case 67: {
                return 4;
            }
            case 70: {
                return 8;
            }
            case 4: 
            case 68: {
                if (v instanceof OctetString) {
                    return AgentXProtocol.getOctetStringLength(((OctetString)v).length());
                }
                if (!(v instanceof AssignableFromByteArray)) break;
                return AgentXProtocol.getOctetStringLength(((AssignableFromByteArray)((Object)v)).toByteArray().length);
            }
            case 64: {
                return 8;
            }
            case 6: {
                return AgentXProtocol.getOIDLength(((AssignableFromIntArray)((Object)v)).toIntArray());
            }
        }
        return 0;
    }

    public static Variable decodeVariableData(ByteBuffer buf, int syntax) {
        switch (syntax) {
            case 66: {
                return new Gauge32((long)buf.getInt() & 0xFFFFFFFFL);
            }
            case 67: {
                return new TimeTicks((long)buf.getInt() & 0xFFFFFFFFL);
            }
            case 65: {
                return new Counter32((long)buf.getInt() & 0xFFFFFFFFL);
            }
            case 2: {
                return new Integer32(buf.getInt());
            }
            case 70: {
                return new Counter64(buf.getLong());
            }
            case 4: {
                return AgentXProtocol.decodeOctetString(buf);
            }
            case 68: {
                return new Opaque(AgentXProtocol.decodeOctetString(buf).getValue());
            }
            case 64: {
                byte[] addrBytes = AgentXProtocol.decodeOctetString(buf).getValue();
                if (addrBytes.length > 4) {
                    logger.warn((Serializable)((Object)("Subagent returned IpAddress with length " + addrBytes.length + " > 4 which violates AgentX protocol specification")));
                    byte[] fourBytes = new byte[4];
                    System.arraycopy(addrBytes, 0, fourBytes, 0, 4);
                    addrBytes = fourBytes;
                }
                InetAddress addr = null;
                try {
                    addr = InetAddress.getByAddress(addrBytes);
                }
                catch (UnknownHostException ex) {
                    logger.error("Failed to create IpAddress from address bytes  with length " + addrBytes.length + ", using default IpAddress instead", ex);
                    return new IpAddress();
                }
                return new IpAddress(addr);
            }
            case 6: {
                OID oid = new OID();
                AgentXProtocol.decodeOID(buf, oid);
                return oid;
            }
            case 128: 
            case 129: 
            case 130: {
                return new Null(syntax);
            }
            case 5: {
                return new Null();
            }
        }
        logger.error((Serializable)((Object)("Unknown AgentX variable syntax '" + syntax + "', using Null instead")));
        return new Null();
    }

    public static VariableBinding[] decodeVariableBindings(ByteBuffer buf) {
        ArrayList<VariableBinding> vbs = new ArrayList<VariableBinding>();
        while (buf.remaining() > 0) {
            int type = buf.getShort() & 0xFFFF;
            buf.getShort();
            OID oid = new OID();
            AgentXProtocol.decodeOID(buf, oid);
            Variable v = AgentXProtocol.decodeVariableData(buf, type);
            vbs.add(new VariableBinding(oid, v));
        }
        return vbs.toArray(new VariableBinding[0]);
    }

    public static void encodeVaribleBindings(ByteBuffer buf, VariableBinding[] vbs) {
        for (VariableBinding vb : vbs) {
            buf.putShort((short)vb.getSyntax());
            buf.put(new byte[]{0, 0});
            AgentXProtocol.encodeOID(buf, vb.getOid(), false);
            AgentXProtocol.encodeVariableData(buf, vb.getVariable());
        }
    }

    public static void encodeRanges(ByteBuffer buf, MOScope[] searchRanges) {
        for (MOScope searchRange : searchRanges) {
            AgentXProtocol.encodeOID(buf, searchRange.getLowerBound(), searchRange.isLowerIncluded());
            if (searchRange.isUpperIncluded()) {
                AgentXProtocol.encodeOID(buf, searchRange.getUpperBound().successor(), false);
                continue;
            }
            AgentXProtocol.encodeOID(buf, searchRange.getUpperBound(), false);
        }
    }

    public static int getOctetStringLength(int length) {
        int padding = 0;
        if (length % 4 > 0) {
            padding = 4 - length % 4;
        }
        return 4 + length + padding;
    }

    public static void encodeOctetString(ByteBuffer buf, OctetString os) {
        buf.putInt(os.length());
        buf.put(os.getValue());
        if (os.length() % 4 > 0) {
            for (int i = 0; i < 4 - os.length() % 4; ++i) {
                buf.put((byte)0);
            }
        }
    }

    public static OctetString decodeOctetString(ByteBuffer buf) {
        int size = buf.getInt();
        byte[] value = new byte[size];
        buf.get(value);
        if (size % 4 > 0) {
            for (int i = 0; i < 4 - size % 4; ++i) {
                buf.get();
            }
        }
        return new OctetString(value);
    }

    public static MOScope[] decodeRanges(ByteBuffer buf) {
        return AgentXProtocol.decodeRanges(buf, false);
    }

    public static MOScope[] decodeRanges(ByteBuffer buf, boolean lowerAlwaysIncluded) {
        ArrayList<DefaultMOScope> ranges = new ArrayList<DefaultMOScope>();
        while (buf.hasRemaining()) {
            OID lowerBound = new OID();
            boolean isLowerIncluded = lowerAlwaysIncluded | AgentXProtocol.decodeOID(buf, lowerBound);
            OID upperBound = new OID();
            AgentXProtocol.decodeOID(buf, upperBound);
            if (upperBound.size() == 0) {
                upperBound = null;
            }
            ranges.add(new DefaultMOScope(lowerBound, isLowerIncluded, upperBound, false));
        }
        return ranges.toArray(new MOScope[0]);
    }

    public static int getRangesLength(MOScope[] ranges) {
        int length = 0;
        for (MOScope range : ranges) {
            length += AgentXProtocol.getOIDLength(range.getLowerBound());
            if (range.isUpperIncluded()) {
                length += AgentXProtocol.getOIDLength(range.getUpperBound().successor());
                continue;
            }
            length += AgentXProtocol.getOIDLength(range.getUpperBound());
        }
        return length;
    }

    public static int getVariableBindingsLength(VariableBinding[] vbs) {
        int length = 0;
        for (VariableBinding vb : vbs) {
            length += 4 + AgentXProtocol.getOIDLength(vb.getOid()) + AgentXProtocol.getVariableDataLength(vb.getVariable());
        }
        return length;
    }

    @Override
    public int getMinHeaderLength() {
        return 20;
    }

    @Override
    public MessageLength getMessageLength(ByteBuffer buf) throws IOException {
        return AgentXProtocol.decodeHeader(buf);
    }

    public static AgentXMessageHeader decodeHeader(ByteBuffer buf) throws IOException {
        byte version = buf.get();
        if (version != 1) {
            throw new IOException("Unknown AgentX version: " + version);
        }
        byte type = buf.get();
        byte flags = buf.get();
        buf.get();
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        if ((flags & 0x10) != 0) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        }
        buf.order(byteOrder);
        int sessionID = buf.getInt();
        int transactionID = buf.getInt();
        int packetID = buf.getInt();
        int length = buf.getInt();
        return new AgentXMessageHeader(type, flags, sessionID, transactionID, packetID, length);
    }

    public static void setNonDefaultContextsEnabled(boolean enabled) {
        nonDefaultContextEnabled = enabled;
    }

    public static boolean isNonDefaultContextsEnabled() {
        return nonDefaultContextEnabled;
    }
}

