/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.agentx;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;

public class AgentXPeer<A extends Address>
implements Serializable {
    private static final long serialVersionUID = 8420653697945606497L;
    private final ConnectionOrientedTransportMapping<A> transport;
    private final A address;
    private long connectionTime;
    private int timeout;
    private Object id;
    private volatile boolean closing;
    private final AtomicInteger parseErrors = new AtomicInteger(0);

    public AgentXPeer(ConnectionOrientedTransportMapping<A> transport, A address) {
        this.transport = transport;
        this.address = address;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public long getConnectionTime() {
        return this.connectionTime;
    }

    public Object getId() {
        return this.id;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public long getTimeoutMillis() {
        return TimeUnit.SECONDS.toMillis(this.timeout);
    }

    public ConnectionOrientedTransportMapping<A> getTransport() {
        return this.transport;
    }

    public A getAddress() {
        return this.address;
    }

    public int getParseErrors() {
        return this.parseErrors.get();
    }

    public void incParseErrors() {
        this.parseErrors.addAndGet(1);
    }

    public void setClosing(boolean closing) {
        this.closing = closing;
    }

    public void setConnectionTime(long connectionTime) {
        this.connectionTime = connectionTime;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        return this.getClass().getName() + "[transport=" + String.valueOf(this.transport) + ",address=" + String.valueOf(this.address) + ",connectionTime=" + this.connectionTime + ",timeout=" + this.timeout + ",id=" + String.valueOf(this.id) + ",closing=" + this.closing + ",parseErrors=" + String.valueOf(this.parseErrors) + "]";
    }
}

