/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import java.io.PrintStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.LongIterator;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.ILeafNode;
import org.jetbrains.annotations.NotNull;

abstract class BaseLeafNode
implements ILeafNode {
    BaseLeafNode() {
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof INode && this.getKey().equals(((INode)obj).getKey());
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isDupLeaf() {
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    @Override
    public long getAddress() {
        return -1L;
    }

    @Override
    @NotNull
    public BTreeBase getTree() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public LongIterator addressIterator() {
        return LongIterator.EMPTY;
    }

    @Override
    public boolean isDup() {
        return false;
    }

    @Override
    public long getDupCount() {
        return 1L;
    }

    @Override
    public boolean valueExists(@NotNull ByteIterable value) {
        return this.compareValueTo(value) == 0;
    }

    @Override
    public int compareKeyTo(@NotNull ByteIterable iterable2) {
        return this.getKey().compareTo(iterable2);
    }

    @Override
    public int compareValueTo(@NotNull ByteIterable iterable2) {
        return this.getValue().compareTo(iterable2);
    }

    public String toString() {
        return "LN {key:" + this.getKey().toString() + "} @ " + this.getAddress();
    }

    @Override
    public void dump(PrintStream out, int level, Dumpable.ToString renderer) {
        BasePage.indent(out, level);
        out.println(renderer == null ? this.toString() : renderer.toString(this));
    }
}

