/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.FixedLengthByteIterable;
import jetbrains.exodus.log.BlockByteIterator;
import jetbrains.exodus.log.ByteIterableWithAddress;
import org.jetbrains.annotations.NotNull;

class LogAwareFixedLengthByteIterable
extends FixedLengthByteIterable {
    LogAwareFixedLengthByteIterable(@NotNull ByteIterableWithAddress source, int offset, int length) {
        super(source, offset, length);
    }

    @Override
    public int compareTo(@NotNull ByteIterable right) {
        return this.getSource().compareTo(this.offset, this.length, right);
    }

    @Override
    public ByteIterableWithAddress getSource() {
        return (ByteIterableWithAddress)super.getSource();
    }

    @Override
    protected ByteIterator getIterator() {
        if (this.length == 0) {
            return ByteIterable.EMPTY_ITERATOR;
        }
        ByteIterator bi = this.source.iterator();
        bi.skip(this.offset);
        return new LogAwareFixedLengthByteIterator(bi, this.length);
    }

    private static class LogAwareFixedLengthByteIterator
    extends ByteIterator
    implements BlockByteIterator {
        private final ByteIterator si;
        private int bytesToRead;

        LogAwareFixedLengthByteIterator(@NotNull ByteIterator si, int length) {
            this.si = si;
            this.bytesToRead = length;
        }

        @Override
        public boolean hasNext() {
            return this.bytesToRead > 0 && this.si.hasNext();
        }

        @Override
        public byte next() {
            --this.bytesToRead;
            return this.si.next();
        }

        @Override
        public long skip(long bytes) {
            long result = this.si.skip(Math.min(bytes, (long)this.bytesToRead));
            this.bytesToRead -= (int)result;
            return result;
        }

        @Override
        public int nextBytes(byte[] array, int off, int len) {
            int bytesToRead = Math.min(len, this.bytesToRead);
            if (this.si instanceof BlockByteIterator) {
                int result = ((BlockByteIterator)((Object)this.si)).nextBytes(array, off, bytesToRead);
                this.bytesToRead -= result;
                return result;
            }
            for (int i = 0; i < bytesToRead; ++i) {
                array[off + i] = this.next();
            }
            return bytesToRead;
        }
    }
}

