/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.exodus.crypto.EnvKryptKt;
import jetbrains.exodus.crypto.StreamCipher;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.DataCorruptionException;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogConfig;
import jetbrains.exodus.log.LogTip;
import org.jetbrains.annotations.NotNull;

public class BlockDataIterator
extends ByteIteratorWithAddress {
    private final Log log;
    private final Block block;
    private final byte[] lastPage;
    private final long lastPageAddress;
    private long position;
    private final long end;
    private final BufferedInputStream stream;
    private int lastPageCount;

    public BlockDataIterator(Log log, LogTip prevTip, Block block, long startAddress) {
        this.log = log;
        this.block = block;
        this.position = startAddress;
        this.end = block.getAddress() + block.length();
        this.lastPageAddress = log.getHighPageAddress(this.end);
        this.lastPage = new byte[log.getCachePageSize()];
        LogConfig config = log.getConfig();
        if (this.lastPageAddress == prevTip.pageAddress) {
            this.lastPageCount = prevTip.count;
            System.arraycopy(prevTip.bytes, 0, this.lastPage, 0, prevTip.count);
        }
        this.stream = new BufferedInputStream(new BlockStream(config, block, this.position), log.getCachePageSize());
    }

    @Override
    public boolean hasNext() {
        return this.position < this.end;
    }

    @Override
    public byte next() {
        if (this.position >= this.end) {
            DataCorruptionException.raise("DataIterator: no more bytes available", this.log, this.position);
        }
        try {
            byte[] result = new byte[1];
            if (this.stream.read(result, 0, 1) < 1) {
                DataCorruptionException.raise("DataIterator: no more bytes available", this.log, this.position);
            }
            ++this.position;
            return result[0];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long skip(long bytes) {
        try {
            long result;
            long skipped;
            for (result = 0L; result < bytes && (skipped = this.stream.skip(bytes - result)) > 0L; result += skipped) {
            }
            this.position += result;
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getAddress() {
        return this.position;
    }

    @Override
    public int getOffset() {
        return (int)(this.position - this.block.getAddress());
    }

    public byte[] getLastPage() {
        return this.lastPage;
    }

    public long getLastPageAddress() {
        return this.lastPageAddress;
    }

    public int getLastPageCount() {
        return this.lastPageCount;
    }

    private class BlockStream
    extends InputStream {
        @NotNull
        private final LogConfig config;
        private final Block block;
        private final boolean crypt;
        private long position;
        private StreamCipher cipher;

        BlockStream(LogConfig config, Block block, long position) {
            this.config = config;
            this.block = block;
            if (config.getCipherProvider() != null) {
                long skipped;
                long skip = position % 1024L;
                this.position = position - skip;
                this.crypt = true;
                this.cipher = this.makeCipher((int)(this.position - block.getAddress()));
                if (skip > 0L && (skipped = this.skipInternal(skip)) < skip) {
                    DataCorruptionException.raise("DataIterator: no more bytes available", BlockDataIterator.this.log, position - skipped);
                }
            } else {
                this.position = position;
                this.crypt = false;
            }
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long skip(long n) {
            if (n >= Integer.MAX_VALUE) {
                throw new UnsupportedOperationException();
            }
            byte[] skipped = new byte[(int)n];
            return this.read(skipped, 0, (int)n);
        }

        @Override
        public int read(@NotNull @NotNull byte @NotNull [] b2, int off, int len) {
            int readLength = this.block.read(b2, this.position - this.block.getAddress(), off, len);
            if (readLength > 0) {
                long nextPosition;
                if (this.crypt) {
                    int end = off + readLength;
                    long currentPosition = this.position;
                    for (int i = off; i < end; ++i) {
                        b2[i] = this.cipher.crypt(b2[i]);
                        this.checkCipher(++currentPosition);
                    }
                }
                if ((nextPosition = this.position + (long)readLength) > BlockDataIterator.this.lastPageAddress) {
                    int offset;
                    int skip;
                    if (this.position < BlockDataIterator.this.lastPageAddress) {
                        skip = (int)(BlockDataIterator.this.lastPageAddress - this.position);
                        offset = 0;
                    } else {
                        offset = (int)(this.position - BlockDataIterator.this.lastPageAddress);
                        skip = 0;
                    }
                    int length = Math.min(BlockDataIterator.this.lastPage.length - offset, readLength - skip);
                    System.arraycopy(b2, off + skip, BlockDataIterator.this.lastPage, offset, length);
                    BlockDataIterator.this.lastPageCount = BlockDataIterator.this.lastPageCount + length;
                }
                this.position = nextPosition;
            }
            return readLength;
        }

        private long skipInternal(long n) {
            int count = (int)n;
            byte[] skipped = new byte[count];
            int read2 = this.block.read(skipped, this.position - this.block.getAddress(), 0, count);
            for (int i = 0; i < read2; ++i) {
                this.cipher.crypt(skipped[i]);
            }
            this.position += (long)read2;
            return read2;
        }

        private void checkCipher(long position) {
            int offset = (int)(position - this.block.getAddress());
            if (offset % 1024 == 0) {
                this.cipher = this.makeCipher(offset);
            }
        }

        private StreamCipher makeCipher(Integer offset) {
            StreamCipher result = this.config.getCipherProvider().newCipher();
            long iv = this.config.getCipherBasicIV() + (this.block.getAddress() + (long)offset.intValue()) / 1024L;
            result.init(this.config.getCipherKey(), EnvKryptKt.asHashedIV(iv));
            return result;
        }

        @Override
        public void close() {
        }
    }
}

