/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Scanner;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.OutOfDiskSpaceException;
import jetbrains.exodus.system.JVMConstants;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010\u0007\u001a\u00020\u0012H\u0002J\u000e\u0010\u0007\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u0014\u001a\u0004\u0018\u00010\u0005J\u0006\u0010\u0015\u001a\u00020\u0012J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ljetbrains/exodus/io/LockingManager;", "", "dir", "Ljava/io/File;", "lockId", "", "(Ljava/io/File;Ljava/lang/String;)V", "lock", "Ljava/nio/channels/FileLock;", "lockFile", "Ljava/io/RandomAccessFile;", "usableSpace", "", "getUsableSpace", "()J", "close", "", "getLockFile", "", "timeout", "lockInfo", "release", "throwFailedToLock", "e", "Ljava/io/IOException;", "Companion", "xodus-environment"})
public final class LockingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File dir;
    @Nullable
    private final String lockId;
    @Nullable
    private RandomAccessFile lockFile;
    @Nullable
    private FileLock lock;
    @NotNull
    private static final String LOCK_FILE_NAME = "xd.lck";

    public LockingManager(@NotNull File dir, @Nullable String lockId) {
        Intrinsics.checkNotNullParameter(dir, "dir");
        this.dir = dir;
        this.lockId = lockId;
    }

    public final long getUsableSpace() {
        return this.dir.getUsableSpace();
    }

    public final boolean lock(long timeout) {
        long started = System.currentTimeMillis();
        do {
            if (this.lock()) {
                return true;
            }
            if (timeout <= 0L) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while (System.currentTimeMillis() - started < timeout);
        return false;
    }

    public final boolean release() {
        if (this.lockFile != null) {
            try {
                this.close();
                return true;
            }
            catch (IOException e) {
                throw new ExodusException("Failed to release lock file xd.lck", e);
            }
        }
        return false;
    }

    private final boolean lock() {
        if (this.lockFile != null) {
            return false;
        }
        try {
            RandomAccessFile lockFile;
            File lockFileHandle = this.getLockFile();
            this.lockFile = lockFile = new RandomAccessFile(lockFileHandle, "rw");
            FileChannel channel = lockFile.getChannel();
            this.lock = channel.tryLock();
            if (this.lock != null) {
                lockFile.setLength(0L);
                lockFile.writeBytes("Private property of Exodus: ");
                if (this.lockId == null) {
                    RuntimeMXBean bean;
                    if (!JVMConstants.getIS_ANDROID() && (bean = ManagementFactory.getRuntimeMXBean()) != null) {
                        lockFile.writeBytes(bean.getName());
                    }
                } else {
                    lockFile.writeBytes(String.valueOf(this.lockId));
                }
                lockFile.writeBytes("\n\n");
                StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
                Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "Throwable().stackTrace");
                for (StackTraceElement element : stackTraceElementArray) {
                    lockFile.writeBytes(Intrinsics.stringPlus(element.toString(), "\n"));
                }
                channel.force(false);
            }
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.throwFailedToLock(e);
        }
        catch (OverlappingFileLockException _) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.lock == null) {
            try {
                this.close();
            }
            catch (IOException e) {
                this.throwFailedToLock(e);
            }
        }
        return this.lockFile != null;
    }

    @Nullable
    public final String lockInfo() {
        try {
            Scanner $this$lockInfo_u24lambda_u2d0 = new Scanner(this.getLockFile()).useDelimiter("\\A");
            boolean bl = false;
            return $this$lockInfo_u24lambda_u2d0.hasNext() ? $this$lockInfo_u24lambda_u2d0.next() : null;
        }
        catch (IOException e) {
            throw new ExodusException("Failed to read contents of lock file xd.lck", e);
        }
    }

    private final File getLockFile() {
        return new File(this.dir, LOCK_FILE_NAME);
    }

    private final boolean throwFailedToLock(IOException e) {
        if (this.getUsableSpace() < 4096L) {
            throw new OutOfDiskSpaceException(e);
        }
        throw new ExodusException("Failed to lock file xd.lck", e);
    }

    private final void close() {
        FileLock fileLock = this.lock;
        if (fileLock != null) {
            fileLock.release();
        }
        RandomAccessFile randomAccessFile = this.lockFile;
        if (randomAccessFile != null) {
            RandomAccessFile randomAccessFile2;
            RandomAccessFile $this$close_u24lambda_u2d1 = randomAccessFile2 = randomAccessFile;
            boolean bl = false;
            $this$close_u24lambda_u2d1.close();
            this.lockFile = null;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/exodus/io/LockingManager$Companion;", "", "()V", "LOCK_FILE_NAME", "", "xodus-environment"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

