/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.concurrent.TimeUnit;
import jetbrains.exodus.AbstractConfig;
import jetbrains.exodus.ConfigurationStrategy;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.InvalidSettingException;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.crypto.KryptKt;
import jetbrains.exodus.entitystore.MetaServer;
import jetbrains.exodus.system.JVMConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentConfig
extends AbstractConfig {
    public static final EnvironmentConfig DEFAULT = new EnvironmentConfig(ConfigurationStrategy.IGNORE){

        @Override
        public EnvironmentConfig setMutable(boolean isMutable) {
            if (!this.isMutable() && isMutable) {
                throw new ExodusException("Can't make EnvironmentConfig.DEFAULT mutable");
            }
            return super.setMutable(isMutable);
        }
    }.setMutable(false);
    public static final String MEMORY_USAGE = "exodus.memoryUsage";
    public static final String MEMORY_USAGE_PERCENTAGE = "exodus.memoryUsagePercentage";
    public static final String USE_VERSION1_FORMAT = "exodus.useVersion1Format";
    public static final String CIPHER_ID = "exodus.cipherId";
    public static final String CIPHER_KEY = "exodus.cipherKey";
    public static final String CIPHER_BASIC_IV = "exodus.cipherBasicIV";
    public static final String PROFILER_ENABLED = "exodus.profiler.enabled";
    public static final String LOG_DURABLE_WRITE = "exodus.log.durableWrite";
    public static final String LOG_FILE_SIZE = "exodus.log.fileSize";
    public static final String LOG_LOCK_TIMEOUT = "exodus.log.lockTimeout";
    public static final String LOG_LOCK_ID = "exodus.log.lockID";
    public static final String LOG_CACHE_PAGE_SIZE = "exodus.log.cache.pageSize";
    public static final String LOG_CACHE_OPEN_FILES = "exodus.log.cache.openFilesCount";
    public static final String LOG_CACHE_USE_NIO = "exodus.log.cache.useNIO";
    public static final String LOG_CACHE_FREE_PHYSICAL_MEMORY_THRESHOLD = "exodus.log.cache.freePhysicalMemoryThreshold";
    public static final String LOG_CACHE_SHARED = "exodus.log.cache.shared";
    public static final String LOG_CACHE_NON_BLOCKING = "exodus.log.cache.nonBlocking";
    public static final String LOG_CACHE_GENERATION_COUNT = "exodus.log.cache.generationCount";
    public static final String LOG_CACHE_USE_SOFT_REFERENCES = "exodus.log.cache.useSoftReferences";
    public static final String LOG_CACHE_READ_AHEAD_MULTIPLE = "exodus.log.cache.readAheadMultiple";
    public static final String LOG_CACHE_WARMUP = "exodus.log.cache.warmup";
    public static final String LOG_CLEAN_DIRECTORY_EXPECTED = "exodus.log.cleanDirectoryExpected";
    public static final String LOG_CLEAR_INVALID = "exodus.log.clearInvalid";
    public static final String LOG_SYNC_PERIOD = "exodus.log.syncPeriod";
    public static final String LOG_FULL_FILE_READ_ONLY = "exodus.log.fullFileReadonly";
    public static final String LOG_ALLOW_REMOVABLE = "exodus.log.allowRemovable";
    public static final String LOG_ALLOW_REMOTE = "exodus.log.allowRemote";
    public static final String LOG_ALLOW_RAM_DISK = "exodus.log.allowRamDisk";
    public static final String LOG_DATA_READER_WRITER_PROVIDER = "exodus.log.readerWriterProvider";
    public static final String ENV_IS_READONLY = "exodus.env.isReadonly";
    public static final String ENV_FAIL_FAST_IN_READONLY = "exodus.env.failFastInReadonly";
    public static final String ENV_READONLY_EMPTY_STORES = "exodus.env.readonly.emptyStores";
    public static final String ENV_STOREGET_CACHE_SIZE = "exodus.env.storeGetCacheSize";
    public static final String ENV_STOREGET_CACHE_MIN_TREE_SIZE = "exodus.env.storeGetCache.minTreeSize";
    public static final String ENV_STOREGET_CACHE_MAX_VALUE_SIZE = "exodus.env.storeGetCache.maxValueSize";
    public static final String ENV_CLOSE_FORCEDLY = "exodus.env.closeForcedly";
    public static final String ENV_TXN_REPLAY_TIMEOUT = "exodus.env.txn.replayTimeout";
    public static final String ENV_TXN_REPLAY_MAX_COUNT = "exodus.env.txn.replayMaxCount";
    public static final String ENV_TXN_DOWNGRADE_AFTER_FLUSH = "exodus.env.txn.downgradeAfterFlush";
    public static final String ENV_TXN_SINGLE_THREAD_WRITES = "exodus.env.txn.singleThreadWrites";
    public static final String ENV_TXN_TRACE_FINISH = "exodus.env.txn.traceFinish";
    public static final String ENV_MAX_PARALLEL_TXNS = "exodus.env.maxParallelTxns";
    @Deprecated
    public static final String ENV_MAX_PARALLEL_READONLY_TXNS = "exodus.env.maxParallelReadonlyTxns";
    public static final String ENV_MONITOR_TXNS_TIMEOUT = "exodus.env.monitorTxns.timeout";
    public static final String ENV_MONITOR_TXNS_EXPIRATION_TIMEOUT = "exodus.env.monitorTxns.expirationTimeout";
    public static final String ENV_MONITOR_TXNS_CHECK_FREQ = "exodus.env.monitorTxns.checkFreq";
    public static final String ENV_GATHER_STATISTICS = "exodus.env.gatherStatistics";
    public static final String ENV_COMPACT_ON_OPEN = "exodus.env.compactOnOpen";
    public static final String TREE_MAX_PAGE_SIZE = "exodus.tree.maxPageSize";
    public static final String TREE_DUP_MAX_PAGE_SIZE = "exodus.tree.dupMaxPageSize";
    @Deprecated
    public static final String TREE_NODES_CACHE_SIZE = "exodus.tree.nodesCacheSize";
    public static final String GC_ENABLED = "exodus.gc.enabled";
    public static final String GC_START_IN = "exodus.gc.startIn";
    public static final String GC_MIN_UTILIZATION = "exodus.gc.minUtilization";
    public static final String GC_RENAME_FILES = "exodus.gc.renameFiles";
    @Deprecated
    public static final String GC_USE_EXPIRATION_CHECKER = "exodus.gc.useExpirationChecker";
    public static final String GC_MIN_FILE_AGE = "exodus.gc.fileMinAge";
    @Deprecated
    public static final String GC_FILES_INTERVAL = "exodus.gc.filesInterval";
    public static final String GC_RUN_PERIOD = "exodus.gc.runPeriod";
    public static final String GC_UTILIZATION_FROM_SCRATCH = "exodus.gc.utilization.fromScratch";
    public static final String GC_UTILIZATION_FROM_FILE = "exodus.gc.utilization.fromFile";
    public static final String GC_USE_EXCLUSIVE_TRANSACTION = "exodus.gc.useExclusiveTransaction";
    public static final String GC_TRANSACTION_ACQUIRE_TIMEOUT = "exodus.gc.transactionAcquireTimeout";
    public static final String GC_TRANSACTION_TIMEOUT = "exodus.gc.transactionTimeout";
    public static final String GC_FILES_DELETION_DELAY = "exodus.gc.filesDeletionDelay";
    public static final String GC_RUN_EVERY = "exodus.gc.runEvery";
    public static final String MANAGEMENT_ENABLED = "exodus.managementEnabled";
    public static final String MANAGEMENT_OPERATIONS_RESTRICTED = "exodus.management.operationsRestricted";
    public static final String META_SERVER = "exodus.env.metaServer";

    public EnvironmentConfig() {
        this(ConfigurationStrategy.SYSTEM_PROPERTY);
    }

    public EnvironmentConfig(@NotNull ConfigurationStrategy strategy) {
        super(new Pair[]{new Pair<String, Integer>(MEMORY_USAGE_PERCENTAGE, 50), new Pair<String, Boolean>(USE_VERSION1_FORMAT, true), new Pair<String, Object>(CIPHER_ID, null), new Pair<String, Object>(CIPHER_KEY, null), new Pair<String, Long>(CIPHER_BASIC_IV, 0L), new Pair<String, Boolean>(PROFILER_ENABLED, false), new Pair<String, Boolean>(LOG_DURABLE_WRITE, false), new Pair<String, Long>(LOG_FILE_SIZE, 8192L), new Pair<String, Long>(LOG_LOCK_TIMEOUT, 0L), new Pair<String, Object>(LOG_LOCK_ID, null), new Pair<String, Integer>(LOG_CACHE_PAGE_SIZE, 65536), new Pair<String, Integer>(LOG_CACHE_OPEN_FILES, 500), new Pair<String, Boolean>(LOG_CACHE_USE_NIO, false), new Pair<String, Long>(LOG_CACHE_FREE_PHYSICAL_MEMORY_THRESHOLD, 1000000000L), new Pair<String, Boolean>(LOG_CACHE_SHARED, true), new Pair<String, Boolean>(LOG_CACHE_NON_BLOCKING, true), new Pair<String, Integer>(LOG_CACHE_GENERATION_COUNT, 2), new Pair<String, Boolean>(LOG_CACHE_USE_SOFT_REFERENCES, false), new Pair<String, Integer>(LOG_CACHE_READ_AHEAD_MULTIPLE, 1), new Pair<String, Boolean>(LOG_CACHE_WARMUP, false), new Pair<String, Boolean>(LOG_CLEAN_DIRECTORY_EXPECTED, false), new Pair<String, Boolean>(LOG_CLEAR_INVALID, false), new Pair<String, Long>(LOG_SYNC_PERIOD, 10000L), new Pair<String, Boolean>(LOG_FULL_FILE_READ_ONLY, true), new Pair<String, Boolean>(LOG_ALLOW_REMOVABLE, false), new Pair<String, Boolean>(LOG_ALLOW_REMOTE, false), new Pair<String, Boolean>(LOG_ALLOW_RAM_DISK, false), new Pair<String, String>(LOG_DATA_READER_WRITER_PROVIDER, "jetbrains.exodus.io.FileDataReaderWriterProvider"), new Pair<String, Boolean>(ENV_IS_READONLY, false), new Pair<String, Boolean>(ENV_FAIL_FAST_IN_READONLY, true), new Pair<String, Boolean>(ENV_READONLY_EMPTY_STORES, false), new Pair<String, Integer>(ENV_STOREGET_CACHE_SIZE, 0), new Pair<String, Integer>(ENV_STOREGET_CACHE_MIN_TREE_SIZE, 200), new Pair<String, Integer>(ENV_STOREGET_CACHE_MAX_VALUE_SIZE, 200), new Pair<String, Boolean>(ENV_CLOSE_FORCEDLY, false), new Pair<String, Long>(ENV_TXN_REPLAY_TIMEOUT, 2000L), new Pair<String, Integer>(ENV_TXN_REPLAY_MAX_COUNT, 2), new Pair<String, Boolean>(ENV_TXN_DOWNGRADE_AFTER_FLUSH, true), new Pair<String, Boolean>(ENV_TXN_SINGLE_THREAD_WRITES, false), new Pair<String, Boolean>(ENV_TXN_TRACE_FINISH, false), new Pair<String, Integer>(ENV_MAX_PARALLEL_TXNS, Integer.MAX_VALUE), new Pair<String, Integer>(ENV_MONITOR_TXNS_TIMEOUT, 0), new Pair<String, Integer>(ENV_MONITOR_TXNS_EXPIRATION_TIMEOUT, (int)TimeUnit.HOURS.toMillis(8L)), new Pair<String, Integer>(ENV_MONITOR_TXNS_CHECK_FREQ, 60000), new Pair<String, Boolean>(ENV_GATHER_STATISTICS, true), new Pair<String, Boolean>(ENV_COMPACT_ON_OPEN, false), new Pair<String, Integer>(TREE_MAX_PAGE_SIZE, 128), new Pair<String, Integer>(TREE_DUP_MAX_PAGE_SIZE, 8), new Pair<String, Boolean>(GC_ENABLED, true), new Pair<String, Integer>(GC_START_IN, 10000), new Pair<String, Integer>(GC_MIN_UTILIZATION, 50), new Pair<String, Boolean>(GC_RENAME_FILES, false), new Pair<String, Integer>(GC_MIN_FILE_AGE, 2), new Pair<String, Integer>(GC_FILES_INTERVAL, 3), new Pair<String, Integer>(GC_RUN_PERIOD, 5000), new Pair<String, Boolean>(GC_UTILIZATION_FROM_SCRATCH, false), new Pair<String, String>(GC_UTILIZATION_FROM_FILE, ""), new Pair<String, Integer>(GC_FILES_DELETION_DELAY, 5000), new Pair<String, Integer>(GC_RUN_EVERY, 0), new Pair<String, Boolean>(GC_USE_EXCLUSIVE_TRANSACTION, true), new Pair<String, Integer>(GC_TRANSACTION_ACQUIRE_TIMEOUT, 1000), new Pair<String, Integer>(GC_TRANSACTION_TIMEOUT, 500), new Pair<String, Boolean>(MANAGEMENT_ENABLED, !JVMConstants.getIS_ANDROID()), new Pair<String, Boolean>(MANAGEMENT_OPERATIONS_RESTRICTED, true), new Pair<String, Object>(META_SERVER, null)}, strategy);
    }

    @Override
    public EnvironmentConfig setSetting(@NotNull String key, @NotNull Object value) {
        return (EnvironmentConfig)super.setSetting(key, value);
    }

    @Override
    public EnvironmentConfig setMutable(boolean isMutable) {
        return (EnvironmentConfig)super.setMutable(isMutable);
    }

    public Long getMemoryUsage() {
        return (Long)this.getSetting(MEMORY_USAGE);
    }

    public EnvironmentConfig setMemoryUsage(long maxMemory) {
        return this.setSetting(MEMORY_USAGE, maxMemory);
    }

    public int getMemoryUsagePercentage() {
        return (Integer)this.getSetting(MEMORY_USAGE_PERCENTAGE);
    }

    public EnvironmentConfig setMemoryUsagePercentage(int memoryUsagePercentage) {
        return this.setSetting(MEMORY_USAGE_PERCENTAGE, memoryUsagePercentage);
    }

    public boolean getUseVersion1Format() {
        return (Boolean)this.getSetting(USE_VERSION1_FORMAT);
    }

    public EnvironmentConfig setUseVersion1Format(boolean useVersion1Format) {
        return this.setSetting(USE_VERSION1_FORMAT, useVersion1Format);
    }

    @Nullable
    public String getCipherId() {
        return (String)this.getSetting(CIPHER_ID);
    }

    public EnvironmentConfig setCipherId(String id) {
        return this.setSetting(CIPHER_ID, id);
    }

    @Nullable
    public byte[] getCipherKey() {
        Object cipherKey = this.getSetting(CIPHER_KEY);
        if (cipherKey instanceof String) {
            cipherKey = KryptKt.toBinaryKey((String)cipherKey);
            this.setSetting(CIPHER_KEY, cipherKey);
        }
        return (byte[])cipherKey;
    }

    public EnvironmentConfig setCipherKey(String cipherKey) {
        if (cipherKey == null) {
            return (EnvironmentConfig)this.removeSetting(CIPHER_KEY);
        }
        return this.setSetting(CIPHER_KEY, KryptKt.toBinaryKey(cipherKey));
    }

    public long getCipherBasicIV() {
        return (Long)this.getSetting(CIPHER_BASIC_IV);
    }

    public EnvironmentConfig setCipherBasicIV(long basicIV) {
        return this.setSetting(CIPHER_BASIC_IV, basicIV);
    }

    public boolean getProfilerEnabled() {
        return (Boolean)this.getSetting(PROFILER_ENABLED);
    }

    public EnvironmentConfig setProfilerEnabled(boolean enabled) {
        return this.setSetting(PROFILER_ENABLED, enabled);
    }

    public boolean getLogDurableWrite() {
        return (Boolean)this.getSetting(LOG_DURABLE_WRITE);
    }

    public EnvironmentConfig setLogDurableWrite(boolean durableWrite) {
        return this.setSetting(LOG_DURABLE_WRITE, durableWrite);
    }

    public long getLogFileSize() {
        return (Long)this.getSetting(LOG_FILE_SIZE);
    }

    public EnvironmentConfig setLogFileSize(long kilobytes) {
        return this.setSetting(LOG_FILE_SIZE, kilobytes);
    }

    public long getLogLockTimeout() {
        return (Long)this.getSetting(LOG_LOCK_TIMEOUT);
    }

    public EnvironmentConfig setLogLockId(String id) {
        return this.setSetting(LOG_LOCK_ID, id);
    }

    public EnvironmentConfig setLogLockTimeout(long millis) {
        return this.setSetting(LOG_LOCK_TIMEOUT, millis);
    }

    public String getLogLockId() {
        return (String)this.getSetting(LOG_LOCK_ID);
    }

    public int getLogCachePageSize() {
        return (Integer)this.getSetting(LOG_CACHE_PAGE_SIZE);
    }

    public EnvironmentConfig setLogCachePageSize(int bytes) {
        return this.setSetting(LOG_CACHE_PAGE_SIZE, bytes);
    }

    public int getLogCacheOpenFilesCount() {
        return (Integer)this.getSetting(LOG_CACHE_OPEN_FILES);
    }

    public EnvironmentConfig setLogCacheOpenFilesCount(int files) {
        return this.setSetting(LOG_CACHE_OPEN_FILES, files);
    }

    public boolean getLogCacheUseNio() {
        return (Boolean)this.getSetting(LOG_CACHE_USE_NIO);
    }

    public EnvironmentConfig setLogCacheUseNio(boolean useNio) {
        return this.setSetting(LOG_CACHE_USE_NIO, useNio);
    }

    public long getLogCacheFreePhysicalMemoryThreshold() {
        return (Long)this.getSetting(LOG_CACHE_FREE_PHYSICAL_MEMORY_THRESHOLD);
    }

    public EnvironmentConfig setLogCacheFreePhysicalMemoryThreshold(long freePhysicalMemoryThreshold) {
        return this.setSetting(LOG_CACHE_FREE_PHYSICAL_MEMORY_THRESHOLD, freePhysicalMemoryThreshold);
    }

    public boolean isLogCacheShared() {
        return (Boolean)this.getSetting(LOG_CACHE_SHARED);
    }

    public EnvironmentConfig setLogCacheShared(boolean shared) {
        return this.setSetting(LOG_CACHE_SHARED, shared);
    }

    public boolean isLogCacheNonBlocking() {
        return (Boolean)this.getSetting(LOG_CACHE_NON_BLOCKING);
    }

    public EnvironmentConfig setLogCacheNonBlocking(boolean nonBlocking) {
        return this.setSetting(LOG_CACHE_NON_BLOCKING, nonBlocking);
    }

    public int getLogCacheGenerationCount() {
        return (Integer)this.getSetting(LOG_CACHE_GENERATION_COUNT);
    }

    public EnvironmentConfig setLogCacheGenerationCount(int generationCount) {
        if (generationCount < 2) {
            throw new InvalidSettingException("LogCache generation count should greater than 1");
        }
        return this.setSetting(LOG_CACHE_GENERATION_COUNT, generationCount);
    }

    public boolean getLogCacheUseSoftReferences() {
        return (Boolean)this.getSetting(LOG_CACHE_USE_SOFT_REFERENCES);
    }

    public EnvironmentConfig setLogCacheUseSoftReferences(boolean useSoftReferences) {
        return this.setSetting(LOG_CACHE_USE_SOFT_REFERENCES, useSoftReferences);
    }

    public int getLogCacheReadAheadMultiple() {
        return (Integer)this.getSetting(LOG_CACHE_READ_AHEAD_MULTIPLE);
    }

    public EnvironmentConfig setLogCacheReadAheadMultiple(int readAheadMultiple) {
        if (readAheadMultiple < 1) {
            throw new InvalidSettingException("LogCache read ahead multiple should greater than 0");
        }
        return this.setSetting(LOG_CACHE_READ_AHEAD_MULTIPLE, readAheadMultiple);
    }

    public boolean getLogCacheWarmup() {
        return (Boolean)this.getSetting(LOG_CACHE_WARMUP);
    }

    public EnvironmentConfig setLogCacheWarmup(boolean warmup2) {
        return this.setSetting(LOG_CACHE_WARMUP, warmup2);
    }

    public boolean isLogCleanDirectoryExpected() {
        return (Boolean)this.getSetting(LOG_CLEAN_DIRECTORY_EXPECTED);
    }

    public EnvironmentConfig setLogCleanDirectoryExpected(boolean logCleanDirectoryExpected) {
        return this.setSetting(LOG_CLEAN_DIRECTORY_EXPECTED, logCleanDirectoryExpected);
    }

    public boolean isLogClearInvalid() {
        return (Boolean)this.getSetting(LOG_CLEAR_INVALID);
    }

    public EnvironmentConfig setLogClearInvalid(boolean logClearInvalid) {
        return this.setSetting(LOG_CLEAR_INVALID, logClearInvalid);
    }

    public long getLogSyncPeriod() {
        return (Long)this.getSetting(LOG_SYNC_PERIOD);
    }

    public EnvironmentConfig setLogSyncPeriod(long millis) {
        return this.setSetting(LOG_SYNC_PERIOD, millis);
    }

    public boolean isLogFullFileReadonly() {
        return (Boolean)this.getSetting(LOG_FULL_FILE_READ_ONLY);
    }

    public EnvironmentConfig setFullFileReadonly(boolean readonly) {
        return this.setSetting(LOG_FULL_FILE_READ_ONLY, readonly);
    }

    public boolean isLogAllowRemovable() {
        return (Boolean)this.getSetting(LOG_ALLOW_REMOVABLE);
    }

    public EnvironmentConfig setLogAllowRemovable(boolean allow) {
        return this.setSetting(LOG_ALLOW_REMOVABLE, allow);
    }

    public boolean isLogAllowRemote() {
        return (Boolean)this.getSetting(LOG_ALLOW_REMOTE);
    }

    public EnvironmentConfig setLogAllowRemote(boolean allow) {
        return this.setSetting(LOG_ALLOW_REMOTE, allow);
    }

    public boolean isLogAllowRamDisk() {
        return (Boolean)this.getSetting(LOG_ALLOW_RAM_DISK);
    }

    public EnvironmentConfig setLogAllowRamDisk(boolean allow) {
        return this.setSetting(LOG_ALLOW_RAM_DISK, allow);
    }

    public String getLogDataReaderWriterProvider() {
        return (String)this.getSetting(LOG_DATA_READER_WRITER_PROVIDER);
    }

    public EnvironmentConfig setLogDataReaderWriterProvider(@NotNull String provider) {
        return this.setSetting(LOG_DATA_READER_WRITER_PROVIDER, provider);
    }

    public boolean getEnvIsReadonly() {
        return (Boolean)this.getSetting(ENV_IS_READONLY);
    }

    public EnvironmentConfig setEnvIsReadonly(boolean isReadonly) {
        return this.setSetting(ENV_IS_READONLY, isReadonly);
    }

    public boolean getEnvFailFastInReadonly() {
        return (Boolean)this.getSetting(ENV_FAIL_FAST_IN_READONLY);
    }

    public EnvironmentConfig setEnvFailFastInReadonly(boolean failFast) {
        return this.setSetting(ENV_FAIL_FAST_IN_READONLY, failFast);
    }

    public boolean getEnvReadonlyEmptyStores() {
        return (Boolean)this.getSetting(ENV_READONLY_EMPTY_STORES);
    }

    public EnvironmentConfig setEnvReadonlyEmptyStores(boolean readonlyEmptyStores) {
        return this.setSetting(ENV_READONLY_EMPTY_STORES, readonlyEmptyStores);
    }

    public int getEnvStoreGetCacheSize() {
        return (Integer)this.getSetting(ENV_STOREGET_CACHE_SIZE);
    }

    public EnvironmentConfig setEnvStoreGetCacheSize(int storeGetCacheSize) {
        if (storeGetCacheSize < 0) {
            throw new InvalidSettingException("Negative StoreGetCache size");
        }
        return this.setSetting(ENV_STOREGET_CACHE_SIZE, storeGetCacheSize);
    }

    public int getEnvStoreGetCacheMinTreeSize() {
        return (Integer)this.getSetting(ENV_STOREGET_CACHE_MIN_TREE_SIZE);
    }

    public EnvironmentConfig setEnvStoreGetCacheMinTreeSize(int treeSize) {
        if (treeSize < 0) {
            throw new InvalidSettingException("Negative tree size");
        }
        return this.setSetting(ENV_STOREGET_CACHE_MIN_TREE_SIZE, treeSize);
    }

    public int getEnvStoreGetCacheMaxValueSize() {
        return (Integer)this.getSetting(ENV_STOREGET_CACHE_MAX_VALUE_SIZE);
    }

    public EnvironmentConfig setEnvStoreGetCacheMaxValueSize(int valueSize) {
        if (valueSize < 0) {
            throw new InvalidSettingException("Negative value size");
        }
        return this.setSetting(ENV_STOREGET_CACHE_MAX_VALUE_SIZE, valueSize);
    }

    public boolean getEnvCloseForcedly() {
        return (Boolean)this.getSetting(ENV_CLOSE_FORCEDLY);
    }

    public EnvironmentConfig setEnvCloseForcedly(boolean closeForcedly) {
        return this.setSetting(ENV_CLOSE_FORCEDLY, closeForcedly);
    }

    public long getEnvTxnReplayTimeout() {
        return (Long)this.getSetting(ENV_TXN_REPLAY_TIMEOUT);
    }

    public EnvironmentConfig setEnvTxnReplayTimeout(long timeout) {
        if (timeout < 0L) {
            throw new InvalidSettingException("Negative transaction replay timeout");
        }
        return this.setSetting(ENV_TXN_REPLAY_TIMEOUT, timeout);
    }

    public int getEnvTxnReplayMaxCount() {
        return (Integer)this.getSetting(ENV_TXN_REPLAY_MAX_COUNT);
    }

    public EnvironmentConfig setEnvTxnReplayMaxCount(int count) {
        if (count < 0) {
            throw new InvalidSettingException("Negative transaction replay count");
        }
        return this.setSetting(ENV_TXN_REPLAY_MAX_COUNT, count);
    }

    public boolean getEnvTxnDowngradeAfterFlush() {
        return (Boolean)this.getSetting(ENV_TXN_DOWNGRADE_AFTER_FLUSH);
    }

    public EnvironmentConfig setEnvTxnDowngradeAfterFlush(boolean downgrade) {
        return this.setSetting(ENV_TXN_DOWNGRADE_AFTER_FLUSH, downgrade);
    }

    public boolean getEnvTxnSingleThreadWrites() {
        return (Boolean)this.getSetting(ENV_TXN_SINGLE_THREAD_WRITES);
    }

    public EnvironmentConfig setEnvTxnSingleThreadWrites(boolean singleThreadWrites) {
        return this.setSetting(ENV_TXN_SINGLE_THREAD_WRITES, singleThreadWrites);
    }

    public boolean isEnvTxnTraceFinish() {
        return (Boolean)this.getSetting(ENV_TXN_TRACE_FINISH);
    }

    public EnvironmentConfig setEnvTxnTraceFinish(boolean traceFinish) {
        return this.setSetting(ENV_TXN_TRACE_FINISH, traceFinish);
    }

    public int getEnvMaxParallelTxns() {
        return (Integer)this.getSetting(ENV_MAX_PARALLEL_TXNS);
    }

    public EnvironmentConfig setEnvMaxParallelTxns(int maxParallelTxns) {
        return this.setSetting(ENV_MAX_PARALLEL_TXNS, maxParallelTxns);
    }

    @Deprecated
    public int getEnvMaxParallelReadonlyTxns() {
        return Integer.MAX_VALUE;
    }

    public EnvironmentConfig setEnvMaxParallelReadonlyTxns(int maxParallelReadonlyTxns) {
        return this;
    }

    public int getEnvMonitorTxnsTimeout() {
        return (Integer)this.getSetting(ENV_MONITOR_TXNS_TIMEOUT);
    }

    public EnvironmentConfig setEnvMonitorTxnsTimeout(int timeout) {
        if (timeout != 0 && timeout < 1000) {
            throw new InvalidSettingException("Transaction timeout should be greater than a second");
        }
        this.setSetting(ENV_MONITOR_TXNS_TIMEOUT, timeout);
        if (timeout > 0 && timeout < this.getEnvMonitorTxnsCheckFreq()) {
            this.setEnvMonitorTxnsCheckFreq(timeout);
        }
        return this;
    }

    public int getEnvMonitorTxnsExpirationTimeout() {
        return (Integer)this.getSetting(ENV_MONITOR_TXNS_EXPIRATION_TIMEOUT);
    }

    public EnvironmentConfig setEnvMonitorTxnsExpirationTimeout(int timeout) {
        if (timeout != 0 && timeout < 1000) {
            throw new InvalidSettingException("Transaction timeout should be greater than a second");
        }
        this.setSetting(ENV_MONITOR_TXNS_EXPIRATION_TIMEOUT, timeout);
        if (timeout > 0 && timeout < this.getEnvMonitorTxnsCheckFreq()) {
            this.setEnvMonitorTxnsCheckFreq(timeout);
        }
        return this;
    }

    public int getEnvMonitorTxnsCheckFreq() {
        return (Integer)this.getSetting(ENV_MONITOR_TXNS_CHECK_FREQ);
    }

    public EnvironmentConfig setEnvMonitorTxnsCheckFreq(int freq) {
        return this.setSetting(ENV_MONITOR_TXNS_CHECK_FREQ, freq);
    }

    public boolean getEnvGatherStatistics() {
        return (Boolean)this.getSetting(ENV_GATHER_STATISTICS);
    }

    public EnvironmentConfig setEnvGatherStatistics(boolean gatherStatistics) {
        return this.setSetting(ENV_GATHER_STATISTICS, gatherStatistics);
    }

    public boolean getEnvCompactOnOpen() {
        return (Boolean)this.getSetting(ENV_COMPACT_ON_OPEN);
    }

    public EnvironmentConfig setEnvCompactOnOpen(boolean compactOnOpen) {
        return this.setSetting(ENV_COMPACT_ON_OPEN, compactOnOpen);
    }

    public int getTreeMaxPageSize() {
        return (Integer)this.getSetting(TREE_MAX_PAGE_SIZE);
    }

    public EnvironmentConfig setTreeMaxPageSize(int pageSize) throws InvalidSettingException {
        if (pageSize < 16 || pageSize > 1024) {
            throw new InvalidSettingException("Invalid tree page size: " + pageSize);
        }
        return this.setSetting(TREE_MAX_PAGE_SIZE, pageSize);
    }

    public int getTreeDupMaxPageSize() {
        return (Integer)this.getSetting(TREE_DUP_MAX_PAGE_SIZE);
    }

    public EnvironmentConfig setTreeDupMaxPageSize(int pageSize) throws InvalidSettingException {
        if (pageSize < 8 || pageSize > 128) {
            throw new InvalidSettingException("Invalid dup tree page size: " + pageSize);
        }
        return this.setSetting(TREE_DUP_MAX_PAGE_SIZE, pageSize);
    }

    @Deprecated
    public int getTreeNodesCacheSize() {
        return 0;
    }

    @Deprecated
    public EnvironmentConfig setTreeNodesCacheSize(int cacheSize) {
        return this;
    }

    public boolean isGcEnabled() {
        return (Boolean)this.getSetting(GC_ENABLED);
    }

    public EnvironmentConfig setGcEnabled(boolean enabled) {
        return this.setSetting(GC_ENABLED, enabled);
    }

    public int getGcStartIn() {
        return (Integer)this.getSetting(GC_START_IN);
    }

    public EnvironmentConfig setGcStartIn(int startInMillis) throws InvalidSettingException {
        if (startInMillis < 0) {
            throw new InvalidSettingException("GC can't be postponed for that number of milliseconds: " + startInMillis);
        }
        return this.setSetting(GC_START_IN, startInMillis);
    }

    public int getGcMinUtilization() {
        return (Integer)this.getSetting(GC_MIN_UTILIZATION);
    }

    public EnvironmentConfig setGcMinUtilization(int percent) throws InvalidSettingException {
        if (percent < 1 || percent > 90) {
            throw new InvalidSettingException("Invalid minimum log files utilization: " + percent);
        }
        return this.setSetting(GC_MIN_UTILIZATION, percent);
    }

    public boolean getGcRenameFiles() {
        return (Boolean)this.getSetting(GC_RENAME_FILES);
    }

    public EnvironmentConfig setGcRenameFiles(boolean rename) {
        return this.setSetting(GC_RENAME_FILES, rename);
    }

    @Deprecated
    public boolean getGcUseExpirationChecker() {
        return false;
    }

    @Deprecated
    public EnvironmentConfig setGcUseExpirationChecker(boolean useExpirationChecker) {
        return this;
    }

    public int getGcFileMinAge() {
        return (Integer)this.getSetting(GC_MIN_FILE_AGE);
    }

    public EnvironmentConfig setGcFileMinAge(int minAge) throws InvalidSettingException {
        if (minAge < 1) {
            throw new InvalidSettingException("Invalid file minimum age: " + minAge);
        }
        return this.setSetting(GC_MIN_FILE_AGE, minAge);
    }

    @Deprecated
    public int getGcFilesInterval() {
        return (Integer)this.getSetting(GC_FILES_INTERVAL);
    }

    @Deprecated
    public EnvironmentConfig setGcFilesInterval(int files) throws InvalidSettingException {
        if (files < 1) {
            throw new InvalidSettingException("Invalid number of files: " + files);
        }
        return this.setSetting(GC_FILES_INTERVAL, files);
    }

    public int getGcRunPeriod() {
        return (Integer)this.getSetting(GC_RUN_PERIOD);
    }

    public EnvironmentConfig setGcRunPeriod(int runPeriod) throws InvalidSettingException {
        if (runPeriod < 0) {
            throw new InvalidSettingException("Invalid GC run period: " + runPeriod);
        }
        return this.setSetting(GC_RUN_PERIOD, runPeriod);
    }

    public boolean getGcUtilizationFromScratch() {
        return (Boolean)this.getSetting(GC_UTILIZATION_FROM_SCRATCH);
    }

    public EnvironmentConfig setGcUtilizationFromScratch(boolean fromScratch) {
        return this.setSetting(GC_UTILIZATION_FROM_SCRATCH, fromScratch);
    }

    public String getGcUtilizationFromFile() {
        return (String)this.getSetting(GC_UTILIZATION_FROM_FILE);
    }

    public EnvironmentConfig setGcUtilizationFromFile(String file) {
        return this.setSetting(GC_UTILIZATION_FROM_FILE, file);
    }

    public boolean getGcUseExclusiveTransaction() {
        return (Boolean)this.getSetting(GC_USE_EXCLUSIVE_TRANSACTION);
    }

    public EnvironmentConfig setGcUseExclusiveTransaction(boolean useExclusiveTransaction) {
        return this.setSetting(GC_USE_EXCLUSIVE_TRANSACTION, useExclusiveTransaction);
    }

    public int getGcTransactionAcquireTimeout() {
        return (Integer)this.getSetting(GC_TRANSACTION_ACQUIRE_TIMEOUT);
    }

    public EnvironmentConfig setGcTransactionAcquireTimeout(int txnAcquireTimeout) {
        return this.setSetting(GC_TRANSACTION_ACQUIRE_TIMEOUT, txnAcquireTimeout);
    }

    public int getGcTransactionTimeout() {
        return (Integer)this.getSetting(GC_TRANSACTION_TIMEOUT);
    }

    public EnvironmentConfig setGcTransactionTimeout(int txnTimeout) {
        return this.setSetting(GC_TRANSACTION_TIMEOUT, txnTimeout);
    }

    public int getGcFilesDeletionDelay() {
        return (Integer)this.getSetting(GC_FILES_DELETION_DELAY);
    }

    public EnvironmentConfig setGcFilesDeletionDelay(int delay) throws InvalidSettingException {
        if (delay < 0) {
            throw new InvalidSettingException("Invalid GC files deletion delay: " + delay);
        }
        return this.setSetting(GC_FILES_DELETION_DELAY, delay);
    }

    public int getGcRunEvery() {
        return (Integer)this.getSetting(GC_RUN_EVERY);
    }

    public EnvironmentConfig setGcRunEvery(int seconds) {
        if (seconds < 0) {
            throw new InvalidSettingException("Number of seconds must be non-negative: " + seconds);
        }
        return this.setSetting(GC_RUN_EVERY, seconds);
    }

    public boolean isManagementEnabled() {
        return (Boolean)this.getSetting(MANAGEMENT_ENABLED);
    }

    public EnvironmentConfig setManagementEnabled(boolean managementEnabled) {
        return this.setSetting(MANAGEMENT_ENABLED, managementEnabled && !JVMConstants.getIS_ANDROID());
    }

    public boolean getManagementOperationsRestricted() {
        return (Boolean)this.getSetting(MANAGEMENT_OPERATIONS_RESTRICTED);
    }

    public EnvironmentConfig setManagementOperationsRestricted(boolean operationsRestricted) {
        return this.setSetting(MANAGEMENT_OPERATIONS_RESTRICTED, operationsRestricted);
    }

    public EnvironmentConfig setMetaServer(MetaServer metaServer) {
        return this.setSetting(META_SERVER, metaServer);
    }

    public MetaServer getMetaServer() {
        return (MetaServer)this.getSetting(META_SERVER);
    }
}

