/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Objects;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.PropertyRangeOrValueIterableBase;
import jetbrains.exodus.entitystore.iterate.UpdatablePropertiesCachedInstanceIterable;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyRangeIterable
extends PropertyRangeOrValueIterableBase {
    @NotNull
    private final Comparable min;
    @NotNull
    private final Comparable max;

    public PropertyRangeIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int propertyId, @NotNull Comparable minValue, @NotNull Comparable maxValue) {
        super(txn, entityTypeId, propertyId);
        this.min = Objects.requireNonNull(PropertyTypes.toLowerCase(minValue));
        this.max = Objects.requireNonNull(PropertyTypes.toLowerCase(maxValue));
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    public boolean canBeReordered() {
        return true;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIterableBase it = this.getPropertyValueIndex();
        if (it.isCachedInstance()) {
            Class<?> minClass = this.min.getClass();
            Class<?> maxClass = this.max.getClass();
            UpdatablePropertiesCachedInstanceIterable cached = (UpdatablePropertiesCachedInstanceIterable)it;
            if (minClass != maxClass || minClass != cached.getPropertyValueClass()) {
                return EntityIteratorBase.EMPTY;
            }
            return cached.getPropertyRangeIterator(this.min, this.max);
        }
        Cursor valueIdx = this.openCursor(txn);
        if (valueIdx == null) {
            return EntityIteratorBase.EMPTY;
        }
        return new PropertyRangeIterator(valueIdx);
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        final int entityTypeId = this.getEntityTypeId();
        final int propertyId = this.getPropertyId();
        return new ConstantEntityIterableHandle(this.getStore(), PropertyRangeIterable.getType()){

            @Override
            @NotNull
            public int[] getPropertyIds() {
                return new int[]{propertyId};
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(entityTypeId);
                builder.append('-');
                builder.append(propertyId);
                builder.append('-');
                builder.append(PropertyRangeIterable.this.min.toString());
                builder.append('-');
                builder.append(PropertyRangeIterable.this.max.toString());
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(entityTypeId);
                hash.applyDelimiter();
                hash.apply(propertyId);
                hash.applyDelimiter();
                hash.apply(PropertyRangeIterable.this.min.toString());
                hash.applyDelimiter();
                hash.apply(PropertyRangeIterable.this.max.toString());
            }

            @Override
            public int getEntityTypeId() {
                return entityTypeId;
            }

            @Override
            public boolean isMatchedPropertyChanged(@NotNull EntityId id, int propId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
                return propertyId == propId && entityTypeId == id.getTypeId() && (this.isRangeAffected(oldValue) || this.isRangeAffected(newValue));
            }

            private boolean isRangeAffected(@Nullable Comparable value) {
                if (value == null) {
                    return false;
                }
                if (value instanceof ComparableSet) {
                    ComparableSet set = (ComparableSet)value;
                    return this.isRangeAffectedByPrimitiveValue((Comparable)set.getMinimum()) || this.isRangeAffectedByPrimitiveValue((Comparable)set.getMaximum());
                }
                return this.isRangeAffectedByPrimitiveValue(value);
            }

            private boolean isRangeAffectedByPrimitiveValue(@NotNull Comparable value) {
                Comparable lowercaseValue = PropertyTypes.toLowerCase(value);
                return PropertyRangeIterable.this.min.compareTo(lowercaseValue) <= 0 && PropertyRangeIterable.this.max.compareTo(lowercaseValue) >= 0;
            }
        };
    }

    private static EntityIterableType getType() {
        return EntityIterableType.ENTITIES_BY_PROP_VALUE_IN_RANGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        Cursor cursor = this.openCursor(txn);
        if (cursor == null) {
            return 0L;
        }
        try {
            boolean success;
            PropertyValue propertyValue = this.getStore().getPropertyTypes().dataToPropertyValue(this.min);
            ComparableBinding binding = propertyValue.getBinding();
            long result = 0L;
            boolean bl = success = cursor.getSearchKeyRange(propertyValue.dataToEntry()) != null;
            while (success && this.max.compareTo(binding.entryToObject(cursor.getKey())) >= 0) {
                result += (long)cursor.count();
                success = cursor.getNextNoDup();
            }
            long l = result;
            return l;
        }
        finally {
            cursor.close();
        }
    }

    static {
        PropertyRangeIterable.registerType(PropertyRangeIterable.getType(), (txn, store, parameters) -> {
            try {
                long min = Long.parseLong((String)parameters[2]);
                long max = Long.parseLong((String)parameters[3]);
                return new PropertyRangeIterable(txn, Integer.parseInt((String)parameters[0]), Integer.parseInt((String)parameters[1]), Long.valueOf(min), Long.valueOf(max));
            }
            catch (NumberFormatException e) {
                return new PropertyRangeIterable(txn, Integer.parseInt((String)parameters[0]), Integer.parseInt((String)parameters[1]), (Comparable)parameters[2], (Comparable)parameters[3]);
            }
        });
    }

    private final class PropertyRangeIterator
    extends EntityIteratorBase {
        private boolean hasNext;
        @NotNull
        private final ComparableBinding binding;

        private PropertyRangeIterator(Cursor cursor) {
            super(PropertyRangeIterable.this);
            this.setCursor(cursor);
            this.binding = this.getStore().getPropertyTypes().dataToPropertyValue(PropertyRangeIterable.this.min).getBinding();
            ArrayByteIterable key = this.binding.objectToEntry(PropertyRangeIterable.this.min);
            this.checkHasNext(this.getCursor().getSearchKeyRange(key) != null);
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                PropertyRangeIterable.this.explain(PropertyRangeIterable.getType());
                Cursor cursor = this.getCursor();
                PersistentEntityId result = new PersistentEntityId(PropertyRangeIterable.this.getEntityTypeId(), LongBinding.compressedEntryToLong(cursor.getValue()));
                this.checkHasNext(cursor.getNext());
                return result;
            }
            return null;
        }

        private void checkHasNext(boolean success) {
            this.hasNext = success && PropertyRangeIterable.this.max.compareTo(this.binding.entryToObject(this.getCursor().getKey())) >= 0;
        }
    }
}

