/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.ComparableValueType;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.IntHashSet;
import jetbrains.exodus.crypto.EncryptedBlobVault;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.entitystore.BlobHandleGenerator;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.BlobVaultItem;
import jetbrains.exodus.entitystore.CachedBlobLengths;
import jetbrains.exodus.entitystore.DiskBasedBlobVault;
import jetbrains.exodus.entitystore.DummyBlobVault;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableCache;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.EntityStoreSharedAsyncProcessor;
import jetbrains.exodus.entitystore.Explainer;
import jetbrains.exodus.entitystore.FileSystemBlobVault;
import jetbrains.exodus.entitystore.FileSystemBlobVaultOld;
import jetbrains.exodus.entitystore.FlushLog;
import jetbrains.exodus.entitystore.OpenTablesCache;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreBackupStrategy;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings;
import jetbrains.exodus.entitystore.PersistentEntityStoreSettingsListener;
import jetbrains.exodus.entitystore.PersistentEntityStoreStatistics;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import jetbrains.exodus.entitystore.PersistentSequence;
import jetbrains.exodus.entitystore.PersistentSequenceBlobHandleGenerator;
import jetbrains.exodus.entitystore.PersistentSequentialDictionary;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.PersistentStoreTransactionSnapshot;
import jetbrains.exodus.entitystore.PhantomLinkException;
import jetbrains.exodus.entitystore.ReadonlyPersistentStoreTransaction;
import jetbrains.exodus.entitystore.Settings;
import jetbrains.exodus.entitystore.StoreNamingRules;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalComputable;
import jetbrains.exodus.entitystore.StoreTransactionalExecutable;
import jetbrains.exodus.entitystore.TxnProvider;
import jetbrains.exodus.entitystore.UnexpectedBlobVaultVersionException;
import jetbrains.exodus.entitystore.VFSBlobVault;
import jetbrains.exodus.entitystore.iterate.EntityFromLinkSetIterable;
import jetbrains.exodus.entitystore.iterate.EntityFromLinksIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.management.EntityStoreConfig;
import jetbrains.exodus.entitystore.management.EntityStoreStatistics;
import jetbrains.exodus.entitystore.replication.PersistentEntityStoreReplicator;
import jetbrains.exodus.entitystore.tables.BitmapTable;
import jetbrains.exodus.entitystore.tables.BlobsTable;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.LinksTable;
import jetbrains.exodus.entitystore.tables.PropertiesTable;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.entitystore.tables.SingleColumnTable;
import jetbrains.exodus.entitystore.tables.TwoColumnTable;
import jetbrains.exodus.env.BitmapImpl;
import jetbrains.exodus.env.BitmapIterator;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.replication.EnvironmentReplicationDelta;
import jetbrains.exodus.io.DataReaderWriterProvider;
import jetbrains.exodus.io.WatchingFileDataReader;
import jetbrains.exodus.io.WatchingFileDataReaderWriterProvider;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.management.Statistics;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.exodus.util.UTFUtil;
import kotlin.Unit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentEntityStoreImpl
implements PersistentEntityStore,
FlushLog.Member {
    private static final Logger logger = LoggerFactory.getLogger(PersistentEntityStoreImpl.class);
    @NonNls
    private static final String BLOBS_DIR = "blobs";
    @NonNls
    static final String BLOBS_EXTENSION = ".blob";
    @NonNls
    static final String BLOB_HANDLES_SEQUENCE = "blob.handles.sequence";
    @NonNls
    private static final String SEQUENCES_STORE = "sequences";
    static final long BLOB_HANDLE_ADDEND = 16L;
    static final long EMPTY_BLOB_HANDLE = Long.MAX_VALUE;
    static final long IN_PLACE_BLOB_HANDLE = 0x7FFFFFFFFFFFFFFEL;
    static final long IN_PLACE_BLOB_REFERENCE_HANDLE = 0x7FFFFFFFFFFFFFFDL;
    @NotNull
    private static final ByteArrayInputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    private final int hashCode;
    @NotNull
    private final PersistentEntityStoreConfig config;
    @NotNull
    private final String name;
    @NotNull
    private final Environment environment;
    private boolean closeEnvironment;
    @NotNull
    private final DataReaderWriterProvider readerWriterProvider;
    @NotNull
    private final String location;
    @NotNull
    private final Map<Thread, Deque<PersistentStoreTransaction>> txns = new ConcurrentHashMap<Thread, Deque<PersistentStoreTransaction>>(4, 0.75f, 4);
    @NotNull
    private final StoreNamingRules namingRulez;
    private BlobVault blobVault;
    @NotNull
    private final Map<String, PersistentSequence> allSequences;
    @NotNull
    private final IntHashMap<PersistentSequence> entitiesSequences;
    private PersistentSequentialDictionary entityTypes;
    private PersistentSequentialDictionary propertyIds;
    private PersistentSequentialDictionary linkIds;
    @NotNull
    private final PropertyTypes propertyTypes;
    private PersistentSequentialDictionary propertyCustomTypeIds;
    private OpenTablesCache entitiesTables;
    private OpenTablesCache propertiesTables;
    OpenTablesCache linksTables;
    private OpenTablesCache blobsTables;
    private OpenTablesCache blobHashesTables;
    private Store blobFileLengths;
    private Store internalSettings;
    private Store sequences;
    @NotNull
    private final EntityIterableCache iterableCache;
    private final Explainer explainer;
    private final DataGetter propertyDataGetter;
    private final DataGetter linkDataGetter;
    private final DataGetter nonDebugLinkDataGetter = new LinkDataGetter();
    private final DataGetter blobDataGetter;
    @NotNull
    private final PersistentEntityStoreStatistics statistics;
    @Nullable
    private final EntityStoreConfig configMBean;
    @Nullable
    private final EntityStoreStatistics statisticsMBean;
    @NotNull
    private final PersistentEntityStoreSettingsListener entityStoreSettingsListener;
    @NotNull
    private final Set<TableCreationOperation> tableCreationLog = new HashSet<TableCreationOperation>();
    @NotNull
    private final TxnProvider txnProvider = this::getAndCheckCurrentTransaction;

    public PersistentEntityStoreImpl(@NotNull Environment environment, @NotNull String name) {
        this(environment, null, name);
    }

    public PersistentEntityStoreImpl(@NotNull Environment environment, @Nullable BlobVault blobVault, @NotNull String name) {
        this(new PersistentEntityStoreConfig(), environment, blobVault, name);
    }

    public PersistentEntityStoreImpl(@NotNull PersistentEntityStoreConfig config, @NotNull Environment environment, @Nullable BlobVault blobVault, @NotNull String name) {
        this.hashCode = System.identityHashCode(this);
        this.config = config;
        this.environment = environment;
        this.closeEnvironment = false;
        this.blobVault = blobVault;
        PersistentEntityStores.adjustEnvironmentConfigForEntityStore(environment.getEnvironmentConfig());
        this.name = name;
        this.location = environment.getLocation();
        this.readerWriterProvider = Objects.requireNonNull(((EnvironmentImpl)environment).getLog().getConfig().getReaderWriterProvider());
        if (this.readerWriterProvider.isInMemory()) {
            config.setMaxInPlaceBlobSize(Integer.MAX_VALUE);
        }
        if (this.readerWriterProvider.isReadonly()) {
            config.setCachingDisabled(true);
        }
        this.namingRulez = new StoreNamingRules(name);
        this.iterableCache = new EntityIterableCache(this);
        this.explainer = new Explainer(config.isExplainOn());
        this.propertyDataGetter = new PropertyDataGetter();
        this.linkDataGetter = config.isDebugLinkDataGetter() ? new DebugLinkDataGetter() : this.nonDebugLinkDataGetter;
        this.blobDataGetter = new BlobDataGetter();
        this.allSequences = new HashMap<String, PersistentSequence>();
        this.entitiesSequences = new IntHashMap();
        this.propertyTypes = new PropertyTypes();
        PersistentEntityStoreReplicator replicator = config.getStoreReplicator();
        if (replicator != null) {
            this.replicate(replicator, blobVault);
        }
        this.init();
        if (this.readerWriterProvider instanceof WatchingFileDataReaderWriterProvider) {
            ((WatchingFileDataReader)((EnvironmentImpl)environment).getLog().getConfig().getReader()).addNewDataListener((aLong, aLong2) -> {
                environment.executeInReadonlyTransaction((Transaction txn) -> {
                    this.entityTypes.invalidate(txn);
                    this.propertyIds.invalidate(txn);
                    this.linkIds.invalidate(txn);
                    this.propertyCustomTypeIds.invalidate(txn);
                });
                return Unit.INSTANCE;
            });
        }
        this.statistics = new PersistentEntityStoreStatistics(this);
        if (config.isManagementEnabled()) {
            this.configMBean = new EntityStoreConfig(this);
            this.statisticsMBean = config.getGatherStatistics() ? new EntityStoreStatistics(this) : null;
        } else {
            this.configMBean = null;
            this.statisticsMBean = null;
        }
        this.entityStoreSettingsListener = new PersistentEntityStoreSettingsListener(this);
        config.addChangedSettingsListener(this.entityStoreSettingsListener);
        PersistentEntityStoreImpl.loggerDebug("Created successfully.");
    }

    private void init() {
        boolean fromScratch = this.computeInTransaction(tx -> {
            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
            Transaction envTxn = txn.getEnvironmentTransaction();
            this.initBasicStores(envTxn);
            if (this.blobVault == null) {
                this.blobVault = this.initBlobVault();
            }
            TwoColumnTable entityTypesTable = new TwoColumnTable(txn, this.namingRulez.getEntityTypesTableName(), StoreConfig.WITHOUT_DUPLICATES);
            PersistentSequence entityTypesSequence = this.getSequence(txn, this.namingRulez.getEntityTypesSequenceName());
            this.entityTypes = new PersistentSequentialDictionary(entityTypesSequence, entityTypesTable){

                @Override
                protected void created(PersistentStoreTransaction txn, int id) {
                    PersistentEntityStoreImpl.this.preloadTables(txn, id);
                }
            };
            this.propertyIds = new PersistentSequentialDictionary(this.getSequence(txn, this.namingRulez.getPropertyIdsSequenceName()), new TwoColumnTable(txn, this.namingRulez.getPropertyIdsTableName(), StoreConfig.WITHOUT_DUPLICATES));
            this.linkIds = new PersistentSequentialDictionary(this.getSequence(txn, this.namingRulez.getLinkIdsSequenceName()), new TwoColumnTable(txn, this.namingRulez.getLinkIdsTableName(), StoreConfig.WITHOUT_DUPLICATES));
            this.propertyCustomTypeIds = new PersistentSequentialDictionary(this.getSequence(txn, this.namingRulez.getPropertyCustomTypesSequence()), new TwoColumnTable(txn, this.namingRulez.getPropertyCustomTypesTable(), StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING));
            this.entitiesTables = new OpenTablesCache((t, entityTypeId) -> {
                String entitiesTableName = this.namingRulez.getEntitiesTableName(entityTypeId);
                return this.useVersion1Format() ? new SingleColumnTable(t, entitiesTableName, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING) : new BitmapTable(t, entitiesTableName, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING);
            });
            this.propertiesTables = new OpenTablesCache((t, entityTypeId) -> new PropertiesTable(t, this.namingRulez.getPropertiesTableName(entityTypeId), StoreConfig.WITHOUT_DUPLICATES));
            this.linksTables = new OpenTablesCache((t, entityTypeId) -> new LinksTable(t, this.namingRulez.getLinksTableName(entityTypeId), StoreConfig.WITH_DUPLICATES_WITH_PREFIXING));
            this.blobsTables = new OpenTablesCache((t, entityTypeId) -> new BlobsTable(this, t, this.useVersion1Format() ? this.namingRulez.getBlobsObsoleteTableName(entityTypeId) : this.namingRulez.getBlobsTableName(entityTypeId), this.useVersion1Format() ? StoreConfig.WITHOUT_DUPLICATES : StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING));
            this.blobHashesTables = new OpenTablesCache((t, entityTypeId) -> new SingleColumnTable(t, this.namingRulez.getBlobHashesTableName(entityTypeId), StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING));
            String internalSettingsName = this.namingRulez.getInternalSettingsName();
            Store settings = this.environment.openStore(internalSettingsName, StoreConfig.WITHOUT_DUPLICATES, envTxn, false);
            boolean result = settings == null;
            this.internalSettings = result ? this.environment.openStore(internalSettingsName, StoreConfig.WITHOUT_DUPLICATES, envTxn, true) : settings;
            return result;
        });
        if (!this.config.getRefactoringSkipAll() && !this.environment.getEnvironmentConfig().getEnvIsReadonly()) {
            this.applyRefactorings(fromScratch);
        }
    }

    private void initBasicStores(Transaction envTxn) {
        this.sequences = this.environment.openStore(SEQUENCES_STORE, StoreConfig.WITHOUT_DUPLICATES, envTxn);
        this.blobFileLengths = this.environment.openStore(this.namingRulez.getBlobFileLengthsTable(), StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, envTxn);
    }

    private BlobVault initBlobVault() {
        PersistentEntityStoreReplicator replicator;
        FileSystemBlobVaultOld fsVault;
        if (this.readerWriterProvider.isInMemory()) {
            return new DummyBlobVault(this.config);
        }
        DiskBasedBlobVault result = fsVault = this.createDefaultFSBlobVault();
        StreamCipherProvider cipherProvider = this.environment.getCipherProvider();
        if (cipherProvider != null) {
            result = new EncryptedBlobVault(fsVault, cipherProvider, Objects.requireNonNull(this.environment.getCipherKey()), this.environment.getCipherBasicIV());
        }
        if ((replicator = this.config.getStoreReplicator()) != null) {
            result = replicator.decorateBlobVault(result, this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRefactorings(boolean fromScratch) {
        this.environment.suspendGC();
        try {
            PersistentEntityStoreRefactorings refactorings = new PersistentEntityStoreRefactorings(this);
            if (this.config.getRefactoringDeleteRedundantBlobs()) {
                refactorings.refactorDeleteRedundantBlobs();
            }
            if (!this.useVersion1Format() && (fromScratch || Settings.get(this.internalSettings, "refactorBlobsForVersion2Format() applied") == null)) {
                if (!fromScratch) {
                    refactorings.refactorBlobsToVersion2Format(this.internalSettings);
                }
                Settings.set(this.internalSettings, "refactorBlobsForVersion2Format() applied", "y");
            }
            if (!this.useVersion1Format() && (fromScratch || Settings.get(this.internalSettings, "refactorEntitiesTablesToBitmap() applied") == null)) {
                if (!fromScratch) {
                    refactorings.refactorEntitiesTablesToBitmap(this.internalSettings);
                }
                Settings.set(this.internalSettings, "refactorEntitiesTablesToBitmap() applied", "y");
            }
            if (!this.useVersion1Format() && this.useIntForLocalId() && (fromScratch || Settings.get(this.internalSettings, "refactorAllPropsIndexToBitmap() applied") == null)) {
                if (!fromScratch) {
                    refactorings.refactorAllPropsIndexToBitmap();
                }
                Settings.set(this.internalSettings, "refactorAllPropsIndexToBitmap() applied", "y");
            }
            if (!this.useVersion1Format() && this.useIntForLocalId() && (fromScratch || Settings.get(this.internalSettings, "refactorAllLinksIndexToBitmap() applied") == null)) {
                if (!fromScratch) {
                    refactorings.refactorAllLinksIndexToBitmap();
                }
                Settings.set(this.internalSettings, "refactorAllLinksIndexToBitmap() applied", "y");
            }
            if (!this.useVersion1Format() && this.useIntForLocalId() && (fromScratch || Settings.get(this.internalSettings, "refactorAllBlobsIndexToBitmap() applied") == null)) {
                if (!fromScratch) {
                    refactorings.refactorAllBlobsIndexToBitmap();
                }
                Settings.set(this.internalSettings, "refactorAllBlobsIndexToBitmap() applied", "y");
            }
            if (!fromScratch && !this.useVersion1Format()) {
                refactorings.refactorDeduplicateInPlaceBlobsPeriodically(this.internalSettings);
            }
            if (fromScratch || Settings.get(this.internalSettings, "Null-indices refactored") == null || this.config.getRefactoringNullIndices()) {
                if (!fromScratch) {
                    Settings.delete(this.internalSettings, "Null-indices present");
                    Settings.delete(this.internalSettings, "Null-indices present 2");
                    Settings.delete(this.internalSettings, "Null-indices present 3");
                    refactorings.refactorCreateNullPropertyIndices();
                }
                Settings.set(this.internalSettings, "Null-indices refactored", "yes");
            }
            if (fromScratch || Settings.get(this.internalSettings, "Blobs' null-indices present") == null || this.config.getRefactoringBlobNullIndices()) {
                if (!fromScratch) {
                    refactorings.refactorCreateNullBlobIndices();
                }
                Settings.set(this.internalSettings, "Blobs' null-indices present", "yes");
            }
            if (fromScratch || Settings.get(this.internalSettings, "refactorDropEmptyPrimaryLinkTables() applied") == null) {
                if (!fromScratch) {
                    refactorings.refactorDropEmptyPrimaryLinkTables();
                }
                Settings.set(this.internalSettings, "refactorDropEmptyPrimaryLinkTables() applied", "y");
            }
            if (fromScratch || Settings.get(this.internalSettings, "refactorMakeLinkTablesConsistent() applied") == null || this.config.getRefactoringHeavyLinks()) {
                if (!fromScratch) {
                    refactorings.refactorMakeLinkTablesConsistent(this.internalSettings);
                }
                Settings.set(this.internalSettings, "refactorMakeLinkTablesConsistent() applied", "y");
            }
            if (fromScratch || Settings.get(this.internalSettings, "refactorMakePropTablesConsistent() applied") == null || this.config.getRefactoringHeavyProps()) {
                if (!fromScratch) {
                    refactorings.refactorMakePropTablesConsistent();
                }
                Settings.set(this.internalSettings, "refactorMakePropTablesConsistent() applied", "y");
            }
            if (fromScratch || Settings.get(this.internalSettings, "refactorFixNegativeFloatAndDoubleProps() applied") == null) {
                if (!fromScratch) {
                    refactorings.refactorFixNegativeFloatAndDoubleProps(this.internalSettings);
                }
                Settings.set(this.internalSettings, "refactorFixNegativeFloatAndDoubleProps() applied", "y");
            }
            if (fromScratch || Settings.get(this.internalSettings, "Link null-indices present") == null) {
                if (!fromScratch) {
                    refactorings.refactorCreateNullLinkIndices();
                }
                Settings.set(this.internalSettings, "Link null-indices present", "y");
            }
            if (this.blobVault instanceof VFSBlobVault && new File(this.location, BLOBS_DIR).exists()) {
                try {
                    ((VFSBlobVault)this.blobVault).refactorFromFS(this);
                }
                catch (IOException e) {
                    throw ExodusException.toEntityStoreException(e);
                }
            }
            if (this.blobVault instanceof DiskBasedBlobVault && (fromScratch || Settings.get(this.internalSettings, "refactorBlobFileLengths() applied") == null)) {
                if (!fromScratch) {
                    Settings.delete(this.internalSettings, "Blob file lengths cached");
                    refactorings.refactorBlobFileLengths();
                }
                Settings.set(this.internalSettings, "refactorBlobFileLengths() applied", "y");
            }
        }
        finally {
            this.environment.resumeGC();
        }
    }

    private FileSystemBlobVaultOld createDefaultFSBlobVault() {
        try {
            FileSystemBlobVaultOld blobVault;
            PersistentSequenceBlobHandleGenerator.PersistentSequenceGetter persistentSequenceGetter = () -> this.getSequence(this.getAndCheckCurrentTransaction(), BLOB_HANDLES_SEQUENCE);
            try {
                blobVault = new FileSystemBlobVault(this.config, this.location, BLOBS_DIR, BLOBS_EXTENSION, new PersistentSequenceBlobHandleGenerator(persistentSequenceGetter));
            }
            catch (UnexpectedBlobVaultVersionException e) {
                blobVault = null;
            }
            if (blobVault == null) {
                blobVault = this.config.getMaxInPlaceBlobSize() > 0 ? new FileSystemBlobVaultOld(this.config, this.location, BLOBS_DIR, BLOBS_EXTENSION, BlobHandleGenerator.IMMUTABLE) : new FileSystemBlobVaultOld(this.config, this.location, BLOBS_DIR, BLOBS_EXTENSION, new PersistentSequenceBlobHandleGenerator(persistentSequenceGetter));
            }
            long current = persistentSequenceGetter.get().get();
            for (long blobHandle = current + 1L; blobHandle < current + 1000L; ++blobHandle) {
                BlobVaultItem item = blobVault.getBlob(blobHandle);
                if (!item.exists()) continue;
                logger.error("Redundant blob item: " + item);
            }
            blobVault.setSizeFunctions(new CachedBlobLengths(this.environment, this.blobFileLengths));
            return blobVault;
        }
        catch (IOException e) {
            throw ExodusException.toExodusException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicate(@NotNull PersistentEntityStoreReplicator replicator, @Nullable BlobVault blobVault) {
        if (blobVault != null) {
            throw new UnsupportedOperationException("Can only replicate default blob value");
        }
        long highBlobHandle = this.computeInReadonlyTransaction(tx -> {
            ByteIterable value;
            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
            Transaction envTxn = txn.getEnvironmentTransaction();
            Store sequencesStore = this.environment.openStore(SEQUENCES_STORE, StoreConfig.WITHOUT_DUPLICATES, envTxn, false);
            long result = sequencesStore == null ? -1L : ((value = sequencesStore.get(envTxn, PersistentSequence.sequenceNameToEntry(BLOB_HANDLES_SEQUENCE))) == null ? -1L : LongBinding.compressedEntryToLong(value));
            return result;
        });
        EnvironmentReplicationDelta delta = replicator.beginReplication(this.environment);
        try {
            replicator.replicateEnvironment(delta, this.environment);
            if (highBlobHandle >= 0L) {
                this.replicateBlobs(replicator, delta, highBlobHandle);
            }
        }
        finally {
            replicator.endReplication(delta);
        }
    }

    private void replicateBlobs(@NotNull PersistentEntityStoreReplicator replicator, @NotNull EnvironmentReplicationDelta delta, long highBlobHandle) {
        List blobsToReplicate = this.computeInReadonlyTransaction(tx -> {
            String internalSettingsName = this.namingRulez.getInternalSettingsName();
            Transaction envTxn = ((PersistentStoreTransaction)tx).getEnvironmentTransaction();
            Store settings = this.environment.openStore(internalSettingsName, StoreConfig.WITHOUT_DUPLICATES, envTxn, false);
            Store blobFileLengths = this.environment.openStore(this.namingRulez.getBlobFileLengthsTable(), StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, envTxn, false);
            if (settings == null || blobFileLengths == null) {
                return Collections.emptyList();
            }
            if (Settings.get(settings, "refactorBlobFileLengths() applied") == null) {
                throw new IllegalStateException("Cannot replicate blobs without serialized blob list");
            }
            ArrayList<Pair<Long, Long>> result = new ArrayList<Pair<Long, Long>>();
            try (Cursor cursor = blobFileLengths.openCursor(this.getAndCheckCurrentTransaction().getEnvironmentTransaction());){
                ByteIterable foundBlob = cursor.getSearchKeyRange(LongBinding.longToCompressedEntry(highBlobHandle));
                if (foundBlob != null) {
                    do {
                        long blobHandle;
                        if ((blobHandle = LongBinding.compressedEntryToLong(cursor.getKey())) <= highBlobHandle) continue;
                        long fileLength = LongBinding.compressedEntryToLong(cursor.getValue());
                        result.add(new Pair<Long, Long>(blobHandle, fileLength));
                    } while (cursor.getNext());
                }
            }
            return result;
        });
        if (!blobsToReplicate.isEmpty()) {
            BlobVault vault = this.computeInReadonlyTransaction(txn -> {
                this.initBasicStores(((PersistentStoreTransaction)txn).getEnvironmentTransaction());
                return this.initBlobVault();
            });
            replicator.replicateBlobVault(delta, vault, blobsToReplicate);
            this.blobVault = vault;
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    @NotNull
    public PersistentStoreTransaction beginTransaction() {
        PersistentStoreTransaction txn = new PersistentStoreTransaction(this);
        this.registerTransaction(txn);
        return txn;
    }

    @Override
    @NotNull
    public StoreTransaction beginExclusiveTransaction() {
        PersistentStoreTransaction txn = new PersistentStoreTransaction(this, PersistentStoreTransaction.TransactionType.Exclusive);
        this.registerTransaction(txn);
        return txn;
    }

    @Override
    @NotNull
    public PersistentStoreTransaction beginReadonlyTransaction() {
        ReadonlyPersistentStoreTransaction txn = new ReadonlyPersistentStoreTransaction(this);
        this.registerTransaction(txn);
        return txn;
    }

    @Override
    @Nullable
    public PersistentStoreTransaction getCurrentTransaction() {
        Thread thread2 = Thread.currentThread();
        Deque<PersistentStoreTransaction> stack = this.txns.get(thread2);
        return stack == null ? null : stack.peek();
    }

    @NotNull
    public PersistentStoreTransaction getAndCheckCurrentTransaction() {
        PersistentStoreTransaction transaction = this.getCurrentTransaction();
        if (transaction == null) {
            throw new IllegalStateException("EntityStore: current transaction is not set.");
        }
        return transaction;
    }

    public PersistentStoreTransaction beginTransactionAt(long highAddress) {
        return new PersistentStoreTransactionSnapshot(this, highAddress);
    }

    public void registerTransaction(@NotNull PersistentStoreTransaction txn) {
        Thread thread2 = Thread.currentThread();
        Deque<PersistentStoreTransaction> stack = this.txns.get(thread2);
        if (stack == null) {
            stack = new ArrayDeque<PersistentStoreTransaction>(4);
            this.txns.put(thread2, stack);
        }
        stack.push(txn);
    }

    public void unregisterTransaction(@NotNull PersistentStoreTransaction txn) {
        Thread thread2 = Thread.currentThread();
        Deque<PersistentStoreTransaction> stack = this.txns.get(thread2);
        if (stack == null) {
            throw new EntityStoreException("Transaction was already finished");
        }
        if (txn != stack.peek()) {
            throw new EntityStoreException("Can't finish transaction: nested transaction is not finished");
        }
        stack.pop();
        if (stack.isEmpty()) {
            this.txns.remove(thread2);
        }
        txn.closeCaches();
    }

    @Override
    public void clear() {
        this.environment.clear();
        this.allSequences.clear();
        this.entitiesSequences.clear();
        this.propertyTypes.clear();
        this.iterableCache.clear();
        this.init();
        this.blobVault.clear();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public PersistentEntityStoreConfig getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public String getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PersistentSequence getSequence(@NotNull PersistentStoreTransaction txn, @NotNull String sequenceName) {
        Map<String, PersistentSequence> map = this.allSequences;
        synchronized (map) {
            PersistentSequence result = this.allSequences.get(sequenceName);
            if (result == null) {
                result = new PersistentSequence(txn, this.sequences, sequenceName);
                this.allSequences.put(sequenceName, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PersistentSequence getSequence(@NotNull PersistentStoreTransaction txn, @NotNull String sequenceName, long initialValue) {
        Map<String, PersistentSequence> map = this.allSequences;
        synchronized (map) {
            PersistentSequence result = this.allSequences.get(sequenceName);
            if (result == null) {
                result = new PersistentSequence(txn, this.sequences, sequenceName, initialValue);
                this.allSequences.put(sequenceName, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersistentSequence> getAllSequences() {
        Map<String, PersistentSequence> map = this.allSequences;
        synchronized (map) {
            return new ArrayList<PersistentSequence>(this.allSequences.values());
        }
    }

    @Override
    public long getUsableSpace() {
        return new File(this.location).getUsableSpace();
    }

    @Override
    @NotNull
    public BlobVault getBlobVault() {
        return this.blobVault;
    }

    @Override
    public void registerCustomPropertyType(@NotNull StoreTransaction txn, @NotNull Class<? extends Comparable> clazz, @NotNull ComparableBinding binding) {
        boolean[] wasAllocated = new boolean[]{false};
        int typeId = this.propertyCustomTypeIds.getOrAllocateId(() -> {
            wasAllocated[0] = true;
            return (PersistentStoreTransaction)txn;
        }, clazz.getName());
        if (wasAllocated[0]) {
            this.propertyTypes.registerCustomPropertyType(typeId, clazz, binding);
        }
    }

    @Override
    public void executeInTransaction(@NotNull StoreTransactionalExecutable executable) {
        PersistentStoreTransaction txn = this.beginTransaction();
        try {
            do {
                executable.execute(txn);
                if (txn == this.getCurrentTransaction()) continue;
                txn = null;
                break;
            } while (!txn.flush());
        }
        finally {
            if (txn != null) {
                txn.abort();
            }
        }
    }

    @Override
    public void executeInExclusiveTransaction(@NotNull StoreTransactionalExecutable executable) {
        StoreTransaction txn = this.beginExclusiveTransaction();
        try {
            executable.execute(txn);
            txn.commit();
        }
        finally {
            if (txn == this.getCurrentTransaction()) {
                txn.abort();
            }
        }
    }

    @Override
    public void executeInReadonlyTransaction(@NotNull StoreTransactionalExecutable executable) {
        PersistentStoreTransaction txn = this.beginReadonlyTransaction();
        try {
            executable.execute(txn);
        }
        finally {
            if (txn == this.getCurrentTransaction()) {
                txn.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T computeInTransaction(@NotNull StoreTransactionalComputable<T> computable) {
        T result;
        PersistentStoreTransaction txn = this.beginTransaction();
        try {
            do {
                result = computable.compute(txn);
                if (txn == this.getCurrentTransaction()) continue;
                txn = null;
                break;
            } while (!txn.flush());
        }
        finally {
            if (txn != null) {
                txn.abort();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T computeInExclusiveTransaction(@NotNull StoreTransactionalComputable<T> computable) {
        StoreTransaction txn = this.beginExclusiveTransaction();
        try {
            T result = computable.compute(txn);
            txn.commit();
            T t = result;
            return t;
        }
        finally {
            if (txn == this.getCurrentTransaction()) {
                txn.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T computeInReadonlyTransaction(@NotNull StoreTransactionalComputable<T> computable) {
        PersistentStoreTransaction txn = this.beginReadonlyTransaction();
        try {
            T t = computable.compute(txn);
            return t;
        }
        finally {
            if (txn == this.getCurrentTransaction()) {
                txn.abort();
            }
        }
    }

    public Explainer getExplainer() {
        return this.explainer;
    }

    @NotNull
    public EntityIterableCache getEntityIterableCache() {
        return this.iterableCache;
    }

    @Nullable
    public Comparable getProperty(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String propertyName) {
        PropertyValue propValue;
        int propertyId = this.getPropertyId(txn, propertyName, false);
        if (propertyId < 0) {
            return null;
        }
        Comparable result = txn.getCachedProperty(entity, propertyId);
        if (result == null && (propValue = this.getPropertyValue(txn, entity, propertyId)) != null) {
            result = propValue.getData();
            if (propValue.getType().getTypeId() != 8) {
                txn.cacheProperty(entity.getId(), propertyId, result);
            }
        }
        return result;
    }

    @Nullable
    public PropertyValue getPropertyValue(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, int propertyId) {
        ByteIterable entry = this.getRawProperty(txn, entity.getId(), propertyId);
        return entry != null ? this.propertyTypes.entryToPropertyValue(entry) : null;
    }

    @Nullable
    public ByteIterable getRawProperty(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntityId entityId, int propertyId) {
        return this.getRawValue(txn, entityId, propertyId, this.propertyDataGetter);
    }

    public boolean setProperty(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String propertyName, @NotNull Comparable value) {
        Comparable oldValue;
        int propertyId;
        if (value instanceof ComparableSet && ((ComparableSet)value).isEmpty() || value instanceof Boolean && value.equals(false)) {
            return this.deleteProperty(txn, entity, propertyName);
        }
        PropertyValue propValue = this.propertyTypes.dataToPropertyValue(value);
        ComparableValueType valueType = propValue.getType();
        PersistentEntityId entityId = entity.getId();
        ByteIterable oldValueEntry = this.getRawProperty(txn, entityId, propertyId = this.getPropertyId(txn, propertyName, true));
        Comparable comparable = oldValue = oldValueEntry == null ? null : this.propertyTypes.entryToPropertyValue(oldValueEntry).getData();
        if (value.equals(oldValue)) {
            return false;
        }
        this.getPropertiesTable(txn, entityId.getTypeId()).put(txn, entityId.getLocalId(), PropertyTypes.propertyValueToEntry(propValue), oldValueEntry, propertyId, valueType);
        txn.propertyChanged(entityId, propertyId, oldValue, value);
        return true;
    }

    public boolean deleteProperty(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String propertyName) {
        int propertyId = this.getPropertyId(txn, propertyName, false);
        if (propertyId < 0) {
            return false;
        }
        PersistentEntityId id = entity.getId();
        ByteIterable oldValue = this.getRawProperty(txn, id, propertyId);
        if (oldValue == null) {
            return false;
        }
        PropertyValue propValue = this.propertyTypes.entryToPropertyValue(oldValue);
        this.getPropertiesTable(txn, id.getTypeId()).delete(txn, id.getLocalId(), oldValue, propertyId, propValue.getType());
        txn.propertyChanged(id, propertyId, propValue.getData(), null);
        return true;
    }

    @NotNull
    public List<String> getPropertyNames(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        EntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        try (Cursor index2 = this.getPrimaryPropertyIndexCursor(txn, id.getTypeId());){
            boolean success;
            boolean bl = success = index2.getSearchKeyRange(PropertyKey.propertyKeyToEntry(propertyKey)) != null;
            while (success && (propertyKey = PropertyKey.entryToPropertyKey(index2.getKey())).getEntityLocalId() == entityLocalId) {
                String propertyName = this.getPropertyName(txn, propertyKey.getPropertyId());
                if (propertyName != null) {
                    result.add(propertyName);
                }
                success = index2.getNext();
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    @NotNull
    public List<Pair<String, Comparable>> getProperties(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<Pair<String, Comparable>> result = new ArrayList<Pair<String, Comparable>>();
        EntityId fromId = entity.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        try (Cursor cursor = this.getPrimaryPropertyIndexCursor(txn, entityTypeId);){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange(PropertyKey.propertyKeyToEntry(propertyKey)) != null;
            while (success) {
                propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                if (propertyKey.getEntityLocalId() != entityLocalId) {
                    break;
                }
                String propertyName = this.getPropertyName(txn, propertyKey.getPropertyId());
                if (propertyName != null) {
                    result.add(new Pair<String, Comparable>(propertyName, this.propertyTypes.entryToPropertyValue(cursor.getValue()).getData()));
                }
                success = cursor.getNext();
            }
        }
        return result;
    }

    @NotNull
    public Cursor getPrimaryPropertyIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getPrimaryPropertyIndexCursor(txn, this.getPropertiesTable(txn, entityTypeId));
    }

    @NotNull
    public Cursor getPrimaryPropertyIndexCursor(@NotNull PersistentStoreTransaction txn, @NotNull PropertiesTable properties) {
        return properties.getPrimaryIndex().openCursor(txn.getEnvironmentTransaction());
    }

    @Nullable
    public Cursor getPropertyValuesIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId, int propertyId) {
        Store valueIdx = this.getPropertiesTable(txn, entityTypeId).getValueIndex(txn, propertyId, false);
        if (valueIdx == null) {
            return null;
        }
        return valueIdx.openCursor(txn.getEnvironmentTransaction());
    }

    @NotNull
    public Iterable<Pair<Integer, Long>> getEntityWithPropIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int propertyId) {
        return this.getPropertiesTable(txn, entityTypeId).getAllPropsIndex().iterable(txn.getEnvironmentTransaction(), propertyId);
    }

    @NotNull
    public Iterable<Pair<Integer, Long>> getEntityWithBlobIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int blobId) {
        return this.getBlobsTable(txn, entityTypeId).getAllBlobsIndex().iterable(txn.getEnvironmentTransaction(), blobId);
    }

    @Deprecated
    @NotNull
    public Cursor getEntitiesIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getEntitiesTable(txn, entityTypeId).openCursor(txn.getEnvironmentTransaction());
    }

    @NotNull
    public BitmapIterator getEntitiesBitmapIterator(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getEntitiesBitmapTable(txn, entityTypeId).iterator(txn.getEnvironmentTransaction());
    }

    @NotNull
    public BitmapIterator getEntitiesBitmapReverseIterator(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getEntitiesBitmapTable(txn, entityTypeId).reverseIterator(txn.getEnvironmentTransaction());
    }

    @NotNull
    public Cursor getLinksFirstIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getLinksTable(txn, entityTypeId).getFirstIndexCursor(txn.getEnvironmentTransaction());
    }

    @NotNull
    public Cursor getLinksSecondIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getLinksTable(txn, entityTypeId).getSecondIndexCursor(txn.getEnvironmentTransaction());
    }

    @NotNull
    public Iterable<Pair<Integer, Long>> getEntityWithLinkIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int linkId) {
        return this.getLinksTable(txn, entityTypeId).getAllLinksIndex().iterable(txn.getEnvironmentTransaction(), linkId);
    }

    public void clearProperties(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        Transaction envTxn = txn.getEnvironmentTransaction();
        PersistentEntityId id = (PersistentEntityId)entity.getId();
        int entityTypeId = id.getTypeId();
        long entityLocalId = id.getLocalId();
        PropertiesTable properties = this.getPropertiesTable(txn, entityTypeId);
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        try (Cursor cursor = this.getPrimaryPropertyIndexCursor(txn, properties);){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange(PropertyKey.propertyKeyToEntry(propertyKey)) != null;
            while (success) {
                ByteIterable keyEntry = cursor.getKey();
                PropertyKey key = PropertyKey.entryToPropertyKey(keyEntry);
                if (key.getEntityLocalId() != entityLocalId) {
                    break;
                }
                int propertyId = key.getPropertyId();
                ByteIterable value = cursor.getValue();
                PropertyValue propValue = this.propertyTypes.entryToPropertyValue(value);
                txn.propertyChanged(id, propertyId, propValue.getData(), null);
                properties.delete(txn, entityLocalId, value, propertyId, propValue.getType());
                success = cursor.getNext();
            }
        }
    }

    public long getBlobSize(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) throws IOException {
        Pair<Long, ByteIterator> blobInfo = this.getBlobHandleAndValue(txn, entity, blobName);
        if (blobInfo == null) {
            return -1L;
        }
        long blobHandle = blobInfo.getFirst();
        if (blobHandle == Long.MAX_VALUE) {
            return 0L;
        }
        if (PersistentEntityStoreImpl.isInPlaceBlobHandle(blobHandle)) {
            return CompressedUnsignedLongByteIterable.getLong(blobInfo.getSecond());
        }
        long result = txn.getBlobSize(blobHandle);
        if (result < 0L) {
            return this.blobVault.getSize(blobHandle, txn.getEnvironmentTransaction());
        }
        return result;
    }

    @Nullable
    public InputStream getBlob(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) throws IOException {
        Pair<Long, InputStream> blobStream = this.getInPlaceBlobStream(txn, entity, blobName);
        if (blobStream == null) {
            return null;
        }
        long blobHandle = blobStream.getFirst();
        if (blobHandle == Long.MAX_VALUE) {
            return EMPTY_INPUT_STREAM;
        }
        InputStream result = blobStream.getSecond();
        if (result != null) {
            return result;
        }
        result = this.blobVault.getContent(blobHandle, txn.getEnvironmentTransaction());
        if (result == null && !this.readerWriterProvider.isReadonly()) {
            PersistentEntityStoreImpl.loggerWarn("Blob not found: " + this.blobVault.getBlobLocation(blobHandle), new FileNotFoundException());
        }
        return result;
    }

    @Nullable
    public String getBlobString(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) throws IOException {
        int blobId = this.getPropertyId(txn, blobName, false);
        if (blobId < 0) {
            return null;
        }
        String result = txn.getCachedBlobString(entity, blobId);
        if (result != null) {
            return result;
        }
        Pair<Long, InputStream> blobStream = this.getInPlaceBlobStream(txn, entity, blobName);
        if (blobStream == null) {
            return null;
        }
        long blobHandle = blobStream.getFirst();
        if (blobHandle == Long.MAX_VALUE) {
            result = "";
        } else {
            try {
                InputStream stream = blobStream.getSecond();
                if (stream == null) {
                    return this.blobVault.getStringContent(blobHandle, txn.getEnvironmentTransaction());
                }
                result = UTFUtil.readUTF(stream);
            }
            catch (UTFDataFormatException e) {
                result = e.toString();
            }
        }
        if (result != null) {
            txn.cacheBlobString(entity, blobId, result);
        }
        return result;
    }

    @Nullable
    Pair<Long, ByteIterator> getBlobHandleAndValue(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) {
        int blobId = this.getPropertyId(txn, blobName, false);
        if (blobId < 0) {
            return null;
        }
        ByteIterable valueEntry = this.getRawValue(txn, entity.getId(), blobId, this.blobDataGetter);
        if (valueEntry == null) {
            return null;
        }
        ByteIterator valueIterator = valueEntry.iterator();
        long blobHandle = LongBinding.readCompressed(valueIterator);
        if (!this.useVersion1Format()) {
            blobHandle = blobHandle == 0L ? Long.MAX_VALUE : (blobHandle == 1L ? 0x7FFFFFFFFFFFFFFEL : (blobHandle == 2L ? 0x7FFFFFFFFFFFFFFDL : (blobHandle -= 16L)));
        }
        return new Pair<Long, ByteIterator>(blobHandle, valueIterator);
    }

    private boolean useIntForLocalId() {
        return this.config.getUseIntForLocalId();
    }

    @Nullable
    private Pair<Long, InputStream> getInPlaceBlobStream(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) throws IOException {
        Pair<Long, ByteIterator> blobInfo = this.getBlobHandleAndValue(txn, entity, blobName);
        if (blobInfo == null) {
            return null;
        }
        long blobHandle = blobInfo.getFirst();
        if (blobHandle == Long.MAX_VALUE) {
            return new Pair<Long, Object>(blobHandle, null);
        }
        if (PersistentEntityStoreImpl.isInPlaceBlobHandle(blobHandle)) {
            ByteIterator valueIterator = blobInfo.getSecond();
            int size = (int)CompressedUnsignedLongByteIterable.getLong(valueIterator);
            if (blobHandle == 0x7FFFFFFFFFFFFFFEL) {
                return new Pair<Long, InputStream>(blobHandle, new ByteArraySizedInputStream(ByteIterableBase.readIterator(valueIterator, size)));
            }
            ArrayByteIterable hashEntry = new ArrayByteIterable(valueIterator);
            ByteIterable duplicateEntry = this.getBlobHashesTable(txn, entity.getId().getTypeId()).getDatabase().get(txn.getEnvironmentTransaction(), hashEntry);
            if (duplicateEntry == null) {
                throw new EntityStoreException("No duplicate entry is available to in-place blob reference");
            }
            return new Pair<Long, InputStream>(blobHandle, new ByteArraySizedInputStream(ByteIterableBase.readIteratorSafe(duplicateEntry.iterator(), size)));
        }
        return new Pair<Long, InputStream>(blobHandle, txn.getBlobStream(blobHandle));
    }

    public void setBlob(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName, @NotNull InputStream stream) throws IOException {
        ByteArraySizedInputStream copy = stream instanceof ByteArraySizedInputStream ? (ByteArraySizedInputStream)stream : this.blobVault.cloneStream(stream, true);
        long blobHandle = this.createBlobHandle(txn, entity, blobName, copy, copy.size());
        if (!PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) {
            this.setBlobFileLength(txn, blobHandle, copy.size());
            txn.addBlob(blobHandle, copy);
        }
    }

    public void setBlob(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName, @NotNull File file) throws IOException {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new EntityStoreException("Too large blob, size is greater than 2147483647");
        }
        int size = (int)length;
        long blobHandle = this.createBlobHandle(txn, entity, blobName, size > this.config.getMaxInPlaceBlobSize() ? null : this.blobVault.cloneFile(file), size);
        if (!PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) {
            this.setBlobFileLength(txn, blobHandle, length);
            txn.addBlob(blobHandle, file);
        }
    }

    public void setBlobString(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName, @NotNull String blobString) throws IOException {
        int length = blobString.length();
        if (length == 0) {
            this.createBlobHandle(txn, entity, blobName, null, 0);
        } else {
            LightByteArrayOutputStream memCopy = new LightByteArrayOutputStream();
            UTFUtil.writeUTF(memCopy, blobString);
            int streamSize = memCopy.size();
            ByteArraySizedInputStream copy = new ByteArraySizedInputStream(memCopy.toByteArray(), 0, streamSize);
            long blobHandle = this.createBlobHandle(txn, entity, blobName, copy, streamSize);
            if (!PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) {
                this.setBlobFileLength(txn, blobHandle, copy.size());
                txn.addBlob(blobHandle, copy);
            }
        }
    }

    private long createBlobHandle(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName, @Nullable ByteArraySizedInputStream stream, int size) {
        long blobHandle;
        PersistentEntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        int blobId = this.getPropertyId(txn, blobName, true);
        txn.invalidateCachedBlobString(entity, blobId);
        int typeId = id.getTypeId();
        BlobsTable blobs = this.getBlobsTable(txn, typeId);
        Transaction envTxn = txn.getEnvironmentTransaction();
        ByteIterable value = blobs.get(envTxn, entityLocalId, blobId);
        if (value != null) {
            this.deleteObsoleteBlobHandle(this.entryToBlobHandle(value), txn);
        }
        if (size == 0) {
            blobHandle = Long.MAX_VALUE;
            blobs.put(envTxn, entityLocalId, blobId, this.blobHandleToEntry(blobHandle));
        } else if (size <= this.config.getMaxInPlaceBlobSize()) {
            ByteIterable hashEntry;
            if (stream == null) {
                throw new NullPointerException("In-memory blob content is expected");
            }
            if (!this.useVersion1Format() && (hashEntry = this.findDuplicate(txn, typeId, stream)) != null) {
                blobs.put(envTxn, entityLocalId, blobId, new CompoundByteIterable(new ByteIterable[]{this.blobHandleToEntry(0x7FFFFFFFFFFFFFFDL), CompressedUnsignedLongByteIterable.getIterable(size), hashEntry}));
                return 0x7FFFFFFFFFFFFFFDL;
            }
            blobHandle = 0x7FFFFFFFFFFFFFFEL;
            blobs.put(envTxn, entityLocalId, blobId, new CompoundByteIterable(new ByteIterable[]{this.blobHandleToEntry(blobHandle), CompressedUnsignedLongByteIterable.getIterable(size), new ArrayByteIterable(stream.toByteArray(), size)}));
        } else {
            blobHandle = this.blobVault.nextHandle(envTxn);
            blobs.put(envTxn, entityLocalId, blobId, this.blobHandleToEntry(blobHandle));
        }
        return blobHandle;
    }

    @Nullable
    ByteIterable findDuplicate(@NotNull PersistentStoreTransaction txn, int typeId, @NotNull ByteArraySizedInputStream stream) {
        ArrayByteIterable duplicateKey = IntegerBinding.intToEntry(stream.hashCode());
        ByteIterable duplicateEntry = this.getBlobHashesTable(txn, typeId).getDatabase().get(txn.getEnvironmentTransaction(), duplicateKey);
        return duplicateEntry != null && stream.equals(new ByteArraySizedInputStream(ByteIterableBase.readIterable(duplicateEntry))) ? duplicateKey : null;
    }

    public boolean useVersion1Format() {
        return this.environment.getEnvironmentConfig().getUseVersion1Format();
    }

    ByteIterable blobHandleToEntry(long blobHandle) {
        if (!this.useVersion1Format()) {
            blobHandle = blobHandle == Long.MAX_VALUE ? 0L : (blobHandle == 0x7FFFFFFFFFFFFFFEL ? 1L : (blobHandle == 0x7FFFFFFFFFFFFFFDL ? 2L : (blobHandle += 16L)));
        }
        return LongBinding.longToCompressedEntry(blobHandle);
    }

    private long entryToBlobHandle(ByteIterable entry) {
        long result = LongBinding.compressedEntryToLong(entry);
        if (this.useVersion1Format()) {
            return result;
        }
        if (result == 0L) {
            return Long.MAX_VALUE;
        }
        if (result == 1L) {
            return 0x7FFFFFFFFFFFFFFEL;
        }
        if (result == 2L) {
            return 0x7FFFFFFFFFFFFFFDL;
        }
        return result - 16L;
    }

    public boolean deleteBlob(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) {
        Transaction envTxn = txn.getEnvironmentTransaction();
        int blobId = this.getPropertyId(txn, blobName, false);
        if (blobId < 0) {
            return false;
        }
        txn.invalidateCachedBlobString(entity, blobId);
        PersistentEntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        BlobsTable blobs = this.getBlobsTable(txn, id.getTypeId());
        ByteIterable value = blobs.get(envTxn, entityLocalId, blobId);
        if (value == null) {
            return false;
        }
        blobs.delete(envTxn, entityLocalId, blobId);
        this.deleteObsoleteBlobHandle(this.entryToBlobHandle(value), txn);
        return true;
    }

    public void clearBlobs(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity) {
        PersistentEntityId id = entity.getId();
        int entityTypeId = id.getTypeId();
        long entityLocalId = id.getLocalId();
        Transaction envTxn = txn.getEnvironmentTransaction();
        BlobsTable blobs = this.getBlobsTable(txn, entityTypeId);
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        ByteIterable keyEntry = PropertyKey.propertyKeyToEntry(propertyKey);
        try (Cursor cursor = blobs.getPrimaryIndex().openCursor(envTxn);){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange(keyEntry) != null;
            while (success) {
                keyEntry = cursor.getKey();
                PropertyKey key = PropertyKey.entryToPropertyKey(keyEntry);
                if (key.getEntityLocalId() != entityLocalId) {
                    break;
                }
                ByteIterable value = cursor.getValue();
                int blobId = key.getPropertyId();
                blobs.delete(envTxn, entityLocalId, blobId);
                txn.invalidateCachedBlobString(entity, blobId);
                this.deleteObsoleteBlobHandle(this.entryToBlobHandle(value), txn);
                success = cursor.getNext();
            }
        }
    }

    @NotNull
    public List<String> getBlobNames(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity) {
        ArrayList<String> result = new ArrayList<String>();
        PersistentEntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        try (Cursor index2 = this.getBlobsTable(txn, id.getTypeId()).getPrimaryIndex().openCursor(txn.getEnvironmentTransaction());){
            boolean success;
            boolean bl = success = index2.getSearchKeyRange(PropertyKey.propertyKeyToEntry(propertyKey)) != null;
            while (success && (propertyKey = PropertyKey.entryToPropertyKey(index2.getKey())).getEntityLocalId() == entityLocalId) {
                String propertyName = this.getPropertyName(txn, propertyKey.getPropertyId());
                if (propertyName != null) {
                    result.add(propertyName);
                }
                success = index2.getNext();
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    @NotNull
    public List<Pair<String, Long>> getBlobs(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<Pair<String, Long>> result = new ArrayList<Pair<String, Long>>();
        EntityId fromId = entity.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey blobKey = new PropertyKey(entityLocalId, 0);
        try (Cursor cursor = this.getBlobsTable(txn, entityTypeId).getPrimaryIndex().openCursor(txn.getEnvironmentTransaction());){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange(PropertyKey.propertyKeyToEntry(blobKey)) != null;
            while (success) {
                blobKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                if (blobKey.getEntityLocalId() != entityLocalId) {
                    break;
                }
                String blobName = this.getPropertyName(txn, blobKey.getPropertyId());
                if (blobName != null) {
                    result.add(new Pair<String, Long>(blobName, this.entryToBlobHandle(cursor.getValue())));
                }
                success = cursor.getNext();
            }
        }
        return result;
    }

    boolean addLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, @NotNull PersistentEntity target, int linkId) {
        PersistentEntityId fromId = from.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey linkKey = new PropertyKey(entityLocalId, linkId);
        LinkValue linkValue = new LinkValue(target.getId(), linkId);
        if (this.config.isDebugTestLinkedEntities()) {
            target = this.getEntityAssertPhantomLink(txn, target.getId());
        }
        ByteIterable existingValue = this.nonDebugLinkDataGetter.getUpToDateEntry(txn, entityTypeId, linkKey);
        if (!this.getLinksTable(txn, entityTypeId).put(txn.getEnvironmentTransaction(), entityLocalId, LinkValue.linkValueToEntry(linkValue), existingValue == null, linkId)) {
            return false;
        }
        txn.linkAdded(from.getId(), target.getId(), linkId);
        return true;
    }

    boolean setLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId, @Nullable PersistentEntity target) {
        ByteIterable oldValue;
        Transaction envTxn = txn.getEnvironmentTransaction();
        PersistentEntityId fromId = from.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        LinksTable links = this.getLinksTable(txn, entityTypeId);
        boolean oldTargetDeleted = false;
        if (target != null && this.config.isDebugTestLinkedEntities()) {
            target = this.getEntityAssertPhantomLink(txn, target.getId());
        }
        if ((oldValue = this.getRawLink(txn, fromId, linkId)) != null) {
            PersistentEntity oldTarget = this.getEntity(LinkValue.entryToLinkValue(oldValue).getEntityId());
            if (oldTarget.equals(target)) {
                return false;
            }
            links.delete(envTxn, entityLocalId, oldValue, target == null, linkId);
            txn.linkDeleted(fromId, oldTarget.getId(), linkId);
            oldTargetDeleted = true;
        }
        if (target == null) {
            return oldTargetDeleted;
        }
        LinkValue linkValue = new LinkValue(target.getId(), linkId);
        links.put(envTxn, entityLocalId, LinkValue.linkValueToEntry(linkValue), oldValue == null, linkId);
        txn.linkAdded(fromId, target.getId(), linkId);
        return true;
    }

    @Nullable
    PersistentEntity getLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId) {
        PersistentEntityId resultId = this.getLinkAsEntityId(txn, from, linkId);
        return resultId == null ? null : this.getEntity(resultId);
    }

    @Nullable
    public PersistentEntityId getLinkAsEntityId(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId) {
        PersistentEntityId resultId = txn.getCachedLink(from, linkId);
        if (resultId == null && (resultId = this.getRawLinkAsEntityId(txn, from.getId(), linkId)) != null) {
            txn.cacheLink(from, linkId, resultId);
        }
        return resultId;
    }

    @Nullable
    public PersistentEntityId getRawLinkAsEntityId(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntityId fromId, int linkId) {
        ByteIterable resultEntry = this.getRawLink(txn, fromId, linkId);
        return resultEntry == null ? null : (PersistentEntityId)LinkValue.entryToLinkValue(resultEntry).getEntityId();
    }

    @Nullable
    private ByteIterable getRawLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntityId fromId, int linkId) {
        return this.getRawValue(txn, fromId, linkId, this.linkDataGetter);
    }

    @Nullable
    private ByteIterable getRawValue(@NotNull PersistentStoreTransaction txn, @NotNull EntityId entityId, int propertyId, @NotNull DataGetter dataGetter) {
        return dataGetter.getUpToDateEntry(txn, entityId.getTypeId(), new PropertyKey(entityId.getLocalId(), propertyId));
    }

    @NotNull
    EntityIterableBase getLinks(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId) {
        return new EntityFromLinksIterable(txn, from.getId(), linkId);
    }

    @NotNull
    EntityIterable getLinks(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, IntHashMap<String> linkNames) {
        return new EntityFromLinkSetIterable(txn, from.getId(), linkNames);
    }

    boolean deleteLinkInternal(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId, @NotNull PersistentEntity to) {
        boolean result = this.deleteLinkInternal(txn, from, linkId, to.getId());
        if (result) {
            PersistentEntityId fromId = from.getId();
            long entityLocalId = fromId.getLocalId();
            PropertyKey linkKey = new PropertyKey(entityLocalId, linkId);
            int entityTypeId = fromId.getTypeId();
            ByteIterable remainingValue = this.nonDebugLinkDataGetter.getUpToDateEntry(txn, entityTypeId, linkKey);
            if (remainingValue == null) {
                this.getLinksTable(txn, entityTypeId).deleteAllIndex(txn.getEnvironmentTransaction(), linkId, entityLocalId);
            }
        }
        return result;
    }

    void deleteAllLinks(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId, @NotNull EntityIterableBase existing) {
        EntityIterator itr = existing.iterator();
        boolean deleted = false;
        while (itr.hasNext()) {
            deleted |= this.deleteLinkInternal(txn, from, linkId, (PersistentEntityId)itr.nextId());
        }
        if (deleted) {
            PersistentEntityId fromId = from.getId();
            this.getLinksTable(txn, fromId.getTypeId()).deleteAllIndex(txn.getEnvironmentTransaction(), linkId, fromId.getLocalId());
        }
    }

    private boolean deleteLinkInternal(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId, @NotNull PersistentEntityId toId) {
        PersistentEntityId fromId = from.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey linkKey = new PropertyKey(entityLocalId, linkId);
        LinkValue linkValue = new LinkValue(toId, linkId);
        Transaction envTxn = txn.getEnvironmentTransaction();
        LinksTable links = this.getLinksTable(txn, entityTypeId);
        if (links.delete(envTxn, PropertyKey.propertyKeyToEntry(linkKey), LinkValue.linkValueToEntry(linkValue))) {
            txn.linkDeleted(fromId, toId, linkId);
            return true;
        }
        return false;
    }

    @NotNull
    public List<String> getLinkNames(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        EntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        PropertyKey linkKey = new PropertyKey(entityLocalId, 0);
        try (Cursor index2 = this.getLinksTable(txn, id.getTypeId()).getFirstIndexCursor(txn.getEnvironmentTransaction());){
            boolean success;
            boolean bl = success = index2.getSearchKeyRange(PropertyKey.propertyKeyToEntry(linkKey)) != null;
            while (success && (linkKey = PropertyKey.entryToPropertyKey(index2.getKey())).getEntityLocalId() == entityLocalId) {
                String linkName = this.getLinkName(txn, linkKey.getPropertyId());
                if (linkName != null) {
                    result.add(linkName);
                }
                success = index2.getNextNoDup();
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    @NotNull
    public List<Pair<String, EntityId>> getLinks(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<Pair<String, EntityId>> result = new ArrayList<Pair<String, EntityId>>();
        EntityId fromId = entity.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey linkKey = new PropertyKey(entityLocalId, 0);
        try (Cursor cursor = this.getLinksTable(txn, entityTypeId).getFirstIndexCursor(txn.getEnvironmentTransaction());){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange(PropertyKey.propertyKeyToEntry(linkKey)) != null;
            while (success) {
                linkKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                if (linkKey.getEntityLocalId() != entityLocalId) {
                    break;
                }
                String linkName = this.getLinkName(txn, linkKey.getPropertyId());
                if (linkName != null) {
                    result.add(new Pair<String, EntityId>(linkName, LinkValue.entryToLinkValue(cursor.getValue()).getEntityId()));
                }
                success = cursor.getNext();
            }
        }
        return result;
    }

    @Deprecated
    public int getLastVersion(@NotNull EntityId id) {
        return this.getLastVersion(this.getAndCheckCurrentTransaction(), id);
    }

    public int getLastVersion(@NotNull PersistentStoreTransaction txn, @NotNull EntityId id) {
        if (this.useVersion1Format()) {
            Store entities = this.getEntitiesTable(txn, id.getTypeId());
            ByteIterable versionEntry = entities.get(txn.getEnvironmentTransaction(), LongBinding.longToCompressedEntry(id.getLocalId()));
            if (versionEntry == null) {
                return -1;
            }
            return IntegerBinding.compressedEntryToInt(versionEntry);
        }
        BitmapImpl bitmap = this.getEntitiesBitmapTable(txn, id.getTypeId());
        boolean exists = bitmap.get(txn.getEnvironmentTransaction(), id.getLocalId());
        return exists ? 0 : -1;
    }

    @Override
    public PersistentEntity getEntity(@NotNull EntityId id) {
        return new PersistentEntity(this, (PersistentEntityId)id);
    }

    boolean deleteEntity(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity) {
        boolean result;
        this.clearProperties(txn, entity);
        this.clearBlobs(txn, entity);
        this.deleteLinks(txn, entity);
        PersistentEntityId id = entity.getId();
        int entityTypeId = id.getTypeId();
        long entityLocalId = id.getLocalId();
        ArrayByteIterable key = LongBinding.longToCompressedEntry(entityLocalId);
        if (this.config.isDebugSearchForIncomingLinksOnDelete()) {
            List<String> allLinkNames = this.getAllLinkNames(txn);
            for (String entityType : txn.getEntityTypes()) {
                for (String linkName : allLinkNames) {
                    EntityIterator entityIterator = txn.findLinks(entityType, entity, linkName).iterator();
                    if (!entityIterator.hasNext()) continue;
                    Entity referrer = (Entity)entityIterator.next();
                    throw new EntityStoreException(entity + " is about to be deleted, but it is referenced by " + referrer + ", link name: " + linkName);
                }
            }
        }
        Transaction envTxn = txn.getEnvironmentTransaction();
        boolean bl = result = this.useVersion1Format() ? this.getEntitiesTable(txn, entityTypeId).delete(envTxn, key) : this.getEntitiesBitmapTable(txn, entityTypeId).clear(envTxn, entityLocalId);
        if (result) {
            txn.entityDeleted(id);
        }
        return result;
    }

    private void deleteLinks(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity) {
        PersistentEntityId id = entity.getId();
        int entityTypeId = id.getTypeId();
        long entityLocalId = id.getLocalId();
        Transaction envTxn = txn.getEnvironmentTransaction();
        LinksTable links = this.getLinksTable(txn, entityTypeId);
        IntHashSet deletedLinks = new IntHashSet();
        try (Cursor cursor = links.getFirstIndexCursor(envTxn);){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange(PropertyKey.propertyKeyToEntry(new PropertyKey(entityLocalId, 0))) != null;
            while (success) {
                int linkId;
                ByteIterable keyEntry = cursor.getKey();
                PropertyKey key = PropertyKey.entryToPropertyKey(keyEntry);
                if (key.getEntityLocalId() != entityLocalId) {
                    break;
                }
                ByteIterable valueEntry = cursor.getValue();
                if (links.delete(envTxn, keyEntry, valueEntry) && this.getLinkName(txn, linkId = key.getPropertyId()) != null) {
                    deletedLinks.add(linkId);
                    LinkValue linkValue = LinkValue.entryToLinkValue(valueEntry);
                    txn.linkDeleted(entity.getId(), (PersistentEntityId)linkValue.getEntityId(), linkValue.getLinkId());
                }
                success = cursor.getNext();
            }
        }
        for (Integer linkId : deletedLinks) {
            links.deleteAllIndex(envTxn, linkId, entityLocalId);
        }
    }

    @Override
    public int getEntityTypeId(@NotNull String entityType) {
        return this.getEntityTypeId(entityType, false);
    }

    @Deprecated
    public int getEntityTypeId(@NotNull String entityType, boolean allowCreate) {
        return this.getEntityTypeId(this.txnProvider, entityType, allowCreate);
    }

    public int getEntityTypeId(@NotNull PersistentStoreTransaction txn, @NotNull String entityType, boolean allowCreate) {
        Objects.requireNonNull(entityType, "Entity type cannot be null");
        return allowCreate ? this.entityTypes.getOrAllocateId(txn, entityType) : this.entityTypes.getId(txn, entityType);
    }

    public int getEntityTypeId(@NotNull TxnProvider txnProvider, @NotNull String entityType, boolean allowCreate) {
        Objects.requireNonNull(entityType, "Entity type cannot be null");
        return allowCreate ? this.entityTypes.getOrAllocateId(txnProvider, entityType) : this.entityTypes.getId(txnProvider, entityType);
    }

    @Override
    @NotNull
    public String getEntityType(int entityTypeId) {
        return this.getEntityType(this.txnProvider, entityTypeId);
    }

    @NotNull
    public String getEntityType(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        String result = this.entityTypes.getName(txn, entityTypeId);
        if (result == null) {
            throw new EntityRemovedInDatabaseException("Invalid type id: " + entityTypeId);
        }
        return result;
    }

    @NotNull
    public String getEntityType(@NotNull TxnProvider txnProvider, int entityTypeId) {
        String result = this.entityTypes.getName(txnProvider, entityTypeId);
        if (result == null) {
            throw new EntityRemovedInDatabaseException("Invalid type id: " + entityTypeId);
        }
        return result;
    }

    @NotNull
    public List<String> getEntityTypes(@NotNull PersistentStoreTransaction txn) {
        ArrayList<String> result = new ArrayList<String>();
        try (Cursor entityTypesCursor = this.entityTypes.getTable().getSecondIndexCursor(txn.getEnvironmentTransaction());){
            while (entityTypesCursor.getNext()) {
                int entityTypeId = IntegerBinding.compressedEntryToInt(entityTypesCursor.getKey());
                result.add(this.getEntityType(txn, entityTypeId));
            }
        }
        return result;
    }

    @Override
    public void renameEntityType(@NotNull String oldEntityTypeName, @NotNull String newEntityTypeName) {
        this.entityTypes.rename(this.getAndCheckCurrentTransaction(), oldEntityTypeName, newEntityTypeName);
    }

    public void deleteEntityType(@NotNull String entityTypeName) {
        PersistentStoreTransaction txn = this.getAndCheckCurrentTransaction();
        int entityTypeId = this.entityTypes.delete(txn, entityTypeName);
        if (entityTypeId < 0) {
            return;
        }
        this.entitiesTables.remove(entityTypeId);
        this.propertiesTables.remove(entityTypeId);
        this.linksTables.remove(entityTypeId);
        this.blobsTables.remove(entityTypeId);
        this.blobHashesTables.remove(entityTypeId);
        String entityTableName = this.namingRulez.getEntitiesTableName(entityTypeId);
        final String propertiesTableName = this.namingRulez.getPropertiesTableName(entityTypeId);
        String linksTableName = this.namingRulez.getLinksTableName(entityTypeId);
        String secondLinksTableName = TwoColumnTable.secondColumnDatabaseName(linksTableName);
        String blobsObsoleteTableName = this.namingRulez.getBlobsObsoleteTableName(entityTypeId);
        String blobsTableName = this.namingRulez.getBlobsTableName(entityTypeId);
        this.truncateStores(txn, Arrays.asList(entityTableName, linksTableName, secondLinksTableName, propertiesTableName, blobsObsoleteTableName, blobsTableName), () -> new Iterator<String>(){
            private int propertyId = 0;

            @Override
            public boolean hasNext() {
                return this.propertyId < 10000;
            }

            @Override
            public String next() {
                return propertiesTableName + "#value_idx" + this.propertyId++;
            }

            @Override
            public void remove() {
            }
        });
    }

    private void truncateStores(@NotNull PersistentStoreTransaction txn, @NotNull Iterable<String> unsafe, @NotNull Iterable<String> safe) {
        Transaction envTxn = txn.getEnvironmentTransaction();
        for (String name : unsafe) {
            if (!this.environment.storeExists(name, envTxn)) continue;
            this.environment.truncateStore(name, envTxn);
        }
        for (String name : safe) {
            try {
                if (!this.environment.storeExists(name, envTxn)) continue;
                this.environment.truncateStore(name, envTxn);
            }
            catch (ExodusException exodusException) {}
        }
    }

    @Deprecated
    public int getPropertyId(@NotNull String propertyName, boolean allowCreate) {
        return this.getPropertyId(this.txnProvider, propertyName, allowCreate);
    }

    public int getPropertyId(@NotNull PersistentStoreTransaction txn, @NotNull String propertyName, boolean allowCreate) {
        return allowCreate ? this.propertyIds.getOrAllocateId(txn, propertyName) : this.propertyIds.getId(txn, propertyName);
    }

    public int getPropertyId(@NotNull TxnProvider txnProvider, @NotNull String propertyName, boolean allowCreate) {
        return allowCreate ? this.propertyIds.getOrAllocateId(txnProvider, propertyName) : this.propertyIds.getId(txnProvider, propertyName);
    }

    @Nullable
    public String getPropertyName(@NotNull PersistentStoreTransaction txn, int propertyId) {
        return this.propertyIds.getName(txn, propertyId);
    }

    @Deprecated
    public int getLinkId(@NotNull String linkName, boolean allowCreate) {
        return this.getLinkId(this.txnProvider, linkName, allowCreate);
    }

    public int getLinkId(@NotNull PersistentStoreTransaction txn, @NotNull String linkName, boolean allowCreate) {
        return allowCreate ? this.linkIds.getOrAllocateId(txn, linkName) : this.linkIds.getId(txn, linkName);
    }

    public int getLinkId(@NotNull TxnProvider txnProvider, @NotNull String linkName, boolean allowCreate) {
        return allowCreate ? this.linkIds.getOrAllocateId(txnProvider, linkName) : this.linkIds.getId(txnProvider, linkName);
    }

    public void deleteLinkName(@NotNull PersistentStoreTransaction txn, @NotNull String linkName) {
        this.linkIds.delete(txn, linkName);
    }

    @Nullable
    public String getLinkName(@NotNull PersistentStoreTransaction txn, int linkId) {
        return this.linkIds.getName(txn, linkId);
    }

    public List<String> getAllLinkNames(@NotNull PersistentStoreTransaction txn) {
        int lastLinkId = this.linkIds.getLastAllocatedId();
        ArrayList<String> result = new ArrayList<String>(lastLinkId + 1);
        for (int i = 0; i <= lastLinkId; ++i) {
            String linkName = this.getLinkName(txn, i);
            if (linkName == null) continue;
            result.add(linkName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    PersistentSequence getEntitiesSequence(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        IntHashMap<PersistentSequence> intHashMap = this.entitiesSequences;
        synchronized (intHashMap) {
            PersistentSequence result = this.entitiesSequences.get(entityTypeId);
            if (result == null) {
                result = this.getSequence(txn, this.namingRulez.getEntitiesSequenceName(entityTypeId));
                this.entitiesSequences.put(entityTypeId, result);
            }
            return result;
        }
    }

    private void preloadTables(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        if (this.useVersion1Format()) {
            this.getEntitiesTable(txn, entityTypeId);
        } else {
            this.getEntitiesBitmapTable(txn, entityTypeId);
        }
        this.getPropertiesTable(txn, entityTypeId);
        this.getLinksTable(txn, entityTypeId);
        this.getBlobsTable(txn, entityTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackTableCreation(@NotNull Store table, @NotNull PersistentStoreTransaction txn) {
        final StoreImpl tableImpl = (StoreImpl)table;
        if (tableImpl.isNew(txn.getEnvironmentTransaction())) {
            Set<TableCreationOperation> set = this.tableCreationLog;
            synchronized (set) {
                this.tableCreationLog.add(new TableCreationOperation(){

                    @Override
                    void persist(Transaction txn) {
                        tableImpl.persistCreation(txn);
                    }
                });
            }
        }
    }

    @Override
    public void logOperations(Transaction txn, FlushLog flushLog) {
        for (PersistentSequence sequence : this.getAllSequences()) {
            sequence.logOperations(txn, flushLog);
        }
        this.entityTypes.logOperations(txn, flushLog);
        this.propertyIds.logOperations(txn, flushLog);
        this.propertyCustomTypeIds.logOperations(txn, flushLog);
        this.linkIds.logOperations(txn, flushLog);
        for (TableCreationOperation op : this.tableCreationLog) {
            op.persist(txn);
            flushLog.add(op);
        }
    }

    @NotNull
    public TwoColumnTable getEntityTypesTable() {
        return this.entityTypes.getTable();
    }

    @NotNull
    public PropertyTypes getPropertyTypes() {
        return this.propertyTypes;
    }

    @Deprecated
    @NotNull
    public Store getEntitiesTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return ((SingleColumnTable)this.entitiesTables.get(txn, entityTypeId)).getDatabase();
    }

    public long getEntitiesCount(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        if (this.useVersion1Format()) {
            return this.getEntitiesTable(txn, entityTypeId).count(txn.getEnvironmentTransaction());
        }
        return this.getEntitiesBitmapTable(txn, entityTypeId).count(txn.getEnvironmentTransaction());
    }

    @NotNull
    public BitmapImpl getEntitiesBitmapTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return ((BitmapTable)this.entitiesTables.get(txn, entityTypeId)).getBitmap();
    }

    @NotNull
    public PropertiesTable getPropertiesTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return (PropertiesTable)this.propertiesTables.get(txn, entityTypeId);
    }

    @NotNull
    public LinksTable getLinksTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return (LinksTable)this.linksTables.get(txn, entityTypeId);
    }

    @NotNull
    public BlobsTable getBlobsTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return (BlobsTable)this.blobsTables.get(txn, entityTypeId);
    }

    @NotNull
    SingleColumnTable getBlobHashesTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return (SingleColumnTable)this.blobHashesTables.get(txn, entityTypeId);
    }

    public Long getBlobFileLength(long blobHandle, Transaction txn) {
        ByteIterable resultEntry = this.blobFileLengths.get(txn, LongBinding.longToCompressedEntry(blobHandle));
        return resultEntry == null ? null : Long.valueOf(LongBinding.compressedEntryToLong(resultEntry));
    }

    void setBlobFileLength(@NotNull PersistentStoreTransaction txn, long blobHandle, long length) {
        if (length < 0L) {
            throw new IllegalArgumentException("length < 0");
        }
        this.blobFileLengths.put(txn.getEnvironmentTransaction(), LongBinding.longToCompressedEntry(blobHandle), LongBinding.longToCompressedEntry(length));
    }

    void deleteBlobFileLength(@NotNull PersistentStoreTransaction txn, long blobHandle) {
        this.blobFileLengths.delete(txn.getEnvironmentTransaction(), LongBinding.longToCompressedEntry(blobHandle));
    }

    public long blobFileCount(@NotNull PersistentStoreTransaction txn) {
        return this.blobFileLengths.count(txn.getEnvironmentTransaction());
    }

    public Iterable<Pair<Long, Long>> getBlobFileLengths(@NotNull PersistentStoreTransaction txn) {
        return this.getBlobFileLengths(txn, 0L);
    }

    public Iterable<Pair<Long, Long>> getBlobFileLengths(@NotNull PersistentStoreTransaction txn, long fromHandle) {
        return new BlobFileLengthsIterable(txn, fromHandle);
    }

    @Override
    @NotNull
    public EntityStoreSharedAsyncProcessor getAsyncProcessor() {
        return this.iterableCache.getProcessor();
    }

    @Override
    @NotNull
    public Statistics getStatistics() {
        return this.statistics;
    }

    public void setCloseEnvironment(boolean closeEnvironment) {
        this.closeEnvironment = closeEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PersistentEntityStoreImpl.loggerDebug("Closing...");
        this.config.removeChangedSettingsListener(this.entityStoreSettingsListener);
        if (this.configMBean != null) {
            this.configMBean.unregister();
        }
        if (this.statisticsMBean != null) {
            this.statisticsMBean.unregister();
        }
        try {
            this.getAsyncProcessor().finish();
            PersistentEntityStoreImpl persistentEntityStoreImpl = this;
            synchronized (persistentEntityStoreImpl) {
                this.blobVault.close();
                if (this.closeEnvironment) {
                    this.environment.close();
                }
            }
            this.iterableCache.clear();
            PersistentEntityStoreImpl.loggerDebug("Closed successfully.");
        }
        catch (Exception e) {
            logger.error("close() failed", e);
            throw ExodusException.toExodusException(e);
        }
    }

    @Override
    @NotNull
    public BackupStrategy getBackupStrategy() {
        return new PersistentEntityStoreBackupStrategy(this);
    }

    @NotNull
    StoreNamingRules getNamingRules() {
        return this.namingRulez;
    }

    static boolean isInPlaceBlobHandle(long blobHandle) {
        return 0x7FFFFFFFFFFFFFFEL == blobHandle || 0x7FFFFFFFFFFFFFFDL == blobHandle;
    }

    static boolean isEmptyOrInPlaceBlobHandle(long blobHandle) {
        return Long.MAX_VALUE == blobHandle || PersistentEntityStoreImpl.isInPlaceBlobHandle(blobHandle);
    }

    public static void loggerWarn(@NotNull String message) {
        if (logger.isWarnEnabled()) {
            logger.warn(message);
        }
    }

    public static void loggerWarn(@NotNull String message, @NotNull Throwable t) {
        if (logger.isWarnEnabled()) {
            logger.warn(message, t);
        }
    }

    public static void loggerDebug(@NotNull String message) {
        if (logger.isDebugEnabled()) {
            logger.debug(message);
        }
    }

    public static void loggerDebug(@NotNull String message, @NotNull Throwable t) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, t);
        }
    }

    private void safeTruncateStore(@NotNull PersistentStoreTransaction txn, @NotNull String dbName) {
        this.environment.truncateStore(dbName, txn.getEnvironmentTransaction());
    }

    private void deleteObsoleteBlobHandle(long blobHandle, PersistentStoreTransaction txn) {
        if (PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) {
            return;
        }
        this.deleteBlobFileLength(txn, blobHandle);
        txn.deleteBlob(blobHandle);
        txn.deferBlobDeletion(blobHandle);
    }

    private PersistentEntity getEntityAssertPhantomLink(@NotNull PersistentStoreTransaction txn, @NotNull EntityId id) {
        int version = this.getLastVersion(txn, id);
        if (version < 0) {
            throw new PhantomLinkException(this.getEntityType(txn, id.getTypeId()) + '[' + id + ']');
        }
        return new PersistentEntity(this, (PersistentEntityId)id);
    }

    private class BlobFileLengthsIterable
    implements Iterable<Pair<Long, Long>> {
        @NotNull
        private final PersistentStoreTransaction txn;
        private final long fromHandle;

        BlobFileLengthsIterable(PersistentStoreTransaction txn, long fromHandle) {
            this.txn = txn;
            this.fromHandle = fromHandle;
        }

        @NotNull
        public Iterator iterator() {
            return new Iterator();
        }

        private class Iterator
        implements java.util.Iterator<Pair<Long, Long>> {
            final Cursor cursor;
            Pair<Long, Long> next;
            boolean hasMore;

            public Iterator() {
                this.cursor = PersistentEntityStoreImpl.this.blobFileLengths.openCursor(BlobFileLengthsIterable.this.txn.getEnvironmentTransaction());
                if (BlobFileLengthsIterable.this.fromHandle == 0L) {
                    this.hasMore = true;
                    this.next = null;
                } else {
                    boolean bl = this.hasMore = this.cursor.getSearchKeyRange(LongBinding.longToCompressedEntry(BlobFileLengthsIterable.this.fromHandle)) != null;
                    if (this.hasMore) {
                        this.next = this.newNext();
                    }
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (this.hasMore && this.next == null) {
                    if (this.cursor.getNext()) {
                        this.next = this.newNext();
                    } else {
                        this.cursor.close();
                        this.hasMore = false;
                    }
                }
                return this.hasMore;
            }

            @Override
            public Pair<Long, Long> next() {
                if (!this.hasNext()) {
                    return null;
                }
                Pair<Long, Long> result = this.next;
                this.next = null;
                return result;
            }

            @NotNull
            private Pair<Long, Long> newNext() {
                return new Pair<Long, Long>(LongBinding.compressedEntryToLong(this.cursor.getKey()), LongBinding.compressedEntryToLong(this.cursor.getValue()));
            }
        }
    }

    private abstract class TableCreationOperation
    implements FlushLog.Operation {
        private TableCreationOperation() {
        }

        abstract void persist(Transaction var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flushed() {
            Set set = PersistentEntityStoreImpl.this.tableCreationLog;
            synchronized (set) {
                PersistentEntityStoreImpl.this.tableCreationLog.remove(this);
            }
        }
    }

    private class BlobDataGetter
    implements DataGetter {
        private BlobDataGetter() {
        }

        @Override
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction txn, int typeId, PropertyKey key) {
            return PersistentEntityStoreImpl.this.getBlobsTable(txn, typeId).get(txn.getEnvironmentTransaction(), key);
        }
    }

    private class DebugLinkDataGetter
    implements DataGetter {
        private DebugLinkDataGetter() {
        }

        @Override
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction txn, int typeId, PropertyKey key) {
            ByteIterable valueEntry;
            ArrayByteIterable keyEntry = PropertyKey.propertyKeyToEntry(key);
            try (Cursor cursor = PersistentEntityStoreImpl.this.getLinksTable(txn, typeId).getFirstIndexCursor(txn.getEnvironmentTransaction());){
                valueEntry = cursor.getSearchKey(keyEntry);
                if (valueEntry == null) {
                    ByteIterable byteIterable = null;
                    return byteIterable;
                }
                if (cursor.getNextDup()) {
                    throw new IllegalStateException("Only one link is allowed.");
                }
            }
            return valueEntry;
        }
    }

    private class LinkDataGetter
    implements DataGetter {
        @NotNull
        private Pair<Integer, LinksTable> lastUsedTable = new Pair<Integer, Object>(Integer.MIN_VALUE, null);

        private LinkDataGetter() {
        }

        @Override
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction txn, int typeId, @NotNull PropertyKey key) {
            return this.getTable(txn, typeId).get(txn.getEnvironmentTransaction(), PropertyKey.propertyKeyToEntry(key));
        }

        private TwoColumnTable getTable(@NotNull PersistentStoreTransaction txn, int typeId) {
            Pair<Integer, LinksTable> lastUsedTable = this.lastUsedTable;
            if (lastUsedTable.getFirst() == typeId) {
                return lastUsedTable.getSecond();
            }
            LinksTable result = PersistentEntityStoreImpl.this.getLinksTable(txn, typeId);
            this.lastUsedTable = new Pair<Integer, LinksTable>(typeId, result);
            return result;
        }
    }

    private class PropertyDataGetter
    implements DataGetter {
        private PropertyDataGetter() {
        }

        @Override
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction txn, int typeId, PropertyKey key) {
            return PersistentEntityStoreImpl.this.getPropertiesTable(txn, typeId).get(txn, PropertyKey.propertyKeyToEntry(key));
        }
    }

    private static interface DataGetter {
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction var1, int var2, PropertyKey var3);
    }
}

