/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.PriorityQueue;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import jetbrains.exodus.core.execution.locks.CriticalSection;
import org.jetbrains.annotations.NotNull;

public class StablePriorityQueue<P extends Comparable<? super P>, E>
extends PriorityQueue<P, E> {
    private final TreeMap<P, LinkedHashSet<E>> theQueue = new TreeMap();
    private final Map<E, Pair<E, P>> priorities = new HashMap<E, Pair<E, P>>();
    private final AtomicInteger size = new AtomicInteger(0);
    private final CriticalSection criticalSection = new CriticalSection();

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public E push(@NotNull P priority, @NotNull E value) {
        LinkedHashSet<E> values2;
        E oldValue;
        Pair<E, P> oldPair = this.priorities.remove(value);
        this.priorities.put(value, new Pair<E, P>(value, priority));
        this.invalidateSize();
        Comparable oldPriority = oldPair == null ? null : (Comparable)oldPair.getSecond();
        E e = oldValue = oldPair == null ? null : (E)oldPair.getFirst();
        if (oldPriority != null && (values2 = this.theQueue.get(oldPriority)) != null) {
            values2.remove(value);
            if (values2.isEmpty()) {
                this.theQueue.remove(oldPriority);
            }
        }
        if ((values2 = this.theQueue.get(priority)) == null) {
            values2 = new LinkedHashSet();
            this.theQueue.put(priority, values2);
        }
        values2.add(value);
        return oldValue;
    }

    @Override
    public Pair<P, E> peekPair() {
        if (this.priorities.size() == 0) {
            return null;
        }
        TreeMap<P, LinkedHashSet<E>> queue = this.theQueue;
        Comparable priority = (Comparable)queue.lastKey();
        LinkedHashSet<E> values2 = queue.get(priority);
        return new Pair<Comparable, E>(priority, values2.getBack());
    }

    @Override
    public Pair<P, E> floorPair() {
        if (this.priorities.size() == 0) {
            return null;
        }
        TreeMap<P, LinkedHashSet<E>> queue = this.theQueue;
        Comparable priority = (Comparable)queue.firstKey();
        LinkedHashSet<E> values2 = queue.get(priority);
        return new Pair<Comparable, E>(priority, values2.getTop());
    }

    @Override
    public E pop() {
        if (this.priorities.size() == 0) {
            return null;
        }
        TreeMap<P, LinkedHashSet<E>> queue = this.theQueue;
        Comparable priority = (Comparable)queue.lastKey();
        Set values2 = queue.get(priority);
        Object result = values2.iterator().next();
        this.priorities.remove(result);
        this.invalidateSize();
        values2.remove(result);
        if (values2.isEmpty()) {
            queue.remove(priority);
        }
        return result;
    }

    @Override
    public void clear() {
        try (CriticalSection ignored = this.lock();){
            this.theQueue.clear();
            this.priorities.clear();
            this.size.set(0);
        }
    }

    @Override
    public CriticalSection lock() {
        return this.criticalSection.enter();
    }

    @Override
    public void unlock() {
        this.criticalSection.unlock();
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new QueueIterator();
    }

    public boolean remove(@NotNull E value) {
        Pair<E, P> pair = this.priorities.remove(value);
        if (pair == null) {
            return false;
        }
        this.invalidateSize();
        Comparable priority = (Comparable)pair.getSecond();
        LinkedHashSet<E> values2 = this.theQueue.get(priority);
        values2.remove(value);
        if (values2.isEmpty()) {
            this.theQueue.remove(priority);
        }
        return true;
    }

    private void invalidateSize() {
        this.size.set(this.priorities.size());
    }

    private class QueueIterator
    implements Iterator<E> {
        @NotNull
        private final Iterator<Map.Entry<P, LinkedHashSet<E>>> priorityIt;
        @NotNull
        private Iterator<E> currentIt;

        private QueueIterator() {
            this.priorityIt = StablePriorityQueue.this.theQueue.descendingMap().entrySet().iterator();
            this.currentIt = Collections.EMPTY_LIST.iterator();
            this.checkCurrentIterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentIt.hasNext();
        }

        @Override
        public E next() {
            Object result = this.currentIt.next();
            this.checkCurrentIterator();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void checkCurrentIterator() {
            while (!this.currentIt.hasNext() && this.priorityIt.hasNext()) {
                Map.Entry next = this.priorityIt.next();
                this.currentIt = next.getValue().iterator();
            }
        }
    }
}

