/*_############################################################################
  _## 
  _##  SNMP4J-Agent 3 - MOScopePriorityComparatorTest.java  
  _## 
  _##  Copyright (C) 2005-2025  Frank Fock (SNMP4J.org)
  _##  
  _##  Licensed under the Apache License, Version 2.0 (the "License");
  _##  you may not use this file except in compliance with the License.
  _##  You may obtain a copy of the License at
  _##  
  _##      http://www.apache.org/licenses/LICENSE-2.0
  _##  
  _##  Unless required by applicable law or agreed to in writing, software
  _##  distributed under the License is distributed on an "AS IS" BASIS,
  _##  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  _##  See the License for the specific language governing permissions and
  _##  limitations under the License.
  _##  
  _##########################################################################*/
package org.snmp4j.agent.util;

import org.junit.Test;
import org.snmp4j.agent.DefaultMOScope;
import org.snmp4j.agent.MOScope;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.OID;

import java.util.TreeMap;

import static org.junit.Assert.*;

public class MOScopePriorityComparatorTest {

    @Test
    public void compare() {
        OID enterprise = new OID("1.3.6.4.1");
        OID mgmt = new OID("1.3.6.1.2.1");
        OID system = SnmpConstants.system;
        OID three = new OID("1.3.6.3");
        OID threeOne = new OID("1.3.6.3.1");
        OID sysDescr = SnmpConstants.sysDescr;
        TreeMap<OID, Integer> prioMap = new TreeMap<>();
        prioMap.put(mgmt, 0);
        prioMap.put(enterprise, 1);
        prioMap.put(system, 10);
        MOScopePriorityComparator priorityComparator = new MOScopePriorityComparator(prioMap);
        assertTrue(priorityComparator.compare(
                new DefaultMOScope(sysDescr, true, enterprise, false),
                new DefaultMOScope(SnmpConstants.snmp4jStatsResponseIgnoredRetries, true,
                                   SnmpConstants.snmp4jStatsResponseIgnoredRetries, true)) < 0);
        assertTrue(priorityComparator.compare(
                new DefaultMOScope(sysDescr, true, enterprise, false),
                new DefaultMOScope(SnmpConstants.snmp4jStatsResponseIgnoredRetries, true,
                        SnmpConstants.snmp4jStatsResponseIgnoredRetries, true)) < 0);
        assertTrue(priorityComparator.compare(
                new DefaultMOScope(three, true, three, false),
                new DefaultMOScope(SnmpConstants.snmp4jStatsResponseIgnoredRetries, true,
                        SnmpConstants.snmp4jStatsResponseIgnoredRetries, true)) > 0);
        assertEquals(0, priorityComparator.compare(
                new DefaultMOScope(three, true, three, false),
                new DefaultMOScope(three, true, three, false)));
        assertTrue(priorityComparator.compare(
                new DefaultMOScope(three, true, three, false),
                new DefaultMOScope(threeOne, true, threeOne, false)) < 0);
        assertTrue(priorityComparator.compare(
                new DefaultMOScope(threeOne, true, threeOne, false),
                new DefaultMOScope(three, true, three, false)) > 0);
        assertTrue(priorityComparator.compare(
                new DefaultMOScope(sysDescr, true, sysDescr, true),
                new DefaultMOScope(SnmpConstants.snmpInPkts, true, SnmpConstants.snmpInPkts, true)) > 0);
        assertTrue(priorityComparator.compare(
                new DefaultMOScope(new OID(), true, three, false),
                new DefaultMOScope(new OID("1"), true, threeOne, false)) < 0);
        assertTrue(priorityComparator.compare(
                new DefaultMOScope(new OID("3"), true, new OID("3"), false),
                new DefaultMOScope(new OID("1"), true, new OID("2"), false)) > 0);
    }
}