/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.mo.snmp;

import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOAccess;
import org.snmp4j.agent.MOGroup;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.mo.DefaultMOFactory;
import org.snmp4j.agent.mo.MOFactory;
import org.snmp4j.agent.mo.MOScalar;
import org.snmp4j.agent.mo.MOValueValidationEvent;
import org.snmp4j.agent.mo.MOValueValidationListener;
import org.snmp4j.agent.mo.snmp.tc.TruthValueTC;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.DefaultCounterListener;
import org.snmp4j.security.TSM;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;

public class SnmpTsmMib
implements MOGroup {
    private static final LogAdapter LOGGER = LogFactory.getLogger(SnmpTsmMib.class);
    private MOFactory moFactory = DefaultMOFactory.getInstance();
    public static final OID oidSnmpTsmMib = new OID(new int[]{1, 3, 6, 1, 2, 1, 190});
    public static final OID oidSnmpTsmInvalidCaches = new OID(new int[]{1, 3, 6, 1, 2, 1, 190, 1, 1, 1, 0});
    public static final OID oidSnmpTsmInadequateSecurityLevels = new OID(new int[]{1, 3, 6, 1, 2, 1, 190, 1, 1, 2, 0});
    public static final OID oidSnmpTsmUnknownPrefixes = new OID(new int[]{1, 3, 6, 1, 2, 1, 190, 1, 1, 3, 0});
    public static final OID oidSnmpTsmInvalidPrefixes = new OID(new int[]{1, 3, 6, 1, 2, 1, 190, 1, 1, 4, 0});
    public static final OID oidSnmpTsmConfigurationUsePrefix = new OID(new int[]{1, 3, 6, 1, 2, 1, 190, 1, 2, 1, 0});
    private static final String TC_MODULE_SNMPV2_TC = "SNMPv2-TC";
    private static final String TC_TRUTHVALUE = "TruthValue";
    private MOScalar<Counter32> snmpTsmInvalidCaches;
    private MOScalar<Counter32> snmpTsmInadequateSecurityLevels;
    private MOScalar<Counter32> snmpTsmUnknownPrefixes;
    private MOScalar<Counter32> snmpTsmInvalidPrefixes;
    private MOScalar<Integer32> snmpTsmConfigurationUsePrefix;
    private TSM tsm;
    private DefaultCounterListener counterListener = new DefaultCounterListener();

    protected SnmpTsmMib() {
        this.counterListener.setCountRegisteredOnly(true);
    }

    public SnmpTsmMib(MOFactory moFactory) {
        this();
        this.createMO(moFactory);
        this.counterListener.add(this.snmpTsmInvalidCaches.getOid(), this.snmpTsmInvalidCaches.getValue());
        this.counterListener.add(this.snmpTsmInadequateSecurityLevels.getOid(), this.snmpTsmInadequateSecurityLevels.getValue());
        this.counterListener.add(this.snmpTsmUnknownPrefixes.getOid(), this.snmpTsmUnknownPrefixes.getValue());
        this.counterListener.add(this.snmpTsmInvalidPrefixes.getOid(), this.snmpTsmInvalidPrefixes.getValue());
    }

    protected void createMO(MOFactory moFactory) {
        this.addTCsToFactory(moFactory);
        this.snmpTsmInvalidCaches = moFactory.createScalar(oidSnmpTsmInvalidCaches, moFactory.createAccess(9), new Counter32());
        this.snmpTsmInadequateSecurityLevels = moFactory.createScalar(oidSnmpTsmInadequateSecurityLevels, moFactory.createAccess(9), new Counter32());
        this.snmpTsmUnknownPrefixes = moFactory.createScalar(oidSnmpTsmUnknownPrefixes, moFactory.createAccess(9), new Counter32());
        this.snmpTsmInvalidPrefixes = moFactory.createScalar(oidSnmpTsmInvalidPrefixes, moFactory.createAccess(9), new Counter32());
        this.snmpTsmConfigurationUsePrefix = new SnmpTsmConfigurationUsePrefix(oidSnmpTsmConfigurationUsePrefix, moFactory.createAccess(11));
        this.snmpTsmConfigurationUsePrefix.addMOValueValidationListener(new SnmpTsmConfigurationUsePrefixValidator());
    }

    public MOScalar<Counter32> getSnmpTsmInvalidCaches() {
        return this.snmpTsmInvalidCaches;
    }

    public MOScalar<Counter32> getSnmpTsmInadequateSecurityLevels() {
        return this.snmpTsmInadequateSecurityLevels;
    }

    public MOScalar<Counter32> getSnmpTsmUnknownPrefixes() {
        return this.snmpTsmUnknownPrefixes;
    }

    public MOScalar<Counter32> getSnmpTsmInvalidPrefixes() {
        return this.snmpTsmInvalidPrefixes;
    }

    public MOScalar<Integer32> getSnmpTsmConfigurationUsePrefix() {
        return this.snmpTsmConfigurationUsePrefix;
    }

    @Override
    public void registerMOs(MOServer server, OctetString context) throws DuplicateRegistrationException {
        server.register(this.snmpTsmInvalidCaches, context);
        server.register(this.snmpTsmInadequateSecurityLevels, context);
        server.register(this.snmpTsmUnknownPrefixes, context);
        server.register(this.snmpTsmInvalidPrefixes, context);
        server.register(this.snmpTsmConfigurationUsePrefix, context);
    }

    @Override
    public void unregisterMOs(MOServer server, OctetString context) {
        server.unregister(this.snmpTsmInvalidCaches, context);
        server.unregister(this.snmpTsmInadequateSecurityLevels, context);
        server.unregister(this.snmpTsmUnknownPrefixes, context);
        server.unregister(this.snmpTsmInvalidPrefixes, context);
        server.unregister(this.snmpTsmConfigurationUsePrefix, context);
    }

    public TSM getTsm() {
        return this.tsm;
    }

    public void setTsm(TSM tsm) {
        if (this.tsm != null) {
            this.tsm.getCounterSupport().removeCounterListener((CounterListener)this.counterListener);
        }
        this.tsm = tsm;
        this.tsm.getCounterSupport().addCounterListener((CounterListener)this.counterListener);
        tsm.setUsePrefix(TruthValueTC.getBooleanValue(this.snmpTsmConfigurationUsePrefix.getValue()));
    }

    protected void addTCsToFactory(MOFactory moFactory) {
    }

    public void addImportedTCsToFactory(MOFactory moFactory) {
    }

    public class SnmpTsmConfigurationUsePrefix
    extends MOScalar<Integer32> {
        SnmpTsmConfigurationUsePrefix(OID oid, MOAccess access) {
            super(oid, access, new Integer32());
        }

        @Override
        public int isValueOK(SubRequest<?> request) {
            Variable newValue = request.getVariableBinding().getVariable();
            int valueOK = super.isValueOK(request);
            if (valueOK != 0) {
                return valueOK;
            }
            return valueOK;
        }

        @Override
        public Integer32 getValue() {
            return (Integer32)super.getValue();
        }

        @Override
        public int setValue(Integer32 newValue) {
            TSM tsmCopy = SnmpTsmMib.this.tsm;
            if (tsmCopy != null) {
                tsmCopy.setUsePrefix(TruthValueTC.getBooleanValue(newValue));
            }
            return super.setValue(newValue);
        }
    }

    static class SnmpTsmConfigurationUsePrefixValidator
    implements MOValueValidationListener {
        SnmpTsmConfigurationUsePrefixValidator() {
        }

        @Override
        public void validate(MOValueValidationEvent validationEvent) {
            Variable newValue = validationEvent.getNewValue();
        }
    }
}

