/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.io;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.snmp4j.agent.io.Context;
import org.snmp4j.agent.io.IndexedVariables;
import org.snmp4j.agent.io.MOInfo;
import org.snmp4j.agent.io.MOInput;
import org.snmp4j.agent.io.Sequence;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Variable;

public class DefaultMOInput
implements MOInput {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultMOInput.class);
    private int importMode;
    private ObjectInputStream ois;

    public DefaultMOInput(ObjectInputStream ois) {
        this.ois = ois;
    }

    @Override
    public int getImportMode() {
        return this.importMode;
    }

    @Override
    public Context readContext() throws IOException {
        try {
            return (Context)this.ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            logger.error((Serializable)((Object)("Failed to load Context: " + ex.getMessage())));
            return null;
        }
    }

    @Override
    public IndexedVariables readIndexedVariables() throws IOException {
        try {
            return (IndexedVariables)this.ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            logger.error((Serializable)((Object)("Failed to load IndexedVariables: " + ex.getMessage())));
            return null;
        }
    }

    @Override
    public MOInfo readManagedObject() throws IOException {
        try {
            return (MOInfo)this.ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            logger.error((Serializable)((Object)("Failed to load MOInfo: " + ex.getMessage())));
            return null;
        }
    }

    @Override
    public Sequence readSequence() throws IOException {
        try {
            return (Sequence)this.ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            logger.error((Serializable)((Object)("Failed to load Sequence: " + ex.getMessage())));
            return null;
        }
    }

    @Override
    public Variable readVariable() throws IOException {
        try {
            return (Variable)this.ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            logger.error((Serializable)((Object)("Failed to load Variable: " + ex.getMessage())));
            return null;
        }
    }

    @Override
    public void skipContext(Context context) throws IOException {
        Object next = null;
        try {
            next = this.ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            logger.error((Serializable)((Object)("Failed to skip Context: " + ex.getMessage())));
        }
        while (!(next instanceof Context) || !((Context)next).equals(context)) {
            try {
                next = this.ois.readObject();
            }
            catch (ClassNotFoundException ex1) {
                logger.error((Serializable)((Object)("Failed to skip Context: " + ex1.getMessage())));
            }
        }
    }

    @Override
    public void skipManagedObject(MOInfo moInfo) throws IOException {
        Object next = null;
        try {
            next = this.ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            logger.error((Serializable)((Object)("Failed to skip Context: " + ex.getMessage())));
        }
        while (!(next instanceof MOInfo) || !((MOInfo)next).equals(moInfo)) {
            try {
                next = this.ois.readObject();
            }
            catch (ClassNotFoundException ex1) {
                logger.error((Serializable)((Object)("Failed to skip Context: " + ex1.getMessage())));
            }
        }
    }

    public void setOverwriteMode(int importMode) {
        this.importMode = importMode;
    }

    @Override
    public void close() throws IOException {
        this.ois.close();
    }
}

