/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.snmp4j.agent.ContextEvent;
import org.snmp4j.agent.ContextListener;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.DuplicateRegistrationException;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOScopeComparator;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.MOServerLookupListener;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.ManagedObjectValueAccess;
import org.snmp4j.agent.RegisteredManagedObject;
import org.snmp4j.agent.UpdatableManagedObject;
import org.snmp4j.agent.UpdateStrategy;
import org.snmp4j.agent.mo.ChangeableManagedObject;
import org.snmp4j.agent.mo.MOChangeListener;
import org.snmp4j.agent.mo.MOColumn;
import org.snmp4j.agent.mo.MOFilter;
import org.snmp4j.agent.mo.MOTable;
import org.snmp4j.agent.mo.MOTableModel;
import org.snmp4j.agent.mo.MOTableRow;
import org.snmp4j.agent.mo.MOTableRowListener;
import org.snmp4j.agent.mo.lock.DefaultMOLockStrategy;
import org.snmp4j.agent.mo.lock.LockRequest;
import org.snmp4j.agent.mo.lock.MOLockStrategy;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class DefaultMOServer
implements MOServer {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultMOServer.class);
    private final Set<OctetString> contexts;
    private final SortedMap<MOScope, ManagedObject<?>> registry;
    private final Map<ManagedObject<?>, Lock> lockList;
    private Map<ManagedObject<?>, List<MOServerLookupListener>> lookupListener;
    private transient List<ContextListener> contextListeners;
    private UpdateStrategy updateStrategy;
    private MOLockStrategy lockStrategy = new DefaultMOLockStrategy();
    private boolean deadlockPreventionEnabled = false;
    private Lock superLock;
    private final Map<LockRequest, Integer> waitingLockRequests = new WeakHashMap<LockRequest, Integer>();
    private final Map<LockRequest, Integer> activeLockRequests = new WeakHashMap<LockRequest, Integer>();

    public DefaultMOServer() {
        this.registry = new TreeMap(new MOScopeComparator());
        this.contexts = new LinkedHashSet<OctetString>(10);
        this.lockList = new Hashtable(10);
    }

    public ManagedObject lookup(MOQuery query) {
        return this.lookup(query, false, null, new MOServerLookupEvent(this, null, query, MOServerLookupEvent.IntendedUse.undefined), ManagedObject.class);
    }

    @Override
    public <MO extends ManagedObject<?>> MO lookup(MOQuery query, LockRequest lockRequest, MOServerLookupEvent lookupEvent, Class<MO> managedObjectType) {
        return this.lookup(query, false, lockRequest, lookupEvent, managedObjectType);
    }

    public MOLockStrategy getLockStrategy() {
        return this.lockStrategy;
    }

    public void setLockStrategy(MOLockStrategy lockStrategy) {
        this.lockStrategy = lockStrategy;
    }

    private <MO extends ManagedObject<?>> MO lookup(MOQuery query, boolean specificRegistrationsOnly, LockRequest lockRequest, MOServerLookupEvent event, Class<MO> managedObjectType) {
        SortedMap<MOScope, ManagedObject<?>> scope = this.registry.tailMap(query);
        boolean timedOut = false;
        if (lockRequest != null) {
            lockRequest.setLockRequestStatus(LockRequest.LockStatus.notRequired);
        }
        for (Map.Entry<MOScope, ManagedObject<?>> entry : scope.entrySet()) {
            MOScope key = entry.getKey();
            if (!MOScopeComparator.isQueryContextMatching(query, key) || specificRegistrationsOnly && (!(key instanceof MOContextScope) || ((MOContextScope)key).getContext() == null)) continue;
            ManagedObject<?> managedObject = entry.getValue();
            MOScope moScope = managedObject.getScope();
            if (!managedObjectType.isInstance(managedObject) || !query.getScope().isOverlapping(moScope)) continue;
            ManagedObject mo = (ManagedObject)managedObjectType.cast(managedObject);
            event.setLookupResult(mo);
            this.fireQueryEvent(mo, event);
            if (this.lockStrategy != null && lockRequest != null && lockRequest.getLockOwner() != null && this.lockStrategy.isLockNeeded(mo, query)) {
                if (!this.lock(lockRequest.getLockOwner(), mo, lockRequest.getTimeoutMillis(), lockRequest)) {
                    timedOut = true;
                    continue;
                }
                lockRequest.setLockRequestStatus(timedOut ? LockRequest.LockStatus.lockedAfterTimeout : LockRequest.LockStatus.locked);
            }
            if (mo instanceof UpdatableManagedObject) {
                this.checkForUpdate((UpdatableManagedObject)mo, query);
            }
            if (query.matchesQuery(mo)) {
                event.setLookupResult(mo);
                this.fireLookupEvent(mo, event);
                return (MO)mo;
            }
            if (lockRequest == null) continue;
            this.unlock(lockRequest.getLockOwner(), mo);
        }
        if (timedOut) {
            lockRequest.setLockRequestStatus(LockRequest.LockStatus.lockTimedOut);
        }
        return null;
    }

    protected void checkForUpdate(UpdatableManagedObject<?> mo, MOQuery query) {
        if (this.updateStrategy != null && this.updateStrategy.isUpdateNeeded(this, mo, query)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Updating UpdatableManagedObject " + String.valueOf(mo) + " on behalf of query " + String.valueOf(query))));
            }
            mo.update(query);
        }
    }

    public ManagedObject<?> getManagedObject(OID key, OctetString context, boolean fireLookupEvents) {
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        DefaultMOQuery query = new DefaultMOQuery(scope);
        SortedMap<MOScope, ManagedObject<?>> reducedScope = this.registry.tailMap(query);
        for (Map.Entry<MOScope, ManagedObject<?>> entry : reducedScope.entrySet()) {
            ManagedObject<?> mo;
            MOScope compareScope = entry.getKey();
            if (!MOScopeComparator.isQueryContextMatching(query, compareScope) || (!((mo = entry.getValue()) instanceof RegisteredManagedObject) || !((RegisteredManagedObject)mo).getID().equals((Object)key)) && (mo instanceof RegisteredManagedObject || !key.equals((Object)mo.getScope().getLowerBound()))) continue;
            if (fireLookupEvents) {
                MOServerLookupEvent event = new MOServerLookupEvent(this, mo, query, MOServerLookupEvent.IntendedUse.undefined);
                this.fireQueryEvent(mo, event);
                boolean locked = false;
                if (mo instanceof UpdatableManagedObject && (locked = this.lock(this, mo))) {
                    this.checkForUpdate((UpdatableManagedObject)mo, query);
                }
                this.fireLookupEvent(mo, event);
                if (locked) {
                    this.unlock(this, mo);
                }
            }
            return mo;
        }
        return null;
    }

    public ManagedObject<?> getManagedObject(OID key, OctetString context) {
        return this.getManagedObject(key, context, true);
    }

    public static Variable getValue(MOServer server, OctetString context, OID key) {
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        MOServerLookupEvent lookupEvent = new MOServerLookupEvent(server, null, new DefaultMOQuery(scope), MOServerLookupEvent.IntendedUse.get, true);
        ManagedObject<?> mo = server.lookup(lookupEvent.getQuery(), null, lookupEvent);
        if (mo instanceof ManagedObjectValueAccess) {
            Variable variable = ((ManagedObjectValueAccess)mo).getValue(key);
            lookupEvent.completedUse(variable);
            return variable;
        }
        return null;
    }

    public static boolean setValue(MOServer server, OctetString context, VariableBinding newValueAndKey) {
        OID key = newValueAndKey.getOid();
        DefaultMOContextScope scope = new DefaultMOContextScope(context, key, true, key, true);
        MOServerLookupEvent lookupEvent = new MOServerLookupEvent(server, null, new DefaultMOQuery(scope), MOServerLookupEvent.IntendedUse.update, true);
        ManagedObject<?> mo = server.lookup(lookupEvent.getQuery(), null, lookupEvent);
        if (mo instanceof ManagedObjectValueAccess) {
            boolean variableSet = ((ManagedObjectValueAccess)mo).setValue(newValueAndKey);
            if (variableSet) {
                lookupEvent.completedUse(newValueAndKey);
            } else {
                lookupEvent.completedUse(null);
            }
            return variableSet;
        }
        lookupEvent.completedUse(null);
        return false;
    }

    protected void fireLookupEvent(ManagedObject<?> mo, MOServerLookupEvent event) {
        if (this.lookupListener != null) {
            List<MOServerLookupListener> l = this.lookupListener.get(mo);
            if (l != null) {
                this.callLookupListeners(event, l);
            }
            if ((l = this.lookupListener.get(null)) != null) {
                this.callLookupListeners(event, l);
            }
        }
    }

    private void callLookupListeners(MOServerLookupEvent event, List<MOServerLookupListener> l) {
        ArrayList<MOServerLookupListener> listCopy = new ArrayList<MOServerLookupListener>(l);
        for (MOServerLookupListener item : listCopy) {
            item.lookupEvent(event);
        }
    }

    protected void fireQueryEvent(ManagedObject<?> mo, MOServerLookupEvent event) {
        List<MOServerLookupListener> l;
        if (this.lookupListener != null && (l = this.lookupListener.get(mo)) != null) {
            l = new ArrayList<MOServerLookupListener>(l);
            for (MOServerLookupListener item : l) {
                item.queryEvent(event);
            }
        }
    }

    @Override
    public OctetString[] getContexts() {
        return this.contexts.toArray(new OctetString[0]);
    }

    @Override
    public boolean isContextSupported(OctetString context) {
        if (context == null || context.length() == 0) {
            return true;
        }
        return this.contexts.contains(context);
    }

    public SortedMap<MOScope, ManagedObject<?>> getRegistry() {
        return this.registry;
    }

    public UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public DefaultMOServer setUpdateStrategy(UpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
        return this;
    }

    @Override
    public void register(ManagedObject<?> mo, OctetString context) throws DuplicateRegistrationException {
        if (context == null || context.length() == 0) {
            MOServerLookupEvent lookupEvent;
            DefaultMOContextScope contextScope = new DefaultMOContextScope(null, mo.getScope());
            ManagedObject<?> other = this.lookup(new DefaultMOQuery(contextScope), null, lookupEvent = new MOServerLookupEvent(this, mo, new DefaultMOQuery(contextScope), MOServerLookupEvent.IntendedUse.register));
            if (other != null) {
                throw new DuplicateRegistrationException(contextScope, other.getScope());
            }
            this.registry.put(mo.getScope(), mo);
            if (logger.isInfoEnabled()) {
                logger.info((CharSequence)("Registered MO [" + mo.getClass().getSimpleName() + "] in default context with scope " + String.valueOf(mo.getScope())));
            }
        } else {
            DefaultMOContextScope contextScope = new DefaultMOContextScope(context, mo.getScope());
            MOServerLookupEvent lookupEvent = new MOServerLookupEvent(this, mo, new DefaultMOQuery(contextScope), MOServerLookupEvent.IntendedUse.register);
            ManagedObject other = this.lookup(lookupEvent.getQuery(), true, null, lookupEvent, ManagedObject.class);
            if (other != null) {
                throw new DuplicateRegistrationException(contextScope, other.getScope());
            }
            this.registry.put(contextScope, mo);
            if (logger.isInfoEnabled()) {
                logger.info((CharSequence)("Registered MO [" + mo.getClass().getSimpleName() + "] in context " + String.valueOf(context) + " with scope " + String.valueOf(contextScope)));
            }
        }
    }

    @Override
    public ManagedObject<?> unregister(ManagedObject<?> mo, OctetString context) {
        MOScope key = context == null || context.length() == 0 ? mo.getScope() : new DefaultMOContextScope(context, mo.getScope());
        ManagedObject<?> r = (ManagedObject<?>)this.registry.remove(key);
        if (r == null) {
            SortedMap<MOScope, ManagedObject<?>> tailMap = this.registry.tailMap(key);
            Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = tailMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MOScope, ManagedObject<?>> entry = it.next();
                MOScope entryKey = entry.getKey();
                if (!entry.getValue().equals(mo) || context != null && (!(entryKey instanceof MOContextScope) || !context.equals((Object)((MOContextScope)entryKey).getContext()))) continue;
                r = entry.getValue();
                it.remove();
                break;
            }
        }
        if (r != null) {
            MOServerLookupEvent event = new MOServerLookupEvent(this, r, new DefaultMOQuery(key instanceof MOContextScope ? (MOContextScope)key : new DefaultMOContextScope(null, key)), MOServerLookupEvent.IntendedUse.unregister);
            this.fireLookupEvent(r, event);
        }
        if (logger.isInfoEnabled()) {
            if (r != null) {
                logger.info((CharSequence)("Removed registration " + String.valueOf(r) + " for " + String.valueOf(mo.getScope()) + " in context '" + String.valueOf(context) + "' successfully"));
            } else {
                logger.warn((Serializable)((Object)("Removing registration failed for " + String.valueOf(mo.getScope()) + " in context '" + String.valueOf(context) + "'")));
            }
        }
        return r;
    }

    @Override
    public void addContext(OctetString context) {
        this.contexts.add(context);
        this.fireContextChanged(new ContextEvent(this, 1, context));
    }

    @Override
    public void removeContext(OctetString context) {
        this.contexts.remove(context);
        this.fireContextChanged(new ContextEvent(this, 2, context));
    }

    @Override
    public boolean lock(Object owner, ManagedObject<?> managedObject) {
        return this.lock(owner, managedObject, 0L, new LockRequest(owner, 0L));
    }

    @Override
    public boolean lock(Object owner, ManagedObject<?> managedObject, long timeoutMillis) {
        return this.lock(owner, managedObject, timeoutMillis, new LockRequest(owner, timeoutMillis));
    }

    public synchronized void resetLocks() {
        this.waitingLockRequests.clear();
        this.activeLockRequests.clear();
        this.lockList.clear();
        this.superLock = null;
        this.notifyAll();
    }

    @Override
    public synchronized boolean waitForUnlockedState(long waitTimeoutMillis) {
        if (logger.isInfoEnabled()) {
            logger.info((CharSequence)("Waiting for unlocked state with timeout millis " + waitTimeoutMillis + ", active locks: " + String.valueOf(this.lockList) + ", waitingLockRequests: " + String.valueOf(this.waitingLockRequests)));
        }
        long waitStart = System.nanoTime();
        while (!(this.lockList.isEmpty() && this.waitingLockRequests.isEmpty() || waitTimeoutMillis > 0L && System.nanoTime() - waitStart <= TimeUnit.MICROSECONDS.toNanos(waitTimeoutMillis))) {
            try {
                if (waitTimeoutMillis <= 0L) {
                    this.wait(0L);
                    continue;
                }
                long waitTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - waitStart);
                this.wait(waitTime);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((CharSequence)("Finished waiting for unlocked state in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - waitStart) + "ms, active locks: " + String.valueOf(this.lockList) + ", waitingLockRequests: " + String.valueOf(this.waitingLockRequests)));
        }
        return this.lockList.isEmpty() && this.waitingLockRequests.isEmpty();
    }

    public Map<LockRequest, Integer> getWaitingLockRequests() {
        return Collections.unmodifiableMap(this.waitingLockRequests);
    }

    public Map<LockRequest, Integer> getActiveLockRequests() {
        return Collections.unmodifiableMap(this.activeLockRequests);
    }

    public synchronized boolean lock(Object owner, ManagedObject<?> managedObject, long timeoutMillis, LockRequest lockRequest) {
        long start = System.nanoTime();
        lockRequest.setLockRequestStatus(LockRequest.LockStatus.lockRequired);
        do {
            if (this.deadlockPreventionEnabled && this.superLock != null && this.superLock.getOwner() != owner) {
                if (this.waitForLock(managedObject, timeoutMillis, this.superLock, start)) continue;
                return false;
            }
            if (this.deadlockPreventionEnabled && this.superLock != null && this.superLock.getOwner() == owner) {
                this.superLock.add();
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Acquired super lock " + String.valueOf(this.superLock) + " on " + String.valueOf(managedObject) + " for " + String.valueOf(owner))));
                }
                return true;
            }
            if (this.superLock != null) continue;
            Lock lock = this.lockList.get(managedObject);
            if (lock == null || lock.getOwner() != owner && lock.getCount() <= 0) {
                Lock newLock = new Lock(lockRequest);
                lockRequest.setLockRequestStatus(LockRequest.LockStatus.locked);
                this.lockList.put(managedObject, newLock);
                if (this.deadlockPreventionEnabled) {
                    this.incLockRequestCounter(this.activeLockRequests, lockRequest);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Acquired lock " + String.valueOf(newLock) + " on " + String.valueOf(managedObject) + " for " + String.valueOf(owner) + " (waiting=" + this.waitingLockRequests.size() + ",active=" + this.activeLockRequests.size() + ")")));
                }
                return true;
            }
            if (lock.getOwner() != owner) {
                int waitingCount = this.waitingLockRequests.size() + 1;
                int activeCount = this.activeLockRequests.size();
                if (this.deadlockPreventionEnabled && !this.waitingLockRequests.isEmpty() && waitingCount >= activeCount) {
                    switch (lock.getLockRequest().getLockRequestStatus()) {
                        case waitingForLock: 
                        case lockRequired: 
                        case unlocked: {
                            this.superLock = new Lock(lockRequest);
                            lockRequest.setLockRequestStatus(LockRequest.LockStatus.locked);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Serializable)((Object)("Deadlock condition detected on " + String.valueOf(lock) + " (waiting=" + waitingCount + " >= active=" + activeCount + ", acquired super " + String.valueOf(this.superLock) + " for " + String.valueOf(owner))));
                            }
                            return true;
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Waiting for running thread on " + String.valueOf(lock) + " to unlock it before entering in super lock mode, waitingCount=" + this.waitingLockRequests.size() + ", activeCount=" + this.activeLockRequests.size())));
                    }
                    lockRequest.setLockRequestStatus(LockRequest.LockStatus.waitingForLock);
                    if (this.waitForLock(managedObject, timeoutMillis, lock, start)) continue;
                    return false;
                }
                lockRequest.setLockRequestStatus(LockRequest.LockStatus.waitingForLock);
                if (!this.waitForLock(managedObject, timeoutMillis, lock, start)) break;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Serializable)((Object)("Waiting thread on " + String.valueOf(lock) + " was notified, waitingCount=" + this.waitingLockRequests.size() + ", activeCount=" + this.activeLockRequests.size())));
                continue;
            }
            lock.add();
            if (this.deadlockPreventionEnabled) {
                this.incLockRequestCounter(this.activeLockRequests, lockRequest);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Added lock on " + String.valueOf(managedObject) + " for " + String.valueOf(owner))));
            }
            return true;
        } while (timeoutMillis <= 0L || (System.nanoTime() - start) / 1000000L < timeoutMillis);
        return false;
    }

    private synchronized void incLockRequestCounter(Map<LockRequest, Integer> counter, LockRequest lockRequest) {
        int counterValue = counter.getOrDefault(lockRequest, 0);
        counter.put(lockRequest, ++counterValue);
    }

    private synchronized void decLockRequestCounter(Map<LockRequest, Integer> counter, LockRequest lockRequest) {
        counter.computeIfPresent(lockRequest, (lr, counterValue) -> {
            int updatedCount = counterValue - 1;
            if (updatedCount <= 0) {
                return null;
            }
            return updatedCount;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean waitForLock(ManagedObject<?> managedObject, long timeoutMillis, Lock lock, long start) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Waiting for " + String.valueOf(lock) + " on " + String.valueOf(managedObject) + " with timeout (ms) " + timeoutMillis)));
            }
            if (this.deadlockPreventionEnabled && lock != this.superLock) {
                this.incLockRequestCounter(this.waitingLockRequests, lock.getLockRequest());
            }
            if (timeoutMillis <= 0L) {
                this.wait();
            } else {
                this.wait(Math.max(timeoutMillis - (System.nanoTime() - start) / 1000000L, 1L));
            }
        }
        catch (InterruptedException ex) {
            logger.warn((Serializable)((Object)("Waiting for lock " + String.valueOf(lock) + " on " + String.valueOf(managedObject) + " has been interrupted!")));
            boolean bl = false;
            return bl;
        }
        finally {
            if (this.deadlockPreventionEnabled && lock != this.superLock) {
                this.decLockRequestCounter(this.waitingLockRequests, lock.getLockRequest());
            }
        }
        return true;
    }

    @Override
    public synchronized boolean unlockNow(Object owner, ManagedObject<?> managedObject) {
        return this.unlock(owner, managedObject, true);
    }

    @Override
    public synchronized boolean unlock(Object owner, ManagedObject<?> managedObject) {
        return this.unlock(owner, managedObject, false);
    }

    protected synchronized boolean unlock(Object owner, ManagedObject<?> managedObject, boolean forceUnlock) {
        if (managedObject != null) {
            Lock lock = this.lockList.get(managedObject);
            if (lock != null) {
                if (lock.getOwner() != owner) {
                    if (this.superLock == null && logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Object '" + String.valueOf(owner) + "' is not owner of lock: " + String.valueOf(lock))));
                    }
                } else if (lock.remove() || forceUnlock) {
                    this.lockList.remove(managedObject);
                    if (this.deadlockPreventionEnabled && lock != this.superLock) {
                        this.decLockRequestCounter(this.activeLockRequests, lock.getLockRequest());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Removed " + String.valueOf(lock) + " on " + String.valueOf(managedObject) + " by " + String.valueOf(owner))));
                    }
                    this.notifyAll();
                    return true;
                }
            }
            if (this.superLock != null && this.superLock.getOwner() == owner) {
                this.superLock.remove();
                if (this.superLock.getCount() <= 0 || forceUnlock) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("End of deadlock prevention: Removed super lock " + String.valueOf(this.superLock) + " on " + String.valueOf(managedObject) + " by " + String.valueOf(owner))));
                    }
                    this.superLock = null;
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Removed super lock " + String.valueOf(this.superLock) + " on " + String.valueOf(managedObject) + " by " + String.valueOf(owner))));
                }
                this.notifyAll();
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<Map.Entry<MOScope, ManagedObject<?>>> iterator() {
        return this.iterator(new MOScopeComparator(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Iterator<Map.Entry<MOScope, ManagedObject<?>>> iterator(Comparator<MOScope> comparator, MOFilter moFilter) {
        SortedMap<MOScope, ManagedObject<?>> sortedMap = this.registry;
        synchronized (sortedMap) {
            TreeMap r = new TreeMap(comparator);
            if (moFilter != null) {
                for (Map.Entry<MOScope, ManagedObject<?>> entry : this.registry.entrySet()) {
                    if (!moFilter.passesFilter(entry.getValue())) continue;
                    r.put(entry.getKey(), entry.getValue());
                }
            } else {
                r.putAll(this.registry);
            }
            return r.entrySet().iterator();
        }
    }

    @Override
    public synchronized void addLookupListener(MOServerLookupListener listener, ManagedObject<?> mo) {
        if (this.lookupListener == null) {
            this.lookupListener = Collections.synchronizedMap(new HashMap());
        }
        List l = this.lookupListener.computeIfAbsent(mo, k -> Collections.synchronizedList(new LinkedList()));
        l.add(listener);
    }

    @Override
    public synchronized boolean removeLookupListener(MOServerLookupListener listener, ManagedObject<?> mo) {
        List<MOServerLookupListener> l;
        if (this.lookupListener != null && (l = this.lookupListener.get(mo)) != null) {
            return l.remove(listener);
        }
        return false;
    }

    @Override
    public synchronized void addContextListener(ContextListener l) {
        if (this.contextListeners == null) {
            this.contextListeners = new ArrayList<ContextListener>(2);
        }
        this.contextListeners.add(l);
    }

    @Override
    public synchronized void removeContextListener(ContextListener l) {
        if (this.contextListeners != null) {
            this.contextListeners.remove(l);
        }
    }

    protected void fireContextChanged(ContextEvent event) {
        if (this.contextListeners != null) {
            List<ContextListener> listeners = this.contextListeners;
            for (ContextListener listener : listeners) {
                listener.contextChanged(event);
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getClass().getName());
        buf.append("[contexts=");
        buf.append(this.contexts);
        buf.append("[keys={");
        Iterator<MOScope> it = this.registry.keySet().iterator();
        while (it.hasNext()) {
            MOScope scope = it.next();
            buf.append(scope.getLowerBound());
            if (scope.isLowerIncluded()) {
                buf.append("+");
            }
            buf.append("-");
            buf.append(scope.getUpperBound());
            if (scope.isUpperIncluded()) {
                buf.append("+");
            }
            if (scope instanceof MOContextScope) {
                buf.append("(").append(((MOContextScope)scope).getContext()).append(")");
            }
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        buf.append("}");
        buf.append(",registry=").append(this.registry);
        buf.append(",lockList=").append(this.lockList);
        buf.append(",lookupListener=").append(this.lookupListener);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public OctetString[] getRegisteredContexts(ManagedObject<?> managedObject) {
        HashSet<OctetString> contextSet = new HashSet<OctetString>();
        SortedMap<MOScope, ManagedObject<?>> scope = this.registry.tailMap(new DefaultMOContextScope(null, managedObject.getScope()));
        for (Map.Entry<MOScope, ManagedObject<?>> entry : scope.entrySet()) {
            MOScope key = entry.getKey();
            ManagedObject<?> o = entry.getValue();
            if (!managedObject.equals(o)) continue;
            if (key instanceof MOContextScope) {
                contextSet.add(((MOContextScope)key).getContext());
                continue;
            }
            contextSet.add(null);
        }
        return contextSet.toArray(new OctetString[0]);
    }

    @Override
    public Map<OctetString, MOScope> getRegisteredScopes(ManagedObject<?> managedObject) {
        HashMap<OctetString, MOScope> scopes = new HashMap<OctetString, MOScope>();
        SortedMap<MOScope, ManagedObject<?>> scope = this.registry.tailMap(new DefaultMOContextScope(null, managedObject.getScope()));
        for (Map.Entry<MOScope, ManagedObject<?>> entry : scope.entrySet()) {
            MOScope key = entry.getKey();
            ManagedObject<?> o = entry.getValue();
            if (!managedObject.equals(o)) continue;
            if (key instanceof MOContextScope) {
                scopes.put(((MOContextScope)key).getContext(), key);
                continue;
            }
            scopes.put(null, key);
        }
        return scopes;
    }

    public static <R extends MOTableRow, T extends MOTable<R, ? extends MOColumn, ? extends MOTableModel<R>>> void registerTableRowListener(MOServer server, MOTableRowListener<R> listener) {
        Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject<?> mo = it.next().getValue();
            if (!(mo instanceof MOTable)) continue;
            ((MOTable)mo).addMOTableRowListener(listener);
        }
    }

    public static <R extends MOTableRow, T extends MOTable<R, ? extends MOColumn, ? extends MOTableModel<R>>> void unregisterTableRowListener(MOServer server, MOTableRowListener<R> listener) {
        Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject<?> mo = it.next().getValue();
            if (!(mo instanceof MOTable)) continue;
            ((MOTable)mo).removeMOTableRowListener(listener);
        }
    }

    public static void registerChangeListener(MOServer server, MOChangeListener listener, MOFilter moFilter) {
        Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject<?> mo = it.next().getValue();
            if (!(mo instanceof ChangeableManagedObject) || moFilter != null && !moFilter.passesFilter(mo)) continue;
            ((ChangeableManagedObject)mo).addMOChangeListener(listener);
        }
    }

    public static void unregisterChangeListener(MOServer server, MOChangeListener listener, MOFilter moFilter) {
        Iterator<Map.Entry<MOScope, ManagedObject<?>>> it = server.iterator();
        while (it.hasNext()) {
            ManagedObject<?> mo = it.next().getValue();
            if (!(mo instanceof ChangeableManagedObject) || moFilter != null && !moFilter.passesFilter(mo)) continue;
            ((ChangeableManagedObject)mo).removeMOChangeListener(listener);
        }
    }

    public boolean isDeadlockPreventionEnabled() {
        return this.deadlockPreventionEnabled;
    }

    public DefaultMOServer setDeadlockPreventionEnabled(boolean deadlockPreventionEnabled) {
        this.deadlockPreventionEnabled = deadlockPreventionEnabled;
        return this;
    }

    static class Lock {
        private final long creationTime = System.currentTimeMillis();
        private volatile int count = 0;
        private LockRequest lockRequest;

        private Lock() {
        }

        Lock(LockRequest lockRequest) {
            this();
            this.lockRequest = lockRequest;
            this.count = 1;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public int getCount() {
            return this.count;
        }

        public synchronized void add() {
            ++this.count;
        }

        public synchronized boolean remove() {
            if (--this.count <= 0) {
                if (this.count != 0) {
                    this.count = 0;
                }
                return true;
            }
            return false;
        }

        public Object getOwner() {
            return this.lockRequest.getLockOwner();
        }

        public LockRequest getLockRequest() {
            return this.lockRequest;
        }

        public String toString() {
            return "Lock[,creationTime=" + this.creationTime + ",count=" + this.count + ",lockRequest=" + String.valueOf(this.lockRequest) + "]";
        }
    }
}

