/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MutableMOScope;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;

public class DefaultMOScope
implements MOScope,
MutableMOScope {
    protected OID lowerBound;
    protected OID upperBound;
    protected boolean lowerIncluded;
    protected boolean upperIncluded;

    public DefaultMOScope(OID lowerBound, boolean lowerIncluded, OID upperBound, boolean upperIncluded) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.lowerIncluded = lowerIncluded;
        this.upperIncluded = upperIncluded;
    }

    public DefaultMOScope(MOScope other) {
        this.lowerBound = other.getLowerBound();
        this.upperBound = other.getUpperBound();
        this.lowerIncluded = other.isLowerIncluded();
        this.upperIncluded = other.isUpperIncluded();
    }

    @Override
    public OID getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public OID getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean isLowerIncluded() {
        return this.lowerIncluded;
    }

    @Override
    public boolean isUpperIncluded() {
        return this.upperIncluded;
    }

    @Override
    public boolean isCovered(MOScope other) {
        return DefaultMOScope.covers(this, other);
    }

    @Override
    public boolean isOverlapping(MOScope other) {
        return DefaultMOScope.overlaps(this, other);
    }

    @Override
    public void setLowerBound(OID lowerBound) {
        this.lowerBound = lowerBound;
    }

    @Override
    public void setLowerIncluded(boolean lowerIncluded) {
        this.lowerIncluded = lowerIncluded;
    }

    @Override
    public void setUpperBound(OID upperBound) {
        this.upperBound = upperBound;
    }

    @Override
    public void setUpperIncluded(boolean upperIncluded) {
        this.upperIncluded = upperIncluded;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MOScope) {
            MOScope other = (MOScope)obj;
            return this.lowerBound.equals((Object)other.getLowerBound()) && (this.upperBound == null && other.getUpperBound() == null || this.upperBound.equals((Object)other.getUpperBound())) && this.lowerIncluded == other.isLowerIncluded() && this.upperIncluded == other.isUpperIncluded();
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode();
    }

    public boolean covers(MOScope covered) {
        return DefaultMOScope.covers(this, covered);
    }

    public static boolean covers(MOScope scope, MOScope covered) {
        int lowerResult = scope.getLowerBound().compareTo((Variable)covered.getLowerBound());
        if (lowerResult < 0 || lowerResult == 0 && scope.isLowerIncluded()) {
            if (scope.getUpperBound() == null) {
                return true;
            }
            int upperResult = scope.getUpperBound().compareTo((Variable)covered.getLowerBound());
            if (upperResult > 0 || upperResult == 0 && scope.isUpperIncluded() && covered.isLowerIncluded()) {
                return true;
            }
        }
        return false;
    }

    public static boolean overlaps(MOScope scope, MOScope intersected) {
        OID iUpper = intersected.getUpperBound();
        if (iUpper == null) {
            if (scope.getUpperBound() == null) {
                return true;
            }
            int upperResult = scope.getUpperBound().compareTo((Variable)intersected.getLowerBound());
            return upperResult > 0 || upperResult == 0 && scope.isUpperIncluded() && intersected.isLowerIncluded();
        }
        int lowerResult = scope.getLowerBound().compareTo((Variable)iUpper);
        int upperResult = 1;
        if (scope.getUpperBound() != null) {
            upperResult = scope.getUpperBound().compareTo((Variable)intersected.getLowerBound());
        }
        if (lowerResult == 0 && scope.isLowerIncluded() && intersected.isUpperIncluded()) {
            return true;
        }
        if (upperResult == 0 && scope.isUpperIncluded() && intersected.isLowerIncluded()) {
            return true;
        }
        return lowerResult < 0 && upperResult > 0;
    }

    @Override
    public void subtractScope(MOScope scope) {
        if (this.lowerBound.compareTo((Variable)scope.getUpperBound()) <= 0) {
            this.lowerBound = scope.getUpperBound();
            this.lowerIncluded = !scope.isUpperIncluded();
        }
    }

    @Override
    public boolean covers(OID oid) {
        if (oid == null) {
            return false;
        }
        return (this.getLowerBound().compareTo((Variable)oid) < 0 || this.isLowerIncluded() && this.getLowerBound().equals((Object)oid)) && (this.getUpperBound() == null || this.getUpperBound().compareTo((Variable)oid) > 0 || this.isUpperIncluded() && this.getUpperBound().equals((Object)oid));
    }

    @Override
    public boolean isEmpty() {
        return this.lowerBound != null && this.upperBound != null && (this.lowerBound.compareTo((Variable)this.upperBound) > 0 || this.lowerBound.equals((Object)this.upperBound) && (!this.isLowerIncluded() || !this.isUpperIncluded()));
    }

    public String toString() {
        return this.getClass().getName() + "[lowerBound=" + String.valueOf(this.lowerBound) + ",lowerIncluded=" + this.lowerIncluded + ",upperBound=" + String.valueOf(this.upperBound) + ",upperIncluded=" + this.upperIncluded + "]";
    }
}

