/*_############################################################################
  _## 
  _##  SNMP4J-Agent 3 - MOException.java  
  _## 
  _##  Copyright (C) 2005-2025  Frank Fock (SNMP4J.org)
  _##  
  _##  Licensed under the Apache License, Version 2.0 (the "License");
  _##  you may not use this file except in compliance with the License.
  _##  You may obtain a copy of the License at
  _##  
  _##      http://www.apache.org/licenses/LICENSE-2.0
  _##  
  _##  Unless required by applicable law or agreed to in writing, software
  _##  distributed under the License is distributed on an "AS IS" BASIS,
  _##  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  _##  See the License for the specific language governing permissions and
  _##  limitations under the License.
  _##  
  _##########################################################################*/


package org.snmp4j.agent;

/**
 * The <code>MOException</code> is the base class for all exceptions thrown while managing {@link ManagedObject}s.
 *
 * @author Frank Fock
 * @version 1.0
 */
public abstract class MOException extends Exception {

    private static final long serialVersionUID = 1880669598779360010L;

    public MOException() {
    }

    public MOException(String message) {
        super(message);
    }

    public MOException(String message, Exception chainedException) {
        super(message, chainedException);
    }

}
