/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent.io;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.io.DefaultMOInput;
import org.snmp4j.agent.io.DefaultMOOutput;
import org.snmp4j.agent.io.MOPersistenceProvider;
import org.snmp4j.agent.io.MOServerPersistence;
import org.snmp4j.agent.mo.MOPriorityProvider;

public class DefaultMOPersistenceProvider
implements MOPersistenceProvider {
    private final MOServer[] server;
    private final String defaultURI;

    public DefaultMOPersistenceProvider(MOServer[] server, String defaultURI) {
        this.server = server;
        this.defaultURI = defaultURI;
    }

    @Override
    public String getPersistenceProviderID() {
        return "default";
    }

    @Override
    public boolean isValidPersistenceURI(String uri) {
        try {
            File f = this.getFile(uri);
            return f.isFile() && (f.canRead() || f.canWrite()) || !f.exists();
        }
        catch (Exception ex) {
            return false;
        }
    }

    private File getFile(String uri) {
        File f;
        if (uri.toUpperCase().startsWith("FILE:")) {
            URI u = URI.create(uri);
            f = new File(u);
        } else {
            f = new File(uri);
        }
        return f;
    }

    @Override
    public void restore(String uri, int importMode) throws IOException {
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(this.getFile(uri).toPath(), new OpenOption[0]));){
            DefaultMOInput is = new DefaultMOInput(ois);
            is.setOverwriteMode(importMode);
            MOServerPersistence p = new MOServerPersistence(this.server);
            p.loadData(is);
        }
    }

    @Override
    public void store(String uri) throws IOException {
        this.store(uri, null);
    }

    @Override
    public void store(String uri, MOPriorityProvider priorityProvider) throws IOException {
        if (uri == null) {
            uri = this.getDefaultURI();
        }
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(this.getFile(uri).toPath(), new OpenOption[0]));){
            DefaultMOOutput os = new DefaultMOOutput(oos);
            MOServerPersistence p = new MOServerPersistence(this.server);
            p.saveData(os, priorityProvider);
            oos.flush();
        }
    }

    @Override
    public String getDefaultURI() {
        return this.defaultURI;
    }
}

