/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.agent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.agent.DefaultMOContextScope;
import org.snmp4j.agent.DefaultMOQuery;
import org.snmp4j.agent.MOContextScope;
import org.snmp4j.agent.MOQuery;
import org.snmp4j.agent.MOQueryWithSource;
import org.snmp4j.agent.MOScope;
import org.snmp4j.agent.MOServer;
import org.snmp4j.agent.MOServerLookupEvent;
import org.snmp4j.agent.ManagedObject;
import org.snmp4j.agent.NotificationOriginator;
import org.snmp4j.agent.NotificationTask;
import org.snmp4j.agent.ProxyForwardRequest;
import org.snmp4j.agent.ProxyForwarder;
import org.snmp4j.agent.ProxyMap;
import org.snmp4j.agent.RequestHandler;
import org.snmp4j.agent.mo.GenericManagedObject;
import org.snmp4j.agent.mo.lock.LockRequest;
import org.snmp4j.agent.mo.snmp.CoexistenceInfo;
import org.snmp4j.agent.mo.snmp.CoexistenceInfoProvider;
import org.snmp4j.agent.mo.snmp.NotificationOriginatorImpl;
import org.snmp4j.agent.mo.snmp.SnmpTargetMIB;
import org.snmp4j.agent.request.Request;
import org.snmp4j.agent.request.RequestFactory;
import org.snmp4j.agent.request.SnmpRequest;
import org.snmp4j.agent.request.SnmpSubRequest;
import org.snmp4j.agent.request.SubRequest;
import org.snmp4j.agent.security.VACM;
import org.snmp4j.agent.util.TemporaryList;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.CounterListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.util.WorkerTask;

public class CommandProcessor
implements CommandResponder,
NotificationOriginator {
    private static final LogAdapter logger = LogFactory.getLogger(CommandProcessor.class);
    private static final int MAX_INTERNAL_REQUEST_TIMEOUT = 300000;
    protected WorkerPool threadPool = null;
    protected VACM vacm = null;
    protected List<MOServer> moServers;
    protected List<OctetString> ownContextEngineIDs = new ArrayList<OctetString>(2);
    protected final List<RequestHandler<SnmpRequest>> pduHandler = new ArrayList<RequestHandler<SnmpRequest>>();
    protected TemporaryList<SnmpRequest> requestList;
    protected RequestFactory<CommandResponderEvent<?>, PDU, SnmpRequest> requestFactory;
    protected NotificationOriginator notificationOriginator;
    protected ProxyMap proxyForwarder;
    protected CoexistenceInfoProvider coexistenceProvider;
    protected boolean lockNonNextRequestsSortedByVbOid;
    private transient List<CounterListener> counterListeners;

    public CommandProcessor(OctetString contextEngineID) {
        this.ownContextEngineIDs.add(contextEngineID);
        this.ownContextEngineIDs.add(MPv3.LOCAL_ENGINE_ID);
        this.moServers = new ArrayList<MOServer>();
        this.requestList = new TemporaryList(300000);
        this.pduHandler.add(new GetHandler());
        this.pduHandler.add(new GetNextHandler());
        this.pduHandler.add(new SetHandler());
        this.pduHandler.add(new GetBulkHandler());
        this.requestFactory = new DefaultRequestFactory();
    }

    public void setInternalRequestTimeout(int timeoutMillis) {
        this.requestList.setTimeout(timeoutMillis);
    }

    public int getInternalRequestTimeout() {
        return this.requestList.getTimeout();
    }

    public <A extends Address> void processPdu(CommandResponderEvent<A> event) {
        if (event.getPDU() != null) {
            CoexistenceInfo cinfo = null;
            OctetString sname = new OctetString(event.getSecurityName());
            if (event.getPDU() instanceof ScopedPDU) {
                ScopedPDU spdu = (ScopedPDU)event.getPDU();
                cinfo = new CoexistenceInfo(sname, spdu.getContextEngineID(), spdu.getContextName());
            } else if (this.coexistenceProvider != null) {
                CoexistenceInfo[] cinfos = this.coexistenceProvider.getCoexistenceInfo(sname);
                if (cinfos != null && cinfos.length > 0) {
                    for (CoexistenceInfo cinfo1 : cinfos) {
                        if (!this.coexistenceProvider.passesFilter(event.getPeerAddress(), cinfo1)) continue;
                        cinfo = cinfo1;
                        break;
                    }
                    if (cinfo == null) {
                        logger.warn((Serializable)((Object)("Access attempt from " + String.valueOf(event.getPeerAddress()) + " denied because of source address filtering")));
                        this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpInBadCommunityNames));
                        return;
                    }
                    event.setMaxSizeResponsePDU(Math.min(cinfo.getMaxMessageSize(), event.getMaxSizeResponsePDU()));
                } else {
                    if (logger.isInfoEnabled()) {
                        logger.info((CharSequence)("Community name '" + String.valueOf(sname) + "' not found in SNMP-COMMUNITY-MIB"));
                    }
                    this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpInBadCommunityNames));
                    return;
                }
            }
            if (cinfo == null || this.ownContextEngineIDs.contains(cinfo.getContextEngineID())) {
                event.setProcessed(true);
                Command<A> command = new Command<A>(event, cinfo);
                if (this.threadPool != null) {
                    this.threadPool.execute(command);
                } else {
                    command.run();
                }
            } else if (this.proxyForwarder != null) {
                ProxyForwardRequest<A> request = new ProxyForwardRequest<A>(event, cinfo);
                ProxyForwarder proxy = this.proxyForwarder.get(cinfo.getContextEngineID(), request.getProxyType());
                ProxyCommand<A> command = new ProxyCommand<A>(proxy, request);
                if (proxy != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Processing proxy request with proxy forwarder " + String.valueOf(proxy))));
                    }
                    if (this.threadPool != null) {
                        this.threadPool.execute(command);
                    } else {
                        command.run();
                    }
                } else {
                    this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpProxyDrops));
                }
            } else {
                this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpSilentDrops));
            }
        }
    }

    @Deprecated
    public void setThreadPool(WorkerPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setWorkerPool(WorkerPool threadPool) {
        this.threadPool = threadPool;
    }

    public VACM getVacm() {
        return this.vacm;
    }

    public void setVacm(VACM vacm) {
        this.vacm = vacm;
    }

    public OctetString getContextEngineID() {
        return this.ownContextEngineIDs.get(0);
    }

    public void setContextEngineID(OctetString contextEngineID) {
        this.ownContextEngineIDs.set(0, contextEngineID);
    }

    @Override
    public Object notify(OctetString context, OID notificationID, VariableBinding[] vbs) {
        return this.notify(context, notificationID, null, vbs);
    }

    @Override
    public Object notify(OctetString context, OID notificationID, TimeTicks sysUpTime, VariableBinding[] vbs) {
        if (this.notificationOriginator != null) {
            if (sysUpTime == null && this.notificationOriginator instanceof NotificationOriginatorImpl) {
                sysUpTime = ((NotificationOriginatorImpl)this.notificationOriginator).getSysUpTime().get();
            }
            NotificationTask notifyTask = new NotificationTask(this.notificationOriginator, context, notificationID, sysUpTime, vbs);
            if (this.threadPool != null) {
                this.threadPool.execute((WorkerTask)notifyTask);
                return notifyTask;
            }
            notifyTask.run();
            return notifyTask.getResponses();
        }
        logger.warn((Serializable)((Object)("Could not sent notification '" + String.valueOf(notificationID) + "'=" + String.valueOf(Arrays.asList(vbs)) + " because NotificationOriginator not set")));
        return null;
    }

    public void setNotificationOriginator(NotificationOriginator notificationOriginator) {
        this.notificationOriginator = notificationOriginator;
    }

    public void setCoexistenceProvider(CoexistenceInfoProvider coexistenceProvider) {
        this.coexistenceProvider = coexistenceProvider;
    }

    public ProxyForwarder addProxyForwarder(ProxyForwarder proxyForwarder, OctetString contextEngineID, int proxyType) {
        if (this.proxyForwarder == null) {
            this.proxyForwarder = new ProxyMap();
        }
        return this.proxyForwarder.add(proxyForwarder, contextEngineID, proxyType);
    }

    public ProxyForwarder removeProxyForwarder(OctetString contextEngineID, int proxyType) {
        if (this.proxyForwarder != null) {
            return this.proxyForwarder.remove(contextEngineID, proxyType);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestHandler<SnmpRequest> getHandler(int pduType) {
        List<RequestHandler<SnmpRequest>> list = this.pduHandler;
        synchronized (list) {
            for (RequestHandler<SnmpRequest> handler : this.pduHandler) {
                if (!handler.isSupported(pduType)) continue;
                return handler;
            }
        }
        return null;
    }

    protected <A extends Address> void dispatchCommand(CommandResponderEvent<A> command, CoexistenceInfo cinfo) {
        block4: {
            try {
                RequestHandler<SnmpRequest> handler = this.getHandler(command.getPDU().getType());
                if (handler != null) {
                    this.processRequest(command, cinfo, handler);
                } else {
                    this.sendUnknownPDUHandlersReport(command);
                }
            }
            catch (Exception ex) {
                logger.error((CharSequence)("Failed to dispatch command " + String.valueOf(command) + " with " + String.valueOf(cinfo) + ": " + ex.getMessage()), (Throwable)ex);
                if (!logger.isDebugEnabled()) break block4;
                ex.printStackTrace();
            }
        }
    }

    private void sendUnknownPDUHandlersReport(CommandResponderEvent<?> command) {
        logger.info((CharSequence)("No PDU handler found for request " + String.valueOf(command)));
        CounterEvent counter = new CounterEvent((Object)this, SnmpConstants.snmpUnknownPDUHandlers);
        this.fireIncrementCounter(counter);
        if (command.getMessageProcessingModel() == 3 && command.getPDU() instanceof ScopedPDU) {
            ScopedPDU request = (ScopedPDU)command.getPDU();
            ScopedPDU report = new ScopedPDU();
            report.setContextEngineID(request.getContextEngineID());
            report.setContextName(request.getContextName());
            report.setType(-88);
            report.add(new VariableBinding(counter.getOid(), counter.getCurrentValue()));
            this.sendResponse(command, (PDU)report);
        } else {
            PDU resp = (PDU)command.getPDU().clone();
            resp.setErrorStatus(5);
            this.sendResponse(command, resp);
        }
    }

    protected <A extends Address> void processRequest(CommandResponderEvent<A> command, CoexistenceInfo cinfo, RequestHandler<SnmpRequest> handler) {
        SnmpRequest req = this.requestFactory.createRequest(command, cinfo);
        this.requestList.add(req);
        MOServer server = null;
        OctetString context = req.getContext();
        if (this.isContextNotSupported(context, command)) {
            return;
        }
        OctetString viewName = this.getViewName(command, cinfo, req.getViewType());
        if (viewName == null) {
            this.setAuthorizationError(req, 2);
        } else {
            req.setViewName(viewName);
            server = this.getServer(context);
            this.processRequest(server, handler, req);
        }
        this.finalizeRequest(command, req, server);
    }

    protected void reprocessRequest(MOServer server, SnmpRequest req) {
        RequestHandler<SnmpRequest> handler = this.getHandler(((CommandResponderEvent)req.getSource()).getPDU().getType());
        if (handler != null) {
            req.resetProcessedStatus();
            req.incReprocessCounter();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Reprocessing " + String.valueOf(req) + " with handler " + String.valueOf(handler))));
            }
            this.processRequest(server, handler, req);
        } else {
            this.sendUnknownPDUHandlersReport((CommandResponderEvent)req.getSource());
        }
    }

    protected <R extends Request<Source, Response, ? extends SubRequest<?>>, Source, Response> void processRequest(MOServer server, RequestHandler<R> handler, R req) {
        if (server == null) {
            logger.error((Serializable)((Object)("No server for " + String.valueOf(req.getContext()) + " found -> request cannot be processed")));
            req.setErrorStatus(5);
        } else {
            handler.processPdu(req, server);
        }
    }

    protected <A extends Address> void finalizeRequest(CommandResponderEvent<A> command, SnmpRequest req, MOServer server) {
        if (req.isComplete()) {
            this.requestList.remove(req);
            this.sendResponse(command, req.getResponse());
            if (server != null) {
                this.release(server, req);
            }
        }
    }

    protected void release(MOServer server, SnmpRequest req) {
        Iterator<SnmpRequest.SnmpSubRequest> it = req.iterator();
        while (it.hasNext()) {
            SnmpRequest.SnmpSubRequest sreq = it.next();
            if (sreq.getTargetMO() == null) continue;
            server.unlockNow(req, sreq.getTargetMO());
        }
    }

    protected <A extends Address> void sendResponse(CommandResponderEvent<A> requestEvent, PDU response) {
        MessageDispatcher disp = requestEvent.getMessageDispatcher();
        try {
            if (response.getBERLength() > requestEvent.getMaxSizeResponsePDU()) {
                if (response.getType() != -88) {
                    if (requestEvent.getPDU().getType() == -91) {
                        while (response.size() > 0 && response.getBERLength() > requestEvent.getMaxSizeResponsePDU()) {
                            response.trim();
                        }
                    } else {
                        response.clear();
                        response.setRequestID(requestEvent.getPDU().getRequestID());
                        response.setErrorStatus(1);
                    }
                }
                if (response.getBERLength() > requestEvent.getMaxSizeResponsePDU()) {
                    this.fireIncrementCounter(new CounterEvent((Object)this, SnmpConstants.snmpSilentDrops));
                    return;
                }
            }
            StatusInformation status = new StatusInformation();
            StateReference stateRef = requestEvent.getStateReference();
            if (stateRef == null) {
                logger.warn((Serializable)((Object)("No state reference available for requestEvent=" + String.valueOf(requestEvent) + ". Cannot return response=" + String.valueOf(response))));
            } else {
                stateRef.setTransportMapping(requestEvent.getTransportMapping());
                disp.returnResponsePdu(requestEvent.getMessageProcessingModel(), requestEvent.getSecurityModel(), requestEvent.getSecurityName(), requestEvent.getSecurityLevel(), response, requestEvent.getMaxSizeResponsePDU(), requestEvent.getStateReference(), status);
            }
        }
        catch (MessageException ex) {
            logger.error((CharSequence)("Failed to send response to request " + String.valueOf(requestEvent)), (Throwable)ex);
        }
    }

    protected void setAuthorizationError(Request<?, ?, ?> req, int vacmStatus) {
        if (logger.isInfoEnabled()) {
            logger.info((CharSequence)("Request failed with VACM error " + vacmStatus + ": " + String.valueOf(req)));
        }
        if (req.size() > 0) {
            SubRequest sreq = (SubRequest)req.iterator().next();
            sreq.getStatus().setErrorStatus(16);
        } else {
            req.setErrorStatus(16);
        }
    }

    public void addPduHandler(RequestHandler<SnmpRequest> handler) {
        this.pduHandler.add(handler);
    }

    public void removePduHandler(RequestHandler<SnmpRequest> handler) {
        this.pduHandler.remove(handler);
    }

    public boolean addMOServer(MOServer server) {
        if (this.moServers.contains(server)) {
            if (logger.isWarnEnabled()) {
                logger.warn((Serializable)((Object)("Duplicate MOServer registration: " + String.valueOf(server))));
            }
            return false;
        }
        this.moServers.add(server);
        return true;
    }

    public boolean removeMOServer(MOServer server) {
        return this.moServers.remove(server);
    }

    public MOServer getServer(OctetString context) {
        for (MOServer s : this.moServers) {
            if (s == null || !s.isContextSupported(context)) continue;
            return s;
        }
        return null;
    }

    public TemporaryList<SnmpRequest> getRequestList() {
        return this.requestList;
    }

    public NotificationOriginator getNotificationOriginator() {
        return this.notificationOriginator;
    }

    public ProxyMap getProxyForwarder() {
        return this.proxyForwarder;
    }

    public CoexistenceInfoProvider getCoexistenceProvider() {
        return this.coexistenceProvider;
    }

    public boolean isLockNonNextRequestsSortedByVbOid() {
        return this.lockNonNextRequestsSortedByVbOid;
    }

    public void setLockNonNextRequestsSortedByVbOid(boolean lockNonNextRequestsSortedByVbOid) {
        this.lockNonNextRequestsSortedByVbOid = lockNonNextRequestsSortedByVbOid;
    }

    protected <A extends Address> boolean isContextNotSupported(OctetString context, CommandResponderEvent<A> command) {
        if (!this.vacm.hasContext(context)) {
            CounterEvent counterEvent = new CounterEvent((Object)this, SnmpTargetMIB.oidSnmpUnknownContexts);
            this.fireIncrementCounter(counterEvent);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Request with context '" + String.valueOf(context) + "' not processed because context is not known.")));
            }
            if (command != null && command.getMessageProcessingModel() == 3 && command.getPDU() instanceof ScopedPDU && command.getStateReference() != null) {
                ScopedPDU reportPDU = new ScopedPDU();
                reportPDU.setType(-88);
                reportPDU.setContextEngineID(((ScopedPDU)command.getPDU()).getContextEngineID());
                reportPDU.setContextName(((ScopedPDU)command.getPDU()).getContextName());
                reportPDU.add(new VariableBinding(SnmpConstants.snmpUnknownContexts, counterEvent.getCurrentValue()));
                this.sendResponse(command, (PDU)reportPDU);
            }
            return true;
        }
        return false;
    }

    protected OctetString getViewName(CommandResponderEvent<?> req, CoexistenceInfo cinfo, int viewType) {
        return this.vacm.getViewName(cinfo.getContextName(), cinfo.getSecurityName(), req.getSecurityModel(), req.getSecurityLevel(), viewType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processNextSubRequest(SnmpRequest request, MOServer server, OctetString context, SubRequest<?> sreq) throws NoSuchElementException {
        DefaultMOContextScope scope = (DefaultMOContextScope)sreq.getScope();
        MOQuery query = sreq.getQuery();
        if (query == null) {
            query = new VACMQuery(context, scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded(), request.getViewName(), false, request);
            sreq.setQuery(query);
        }
        Function<OID, Boolean> vacmFilter = oid -> this.vacm.isAccessAllowed(request.getViewName(), (OID)oid) == 0;
        LockRequest lockRequest = new LockRequest(request, this.requestList.getTimeout());
        MOServerLookupEvent lookupEvent = new MOServerLookupEvent(this, null, query, MOServerLookupEvent.IntendedUse.getNext, true);
        while (!sreq.getStatus().isProcessed()) {
            GenericManagedObject mo = server.lookup(query, lockRequest, lookupEvent, GenericManagedObject.class);
            if (mo == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("EndOfMibView at scope=" + String.valueOf(scope) + " and query " + String.valueOf(query))));
                }
                sreq.getVariableBinding().setVariable((Variable)Null.endOfMibView);
                sreq.getStatus().setPhaseComplete(true);
                continue;
            }
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Processing NEXT query " + String.valueOf(query) + " with " + String.valueOf(mo) + " sub-request with index " + sreq.getIndex())));
                }
                boolean counter64Skip = false;
                if (mo.next(sreq, vacmFilter) && !(counter64Skip = request.getMessageProcessingModel() == 0 && sreq.getVariableBinding().getSyntax() == 70)) continue;
                sreq.getVariableBinding().setVariable((Variable)Null.instance);
                if (counter64Skip) {
                    scope.lowerBound = sreq.getVariableBinding().getOid();
                    scope.lowerIncluded = false;
                    sreq.getStatus().setProcessed(false);
                    continue;
                }
                scope.subtractScope(mo.getScope());
                query.subtractScope(mo.getScope());
            }
            catch (Exception moex) {
                if (logger.isDebugEnabled()) {
                    moex.printStackTrace();
                }
                logger.error((CharSequence)("Exception occurred while executing NEXT query: " + moex.getMessage()), (Throwable)moex);
                if (sreq.getStatus().getErrorStatus() == 0) {
                    sreq.getStatus().setErrorStatus(5);
                }
                if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                throw new RuntimeException(moex);
            }
            finally {
                this.unlockManagedObjectIfLockedByLookup(server, mo, lockRequest);
            }
        }
    }

    protected void unlockManagedObjectIfLockedByLookup(MOServer server, ManagedObject<?> mo, LockRequest lockRequest) {
        switch (lockRequest.getLockRequestStatus()) {
            case locked: 
            case lockedAfterTimeout: {
                server.unlock(lockRequest.getLockOwner(), mo);
            }
        }
    }

    public synchronized void addCounterListener(CounterListener l) {
        if (this.counterListeners == null) {
            this.counterListeners = new ArrayList<CounterListener>(2);
        }
        this.counterListeners.add(l);
    }

    public synchronized void removeCounterListener(CounterListener l) {
        if (this.counterListeners != null) {
            this.counterListeners.remove(l);
        }
    }

    protected void fireIncrementCounter(CounterEvent event) {
        if (this.counterListeners != null) {
            List<CounterListener> listeners = this.counterListeners;
            for (CounterListener listener : listeners) {
                listener.incrementCounter(event);
            }
        }
    }

    private static void initRequestPhase(Request<?, ?, ?> request) {
        if (request.getPhase() == -1) {
            request.nextPhase();
        }
    }

    class GetHandler
    implements RequestHandler<SnmpRequest> {
        GetHandler() {
        }

        @Override
        public boolean isSupported(int pduType) {
            return pduType == -96;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPdu(SnmpRequest request, MOServer server) {
            CommandProcessor.initRequestPhase(request);
            OctetString context = request.getContext();
            try {
                SnmpRequest.SnmpSubRequest sreq;
                Iterator<SnmpRequest.SnmpSubRequest> it = CommandProcessor.this.lockNonNextRequestsSortedByVbOid ? request.iteratorSortedByVariableBindingOID() : request.iterator();
                LockRequest lockRequest = new LockRequest(request, CommandProcessor.this.requestList.getTimeout());
                while (it.hasNext()) {
                    sreq = it.next();
                    MOScope scope = sreq.getScope();
                    MOQuery query = sreq.getQuery();
                    if (query == null) {
                        query = new VACMQuery(context, scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded(), request.getViewName(), false, request);
                        sreq.setQuery(query);
                    }
                    MOServerLookupEvent lookupEvent = new MOServerLookupEvent(this, null, query, MOServerLookupEvent.IntendedUse.get, true);
                    sreq.setLookupEvent(lookupEvent);
                    GenericManagedObject mo = server.lookup(query, lockRequest, lookupEvent, GenericManagedObject.class);
                    if (mo == null) {
                        sreq.getVariableBinding().setVariable((Variable)Null.noSuchObject);
                        sreq.getStatus().setPhaseComplete(true);
                        continue;
                    }
                    sreq.setTargetMO(mo);
                }
                it = request.iterator();
                while (it.hasNext()) {
                    sreq = it.next();
                    ManagedObject<? super SnmpRequest.SnmpSubRequest> mo = sreq.getTargetMO();
                    if (sreq.isComplete() || mo == null) continue;
                    MOServerLookupEvent lookupEvent = sreq.getLookupEvent();
                    try {
                        mo.get(sreq);
                        if (request.getMessageProcessingModel() != 0 || sreq.getVariableBinding().getSyntax() != 70) continue;
                        sreq.getVariableBinding().setVariable((Variable)Null.noSuchInstance);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.warn((Serializable)moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(5);
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                    }
                    finally {
                        if (lookupEvent != null) {
                            lookupEvent.completedUse(sreq);
                        }
                        CommandProcessor.this.unlockManagedObjectIfLockedByLookup(server, mo, lockRequest);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((Serializable)((Object)"SubRequest not found"));
                request.setErrorStatus(5);
            }
        }
    }

    class GetNextHandler
    implements RequestHandler<SnmpRequest> {
        GetNextHandler() {
        }

        @Override
        public void processPdu(SnmpRequest request, MOServer server) {
            CommandProcessor.initRequestPhase(request);
            OctetString context = request.getContext();
            try {
                Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                while (it.hasNext()) {
                    SubRequest sreq = it.next();
                    CommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((Serializable)((Object)"SubRequest not found"));
                request.setErrorStatus(5);
            }
        }

        @Override
        public boolean isSupported(int pduType) {
            return pduType == -95;
        }
    }

    class SetHandler
    implements RequestHandler<SnmpRequest> {
        SetHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepare(OctetString context, SnmpRequest request, MOServer server) {
            try {
                SnmpSubRequest sreq;
                Iterator<SnmpRequest.SnmpSubRequest> it = CommandProcessor.this.lockNonNextRequestsSortedByVbOid ? request.iteratorSortedByVariableBindingOID() : request.iterator();
                LockRequest lockRequest = new LockRequest(request, CommandProcessor.this.requestList.getTimeout());
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    if (sreq.isComplete()) continue;
                    MOScope scope = sreq.getScope();
                    MOQuery query = sreq.getQuery();
                    if (query == null) {
                        query = new VACMQuery(context, scope.getLowerBound(), scope.isLowerIncluded(), scope.getUpperBound(), scope.isUpperIncluded(), request.getViewName(), true, request);
                        sreq.setQuery(query);
                    }
                    if (!query.getScope().isCovered(new DefaultMOContextScope(context, scope))) {
                        sreq.getStatus().setErrorStatus(6);
                        continue;
                    }
                    MOServerLookupEvent lookupEvent = new MOServerLookupEvent(this, null, query, MOServerLookupEvent.IntendedUse.prepare, true);
                    sreq.setLookupEvent(lookupEvent);
                    GenericManagedObject mo = server.lookup(query, lockRequest, lookupEvent, GenericManagedObject.class);
                    if (mo == null) {
                        if (query instanceof VACMQuery && !((VACMQuery)query).isAccessAllowed(scope.getLowerBound())) {
                            sreq.getStatus().setErrorStatus(6);
                            break;
                        }
                        sreq.getStatus().setErrorStatus(11);
                        break;
                    }
                    sreq.setTargetMO(mo);
                    if (lockRequest.getLockRequestStatus() != LockRequest.LockStatus.lockTimedOut) continue;
                    logger.warn((Serializable)((Object)("Set request " + String.valueOf(request) + " failed because " + String.valueOf(mo) + " could not be locked")));
                    if (sreq.getStatus().getErrorStatus() != 0) continue;
                    sreq.getStatus().setErrorStatus(5);
                }
                it = request.iterator();
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    ManagedObject mo = sreq.getTargetMO();
                    if (sreq.isComplete() || mo == null) continue;
                    MOServerLookupEvent lookupEvent = sreq.getLookupEvent();
                    try {
                        mo.prepare(sreq);
                    }
                    catch (Exception moex) {
                        logger.error((CharSequence)("Set request " + String.valueOf(request) + " failed with exception"), (Throwable)moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(5);
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                    }
                    finally {
                        lookupEvent.completedUse(sreq);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                request.setErrorStatus(5);
            }
        }

        @Override
        public void processPdu(SnmpRequest request, MOServer server) {
            OctetString context;
            block10: {
                context = request.getContext();
                try {
                    while (request.getPhase() < 4) {
                        int phase = request.nextPhase();
                        switch (phase) {
                            case 1: {
                                this.prepare(context, request, server);
                                break;
                            }
                            case 2: {
                                this.commit(context, request, server);
                                break;
                            }
                            case 3: {
                                this.undo(context, request, server);
                                break;
                            }
                            case 4: {
                                this.cleanup(context, request, server);
                                return;
                            }
                        }
                        if (request.isPhaseComplete()) continue;
                        return;
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        ex.printStackTrace();
                    }
                    logger.error((CharSequence)"Failed to process SET request, trying to clean it up...", (Throwable)ex);
                    if (!SNMP4JSettings.isForwardRuntimeExceptions()) break block10;
                    throw new RuntimeException(ex);
                }
            }
            this.cleanup(context, request, server);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void undo(OctetString context, SnmpRequest request, MOServer server) {
            try {
                SnmpSubRequest<SnmpRequest.SnmpSubRequest> sreq;
                Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                while (it.hasNext()) {
                    sreq = it.next();
                    if (((SnmpRequest.SnmpSubRequest)sreq).isComplete()) continue;
                    OID oid = ((SnmpRequest.SnmpSubRequest)sreq).getVariableBinding().getOid();
                    GenericManagedObject mo = ((SnmpRequest.SnmpSubRequest)sreq).getTargetMO();
                    MOServerLookupEvent lookupEvent = null;
                    if (mo == null) {
                        DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
                        lookupEvent = new MOServerLookupEvent(this, null, new MOQueryWithSource(scope, true, request), MOServerLookupEvent.IntendedUse.undo, true);
                        ((SnmpRequest.SnmpSubRequest)sreq).setLookupEvent(lookupEvent);
                        mo = server.lookup(lookupEvent.getQuery(), null, lookupEvent, GenericManagedObject.class);
                        ((SnmpRequest.SnmpSubRequest)sreq).setTargetMO((ManagedObject<? super SnmpRequest.SnmpSubRequest>)((ManagedObject<SnmpRequest.SnmpSubRequest>)((ManagedObject<? super SnmpRequest.SnmpSubRequest>)mo)));
                    }
                    if (mo != null) continue;
                    ((SnmpRequest.SnmpSubRequest)sreq).getStatus().setErrorStatus(15);
                }
                it = request.iterator();
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    ManagedObject mo = sreq.getTargetMO();
                    if (sreq.isComplete() || mo == null) continue;
                    MOServerLookupEvent lookupEvent = sreq.getLookupEvent();
                    try {
                        mo.undo(sreq);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.error((Serializable)moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(15);
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                    }
                    finally {
                        if (lookupEvent == null || lookupEvent.getIntendedUse() != MOServerLookupEvent.IntendedUse.undo) continue;
                        lookupEvent.completedUse(sreq);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                request.setErrorStatus(5);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void commit(OctetString context, SnmpRequest request, MOServer server) {
            try {
                SnmpRequest.SnmpSubRequest sreq;
                Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                while (request.getErrorStatus() == 0 && it.hasNext()) {
                    sreq = it.next();
                    if (sreq.isComplete()) continue;
                    OID oid = sreq.getVariableBinding().getOid();
                    GenericManagedObject mo = sreq.getTargetMO();
                    MOServerLookupEvent lookupEvent = null;
                    if (mo == null) {
                        DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
                        lookupEvent = new MOServerLookupEvent(this, null, new MOQueryWithSource(scope, true, request), MOServerLookupEvent.IntendedUse.commit, true);
                        sreq.setLookupEvent(lookupEvent);
                        mo = server.lookup(lookupEvent.getQuery(), null, lookupEvent, GenericManagedObject.class);
                        sreq.setTargetMO(mo);
                    }
                    if (mo != null) continue;
                    sreq.getStatus().setErrorStatus(14);
                }
                it = request.iterator();
                while (!request.isPhaseComplete() && it.hasNext()) {
                    sreq = it.next();
                    ManagedObject<? super SnmpRequest.SnmpSubRequest> mo = sreq.getTargetMO();
                    if (sreq.isComplete() || mo == null) continue;
                    MOServerLookupEvent lookupEvent = sreq.getLookupEvent();
                    try {
                        mo.commit(sreq);
                    }
                    catch (Exception moex) {
                        if (logger.isDebugEnabled()) {
                            moex.printStackTrace();
                        }
                        logger.error((Serializable)moex);
                        if (sreq.getStatus().getErrorStatus() == 0) {
                            sreq.getStatus().setErrorStatus(14);
                        }
                        if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                        throw new RuntimeException(moex);
                    }
                    finally {
                        if (lookupEvent == null || lookupEvent.getIntendedUse() != MOServerLookupEvent.IntendedUse.commit) continue;
                        lookupEvent.completedUse(sreq);
                    }
                }
            }
            catch (NoSuchElementException nsex) {
                if (logger.isDebugEnabled()) {
                    nsex.printStackTrace();
                }
                logger.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                request.setErrorStatus(5);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void cleanup(OctetString context, SnmpRequest request, MOServer server) {
            block11: {
                try {
                    SnmpRequest.SnmpSubRequest sreq;
                    Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                    while (it.hasNext()) {
                        sreq = it.next();
                        if (sreq.isComplete()) continue;
                        OID oid = sreq.getVariableBinding().getOid();
                        GenericManagedObject mo = sreq.getTargetMO();
                        MOServerLookupEvent lookupEvent = null;
                        if (mo == null) {
                            DefaultMOContextScope scope = new DefaultMOContextScope(context, oid, true, oid, true);
                            lookupEvent = new MOServerLookupEvent(this, null, new DefaultMOQuery(scope), MOServerLookupEvent.IntendedUse.cleanUp, true);
                            sreq.setLookupEvent(lookupEvent);
                            mo = server.lookup(lookupEvent.getQuery(), null, lookupEvent, GenericManagedObject.class);
                            sreq.setTargetMO(mo);
                        }
                        if (mo != null) continue;
                        sreq.completed();
                    }
                    it = request.iterator();
                    while (!request.isPhaseComplete() && it.hasNext()) {
                        sreq = it.next();
                        ManagedObject<? super SnmpRequest.SnmpSubRequest> mo = sreq.getTargetMO();
                        if (sreq.isComplete() || mo == null) continue;
                        MOServerLookupEvent lookupEvent = sreq.getLookupEvent();
                        try {
                            mo.cleanup(sreq);
                            server.unlock(sreq.getRequest(), mo);
                            sreq.getStatus().setPhaseComplete(true);
                        }
                        catch (Exception moex) {
                            if (logger.isDebugEnabled()) {
                                moex.printStackTrace();
                            }
                            logger.error((Serializable)moex);
                            if (!SNMP4JSettings.isForwardRuntimeExceptions()) continue;
                            throw new RuntimeException(moex);
                        }
                        finally {
                            if (lookupEvent == null || lookupEvent.getIntendedUse() != MOServerLookupEvent.IntendedUse.cleanUp) continue;
                            lookupEvent.completedUse(sreq);
                        }
                    }
                }
                catch (NoSuchElementException nsex) {
                    logger.error((CharSequence)"Cannot find sub-request: ", (Throwable)nsex);
                    if (!logger.isDebugEnabled()) break block11;
                    nsex.printStackTrace();
                }
            }
        }

        @Override
        public boolean isSupported(int pduType) {
            return pduType == -93;
        }
    }

    class GetBulkHandler
    implements RequestHandler<SnmpRequest> {
        GetBulkHandler() {
        }

        @Override
        public boolean isSupported(int pduType) {
            return pduType == -91;
        }

        @Override
        public void processPdu(SnmpRequest request, MOServer server) {
            block8: {
                CommandProcessor.initRequestPhase(request);
                OctetString context = request.getContext();
                int nonRep = request.getNonRepeaters();
                try {
                    SnmpRequest.SnmpSubRequest sreq;
                    int i;
                    Iterator<SnmpRequest.SnmpSubRequest> it = request.iterator();
                    for (i = 0; i < nonRep && it.hasNext(); ++i) {
                        sreq = it.next();
                        if (sreq.isComplete()) continue;
                        CommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                    }
                    if (request.getMaxRepetitions() > 0) {
                        while (it.hasNext()) {
                            sreq = it.next();
                            if (!sreq.isComplete()) {
                                CommandProcessor.this.processNextSubRequest(request, server, context, sreq);
                                sreq.updateNextRepetition();
                            }
                            ++i;
                        }
                    } else {
                        while (it.hasNext()) {
                            sreq = it.next();
                            sreq.completed();
                            ++i;
                        }
                    }
                }
                catch (NoSuchElementException nsex) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug((Serializable)((Object)"GETBULK request response PDU size limit reached"));
                }
            }
        }
    }

    static class DefaultRequestFactory
    implements RequestFactory<CommandResponderEvent<?>, PDU, SnmpRequest> {
        DefaultRequestFactory() {
        }

        @Override
        public SnmpRequest createRequest(CommandResponderEvent<?> initiatingEvent, CoexistenceInfo cinfo) {
            return new SnmpRequest(initiatingEvent, cinfo);
        }
    }

    class Command<A extends Address>
    implements WorkerTask {
        private final CommandResponderEvent<A> request;
        private final CoexistenceInfo cinfo;

        public Command(CommandResponderEvent<A> event, CoexistenceInfo cinfo) {
            this.request = event;
            this.cinfo = cinfo;
        }

        public void run() {
            CommandProcessor.this.dispatchCommand(this.request, this.cinfo);
        }

        public void terminate() {
        }

        public void join() throws InterruptedException {
        }

        public void interrupt() {
        }
    }

    class ProxyCommand<A extends Address>
    implements WorkerTask {
        private final ProxyForwardRequest<A> request;
        private final ProxyForwarder forwarder;

        public ProxyCommand(ProxyForwarder forwarder, ProxyForwardRequest<A> event) {
            this.forwarder = forwarder;
            this.request = event;
        }

        public void run() {
            if (this.forwarder.forward(this.request)) {
                PDU response = this.request.getResponsePDU();
                if (response != null) {
                    CommandProcessor.this.sendResponse(this.request.getCommandEvent(), response);
                }
            } else if (this.request.getProxyType() != 3) {
                CounterEvent cevent = new CounterEvent((Object)this, SnmpConstants.snmpProxyDrops);
                CommandProcessor.this.fireIncrementCounter(cevent);
                CommandResponderEvent<A> cre = this.request.getCommandEvent();
                if (cre.getMessageProcessingModel() == 3 && cre.getStateReference() != null) {
                    ScopedPDU reportPDU = new ScopedPDU();
                    reportPDU.setType(-88);
                    reportPDU.setContextEngineID(this.request.getContextEngineID());
                    reportPDU.setContextName(this.request.getContext());
                    reportPDU.add(new VariableBinding(SnmpConstants.snmpProxyDrops, cevent.getCurrentValue()));
                    CommandProcessor.this.sendResponse(this.request.getCommandEvent(), (PDU)reportPDU);
                }
            }
        }

        public void terminate() {
        }

        public void join() throws InterruptedException {
        }

        public void interrupt() {
        }
    }

    class VACMQuery
    extends MOQueryWithSource {
        private final OctetString viewName;

        public VACMQuery(OctetString context, OID lowerBound, boolean isLowerIncluded, OID upperBound, boolean isUpperIncluded, OctetString viewName, boolean isWriteAccessIntended, SnmpRequest source) {
            super(new DefaultMOContextScope(context, lowerBound, isLowerIncluded, upperBound, isUpperIncluded), isWriteAccessIntended, source);
            this.viewName = viewName;
        }

        public boolean isSearchQuery() {
            MOContextScope scope = this.getScope();
            return !scope.isLowerIncluded() && (scope.getUpperBound() == null || !scope.getUpperBound().equals((Object)scope.getLowerBound()));
        }

        @Override
        public boolean matchesQuery(ManagedObject<?> managedObject) {
            if (this.isSearchQuery()) {
                OID oid = managedObject.find(this, new Function<OID, Boolean>(){

                    @Override
                    public Boolean apply(OID oid) {
                        return CommandProcessor.this.vacm.isAccessAllowed(VACMQuery.this.viewName, oid) == 0;
                    }
                });
                return oid != null;
            }
            OID oid = this.getScope().getLowerBound();
            return CommandProcessor.this.vacm.isAccessAllowed(this.viewName, oid) == 0;
        }

        public boolean isAccessAllowed(OID oid) {
            return CommandProcessor.this.vacm.isAccessAllowed(this.viewName, oid) == 0;
        }

        @Override
        public String toString() {
            return super.toString() + "[viewName=" + String.valueOf(this.viewName) + "]";
        }
    }
}

