/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smi;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.util.OIDComparator;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smi.IEnum;
import com.agentpp.smi.IRange;
import com.agentpp.smi.IRevision;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.IVariation;
import com.agentpp.smi.event.ExtRepsitoryListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.snmpvalue.IndexConverter;
import com.agentpp.snmpvalue.Val;
import com.agentpp.snmpvalue.ValueConverter;
import com.snmp4j.smi.CompilationMonitor;
import com.snmp4j.smi.CompilationResult;
import com.snmp4j.smi.NamedInputStream;
import com.snmp4j.smi.RepositoryDriver;
import com.snmp4j.smi.RepositoryIO;
import com.snmp4j.smi.SmiAccess;
import com.snmp4j.smi.SmiAgentCapabilities;
import com.snmp4j.smi.SmiCompiler;
import com.snmp4j.smi.SmiComplianceModule;
import com.snmp4j.smi.SmiComplianceType;
import com.snmp4j.smi.SmiError;
import com.snmp4j.smi.SmiGroup;
import com.snmp4j.smi.SmiGroupType;
import com.snmp4j.smi.SmiImport;
import com.snmp4j.smi.SmiIndexInfo;
import com.snmp4j.smi.SmiModule;
import com.snmp4j.smi.SmiModuleCompliance;
import com.snmp4j.smi.SmiModuleIdentity;
import com.snmp4j.smi.SmiNotificationType;
import com.snmp4j.smi.SmiObject;
import com.snmp4j.smi.SmiObjectCompliance;
import com.snmp4j.smi.SmiObjectFilter;
import com.snmp4j.smi.SmiObjectType;
import com.snmp4j.smi.SmiObjectTypeIndex;
import com.snmp4j.smi.SmiObjectVariation;
import com.snmp4j.smi.SmiParseException;
import com.snmp4j.smi.SmiRevision;
import com.snmp4j.smi.SmiStatus;
import com.snmp4j.smi.SmiSupportedModule;
import com.snmp4j.smi.SmiSyntax;
import com.snmp4j.smi.SmiSyntaxElement;
import com.snmp4j.smi.SmiSyntaxImpl;
import com.snmp4j.smi.SmiSyntaxType;
import com.snmp4j.smi.SmiTextualConvention;
import com.snmp4j.smi.SmiType;
import com.snmp4j.smi.SmiValueType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.MaxAccess;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.OIDTextFormat;
import org.snmp4j.util.SimpleOIDTextFormat;
import org.snmp4j.util.VariableTextFormat;

public final class SmiManager
implements SmiCompiler,
OIDTextFormat,
VariableTextFormat {
    private static final LogAdapter a = LogFactory.getLogger(SmiManager.class);
    private DefaultRepositoryManager b;
    private final MIBRepository c;
    private final Set<String> d;
    private OctetStringDefaultFormat e;
    private OIDFormat f;
    private NonPrintableStringFormat g;
    private int h;
    private RepositoryDriver i;
    private transient boolean j;
    private transient boolean k;
    private char l;
    private char m;
    private String n;
    private String o;
    private char p;

    /*
     * WARNING - void declaration
     */
    public SmiManager(String licenseKey, File repositoryDirectory) throws IOException {
        this((String)stringArray);
        void var2_2;
        String[] stringArray;
        if (!(repositoryDirectory.isDirectory() && repositoryDirectory.canRead() && repositoryDirectory.canWrite())) {
            throw new IOException("MIB repository directory is not accessible: " + repositoryDirectory);
        }
        this.e = OctetStringDefaultFormat.ASCII;
        this.b = new DefaultRepositoryManager();
        this.b.verbose = false;
        this.b.addRepositoryListener(new b(this, 0));
        this.b.open(repositoryDirectory);
        stringArray = var2_2.list();
        this.h = stringArray == null ? 0 : stringArray.length;
    }

    /*
     * WARNING - void declaration
     */
    public SmiManager(String licenseKey, RepositoryDriver repositoryDriver) {
        this((String)((Object)b2));
        void var2_2;
        b b2;
        this.i = var2_2;
        this.e = OctetStringDefaultFormat.ASCII;
        this.b = new DefaultRepositoryManager();
        this.b.verbose = false;
        this.b.setUseCompression(true);
        b2 = new b(this, 0);
        this.b.addRepositoryListener(b2);
    }

    /*
     * WARNING - void declaration
     */
    public final SmiManager useCompression(boolean enableCompressionOfCompiledModules) {
        void var1_1;
        this.b.setUseCompression((boolean)var1_1);
        return this;
    }

    public final boolean isUseCompression() {
        return this.b.isUseCompression();
    }

    private SmiManager(String licenseKey) {
        block9: {
            this.c = new MIBRepository();
            this.d = new HashSet<String>();
            this.e = OctetStringDefaultFormat.MIB;
            this.f = OIDFormat.ObjectNameAndDecodedIndex4RoundTrip;
            this.g = NonPrintableStringFormat.asIs;
            this.h = 1;
            this.j = true;
            this.k = false;
            this.l = (char)39;
            this.m = (char)34;
            this.n = "\\'";
            this.o = "\\\"";
            this.p = (char)92;
            if (licenseKey == null) {
                this.j = true;
                return;
            }
            try {
                boolean bl;
                Object object;
                object = ((String)object).split("/");
                if (object[0].startsWith("bf 6 5d 61 f ec b0 b4")) {
                    System.err.println("Invalid license, aborting!");
                    System.exit(1);
                }
                byte[] byArray = Val.fromHexString(object[0].trim());
                Object object2 = object[1].trim().getBytes();
                object = this;
                if ((byArray = Val.decrypt(byArray, new String((byte[])object2).toCharArray())) == null || byArray.length < 7 || byArray[0] != 7 && byArray[0] != 8 || byArray[1] != 1) {
                    bl = false;
                } else {
                    if (byArray[0] == 8) {
                        ((SmiManager)object).k = true;
                    }
                    object = new GregorianCalendar(2000 + byArray[4], byArray[5] - 1, byArray[6]);
                    object2 = new GregorianCalendar();
                    bl = byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 || !((Calendar)object).getTime().before(((Calendar)object2).getTime());
                }
                if (bl) break block9;
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {}
                System.err.println("Invalid license, aborting!");
                System.exit(1);
            }
            catch (Exception exception) {
                System.err.println("Invalid license, aborting!");
                System.exit(1);
            }
        }
        this.j = false;
    }

    public final OIDFormat getOidFormat() {
        return this.f;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOidFormat(OIDFormat oidFormat) {
        void var1_1;
        this.f = var1_1;
    }

    public final OctetStringDefaultFormat getOctetStringDisplayHint() {
        return this.e;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOctetStringDisplayHint(OctetStringDefaultFormat octetStringDisplayHint) {
        void var1_1;
        this.e = var1_1;
    }

    public final String[] listModules() throws IOException {
        try {
            return this.b.getModuleNames();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public final String[] getLoadedModuleNames() {
        Vector<String> vector = this.c.getModuleNames();
        return vector.toArray(new String[0]);
    }

    public final String[] getExplicitlyLoadedModuleNames() {
        return this.d.toArray(new String[0]);
    }

    public final List<SmiModule> getLoadedSmiModules() throws IOException {
        String[] stringArray = this.getLoadedModuleNames();
        ArrayList<SmiModule> arrayList = new ArrayList<SmiModule>(stringArray.length);
        for (String string : stringArray) {
            SmiModule smiModule = this.findSmiModule(string);
            if (smiModule != null) {
                arrayList.add(smiModule);
                continue;
            }
            a.warn((Serializable)((Object)("Loaded MODULE '" + string + "' could not be found in repository, inconsistent state detected")));
        }
        return arrayList;
    }

    public final synchronized boolean loadModule(String moduleName) {
        MIBModule mIBModule;
        try {
            mIBModule = this.b.getModule((String)((Object)mIBModule), true);
        }
        catch (IOException iOException) {
            return false;
        }
        return this.a(mIBModule, true);
    }

    private boolean a(MIBModule mIBModule, boolean bl) {
        if (mIBModule == null) {
            return false;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        try {
            MIBObject[] mIBObjectArray = this.b.getImportedObjects(mIBModule.getModuleName());
            this.c.addAllObjects(mIBObjectArray, null, bl, hashMap);
            this.c.addObject(mIBModule);
            this.c.addAllObjects(mIBModule.getObjects(), mIBModule, bl, hashMap);
            this.c.addImportedModuleIDsInverted(hashMap);
            this.d.add(mIBModule.getModuleName());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean[] loadModules(String[] moduleNames, int maxThreads, boolean overwriteExistingObjects) {
        void var1_1;
        int n2;
        List list;
        int n3;
        int n4;
        if ((n4 = Math.min(moduleNames.length, n4)) <= 0) {
            boolean[] blArray = new boolean[moduleNames.length];
            for (int i2 = 0; i2 < moduleNames.length; ++i2) {
                MIBModule mIBModule = this.a(moduleNames[i2]);
                blArray[i2] = this.a(mIBModule, overwriteExistingObjects);
            }
            return blArray;
        }
        ExecutorService executorService = Executors.newFixedThreadPool(n4, (ThreadFactory)SNMP4JSettings.getThreadFactory());
        ArrayList<Callable<MIBModule>> arrayList = new ArrayList<Callable<MIBModule>>();
        Object object = moduleNames;
        int n5 = moduleNames.length;
        for (n3 = 0; n3 < n5; ++n3) {
            String string = object[n3];
            arrayList.add(() -> this.a(string));
        }
        object = new MIBModule[moduleNames.length];
        try {
            list = executorService.invokeAll(arrayList);
            for (n3 = 0; n3 < list.size(); ++n3) {
                object[n3] = (MIBModule)list.get(n3).get();
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException("Error loading modules", exception);
        }
        list = new ArrayList();
        Object[] objectArray = object;
        int n6 = ((Object[])object).length;
        for (n2 = 0; n2 < n6; ++n2) {
            object = objectArray[n2];
            list.add(() -> this.a((MIBModule)object));
        }
        objectArray = new boolean[((void)var1_1).length];
        try {
            List list2 = executorService.invokeAll(list);
            for (n2 = 0; n2 < list2.size(); ++n2) {
                objectArray[n2] = (Boolean)list2.get(n2).get();
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            throw new RuntimeException("Error loading modules", exception);
        }
        finally {
            executorService.shutdown();
        }
        return objectArray;
    }

    private MIBModule a(String string) {
        try {
            return this.b.getModule(string, true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean unloadModule(String moduleName) {
        if (this.c.removeModule(moduleName)) {
            void var1_1;
            this.d.remove(var1_1);
            return true;
        }
        return false;
    }

    public final synchronized void resetModules() {
        this.c.clear();
        this.d.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized int unloadModuleWithDependencies(String moduleName) {
        void var1_1;
        MIBModule mIBModule = this.c.getModule(moduleName);
        this.d.remove(var1_1);
        if (mIBModule != null) {
            return this.c.remove(mIBModule, this.d);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isModuleLoaded(String moduleName) {
        void var1_1;
        return this.c.getModule((String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> deleteModule(String moduleName, boolean forceDeletion) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            void var2_2;
            if (var2_2 == false) {
                ModuleInfo[] moduleInfoArray = this.b.getModuleInfos();
                ModuleInfo[] moduleInfoArray2 = moduleInfoArray;
                moduleInfoArray2 = moduleInfoArray;
                int n2 = moduleInfoArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    ModuleInfo moduleInfo = moduleInfoArray2[i2];
                    if (moduleName.equals(moduleInfo.getModuleName()) || !moduleInfo.importsFrom(moduleName)) continue;
                    arrayList.add(moduleInfo.getModuleName());
                }
            }
            if (arrayList.isEmpty() && !this.b.removeModule(moduleName)) {
                arrayList.add(moduleName);
            }
        }
        catch (IOException iOException) {
            void var1_1;
            a.error((CharSequence)("IO error while deleting MIB module '" + moduleName + "': " + iOException.getMessage()), (Throwable)iOException);
            arrayList.add((String)var1_1);
        }
        return arrayList;
    }

    public final String[] compile(File textOrZipFile) throws SmiParseException, FileNotFoundException {
        NamedInputStream namedInputStream = SmiManager.a(textOrZipFile);
        String[] stringArray = this.compile(namedInputStream);
        try {
            namedInputStream.getInputStream().close();
        }
        catch (IOException iOException) {
            a.error((CharSequence)"IOException while closing FileInputStream in compile(File): ", (Throwable)iOException);
        }
        return stringArray;
    }

    public final void resetOidQuoting() {
        this.l = (char)39;
        this.m = (char)34;
        this.n = "\\'";
        this.o = "\\\"";
        this.p = (char)92;
    }

    public final char getOidFixedLengthStringQuote() {
        return this.l;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOidFixedLengthStringQuote(char oidFixedLengthStringQuote) {
        void var1_1;
        this.l = var1_1;
    }

    public final char getOidVariableLengthStringQuote() {
        return this.m;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOidVariableLengthStringQuote(char oidVariableLengthStringQuote) {
        void var1_1;
        this.m = var1_1;
    }

    public final String getOidFixedLengthStringQuoteEscapeSequence() {
        return this.n;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOidFixedLengthStringQuoteEscapeSequence(String oidFixedLengthStringQuoteEscapeSequence) {
        void var1_1;
        this.n = var1_1;
    }

    public final String getOidVariableLengthStringQuoteEscapeSequence() {
        return this.o;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOidVariableLengthStringQuoteEscapeSequence(String oidVariableLengthStringQuoteEscapeSequence) {
        void var1_1;
        this.o = var1_1;
    }

    public final char getOidStringQuoteEscapeCharacter() {
        return this.p;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOidStringQuoteEscapeCharacter(char oidStringQuoteEscapeCharacter) {
        void var1_1;
        this.p = var1_1;
    }

    private static NamedInputStream a(File file) throws FileNotFoundException {
        NamedInputStream.ZipFormat zipFormat = NamedInputStream.ZipFormat.none;
        if (file.getName().toLowerCase().endsWith(".zip")) {
            zipFormat = NamedInputStream.ZipFormat.ZIP;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        return new NamedInputStream(fileInputStream, file.getPath(), zipFormat);
    }

    public final String[] compile(NamedInputStream mibFile) throws SmiParseException {
        ModuleInfo[] moduleInfoArray;
        String string = "SNMP4J-SMI_" + this.h++;
        if (mibFile.getName() != null) {
            string = mibFile.getName();
        }
        try {
            moduleInfoArray = this.b.addModules(moduleInfoArray.getInputStream(), string);
            String[] stringArray = new String[moduleInfoArray.length];
            for (int i2 = 0; i2 < moduleInfoArray.length; ++i2) {
                stringArray[i2] = moduleInfoArray[i2].getModuleName();
            }
            return stringArray;
        }
        catch (SMIParseException moduleInfoArray2) {
            moduleInfoArray = moduleInfoArray2;
            throw SmiManager.a((SMIParseException)moduleInfoArray2, string);
        }
    }

    public final List<CompilationResult> compile(File[] files, CompilationMonitor compilationMonitor, boolean loadIntoRepository, boolean updateExistent, boolean compileLeniently) throws IOException {
        int n2;
        NamedInputStream[] namedInputStreamArray;
        NamedInputStream[] namedInputStreamArray2 = new NamedInputStream[files.length];
        try {
            for (int i2 = 0; i2 < files.length; ++i2) {
                namedInputStreamArray2[i2] = SmiManager.a(files[i2]);
            }
            List<CompilationResult> list = this.compile(namedInputStreamArray2, (CompilationMonitor)namedInputStreamArray, n2 != 0, updateExistent, compileLeniently);
            return list;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            throw iOException;
        }
        finally {
            namedInputStreamArray = namedInputStreamArray2;
            n2 = namedInputStreamArray2.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                NamedInputStream namedInputStream = namedInputStreamArray[i3];
                namedInputStream.getInputStream().close();
            }
        }
    }

    @Override
    public final List<CompilationResult> compile(NamedInputStream[] files, CompilationMonitor compilationMonitor, SmiCompiler.TargetMode compilerTargetMode, SmiCompiler.OverwriteMode overwriteMode, SmiCompiler.Strictness strictness) throws IOException {
        int n2;
        Object object;
        int n3;
        ArrayList arrayList = new ArrayList(files.length);
        int n4 = 1;
        Object object2 = files;
        int n5 = files.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            NamedInputStream namedInputStream = object2[i2];
            if (compilationMonitor != null && !compilationMonitor.loadingProgress(namedInputStream.getName(), n4++, files.length)) break;
            arrayList.addAll(com.snmp4j.smi.SmiManager$a.a(namedInputStream));
        }
        object2 = new ArrayList();
        n5 = 0;
        ModuleInfo[] moduleInfoArray = new ArrayList(arrayList.size());
        boolean bl = false;
        for (int i3 = 0; !bl && i3 < arrayList.size(); ++i3) {
            ModuleInfo[] moduleInfoArray2;
            a a2 = (a)arrayList.get(i3);
            try {
                ModuleInfo[] moduleInfoArray3;
                bl = compilationMonitor != null && !compilationMonitor.sortingProgress(a2.getName(), i3 + 1, arrayList.size());
                moduleInfoArray2 = moduleInfoArray3 = this.b.getModuleInfo(a2.a(), a2.getName());
                int n6 = moduleInfoArray3.length;
                for (n3 = 0; n3 < n6; ++n3) {
                    object = moduleInfoArray2[n3];
                    moduleInfoArray2[n3].userObject = a2;
                    Collections.addAll(moduleInfoArray, moduleInfoArray3);
                }
                continue;
            }
            catch (Exception exception) {
                moduleInfoArray2 = new ModuleInfo("invalid ");
                new ModuleInfo("invalid ").path = new File(a2.getName());
                moduleInfoArray2.userObject = a2;
                moduleInfoArray.add(moduleInfoArray2);
            }
        }
        if (bl) {
            return Collections.emptyList();
        }
        Object object3 = this.b.getModuleInfos();
        if (overwriteMode != SmiCompiler.OverwriteMode.overwriteAlways) {
            ModuleInfo[] moduleInfoArray4 = object3;
            int n7 = ((ModuleInfo[])object3).length;
            for (int i4 = 0; i4 < n7; ++i4) {
                ModuleInfo moduleInfo = moduleInfoArray4[i4];
                for (n3 = 0; n3 < moduleInfoArray.size(); ++n3) {
                    object = (ModuleInfo)moduleInfoArray.get(n3);
                    if (!((ModuleInfo)object).getModuleName().equals(moduleInfo.getModuleName()) || overwriteMode == SmiCompiler.OverwriteMode.overwriteIfNewer && SmiManager.a(moduleInfo, (ModuleInfo)object)) continue;
                    moduleInfoArray.remove(n3);
                    --n3;
                }
            }
        }
        Object object4 = new LinkedHashMap<String, ModuleInfo>();
        for (ModuleInfo moduleInfo : moduleInfoArray) {
            ModuleInfo moduleInfo2 = (ModuleInfo)((LinkedHashMap)object4).get(moduleInfo.getModuleName());
            if (moduleInfo2 != null && !SmiManager.a(moduleInfo2, moduleInfo)) continue;
            ((HashMap)object4).put(moduleInfo.getModuleName(), moduleInfo);
        }
        ModuleInfo[] moduleInfoArray5 = ((LinkedHashMap)object4).values().toArray(new ModuleInfo[0]);
        ModuleInfoSorter moduleInfoSorter = new ModuleInfoSorter(moduleInfoArray5);
        moduleInfoSorter.setPool((ModuleInfo[])object3);
        moduleInfoSorter.setBackupPool(this.b.getBuiltinModuleNames());
        moduleInfoSorter.sort();
        ModuleInfo[] object52 = moduleInfoSorter.getSortedList();
        ModuleInfo[] moduleInfoArray2 = moduleInfoSorter.getFailedList();
        object = new ArrayList(object52.length + moduleInfoArray2.length);
        object3 = object52;
        int n8 = object52.length;
        for (n2 = 0; n2 < n8; ++n2) {
            object4 = object3[n2];
            object.add((a)((ModuleInfo)object4).userObject);
        }
        object3 = moduleInfoArray2;
        n8 = moduleInfoArray2.length;
        for (n2 = 0; n2 < n8; ++n2) {
            object4 = object3[n2];
            object.add((a)((ModuleInfo)object4).userObject);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object3 = object4 = (a)iterator.next();
            if (hashSet.contains(object4)) {
                ++n5;
                continue;
            }
            hashSet.add(object4);
            ++n5;
            try {
                moduleInfoArray = compilerTargetMode == SmiCompiler.TargetMode.dryRun || compilerTargetMode == SmiCompiler.TargetMode.dryRunWithoutErrorLimit ? this.b.checkModules(((a)object4).a(), strictness == SmiCompiler.Strictness.lenient, compilerTargetMode == SmiCompiler.TargetMode.dryRunWithoutErrorLimit) : (strictness == SmiCompiler.Strictness.lenient ? this.b.addModulesLeniently(((a)object4).a(), ((NamedInputStream)object4).getName()) : this.b.addModules(((a)object4).a(), ((NamedInputStream)object4).getName()));
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (ModuleInfo moduleInfo : moduleInfoArray) {
                    arrayList2.add(moduleInfo.moduleName);
                    if (compilerTargetMode != SmiCompiler.TargetMode.storeIntoRepositoryAndLoad) continue;
                    SmiManager smiManager = this;
                    smiManager.a(smiManager.b.getModule(moduleInfo.moduleName, true), false);
                }
                if (compilationMonitor != null && !compilationMonitor.compilationProgress(arrayList2.isEmpty() ? null : (String)arrayList2.get(0), n5, object.size())) break;
                ((ArrayList)object2).add(new CompilationResult(((NamedInputStream)object4).getName(), arrayList2, null, ((a)object4).b));
            }
            catch (SMIParseException sMIParseException) {
                SMIParseException sMIParseException2 = sMIParseException;
                sMIParseException.freeUnusedTokens();
                ((ArrayList)object2).add(new CompilationResult(((NamedInputStream)object3).getName(), null, SmiManager.a(sMIParseException2, ((NamedInputStream)object3).getName()).getErrorList(), ((a)object3).b));
            }
        }
        return object2;
    }

    private static boolean a(ModuleInfo moduleInfo, ModuleInfo moduleInfo2) {
        return moduleInfo.getLastUpdated() == null && moduleInfo2.getLastUpdated() != null || moduleInfo.getLastUpdated() != null && moduleInfo2.getLastUpdated() != null && moduleInfo2.getLastUpdated().after(moduleInfo.getLastUpdated());
    }

    /*
     * WARNING - void declaration
     */
    public final List<CompilationResult> compile(NamedInputStream[] files, CompilationMonitor compilationMonitor, boolean loadIntoRepository, boolean updateExistent, boolean compileLeniently) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.compile((NamedInputStream[])var1_1, (CompilationMonitor)var2_2, var3_3 != false ? SmiCompiler.TargetMode.storeIntoRepositoryAndLoad : SmiCompiler.TargetMode.storeIntoRepositoryNoLoad, updateExistent ? SmiCompiler.OverwriteMode.overwriteAlways : SmiCompiler.OverwriteMode.addNewOnly, compileLeniently ? SmiCompiler.Strictness.lenient : SmiCompiler.Strictness.standard);
    }

    private ValueConverter a(MIBObjectType mIBObjectType) {
        MIBTextualConvention mIBTextualConvention = this.c.getEffectiveSyntax(mIBObjectType.getSyntax());
        String string = mIBTextualConvention.getDisplayHint();
        if (string == null && this.e != null && !this.e.getDisplayHint().isEmpty()) {
            string = this.e.getDisplayHint();
        }
        return new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), string);
    }

    private static SmiParseException a(SMIParseException list, String string) {
        ArrayList<SmiError> arrayList = new ArrayList<SmiError>();
        list = ((SMIParseException)((Object)list)).getErrorList() != null && !((SMIParseException)((Object)list)).getErrorList().isEmpty() ? ((SMIParseException)((Object)list)).getErrorList() : Collections.singletonList(list);
        for (SMIParseException sMIParseException : list) {
            String string2 = "[" + string + "] " + DefaultRepositoryManager.getErrorText(sMIParseException);
            String string3 = DefaultRepositoryManager.getErrorText(sMIParseException, false, false);
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            String string4 = null;
            int n6 = -1;
            int n7 = sMIParseException.errorType;
            String[] stringArray = null;
            if (sMIParseException.fileError != null) {
                n2 = sMIParseException.fileError.getLine();
                n3 = sMIParseException.fileError.getColumn();
                n4 = sMIParseException.fileError.getEndLine();
                n5 = sMIParseException.fileError.getEndColumn();
                n7 = sMIParseException.fileError.getErrorType();
                string4 = sMIParseException.fileError.getFoundTokenImage() == null ? sMIParseException.fileError.getFound() : sMIParseException.fileError.getFoundTokenImage();
                n6 = sMIParseException.fileError.getEndPosition();
                if (string4 != null) {
                    n6 = Math.max(0, n6 - string4.length());
                }
                stringArray = sMIParseException.fileError.getLastExpectedImages();
            }
            arrayList.add(new SmiError(string, n2, n3, n4, n5, n6, n7, string2, string3, string4, stringArray));
        }
        Collections.sort(arrayList, new e(0));
        return new SmiParseException(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    public final String format(OID instanceOID, Variable variable, boolean withOID) {
        Object object;
        void var3_3;
        StringBuilder stringBuilder = new StringBuilder();
        if (var3_3 != false) {
            stringBuilder.append(this.format(instanceOID.getValue()));
            stringBuilder.append(" = ");
        }
        object = (object = this.c.getObjectType(new ObjectID(object.getValue()))) != null ? this.a((MIBObjectType)object) : new ValueConverter(variable.getClass());
        if (this.e != null && this.e.getDisplayHint().length() > 0) {
            ((ValueConverter)object).setDisplayHint(this.e.getDisplayHint());
        }
        if ((object = ((ValueConverter)object).toNative(variable, true)) != null) {
            stringBuilder.append(object.toString());
        } else {
            void var2_2;
            stringBuilder.append(var2_2.toString());
        }
        return stringBuilder.toString();
    }

    public final VariableBinding parseVariableBinding(String text) throws ParseException {
        Variable variable;
        int n2 = text.indexOf(" = ");
        if (n2 <= 0) {
            throw new ParseException("Could not locate assignment ' = ' string in '" + text, 0);
        }
        OID oID = new OID(this.parse(text.substring(0, n2)));
        variable = this.parse(oID, variable.substring(n2 + 3));
        return new VariableBinding(oID, variable);
    }

    /*
     * WARNING - void declaration
     */
    public final Variable parse(OID classOrInstanceOID, String text) throws ParseException {
        void var2_2;
        MIBObjectType mIBObjectType;
        ValueConverter valueConverter = null;
        if ((mIBObjectType = this.c.getObjectType(new ObjectID(mIBObjectType.getValue()))) != null) {
            valueConverter = this.a(mIBObjectType);
        }
        if (valueConverter == null) {
            return null;
        }
        mIBObjectType = valueConverter.fromString((String)var2_2);
        return mIBObjectType;
    }

    /*
     * WARNING - void declaration
     */
    public final Variable parse(int smiSyntax, String text) throws ParseException {
        void var2_3;
        void var1_1;
        ValueConverter valueConverter = new ValueConverter(ValueConverter.getSmiSyntax((int)var1_1));
        return valueConverter.fromString((String)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public final String format(int[] value) {
        ObjectID objectID = new ObjectID(value);
        switch (this.f) {
            case ObjectNameNumIndex: {
                return this.c.getPathSuffix(objectID);
            }
            case ObjectNameAndDecodedIndex: {
                return this.a(objectID);
            }
            case ObjectNameAndDecodedIndex4RoundTrip: {
                return this.b(objectID);
            }
            case NameAndNumber: {
                void var1_1;
                return this.c.getPath(new ObjectID((int[])var1_1), true);
            }
        }
        return objectID.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String formatForRoundTrip(int[] value) {
        void var1_1;
        switch (this.f) {
            case ObjectNameNumIndex: 
            case ObjectNameAndDecodedIndex: {
                return this.c.getPathSuffix(new ObjectID(value));
            }
            case ObjectNameAndDecodedIndex4RoundTrip: {
                return this.b(new ObjectID(value));
            }
            case NameAndNumber: {
                return this.c.getPath(new ObjectID(value), true);
            }
        }
        return SimpleOIDTextFormat.formatOID((int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int[] parse(String text) throws ParseException {
        ObjectID objectID;
        int n2;
        String string = text;
        if (string.length() == 0) {
            return new int[0];
        }
        Object object = null;
        if (Character.isUpperCase(string.charAt(0))) {
            n2 = string.indexOf(58);
            if (n2 < 0) {
                n2 = string.indexOf(46);
            }
            if (n2 > 0) {
                object = string.substring(0, n2);
                if (!this.isModuleLoaded((String)object) && !this.loadModule((String)object)) {
                    throw new ParseException("MIB module '" + (String)object + "' not found", 0);
                }
                string = string.substring(n2 + 1);
            }
        }
        if (this.f == OIDFormat.NameAndNumber) {
            String[] stringArray = string.split("\\.");
            int[] nArray = new int[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].endsWith(")")) {
                    int n3 = stringArray[i2].indexOf(40);
                    if (n3 < 0) {
                        throw new ParseException(stringArray[i2], i2);
                    }
                    nArray[i2] = Long.valueOf(stringArray[i2].substring(n3 + 1, stringArray[i2].length() - 1)).intValue();
                    continue;
                }
                nArray[i2] = Long.valueOf(stringArray[i2]).intValue();
            }
            return nArray;
        }
        if (this.f == OIDFormat.ObjectNameAndDecodedIndex4RoundTrip) {
            n2 = string.indexOf(46);
            char c2 = string.charAt(0);
            if (n2 >= 0 && (Character.isLetter(c2) || c2 == this.l || c2 == this.m)) {
                String string2 = string.substring(n2 + 1);
                string = string.substring(0, n2);
                if ((object = object != null ? this.c.getObject((String)object, string) : this.c.getObject(string)) instanceof MIBObjectType) {
                    if (((MIBObjectType)(object = (MIBObjectType)object)).isColumnarObject()) {
                        ValueConverter[] valueConverterArray = this.c.getParent((MIBObject)object);
                        if (valueConverterArray instanceof MIBObjectType) {
                            valueConverterArray = (MIBObjectType)valueConverterArray;
                            try {
                                int n4;
                                object = new OID(((MIBObject)object).getOid().asIntArray());
                                IndexStruct[] indexStructArray = valueConverterArray.getIndexPart().getIndexStruct(this.c);
                                List<String> list = SmiManager.tokenizeQuotedString(string2, "" + this.m + this.l, this.p, ".", true);
                                valueConverterArray = IndexConverter.getIndexValueConverter(this.c, (MIBObjectType)valueConverterArray);
                                int n5 = 0;
                                boolean bl = false;
                                for (n4 = 0; n4 < Math.min(list.size(), Math.min(valueConverterArray.length, indexStructArray.length)); ++n4) {
                                    String string3 = list.get(n4 + n5);
                                    if (string3.charAt(0) == this.m || string3.charAt(0) == this.l) {
                                        Object object2;
                                        if ((string3 = string3.substring(1, string3.length() - 1)).length() > 2) {
                                            if (string3.charAt(0) == '#') {
                                                object2 = IndexConverter.StringFormat.getFormat(string3.substring(0, 2));
                                                string3 = OctetString.fromString((String)string3.substring(2, string3.length()), (char)((IndexConverter.StringFormat)((Object)object2)).getDelimiter(), (int)((IndexConverter.StringFormat)((Object)object2)).getRadix());
                                                string3 = new String(string3.getValue());
                                            } else if (string3.charAt(0) == this.p) {
                                                string3 = string3.substring(1);
                                            }
                                        }
                                        if ((object2 = valueConverterArray[n4].fromString(string3)) == null) continue;
                                        object.append(object2.toSubIndex(indexStructArray[n4].impliedLength));
                                        continue;
                                    }
                                    if (indexStructArray[n4].impliedLength) {
                                        for (int i3 = n4 + n5; i3 < list.size(); ++i3) {
                                            object.append(list.get(i3));
                                        }
                                        bl = true;
                                        break;
                                    }
                                    if (indexStructArray[n4].minLength == indexStructArray[n4].maxLength) {
                                        int n6 = indexStructArray[n4].minLength;
                                        for (int i4 = n4 + n5; i4 < list.size() && i4 < n4 + n5 + n6; ++i4) {
                                            object.append(list.get(i4));
                                        }
                                        n5 += n6 - 1;
                                        continue;
                                    }
                                    int n7 = Integer.parseInt(string3);
                                    for (int i5 = n4 + n5; i5 < list.size() && i5 < n4 + n5 + n7 + 1; ++i5) {
                                        object.append(list.get(i5));
                                    }
                                    n5 += n7;
                                }
                                if (!bl && list.size() > n4 + n5) {
                                    this.a(string2, n4, (OID)object);
                                }
                                return object.getValue();
                            }
                            catch (ObjectIDFormatException objectIDFormatException) {}
                        }
                        string = string + '.' + string2;
                    } else if (((MIBObjectType)object).isScalar()) {
                        string = string + '.' + string2;
                    }
                } else if (object != null) {
                    try {
                        object = new OID(((MIBObject)object).getOid().asIntArray());
                        this.a(string2, 0, (OID)object);
                        return object.getValue();
                    }
                    catch (ObjectIDFormatException objectIDFormatException) {}
                }
            }
        }
        if ((objectID = this.c.resolveOID(new ObjectID(string))) == null) {
            void var1_1;
            throw new ParseException("Could not resolve OID '" + (String)var1_1 + "'", 0);
        }
        try {
            return objectID.asIntArray();
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            throw new ParseException("Could not resolve OID '" + objectID + "'", 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void a(String var1_1, int var2_2, OID var3_3) {
        var1_1 = SmiManager.tokenizeQuotedString((String)var1_1, "" + this.l + this.m, this.p, ".", true);
        var4_4 = this.p + "#";
        while (var2_2 < var1_1.size()) {
            block5: {
                block6: {
                    var5_5 = (String)var1_1.get(var2_2);
                    if (var5_5.isEmpty()) break block5;
                    var6_6 = var5_5.charAt(0);
                    if (var6_6 != this.l && var6_6 != this.m) break block6;
                    if (var5_5.length() <= 2) ** GOTO lbl-1000
                    if (var5_5.charAt(1) == '#') {
                        var7_7 = IndexConverter.StringFormat.getFormat(var5_5.substring(1, 3));
                        var5_5 = OctetString.fromString((String)var5_5.substring(3, var5_5.length() - 1), (char)var7_7.getDelimiter(), (int)var7_7.getRadix());
                        var3_3.append(var5_5.toSubIndex(var6_6 == '\''));
                    } else if (var5_5.startsWith(var4_4, 1)) {
                        var3_3.append(new OctetString(var5_5.substring(2, var5_5.length() - 1)).toSubIndex(var6_6 == this.l));
                    } else lbl-1000:
                    // 2 sources

                    {
                        var3_3.append(new OctetString(var5_5.substring(1, var5_5.length() - 1)).toSubIndex(var6_6 == this.l));
                    }
                    break block5;
                }
                var3_3.append(new OID(var5_5));
            }
            ++var2_2;
        }
    }

    public static List<String> tokenizeQuotedString(String text, String quotes, char escapeChar, String delimiter, boolean includeQuotes) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = -1;
        boolean bl = false;
        Character c2 = null;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c3 = text.charAt(i2);
            if (c3 == escapeChar) {
                if (bl2) {
                    bl2 = false;
                    stringBuilder.append(text.substring(n2, n3)).append(c3);
                    n2 = i2 + 1;
                    continue;
                }
                bl2 = true;
                n3 = i2;
                continue;
            }
            if (bl2) {
                bl2 = false;
                stringBuilder.append(text.substring(n2, n3)).append(c3);
                n2 = i2 + 1;
                continue;
            }
            if (quotes.indexOf(c3) >= 0) {
                if (c2 == null) {
                    bl = true;
                    c2 = Character.valueOf(c3);
                    if (!includeQuotes) {
                        stringBuilder.append(text.substring(n2, i2));
                        n2 = i2 + 1;
                    }
                } else if (c2.charValue() == c3) {
                    bl = false;
                    c2 = null;
                    if (!includeQuotes) {
                        stringBuilder.append(text.substring(n2, i2));
                        n2 = i2 + 1;
                    }
                }
            }
            if ((c3 = i2 == text.length() - 1 ? (char)'\u0001' : '\u0000') != '\u0000') {
                arrayList.add(stringBuilder.toString() + text.substring(n2));
                stringBuilder.setLength(0);
                continue;
            }
            if (delimiter.indexOf(text.charAt(i2)) < 0 || bl) continue;
            arrayList.add(stringBuilder.toString() + text.substring(n2, i2));
            n2 = i2 + 1;
            stringBuilder.setLength(0);
        }
        return arrayList;
    }

    private String a(ObjectID objectID) {
        try {
            ObjectID[] objectIDArray = this.c.getSplittedObjectID(objectID);
            if (objectIDArray.second != null && ((ObjectID)objectIDArray.second).size() > 0) {
                Comparable comparable = (ObjectID)objectIDArray.first;
                objectIDArray = (ObjectID)objectIDArray.second;
                ValueConverter[] valueConverterArray = (ValueConverter[])this.c.getParent((MIBObject)(comparable = this.c.getObject((ObjectID)comparable)));
                if (valueConverterArray != null) {
                    IndexStruct[] indexStructArray;
                    if (valueConverterArray.getIndexPart().isAugment()) {
                        valueConverterArray = (MIBObjectType)this.c.getObject(valueConverterArray.getIndexPart().getIndexPart()[0]);
                    }
                    if ((indexStructArray = valueConverterArray.getIndexPart().getIndexStruct(this.c)) != null) {
                        try {
                            objectIDArray = this.c.getIndexObjectIDs((ObjectID)objectIDArray, indexStructArray);
                            valueConverterArray = this.b((MIBObjectType)valueConverterArray);
                            return ((MIBObject)comparable).getName() + "." + IndexConverter.getIndexString(valueConverterArray, indexStructArray, objectIDArray);
                        }
                        catch (NullPointerException nullPointerException) {
                            objectIDArray = nullPointerException;
                            nullPointerException.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {}
        return this.c.getPathSuffix(objectID);
    }

    private String b(ObjectID objectID) {
        block6: {
            try {
                IndexStruct[] indexStructArray;
                ObjectID[] objectIDArray = this.c.getSplittedObjectID(objectID);
                if (objectIDArray.second == null || ((ObjectID)objectIDArray.second).isEmpty()) break block6;
                Comparable comparable = (ObjectID)objectIDArray.first;
                objectIDArray = (ObjectID)objectIDArray.second;
                ValueConverter[] valueConverterArray = this.c.getParent((MIBObject)(comparable = this.c.getObject((ObjectID)comparable)));
                if (!(valueConverterArray instanceof MIBObjectType)) break block6;
                if ((valueConverterArray = (MIBObjectType)valueConverterArray).getIndexPart().isAugment()) {
                    valueConverterArray = (MIBObjectType)this.c.getObject(valueConverterArray.getIndexPart().getIndexPart()[0]);
                }
                if ((indexStructArray = valueConverterArray.getIndexPart().getIndexStruct(this.c)) == null) break block6;
                try {
                    objectIDArray = this.c.getIndexObjectIDs((ObjectID)objectIDArray, indexStructArray);
                    valueConverterArray = this.b((MIBObjectType)valueConverterArray);
                    if (objectIDArray != null && valueConverterArray != null) {
                        return ((MIBObject)comparable).getName() + "." + IndexConverter.getIndexString(valueConverterArray, indexStructArray, objectIDArray, true, "" + this.l, "" + this.m, this.n, this.o, IndexConverter.StringFormat.getFormat(this.g.getRadix()));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    objectIDArray = nullPointerException;
                    nullPointerException.printStackTrace();
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
        return this.c.getPathSuffix(objectID);
    }

    public final NonPrintableStringFormat getOidFormatNonPrintableStrings() {
        return this.g;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOidFormatNonPrintableStrings(NonPrintableStringFormat oidFormatNonPrintableStrings) {
        void var1_1;
        if (oidFormatNonPrintableStrings == null) {
            throw new NullPointerException();
        }
        this.g = var1_1;
    }

    public final Variable[] getIndexVariables(OID table, OID index) {
        IndexStruct[] indexStructArray;
        if ((indexStructArray = this.c.getObject(new ObjectID(indexStructArray.getValue()))) instanceof MIBObjectType && (indexStructArray = (MIBObjectType)indexStructArray).getIndexPart() != null) {
            if (indexStructArray.getIndexPart().isAugment()) {
                indexStructArray = (MIBObjectType)this.c.getObject(indexStructArray.getIndexPart().getIndexPart()[0]);
            }
            if ((indexStructArray = indexStructArray.getIndexPart().getIndexStruct(this.c)) != null) {
                ObjectID[] objectIDArray;
                objectIDArray = this.c.getIndexObjectIDs(new ObjectID(objectIDArray.getValue()), indexStructArray);
                return IndexConverter.getIndexVariables(indexStructArray, objectIDArray);
            }
        }
        return null;
    }

    public final String getIndexStringFromVariables(OID table, List<VariableBinding> indexObjects) {
        MIBObject mIBObject;
        if ((mIBObject = this.c.getObject(new ObjectID(mIBObject.getValue()))) instanceof MIBObjectType && ((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject)).getIndexPart() != null) {
            Iterator iterator;
            if (((MIBObjectType)mIBObject).getIndexPart().isAugment()) {
                mIBObject = (MIBObjectType)this.c.getObject(((MIBObjectType)mIBObject).getIndexPart().getIndexPart()[0]);
            }
            Variable[] variableArray = new Variable[indexObjects.size()];
            int n2 = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                VariableBinding variableBinding = (VariableBinding)iterator.next();
                variableArray[n2++] = variableBinding.getVariable();
            }
            return IndexConverter.getIndexValueString(this.c, (MIBObjectType)mIBObject, variableArray, true, "" + this.l, "" + this.m, this.n, this.o, IndexConverter.StringFormat.getFormat(this.g.getRadix()));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final SmiObject findSmiObject(OID oid) {
        if (!this.k) {
            throw new UnsupportedOperationException();
        }
        MIBObject mIBObject = this.c.getObject(new ObjectID(oid.getValue()));
        if (mIBObject != null) {
            void var1_1;
            return this.a(mIBObject, (OID)var1_1);
        }
        return null;
    }

    public final SmiObjectType findSmiObjectType(OID oidInstance) {
        MIBObjectType mIBObjectType;
        if (!this.k) {
            throw new UnsupportedOperationException();
        }
        if ((mIBObjectType = this.c.getObjectType(new ObjectID(mIBObjectType.getValue()))) != null) {
            try {
                return (SmiObjectType)this.a(mIBObjectType, new OID(mIBObjectType.getOid().asIntArray()));
            }
            catch (ObjectIDFormatException objectIDFormatException) {}
        }
        return null;
    }

    public final SmiObject findRootSmiObject() {
        if (!this.k) {
            throw new UnsupportedOperationException();
        }
        MIBObject mIBObject = this.c.getNextObject(new ObjectID());
        if (mIBObject != null) {
            return this.a(mIBObject, new OID(mIBObject.getPrintableOid()));
        }
        return null;
    }

    public final SmiObject findRootSmiObject(String moduleName) {
        Comparable comparable;
        if (!this.k) {
            throw new UnsupportedOperationException();
        }
        if ((comparable = this.c.getModule((String)((Object)comparable))) != null) {
            MIBObject mIBObject;
            comparable = ((MIBObject)comparable).getModuleID();
            ObjectID objectID = new ObjectID();
            do {
                if ((mIBObject = this.c.getNextObject(objectID)) == null || mIBObject.getOid() == null) continue;
                objectID = mIBObject.getOid();
            } while (mIBObject != null && !comparable.equals(mIBObject.getModuleID()));
            if (mIBObject != null) {
                return this.a(mIBObject, new OID(mIBObject.getPrintableOid()));
            }
        }
        return null;
    }

    public final SmiModule findSmiModule(String moduleName) {
        MIBModule mIBModule;
        if (!this.k) {
            throw new UnsupportedOperationException();
        }
        if ((mIBModule = this.c.getModule((String)((Object)mIBModule))) != null) {
            return new i(this, mIBModule, new OID(mIBModule.getPrintableOid()), 0);
        }
        return null;
    }

    public final List<SmiModule> findSmiModules(OID smiObjectIdentifier) {
        MIBObject[] mIBObjectArray;
        if (!this.k) {
            throw new UnsupportedOperationException();
        }
        if ((mIBObjectArray = this.c.getObjectsByOid(new ObjectID(mIBObjectArray.getValue()))) != null && mIBObjectArray.length > 0) {
            HashSet<i> hashSet = new HashSet<i>(mIBObjectArray.length);
            for (MIBObject mIBObject : mIBObjectArray) {
                MIBModule mIBModule = this.c.getModule(mIBObject.getModuleID());
                if (mIBModule == null) continue;
                hashSet.add(new i(this, mIBModule, new OID(mIBModule.getPrintableOid()), 0));
                System.out.println("smiModule=" + mIBModule.getModuleID() + "=" + mIBModule.getOid() + "|" + mIBObject.getOid() + "=" + mIBObject.getName());
            }
            return new ArrayList<SmiModule>(hashSet);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final SmiObject findSmiObject(String moduleName, String objectName) {
        void var2_2;
        MIBObject mIBObject;
        if (!this.k) {
            throw new UnsupportedOperationException();
        }
        if ((mIBObject = this.c.getObject((String)((Object)mIBObject), (String)var2_2)) != null) {
            MIBObject mIBObject2 = mIBObject;
            return this.a(mIBObject2, mIBObject2.getOid() != null ? new OID(mIBObject.getPrintableOid()) : null);
        }
        return null;
    }

    public final SmiObject findSmiObject(String moduleName, String objectName, boolean includeImportedModules) {
        while (true) {
            Object object;
            if (!this.k) {
                throw new UnsupportedOperationException();
            }
            MIBObject mIBObject = this.c.getObject(moduleName, objectName);
            if (mIBObject != null) {
                MIBObject mIBObject2 = mIBObject;
                return this.a(mIBObject2, mIBObject2.getOid() != null ? new OID(mIBObject.getPrintableOid()) : null);
            }
            if (!includeImportedModules || (object = this.c.getModule(moduleName)) == null || (object = ((MIBModule)object).getImportSource(objectName)) == null) break;
            includeImportedModules = true;
        }
        return null;
    }

    public final <S extends SmiObject> List<S> findSmiObject(String moduleName, SmiObjectFilter<S> filter) {
        Comparable comparable;
        if (!this.k) {
            throw new UnsupportedOperationException();
        }
        ArrayList<MIBModule> arrayList = new ArrayList<MIBModule>();
        Enumeration<? extends MIBObject> enumeration = this.c.objects();
        if (moduleName != null && (comparable = this.c.getModule((String)((Object)comparable))) != null) {
            enumeration = comparable.objects();
        }
        while (enumeration.hasMoreElements()) {
            comparable = enumeration.nextElement();
            SmiType smiType = comparable instanceof MIBObjectType ? SmiManager.c((MIBObjectType)comparable) : SmiType.fromJasmiType(comparable.getType());
            if (!filter.passesFilter(smiType)) continue;
            MIBObject mIBObject = comparable;
            comparable = this.a(mIBObject, mIBObject.getOid() != null ? new OID(comparable.getPrintableOid()) : null);
            if (!filter.passesFilter((MIBModule)comparable)) continue;
            arrayList.add((MIBModule)comparable);
        }
        return arrayList;
    }

    public final void setIncludeUnknownErrorsCause(boolean includeUnknownErrorsCause) {
        DefaultRepositoryManager.setForwardUnknownErrors(includeUnknownErrorsCause);
    }

    public final boolean isIncludeUnknownErrorsCause() {
        return DefaultRepositoryManager.isForwardUnknownErrors();
    }

    public final void setSmiErrorTextResourceBundle(String resourceBundleClassName) {
        DefaultRepositoryManager.setResourceClassName(resourceBundleClassName);
    }

    /*
     * WARNING - void declaration
     */
    public final void setStoreFilenamesInRepository(boolean storeFilenameInRepository) {
        void var1_1;
        System.setProperty("com.agentpp.smi.storeMIBFileName", Boolean.toString((boolean)var1_1));
    }

    public final boolean isStoreFilenamesInRepository() {
        return Boolean.getBoolean("com.agentpp.smi.storeMIBFileName");
    }

    private SmiObject a(MIBObject mIBObject, OID oID) {
        if (this.k) {
            if (mIBObject instanceof MIBObjectType) {
                return new m(this, (MIBObjectType)mIBObject, oID, 0);
            }
            if (mIBObject instanceof MIBTextualConvention) {
                return new r(this, (MIBTextualConvention)mIBObject, 0);
            }
            if (mIBObject instanceof MIBGroup) {
                return new f(this, (MIBGroup)mIBObject, oID);
            }
            if (mIBObject instanceof MIBModule) {
                return new i(this, (MIBModule)mIBObject, oID, 0);
            }
            if (mIBObject instanceof MIBNotifyType) {
                return new j(this, (MIBNotifyType)mIBObject, oID, 0);
            }
            if (mIBObject instanceof MIBCompliance) {
                return new h(this, (MIBCompliance)mIBObject, oID);
            }
            if (mIBObject instanceof MIBAgentCaps) {
                return new c(this, (MIBAgentCaps)mIBObject, oID);
            }
            return new l(this, mIBObject, oID, 0);
        }
        return null;
    }

    private ValueConverter[] b(MIBObjectType mIBObjectType) {
        if (!mIBObjectType.isTable()) {
            return null;
        }
        Vector<? extends MIBObjectType> vector = this.c.getColumnarObjectsOfTable(mIBObjectType, true, false);
        if (mIBObjectType.userObject instanceof ValueConverter[]) {
            return (ValueConverter[])mIBObjectType.userObject;
        }
        ValueConverter[] valueConverterArray = new ValueConverter[vector.size()];
        for (int i2 = 0; i2 < valueConverterArray.length; ++i2) {
            MIBObjectType mIBObjectType2 = vector.elementAt(i2);
            MIBTextualConvention mIBTextualConvention = this.c.getEffectiveSyntax(mIBObjectType2.getSyntax());
            valueConverterArray[i2] = new ValueConverter(mIBObjectType2, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
        }
        mIBObjectType.userObject = valueConverterArray;
        return valueConverterArray;
    }

    private static int b(int n2) {
        switch (n2) {
            case 0: 
            case 8: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: {
                n2 = 65;
                break;
            }
            case 6: {
                n2 = 70;
                break;
            }
            case 10: {
                n2 = 68;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 6;
                break;
            }
            case 9: 
            case 15: {
                n2 = 64;
                break;
            }
            case 4: 
            case 7: 
            case 13: {
                n2 = 66;
                break;
            }
            case 11: {
                n2 = 67;
                break;
            }
            case 12: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 5;
            }
        }
        return n2;
    }

    private int b(ISyntax object) {
        if (object != null) {
            object = this.c.getEffectiveSyntax((ISyntax)object);
            return SmiManager.b(SMI.smiSyntax(((MIBTextualConvention)object).getSyntax().getSyntax()));
        }
        return 0;
    }

    private static SmiType c(MIBObjectType mIBObjectType) {
        if (mIBObjectType.isTable()) {
            return SmiType.OBJECT_TYPE_TABLE_ENTRY;
        }
        if (mIBObjectType.isColumnarObject()) {
            return SmiType.OBJECT_TYPE_COLUMN;
        }
        if (mIBObjectType.isTableSequence()) {
            return SmiType.OBJECT_TYPE_TABLE;
        }
        return SmiType.OBJECT_TYPE_SCALAR;
    }

    private static List<SmiSyntaxElement> c(ISyntax object) {
        ArrayList<com.snmp4j.smi.a> arrayList = new ArrayList<com.snmp4j.smi.a>();
        if (object.hasEnums()) {
            for (IEnum iEnum : object.getEnums()) {
                arrayList.add(new com.snmp4j.smi.a(SmiSyntaxElement.Type.Enumeration, iEnum.getLabel(), iEnum.getLongValue(), null));
            }
        } else if (object.hasRanges()) {
            for (IRange iRange : object.getRanges()) {
                arrayList.add(new com.snmp4j.smi.a(SmiSyntaxElement.Type.Range, null, iRange.getLowerValue(), iRange.getUpper()));
            }
        }
        List<SmiSyntaxElement> list = Collections.unmodifiableList(arrayList);
        return list;
    }

    private static SmiSyntaxType d(ISyntax iSyntax) {
        if (iSyntax == null) {
            return null;
        }
        switch (iSyntax.getType()) {
            case 1: {
                return SmiSyntaxType.APPLICATION;
            }
            case 3: {
                return SmiSyntaxType.CONVENTION;
            }
            case 2: {
                return SmiSyntaxType.SEQUENCE;
            }
            case 0: {
                return SmiSyntaxType.SIMPLE;
            }
        }
        return null;
    }

    private /* synthetic */ Boolean a(MIBModule mIBModule) throws Exception {
        return this.a(mIBModule, true);
    }

    static /* synthetic */ SmiSyntaxImpl b(SmiManager smiManager, ISyntax iSyntax) {
        SmiSyntaxType smiSyntaxType = SmiManager.d(iSyntax);
        SmiSyntaxImpl smiSyntaxImpl = null;
        String string = null;
        if (iSyntax != null) {
            Object object = smiManager.c.getEffectiveSyntax(iSyntax);
            if (smiSyntaxType == SmiSyntaxType.CONVENTION && object != null) {
                smiSyntaxImpl = new SmiSyntaxImpl(((MIBTextualConvention)object).getSyntax().getSyntax(), SmiManager.d(((MIBTextualConvention)object).getSyntax()), smiManager.b(iSyntax), SmiManager.c(((MIBTextualConvention)object).getSyntax()));
                string = ((MIBTextualConvention)object).getDisplayHint();
            }
            object = SmiManager.c(iSyntax);
            return new SmiSyntaxImpl(iSyntax.getSyntax(), smiSyntaxType, smiManager.b(iSyntax), (List<SmiSyntaxElement>)object, smiSyntaxImpl, string);
        }
        return null;
    }

    public static enum OctetStringDefaultFormat {
        MIB(""),
        ASCII("255a"),
        Hexadecimal("1x:"),
        Decimal("1d."),
        Binary("1b:");

        private final String displayHint;

        /*
         * WARNING - void declaration
         */
        private OctetStringDefaultFormat(String displayHint) {
            void var3_3;
            this.displayHint = var3_3;
        }

        public final String getDisplayHint() {
            return this.displayHint;
        }
    }

    private final class b
    implements ExtRepsitoryListener {
        private /* synthetic */ SmiManager a;

        private b(SmiManager smiManager) {
            this.a = smiManager;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeModule(RepositoryEvent repositoryEvent) {
            void var1_1;
            this.afterReadModule(repositoryEvent);
            RepositoryIO repositoryIO = new RepositoryIO(this, repositoryEvent.getModuleName());
            if (this.a.i != null) {
                this.a.i.writeModule(repositoryIO);
                repositoryEvent.setUseDefaults(false);
                repositoryEvent.setOutputStream(repositoryIO.getOutputStream());
                return;
            }
            var1_1.setUseDefaults(true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void readModule(RepositoryEvent repositoryEvent) {
            void var1_1;
            RepositoryIO repositoryIO = new RepositoryIO(this, repositoryEvent.getModuleName());
            if (this.a.i != null) {
                this.a.i.readModule(repositoryIO);
                repositoryEvent.setInputStream(repositoryIO.getInputStream());
                repositoryEvent.setUseDefaults(false);
                return;
            }
            var1_1.setUseDefaults(true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void deleteModule(RepositoryEvent repositoryEvent) {
            void var1_1;
            RepositoryIO repositoryIO = new RepositoryIO(this, repositoryEvent.getModuleName());
            if (this.a.i != null) {
                this.a.i.deleteModule(repositoryIO);
                repositoryEvent.setModuleDeleted(repositoryIO.isModuleDeleted());
                repositoryEvent.setUseDefaults(false);
                return;
            }
            var1_1.setUseDefaults(true);
        }

        @Override
        public final String[] listModuleNames() {
            if (this.a.i != null) {
                return this.a.i.listModuleNames();
            }
            try {
                return this.a.b.getModuleNamesFromDirectory();
            }
            catch (IOException iOException) {
                a.error((CharSequence)("Unable to read MIB repository: " + iOException.getMessage()), (Throwable)iOException);
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void afterReadModule(RepositoryEvent repositoryEvent) {
            void var1_1;
            if (this.a.j && var1_1.getModule().getPrintableOid().startsWith("1.3.6.1.4")) {
                throw new RuntimeException("Please purchase the full SNMP4J-SMI version to use enterprise specific MIB modules");
            }
        }

        /* synthetic */ b(SmiManager smiManager, byte by) {
            this(smiManager);
        }
    }

    public static enum OIDFormat {
        Numbers,
        ObjectNameNumIndex,
        ObjectNameAndDecodedIndex,
        ObjectNameAndDecodedIndex4RoundTrip,
        NameAndNumber;

    }

    public static enum NonPrintableStringFormat {
        asIs('\u0000', 0),
        hex(':', 16),
        decimal('.', 10),
        octal(':', 8),
        binary(':', 2);

        private final char separator;
        private final int radix;

        /*
         * WARNING - void declaration
         */
        private NonPrintableStringFormat(char separator, int radix) {
            void var3_3;
            this.separator = var3_3;
            this.radix = radix;
        }

        public final int getRadix() {
            return this.radix;
        }

        public final char getSeparator() {
            return this.separator;
        }
    }

    private static final class a
    extends NamedInputStream {
        private byte[] a;
        private String b;

        private a(byte[] byArray, String string, String string2) {
            super(null, string, NamedInputStream.ZipFormat.none);
            this.a = byArray;
            this.b = string2;
        }

        private static byte[] a(InputStream inputStream) throws IOException {
            int n2;
            inputStream = new BufferedInputStream(inputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[16384];
            while ((n2 = ((BufferedInputStream)inputStream).read(byArray, 0, 16384)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }

        public final InputStream a() throws IOException {
            if (this.a == null) {
                this.a = com.snmp4j.smi.SmiManager$a.a(this.getInputStream());
            }
            return new ByteArrayInputStream(this.a);
        }

        static /* synthetic */ List a(NamedInputStream namedInputStream) throws IOException {
            if (namedInputStream.getZipFormat() == NamedInputStream.ZipFormat.ZIP) {
                ZipEntry zipEntry;
                ArrayList<a> arrayList = new ArrayList<a>();
                ZipInputStream zipInputStream = new ZipInputStream(namedInputStream.getInputStream());
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    arrayList.add(new a(com.snmp4j.smi.SmiManager$a.a(zipInputStream), zipEntry.getName(), namedInputStream.getName()));
                }
                return arrayList;
            }
            return Collections.singletonList(new a(com.snmp4j.smi.SmiManager$a.a(namedInputStream.getInputStream()), namedInputStream.getName(), null));
        }
    }

    private static final class e
    implements Comparator<SmiError> {
        private e() {
        }

        @Override
        public final /* synthetic */ int compare(Object object, Object object2) {
            object2 = (SmiError)object2;
            object = (SmiError)object;
            return ((SmiError)object).getPosition() - ((SmiError)object2).getPosition();
        }

        /* synthetic */ e(byte by) {
            this();
        }
    }

    private final class i
    extends l
    implements SmiModuleIdentity {
        private List<String> b;
        private List<String> c;
        private Collection<OID> d;
        private /* synthetic */ SmiManager e;

        private i(SmiManager smiManager, MIBModule mIBModule, OID oID) {
            this.e = smiManager;
            super(smiManager, mIBModule, oID, (byte)0);
        }

        @Override
        public final String getOrganization() {
            i i2 = this;
            return MIBObject.getUnquotedString(((MIBModule)i2.a).getOrganization());
        }

        @Override
        public final String getContactInfo() {
            i i2 = this;
            return MIBObject.getUnquotedString(((MIBModule)i2.a).getContactInfo());
        }

        @Override
        public final String getLastUpdatedString() {
            i i2 = this;
            return MIBObject.getUnquotedString(((MIBModule)i2.a).getLastUpdated());
        }

        @Override
        public final GregorianCalendar getLastUpdated() {
            return MIBModule.getDateAndTimeFromUTC(this.getLastUpdatedString());
        }

        @Override
        public final List<SmiRevision> getRevisions() {
            IRevision[] iRevisionArray = this;
            iRevisionArray = ((MIBModule)this.a).getRevisions();
            ArrayList<p> arrayList = new ArrayList<p>(iRevisionArray.length);
            for (IRevision iRevision : iRevisionArray) {
                arrayList.add(new p(this.e, iRevision, 0));
            }
            return Collections.unmodifiableList(arrayList);
        }

        @Override
        public final List<SmiImport> getImports() {
            ArrayList<g> arrayList = new ArrayList<g>();
            i i2 = this;
            for (MIBImport mIBImport : ((MIBModule)i2.a).getImportsVector()) {
                arrayList.add(new g(this.e, mIBImport, 0));
            }
            return Collections.unmodifiableList(arrayList);
        }

        @Override
        public final List<String> getObjectNames() {
            if (this.c == null) {
                i i2 = this;
                synchronized (i2) {
                    if (this.c == null) {
                        Iterator iterator = this;
                        iterator = ((MIBModule)((l)((Object)iterator)).a).getObjectsVector();
                        ArrayList<String> arrayList = new ArrayList<String>(((Vector)((Object)iterator)).size());
                        iterator = ((Vector)((Object)iterator)).iterator();
                        while (iterator.hasNext()) {
                            MIBObject mIBObject = (MIBObject)iterator.next();
                            arrayList.add(mIBObject.getName());
                        }
                        this.c = Collections.unmodifiableList(arrayList);
                    }
                }
            }
            return this.c;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Collection<OID> getObjectIdentifiers(OIDComparator.OIDOrder orderBy) {
            void var1_1;
            Object object;
            if (this.d == null) {
                object = this;
                synchronized (object) {
                    if (this.d == null) {
                        Iterator iterator = this;
                        iterator = ((MIBModule)((l)((Object)iterator)).a).getObjectsVector();
                        TreeSet<OID> treeSet = new TreeSet<OID>();
                        iterator = iterator.iterator();
                        while (iterator.hasNext()) {
                            Comparable comparable = (MIBObject)iterator.next();
                            if ((comparable = ((MIBObject)comparable).getOid()) == null || ((ObjectID)comparable).size() <= 0) continue;
                            try {
                                treeSet.add(new OID(((ObjectID)comparable).asIntArray()));
                            }
                            catch (ObjectIDFormatException objectIDFormatException) {}
                        }
                        this.d = Collections.unmodifiableCollection(treeSet);
                    }
                }
            }
            if (var1_1 == OIDComparator.OIDOrder.breadthFirstOrder) {
                object = new TreeSet<OID>(new OIDComparator(OIDComparator.OIDOrder.breadthFirstOrder));
                ((TreeSet)object).addAll(this.d);
                return Collections.unmodifiableCollection(object);
            }
            return this.d;
        }

        @Override
        public final List<String> getTextualConventionNames() {
            if (this.b == null) {
                i i2 = this;
                synchronized (i2) {
                    if (this.b == null) {
                        Iterator iterator = this;
                        iterator = ((MIBModule)((l)((Object)iterator)).a).getTextualConventions();
                        ArrayList<String> arrayList = new ArrayList<String>(((Vector)((Object)iterator)).size());
                        iterator = ((Vector)((Object)iterator)).iterator();
                        while (iterator.hasNext()) {
                            MIBTextualConvention mIBTextualConvention = (MIBTextualConvention)iterator.next();
                            arrayList.add(mIBTextualConvention.getName());
                        }
                        this.b = Collections.unmodifiableList(arrayList);
                    }
                }
            }
            return this.b;
        }

        @Override
        public final String getSourceFilename() {
            i i2 = this;
            return ((MIBModule)i2.a).getFileName();
        }

        @Override
        public final String getSmiModuleDefinition() {
            return ((MIBModule)this.a).toSMI(1, this.e.c, "\n");
        }

        @Override
        public final String getModuleName() {
            i i2 = this;
            return ((MIBModule)i2.a).getModuleName();
        }

        @Override
        public final String[] getAsn1Comments() {
            String[] stringArray = new String[4];
            i i2 = this;
            stringArray[0] = ((MIBModule)i2.a).getCopyrightComment();
            i2 = this;
            stringArray[1] = ((MIBModule)i2.a).getComment();
            i2 = this;
            stringArray[2] = ((MIBModule)i2.a).getInlineComment();
            i2 = this;
            stringArray[3] = ((MIBModule)i2.a).getCopyrightCommentEnd();
            return stringArray;
        }

        /* synthetic */ i(SmiManager smiManager, MIBModule mIBModule, OID oID, byte by) {
            this(smiManager, mIBModule, oID);
        }
    }

    private class m
    extends l
    implements SmiObjectType {
        private SmiSyntax b;
        private /* synthetic */ SmiManager c;

        private m(SmiManager smiManager, MIBObjectType mIBObjectType, OID oID) {
            this.c = smiManager;
            super(smiManager, mIBObjectType, oID, (byte)0);
        }

        @Override
        public MaxAccess getMaxAccess() {
            return MaxAccess.fromSmiValue((String)((MIBObjectType)this.a).getAccess());
        }

        @Override
        public String getUnits() {
            return MIBObject.getUnquotedString(((MIBObjectType)this.a).getUnits());
        }

        @Override
        public int getMaxValueLength() {
            Object object = (MIBObjectType)this.a;
            if (((MIBObjectType)object).getSyntax() != null) {
                object = this.c.c.getEffectiveSyntax(((MIBObjectType)object).getSyntax());
                MIBSyntax mIBSyntax = ((MIBTextualConvention)object).getSyntax();
                if (mIBSyntax.getSyntax().equals("INTEGER") || mIBSyntax.getSyntax().equals("Integer32") || mIBSyntax.getSyntax().equals("Counter") || mIBSyntax.getSyntax().equals("Counter32") || mIBSyntax.getSyntax().equals("Counter64") || mIBSyntax.getSyntax().equals("UInteger32") || mIBSyntax.getSyntax().equals("Unsigned32") || mIBSyntax.getSyntax().equals("Gauge") || mIBSyntax.getSyntax().equals("Gauge32") || mIBSyntax.getSyntax().equals("TimeTicks") || mIBSyntax.getSyntax().equals("TimeStamp")) {
                    if (mIBSyntax.hasEnums() && OctetStringDefaultFormat.MIB == this.c.getOctetStringDisplayHint()) {
                        return mIBSyntax.getMaxEnumLabelLength();
                    }
                    long l2 = (long)(Math.pow(2.0, 32.0) - 1.0);
                    if (mIBSyntax.hasRanges()) {
                        l2 = mIBSyntax.getMaxOfRanges();
                    }
                    if (((MIBTextualConvention)object).hasDisplayHint()) {
                        object = ValueConverter.formatLong(l2, MIBObject.getUnquotedString(((MIBTextualConvention)object).getDisplayHint()));
                        if (object == null) {
                            return (int)Math.log10(l2) + 1;
                        }
                        return ((String)object).length();
                    }
                    object = AbstractVariable.createFromSyntax((int)this.getSmiSyntax());
                    if (object instanceof AssignableFromInteger) {
                        ((AssignableFromInteger)object).setValue((int)l2);
                    } else if (object instanceof AssignableFromLong) {
                        ((AssignableFromLong)object).setValue(l2);
                    }
                    object = this.c.format(this.getOID(), (Variable)object, false);
                    return ((String)object).length();
                }
                if (mIBSyntax.getSyntax().equals("IpAddress")) {
                    return 15;
                }
                if (mIBSyntax.getSyntax().equals("NetworkAddress")) {
                    return 15;
                }
                if (mIBSyntax.getSyntax().startsWith("OBJECT IDENTIFIER")) {
                    switch (this.c.getOidFormat()) {
                        case ObjectNameNumIndex: {
                            return 74;
                        }
                    }
                    return 1279;
                }
                if (mIBSyntax.getSyntax().startsWith("OCTET") || mIBSyntax.getSyntax().startsWith("BITS") || mIBSyntax.getSyntax().startsWith("Opaque")) {
                    long l3 = 32767L;
                    if (mIBSyntax.hasRanges()) {
                        l3 = mIBSyntax.getMaxOfRanges();
                    }
                    return (int)l3;
                }
            }
            return -1;
        }

        @Override
        public int getMinValueLength() {
            Object object = (MIBObjectType)this.a;
            if (((MIBObjectType)object).getSyntax() != null) {
                object = this.c.c.getEffectiveSyntax(((MIBObjectType)object).getSyntax());
                MIBSyntax mIBSyntax = ((MIBTextualConvention)object).getSyntax();
                if (mIBSyntax.getSyntax().equals("INTEGER") || mIBSyntax.getSyntax().equals("Integer32") || mIBSyntax.getSyntax().equals("Counter") || mIBSyntax.getSyntax().equals("Counter32") || mIBSyntax.getSyntax().equals("Counter64") || mIBSyntax.getSyntax().equals("UInteger32") || mIBSyntax.getSyntax().equals("Unsigned32") || mIBSyntax.getSyntax().equals("Gauge") || mIBSyntax.getSyntax().equals("Gauge32") || mIBSyntax.getSyntax().equals("TimeTicks") || mIBSyntax.getSyntax().equals("TimeStamp")) {
                    if (mIBSyntax.hasEnums() && OctetStringDefaultFormat.MIB == this.c.getOctetStringDisplayHint()) {
                        return mIBSyntax.getMinEnumLabelLength();
                    }
                    long l2 = 0L;
                    if (mIBSyntax.hasRanges()) {
                        l2 = mIBSyntax.getMinOfRanges();
                    }
                    if (((MIBTextualConvention)object).hasDisplayHint()) {
                        object = ValueConverter.formatLong(l2, ((MIBTextualConvention)object).getDisplayHint());
                        if (object == null) {
                            return 0;
                        }
                        return ((String)object).length();
                    }
                    object = AbstractVariable.createFromSyntax((int)this.getSmiSyntax());
                    if (object instanceof AssignableFromInteger) {
                        ((AssignableFromInteger)object).setValue((int)l2);
                    } else if (object instanceof AssignableFromLong) {
                        ((AssignableFromLong)object).setValue(l2);
                    }
                    object = this.c.format(this.getOID(), (Variable)object, false);
                    return ((String)object).length();
                }
                if (mIBSyntax.getSyntax().equals("IpAddress")) {
                    return 7;
                }
                if (mIBSyntax.getSyntax().equals("NetworkAddress")) {
                    return 7;
                }
                if (mIBSyntax.getSyntax().startsWith("OBJECT IDENTIFIER")) {
                    return 1;
                }
                if (mIBSyntax.getSyntax().startsWith("OCTET") || mIBSyntax.getSyntax().startsWith("BITS") || mIBSyntax.getSyntax().startsWith("Opaque")) {
                    long l3 = 0L;
                    if (mIBSyntax.hasRanges()) {
                        l3 = mIBSyntax.getMinOfRanges();
                    }
                    return (int)l3;
                }
            }
            return -1;
        }

        @Override
        public String getDefaultValue() {
            MIBObjectType mIBObjectType = (MIBObjectType)this.a;
            return mIBObjectType.getDefaultValue();
        }

        @Override
        public Variable getDefaultVariable() {
            return this.a(true);
        }

        @Override
        public Variable createNewVariable() {
            return this.a(false);
        }

        private Variable a(boolean bl) {
            MIBObjectType mIBObjectType = (MIBObjectType)this.a;
            ValueConverter valueConverter = this.c.a(mIBObjectType);
            mIBObjectType = ValueConverter.getDefaultValue(this.c.c, mIBObjectType, valueConverter.getEffectiveSyntax());
            if (!bl && mIBObjectType == null) {
                mIBObjectType = AbstractVariable.createFromSyntax((int)ValueConverter.getSnmpSyntax(valueConverter.getSMISyntax()));
            }
            return mIBObjectType;
        }

        @Override
        public SmiType getType() {
            return SmiManager.c((MIBObjectType)this.a);
        }

        @Override
        public SmiSyntax getSyntax() {
            if (this.b == null) {
                MIBSyntax mIBSyntax = ((MIBObjectType)this.a).getSyntax();
                this.b = SmiManager.b(this.c, mIBSyntax);
            }
            return this.b;
        }

        @Override
        public List<SmiObjectType> getColumns() {
            Object object = (MIBObjectType)this.a;
            if (((MIBObjectType)object).hasIndexPart()) {
                object = this.c.c.getColumnarObjectsOfTable((MIBObjectType)object, false, true);
                ArrayList<m> arrayList = new ArrayList<m>(object.size());
                object = object.iterator();
                while (object.hasNext()) {
                    MIBObjectType mIBObjectType = (MIBObjectType)object.next();
                    arrayList.add(new m(this.c, mIBObjectType, new OID(mIBObjectType.getPrintableOid())));
                }
                return Collections.unmodifiableList(arrayList);
            }
            return null;
        }

        @Override
        public List<SmiObjectTypeIndex> getIndexObjects() {
            Serializable serializable = (MIBObjectType)this.a;
            if (((MIBObjectType)serializable).hasIndexPart()) {
                IndexStruct[] indexStructArray = ((MIBObjectType)serializable).getIndexPart().getIndexStruct(this.c.c);
                serializable = this.c.c.getColumnarObjectsOfTable((MIBObjectType)serializable, true, false);
                ArrayList<n> arrayList = new ArrayList<n>(serializable.size());
                for (int i2 = 0; i2 < serializable.size() && i2 < indexStructArray.length; ++i2) {
                    MIBObjectType mIBObjectType = (MIBObjectType)serializable.get(i2);
                    IndexStruct indexStruct = indexStructArray[i2];
                    arrayList.add(new n(this.c, this, mIBObjectType, indexStruct, new OID(mIBObjectType.getPrintableOid()), 0));
                }
                return Collections.unmodifiableList(arrayList);
            }
            return null;
        }

        /* synthetic */ m(SmiManager smiManager, MIBObjectType mIBObjectType, OID oID, byte by) {
            this(smiManager, mIBObjectType, oID);
        }
    }

    private final class r
    extends l
    implements SmiTextualConvention,
    SmiValueType {
        private SmiSyntax b;
        private /* synthetic */ SmiManager c;

        private r(SmiManager smiManager, MIBTextualConvention mIBTextualConvention) {
            this.c = smiManager;
            super(smiManager, mIBTextualConvention, null, (byte)0);
        }

        @Override
        public final SmiSyntax getSyntax() {
            MIBSyntax mIBSyntax;
            if (this.b == null && (mIBSyntax = ((MIBTextualConvention)this.a).getSyntax()) != null) {
                this.b = new SmiSyntaxImpl(mIBSyntax.getSyntax(), SmiManager.d(mIBSyntax), this.getSmiSyntax(), SmiManager.c(mIBSyntax));
            }
            return this.b;
        }

        @Override
        public final String getDisplayHint() {
            return MIBObject.getUnquotedString(((MIBTextualConvention)this.a).getDisplayHint());
        }

        @Override
        public final List<SmiObject> getChildren() {
            return null;
        }

        @Override
        public final SmiObject getParent() {
            return null;
        }

        /* synthetic */ r(SmiManager smiManager, MIBTextualConvention mIBTextualConvention, byte by) {
            this(smiManager, mIBTextualConvention);
        }
    }

    private final class f
    extends l
    implements SmiGroup {
        public f(SmiManager smiManager, MIBGroup mIBGroup, OID oID) {
            super(smiManager, mIBGroup, oID, (byte)0);
        }

        @Override
        public final SmiGroupType getGroupType() {
            if (((MIBGroup)this.a).isObjectGroup()) {
                return SmiGroupType.OBJECT_GROUP;
            }
            return SmiGroupType.NOTIFICATION_GROUP;
        }

        @Override
        public final List<String> getObjectNames() {
            return Arrays.asList(((MIBGroup)this.a).getObjects());
        }
    }

    private final class j
    extends l
    implements SmiNotificationType {
        private List<SmiObjectType> b;
        private /* synthetic */ SmiManager c;

        private j(SmiManager smiManager, MIBNotifyType mIBNotifyType, OID oID) {
            this.c = smiManager;
            super(smiManager, mIBNotifyType, oID, (byte)0);
        }

        @Override
        public final synchronized List<SmiObjectType> getObjects() {
            if (this.b == null) {
                Comparable<Integer> comparable = this.a.getModuleID();
                comparable = this.c.c.getModule((Integer)comparable);
                if (comparable != null && ((MIBNotifyType)this.a).getVariables() != null) {
                    this.b = new ArrayList<SmiObjectType>(((MIBNotifyType)this.a).getVariables().length);
                    for (String string : ((MIBNotifyType)this.a).getVariables()) {
                        SmiObject object = this.c.findSmiObject(((MIBModule)comparable).getModuleName(), string);
                        if (!(object instanceof SmiObjectType)) continue;
                        this.b.add((SmiObjectType)object);
                    }
                } else {
                    this.b = new ArrayList<SmiObjectType>(0);
                }
            }
            return this.b;
        }

        @Override
        public final List<String> getObjectNames() {
            if (((MIBNotifyType)this.a).hasVariables()) {
                return Arrays.asList(((MIBNotifyType)this.a).getVariables());
            }
            return Collections.emptyList();
        }

        /* synthetic */ j(SmiManager smiManager, MIBNotifyType mIBNotifyType, OID oID, byte by) {
            this(smiManager, mIBNotifyType, oID);
        }
    }

    private final class h
    extends l
    implements SmiModuleCompliance {
        private List<SmiComplianceModule> b;
        private /* synthetic */ SmiManager c;

        public h(SmiManager smiManager, MIBCompliance mIBCompliance, OID oID) {
            this.c = smiManager;
            super(smiManager, mIBCompliance, oID, (byte)0);
        }

        @Override
        public final synchronized List<SmiComplianceModule> getModules() {
            if (this.b == null) {
                MIBCompliance mIBCompliance = (MIBCompliance)this.a;
                this.b = new ArrayList<SmiComplianceModule>(mIBCompliance.getModules().size());
                for (Object e2 : mIBCompliance.getModules()) {
                    this.b.add(new d(this.c, (MIBComplianceModule)e2));
                }
            }
            return this.b;
        }
    }

    private final class c
    extends l
    implements SmiAgentCapabilities {
        private List<SmiSupportedModule> b;
        private /* synthetic */ SmiManager c;

        public c(SmiManager smiManager, MIBAgentCaps mIBAgentCaps, OID oID) {
            this.c = smiManager;
            super(smiManager, mIBAgentCaps, oID, (byte)0);
        }

        @Override
        public final String getProductRelease() {
            return MIBObject.getUnquotedString(((MIBAgentCaps)this.a).getProductRelease());
        }

        @Override
        public final synchronized List<SmiSupportedModule> getSupportedModules() {
            if (this.b == null) {
                MIBAgentCaps mIBAgentCaps = (MIBAgentCaps)this.a;
                this.b = new ArrayList<SmiSupportedModule>(mIBAgentCaps.getModules().size());
                for (MIBSupportedModule mIBSupportedModule : mIBAgentCaps.getModules()) {
                    this.b.add(new q(this.c, mIBSupportedModule));
                }
            }
            return this.b;
        }
    }

    private class l
    implements SmiObject {
        protected MIBObject a;
        private final OID b;
        private Integer c;
        private /* synthetic */ SmiManager d;

        private l(SmiManager smiManager, MIBObject mIBObject, OID oID) {
            this.d = smiManager;
            this.a = mIBObject;
            this.b = oID;
        }

        @Override
        public String getObjectName() {
            return this.a.getName();
        }

        @Override
        public OID getOID() {
            return this.b;
        }

        @Override
        public int getSmiSyntax() {
            MIBObject mIBObject;
            if (this.c == null && this.a instanceof MIBObjectType && ((MIBObjectType)(mIBObject = (MIBObjectType)this.a)).getSyntax() != null) {
                mIBObject = this.d.c.getEffectiveSyntax(((MIBObjectType)mIBObject).getSyntax());
                this.c = SmiManager.b(SMI.smiSyntax(((MIBTextualConvention)mIBObject).getSyntax().getSyntax()));
            }
            if (this.c == null) {
                return 0;
            }
            return this.c;
        }

        @Override
        public String getDescription() {
            return MIBObject.getUnquotedString(this.a.getDescription());
        }

        @Override
        public SmiType getType() {
            return SmiType.fromJasmiType(this.a.getType());
        }

        public List<SmiObject> getChildren() {
            ArrayList<SmiObject> arrayList = new ArrayList<SmiObject>();
            for (MIBObject mIBObject : this.d.c.getChildren(this.a)) {
                arrayList.add(this.d.a(mIBObject, new OID(mIBObject.getOid().toString())));
            }
            return Collections.unmodifiableList(arrayList);
        }

        @Override
        public SmiObject getParent() {
            Comparable comparable = this.a.getOid();
            comparable = this.d.c.getNextParent((ObjectID)comparable);
            if (comparable != null) {
                return this.d.a((MIBObject)comparable, new OID(((MIBObject)comparable).getPrintableOid()));
            }
            return null;
        }

        @Override
        public String getReference() {
            return this.a.getReference();
        }

        @Override
        public SmiStatus getStatus() {
            return SmiStatus.valueOf(this.a.getStatus());
        }

        @Override
        public String[] getAsn1Comments() {
            return new String[]{this.a.getComment(), this.a.getInlineComment()};
        }

        public String toString() {
            return this.a.toSMI(1, 2, this.d.c, "\n");
        }

        public boolean equals(Object o2) {
            l l2;
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            l2 = l2;
            return !(this.a == null ? l2.a != null : !this.a.equals(l2.a));
        }

        public int hashCode() {
            if (this.a != null) {
                return this.a.hashCode();
            }
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public /* synthetic */ int compareTo(Object object) {
            SmiObject smiObject = (SmiObject)object;
            object = this;
            if (smiObject == null) {
                throw new IllegalArgumentException("Cannot compare to a null object.");
            }
            OID oID = smiObject.getOID();
            if (((l)object).b == null) {
                if (oID != null) return -1;
                return 0;
            }
            int n2 = ((l)object).b.compareTo((Variable)oID);
            if (n2 == 0) {
                if (((l)object).c.intValue() != smiObject.getSmiSyntax()) return ((l)object).c.compareTo(smiObject.getSmiSyntax());
                if (!(smiObject instanceof l)) return ((l)object).getObjectName().compareTo(smiObject.getObjectName());
                return ((l)object).a.compareTo(((l)smiObject).a);
            }
            int n3 = n2;
            return n3;
        }

        /* synthetic */ l(SmiManager smiManager, MIBObject mIBObject, OID oID, byte by) {
            this(smiManager, mIBObject, oID);
        }
    }

    private final class g
    implements SmiImport {
        private MIBImport a;
        private /* synthetic */ SmiManager b;

        private g(SmiManager smiManager, MIBImport mIBImport) {
            this.b = smiManager;
            this.a = mIBImport;
        }

        @Override
        public final String getSourceModuleName() {
            return this.a.getSource();
        }

        @Override
        public final String getAsn1Comment() {
            return this.a.getComment();
        }

        @Override
        public final List<String> getImportedObjectNames() {
            return Collections.unmodifiableList(this.a.getImportsVector());
        }

        public final String toString() {
            return this.a.toSMI(this.b.c, 1, "\n");
        }

        /* synthetic */ g(SmiManager smiManager, MIBImport mIBImport, byte by) {
            this(smiManager, mIBImport);
        }
    }

    private final class p
    implements SmiRevision {
        private IRevision a;

        private p(SmiManager smiManager, IRevision iRevision) {
            this.a = iRevision;
        }

        @Override
        public final String getRevisionString() {
            return MIBObject.getUnquotedString(this.a.getRevision());
        }

        @Override
        public final GregorianCalendar getRevision() {
            return MIBModule.getDateAndTimeFromUTC(this.getRevisionString());
        }

        @Override
        public final String getDescription() {
            return MIBObject.getUnquotedString(this.a.getDescription());
        }

        public final String toString() {
            return this.a.getRevision();
        }

        /* synthetic */ p(SmiManager smiManager, IRevision iRevision, byte by) {
            this(smiManager, iRevision);
        }
    }

    private final class k
    implements SmiObjectCompliance {
        private IVariation a;
        private /* synthetic */ SmiManager b;

        protected k(SmiManager smiManager, IVariation iVariation) {
            this.b = smiManager;
            this.a = iVariation;
        }

        @Override
        public final String getName() {
            return this.a.getVariation();
        }

        @Override
        public final SmiComplianceType getComplianceType() {
            if (this.a instanceof MIBCondGroup) {
                return SmiComplianceType.GroupCompliance;
            }
            return SmiComplianceType.ObjectCompliance;
        }

        @Override
        public final SmiSyntax getSyntax() {
            return SmiManager.b(this.b, this.a.getSyntaxDef());
        }

        @Override
        public final SmiSyntax getWriteSyntax() {
            return SmiManager.b(this.b, this.a.getWriteSyntaxDef());
        }

        @Override
        public final SmiAccess getAccess() {
            return SmiAccess.fromSmiValue(this.a.getAccess());
        }

        @Override
        public final String getDescription() {
            return MIBObject.getUnquotedString(this.a.getDescription());
        }
    }

    private final class o
    implements SmiObjectVariation {
        private IVariation a;
        private /* synthetic */ SmiManager b;

        public o(SmiManager smiManager, IVariation iVariation) {
            this.b = smiManager;
            this.a = iVariation;
        }

        @Override
        public final String getDefaultValue() {
            return this.a.getDefval();
        }

        @Override
        public final List<String> getCreationRequirements() {
            return Arrays.asList(this.a.getCreationRequires());
        }

        @Override
        public final SmiSyntax getSyntax() {
            return SmiManager.b(this.b, this.a.getSyntaxDef());
        }

        @Override
        public final SmiSyntax getWriteSyntax() {
            return SmiManager.b(this.b, this.a.getWriteSyntaxDef());
        }

        @Override
        public final SmiAccess getAccess() {
            return SmiAccess.fromSmiValue(this.a.getAccess());
        }

        @Override
        public final String getDescription() {
            return MIBObject.getUnquotedString(this.a.getDescription());
        }

        @Override
        public final String getName() {
            return this.a.getVariation();
        }

        @Override
        public final SmiComplianceType getComplianceType() {
            return SmiComplianceType.Variation;
        }
    }

    private final class q
    implements SmiSupportedModule {
        private MIBSupportedModule a;
        private List<SmiObjectVariation> b;
        private /* synthetic */ SmiManager c;

        public q(SmiManager smiManager, MIBSupportedModule mIBSupportedModule) {
            this.c = smiManager;
            this.a = mIBSupportedModule;
        }

        @Override
        public final String getModuleName() {
            return MIBObject.getUnquotedString(this.a.getSupports());
        }

        @Override
        public final List<String> getIncludedGroupNames() {
            return Arrays.asList(this.a.getIncludedGroups());
        }

        @Override
        public final synchronized List<SmiObjectVariation> getVariations() {
            if (this.b == null) {
                this.b = new ArrayList<SmiObjectVariation>(this.a.getVariationsVector().size());
                for (IVariation iVariation : this.a.getVariations()) {
                    this.b.add(new o(this.c, iVariation));
                }
            }
            return this.b;
        }
    }

    private final class d
    implements SmiComplianceModule {
        private MIBComplianceModule a;
        private List<SmiGroup> b;
        private List<SmiObjectCompliance> c;
        private /* synthetic */ SmiManager d;

        public d(SmiManager smiManager, MIBComplianceModule mIBComplianceModule) {
            this.d = smiManager;
            this.a = mIBComplianceModule;
        }

        @Override
        public final List<String> getMandatoryGroupNames() {
            return Collections.unmodifiableList(this.a.getMandatoryVector());
        }

        @Override
        public final synchronized List<SmiGroup> getMandatoryGroups() {
            if (this.b == null && this.a.getMandatoryVector() != null) {
                this.b = new ArrayList<SmiGroup>(this.a.getMandatoryVector().size());
                for (String string : this.a.getMandatory()) {
                    SmiObject object = this.d.findSmiObject(this.a.getModuleName(), string);
                    if (!(object instanceof SmiGroup)) continue;
                    this.b.add((SmiGroup)((Object)object));
                }
            }
            return this.b;
        }

        @Override
        public final synchronized List<SmiObjectCompliance> getObjectCompliances() {
            if (this.c == null && this.a.getVariationsVector() != null) {
                this.c = new ArrayList<SmiObjectCompliance>(this.a.getVariationsVector().size());
                for (IVariation iVariation : this.a.getVariations()) {
                    this.c.add(new k(this.d, iVariation));
                }
            }
            return this.c;
        }
    }

    private final class n
    extends m
    implements SmiObjectTypeIndex {
        private SmiObjectType b;
        private SmiIndexInfo c;

        private n(SmiManager smiManager, SmiObjectType smiObjectType, MIBObjectType mIBObjectType, IndexStruct indexStruct, OID oID) {
            super(smiManager, mIBObjectType, oID, (byte)0);
            this.b = smiObjectType;
            this.c = new a(this, indexStruct, 0);
        }

        @Override
        public final SmiIndexInfo getIndexInfo() {
            return this.c;
        }

        /* synthetic */ n(SmiManager smiManager, SmiObjectType smiObjectType, MIBObjectType mIBObjectType, IndexStruct indexStruct, OID oID, byte by) {
            this(smiManager, smiObjectType, mIBObjectType, indexStruct, oID);
        }

        private final class a
        implements SmiIndexInfo {
            private IndexStruct a;
            private /* synthetic */ n b;

            private a(n n2, IndexStruct indexStruct) {
                this.b = n2;
                this.a = indexStruct;
            }

            public final boolean hasImpliedLength() {
                return this.a.impliedLength;
            }

            public final int getMinLength() {
                return this.a.minLength;
            }

            public final int getMaxLength() {
                return this.a.maxLength;
            }

            public final int getSnmpSyntax() {
                return ValueConverter.getSnmpSyntax(this.a.baseType);
            }

            @Override
            public final SmiObjectType getTableEntry() {
                return this.b.b;
            }

            /* synthetic */ a(n n2, IndexStruct indexStruct, byte by) {
                this(n2, indexStruct);
            }
        }
    }
}

