/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmpvalue;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmpvalue.IndexConverter;
import com.agentpp.snmpvalue.types.ComparableIpAddress;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class ValueConverter
implements Serializable,
Comparator {
    public static final long serialVersionUID = -9073989472934609617L;
    protected MIBObjectType ot;
    protected MIBSyntax effectiveSyntax;
    protected String displayHint;
    protected String overrideDisplayHint;
    protected int smiSyntax;

    /*
     * WARNING - void declaration
     */
    public ValueConverter(ValueConverter other) {
        void var1_1;
        this.smiSyntax = -1;
        this.ot = other.ot;
        this.effectiveSyntax = other.effectiveSyntax;
        this.displayHint = other.displayHint;
        this.smiSyntax = other.smiSyntax;
        this.overrideDisplayHint = var1_1.overrideDisplayHint;
    }

    /*
     * WARNING - void declaration
     */
    public ValueConverter(MIBObjectType objectType, MIBSyntax effectiveSyntax, String displayHint) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.smiSyntax = -1;
        this.ot = var1_1;
        this.effectiveSyntax = effectiveSyntax;
        if (displayHint != null) {
            displayHint = MIBObject.getUnquotedString(displayHint);
        }
        this.displayHint = var3_3;
        this.smiSyntax = SMI.smiSyntax(var2_2.getSyntax());
        if (this.smiSyntax < 0) {
            this.smiSyntax = 11;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ValueConverter(Class snmpClass) {
        void var1_1;
        int n2 = var1_1.equals(Integer32.class) ? 0 : (var1_1.equals(Counter32.class) ? 3 : (var1_1.equals(Counter64.class) ? 6 : (var1_1.equals(OctetString.class) ? 1 : (var1_1.equals(OID.class) ? 2 : (var1_1.equals(IpAddress.class) ? 9 : (var1_1.equals(Gauge32.class) ? 4 : (var1_1.equals(TimeTicks.class) ? 11 : 14)))))));
        this(n2);
    }

    /*
     * WARNING - void declaration
     */
    public ValueConverter(int smiSyntax) {
        void var1_1;
        this.smiSyntax = -1;
        this.smiSyntax = smiSyntax;
        this.displayHint = null;
        this.effectiveSyntax = new MIBSyntax(SMI.SMI_SYNTAX[var1_1], 0);
        this.ot = null;
    }

    public static int getSmiSyntax(int snmpSyntax) {
        int n2;
        switch (snmpSyntax) {
            case 2: {
                n2 = 0;
                break;
            }
            case 65: {
                n2 = 3;
                break;
            }
            case 70: {
                n2 = 6;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 64: {
                n2 = 9;
                break;
            }
            case 66: {
                n2 = 7;
                break;
            }
            case 67: {
                n2 = 11;
                break;
            }
            default: {
                n2 = 14;
            }
        }
        return n2;
    }

    public static int getSnmpSyntax(int smiSyntax) {
        int n2;
        switch (smiSyntax) {
            case 0: 
            case 8: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: {
                n2 = 65;
                break;
            }
            case 6: {
                n2 = 70;
                break;
            }
            case 10: {
                n2 = 68;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 2: {
                n2 = 6;
                break;
            }
            case 9: 
            case 15: {
                n2 = 64;
                break;
            }
            case 4: 
            case 7: 
            case 13: {
                n2 = 66;
                break;
            }
            case 11: {
                n2 = 67;
                break;
            }
            case 12: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 5;
            }
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public void setObjectType(MIBObjectType ot) {
        void var1_1;
        this.ot = var1_1;
    }

    public MIBObjectType getObjectType() {
        return this.ot;
    }

    public String getDisplayHint() {
        if (this.overrideDisplayHint != null) {
            return this.overrideDisplayHint;
        }
        return this.displayHint;
    }

    public String getNativeDisplayHint() {
        return this.displayHint;
    }

    public String getOverrideDisplayHint() {
        return this.overrideDisplayHint;
    }

    /*
     * WARNING - void declaration
     */
    public void setOverrideDisplayHint(String displayHint) {
        void var1_1;
        this.overrideDisplayHint = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setDisplayHint(String displayHint) {
        void var1_1;
        this.displayHint = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setEffectiveSyntax(MIBSyntax effectiveSyntax) {
        void var1_1;
        this.effectiveSyntax = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Object toNative(Variable variable) {
        void var1_1;
        return this.toNative((Variable)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public Object toNative(Variable variable, boolean withLabels) {
        if (this.getDisplayHint() != null) {
            if (variable instanceof OctetString) {
                return ValueConverter.formatString((OctetString)variable, this.getDisplayHint());
            }
            if (variable instanceof Integer32) {
                return ValueConverter.formatLong(new Long(((Integer32)variable).getValue()), this.getDisplayHint());
            }
            if (variable instanceof UnsignedInteger32) {
                return ValueConverter.formatLong(new Long(((UnsignedInteger32)variable).getValue()), this.getDisplayHint());
            }
            if (variable instanceof Counter64) {
                return ValueConverter.formatLong(new Long(((Counter64)variable).getValue()), this.getDisplayHint());
            }
        } else {
            if (variable instanceof Integer32) {
                MIBEnum mIBEnum;
                void var2_2;
                if (var2_2 != false && this.getEffectiveSyntax().hasEnums() && (mIBEnum = this.getEffectiveSyntax().getEnum(((Integer32)variable).getValue())) != null) {
                    return mIBEnum.toString();
                }
                return new Integer(((Integer32)variable).getValue());
            }
            if (variable instanceof UnsignedInteger32) {
                return new Long(((UnsignedInteger32)variable).getValue());
            }
            if (variable instanceof OctetString) {
                if (this.smiSyntax == 12) {
                    return ValueConverter.toBinaryString((OctetString)variable);
                }
                return new String(((OctetString)variable).toHexString());
            }
            if (variable instanceof Counter64) {
                return new BigDecimal(new BigInteger(variable.toString()));
            }
            if (variable instanceof IpAddress) {
                return new ComparableIpAddress(variable.toString());
            }
            if (variable instanceof OID) {
                void var1_1;
                return new ObjectID(var1_1.toString());
            }
        }
        return null;
    }

    public static String toBinaryString(OctetString os) {
        Object object = os.getValue();
        StringBuffer stringBuffer = new StringBuffer(((OctetString)object).length * 9);
        for (int i2 = 0; i2 < ((OctetString)object).length; ++i2) {
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((object[i2] & 1 << 7 - i3) > 0) {
                    stringBuffer.append('1');
                    continue;
                }
                stringBuffer.append('0');
            }
            if (i2 + 1 >= ((OctetString)object).length) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public static String getPrintableString(OctetString os) {
        Object object;
        if (os == null) {
            return "";
        }
        object = object.getValue();
        StringBuffer stringBuffer = new StringBuffer(((OctetString)object).length + 1);
        for (int i2 = 0; i2 < ((OctetString)object).length; ++i2) {
            if (object[i2] >= 32 && object[i2] < 127) {
                stringBuffer.append((char)object[i2]);
                continue;
            }
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    public static OctetString fromBinaryString(String binString) {
        try {
            StringTokenizer stringTokenizer;
            stringTokenizer = new StringTokenizer((String)((Object)stringTokenizer), " ");
            OctetString octetString = new OctetString();
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                for (int i2 = 0; i2 < string.length(); i2 += 8) {
                    String string2;
                    if (i2 + 8 < string.length()) {
                        int n2 = i2;
                        string2 = string.substring(n2, n2 + 8);
                    } else {
                        string2 = string.substring(i2);
                    }
                    if (string2.length() < 8) {
                        StringBuffer stringBuffer = new StringBuffer(8);
                        stringBuffer.append(string2);
                        while (stringBuffer.length() < 8) {
                            stringBuffer.append('0');
                        }
                        string2 = stringBuffer.toString();
                    }
                    octetString.append((byte)Integer.parseInt(string2, 2));
                }
            }
            return octetString;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Variable fromString(String object) {
        switch (this.smiSyntax) {
            case 0: 
            case 8: {
                if (this.effectiveSyntax.hasEnums() && object != null && !object.isEmpty() && !Character.isDigit(object.charAt(0))) {
                    try {
                        ValueConverter valueConverter = this;
                        return valueConverter.fromNative(valueConverter.effectiveSyntax.getEnumValue(object));
                    }
                    catch (Exception exception) {}
                }
                try {
                    return this.fromNative(Integer.valueOf(object));
                }
                catch (Exception exception) {
                    return null;
                }
            }
            case 1: 
            case 10: 
            case 12: {
                return this.fromNative(object);
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 13: {
                try {
                    return this.fromNative(Long.valueOf(object));
                }
                catch (Exception exception) {
                    return null;
                }
            }
            case 6: {
                try {
                    return this.fromNative(new BigDecimal(object));
                }
                catch (Exception exception) {
                    return null;
                }
            }
            case 2: 
            case 9: {
                void var1_1;
                return this.fromNative(var1_1);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Variable fromNative(Object object) {
        try {
            if (object instanceof Integer) {
                return new Integer32(((Integer)object).intValue());
            }
            if (object instanceof Long) {
                switch (this.smiSyntax) {
                    case 0: 
                    case 8: {
                        return new Integer32(((Long)object).intValue());
                    }
                    case 3: 
                    case 5: {
                        return new Counter32(((Long)object).longValue());
                    }
                    case 11: {
                        return new TimeTicks(((Long)object).longValue());
                    }
                }
                return new Gauge32(((Long)object).longValue());
            }
            if (object instanceof BigDecimal) {
                return new Counter64(((BigDecimal)object).longValue());
            }
            if (object instanceof String) {
                Object object2 = (String)object;
                if (this.effectiveSyntax.hasEnums()) {
                    if (this.effectiveSyntax.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                        if (((String)object2).indexOf(123) < 0) return new OctetString(ValueConverter.fromBinaryString((String)object2));
                        byte[] byArray = this.effectiveSyntax.getBitsEnum((String)object2);
                        object2 = byArray;
                        if (byArray == null) return null;
                        return new OctetString((byte[])object2);
                    }
                    if (((String)object2).isEmpty()) return null;
                    if (Character.getType(((String)object2).charAt(0)) == 9) {
                        return new Integer32(Integer.parseInt((String)object2));
                    }
                    int n2 = this.effectiveSyntax.getEnumValue((String)object2);
                    if (n2 == Integer.MIN_VALUE) return null;
                    return new Integer32(n2);
                }
                if (this.getDisplayHint() != null) {
                    switch (this.smiSyntax) {
                        case 1: 
                        case 10: 
                        case 12: {
                            return ValueConverter.scanString(this.getDisplayHint(), (String)object2);
                        }
                        case 3: 
                        case 5: {
                            object2 = ValueConverter.scanLong(this.getDisplayHint(), (String)object2);
                            if (object2 != null) return new Counter32(((Long)object2).longValue());
                            return null;
                        }
                        case 4: 
                        case 7: 
                        case 13: {
                            object2 = ValueConverter.scanLong(this.getDisplayHint(), (String)object2);
                            if (object2 != null) return new Gauge32(((Long)object2).longValue());
                            return null;
                        }
                        case 0: 
                        case 8: {
                            object2 = ValueConverter.scanLong(this.getDisplayHint(), (String)object2);
                            if (object2 != null) return new Integer32(((Long)object2).intValue());
                            return null;
                        }
                        case 6: {
                            object2 = ValueConverter.scanLong(this.getDisplayHint(), (String)object2);
                            if (object2 != null) return new Counter64(((Long)object2).longValue());
                            return null;
                        }
                    }
                    return null;
                }
                switch (this.smiSyntax) {
                    case 10: {
                        object2 = new Opaque();
                        OctetString octetString = ValueConverter.fromHexString((String)object);
                        if (octetString == null) {
                            return null;
                        }
                        object2.setValue(octetString.getValue());
                        return object2;
                    }
                    case 12: {
                        return ValueConverter.fromBinaryString((String)object);
                    }
                    case 1: {
                        return ValueConverter.fromHexString((String)object);
                    }
                    case 9: {
                        object2 = new ObjectID((String)object);
                        try {
                            if (!((ObjectID)object2).isValid()) return null;
                            if (((ObjectID)object2).size() != 4) return null;
                            if (((ObjectID)object2).getSubIDAsLong(0) > 255L) return null;
                            if (((ObjectID)object2).getSubIDAsLong(1) > 255L) return null;
                            if (((ObjectID)object2).getSubIDAsLong(2) > 255L) return null;
                            if (((ObjectID)object2).getSubIDAsLong(3) <= 255L) return new IpAddress(((ObjectID)object2).asByteArray());
                            return null;
                        }
                        catch (ObjectIDFormatException objectIDFormatException) {
                            return null;
                        }
                    }
                    case 2: {
                        return new OID((String)object);
                    }
                    case 0: 
                    case 8: {
                        return new Integer32(Integer.parseInt(object.toString()));
                    }
                    case 3: 
                    case 5: {
                        return new Counter32(Long.parseLong(object.toString()));
                    }
                    case 11: {
                        TimeTicks timeTicks = new TimeTicks();
                        timeTicks.setValue(object.toString());
                        return timeTicks;
                    }
                    case 4: 
                    case 7: {
                        return new Gauge32(Long.parseLong(object.toString()));
                    }
                }
                return null;
            }
            if (object instanceof ComparableIpAddress) {
                return new IpAddress(object.toString());
            }
            if (!(object instanceof ObjectID)) return null;
            if (this.smiSyntax != 9) void var1_1;
            return new OID(((ObjectID)var1_1).toString());
            return new IpAddress(object.toString());
        }
        catch (Exception exception) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String formatLong(Long value, String displayHint) {
        String string = null;
        if (displayHint == null || displayHint.length() <= 0) {
            return null;
        }
        int n2 = displayHint.charAt(0);
        switch (n2) {
            case 100: {
                n2 = -1;
                if (displayHint.length() > 2 && displayHint.charAt(1) == '-') {
                    void var1_2;
                    n2 = Integer.parseInt(var1_2.substring(2));
                }
                string = value.toString();
                if (n2 <= 0) break;
                int n3 = string.length() - n2;
                if (n3 <= 0) {
                    string = "." + string;
                    break;
                }
                string = string.substring(0, n3) + "." + string.substring(n3);
                break;
            }
            case 98: {
                Long l2;
                string = Long.toBinaryString(l2);
                break;
            }
            case 111: {
                Long l2;
                string = Long.toOctalString(l2);
                break;
            }
            case 120: {
                Long l2;
                string = Long.toHexString(l2);
            }
        }
        return string;
    }

    public static String formatString(OctetString value, String displayHint) {
        if (displayHint == null) {
            return value.toString();
        }
        OctetString octetString = new OctetString();
        int n2 = 0;
        int n3 = 0;
        block6: while (n3 < value.length() && n2 < displayHint.length()) {
            int n4;
            int n5 = 1;
            Character c2 = null;
            Character c3 = null;
            if (displayHint.charAt(n2) == '*') {
                ++n2;
                n5 = 0xFF & value.get(n3++);
            }
            for (n4 = n2; n4 < displayHint.length() && Character.isDigit(displayHint.charAt(n4)); ++n4) {
            }
            if (n4 == n2) {
                return value.toString();
            }
            if (n4 >= displayHint.length()) {
                return value.toString();
            }
            String string = displayHint.substring(n2, n4);
            int n6 = Math.min(Integer.parseInt(string), 65535);
            n2 = n4;
            n4 = displayHint.charAt(n2++);
            if (n2 < displayHint.length() && !Character.isDigit(displayHint.charAt(n2)) && displayHint.charAt(n2) != '*') {
                c2 = new Character(displayHint.charAt(n2));
                if (++n2 < displayHint.length() && !Character.isDigit(displayHint.charAt(n2)) && displayHint.charAt(n2) != '*') {
                    c3 = new Character(displayHint.charAt(n2));
                    ++n2;
                }
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                if (n3 + n6 >= value.length()) {
                    n6 = value.length() - n3;
                }
                if (n6 <= 0 || n3 >= value.length()) continue block6;
                byte[] byArray = new byte[n6];
                for (int i3 = 0; i3 < n6; ++i3) {
                    byArray[i3] = value.get(n3 + i3);
                }
                n3 += n6;
                if (n4 == 97 || n4 == 116) {
                    octetString.append(byArray);
                } else {
                    long l2 = 0L;
                    int n7 = byArray.length;
                    for (int i4 = 0; i4 < n7; ++i4) {
                        l2 = (l2 << 8) + (long)(byArray[i4] & 0xFF);
                    }
                    switch (n4) {
                        case 100: {
                            octetString.append(Long.toString(l2));
                            break;
                        }
                        case 98: {
                            octetString.append(Long.toBinaryString(l2));
                            break;
                        }
                        case 111: {
                            octetString.append(Long.toOctalString(l2));
                            break;
                        }
                        case 120: {
                            String string2 = Long.toHexString(l2);
                            if (string2.length() == 1) {
                                string2 = "0" + string2;
                            }
                            octetString.append(string2);
                        }
                    }
                }
                if (c2 != null && n3 < value.length()) {
                    octetString.append((byte)c2.charValue());
                }
                if (i2 + 1 < n5) {
                    octetString.append((byte)c3.charValue());
                }
                if (n2 < displayHint.length()) continue;
                n2 = 0;
            }
        }
        return new String(octetString.getValue());
    }

    public static OctetString scanString(String format, String value) {
        if (format == null) {
            return new OctetString(value);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (value == null || format == null) {
            return null;
        }
        OctetString octetString = new OctetString();
        while (n3 < format.length() && n2 < value.length()) {
            int n5;
            int n6 = n3;
            boolean bl = false;
            int n7 = 0;
            while (n3 < format.length() && Character.isDigit(format.charAt(n3))) {
                n7 = n7 * 10 + format.charAt(n3) - 48;
                bl = true;
                ++n3;
            }
            if (!bl) {
                n7 = 1;
            }
            bl = false;
            switch (format.charAt(n3)) {
                case 'a': 
                case 't': {
                    if (n7 < value.length() - n2) {
                        int n8 = n2;
                        octetString.append(value.substring(n8, n8 + n7).getBytes());
                        n2 += n7;
                        break;
                    }
                    octetString.append(value.substring(n2).getBytes());
                    n2 = value.length();
                    break;
                }
                case 'b': {
                    n5 = n2;
                    while (n2 < value.length() && (value.charAt(n2) == '0' || value.charAt(n2) == '1')) {
                        ++n2;
                    }
                    try {
                        n4 = Integer.parseInt(value.substring(n5, n2), 2);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                case 'd': {
                    n5 = n2;
                    while (n2 < value.length() && Character.isDigit(value.charAt(n2))) {
                        ++n2;
                    }
                    try {
                        n4 = Integer.parseInt(value.substring(n5, n2), 10);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                case 'o': {
                    n5 = n2;
                    while (n2 < value.length() && value.charAt(n2) >= '0' && value.charAt(n2) <= '7') {
                        ++n2;
                    }
                    try {
                        n4 = Integer.parseInt(value.substring(n5, n2), 8);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                case 'x': {
                    n5 = n2;
                    while (n2 < value.length() && (value.charAt(n2) >= '0' && value.charAt(n2) <= '9' || value.charAt(n2) >= 'A' && value.charAt(n2) <= 'F' || value.charAt(n2) >= 'a' && value.charAt(n2) <= 'f')) {
                        ++n2;
                    }
                    try {
                        n4 = Integer.parseInt(value.substring(n5, n2), 16);
                        bl = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
            ++n3;
            if (bl) {
                while (n7 > 0) {
                    n5 = (byte)(n4 >> (n7 - 1 << 3));
                    octetString.append((byte)n5);
                    --n7;
                }
            }
            if (n3 < format.length() && format.charAt(n3) != '*') {
                if (!Character.isDigit(format.charAt(n3))) {
                    ++n3;
                }
                if (n2 < value.length() && !Character.isDigit(value.charAt(n2))) {
                    ++n2;
                }
            }
            if (n3 < format.length() || n2 >= value.length()) continue;
            if (bl) {
                n3 = n6;
                continue;
            }
            return null;
        }
        return octetString;
    }

    /*
     * WARNING - void declaration
     */
    public static Long scanLong(String format, String value) throws NumberFormatException {
        if (format == null) {
            return new Long(value);
        }
        Long l2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        if (format == null || format.length() <= 0 || value == null || value.length() <= 0) {
            return null;
        }
        switch (format.charAt(0)) {
            case 'd': {
                if (format.length() == 1) {
                    l2 = new Long(value);
                    break;
                }
                if (format.length() < 2) {
                    return null;
                }
                if (format.charAt(1) != '-') break;
                if (Character.isDigit(format.charAt(2))) {
                    n3 = 0;
                    n4 = 0;
                    while (n4 + 2 < format.length() && Character.isDigit(format.charAt(n4 + 2))) {
                        n3 = n3 * 10 + (format.charAt(n4 + 2) - 48);
                        ++n4;
                    }
                }
                if (n4 + 2 < format.length()) break;
                if (value.charAt(0) == '-') {
                    bl = true;
                    ++n2;
                }
                int n5 = -1;
                long l3 = 0L;
                while (n2 < value.length() && (Character.isDigit(value.charAt(n2)) || value.charAt(n2) == '.')) {
                    if (value.charAt(n2) == '.') {
                        if (n5 >= 0) break;
                        n5 = 0;
                    } else {
                        l3 = l3 * 10L + (long)(value.charAt(n2) - 48);
                        if (n5 >= 0) {
                            ++n5;
                        }
                    }
                    ++n2;
                }
                if (n2 < value.length()) break;
                while (n5 < n3) {
                    l3 *= 10L;
                    ++n5;
                }
                while (n5 > n3) {
                    l3 /= 10L;
                    --n5;
                }
                l2 = new Long(bl ? -1L * l3 : l3);
                break;
            }
            case 'x': {
                String string;
                if (string.length() > 1) break;
                l2 = new Long(Long.parseLong(value, 16));
                break;
            }
            case 'o': {
                String string;
                if (string.length() > 1) break;
                l2 = new Long(Long.parseLong(value, 8));
                break;
            }
            case 'b': {
                void var1_2;
                String string;
                if (string.length() > 1) break;
                l2 = new Long(Long.parseLong((String)var1_2, 2));
            }
        }
        return l2;
    }

    public static OctetString fromHexString(String hexString) {
        try {
            int n2;
            boolean bl = hexString.length() % 2 == 1;
            for (int i2 = 0; i2 < hexString.length(); ++i2) {
                n2 = hexString.charAt(i2);
                switch (n2) {
                    case 32: 
                    case 34: 
                    case 58: {
                        bl = true;
                    }
                }
            }
            OctetString octetString = new OctetString();
            if (!bl) {
                for (n2 = 0; n2 < hexString.length(); n2 += 2) {
                    int n3 = n2;
                    String string = hexString.substring(n3, n3 + 2);
                    int n4 = Integer.valueOf(string, 16);
                    if (n4 < 0 || n4 > 255) {
                        return null;
                    }
                    n4 = (byte)n4;
                    octetString.append((byte)n4);
                }
            } else {
                String string;
                n2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string, " :\"", true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("\"")) {
                        if ((n2 = n2 == 0 ? 1 : 0) == 0 || !stringTokenizer.hasMoreTokens()) continue;
                        octetString.append(stringTokenizer.nextToken());
                        continue;
                    }
                    if (string2.equals(" ") || string2.equals(":")) continue;
                    int n5 = Integer.valueOf(string2, 16);
                    if (n5 < 0 || n5 > 255) {
                        return null;
                    }
                    byte by = (byte)n5;
                    octetString.append(by);
                }
            }
            return octetString;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public MIBSyntax getEffectiveSyntax() {
        return this.effectiveSyntax;
    }

    /*
     * WARNING - void declaration
     */
    public int compare(Object a2, Object b2) {
        try {
            if (a2 instanceof Comparable) {
                void var2_2;
                void var1_1;
                return ((Comparable)var1_1).compareTo(var2_2);
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public static long parseLongConstant(String value) throws NumberFormatException {
        Object object;
        if (value.endsWith("h") || value.endsWith("H")) {
            object = new StringTokenizer(value, "'");
            if (!((StringTokenizer)object).hasMoreTokens()) {
                throw new NumberFormatException("Hex string must be enclosed in '.");
            }
            return Long.parseLong(((StringTokenizer)object).nextToken(), 16);
        }
        if (((String)object).endsWith("o") || ((String)object).endsWith("O")) {
            if (!((StringTokenizer)(object = new StringTokenizer((String)object, "'"))).hasMoreTokens()) {
                throw new NumberFormatException("Octal string must be enclosed in '.");
            }
            return Long.parseLong(((StringTokenizer)object).nextToken(), 8);
        }
        if (((String)object).endsWith("b") || ((String)object).endsWith("B")) {
            if (!((StringTokenizer)(object = new StringTokenizer((String)object, "'"))).hasMoreTokens()) {
                throw new NumberFormatException("Binary string must be enclosed in '.");
            }
            return Long.parseLong(((StringTokenizer)object).nextToken(), 2);
        }
        return Long.parseLong((String)object, 10);
    }

    public static OctetString parseStringConstant(String value) throws NumberFormatException {
        Object object;
        int n2 = 10;
        int n3 = 3;
        if (value.startsWith("\"")) {
            object = new StringTokenizer(value, "\"");
            if (!((StringTokenizer)object).hasMoreTokens()) {
                return new OctetString();
            }
            return new OctetString(((StringTokenizer)object).nextToken());
        }
        if (((String)object).startsWith("'")) {
            if (((String)object).endsWith("h") || ((String)object).endsWith("H")) {
                n2 = 16;
                n3 = 2;
            }
            if (((String)object).endsWith("o") || ((String)object).endsWith("O")) {
                n2 = 8;
                n3 = 4;
            }
            if (((String)object).endsWith("b") || ((String)object).endsWith("B")) {
                n2 = 2;
                n3 = 8;
            }
            if (!((StringTokenizer)(object = new StringTokenizer((String)object, "'"))).hasMoreTokens()) {
                throw new NumberFormatException("String must be enclosed in '.");
            }
            if (((String)(object = ((StringTokenizer)object).nextToken())).length() == 0) {
                return new OctetString();
            }
            try {
                OctetString octetString = new OctetString();
                for (int i2 = 0; i2 < ((String)object).length(); i2 += n3) {
                    int n4 = i2;
                    byte by = (byte)Integer.parseInt(((String)object).substring(n4, n4 + n3), n2);
                    octetString.append(by);
                }
                return octetString;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return new OctetString();
            }
        }
        return new OctetString((String)object);
    }

    public static Variable getDefaultValue(MIBRepository rep, MIBObjectType ot, MIBSyntax syn) {
        try {
            Object object;
            String string;
            if (!ot.hasDefaultValue()) {
                return null;
            }
            string = ((MIBObjectType)((Object)string)).getDefaultValue();
            if (syn.hasEnums()) {
                if (!syn.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    object = syn.getEnum(string);
                    if (object == null) {
                        return null;
                    }
                    return new Integer32((int)ValueConverter.parseLongConstant((String)object));
                }
                byte[] byArray = ((MIBSyntax)object).getBitsEnum(string);
                object = byArray;
                if (byArray == null) {
                    return null;
                }
                return new OctetString((byte[])object);
            }
            if (((MIBSyntax)object).getSyntax().equals("INTEGER") || ((MIBSyntax)object).getSyntax().equals("Integer32")) {
                return new Integer32((int)ValueConverter.parseLongConstant(string));
            }
            if (((MIBSyntax)object).getSyntax().equals("Counter") || ((MIBSyntax)object).getSyntax().equals("Counter32")) {
                return new Counter32(ValueConverter.parseLongConstant(string));
            }
            if (((MIBSyntax)object).getSyntax().equals("UInteger32") || ((MIBSyntax)object).getSyntax().equals("Unsigned32") || ((MIBSyntax)object).getSyntax().equals("Gauge") || ((MIBSyntax)object).getSyntax().equals("Gauge32")) {
                return new Gauge32(ValueConverter.parseLongConstant(string));
            }
            if (((MIBSyntax)object).getSyntax().equals("Counter64")) {
                return new Counter64(ValueConverter.parseLongConstant(string));
            }
            if (((MIBSyntax)object).getSyntax().equals("TimeTicks")) {
                return new TimeTicks(ValueConverter.parseLongConstant(string));
            }
            if (((MIBSyntax)object).getSyntax().equals("IpAddress") || ((MIBSyntax)object).getSyntax().equals("NetworkAddress")) {
                object = new IpAddress();
                try {
                    object.setAddress(ValueConverter.parseStringConstant(string).getValue());
                }
                catch (Exception exception) {}
                return object;
            }
            if (((MIBSyntax)object).getSyntax().equals("Opaque")) {
                object = new Opaque();
                object.setValue(ValueConverter.parseStringConstant(string));
                return object;
            }
            if (((MIBSyntax)object).getSyntax().startsWith("OCTET STRING")) {
                return ValueConverter.parseStringConstant(string);
            }
            if (((MIBSyntax)object).getSyntax().equals("OBJECT-IDENTITY") || ((MIBSyntax)object).getSyntax().equals("OBJECT IDENTIFIER")) {
                Serializable serializable;
                if (string.indexOf(123) >= 0) {
                    object = new StringTokenizer("{ }");
                    serializable = new StringBuffer();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        ((StringBuffer)serializable).append(((StringTokenizer)object).nextToken());
                        if (!((StringTokenizer)object).hasMoreTokens()) continue;
                        ((StringBuffer)serializable).append('.');
                    }
                    return new OID(((StringBuffer)serializable).toString());
                }
                object = new ObjectID(string);
                if (((ObjectID)object).isValid()) {
                    return new OID(((ObjectID)object).toString());
                }
                object = ((MIBRepository)serializable).getObjectID(string);
                if (object != null) {
                    return new OID(((ObjectID)object).toString());
                }
                return new OID();
            }
            return new OctetString(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public int getSMISyntax() {
        return this.smiSyntax;
    }

    public Object getNativeExample() {
        switch (this.smiSyntax) {
            case 0: 
            case 8: {
                return 0;
            }
            case 1: 
            case 10: 
            case 12: {
                return new String();
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 13: {
                return 0L;
            }
            case 6: {
                return new BigDecimal(0);
            }
            case 9: {
                return new ComparableIpAddress("0.0.0.0");
            }
            case 2: {
                return new ObjectID("0.0");
            }
        }
        return new String();
    }

    public boolean isNumber() {
        switch (this.smiSyntax) {
            case 0: 
            case 8: {
                return true;
            }
            case 1: 
            case 10: 
            case 12: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                return true;
            }
            case 2: 
            case 9: {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSyntaxCompatible(int snmpSyntax) {
        switch (this.smiSyntax) {
            case 0: 
            case 8: {
                return snmpSyntax == 2;
            }
            case 1: 
            case 12: {
                return snmpSyntax == 4;
            }
            case 10: {
                return snmpSyntax == 68;
            }
            case 3: 
            case 5: {
                return snmpSyntax == 65;
            }
            case 11: {
                return snmpSyntax == 67;
            }
            case 4: 
            case 7: 
            case 13: {
                return snmpSyntax == 66;
            }
            case 6: {
                return snmpSyntax == 70;
            }
            case 9: {
                return snmpSyntax == 64;
            }
            case 2: {
                return snmpSyntax == 6;
            }
            case 14: {
                void var1_1;
                return var1_1 == 5;
            }
        }
        return true;
    }

    public static String getExceptionString(int snmpSyntax) {
        switch (snmpSyntax) {
            case 129: {
                return "noSuchInstance";
            }
            case 128: {
                return "noSuchObject";
            }
            case 130: {
                return "endOfMibView";
            }
        }
        return null;
    }

    public boolean isWritable() {
        if (this.ot != null) {
            return SMI.isWritable(this.ot.getAccess());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static String[] toString(MIBRepository rep, VariableBinding vb, ValueConverter vc, Object nativeValue) {
        String[] stringArray = new String[3];
        ObjectID[] objectIDArray = new ObjectID(vb.getOid().getValue());
        try {
            objectIDArray = rep.getSplittedObjectID((ObjectID)objectIDArray);
            if (objectIDArray == null) {
                return null;
            }
            Comparable comparable = (ObjectID)objectIDArray.first;
            objectIDArray = (ObjectID)objectIDArray.second;
            if (comparable != null && objectIDArray != null && (comparable = vc != null ? vc.getObjectType() : rep.getObject((ObjectID)comparable)) instanceof MIBObjectType) {
                ValueConverter[] valueConverterArray;
                IndexStruct[] indexStructArray;
                if (((MIBObjectType)(comparable = (MIBObjectType)comparable)).isColumnarObject()) {
                    MIBObjectType mIBObjectType = (MIBObjectType)rep.getParent((MIBObject)comparable);
                    if (mIBObjectType != null) {
                        if (vc == null) {
                            indexStructArray = rep.getEffectiveSyntax(((MIBObjectType)comparable).getSyntax());
                            vc = new ValueConverter((MIBObjectType)comparable, indexStructArray.getSyntax(), indexStructArray.getDisplayHint());
                        }
                        indexStructArray = mIBObjectType.getIndexPart().getIndexStruct(rep);
                        objectIDArray = rep.getIndexObjectIDs((ObjectID)objectIDArray, indexStructArray);
                        valueConverterArray = IndexConverter.getIndexValueConverter(rep, mIBObjectType);
                        stringArray[0] = IndexConverter.getIndexString(valueConverterArray, indexStructArray, objectIDArray);
                        stringArray[1] = "" + vc.toNative(vb.getVariable());
                        stringArray[2] = ((MIBObject)comparable).getOid().toString();
                    }
                } else if (((MIBObjectType)comparable).isScalar()) {
                    void var1_1;
                    void var2_2;
                    stringArray[0] = null;
                    MIBTextualConvention mIBTextualConvention = valueConverterArray.getEffectiveSyntax(((MIBObjectType)comparable).getSyntax());
                    if (vc == null) {
                        vc = new ValueConverter((MIBObjectType)comparable, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
                    }
                    stringArray[1] = indexStructArray == null ? "" + var2_2.toNative(var1_1.getVariable()) : "" + indexStructArray;
                    stringArray[2] = ((MIBObject)comparable).getOid().toString();
                }
            }
            return stringArray;
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            ObjectIDFormatException objectIDFormatException2 = objectIDFormatException;
            objectIDFormatException.printStackTrace();
            return null;
        }
    }

    public static ValueConverter create(MIBObjectType ot, MIBRepository rep) {
        MIBObjectType mIBObjectType;
        MIBTextualConvention mIBTextualConvention = rep.getEffectiveSyntax(ot.getSyntax());
        return new ValueConverter(mIBObjectType, mIBTextualConvention.getSyntax(), mIBTextualConvention.getDisplayHint());
    }

    public String toString() {
        return "ValueConverter{objectType=" + this.ot + ",effectiveSyntax=" + this.effectiveSyntax + ",displayHint=" + this.displayHint + ",smiSyntax=" + this.smiSyntax + "}";
    }
}

