/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.pib.PIBIndexPart;
import com.agentpp.smi.IEnum;
import com.agentpp.smiparser.FileError;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.Node;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIAgentCapabilities;
import com.agentpp.smiparser.SMICompliance;
import com.agentpp.smiparser.SMIDefaultValue;
import com.agentpp.smiparser.SMIDescription;
import com.agentpp.smiparser.SMIEnum;
import com.agentpp.smiparser.SMIFile;
import com.agentpp.smiparser.SMIIndex;
import com.agentpp.smiparser.SMIMib;
import com.agentpp.smiparser.SMIModule;
import com.agentpp.smiparser.SMINotifyType;
import com.agentpp.smiparser.SMIObject;
import com.agentpp.smiparser.SMIObjectType;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SMIParser;
import com.agentpp.smiparser.SMIParserVisitor;
import com.agentpp.smiparser.SMIRange;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.SMIRevision;
import com.agentpp.smiparser.SMISeqEntries;
import com.agentpp.smiparser.SMISyntax;
import com.agentpp.smiparser.SMITextualConvention;
import com.agentpp.smiparser.SemanticError;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import com.agentpp.smiparser.Token;
import com.agentpp.smiparser.pib.PIBIndex;
import com.agentpp.smiparser.pib.PIBMib;
import com.agentpp.smiparser.pib.PIBModule;
import com.agentpp.smiparser.pib.PIBObjectType;
import com.objectspace.jgl.Pair;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

public class SMI2Java
implements SMIParseExceptionHandler,
SMIParserVisitor {
    public static final String PIB_TAG_REFERENCE_ID = "TagReferenceId";
    public static final String PIB_REFERENCE_ID = "ReferenceId";
    public static final String PIB_TAG_ID = "TagId";
    protected MIBRepository rep = null;
    protected SMIRepository smiRep;
    protected MIBModule currentModule = null;
    protected boolean currentModuleImportListFound = false;
    protected ModuleInfo currentModuleInfo = null;
    protected MIBObject currentObject = null;
    protected MIBObjectType currentObjectType = null;
    protected MIBSyntax currentSyntax = null;
    protected Map tableEntryToObject = null;
    protected Map nameToSyntax = null;
    protected Map nameSequences;
    protected Map<String, StringToken> objectLists;
    protected Map<String, com.agentpp.mib.pib.PIBObjectType> pibInstanceIds;
    protected Vector groups = null;
    protected int options = 4;
    protected int currentSMIVersion = 1;
    protected String currentFile = "";
    protected int moduleCount = 0;
    protected int maxErrors = 0;
    protected List errors = new LinkedList();
    protected ArrayList failedImports = new ArrayList();
    protected boolean storeFileName = Boolean.getBoolean("com.agentpp.smi.storeMIBFileName");
    protected static final Object[][] IMPORT_MAPPINGS = new Object[][]{{12, SMI.SMI_SYNTAX[12]}};

    /*
     * WARNING - void declaration
     */
    public SMI2Java(SMIRepository smiRep, int options) {
        void var2_2;
        void var1_1;
        this.smiRep = var1_1;
        this.options = var2_2;
        this.rep = new MIBRepository();
        this.tableEntryToObject = new HashMap(150);
        this.nameToSyntax = new HashMap(150);
        this.nameSequences = new HashMap(50);
        this.objectLists = new HashMap<String, StringToken>(20);
        this.pibInstanceIds = new HashMap<String, com.agentpp.mib.pib.PIBObjectType>(10);
        this.groups = new Vector(10, 10);
    }

    public MIBObject getCurrentObject() {
        return this.currentObject;
    }

    /*
     * WARNING - void declaration
     */
    public void setParseContext(MIBModule module, Set excludedObjectNames) {
        void var1_1;
        Object object;
        Object object2;
        Object object3;
        Iterator<Serializable> iterator = module.objectsIterator();
        while (iterator.hasNext()) {
            MIBObject mIBObject = iterator.next();
            if (excludedObjectNames.contains(mIBObject.getName())) continue;
            this.smiRep.scope.addObject(mIBObject.getClone());
            try {
                this.smiRep.scope.addKnownObject(mIBObject);
            }
            catch (SMIParseException sMIParseException) {}
            if (mIBObject instanceof MIBObjectType) {
                MIBSyntax mIBSyntax;
                object3 = (MIBObjectType)mIBObject;
                if (((MIBObjectType)object3).isTable()) {
                    Vector<StringToken> vector = new Vector<StringToken>();
                    object2 = ((MIBObjectType)object3).getTableEntriesVector().iterator();
                    while (object2.hasNext()) {
                        object = (String)object2.next();
                        vector.add(new StringToken((String)object, null));
                    }
                    this.nameSequences.put(((MIBObjectType)object3).getTableEntriesVector(), vector);
                }
                if ((mIBSyntax = ((MIBObjectType)object3).getSyntax()) == null || !Character.isUpperCase(mIBSyntax.getSyntax().charAt(0)) || mIBSyntax.getType() != 3) continue;
                this.tableEntryToObject.put(mIBSyntax.getSyntax(), object3);
                continue;
            }
            if (mIBObject instanceof MIBGroup) {
                this.groups.add(mIBObject);
                continue;
            }
            if (mIBObject instanceof MIBCompliance) {
                object3 = ((MIBCompliance)mIBObject).getModules();
                if (object3 == null) continue;
                Iterator iterator2 = ((Vector)object3).iterator();
                while (iterator2.hasNext()) {
                    String string;
                    object2 = iterator2.next();
                    if (!(object2 instanceof MIBComplianceModule) || (string = ((MIBComplianceModule)(object = (MIBComplianceModule)object2)).getModuleName()) == null || string.trim().length() <= 0 || this.smiRep.isModuleAlreadyImported(string)) continue;
                    this.smiRep.importModule(string, this.rep, true);
                }
                continue;
            }
            if (!(mIBObject instanceof MIBAgentCaps)) continue;
            for (MIBSupportedModule mIBSupportedModule : ((MIBAgentCaps)mIBObject).getModules()) {
                if (this.smiRep.isModuleAlreadyImported(mIBSupportedModule.getSupports())) continue;
                this.smiRep.importModule(mIBSupportedModule.getSupports(), this.rep, true);
            }
        }
        for (MIBImport mIBImport : module.getImportsVector()) {
            if (!this.smiRep.isModuleAlreadyImported(mIBImport.getSource())) {
                this.smiRep.importModule(mIBImport.getSource(), this.rep, false);
            }
            object3 = mIBImport.getImports();
            for (int i2 = 0; i2 < ((String[])object3).length; ++i2) {
                if (SMI.isKeyWord((String)object3[i2]) || (object2 = this.smiRep.scope.rep.getObject(mIBImport.getSource(), (String)object3[i2])) == null) continue;
                try {
                    this.smiRep.addKnownObject((MIBObject)object2);
                    continue;
                }
                catch (SMIParseException sMIParseException) {
                    object = sMIParseException;
                    sMIParseException.printStackTrace();
                }
            }
        }
        this.currentModule = (MIBModule)module.getClone();
        this.currentModuleInfo = new ModuleInfo(module.getModuleName(), module.getImportSources());
        iterator = var1_1.objectsIterator();
        while (iterator.hasNext()) {
            MIBObject mIBObject = (MIBObject)iterator.next();
            if (excludedObjectNames.contains(mIBObject.getName())) continue;
            this.rep.addObject(mIBObject.getClone());
        }
    }

    public final MIBRepository getRepository() {
        return this.rep;
    }

    protected final int getTokenSUPPORTS() {
        return 97;
    }

    protected final int getTokenDEFVAL() {
        return 55;
    }

    protected final int getTokenSYNTAX() {
        return 63;
    }

    protected final int getTokenWRITESYNTAX() {
        return 89;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkRestrictedSyntax(Token t, String oname, MIBSyntax syntax, int syntaxTokenType) throws SMIParseException {
        if (!syntax.isRestrictiveSyntax(this.smiRep.scope.rep)) {
            void var2_2;
            void var1_1;
            this.throwLocalizedError((Token)var1_1, new Vector<String>(Arrays.asList(var2_2)), 4000, syntaxTokenType, 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkDisplayHint(MIBTextualConvention tc) throws SMIParseException {
        if (tc != null && tc.hasDisplayHint()) {
            MIBSyntax mIBSyntax = tc.getSyntax();
            if (mIBSyntax == null) {
                return;
            }
            if (mIBSyntax.hasEnums() || SMI.SMI_SYNTAX[2].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[12].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[3].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[5].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[6].equals(mIBSyntax.getSyntax()) || SMI.SMI_SYNTAX[9].equals(mIBSyntax.getSyntax())) {
                this.throwLocalizedError(tc, new Vector<String>(Arrays.asList(tc.getName())), 4100, 80, 1);
                return;
            }
            if (Pattern.matches(SMIParser.DISPLAYHINT_FORMATS[1], tc.getDisplayHint())) {
                if (SMI.SMI_SYNTAX[1].equals(mIBSyntax.getSyntax())) {
                    this.throwLocalizedError(tc, new Vector<String>(Arrays.asList(tc.getName(), tc.getDisplayHint())), 4101, 80, 1);
                    return;
                }
            } else if (!SMI.SMI_SYNTAX[1].equals(mIBSyntax.getSyntax())) {
                void var1_1;
                this.throwLocalizedError(tc, new Vector<String>(Arrays.asList(tc.getName(), var1_1.getDisplayHint())), 4101, 80, 1);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkSyntax(StringToken oname, StringToken syntax) throws SMIParseException {
        void var2_2;
        void var1_1;
        if (syntax == null) {
            return;
        }
        Object object = (StringToken)this.nameToSyntax.get(oname);
        if (object != null && !syntax.equals(object) && (this.options & 2) == 0) {
            object = this.rep.getObject(oname.string);
            if (object != null && ((MIBObject)object).userObject instanceof Token) {
                Object object2 = object = (Token)((MIBObject)object).userObject;
                object = new SemanticError(1200, ((Token)object).beginLine, ((Token)object).beginColumn, ((Token)object).endPos, (Token)object2, ((Token)object2).image, oname.string, new String[0]);
                this.error(new SMIParseException((FileError)object, 1200));
            } else {
                this.throwLocalizedError(oname.token, 1200);
            }
        }
        this.nameToSyntax.put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected ModuleInfo readModule(SMIMib current) throws SMIParseException {
        void var1_1;
        this.currentSMIVersion = current.version;
        Iterator<MIBImport> iterator = this.smiRep.getModuleImporter();
        if ((iterator = iterator.createModuleID(current.getName())) == null) {
            iterator = this.moduleCount;
        }
        this.currentModule = current instanceof PIBMib ? new com.agentpp.mib.pib.PIBModule(current.getName(), (Integer)((Object)iterator)) : new MIBModule(current.getName(), (Integer)((Object)iterator));
        this.currentObject = null;
        this.currentModule.setLastChange(new Date(System.currentTimeMillis()));
        if (this.storeFileName) {
            try {
                this.currentModule.setFileName(new File(this.currentFile).getName());
            }
            catch (Exception exception) {}
        }
        this.currentModule.setName(current.getName());
        if (current.getToken() != null) {
            this.currentModule.setStartPosition(current.getToken().endPos - current.getToken().image.length());
        }
        this.currentModule.setOid(new ObjectID());
        this.currentModule.setSMIVersion(this.currentSMIVersion);
        this.currentModule.setCopyrightComment(current.asn1Comment);
        this.currentModule.setCopyrightCommentEnd(current.asn1EndComment);
        this.rep.addObject(this.currentModule);
        for (MIBImport mIBImport : current.getImports()) {
            this.readImports(mIBImport);
        }
        return new ModuleInfo(this.currentModule.getModuleName(), var1_1.getImportSources().toArray(new String[0]));
    }

    /*
     * WARNING - void declaration
     */
    protected void readModuleIdentity(SMIModule o2) throws SMIParseException {
        void var1_1;
        this.currentSMIVersion = 2;
        this.currentModule.setRevisionsVector(null);
        this.currentModule.setOrganization(o2.getOrganization());
        this.currentModule.setContactInfo(o2.getContactInfo());
        this.currentModule.setLastUpdated(var1_1.getLastUpdated());
        this.currentModule.setSMIVersion(2);
        this.currentModule.setReleased(1);
        this.currentObject = this.currentModule;
    }

    /*
     * WARNING - void declaration
     */
    protected void readPibModuleIdentity(PIBModule o2) throws SMIParseException {
        void var1_1;
        this.currentSMIVersion = -1;
        if (this.currentModule instanceof com.agentpp.mib.pib.PIBModule) {
            ((com.agentpp.mib.pib.PIBModule)this.currentModule).setCategories(o2.getCategories());
        }
        this.currentModule.setRevisionsVector(null);
        this.currentModule.setOrganization(o2.getOrganization());
        this.currentModule.setContactInfo(o2.getContactInfo());
        this.currentModule.setLastUpdated(var1_1.getLastUpdated());
        this.currentModule.setSMIVersion(-1);
        this.currentModule.setReleased(1);
        this.currentObject = this.currentModule;
    }

    /*
     * WARNING - void declaration
     */
    protected void readObject(SMIObject currentSMIObject) throws SMIParseException {
        void var1_1;
        StringToken stringToken;
        Object object = new ObjectID(currentSMIObject.getPrintableOid(this.smiRep));
        if (!((ObjectID)object).isValid() && (stringToken = currentSMIObject.getFirstUnresolvedSubId(this.smiRep)) != null && stringToken.string.length() > 0) {
            if (Character.isUpperCase(stringToken.string.charAt(0))) {
                Object object2 = ((ObjectID)object).getSubID(0);
                object = ((ObjectID)object).getSubID(1);
                if ((object = this.smiRep.getObjectID((String)object2, (String)object)) == null) {
                    if (stringToken.token != null) {
                        this.throwLocalizedError(stringToken.token, 1502);
                    } else if (currentSMIObject.getToken() != null) {
                        object2 = currentSMIObject.getToken();
                        this.error(new SMIParseException(new SemanticError(1502, ((Token)object2).beginLine, ((Token)object2).beginColumn, ((Token)object2).endPos, (Token)object2, stringToken.string, ((Token)object2).image, new String[0]), 1502));
                    } else {
                        this.error(new SMIParseException(stringToken.string, 1502));
                    }
                }
            } else if (stringToken.token != null) {
                this.throwLocalizedError(stringToken.token, 1502);
            } else if (currentSMIObject.getToken() != null) {
                Token token = currentSMIObject.getToken();
                this.error(new SMIParseException(new SemanticError(1502, token.beginLine, token.beginColumn, token.endPos, token, stringToken.string, token.image, new String[0]), 1502));
            } else {
                this.error(new SMIParseException(stringToken.string, 1502));
            }
        }
        if (currentSMIObject.getType() != 4 && !((ObjectID)object).isValid()) {
            this.currentObject = null;
            return;
        }
        switch (currentSMIObject.getType()) {
            case 1: {
                this.currentObject = this.currentModule instanceof com.agentpp.mib.pib.PIBModule ? new com.agentpp.mib.pib.PIBObjectType(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID()) : new MIBObjectType(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 2: 
            case 3: {
                this.currentObject = new MIBNotifyType(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID(), currentSMIObject.getType());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 4: {
                this.currentObject = new MIBTextualConvention(currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 5: {
                this.rep.renameObject(this.currentModule, new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName());
                this.currentModule.setStatus(currentSMIObject.getStatus());
                this.currentModule.setComment(currentSMIObject.asn1Comment);
                this.currentModule.setInlineComment(currentSMIObject.inlineAsn1Comment);
                break;
            }
            case 6: 
            case 7: {
                this.currentObject = new MIBGroup(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID(), currentSMIObject.getType());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.groups.addElement(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 9: {
                this.currentObject = new MIBAgentCaps(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            case 8: {
                this.currentObject = new MIBCompliance(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
                break;
            }
            default: {
                this.currentObject = new MIBObject(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), currentSMIObject.getName(), this.currentModule.getModuleID());
                this.currentObject.setStatus(currentSMIObject.getStatus());
                this.rep.addObject(this.currentObject);
                this.smiRep.addKnownObject(this.currentObject);
            }
        }
        if (this.currentObject != null) {
            this.currentObject.setModuleID(this.currentModule.getModuleID());
            this.currentObject.setSequenceID(currentSMIObject.sequenceID);
            if (!this.currentObject.hasComment()) {
                this.currentObject.setComment(currentSMIObject.asn1Comment);
            }
            if (!this.currentObject.hasInlineComment()) {
                this.currentObject.setInlineComment(currentSMIObject.inlineAsn1Comment);
            }
            this.currentObject.setReleased(1);
            this.currentObject.userObject = currentSMIObject.getToken();
            this.smiRep.addObject(this.currentObject);
            return;
        }
        this.smiRep.addObject(new MIBObject(new ObjectID(currentSMIObject.getPrintableOid(this.smiRep)), var1_1.getName()));
    }

    /*
     * WARNING - void declaration
     */
    protected final StringToken getStringToken(MIBSyntax syn) {
        void var1_1;
        if (syn == null) {
            return null;
        }
        if (syn.userObject != null) {
            return (StringToken)syn.userObject;
        }
        return new StringToken(var1_1.getSyntax(), null);
    }

    /*
     * WARNING - void declaration
     */
    protected void readPibObjectType(PIBObjectType o2) throws SMIParseException {
        void var1_1;
        if (!(this.currentObject instanceof com.agentpp.mib.pib.PIBObjectType)) {
            return;
        }
        this.readObjectType(o2);
        com.agentpp.mib.pib.PIBObjectType pIBObjectType = (com.agentpp.mib.pib.PIBObjectType)this.currentObject;
        pIBObjectType.setInstallErrors(o2.getInstallErrors());
        pIBObjectType.setUniqueObjects(this.convertStringToken(o2.getUniqueObjects()));
        pIBObjectType.setPibReferences(this.convertStringToken(o2.getPibReferences()));
        pIBObjectType.setTag(this.convertStringToken(o2.getTag()));
        this.checkPibObjectType(pIBObjectType, (PIBObjectType)var1_1);
    }

    protected void readObjectType(SMIObjectType o2) throws SMIParseException {
        Serializable serializable;
        if (!(this.currentObject instanceof MIBObjectType)) {
            return;
        }
        MIBObjectType mIBObjectType = (MIBObjectType)this.currentObject;
        mIBObjectType.setAccess(o2.getAccess());
        mIBObjectType.setUnits(o2.getUnits());
        mIBObjectType.setSyntax(o2.syntax);
        serializable = ((SMIObjectType)((Object)serializable)).syntax;
        this.currentSyntax = serializable;
        if (serializable == null) {
            return;
        }
        this.checkSyntax(new StringToken(mIBObjectType.getName(), (Token)mIBObjectType.userObject), (StringToken)((MIBSyntax)serializable).userObject);
        if (((MIBSyntax)serializable).getType() == 3 || ((MIBSyntax)serializable).getType() == 2) {
            this.smiRep.checkUnresolvedSyntax(this.getStringToken((MIBSyntax)serializable));
        }
        if (Character.isUpperCase(((MIBSyntax)serializable).getSyntax().charAt(0)) && ((MIBSyntax)serializable).getType() == 3) {
            this.tableEntryToObject.put(((MIBSyntax)serializable).getSyntax(), mIBObjectType);
            Object object = this.smiRep.getSequence(((MIBSyntax)serializable).getSyntax());
            if (object != null && ((Vector)object).size() > 0) {
                Comparable comparable = new MIBTextualConvention(((MIBSyntax)serializable).getSyntax());
                new MIBTextualConvention(((MIBSyntax)serializable).getSyntax()).userObject = this.getStringToken((MIBSyntax)serializable).token;
                this.smiRep.addKnownObject((MIBObject)comparable);
                serializable = new Vector(((Vector)object).size() + 1);
                object = ((Vector)object).elements();
                while (object.hasMoreElements()) {
                    comparable = (StringToken)object.nextElement();
                    ((Vector)serializable).addElement(((StringToken)comparable).string);
                }
                mIBObjectType.setTableEntriesVector((Vector)serializable);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkPibObjectType(com.agentpp.mib.pib.PIBObjectType ot, PIBObjectType o2) throws SMIParseException {
        void var1_1;
        Object object;
        HashSet<String> hashSet;
        if (ot.getTag() != null && ot.getSyntax() != null && !PIB_TAG_REFERENCE_ID.equals(ot.getSyntax().getSyntax())) {
            this.throwLocalizedError(o2.getTag().token, null, 6001, this.getTokenPIBTAG(), 0);
        }
        if (ot.getPibReferences() != null && ot.getSyntax() != null && !PIB_REFERENCE_ID.equals(ot.getSyntax().getSyntax())) {
            this.throwLocalizedError(o2.getTag().token, null, 6002, this.getTokenPIBREFERENCES(), 0);
        }
        if (ot.getSyntax() != null && PIB_TAG_REFERENCE_ID.equals(ot.getSyntax().getSyntax()) && ot.getTag() == null) {
            this.throwLocalizedError(ot, null, 6003, this.getTokenPIBREFERENCES(), 0);
        }
        if (ot.getSyntax() != null && PIB_REFERENCE_ID.equals(ot.getSyntax().getSyntax()) && ot.getPibReferences() == null) {
            this.throwLocalizedError((Token)ot.userObject, null, 6004, -1, 0);
        } else if (ot.getPibReferences() != null) {
            this.smiRep.checkUnresolvedObject(((PIBObjectType)((Object)hashSet)).getPibReferences(), com.agentpp.mib.pib.PIBObjectType.class);
        }
        if (ot.getUniqueObjects() != null && ot.getIndex() instanceof PIBIndexPart && ((PIBIndexPart)ot.getIndex()).isIndex()) {
            hashSet = new HashSet<String>(ot.getUniqueObjects().size());
            object = ot.getUniqueObjects().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if (ot.getIndex().getIndexPartVector().contains(string)) {
                    this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getName(), string)), 6005, this.getTokenUNIQENESS(), 0);
                }
                if (hashSet.contains(string)) {
                    this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getName(), string)), 6006, this.getTokenUNIQENESS(), 0);
                }
                hashSet.add(string);
            }
        }
        if (ot.getInstallErrors() != null) {
            hashSet = ot.getInstallErrors().iterator();
            while (hashSet.hasNext()) {
                object = hashSet.next();
                if (((MIBEnum)object).hasValidValue() && ((MIBEnum)object).getLongValue() >= 0L && ((MIBEnum)object).getLongValue() <= 65535L) continue;
                this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getName(), ((MIBEnum)object).getValue(), ((MIBEnum)object).getLabel())), 6007, this.getTokenINSTALLERRORS(), 0);
            }
        }
        if (!((hashSet = this.pibInstanceIds.get(ot.getName())) == null || ((MIBObjectType)((Object)hashSet)).getIndexPart() == null || ((MIBObjectType)((Object)hashSet)).getIndexPart().getType() != 1 || (object = var1_1.getSyntax()) != null && ((MIBSyntax)object).getType() == 3 && "InstanceId".equals(((MIBSyntax)object).getSyntax()))) {
            this.throwLocalizedError((MIBObject)((Object)hashSet), null, 6000, this.getTokenPIBINDEX(), 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readNotifyType(SMINotifyType o2) throws SMIParseException {
        void var1_1;
        if (!(this.currentObject instanceof MIBNotifyType)) {
            return;
        }
        MIBNotifyType mIBNotifyType = (MIBNotifyType)this.currentObject;
        mIBNotifyType.setEnterprise(var1_1.getEnterprise());
    }

    protected void readSeqEntries(SMISeqEntries s) throws SMIParseException {
        Object object;
        Object object2;
        Vector vector;
        String string = ((SMIObject)s.jjtGetParent()).getName();
        if (string.length() == 0) {
            return;
        }
        MIBObject mIBObject = Character.isUpperCase(string.charAt(0)) ? (MIBObject)this.tableEntryToObject.get(string) : this.rep.getObject(string);
        vector = ((SMISeqEntries)((Object)vector)).entries();
        Vector<String> vector2 = new Vector<String>(vector.size());
        Object object3 = vector.elements();
        while (object3.hasMoreElements()) {
            object2 = (Pair)object3.nextElement();
            vector2.add(((StringToken)((Pair)object2).first).string);
            object = null;
            if (mIBObject != null && (mIBObject instanceof MIBObjectType || mIBObject instanceof MIBNotifyType)) {
                object = MIBObjectType.class;
            }
            if (mIBObject != null && mIBObject instanceof MIBGroup && mIBObject.getType() == 6) {
                object = MIBObjectType.class;
            } else if (mIBObject != null && mIBObject instanceof MIBGroup) {
                object = MIBNotifyType.class;
            }
            this.smiRep.checkUnresolvedObject((StringToken)((Pair)object2).first, (Class)object);
            if (((Pair)object2).second == null) continue;
            this.checkSyntax((StringToken)((Pair)object2).first, (StringToken)((Pair)object2).second);
        }
        this.nameSequences.put(vector2, vector);
        if (mIBObject != null) {
            if (mIBObject instanceof MIBObjectType) {
                object3 = (MIBObjectType)mIBObject;
                if (!((MIBObjectType)object3).hasIndexPart()) {
                    this.throwInconsistentSyntaxError((MIBObjectType)object3);
                }
                ((MIBObjectType)object3).setTableEntriesVector(vector2);
                if (((MIBObjectType)object3).getSyntax() != null) {
                    object2 = new MIBTextualConvention(((MIBObjectType)object3).getSyntax().getSyntax());
                    new MIBTextualConvention(((MIBObjectType)object3).getSyntax().getSyntax()).userObject = this.getStringToken(((MIBObjectType)object3).getSyntax());
                    this.smiRep.addKnownObject((MIBObject)object2);
                }
            }
            if (mIBObject instanceof MIBNotifyType) {
                object3 = (MIBNotifyType)mIBObject;
                ((MIBNotifyType)object3).setVariablesVector(vector2);
            }
            if (mIBObject instanceof MIBGroup) {
                object3 = (MIBGroup)mIBObject;
                ((MIBGroup)object3).setObjectsVector(vector2);
                return;
            }
        } else {
            object3 = this.smiRep.getSequence(string);
            if (object3 != null) {
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    object = (Pair)object2.nextElement();
                    ((Vector)object3).add(object.first);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void throwInconsistentSyntaxError(MIBObjectType ot) throws SMIParseException {
        void var1_1;
        if (ot.userObject != null && ot.userObject instanceof Token) {
            this.throwLocalizedError(ot, new Vector<String>(Arrays.asList(ot.getName())), 1200, 63, 1);
            return;
        }
        this.error(new SMIParseException(var1_1.getName(), 1200));
    }

    protected List<String> convertStringToken(List<StringToken> stringTokens) {
        Iterator iterator;
        if (stringTokens == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringTokens.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            StringToken stringToken = (StringToken)iterator.next();
            arrayList.add(stringToken.string);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    protected String convertStringToken(StringToken stringToken) {
        void var1_1;
        if (stringToken == null) {
            return null;
        }
        return var1_1.string;
    }

    /*
     * WARNING - void declaration
     */
    protected void readRevision(SMIRevision r2) throws SMIParseException {
        void var1_1;
        this.currentModule.addRevision(new MIBRevision(r2.getRevision(), var1_1.getDescription()));
    }

    /*
     * WARNING - void declaration
     */
    protected void readSyntax(SMISyntax syn) throws SMIParseException {
        void var1_1;
        MIBSyntax mIBSyntax = new MIBSyntax(syn.getSyntax().string, syn.getType());
        new MIBSyntax(syn.getSyntax().string, syn.getType()).userObject = syn.getSyntax();
        if (!(syn.jjtGetParent() instanceof SMISeqEntries) && this.currentObject instanceof MIBAgentCaps && (syn.getType() == 3 || var1_1.getType() == 2)) {
            this.smiRep.checkUnresolvedSyntax(this.getStringToken(mIBSyntax));
        }
        if (this.currentSyntax == null) {
            this.currentSyntax = mIBSyntax;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readRange(SMIRange r2) throws SMIParseException {
        if (this.currentSyntax != null) {
            void var1_1;
            this.currentSyntax.addRange(new MIBRange(r2.getLower(), var1_1.getUpper()));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readEnum(SMIEnum e2) throws SMIParseException {
        if (this.currentSyntax != null) {
            this.currentSyntax.addEnum(new MIBEnum(e2.getLabel(), e2.getValue(), e2.comment));
            return;
        }
        if (this.currentObject instanceof com.agentpp.mib.pib.PIBModule) {
            void var1_1;
            List<? extends IEnum> list;
            com.agentpp.mib.pib.PIBModule pIBModule = (com.agentpp.mib.pib.PIBModule)this.currentObject;
            if (pIBModule.getCategories() == null) {
                list = new ArrayList<IEnum>();
                pIBModule.setCategories(list);
            } else {
                list = pIBModule.getCategories();
            }
            list.add(new MIBEnum(e2.getLabel(), e2.getValue(), var1_1.comment));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void readVariable(StringToken v) {
        Object object = this.currentObject instanceof MIBGroup && ((MIBGroup)this.currentObject).getType() == 7 ? MIBNotifyType.class : MIBObjectType.class;
        this.smiRep.checkUnresolvedObject(v, (Class)object);
        if (this.currentObject instanceof MIBNotifyType) {
            object = (MIBNotifyType)this.currentObject;
            ((MIBNotifyType)object).addVariable(v.string);
            this.addObjectToObjectsList(((MIBObject)object).getName(), v);
        }
        if (this.currentObject instanceof MIBGroup) {
            void var1_1;
            object = (MIBGroup)this.currentObject;
            ((MIBGroup)object).addObject(v.string);
            this.addObjectToObjectsList(((MIBObject)object).getName(), (StringToken)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void addObjectToObjectsList(String objectName, StringToken objectItem) {
        void var2_2;
        void var1_1;
        this.objectLists.put((String)var1_1 + " " + objectItem.string, (StringToken)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void readIndex(SMIIndex index) throws SMIParseException {
        Object object;
        Object object2;
        Object object3;
        Object object4 = index.getIndecies();
        Vector<String> vector = new Vector<String>(((Vector)object4).size() + 1);
        MIBObjectType mIBObjectType = (MIBObjectType)this.currentObject;
        object4 = ((Vector)object4).elements();
        while (object4.hasMoreElements()) {
            object3 = MIBObjectType.class;
            object2 = (StringToken)object4.nextElement();
            if (this.currentModule.getSMIVersion() != 1 || !SMI.isASN1KeyWord(((StringToken)object2).string)) {
                this.smiRep.checkUnresolvedObject((StringToken)object2, (Class)object3);
                if (mIBObjectType instanceof com.agentpp.mib.pib.PIBObjectType) {
                    object = this.currentModule.getImportSource(((StringToken)object2).string);
                    object = object == null ? this.currentModule.getObjectByName(((StringToken)object2).string) : this.smiRep.getObject((String)object, ((StringToken)object2).string);
                    if (object == null) {
                        this.smiRep.checkUnresolvedSyntax(new StringToken(((StringToken)object2).string, ((StringToken)object2).token));
                        this.pibInstanceIds.put(((StringToken)object2).string, (com.agentpp.mib.pib.PIBObjectType)mIBObjectType);
                    } else if (!(object instanceof com.agentpp.mib.pib.PIBObjectType) || index.getType() == 1 && !((MIBObjectType)object).isColumnarObject()) {
                        this.a(mIBObjectType, 1810);
                    } else if (!(index.getType() != 1 || (object3 = ((MIBObjectType)object).getSyntax()) != null && ((MIBSyntax)object3).getType() == 3 && "InstanceId".equals(((MIBSyntax)object3).getSyntax()))) {
                        this.throwLocalizedError(((StringToken)object2).token, 6000);
                    }
                }
            }
            vector.add(((StringToken)object2).string);
        }
        if (mIBObjectType == null) {
            return;
        }
        int n2 = index.getType() == 2 ? 2 : (index.getType() == 3 ? 3 : 1);
        object3 = index instanceof PIBIndex ? new PIBIndexPart(n2, vector) : new MIBIndexPart(n2, vector);
        ((MIBIndexPart)object3).setImplied(index.getImplied());
        if (mIBObjectType instanceof com.agentpp.mib.pib.PIBObjectType) {
            if (!(index instanceof PIBIndex)) {
                ((com.agentpp.mib.pib.PIBObjectType)mIBObjectType).setMibIndexPart((MIBIndexPart)object3);
            } else {
                mIBObjectType.setIndexPart((MIBIndexPart)object3);
            }
        } else {
            mIBObjectType.setIndexPart((MIBIndexPart)object3);
        }
        if (((MIBIndexPart)object3).isAugment() || object3 instanceof PIBIndexPart && ((PIBIndexPart)object3).isExtends()) {
            object2 = (String)((MIBIndexPart)object3).getIndexPartVector().get(0);
            object = this.currentModule.getImportSource((String)object2);
            object = object == null ? this.currentModule.getObjectByName((String)object2) : this.smiRep.getObject((String)object, (String)object2);
            if (object == null) {
                void var1_1;
                this.smiRep.checkUnresolvedSyntax(new StringToken((String)object2, var1_1.getToken()));
                return;
            }
            if (!(object instanceof MIBObjectType) || !((MIBObjectType)object).isTable()) {
                this.throwLocalizedError(mIBObjectType, new Vector<String>(Arrays.asList(object2, ((MIBObject)object).getTypeString())), 1600, this.getTokenINDEX(), 1);
                return;
            }
            if (((MIBObjectType)object).getIndexPart() != null && !(object3 instanceof PIBIndexPart) && ((MIBObjectType)object).getIndexPart().isAugment()) {
                this.a(mIBObjectType);
            }
        }
    }

    private void a(MIBObjectType object, MIBIndexPart serializable) throws SMIParseException {
        if (serializable != null) {
            int n2;
            IndexStruct[] indexStructArray = serializable.getIndexStruct(this.smiRep.scope.rep);
            if (indexStructArray == null) {
                indexStructArray = serializable.getIndexStruct(this.rep);
            }
            if (indexStructArray == null) {
                return;
            }
            int n3 = ((MIBObject)object).getOid().size();
            for (n2 = 0; n2 < indexStructArray.length; ++n2) {
                if (indexStructArray[n2] == null) continue;
                n3 += indexStructArray[n2].minLength;
                if (indexStructArray[n2].minLength == indexStructArray[n2].maxLength) continue;
                ++n3;
            }
            if (indexStructArray[indexStructArray.length - 1] != null) {
                n2 = indexStructArray[indexStructArray.length - 1].maxLength;
                if (n2 <= 0 || n3 > 128) {
                    this.a((MIBObjectType)object, 1812);
                }
                int n4 = indexStructArray[indexStructArray.length - 1].minLength;
                if (serializable.isImplied() && n4 != n2 && n4 == 0) {
                    serializable = object;
                    object = this;
                    ((SMI2Java)object).a((MIBObjectType)serializable, 1813);
                }
            }
        }
    }

    protected int getTokenINDEX() {
        return 54;
    }

    private void a(MIBObjectType mIBObjectType) throws SMIParseException {
        this.a(mIBObjectType, 1810);
    }

    private void a(MIBObjectType mIBObjectType, int n2) throws SMIParseException {
        if (mIBObjectType.userObject != null && mIBObjectType.userObject instanceof Token) {
            Token token = (Token)mIBObjectType.userObject;
            this.error(new SMIParseException(new SemanticError(n2, token.beginLine, token.beginColumn, token.endPos, token, mIBObjectType.getName(), token.image, new String[0]), n2));
            return;
        }
        this.error(new SMIParseException(mIBObjectType.getName(), n2));
    }

    /*
     * WARNING - void declaration
     */
    public final void throwLocalizedError(MIBObject ot, Vector objects, int error, int preceedingToken, int offset) throws SMIParseException {
        void var2_2;
        void var3_3;
        void var1_1;
        if (ot.userObject != null && ot.userObject instanceof Token) {
            Token token = (Token)ot.userObject;
            while (token.next != null && token.kind != preceedingToken) {
                token = token.next;
            }
            for (int i2 = 0; i2 < offset && token.next != null; ++i2) {
                token = token.next;
            }
            this.error(new SMIParseException(new SemanticError(error, token.beginLine, token.beginColumn, token.endPos, token, ot.getName(), token.image, new String[0]), error, (List)objects));
            return;
        }
        this.error(new SMIParseException(var1_1.getName(), (int)var3_3, (List)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void throwLocalizedError(MIBObject ot, Vector objects, int error, int preceedingToken, int offset, int errorObjectIndex) throws SMIParseException {
        void var2_2;
        void var3_3;
        void var1_1;
        if (ot.userObject != null && ot.userObject instanceof Token) {
            Token token = (Token)ot.userObject;
            while (token.next != null && token.kind != preceedingToken) {
                token = token.next;
            }
            for (int i2 = 0; i2 < offset && token.next != null; ++i2) {
                token = token.next;
            }
            this.error(new SMIParseException(new SemanticError(error, token.beginLine, token.beginColumn, token.endPos, token, errorObjectIndex < 0 ? ot.getName() : (String)objects.get(errorObjectIndex), token.image, new String[0]), error, (List)objects));
            return;
        }
        this.error(new SMIParseException(var1_1.getName(), (int)var3_3, (List)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void throwLocalizedError(Token t, List objects, int error, int preceedingToken, int offset) throws SMIParseException {
        void var2_2;
        void var3_3;
        void var1_1;
        if (preceedingToken >= 0) {
            while (t.next != null && t.kind != preceedingToken) {
                t = t.next;
            }
        }
        for (int i2 = 0; i2 < offset && t.next != null; ++i2) {
            t = t.next;
        }
        this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, objects != null && objects.size() > 0 ? objects.get(0).toString() : t.image, var1_1.image, new String[0]), (int)var3_3, (List)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void throwLocalizedError(Token t, List objects, int error, int preceedingToken, String foundImage) throws SMIParseException {
        void var2_2;
        void var3_3;
        void var1_1;
        if (preceedingToken >= 0) {
            while (t.next != null && t.kind != preceedingToken) {
                t = t.next;
            }
        }
        if (foundImage != null) {
            while (t.next != null && !t.image.equals(foundImage)) {
                t = t.next;
            }
        }
        this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, foundImage == null ? objects.get(0).toString() : foundImage, var1_1.image, new String[0]), (int)var3_3, (List)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void throwLocalizedError(Token t, List objects, int error, String foundImage) throws SMIParseException {
        void var2_2;
        void var3_3;
        void var1_1;
        if (foundImage != null) {
            while (t.next != null && !t.image.equals(foundImage)) {
                t = t.next;
            }
        }
        this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, t, foundImage == null ? objects.get(0).toString() : foundImage, var1_1.image, new String[0]), (int)var3_3, (List)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void throwLocalizedError(Token t, int error) throws SMIParseException {
        void var2_2;
        void var1_1;
        Token token = t;
        this.error(new SMIParseException(new SemanticError(error, t.beginLine, t.beginColumn, t.endPos, token, token.image, var1_1.image, new String[0]), (int)var2_2, new Vector(1)));
    }

    /*
     * WARNING - void declaration
     */
    public final void throwNegativeIndex(MIBObjectType ot, String oname) throws SMIParseException {
        void var1_1;
        Token token;
        Vector<Object> vector = new Vector<Object>(2);
        vector.add(ot.getName());
        vector.add(token);
        if (ot.userObject != null && ot.userObject instanceof Token) {
            token = (Token)ot.userObject;
            while (token.next != null && token.kind != 54) {
                token = token.next;
            }
            for (int i2 = 0; i2 < 2 && token.next != null; ++i2) {
                token = token.next;
            }
            this.error(new SMIParseException(new SemanticError(1820, token.beginLine, token.beginColumn, token.endPos, token, ot.getName(), token.image, new String[0]), 1820, vector));
            return;
        }
        this.error(new SMIParseException(var1_1.getName(), 1820, vector));
    }

    /*
     * WARNING - void declaration
     */
    protected void checkDefaultValue(MIBObjectType ot, MIBSyntax refinement, String defaultValue, Token objectToken, int tokenType) throws SMIParseException {
        MIBTextualConvention mIBTextualConvention;
        Object object;
        if (!ot.hasDefaultValue()) {
            return;
        }
        if ((object = MIBObjectType.getDefaultValue(this.smiRep.scope.rep, refinement, (String)object)) == null) {
            this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(ot.getName())), 3002, tokenType, 2);
        }
        if ((mIBTextualConvention = this.smiRep.scope.rep.getEffectiveSyntax((MIBSyntax)((Object)mIBTextualConvention))).getSyntax() != null) {
            long l2;
            if (SMI.isCounter(mIBTextualConvention.getSyntax().getSyntax())) {
                this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(ot.getName())), 3003, tokenType, 2);
            }
            if (object instanceof Number) {
                long l3 = (Long)object;
                if (!mIBTextualConvention.getSyntax().isIncludedInRanges(l3) || SMI.isUnsignedNumeric(mIBTextualConvention.getSyntax().getSyntax()) && (l3 < 0L || l3 > 0xFFFFFFFFL) || SMI.SMI_SYNTAX[8].equals(mIBTextualConvention.getSyntax().getSyntax()) && (l3 < Integer.MIN_VALUE || l3 > Integer.MAX_VALUE)) {
                    this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(ot.getName())), 3000, tokenType, 2);
                }
                return;
            }
            if (object instanceof byte[]) {
                long l4 = ((byte[])object).length;
                if (mIBTextualConvention.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[9]) && l4 != 4L || !mIBTextualConvention.getSyntax().isIncludedInRanges(l4)) {
                    this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(ot.getName())), 3000, tokenType, 2);
                }
                return;
            }
            if (object instanceof ObjectID && (l2 = (long)((ObjectID)object).size()) > 128L) {
                void var1_1;
                this.throwLocalizedError(objectToken, new Vector<Object>(Arrays.asList(var1_1.getName())), 3000, tokenType, 2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkDefaultValue(MIBObjectType ot) throws SMIParseException {
        if (ot.hasDefaultValue() && ot.getSyntax() != null) {
            Object object = ot.getDefaultValue(this.smiRep.scope.rep);
            if (object == null) {
                this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(ot.getName())), 3002, this.getTokenDEFVAL(), 2);
            }
            if (ot.getSyntax() != null) {
                long l2;
                MIBTextualConvention mIBTextualConvention = this.smiRep.scope.rep.getEffectiveSyntax(ot.getSyntax());
                if (SMI.isCounter(mIBTextualConvention.getSyntax().getSyntax())) {
                    this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(ot.getName())), 3003, this.getTokenDEFVAL(), 2);
                }
                if (object instanceof Number) {
                    long l3 = (Long)object;
                    if (!mIBTextualConvention.getSyntax().isIncludedInRanges(l3) || SMI.isUnsignedNumeric(mIBTextualConvention.getSyntax().getSyntax()) && (l3 < 0L || l3 > 0xFFFFFFFFL) || SMI.SMI_SYNTAX[8].equals(mIBTextualConvention.getSyntax().getSyntax()) && (l3 < Integer.MIN_VALUE || l3 > Integer.MAX_VALUE)) {
                        this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(ot.getName())), 3000, this.getTokenDEFVAL(), 2);
                    }
                    return;
                }
                if (object instanceof byte[]) {
                    long l4 = ((byte[])object).length;
                    if (mIBTextualConvention.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[9]) && l4 != 4L || !mIBTextualConvention.getSyntax().isIncludedInRanges(l4)) {
                        this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(ot.getName())), 3000, this.getTokenDEFVAL(), 2);
                    }
                    return;
                }
                if (object instanceof ObjectID && (l2 = (long)((ObjectID)object).size()) > 128L) {
                    void var1_1;
                    this.throwLocalizedError(ot, new Vector<Object>(Arrays.asList(var1_1.getName())), 3000, this.getTokenDEFVAL(), 2);
                }
            }
        }
    }

    protected void checkVariation(String module, MIBVariation mv, Token t) throws SMIParseException {
        Iterator iterator;
        Object object2 = module != null && module.length() > 0 && !module.equals(this.currentModule.getModuleName()) ? this.smiRep.scope.rep.getObject(module, mv.getVariation()) : this.rep.getObject(mv.getVariation());
        if (object2 == null && (iterator = this.currentModule.getImportSource(mv.getVariation())) != null && (iterator = this.smiRep.scope.rep.getModule((String)((Object)iterator))) != null) {
            object2 = ((MIBModule)((Object)iterator)).getObjectByName(mv.getVariation());
        }
        if (mv instanceof MIBCondGroup) {
            if (!(object2 instanceof MIBGroup)) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(object2 == null ? "undefined" : ((MIBObject)object2).getTypeString(), mv.getVariation())), 1601, -1, 0);
            }
            return;
        }
        if (object2 instanceof MIBNotifyType) {
            if (mv.hasAccess() && !mv.getAccess().equals(SMI.ACCESS[6])) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenACCESS(), 0);
            }
            if (mv instanceof MIBException && ((MIBException)mv).hasAccess() && !mv.getAccess().equals(SMI.ACCESS[6])) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenACCESS(), 0);
            }
            if (mv.hasSyntax()) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenSYNTAX(), 0);
            }
            if (mv.hasWriteSyntax()) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenWRITESYNTAX(), 0);
            }
            if (mv.hasDefaultValue()) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1050, this.getTokenDEFVAL(), 0);
                return;
            }
        } else {
            if (object2 == null) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1502, -1, 0);
                return;
            }
            if (!(object2 instanceof MIBObjectType)) {
                this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation(), object2 == null ? "unknown" : ((MIBObject)object2).getTypeString())), 1602, -1, 0);
                return;
            }
            if (((MIBObjectType)(object2 = (MIBObjectType)object2)).getSyntax() != null) {
                iterator = this.smiRep.scope.rep.getEffectiveSyntax(((MIBObjectType)object2).getSyntax()).getSyntax();
                if (mv.hasSyntax()) {
                    iterator = this.smiRep.scope.rep.getEffectiveSyntax(mv.getSyntax()).getSyntax();
                    if (!((MIBObjectType)object2).getSyntax().isRestrictiveSyntax(this.smiRep.scope.rep, mv.getSyntax())) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 4000, this.getTokenSYNTAX(), 1);
                    }
                }
                if (mv.hasSyntax()) {
                    if (SMI.isCounter(mv.getSyntax().getSyntax())) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 3003, this.getTokenSYNTAX(), 1);
                    } else if (mv.hasDefaultValue()) {
                        this.checkDefaultValue((MIBObjectType)object2, (MIBSyntax)((Object)iterator), mv.getDefval(), t, this.getTokenDEFVAL());
                    }
                }
                if (mv.hasWriteSyntax()) {
                    if (SMI.isCounter(mv.getWriteSyntax().getSyntax())) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 3003, this.getTokenWRITESYNTAX(), 1);
                    }
                    if (!((MIBObjectType)object2).getSyntax().isRestrictiveSyntax(this.smiRep.scope.rep, mv.getWriteSyntax())) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 4000, this.getTokenWRITESYNTAX(), 1);
                    }
                }
                if (mv.hasCreationRequires()) {
                    if (!((MIBObjectType)object2).isTable()) {
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1220, this.getTokenCREATION_REQUIRES(), 0);
                        return;
                    }
                    for (Object object2 : mv.getCreationRequiresVector()) {
                        MIBObject mIBObject = module != null && module.length() > 0 && !module.equals(this.currentModule.getModuleName()) ? this.smiRep.scope.rep.getObject(module, (String)object2) : this.rep.getObject((String)object2);
                        if (!(mIBObject instanceof MIBObjectType) || ((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject)).isColumnarObject() && ((MIBObjectType)mIBObject).getAccess().equals(SMI.ACCESS[3])) continue;
                        this.throwLocalizedError(t, new Vector<String>(Arrays.asList(mv.getVariation())), 1221, this.getTokenCREATION_REQUIRES(), (String)object2);
                    }
                }
            }
        }
    }

    protected final int getTokenCREATION_REQUIRES() {
        return 100;
    }

    protected final int getTokenACCESS() {
        return 59;
    }

    /*
     * WARNING - void declaration
     */
    protected void checkWhetherIndexIsPositive(MIBObjectType ot) throws SMIParseException {
        if (ot.getIndexPart().isAugment() || ot.getIndexPart().getType() == 3 || ot.getOid() == null || !ot.getOid().isValid()) {
            return;
        }
        if (!ot.isTable()) {
            this.throwLocalizedError(ot, new Vector(), 1851, 54, 0);
        }
        int n2 = 0;
        MIBIndexPart mIBIndexPart = ot instanceof com.agentpp.mib.pib.PIBObjectType ? ((com.agentpp.mib.pib.PIBObjectType)ot).getMibIndexPart() : ot.getIndexPart();
        if (mIBIndexPart != null) {
            Enumeration enumeration = mIBIndexPart.getIndexPartVector().elements();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement().toString();
                MIBObject mIBObject = this.smiRep.scope.rep.getObject((String)object);
                if (mIBObject == null) {
                    mIBObject = this.smiRep.getKnownObject((String)object);
                }
                if (!(mIBObject instanceof MIBObjectType)) {
                    this.a(ot);
                } else {
                    Serializable serializable;
                    if (!((MIBObjectType)mIBObject).isColumnarObject()) {
                        serializable = new Vector<String>(2);
                        serializable.add(ot.getName());
                        serializable.add((String)object);
                        this.throwLocalizedError(ot, (Vector)serializable, 1850, 54, 2 + (n2 << 1));
                    }
                    if (((MIBObjectType)mIBObject).getSyntax() != null && !SMI.isUnsignedNumeric(((MIBSyntax)(object = ((MIBTextualConvention)(serializable = this.rep.getEffectiveSyntax(((MIBObjectType)mIBObject).getSyntax()))).getSyntax())).getSyntax()) && SMI.isNumeric(((MIBSyntax)object).getSyntax()) && Math.max(((MIBSyntax)object).getMinOfRanges(), ((MIBSyntax)object).getMinOfEnums()) < 0L) {
                        this.throwNegativeIndex(ot, mIBObject.getName());
                    }
                }
                ++n2;
            }
        }
        MIBObjectType mIBObjectType = ot;
        this.a(mIBObjectType, mIBObjectType.getIndexPart());
        if (ot instanceof com.agentpp.mib.pib.PIBObjectType) {
            void var1_1;
            this.a((MIBObjectType)var1_1, mIBIndexPart);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String readImports(MIBImport list) throws SMIParseException {
        void var1_1;
        Object object;
        String string = list.getSource();
        Vector<String> vector = list.getImportsVector();
        Token[] tokenArray = (Token[])list.getUserObject();
        if (!(this.smiRep.isModuleAlreadyImported(string) || this.smiRep.importModule(string, this.rep, false) || this.failedImports.contains(string))) {
            this.failedImports.add(string);
            this.throwLocalizedError(tokenArray[1], new Vector<String>(Arrays.asList(string)), 1100, string);
        }
        if ((object = this.smiRep.hasCircularImport(string, this.currentModule.getModuleName())) != null) {
            this.throwLocalizedError(tokenArray[1], new Vector<String>(Arrays.asList(object)), 1101, string);
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            Serializable serializable;
            String string2 = (String)object.nextElement();
            if (SMI.isASN1KeyWord(string2)) {
                this.throwLocalizedError(tokenArray[0], new Vector<String>(Arrays.asList(string2)), 1114, string2);
                continue;
            }
            MIBObject mIBObject = this.smiRep.getObject(string, string2);
            if (mIBObject instanceof MIBNotifyType) {
                serializable = new Vector<String>(1);
                ((Vector)serializable).add(mIBObject.getName());
                this.throwLocalizedError(tokenArray[0], (List)((Object)serializable), 1114, mIBObject.getName());
                continue;
            }
            if (mIBObject != null) {
                serializable = this.currentModule.getImportSources(string2);
                if (((Vector)serializable).size() > 0) {
                    if (!((Vector)serializable).contains(string)) {
                        serializable = this.smiRep.getKnownObject(string2);
                        String string3 = this.smiRep.getModuleName(((MIBObject)serializable).getModuleID());
                        if (string3 != null) {
                            serializable = ((MIBObject)serializable).getClone();
                            ((MIBObject)serializable).setName(string3 + "." + ((MIBObject)serializable).getName());
                            this.smiRep.replaceKnownObject(string2, (MIBObject)serializable);
                        }
                    } else {
                        serializable = new Vector<String>(2);
                        ((Vector)serializable).add(string2);
                        ((Vector)serializable).add(string);
                        this.throwLocalizedError(tokenArray[0], (List)((Object)serializable), 1113, null);
                    }
                    mIBObject = mIBObject.getClone();
                    mIBObject.setName(string + "." + mIBObject.getName());
                }
                this.smiRep.addKnownObject(mIBObject);
                continue;
            }
            if (SMI.isKeyWord(string2) || string == null || this.failedImports.contains(string)) continue;
            serializable = new Vector<String>(2);
            ((Vector)serializable).add(string2);
            ((Vector)serializable).add(string);
            this.throwLocalizedError(tokenArray[0].next, (List)((Object)serializable), 1112, null);
        }
        object = new MIBImport(string, vector, var1_1.getComment());
        this.currentModule.addImport((MIBImport)object);
        this.smiRep.createOids(this.currentModule.getModuleName());
        return string;
    }

    protected void checkAgentCaps(MIBAgentCaps ac) throws SMIParseException {
        Enumeration<MIBSupportedModule> enumeration = ac.getModules().elements();
        while (enumeration.hasMoreElements()) {
            MIBSupportedModule mIBSupportedModule = enumeration.nextElement();
            Enumeration enumeration2 = mIBSupportedModule.getVariationsVector().elements();
            while (enumeration2.hasMoreElements()) {
                MIBVariation mIBVariation = (MIBVariation)enumeration2.nextElement();
                this.smiRep.checkUnresolvedObject(new StringToken(mIBVariation.getVariation(), null), null);
                MIBVariation mIBVariation2 = mIBVariation;
                this.checkVariation(mIBSupportedModule.getSupports(), mIBVariation2, (Token)mIBVariation2.getUserObject());
            }
        }
    }

    protected void readAgentCaps(SMIAgentCapabilities node) throws SMIParseException {
        Object object;
        Object object2 = (MIBAgentCaps)this.currentObject;
        if (object2 == null) {
            return;
        }
        ((MIBAgentCaps)object2).setProductRelease(node.productRelease);
        object = ((SMIAgentCapabilities)object).acModules;
        ((MIBAgentCaps)object2).setModules((Vector<MIBSupportedModule>)object);
        object = ((Vector)object).elements();
        while (object.hasMoreElements()) {
            Object object3;
            object2 = (MIBSupportedModule)object.nextElement();
            if (!this.smiRep.isModuleAlreadyImported(((MIBSupportedModule)object2).getSupports()) && !this.smiRep.importModule(((MIBSupportedModule)object2).getSupports(), this.rep, true)) {
                this.throwLocalizedError((Token)((MIBSupportedModule)object2).getUserObject(), new Vector<String>(Arrays.asList(((MIBSupportedModule)object2).getSupports())), 1100, this.getTokenSUPPORTS(), ((MIBSupportedModule)object2).getSupports());
            }
            for (int i2 = 0; i2 < ((MIBSupportedModule)object2).getIncludes().size(); ++i2) {
                object3 = (StringToken)((MIBSupportedModule)object2).getIncludes().get(i2);
                ((MIBSupportedModule)object2).getIncludes().set(i2, ((StringToken)object3).string);
                Class<MIBGroup> clazz = MIBGroup.class;
                this.smiRep.checkUnresolvedObject((StringToken)object3, clazz);
            }
            Enumeration enumeration = ((MIBSupportedModule)object2).getVariationsVector().elements();
            while (enumeration.hasMoreElements()) {
                object3 = (MIBVariation)enumeration.nextElement();
                this.smiRep.checkUnresolvedObject(new StringToken(((MIBVariation)object3).getVariation(), null), null);
                for (int i3 = 0; i3 < ((MIBVariation)object3).getCreationRequiresVector().size(); ++i3) {
                    object2 = (StringToken)((MIBVariation)object3).getCreationRequiresVector().get(i3);
                    ((MIBVariation)object3).getCreationRequiresVector().set(i3, ((StringToken)object2).string);
                    Class<MIBObjectType> clazz = MIBObjectType.class;
                    this.smiRep.checkUnresolvedObject((StringToken)object2, clazz);
                }
            }
        }
    }

    protected void readCompliance(SMICompliance node) throws SMIParseException {
        if (!(this.currentObject instanceof MIBCompliance)) {
            return;
        }
        Object object2 = (MIBCompliance)this.currentObject;
        ((MIBCompliance)object2).setModules(node.modules);
        if (node.modules != null) {
            Iterator<E> iterator;
            for (Object object2 : ((SMICompliance)((Object)iterator)).modules) {
                if (!(object2 instanceof MIBComplianceModule)) continue;
                object2 = (MIBComplianceModule)object2;
                if ((object2 = ((MIBComplianceModule)object2).getModuleName()) == null || ((String)object2).trim().length() <= 0 || this.smiRep.isModuleAlreadyImported((String)object2)) continue;
                this.smiRep.importModule((String)object2, this.rep, true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visit(SimpleNode node, Object data) throws SMIParseException {
        void var2_2;
        void var1_1;
        this.healBrokenNodeStructure(node, data);
        if (this.currentModuleInfo != null || node.getId() == -4 || node.getId() == -29) {
            switch (node.getId()) {
                case -5: {
                    this.currentFile = ((SMIFile)node).getName();
                    break;
                }
                case -4: {
                    if (this.currentModuleInfo != null) break;
                    this.smiRep.setScope(((SMIMib)node).getName(), this);
                    this.currentModuleInfo = this.readModule((SMIMib)node);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    break;
                }
                case -29: {
                    this.smiRep.setScope(((PIBMib)node).getName(), this);
                    this.currentModuleInfo = this.readModule((PIBMib)node);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    break;
                }
                case -3: {
                    this.readModuleIdentity((SMIModule)node);
                    break;
                }
                case -30: {
                    this.readPibModuleIdentity((PIBModule)node);
                    break;
                }
                case -1: {
                    this.currentSyntax = null;
                    if (((SMIObject)node).getType() == 11) break;
                    try {
                        this.readObject((SMIObject)node);
                    }
                    catch (SMIParseException sMIParseException) {
                        this.error(sMIParseException);
                    }
                    break;
                }
                case -16: {
                    this.readObjectType((SMIObjectType)node);
                    break;
                }
                case -31: {
                    this.readPibObjectType((PIBObjectType)node);
                    break;
                }
                case -15: {
                    this.readNotifyType((SMINotifyType)node);
                    break;
                }
                case -12: {
                    break;
                }
                case -20: {
                    this.readSeqEntries((SMISeqEntries)node);
                    break;
                }
                case -7: {
                    if (this.currentObject == null) break;
                    SMIDescription sMIDescription = (SMIDescription)node;
                    if (sMIDescription.alreadyAssigned) break;
                    this.currentObject.setDescription(sMIDescription.getValue());
                    break;
                }
                case -24: {
                    if (this.currentObject == null) break;
                    this.currentObject.setReference(node.toString());
                    break;
                }
                case -19: {
                    this.readRevision((SMIRevision)node);
                    break;
                }
                case -8: {
                    if (!(this.currentObject instanceof MIBObjectType)) break;
                    MIBObjectType mIBObjectType = (MIBObjectType)this.currentObject;
                    mIBObjectType.setDefaultValue(((SMIDefaultValue)node).getDefaultValue().string);
                    if (!mIBObjectType.hasDefaultValue() || mIBObjectType.getSyntax() == null || mIBObjectType.getDefaultValue().indexOf("{") >= 0 || !mIBObjectType.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[2])) break;
                    this.smiRep.checkUnresolvedObject(((SMIDefaultValue)node).getDefaultValue(), MIBObject.class);
                    break;
                }
                case -21: {
                    this.readSyntax((SMISyntax)node);
                    break;
                }
                case -23: {
                    this.readVariable(new StringToken(node.toString(), node.getToken()));
                    break;
                }
                case -14: {
                    this.readIndex((SMIIndex)node);
                    break;
                }
                case -22: {
                    MIBTextualConvention mIBTextualConvention = (MIBTextualConvention)this.currentObject;
                    SMITextualConvention sMITextualConvention = (SMITextualConvention)node;
                    mIBTextualConvention.setDisplayHint(sMITextualConvention.getDisplayHint());
                    mIBTextualConvention.setSyntax(sMITextualConvention.syntax);
                    this.currentSyntax = sMITextualConvention.syntax;
                    this.checkSyntax(new StringToken(mIBTextualConvention.getName(), (Token)mIBTextualConvention.userObject), (StringToken)this.currentSyntax.userObject);
                    switch (this.currentSyntax.getType()) {
                        case 2: 
                        case 3: {
                            SMI2Java sMI2Java = this;
                            this.smiRep.checkUnresolvedSyntax(sMI2Java.getStringToken(sMI2Java.currentSyntax));
                        }
                    }
                    this.smiRep.replaceKnownObject(mIBTextualConvention.getName(), mIBTextualConvention);
                    break;
                }
                case -9: {
                    this.readAgentCaps((SMIAgentCapabilities)node);
                    break;
                }
                case -11: {
                    this.readCompliance((SMICompliance)node);
                }
            }
        }
        node.childrenAccept(this, data);
        if (var1_1.getId() == -4) {
            this.checkModule();
            this.currentModuleInfo = null;
        }
        return var2_2;
    }

    protected void healBrokenNodeStructure(SimpleNode node, Object data) throws SMIParseException {
        if (this.currentModuleInfo == null && node.getId() != 0 && node.getId() != -4 && node.getId() != -29 && node.getId() != -5 && node.children != null) {
            Node[] nodeArray;
            nodeArray = nodeArray.children;
            int n2 = nodeArray.children.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node2 = nodeArray[i2];
                if (!(node2 instanceof SimpleNode)) continue;
                if (((SimpleNode)(node2 = (SimpleNode)node2)).getId() == -4) {
                    this.smiRep.setScope(((SMIMib)node2).getName(), this);
                    this.currentModuleInfo = this.readModule((SMIMib)node2);
                    ((Vector)data).addElement(this.currentModuleInfo);
                    continue;
                }
                if (((SimpleNode)node2).getId() != -29) continue;
                this.smiRep.setScope(((PIBMib)node2).getName(), this);
                this.currentModuleInfo = this.readModule((PIBMib)node2);
                ((Vector)data).addElement(this.currentModuleInfo);
                return;
            }
        }
    }

    public void checkModule() throws SMIParseException {
        int n2;
        Object object;
        Object object2;
        Iterator iterator;
        this.smiRep.resolveNames();
        this.smiRep.resolveSyntaxes();
        if (this.smiRep.existsUnresolvedNames()) {
            this.checkUnresolvedNames();
        }
        this.smiRep.resolveSyntaxes();
        if (this.smiRep.existsUnresolvedSyntaxes()) {
            iterator = this.smiRep.getUnresolvedSyntaxes();
            while (iterator.hasNext()) {
                object2 = (Object[])iterator.next();
                object = (StringToken)object2.getKey();
                if (((StringToken)object).token == null) {
                    this.error(new SMIParseException(((StringToken)object).string, 1500, new Vector<Object>(Arrays.asList(((StringToken)object).string))));
                    continue;
                }
                this.throwLocalizedError(((StringToken)object).token, 1500);
            }
        }
        if (this.smiRep.existsWrongTypes()) {
            iterator = this.smiRep.getWrongTypes();
            while (iterator.hasNext()) {
                object2 = (Object[])iterator.next();
                this.throwLocalizedError(((StringToken)object2[0]).token, new Vector<Object>(Arrays.asList(object2)), 1700, null);
            }
        }
        if ((n2 = this.currentModule.getSMIVersion()) != 1) {
            this.rep.structureChanged();
            this.checkAccess();
        }
        SMI2Java sMI2Java = this;
        object2 = sMI2Java.buildImportHash(sMI2Java.currentModule);
        object = this.rep.objectsByName();
        while (object.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)object.nextElement();
            if (this.currentModule != null && !mIBObject.getModuleID().equals(this.currentModule.getModuleID())) continue;
            SMI2Java sMI2Java2 = this;
            sMI2Java2.checkImports(sMI2Java2.currentModule, mIBObject, (Hashtable)object2);
            if (n2 == 1) continue;
            this.checkGroups(mIBObject);
            this.recheckObject(mIBObject);
        }
        ++this.moduleCount;
    }

    public void recheckObject(MIBObject o2) throws SMIParseException {
        MIBObject mIBObject;
        if (o2 instanceof MIBObjectType) {
            Object object;
            mIBObject = (MIBObjectType)o2;
            if (((MIBObjectType)mIBObject).hasIndexPart()) {
                this.checkWhetherIndexIsPositive((MIBObjectType)mIBObject);
            }
            if (!((MIBObjectType)mIBObject).isTable() && ((MIBObjectType)mIBObject).getSyntax() != null && ((MIBObjectType)mIBObject).getSyntax().getType() == 3) {
                this.checkRestrictedSyntax((Token)((MIBObjectType)mIBObject).userObject, mIBObject.getName(), ((MIBObjectType)mIBObject).getSyntax(), this.getTokenSYNTAX());
            }
            this.checkDefaultValue((MIBObjectType)mIBObject);
            if (mIBObject instanceof com.agentpp.mib.pib.PIBObjectType) {
                Vector<String> vector;
                MIBObject mIBObject2;
                com.agentpp.mib.pib.PIBObjectType pIBObjectType = (com.agentpp.mib.pib.PIBObjectType)mIBObject;
                object = this;
                if (pIBObjectType.getSyntax() != null && PIB_TAG_REFERENCE_ID.equals(pIBObjectType.getSyntax().getSyntax()) && pIBObjectType.getTag() != null) {
                    mIBObject2 = ((SMI2Java)object).rep.getObject(pIBObjectType.getTag());
                    vector = new Vector<String>(2);
                    vector.add(pIBObjectType.getName());
                    vector.add(pIBObjectType.getTag());
                    if (mIBObject2 == null) {
                        ((SMI2Java)object).throwLocalizedError((Token)pIBObjectType.userObject, vector, 1501, ((SMI2Java)object).getTokenPIBTAG(), pIBObjectType.getTag());
                    } else if (!(mIBObject2 instanceof MIBObjectType) || ((MIBObjectType)mIBObject2).getSyntax() == null || !PIB_TAG_ID.equals(((MIBObjectType)mIBObject2).getSyntax().getSyntax())) {
                        if (mIBObject2 instanceof MIBObjectType) {
                            ((SMI2Java)object).throwLocalizedError(pIBObjectType, new Vector<String>(Arrays.asList(pIBObjectType.getPibReferences(), PIB_TAG_ID, ((MIBObjectType)mIBObject2).getSyntax() != null ? ((MIBObjectType)mIBObject2).getSyntax().getSyntax() : "''")), 1700, ((SMI2Java)object).getTokenPIBTAG(), 0);
                        } else {
                            ((SMI2Java)object).throwLocalizedError(pIBObjectType, new Vector<String>(Arrays.asList(pIBObjectType.getPibReferences(), mIBObject2.getTypeString())), 1602, ((SMI2Java)object).getTokenPIBTAG(), 0);
                        }
                    }
                }
                if (pIBObjectType.getSyntax() != null && PIB_REFERENCE_ID.equals(pIBObjectType.getSyntax().getSyntax()) && pIBObjectType.getPibReferences() != null) {
                    mIBObject2 = ((SMI2Java)object).rep.getObject(pIBObjectType.getPibReferences());
                    if (mIBObject2 == null) {
                        mIBObject2 = ((SMI2Java)object).smiRep.getKnownObject(pIBObjectType.getPibReferences());
                    }
                    vector = new Vector<String>(2);
                    vector.add(pIBObjectType.getName());
                    vector.add(pIBObjectType.getPibReferences());
                    if (mIBObject2 == null) {
                        ((SMI2Java)object).throwLocalizedError((Token)pIBObjectType.userObject, vector, 1501, ((SMI2Java)object).getTokenPIBREFERENCES(), ((SMI2Java)object).getTokenPIBREFERENCES());
                    } else if (!(mIBObject2 instanceof MIBObjectType) || !((MIBObjectType)mIBObject2).isTable()) {
                        ((SMI2Java)object).throwLocalizedError(pIBObjectType, new Vector<String>(Arrays.asList(pIBObjectType.getPibReferences(), "OBJECT-TYPE (Entry)", mIBObject2.getTypeString())), 1700, ((SMI2Java)object).getTokenPIBREFERENCES(), 0);
                    }
                }
            }
            if (((MIBObjectType)mIBObject).getSyntax() != null && (object = ((MIBObjectType)mIBObject).getSyntax().userObject) instanceof StringToken) {
                this.a(((StringToken)object).token, ((MIBObjectType)mIBObject).getSyntax());
            }
            return;
        }
        if (mIBObject instanceof MIBAgentCaps) {
            this.checkAgentCaps((MIBAgentCaps)mIBObject);
            return;
        }
        if (mIBObject instanceof MIBCompliance) {
            this.checkCompliance((MIBCompliance)mIBObject);
            return;
        }
        if (mIBObject instanceof MIBTextualConvention) {
            Object object;
            mIBObject = (MIBTextualConvention)mIBObject;
            this.checkDisplayHint((MIBTextualConvention)mIBObject);
            if (((MIBTextualConvention)mIBObject).getSyntax() != null && (object = ((MIBTextualConvention)mIBObject).getSyntax().userObject) instanceof StringToken) {
                this.a(((StringToken)object).token, ((MIBTextualConvention)mIBObject).getSyntax());
            }
        }
    }

    private void a(Token token, MIBSyntax object) throws SMIParseException {
        MIBTextualConvention mIBTextualConvention = this.smiRep.scope.rep.getEffectiveSyntax((MIBSyntax)object);
        boolean bl = SMI.isUnsignedNumeric(mIBTextualConvention.getSyntax().getSyntax());
        if (bl && ((MIBSyntax)object).hasRanges()) {
            object = ((MIBSyntax)object).getRangesVector();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (MIBRange)object.next();
                if (((MIBRange)object2).getLowerValue() >= 0L) continue;
                object2 = Arrays.asList("boundary " + ((MIBRange)object2).getLowerValue() + " is negative although SYNTAX '" + mIBTextualConvention.getSyntax().getSyntax() + "' is unsigned");
                this.throwLocalizedError(token, (List)object2, 4010, this.getTokenRANGE(), null);
            }
        }
    }

    protected void checkCompliance(MIBCompliance mc) throws SMIParseException {
        if (mc.getModules() != null) {
            Iterator iterator = mc.getModules().iterator();
            while (iterator.hasNext()) {
                MIBModule mIBModule;
                Object object;
                Object object2;
                MIBModule mIBModule2 = this.rep.getModule(mc.getModuleID());
                MIBComplianceModule mIBComplianceModule = (MIBComplianceModule)iterator.next();
                if (mIBComplianceModule.getModuleName() != null && !mIBComplianceModule.getModuleName().equals(mIBModule2.getModuleName())) {
                    mIBModule2 = this.smiRep.scope.rep.getModule(mIBComplianceModule.getModuleName());
                }
                if (mIBModule2 == null) {
                    this.throwLocalizedError((Token)mIBComplianceModule.getUserObject(), new Vector<String>(Arrays.asList(mIBComplianceModule.getModuleName())), 1100, -1, 0);
                    continue;
                }
                if (mIBComplianceModule.hasMandatory()) {
                    for (Object object3 : mIBComplianceModule.getMandatoryVector()) {
                        object2 = mIBModule2.getObjectByName((String)object3);
                        if (object2 == null) {
                            object = this.currentModule.getImportSource((String)object3);
                            if (object != null) {
                                mIBModule = this.smiRep.scope.rep.getModule((String)object);
                                if (mIBModule != null) {
                                    object2 = mIBModule.getObjectByName((String)object3);
                                }
                            } else {
                                this.throwLocalizedError((Token)mc.userObject, new Vector<String>(Arrays.asList(object3)), 1502, this.getTokenMANDATORYGROUPS(), (String)object3);
                            }
                        }
                        if (object2 instanceof MIBGroup) continue;
                        this.throwLocalizedError((Token)mc.userObject, new Vector<String>(Arrays.asList(object3, object2 == null ? "unknown" : ((MIBObject)object2).getTypeString())), 1601, this.getTokenMANDATORYGROUPS(), (String)object3);
                    }
                }
                mIBModule = mIBModule2;
                if (!mIBComplianceModule.hasVariations()) continue;
                for (Object object3 : mIBComplianceModule.getVariationsVector()) {
                    if (object3 instanceof MIBCondGroup) {
                        object2 = mIBModule2.getObjectByName(((MIBVariation)object3).getVariation());
                        if (object2 == null) {
                            object = this.currentModule.getImportSource(((MIBVariation)object3).getVariation());
                            if (object != null) {
                                mIBModule = this.smiRep.scope.rep.getModule((String)object);
                                if (mIBModule != null) {
                                    object2 = mIBModule.getObjectByName(((MIBVariation)object3).getVariation());
                                }
                            } else {
                                this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation())), 1502, -1, 0);
                            }
                        }
                        if (!(object2 instanceof MIBGroup)) {
                            this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation(), object2 == null ? "unknown" : ((MIBObject)object2).getTypeString())), 1601, -1, 0);
                        }
                        if (!mIBComplianceModule.hasMandatory() || !mIBComplianceModule.getMandatoryVector().contains(((MIBVariation)object3).getVariation())) continue;
                        this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation(), object2 == null ? "unknown" : ((MIBObject)object2).getTypeString())), 1210, -1, 0);
                        continue;
                    }
                    object2 = mIBModule2.getObjectByName(((MIBVariation)object3).getVariation());
                    if (object2 == null) {
                        object = this.currentModule.getImportSource(((MIBVariation)object3).getVariation());
                        if (object != null) {
                            mIBModule = this.smiRep.scope.rep.getModule((String)object);
                            if (mIBModule != null) {
                                mIBModule.getObjectByName(((MIBVariation)object3).getVariation());
                            }
                        } else {
                            this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation())), 1502, -1, 0);
                        }
                    }
                    object2 = mIBComplianceModule.getModuleName();
                    object = this.rep;
                    if (mIBModule != this.currentModule) {
                        object = this.smiRep.scope.rep;
                    }
                    if (!((MIBRepository)object).isReferencedBy(((MIBVariation)object3).getVariation(), mIBModule, mIBComplianceModule)) {
                        this.throwLocalizedError((Token)((MIBVariation)object3).getUserObject(), new Vector<String>(Arrays.asList(((MIBVariation)object3).getVariation())), 1211, -1, 0);
                    } else {
                        Object object4 = object3;
                        this.checkVariation((String)object2, (MIBVariation)object4, (Token)((MIBVariation)object4).getUserObject());
                    }
                    mIBModule = mIBModule2;
                }
            }
        }
    }

    protected final int getTokenOBJECT() {
        return 88;
    }

    protected final int getTokenMANDATORYGROUPS() {
        return 85;
    }

    protected final int getTokenGROUP() {
        return 87;
    }

    protected final int getTokenPIBTAG() {
        return 110;
    }

    protected final int getTokenPIBINDEX() {
        return 105;
    }

    protected final int getTokenPIBREFERENCES() {
        return 109;
    }

    protected final int getTokenUNIQENESS() {
        return 112;
    }

    protected final int getTokenINSTALLERRORS() {
        return 108;
    }

    protected final int getTokenRANGE() {
        return 77;
    }

    protected void checkAccess() throws SMIParseException {
        if ((this.options & 8) > 0) {
            return;
        }
        Enumeration<? extends MIBObject> enumeration = this.rep.objects();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            String string;
            Object object;
            MIBObject mIBObject;
            MIBObject mIBObject2 = enumeration.nextElement();
            if (mIBObject2 instanceof MIBObjectType) {
                mIBObject = (MIBObjectType)mIBObject2;
                if (!((MIBObjectType)mIBObject).isTable() || mIBObject2 instanceof com.agentpp.mib.pib.PIBObjectType) continue;
                object = this.rep.getColumnarObjectsOfTable((MIBObjectType)mIBObject, false, true);
                boolean bl = false;
                string = null;
                for (int i2 = 0; i2 < ((Vector)object).size(); ++i2) {
                    serializable = ((Vector)object).get(i2);
                    if (((MIBObjectType)serializable).getAccess() == null && serializable instanceof com.agentpp.mib.pib.PIBObjectType) continue;
                    if (((MIBObjectType)serializable).getAccess().equals(SMI.ACCESS[3])) {
                        bl = true;
                    } else if (((MIBObjectType)serializable).getAccess().equals(SMI.ACCESS[2])) {
                        string = ((MIBObject)serializable).getName();
                    }
                    if (!bl || string == null) continue;
                    if (((MIBObjectType)serializable).userObject != null && ((MIBObjectType)serializable).userObject instanceof Token) {
                        this.throwLocalizedError(mIBObject, new Vector(), 1202, this.currentSMIVersion == 1 ? 59 : 58, 1);
                        continue;
                    }
                    this.error(new SMIParseException(string, 1202));
                }
                continue;
            }
            if (!(mIBObject2 instanceof MIBNotifyType) || !((MIBNotifyType)(mIBObject = (MIBNotifyType)mIBObject2)).hasVariables()) continue;
            object = ((MIBNotifyType)mIBObject).getVariablesVector();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                MIBObject mIBObject3 = this.rep.getObject(string);
                if (!(mIBObject3 instanceof MIBObjectType) || !SMI.isNotAccessible(((MIBObjectType)mIBObject3).getAccess())) continue;
                serializable = (Token)mIBObject2.userObject;
                object = this.objectLists.get(mIBObject.getName() + " " + string);
                if (object != null) {
                    serializable = ((StringToken)object).token;
                }
                Serializable serializable2 = serializable;
                object = new SemanticError(5101, ((Token)serializable).beginLine, ((Token)serializable).beginColumn, ((Token)serializable).endPos, (Token)serializable2, ((Token)serializable2).image, mIBObject.getName(), new String[]{string});
                this.error(new SMIParseException((FileError)object, 5101));
            }
        }
    }

    protected void checkSequence(MIBObjectType ot) throws SMIParseException {
        if (ot.isTable() && ot.getOid() != null && ot.getOid().isValid()) {
            int n2;
            Vector vector = ot.getTableEntriesVector();
            Vector<? extends MIBObjectType> vector2 = this.rep.getColumnarObjectsOfTable(ot, true, true);
            if (vector2 == null) {
                vector2 = this.smiRep.scope.rep.getColumnarObjectsOfTable(this.currentModule, ot, true, false);
                if (vector2 == null) {
                    Token token = (Token)ot.userObject;
                    Vector<String> vector3 = new Vector<String>(vector.subList(0, 1));
                    vector3.insertElementAt(ot.getName(), 0);
                    this.error(new SMIParseException(new SemanticError(1800, token.beginLine, token.beginColumn, token.endPos, token, ot.getName(), token.image, new String[0]), 1800, vector3));
                    return;
                }
                vector2.addAll(this.rep.getColumnarObjectsOfTable(ot, false, true));
            }
            Collections.sort(vector2);
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                vector2.set(n2, (MIBObjectType)((Object)((MIBObject)vector2.get(n2)).getName()));
            }
            n2 = -1;
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                int n3 = vector2.indexOf(vector.get(i2));
                if (n3 <= n2) {
                    Vector<String> vector4 = new Vector<String>(2);
                    vector4.add(ot.getName());
                    vector4.add((String)vector.get(i2));
                    Serializable serializable = (Vector)this.nameSequences.get(vector);
                    if (serializable != null) {
                        serializable = ((StringToken)((Pair)serializable.get((int)i2)).first).token;
                        this.throwLocalizedError((Token)serializable, vector4, 1800, null);
                        continue;
                    }
                    serializable = (Token)ot.userObject;
                    this.error(new SMIParseException(new SemanticError(1800, ((Token)serializable).beginLine, ((Token)serializable).beginColumn, ((Token)serializable).endPos, (Token)serializable, ot.getName(), ((Token)serializable).image, new String[0]), 1800, vector4));
                    continue;
                }
                n2 = n3;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkNoDescendant(MIBObject o2) throws SMIParseException {
        Serializable serializable = o2.getOid();
        if (serializable == null) {
            return;
        }
        if (o2.getType() == 0 || o2.getType() == 10 || o2.getType() == 5) {
            return;
        }
        if (o2 instanceof MIBObjectType) {
            String[] stringArray;
            Vector<? extends MIBObject> vector = this.rep.getDescendants(o2);
            serializable = (MIBObjectType)o2;
            MIBObjectType mIBObjectType = this.rep.getTableEntry((MIBObject)serializable);
            if (mIBObjectType != null) {
                if (this.currentSMIVersion != 1 && mIBObjectType != serializable) {
                    try {
                        Object object;
                        if (!(((MIBObject)serializable).getOid().equals(mIBObjectType.getOid().trim()) && mIBObjectType.getOid().getLastSubID() == 1L || SMI.STATUS[3].equals(((MIBObject)(object = mIBObjectType)).getStatus()))) {
                            Token serializable2 = (Token)((MIBObject)object).userObject;
                            stringArray = new String[]{o2.getName(), ((MIBObject)object).getPrintableOid()};
                            this.error(new SMIParseException(new SemanticError(2010, serializable2.beginLine, serializable2.beginColumn, serializable2.endPos, serializable2, ((MIBObject)object).getName(), serializable2.image, stringArray), 2010));
                        }
                    }
                    catch (ObjectIDFormatException objectIDFormatException) {}
                }
                this.checkSequence(mIBObjectType);
                if (mIBObjectType != serializable) {
                    for (int i2 = 0; i2 < vector.size(); ++i2) {
                        MIBObject mIBObject = vector.get(i2);
                        if (mIBObjectType.equals(mIBObject) || mIBObject.getOid().size() == mIBObjectType.getOid().size() + 1 && mIBObject.getOid().trim().equals(mIBObjectType.getOid()) || SMI.STATUS[3].equals(mIBObject.getStatus())) continue;
                        stringArray = (Token)mIBObject.userObject;
                        serializable = new String[]{o2.getName(), mIBObject.getPrintableOid()};
                        this.error(new SMIParseException(new SemanticError(2010, stringArray.beginLine, stringArray.beginColumn, stringArray.endPos, (Token)stringArray, mIBObject.getName(), stringArray.image, (String[])serializable), 2010));
                    }
                }
            }
            for (MIBObject mIBObject : vector) {
                if (mIBObject instanceof MIBObjectType || SMI.ENTRY_TYPES[10].equals(mIBObject.getTypeString()) || SMI.STATUS[3].equals(mIBObject.getStatus())) continue;
                stringArray = (String[])mIBObject.userObject;
                serializable = new String[]{o2.getName(), mIBObject.getPrintableOid()};
                this.error(new SMIParseException(new SemanticError(2010, stringArray.beginLine, stringArray.beginColumn, stringArray.endPos, (Token)stringArray, mIBObject.getName(), stringArray.image, (String[])serializable), 2010));
            }
            return;
        }
        MIBObject mIBObject = this.rep.getNextObject((ObjectID)serializable);
        if (mIBObject == null || mIBObject.getOid() == null) {
            return;
        }
        if (((ObjectID)serializable).isRootOf(mIBObject.getOid()) && !SMI.STATUS[3].equals(mIBObject.getStatus())) {
            serializable = new Vector<String>();
            ((Vector)serializable).addElement(mIBObject.getName());
            ((Vector)serializable).addElement(o2.getName());
            ((Vector)serializable).addElement(mIBObject.getPrintableOid());
            if (mIBObject.userObject != null && mIBObject.userObject instanceof Token) {
                void var1_1;
                Token token = (Token)mIBObject.userObject;
                String[] stringArray = new String[]{var1_1.getName(), mIBObject.getPrintableOid()};
                this.error(new SMIParseException(new SemanticError(2010, token.beginLine, token.beginColumn, token.endPos, token, mIBObject.getName(), token.image, stringArray), 2010));
                return;
            }
            this.error(new SMIParseException("Illegal object registration", 2010, (List)((Object)serializable)));
        }
    }

    protected void checkGroups(MIBObject o2) throws SMIParseException {
        block15: {
            Object object;
            block11: {
                block14: {
                    Object object2;
                    MIBObjectType mIBObjectType;
                    block12: {
                        block13: {
                            this.checkNoDescendant(o2);
                            if (!(o2 instanceof MIBObjectType)) break block11;
                            mIBObjectType = (MIBObjectType)o2;
                            if (mIBObjectType.isTable() && mIBObjectType.getOid() != null && mIBObjectType.getOid().isValid() && (this.options & 2) == 0 && this.rep.getChildren(mIBObjectType).size() != mIBObjectType.getTableEntriesVector().size()) {
                                object2 = (Token)mIBObjectType.userObject;
                                this.error(new SMIParseException(new SemanticError(1801, ((Token)object2).beginLine, ((Token)object2).beginColumn, ((Token)object2).endPos, (Token)object2, mIBObjectType.getName(), ((Token)object2).image, new String[0]), 1801));
                            }
                            if (mIBObjectType.isTable() || mIBObjectType.isTableSequence() || o2 instanceof com.agentpp.mib.pib.PIBObjectType || SMI.accessType(mIBObjectType.getAccess()) == 0) break block12;
                            object2 = this.a(mIBObjectType.getName(), 6);
                            if (((Vector)object2).size() != 0 || (this.options & 1) != 0) break block13;
                            if (mIBObjectType.userObject != null && mIBObjectType.userObject instanceof Token) {
                                object = (Token)mIBObjectType.userObject;
                                this.error(new SMIParseException(new SemanticError(5000, ((Token)object).beginLine, ((Token)object).beginColumn, ((Token)object).endPos, (Token)object, mIBObjectType.getName(), ((Token)object).image, new String[0]), 5000));
                            } else {
                                this.error(new SMIParseException(mIBObjectType.getName(), 5000));
                            }
                            break block14;
                        }
                        if ((this.options & 4) != 0) break block15;
                        object = ((Vector)object2).elements();
                        while (object.hasMoreElements()) {
                            this.checkStatus(mIBObjectType, (MIBGroup)object.nextElement());
                        }
                        break block15;
                    }
                    if (!(object instanceof com.agentpp.mib.pib.PIBObjectType) && ((Vector)(object2 = this.a(mIBObjectType.getName(), 6))).size() > 0) {
                        object = (MIBGroup)((Vector)object2).firstElement();
                        Token token = (Token)((MIBGroup)object).userObject;
                        object2 = this.objectLists.get(((MIBObject)object).getName() + " " + mIBObjectType.getName());
                        if (object2 != null) {
                            token = ((StringToken)object2).token;
                        }
                        object2 = new Vector(3);
                        ((Vector)object2).add(((MIBObject)object).getName());
                        ((Vector)object2).add(mIBObjectType.getName());
                        this.error(new SMIParseException(new SemanticError(5100, token.beginLine, token.beginColumn, token.endPos, token, ((MIBObject)object).getName(), token.image, new String[0]), 5100, (List)object2));
                    }
                }
                return;
            }
            if (object instanceof MIBNotifyType) {
                MIBNotifyType mIBNotifyType = (MIBNotifyType)object;
                Vector vector = this.a(mIBNotifyType.getName(), 7);
                if (vector.size() == 0 && (this.options & 1) == 0) {
                    if (mIBNotifyType.userObject != null && mIBNotifyType.userObject instanceof Token) {
                        object = (Token)mIBNotifyType.userObject;
                        this.error(new SMIParseException(new SemanticError(5000, ((Token)object).beginLine, ((Token)object).beginColumn, ((Token)object).endPos, (Token)object, mIBNotifyType.getName(), ((Token)object).image, new String[0]), 5000));
                        return;
                    }
                    this.error(new SMIParseException(mIBNotifyType.getName(), 5000));
                    return;
                }
                if ((this.options & 4) == 0) {
                    object = vector.elements();
                    while (object.hasMoreElements()) {
                        this.checkStatus(mIBNotifyType, (MIBGroup)object.nextElement());
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkStatus(MIBObject o2, MIBGroup g2) throws SMIParseException {
        if (SMI.statusType(o2.getStatus()) < SMI.statusType(g2.getStatus())) {
            void var2_2;
            void var1_1;
            if (o2.userObject != null && o2.userObject instanceof Token) {
                this.throwLocalizedError(o2, new Vector<String>(Arrays.asList(o2.getName(), g2.getName())), 1201, 62, 1);
                return;
            }
            this.error(new SMIParseException(var1_1.getName() + ":" + var2_2.getName(), 1201));
        }
    }

    private Vector a(String string, int n2) {
        Vector<MIBGroup> vector = new Vector<MIBGroup>();
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            MIBGroup mIBGroup = (MIBGroup)enumeration.nextElement();
            if (mIBGroup.getType() != n2 || !mIBGroup.contains(string)) continue;
            vector.addElement(mIBGroup);
        }
        return vector;
    }

    protected void checkUnresolvedNames() throws SMIParseException {
        HashSet<StringToken> hashSet = new HashSet<StringToken>();
        Iterator iterator = this.smiRep.getUnresolvedNames();
        while (iterator.hasNext()) {
            Object object = (List)iterator.next();
            object = object.iterator();
            while (object.hasNext()) {
                Pair pair = (Pair)object.next();
                StringToken[] stringTokenArray = (StringToken[])pair.first;
                StringToken stringToken = null;
                block2: for (int i2 = 0; stringToken == null && i2 < stringTokenArray.length; ++i2) {
                    String string = stringTokenArray[i2].string;
                    for (int i3 = 0; i3 < string.length(); ++i3) {
                        if (Character.isDigit(string.charAt(i3))) continue;
                        stringToken = stringTokenArray[i2];
                        continue block2;
                    }
                }
                if (stringToken == null || stringToken.string.length() <= 0 || hashSet.contains(stringToken)) continue;
                if (stringToken.token == null && pair.second instanceof StringToken) {
                    stringToken.token = ((StringToken)pair.second).token;
                }
                hashSet.add(stringToken);
                Token token = stringToken.token;
                if (token != null) {
                    this.throwLocalizedError(token, 1502);
                    continue;
                }
                this.error(new SMIParseException(stringToken.string, 1501));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setOptions(int options) {
        void var1_1;
        this.options = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setErrors(List errors) {
        void var1_1;
        this.errors = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxErrors(int maxErrors) {
        void var1_1;
        this.maxErrors = var1_1;
    }

    public int getOptions() {
        return this.options;
    }

    public List getErrors() {
        return this.errors;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    protected Hashtable buildImportHash(MIBModule m2) {
        Vector<MIBImport> vector = m2.getImportsVector();
        if (vector == null) {
            return new Hashtable(1);
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>(vector.size() * 5 + 1);
        vector = vector.elements();
        while (vector.hasMoreElements()) {
            MIBImport mIBImport = (MIBImport)vector.nextElement();
            Vector<String> vector2 = mIBImport.getImportsVector();
            if (vector2 == null) continue;
            for (int i2 = 0; i2 < vector2.size(); ++i2) {
                hashtable.put(vector2.elementAt(i2).toString(), mIBImport.getSource());
            }
        }
        return hashtable;
    }

    /*
     * WARNING - void declaration
     */
    public void checkImports(MIBModule m2, MIBObject o2, Hashtable imports) throws SMIParseException {
        MIBObject mIBObject;
        String string;
        if (!o2.getModuleID().equals(m2.getModuleID())) {
            return;
        }
        int n2 = m2.getSMIVersion();
        String string2 = o2.getTypeString();
        if (SMI.ENTRY_TYPES[5].equals(string2) && (o2.getObjectID() == null || o2.getObjectID().size() == 0) || SMI.ENTRY_TYPES[4].equals(string2) && (!((MIBTextualConvention)o2).hasStatus() || SMI.statusType(((MIBTextualConvention)o2).getStatus()) == 0)) {
            return;
        }
        int n3 = SMI.getKeyWordType(n2, string2);
        String string3 = (String)imports.get(string2);
        if (n3 >= 0 && !(string = n2 > 0 ? SMI.smiMIBs[n2 - 1][n3] : SMI.pibMIBs[n2 + 1][n3]).equals(m2.getModuleName())) {
            this.checkImport(string3, string2, o2, true);
            this.checkImport(string3, string, string2, o2, true);
        }
        if (o2 instanceof MIBObjectType) {
            mIBObject = (MIBObjectType)o2;
            if (((MIBObjectType)mIBObject).getSyntax() == null) {
                return;
            }
            string2 = ((MIBObjectType)mIBObject).getSyntax().getSyntax();
        } else if (o2 instanceof MIBTextualConvention) {
            mIBObject = (MIBTextualConvention)o2;
            if (((MIBTextualConvention)mIBObject).getSyntax() == null) {
                return;
            }
            string2 = ((MIBTextualConvention)mIBObject).getSyntax().getSyntax();
        } else {
            return;
        }
        int n4 = SMI.getKeyWordType(n2, string2);
        if (n4 >= 0) {
            void var1_1;
            void var3_3;
            string3 = (String)var3_3.get(string2);
            String string4 = n2 > 0 ? SMI.smiMIBs[n2 - 1][n4] : SMI.pibMIBs[n2 + 1][n4];
            if (!string4.equals(var1_1.getModuleName())) {
                void var2_2;
                this.checkImport(string3, string2, o2, false);
                this.checkImport(string3, string4, string2, (MIBObject)var2_2, false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkImport(String source, String o2, MIBObject mo, boolean checkForSmiObject) throws SMIParseException {
        if (source == null) {
            StringToken stringToken;
            Vector<String> vector = new Vector<String>(1);
            vector.add(o2);
            stringToken = this.smiRep.getUnresolvedSyntax((String)((Object)stringToken));
            if (stringToken == null && mo != null && mo.userObject instanceof Token) {
                this.throwLocalizedError(mo, vector, 1111, checkForSmiObject ? ((Token)mo.userObject).kind : this.getTokenSYNTAX(), checkForSmiObject && mo instanceof MIBTextualConvention ? 2 : 1, 0);
                return;
            }
            if (stringToken != null) {
                this.throwLocalizedError(stringToken.token, 1111);
                return;
            }
            if (mo != null) {
                void var3_3;
                this.error(new SMIParseException(var3_3.getName(), 1111, vector));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkImport(String source, String expectedSource, String o2, MIBObject ot, boolean checkForSmiObject) throws SMIParseException {
        if (!expectedSource.equals(source) && source != null) {
            void var2_2;
            void var1_1;
            void var3_3;
            Vector<void> vector = new Vector<void>(3);
            vector.add(var3_3);
            vector.add(var1_1);
            vector.add(var2_2);
            this.throwLocalizedError(ot, vector, 1110, checkForSmiObject ? ((Token)ot.userObject).kind : this.getTokenSYNTAX(), checkForSmiObject && ot instanceof MIBTextualConvention ? 2 : 1, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(SMIParseException parseException) throws SMIParseException {
        void var1_1;
        boolean bl = SMIParseException.addUniqueException(this.errors, (Exception)var1_1);
        if (bl && this.errors.size() >= this.maxErrors) {
            SMIParseException sMIParseException = (SMIParseException)this.errors.get(0);
            sMIParseException.setErrorList(this.errors);
            throw sMIParseException;
        }
    }
}

