/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import java.util.Arrays;
import java.util.StringTokenizer;

public class SMI {
    public static final String LINE_SEPARATOR = "\n";
    public static final String ALL_LINE_SEPARATORS = "\r\n";
    public static final int SUPPORTED_OBJECT_TYPES = 6;
    public static final int STANDARD = 1;
    public static final int HTML = 2;
    public static final int HTML_LINKED = 4;
    public static final int TO_SMI_V2 = 8;
    public static final int TO_SMI_V1 = 16;
    public static final int WITH_COMMENTS = 32;
    public static final int OMIT_OBJECTS = 64;
    public static final int PRESERVED_ORDER = 128;
    public static final int GROUPING_BY_TYPE = 256;
    public static final int NAVIGATION_LINKS = 512;
    public static final int INLINE_COMMENTS = 1024;
    public static final int ACC_NOACCESS = 0;
    public static final int ACC_READONLY = 1;
    public static final int ACC_READWRITE = 2;
    public static final int ACC_READCREATE = 3;
    public static final int ACC_WRITEONLY = 4;
    public static final int ACC_ACCESSIBLE_FOR_NOTIFY = 5;
    public static final int ACC_NOT_IMPLEMENTED = 6;
    public static final String[] ACCESS = new String[]{"not-accessible", "read-only", "read-write", "read-create", "write-only", "accessible-for-notify", "not-implemented"};
    public static final String[] PIB_ACCESS = new String[]{"install", "notify", "install-notify", "report-only"};
    public static final int[] SMIv1_ACCESS = new int[]{0, 1, 2, 4};
    public static final int STA_UNDEFINED = 0;
    public static final int STA_MANDATORY = 1;
    public static final int STA_OPTIONAL = 2;
    public static final int STA_OBSOLETE = 3;
    public static final int STA_DEPRECATED = 4;
    public static final int STA_CURRENT = 5;
    public static final int SYN_SIMPLE = 0;
    public static final int SYN_APPLICATION = 1;
    public static final int SYN_SEQUENCE = 2;
    public static final int SYN_CONVENTION = 3;
    public static final int OBJECT_IDENTITY = 0;
    public static final int OBJECT_TYPE = 1;
    public static final int TRAP_TYPE = 2;
    public static final int NOTIFICATION_TYPE = 3;
    public static final int TEXTUAL_CONVENTION = 4;
    public static final int MODULE_IDENTITY = 5;
    public static final int OBJECT_GROUP = 6;
    public static final int NOTIFICATION_GROUP = 7;
    public static final int MODULE_COMPLIANCE = 8;
    public static final int AGENT_CAPABILITIES = 9;
    public static final int OBJECT_NAME = 10;
    public static final int SEQUENCE = 11;
    public static final String[] smiv2MIBs = new String[]{"SNMPv2-SMI", "SNMPv2-TC", "SNMPv2-CONF"};
    public static final String[] smiv1MIBs = new String[]{"RFC1155-SMI", "RFC-1212", "RFC-1215"};
    public static final String[][] pibMIBs = new String[][]{{"COPS-PR-SPPI", "COPS-PR-SPPI-TC"}};
    public static final String[][] smiMIBs = new String[][]{smiv1MIBs, smiv2MIBs};
    public static final String[][] smiv2Constructs = new String[][]{{"MODULE-IDENTITY", "OBJECT-IDENTITY", "OBJECT-TYPE", "NOTIFICATION-TYPE", "Counter32", "Counter64", "Gauge32", "Integer32", "IpAddress", "Opaque", "TimeTicks", "Unsigned32"}, {"TEXTUAL-CONVENTION"}, {"OBJECT-GROUP", "NOTIFICATION-GROUP", "MODULE-COMPLIANCE", "AGENT-CAPABILITIES"}};
    public static final String[][][] pibConstructs = new String[][][]{{{"MODULE-IDENTITY", "OBJECT-IDENTITY", "OBJECT-TYPE", "NOTIFICATION-TYPE", "Integer32", "IpAddress", "Opaque", "TimeTicks", "Unsigned32", "Integer64", "Unsigned64", "TEXTUAL-CONVENTION", "OBJECT-GROUP", "MODULE-COMPLIANCE"}, {"InstanceId", "ReferenceId", "Prid", "TagId", "TagReferenceId"}}};
    public static final String[][] smiv1Constructs = new String[][]{{"OBJECT-IDENTITY", "Counter", "Gauge", "IpAddress", "Opaque", "TimeTicks", "NetworkAddress"}, {"OBJECT-TYPE"}, {"TRAP-TYPE"}};
    public static final String[][][] smiConstructs = new String[][][]{smiv1Constructs, smiv2Constructs};
    public static final String[] asn1Constructs = new String[]{"INTEGER", "OCTET STRING", "BITS"};
    public static final String[] STATUS = new String[]{"undefined", "mandatory", "optional", "obsolete", "deprecated", "current"};
    public static final String[][] rootOids = new String[][]{{"iso", "1"}, {"ccitt", "0"}, {"joint-iso-ccitt", "2"}, {"org", "1.3"}, {"dod", "1.3.6"}, {"internet", "1.3.6.1"}, {"mgmt", "1.3.6.1.2"}, {"mib-2", "1.3.6.1.2.1"}, {"mib", "1.3.6.1.2.1"}, {"experimental", "1.3.6.1.3"}, {"private", "1.3.6.1.4"}, {"enterprises", "1.3.6.1.4.1"}};
    public static final String[] ENTRY_TYPES = new String[]{"OBJECT-IDENTITY", "OBJECT-TYPE", "TRAP-TYPE", "NOTIFICATION-TYPE", "TEXTUAL-CONVENTION", "MODULE-IDENTITY", "OBJECT-GROUP", "NOTIFICATION-GROUP", "MODULE-COMPLIANCE", "AGENT-CAPABILITIES", "OBJECT IDENTIFIER"};
    public static final String[] SYNTAX_TYPES = new String[]{"simple", "application", "sequence", "textual convention"};
    public static final String[] BASIC_SYNTAX = new String[]{"Integer", "String", "Hex String", "Object ID", "Null", "IpAddress", "Counter", "Counter64", "Gauge", "TimeTicks", "Opaque"};
    public static final int SYN_NUMBER = 0;
    public static final int SYN_STRING = 1;
    public static final int SYN_HEXSTRING = 2;
    public static final int SYN_OBJECT = 3;
    public static final int SYN_EMPTY = 4;
    public static final int SYN_IPADDRESS = 5;
    public static final int SYN_COUNTER = 6;
    public static final int SYN_COUNTER64 = 7;
    public static final int SYN_GAUGE = 8;
    public static final int SYN_TIMETICKS = 9;
    public static final int SYN_OPAQUE = 10;
    public static final int SYN_NULL = 11;
    public static final int SYN_NETADDRESS = 12;
    public static final String[] SMI_SYNTAX = new String[]{"INTEGER", "OCTET STRING", "OBJECT IDENTIFIER", "Counter", "Gauge", "Counter32", "Counter64", "Gauge32", "Integer32", "IpAddress", "Opaque", "TimeTicks", "BITS", "Unsigned32", "NULL", "NetworkAddress"};
    public static final int SMI_INTEGER = 0;
    public static final int SMI_OCTETSTRING = 1;
    public static final int SMI_OID = 2;
    public static final int SMI_COUNTER = 3;
    public static final int SMI_GAUGE = 4;
    public static final int SMI_COUNTER32 = 5;
    public static final int SMI_COUNTER64 = 6;
    public static final int SMI_GAUGE32 = 7;
    public static final int SMI_INTEGER32 = 8;
    public static final int SMI_IPADDRESS = 9;
    public static final int SMI_OPAQUE = 10;
    public static final int SMI_TIMETICKS = 11;
    public static final int SMI_BITS = 12;
    public static final int SMI_UNSIGNED32 = 13;
    public static final int SMI_NULL = 14;
    public static final int SMI_NETWORKADDRESS = 15;
    public static final int[] SMIv1_SYNTAX = new int[]{0, 1, 2, 3, 4, 9, 10, 11, 14, 15};
    public static final int[] SMI_SYNTAX_MAPPING = new int[]{0, 1, 3, 6, 8, 6, 7, 8, 0, 5, 10, 9, 1, 8, 3, 5};
    private static final String[][] a = new String[][]{STATUS, ACCESS, SMI_SYNTAX};
    private static final String[] b = new String[a[0].length + a[1].length + a[2].length];

    public static int smiv2MIB(String mib) {
        for (int i2 = 0; i2 < smiv2MIBs.length; ++i2) {
            if (!smiv2MIBs[i2].equals(mib)) continue;
            return i2;
        }
        return -1;
    }

    public static int smiv1MIB(String mib) {
        for (int i2 = 0; i2 < smiv1MIBs.length; ++i2) {
            if (!smiv1MIBs[i2].equals(mib)) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isMacroDefMIB(String moduleName) {
        String string;
        return SMI.smiv2MIB(moduleName) >= 0 || SMI.smiv1MIB(string) >= 0;
    }

    public static int entryType(String entryType) {
        if (entryType == null) {
            return -1;
        }
        for (int i2 = 0; i2 < ENTRY_TYPES.length; ++i2) {
            if (!entryType.equals(ENTRY_TYPES[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static int accessType(String access) {
        if (access == null) {
            return -1;
        }
        for (int i2 = 0; i2 < ACCESS.length; ++i2) {
            if (!access.equals(ACCESS[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static final String getCommonIdentifier(String s) {
        String string;
        if (s == null) {
            return null;
        }
        int n2 = Arrays.binarySearch(b, s);
        if (n2 >= 0) {
            return b[n2];
        }
        return string;
    }

    public static int getKeyWordType(int smiversion, String s) {
        int n2;
        String[][] stringArray = smiversion == 1 ? smiv1Constructs : (n2 < 0 ? pibConstructs[Math.abs(n2) - 1] : smiv2Constructs);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            for (int i3 = 0; i3 < stringArray[i2].length; ++i3) {
                if (!stringArray[i2][i3].equals(s)) continue;
                return i2;
            }
        }
        return -1;
    }

    public static boolean isASN1KeyWord(String s) {
        for (int i2 = 0; i2 < asn1Constructs.length; ++i2) {
            if (!asn1Constructs[i2].equals(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKeyWord(String s) {
        String string;
        return SMI.isASN1KeyWord(s) || SMI.getKeyWordType(2, s) >= 0 || SMI.getKeyWordType(1, s) >= 0 || SMI.getKeyWordType(-1, string) >= 0;
    }

    public static boolean isWritable(String access) {
        return SMI.accessType(access) >= 2;
    }

    public static boolean isAccessible(String access) {
        int n2 = SMI.accessType(access);
        return n2 > 0 && n2 < 4;
    }

    public static boolean isNotAccessible(String access) {
        String string;
        return 0 == SMI.accessType(string);
    }

    public static int statusType(String status) {
        if (status == null) {
            return 0;
        }
        for (int i2 = 0; i2 < STATUS.length; ++i2) {
            if (!status.equals(STATUS[i2])) continue;
            return i2;
        }
        return 0;
    }

    public static int basicSyntax(String syntax) {
        for (int i2 = 0; i2 < SMI_SYNTAX.length; ++i2) {
            if (!syntax.equalsIgnoreCase(SMI_SYNTAX[i2])) continue;
            return SMI_SYNTAX_MAPPING[i2];
        }
        return -1;
    }

    public static int smiSyntax(String syntax) {
        if (syntax == null) {
            return -1;
        }
        for (int i2 = 0; i2 < SMI_SYNTAX.length; ++i2) {
            if (!syntax.equalsIgnoreCase(SMI_SYNTAX[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static boolean isNumeric(String syntax) {
        int n2 = SMI.basicSyntax(syntax);
        return n2 == 0 || n2 == 6 || n2 == 8 || n2 == 7 || n2 == 9;
    }

    public static boolean isOID(String syntax) {
        int n2 = SMI.basicSyntax(syntax);
        return n2 == 3;
    }

    public static boolean isCounter(String syntax) {
        int n2 = SMI.basicSyntax(syntax);
        return n2 == 6 || n2 == 7;
    }

    public static boolean isUnsignedNumeric(String syntax) {
        int n2 = SMI.basicSyntax(syntax);
        return n2 == 6 || n2 == 8 || n2 == 7 || n2 == 9;
    }

    public static boolean isSubTypable(String syntax) {
        String string;
        int n2 = SMI.basicSyntax(syntax);
        return SMI.isString(string) || n2 == 0 || n2 == 8;
    }

    public static boolean isString(String syntax) {
        int n2 = SMI.basicSyntax(syntax);
        return n2 == 1 || n2 == 2 || n2 == 10;
    }

    public static long parseLongConstant(String value) throws NumberFormatException {
        Object object;
        if (value.endsWith("h") || value.endsWith("H")) {
            object = new StringTokenizer(value, "'");
            if (!((StringTokenizer)object).hasMoreTokens()) {
                throw new NumberFormatException("Hex string must be enclosed in '.");
            }
            return Long.parseLong(((StringTokenizer)object).nextToken(), 16);
        }
        if (((String)object).endsWith("o") || ((String)object).endsWith("O")) {
            if (!((StringTokenizer)(object = new StringTokenizer((String)object, "'"))).hasMoreTokens()) {
                throw new NumberFormatException("Octal string must be enclosed in '.");
            }
            return Long.parseLong(((StringTokenizer)object).nextToken(), 8);
        }
        if (((String)object).endsWith("b") || ((String)object).endsWith("B")) {
            if (!((StringTokenizer)(object = new StringTokenizer((String)object, "'"))).hasMoreTokens()) {
                throw new NumberFormatException("Binary string must be enclosed in '.");
            }
            return Long.parseLong(((StringTokenizer)object).nextToken(), 2);
        }
        return Long.parseLong((String)object, 10);
    }

    public static byte[] stringConstantToByteArray(String value) throws NumberFormatException {
        int n2 = 10;
        int n3 = 3;
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() >= 2) {
            return value.substring(1, value.length() - 1).getBytes();
        }
        if (value.startsWith("'")) {
            if (value.endsWith("h") || value.endsWith("H")) {
                n2 = 16;
                n3 = 2;
            } else if (value.endsWith("o") || value.endsWith("O")) {
                n2 = 8;
                n3 = 4;
            } else if (value.endsWith("b") || value.endsWith("B")) {
                n2 = 2;
                n3 = 8;
            }
            try {
                String string;
                string = value.substring(1, string.length() - 2);
                if (string.length() == 0) {
                    return new byte[0];
                }
                byte[] byArray = new byte[string.length() / n3];
                for (int i2 = 0; i2 < string.length(); i2 += n3) {
                    int n4 = i2;
                    byArray[i2 / n3] = (byte)Integer.parseInt(string.substring(n4, n4 + n3), n2);
                }
                return byArray;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return null;
            }
        }
        return null;
    }

    public static String parseStringConstant(String value) throws NumberFormatException {
        Object object;
        int n2 = 10;
        int n3 = 3;
        if (value.startsWith("\"")) {
            object = new StringTokenizer(value, "\"");
            if (!((StringTokenizer)object).hasMoreTokens()) {
                return "";
            }
            return ((StringTokenizer)object).nextToken();
        }
        if (((String)object).startsWith("'")) {
            if (((String)object).endsWith("h") || ((String)object).endsWith("H")) {
                n2 = 16;
                n3 = 2;
            }
            if (((String)object).endsWith("o") || ((String)object).endsWith("O")) {
                n2 = 8;
                n3 = 4;
            }
            if (((String)object).endsWith("b") || ((String)object).endsWith("B")) {
                n2 = 2;
                n3 = 8;
            }
            if (!((StringTokenizer)(object = new StringTokenizer((String)object, "'"))).hasMoreTokens()) {
                throw new NumberFormatException("String must be enclosed in '.");
            }
            if (((String)(object = ((StringTokenizer)object).nextToken())).length() == 0) {
                return "";
            }
            try {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i2 = 0; i2 < ((String)object).length(); i2 += n3) {
                    int n4 = i2;
                    char c2 = (char)Integer.parseInt(((String)object).substring(n4, n4 + n3), n2);
                    String string = Integer.toHexString(c2);
                    for (int i3 = 0; i3 < 2 - string.length(); ++i3) {
                        string = "0" + string;
                    }
                    stringBuffer.append("\\x" + string);
                }
                return stringBuffer.toString();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return "";
            }
        }
        return object;
    }

    public static String convertStatusToSMIv2(String status) {
        String string;
        if (status.equals(STATUS[1]) || status.equals(STATUS[2])) {
            return STATUS[5];
        }
        return string;
    }

    static {
        System.arraycopy(a[0], 0, b, 0, a[0].length);
        System.arraycopy(a[1], 0, b, a[0].length, a[1].length);
        System.arraycopy(a[2], 0, b, a[0].length + a[1].length, a[2].length);
        Arrays.sort(b);
    }
}

