/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIObjectIdentifier;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SemanticError;
import com.agentpp.smiparser.StringToken;
import com.agentpp.smiparser.Token;
import com.objectspace.jgl.Pair;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public class ParseScope {
    protected MIBRepository rep = new MIBRepository();
    protected Map unresolved = new HashMap(10);
    protected Map unresolvedSyntaxes = new HashMap(10);
    protected Map knownObjects = new HashMap(100);
    protected Map registeredObjects = new HashMap(100);
    protected Map sequences = new HashMap(100);
    protected Vector wrongTypes = new Vector(10);
    protected String scope = null;
    protected ImportModuleListener importer = null;
    protected SMIParseExceptionHandler errorHandler;

    /*
     * WARNING - void declaration
     */
    public ParseScope(String moduleName, ImportModuleListener importer) {
        void var2_2;
        void var1_1;
        this.scope = var1_1;
        this.importer = var2_2;
        this.init();
    }

    public String getScope() {
        return this.scope;
    }

    public SMIParseExceptionHandler getErrorHandler() {
        return this.errorHandler;
    }

    /*
     * WARNING - void declaration
     */
    public void setImporter(ImportModuleListener importer) {
        void var1_1;
        this.importer = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setErrorHandler(SMIParseExceptionHandler errorHandler) {
        void var1_1;
        this.errorHandler = var1_1;
    }

    public void init() {
        this.rep = new MIBRepository(true);
        this.unresolved = new Hashtable(10);
        this.unresolvedSyntaxes = new Hashtable(10);
        this.knownObjects = new Hashtable(100, 10.0f);
        this.registeredObjects = new Hashtable(100);
        this.sequences = new Hashtable(100);
        Enumeration<? extends MIBObject> enumeration = this.rep.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            try {
                this.addKnownObject(mIBObject);
            }
            catch (SMIParseException sMIParseException) {}
        }
    }

    public boolean importModule(String moduleName, MIBRepository localCache, boolean addAllToKnownObjects) {
        IObject[] iObjectArray;
        Serializable serializable = localCache.getModule(moduleName);
        if (serializable != null) {
            iObjectArray = ((MIBModule)serializable).getObjects();
        } else {
            if (this.importer == null) {
                return false;
            }
            serializable = new ImportModuleEvent(this, (String)iObjectArray);
            this.importer.importModule((ImportModuleEvent)serializable);
            iObjectArray = ((ImportModuleEvent)serializable).getObjects();
        }
        if (iObjectArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < iObjectArray.length; ++i2) {
            if (!(iObjectArray[i2] instanceof MIBObject)) continue;
            this.rep.addObject((MIBObject)iObjectArray[i2]);
            if (!addAllToKnownObjects) continue;
            this.knownObjects.put(iObjectArray[i2].getName(), iObjectArray[i2]);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getObject(String moduleName, String objectName) {
        void var2_2;
        void var1_1;
        return this.rep.getObject((String)var1_1, (String)var2_2);
    }

    public ObjectID getObjectID(String objectName) {
        MIBObject mIBObject;
        if ((mIBObject = (MIBObject)this.knownObjects.get(mIBObject)) == null) {
            return null;
        }
        return mIBObject.getOid();
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID getObjectID(String moduleName, String objectName) {
        void var2_2;
        void var1_1;
        return this.rep.getObjectID((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isModuleAlreadyImported(String moduleName) {
        void var1_1;
        return moduleName != null && this.rep.getModule((String)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isObjectKnown(String objectName) {
        void var1_1;
        return this.knownObjects.get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getKnownObject(String objectName) {
        void var1_1;
        return (MIBObject)this.knownObjects.get(var1_1);
    }

    public String getModuleName(Integer moduleID) {
        MIBModule mIBModule;
        if ((mIBModule = this.rep.getModule((Integer)((Object)mIBModule))) == null) {
            return null;
        }
        return mIBModule.getModuleName();
    }

    /*
     * WARNING - void declaration
     */
    public void addObject(MIBObject o2) {
        void var1_1;
        this.rep.addObject((MIBObject)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addKnownObject(MIBObject o2) throws SMIParseException {
        Serializable serializable;
        switch (o2.getType()) {
            case 4: 
            case 10: {
                break;
            }
            default: {
                serializable = (MIBObject)this.registeredObjects.get(o2.getOid());
                if (serializable != null) {
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(o2.getName());
                    vector.addElement(serializable.getName());
                    vector.addElement(o2.getPrintableOid());
                    if (this.errorHandler != null) {
                        if (o2.userObject instanceof Token) {
                            serializable = (Token)o2.userObject;
                            this.errorHandler.error(new SMIParseException(new SemanticError(2000, ((Token)serializable).beginLine, ((Token)serializable).beginColumn, ((Token)serializable).endPos, (Token)serializable, o2.getName(), o2.getName(), new String[0]), 2000, vector));
                        } else {
                            this.errorHandler.error(new SMIParseException("Duplicate OID registration", 2000, vector));
                        }
                    }
                }
                this.registeredObjects.put(o2.getOid(), o2);
            }
        }
        serializable = (MIBObject)this.knownObjects.get(o2.getName());
        if (serializable == null || serializable.getModuleID() < 0) {
            void var1_1;
            this.knownObjects.put(o2.getName(), var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void replaceKnownObject(String name, MIBObject o2) {
        void var1_1;
        this.knownObjects.remove(var1_1);
        try {
            void var2_2;
            this.addKnownObject((MIBObject)var2_2);
            return;
        }
        catch (SMIParseException sMIParseException) {
            return;
        }
    }

    public final void addUnresolvedName(StringToken[] oid, StringToken name) {
        Object object;
        Pair pair;
        pair = new Pair((Object)oid, (Object)pair);
        object = ParseScope.a((StringToken[])object);
        object = ((AbstractSequentialList)object).iterator();
        while (object.hasNext()) {
            Object object2 = (String)object.next();
            LinkedList<Pair> linkedList = (LinkedList<Pair>)this.unresolved.get(object2 = new StringToken((String)object2, null));
            if (linkedList == null) {
                linkedList = new LinkedList<Pair>();
                this.unresolved.put(object2, linkedList);
            }
            linkedList.add(pair);
        }
    }

    private static LinkedList a(StringToken[] stringTokenArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i2 = 0; i2 < stringTokenArray.length; ++i2) {
            String string = stringTokenArray[i2].string;
            if (string.length() <= 0 || Character.isDigit(string.charAt(0))) continue;
            linkedList.add(string);
        }
        return linkedList;
    }

    public final void checkUnresolved(StringToken name, StringToken[] oid) {
        Object object = (LinkedList)this.unresolved.get(name);
        if (object != null) {
            object = ((AbstractList)object).listIterator();
            while (object.hasNext()) {
                Pair pair = (Pair)object.next();
                Object[] objectArray = (StringToken[])pair.first;
                StringToken stringToken = (StringToken)pair.second;
                int n2 = Arrays.binarySearch(objectArray, name);
                if (n2 < 0 || n2 >= objectArray.length - 1) continue;
                ObjectID objectID = SMIObjectIdentifier.buildObjectID((StringToken[])(objectArray = ParseScope.a(oid, (StringToken[])objectArray, n2)));
                if (objectID.isValid()) {
                    object.remove();
                    try {
                        this.addKnownObject(new MIBObject(objectID, stringToken.string));
                    }
                    catch (SMIParseException sMIParseException) {}
                    continue;
                }
                pair.first = objectArray;
            }
        }
    }

    private static StringToken[] a(StringToken[] stringTokenArray, StringToken[] stringTokenArray2, int n2) {
        StringToken[] stringTokenArray3 = new StringToken[stringTokenArray2.length - 1 + stringTokenArray.length];
        if (n2 > 0) {
            System.arraycopy(stringTokenArray2, 0, stringTokenArray3, 0, n2);
        }
        if (stringTokenArray.length > 0) {
            System.arraycopy(stringTokenArray, 0, stringTokenArray3, n2, stringTokenArray.length);
        }
        System.arraycopy(stringTokenArray2, n2 + 1, stringTokenArray3, n2 + stringTokenArray.length, stringTokenArray2.length - n2 - 1);
        return stringTokenArray3;
    }

    private static boolean a(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void resolveNames() {
        Iterator iterator = this.unresolved.values().iterator();
        while (iterator.hasNext()) {
            LinkedList linkedList = (LinkedList)iterator.next();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                StringToken[] stringTokenArray;
                int n2;
                Object object = (Pair)listIterator.next();
                Object object2 = (StringToken[])object.first;
                StringToken stringToken = (StringToken)object.second;
                Object object3 = null;
                StringToken stringToken2 = null;
                int n3 = -1;
                for (n2 = 0; n2 < ((StringToken[])object2).length; ++n2) {
                    if (ParseScope.a(object2[n2].string)) continue;
                    stringToken2 = object2[n2];
                    n3 = n2;
                    break;
                }
                if (Character.isUpperCase(stringToken2.string.charAt(0))) {
                    n2 = stringToken2.string.indexOf(46);
                    if (n2 >= 0) {
                        object3 = stringToken2.string.substring(0, n2);
                        stringTokenArray = stringToken2.string.substring(n2 + 1);
                        if ((object3 = this.rep.getObjectID((String)object3, (String)stringTokenArray)) != null) {
                            stringToken2.string = stringTokenArray;
                        }
                    }
                } else {
                    object3 = this.rep.getObjectID(stringToken2.string);
                }
                if (object3 == null) continue;
                String[] stringArray = ObjectID.toArray(object3.toString());
                object3 = new StringToken[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    object3[i2] = new StringToken(stringArray[i2], null);
                }
                stringTokenArray = ParseScope.a(object3, object2, n3);
                if ((object2 = new ObjectID(SMIObjectIdentifier.buildObjectID(stringTokenArray))).isValid()) {
                    listIterator.remove();
                    try {
                        object = new MIBObject((ObjectID)object2, stringToken.string);
                        new MIBObject((ObjectID)object2, stringToken.string).userObject = stringTokenArray;
                        this.addKnownObject((MIBObject)object);
                    }
                    catch (SMIParseException sMIParseException) {}
                    continue;
                }
                object.first = stringTokenArray;
            }
            if (linkedList.size() != 0) continue;
            iterator.remove();
        }
    }

    public boolean existsUnresolvedNames() {
        this.resolveNames();
        return this.unresolved.size() > 0;
    }

    public Iterator getUnresolvedNames() {
        return this.unresolved.values().iterator();
    }

    /*
     * WARNING - void declaration
     */
    public void checkUnresolvedSyntax(StringToken syntax) {
        if (this.knownObjects.get(syntax) == null) {
            void var1_1;
            this.unresolvedSyntaxes.put(var1_1, String.class);
        }
    }

    public StringToken getUnresolvedSyntax(String syntax) {
        for (Object k2 : this.unresolvedSyntaxes.keySet()) {
            if (!(k2 instanceof StringToken) || !syntax.equals(k2)) continue;
            return (StringToken)k2;
        }
        return null;
    }

    private static boolean a(Class clazz, Class clazz2) {
        return !clazz.equals(clazz2) && (MIBObject.class.equals(clazz.getClass()) || !clazz.isAssignableFrom(clazz2) && !clazz2.isAssignableFrom(clazz));
    }

    /*
     * WARNING - void declaration
     */
    public void checkUnresolvedObject(StringToken objectName, Class type) {
        MIBObject mIBObject = (MIBObject)this.knownObjects.get(objectName);
        if (mIBObject == null || mIBObject instanceof MIBTextualConvention || mIBObject.getOid().isEmpty() || type != null && ParseScope.a(mIBObject.getClass(), type)) {
            void var2_2;
            void var1_1;
            if (type == null) {
                this.unresolvedSyntaxes.put(objectName, String.class);
                return;
            }
            this.unresolvedSyntaxes.put(var1_1, var2_2);
        }
    }

    public boolean existsUnresolvedSyntaxes() {
        return this.unresolvedSyntaxes.size() > 0;
    }

    public void resolveSyntaxes() {
        boolean bl = true;
        block2: while (bl) {
            bl = false;
            Object object = this.unresolvedSyntaxes.entrySet().iterator();
            while (object.hasNext()) {
                Object object2 = object.next();
                StringToken stringToken = (StringToken)object2.getKey();
                object2 = (Class)object2.getValue();
                Object v = this.knownObjects.get(stringToken.string);
                if (v == null) continue;
                this.unresolvedSyntaxes.remove(stringToken);
                if (!object2.equals(new String().getClass())) {
                    try {
                        String string = ((MIBObject)((Class)object2).newInstance()).getTypeString();
                        object = ((MIBObject)v).getTypeString();
                        if (ParseScope.a(v.getClass(), (Class)object2) && !SMI.ENTRY_TYPES[10].equals(string)) {
                            this.wrongTypes.add(new Object[]{stringToken, string, object});
                        }
                    }
                    catch (Exception exception) {
                        Exception exception2 = exception;
                        exception.printStackTrace();
                    }
                }
                bl = true;
                continue block2;
            }
        }
    }

    public boolean existsWrongTypes() {
        return this.wrongTypes.size() > 0;
    }

    public Iterator getWrongTypes() {
        return this.wrongTypes.iterator();
    }

    public Iterator getUnresolvedSyntaxes() {
        return this.unresolvedSyntaxes.entrySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    public void addSequence(String sequenceIdentifier) {
        void var1_1;
        this.sequences.put(var1_1, new Vector());
    }

    /*
     * WARNING - void declaration
     */
    public Vector getSequence(String sequenceIdentifier) {
        void var1_1;
        return (Vector)this.sequences.get(var1_1);
    }

    public List<String> getKnownLowerCaseNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.knownObjects.keySet()) {
            if (string.length() <= 0 || !Character.isLowerCase(string.charAt(0))) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getKnownUpperCaseNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.knownObjects.keySet()) {
            if (string.length() <= 0 || !Character.isUpperCase(string.charAt(0))) continue;
            arrayList.add(string);
        }
        return arrayList;
    }
}

