/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pib;

import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.ObjectID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PIBObjectType
extends MIBObjectType {
    public static final long serialVersionUID = 1000L;
    private String pibReferences;
    private String tag;
    private List<String> uniqueObjects;
    private List<MIBEnum> installErrors;
    private MIBIndexPart mibIndexPart;

    public PIBObjectType() {
    }

    /*
     * WARNING - void declaration
     */
    public PIBObjectType(ObjectID oid, String name, Integer moduleID) {
        super((ObjectID)var1_1, (String)var2_2, (Integer)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PIBObjectType(PIBObjectType pibObjectType) {
        super(pibObjectType);
        void var1_1;
        this.pibReferences = pibObjectType.pibReferences;
        this.tag = pibObjectType.tag;
        this.uniqueObjects = pibObjectType.uniqueObjects == null ? null : new ArrayList<String>(pibObjectType.uniqueObjects);
        this.installErrors = pibObjectType.installErrors == null ? null : new ArrayList<MIBEnum>(pibObjectType.installErrors);
        this.mibIndexPart = pibObjectType.mibIndexPart == null ? null : new MIBIndexPart(var1_1.mibIndexPart);
    }

    public List<String> getUniqueObjects() {
        return this.uniqueObjects;
    }

    @Override
    public MIBObject getClone() {
        return new PIBObjectType(this);
    }

    public String getTag() {
        return this.tag;
    }

    public String getPibReferences() {
        return this.pibReferences;
    }

    /*
     * WARNING - void declaration
     */
    public void setInstallErrors(List<MIBEnum> installErrors) {
        void var1_1;
        this.installErrors = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setUniqueObjects(List<String> uniqueObjects) {
        void var1_1;
        this.uniqueObjects = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTag(String tag) {
        void var1_1;
        this.tag = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPibReferences(String pibReferences) {
        void var1_1;
        this.pibReferences = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMibIndexPart(MIBIndexPart mibIndex) {
        void var1_1;
        this.mibIndexPart = var1_1;
    }

    public List<MIBEnum> getInstallErrors() {
        return this.installErrors;
    }

    public MIBIndexPart getMibIndexPart() {
        return this.mibIndexPart;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void toSMIIndexPart(int mode, String lineSeparator, MIBObjectType c2, StringBuffer buf) {
        super.toSMIIndexPart(mode, lineSeparator, c2, buf);
        if (this.mibIndexPart != null && this.mibIndexPart.getIndexPartVector() != null && this.mibIndexPart.getIndexPartVector().size() > 0) {
            buf.append('\t');
            Object object = null;
            if (c2 instanceof PIBObjectType) {
                void var3_3;
                object = (PIBObjectType)c2;
                object = var3_3.hasIndexPart() ? ((PIBObjectType)object).mibIndexPart.toSMI(mode, lineSeparator) : "";
            }
            MIBObject.addString(mode, buf, this.mibIndexPart.toSMI(mode, lineSeparator), (String)object);
        }
        if (this.uniqueObjects != null) {
            void var2_2;
            buf.append('\t');
            MIBObject.addKeyWord(mode, buf, "UNIQUENESS ");
            buf.append("{");
            if (this.uniqueObjects.size() > 0) {
                void var1_1;
                buf.append(lineSeparator);
                buf.append(MIBObject.formatObjectRefs((int)var1_1, "\t\t", this.uniqueObjects.iterator(), lineSeparator));
            }
            buf.append(" }");
            buf.append((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void toSmiAccess(int mode, int smiversion, String lineSeparator, MIBObjectType oc, StringBuffer buf) {
        if (smiversion > 0) {
            void var2_2;
            super.toSmiAccess(mode, (int)var2_2, lineSeparator, oc, buf);
            return;
        }
        PIBObjectType pIBObjectType = (PIBObjectType)oc;
        if (this.access != null) {
            buf.append('\t');
            PIBObjectType.addKeyWord(mode, buf, "PIB-ACCESS ");
            PIBObjectType.addString(mode, buf, this.access, pIBObjectType == null ? null : pIBObjectType.getAccess());
            buf.append(lineSeparator);
        }
        if (this.getPibReferences() != null) {
            buf.append('\t');
            PIBObjectType.addKeyWord(mode, buf, "PIB-REFERENCES ");
            buf.append("{ ");
            PIBObjectType.addString(mode, buf, this.getPibReferences(), pIBObjectType == null ? null : pIBObjectType.getPibReferences());
            buf.append(" }" + lineSeparator);
        }
        if (this.getTag() != null) {
            void var3_4;
            void var1_1;
            buf.append('\t');
            PIBObjectType.addKeyWord(mode, buf, "PIB-TAG ");
            buf.append("{ ");
            PIBObjectType.addString((int)var1_1, buf, this.getTag(), pIBObjectType == null ? null : pIBObjectType.getTag());
            buf.append(" }" + (String)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getSMIBeforeReference(int mode, String lineSeparator, MIBObject c2) {
        StringBuffer stringBuffer;
        PIBObjectType pIBObjectType = null;
        if (c2 instanceof PIBObjectType) {
            pIBObjectType = (PIBObjectType)((Object)stringBuffer);
        }
        stringBuffer = new StringBuffer();
        if (this.installErrors != null && this.installErrors.size() > 0) {
            void var2_2;
            void var1_1;
            stringBuffer.append('\t');
            PIBObjectType.addKeyWord(mode, stringBuffer, "INSTALL-ERRORS { ");
            Iterator<MIBEnum> iterator = Collections.emptyList().iterator();
            if (pIBObjectType != null && pIBObjectType.getInstallErrors() != null) {
                iterator = pIBObjectType.getInstallErrors().iterator();
            }
            MIBSyntax.toSMIEnums((int)var1_1, lineSeparator, stringBuffer, iterator, this.getInstallErrors());
            stringBuffer.append("}" + (String)var2_2);
        }
        return stringBuffer.toString();
    }
}

