/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.mib.util.EnumerationIterator;
import com.agentpp.smi.INotificationType;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMIEnum;
import com.agentpp.smiparser.SMI;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class MIBRepository
implements Serializable {
    public static final long serialVersionUID = 100L;
    private transient ConcurrentHashMap<String, MIBModule> modules = null;
    private transient ConcurrentHashMap<Integer, MIBModule> moduleIDs = null;
    private transient ConcurrentHashMap<Integer, String> importedModuleIDs = null;
    private transient OrderedMap onames = null;
    private transient OrderedMap oids = null;
    private transient Vector listenerList;

    public MIBRepository() {
        this.init(false);
    }

    /*
     * WARNING - void declaration
     */
    public MIBRepository(boolean addIETFObjects) {
        void var1_1;
        this.init((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MIBRepository(MIBObject[] objects) {
        void var1_1;
        this.init(false);
        this.addAllObjects((MIBObject[])var1_1);
    }

    public Object clone() {
        MIBRepository mIBRepository = new MIBRepository();
        new MIBRepository().oids = (OrderedMap)this.oids.clone();
        mIBRepository.onames = (OrderedMap)this.onames.clone();
        mIBRepository.modules = new ConcurrentHashMap<String, MIBModule>(this.modules);
        mIBRepository.moduleIDs = new ConcurrentHashMap<Integer, MIBModule>(this.moduleIDs);
        mIBRepository.importedModuleIDs = new ConcurrentHashMap<Integer, String>(this.importedModuleIDs);
        return mIBRepository;
    }

    /*
     * WARNING - void declaration
     */
    private void init(boolean withIETF) {
        void var1_1;
        this.listenerList = new Vector(5);
        this.oids = new OrderedMap((BinaryPredicate)ObjectIDPredicate.instance, true);
        this.onames = new OrderedMap((BinaryPredicate)LexicographicPredicate.instance, true);
        this.modules = new ConcurrentHashMap(150);
        this.moduleIDs = new ConcurrentHashMap(150);
        this.importedModuleIDs = new ConcurrentHashMap(100);
        if (var1_1 != false) {
            this.addIETFObjectIDs();
        }
        this.structureChanged();
    }

    public void clear() {
        this.oids.clear();
        this.onames.clear();
        this.modules.clear();
        this.moduleIDs.clear();
        this.importedModuleIDs.clear();
        this.addIETFObjectIDs();
        this.structureChanged();
    }

    public int size() {
        return this.oids.size();
    }

    public int moduleCount() {
        return this.modules.size();
    }

    protected void addIETFObjectIDs() {
        for (int i2 = 0; i2 < SMI.rootOids.length; ++i2) {
            MIBObject mIBObject = new MIBObject(new ObjectID(SMI.rootOids[i2][1]), SMI.rootOids[i2][0]);
            this.oids.add((Object)mIBObject.getOid(), (Object)mIBObject);
            this.onames.add((Object)mIBObject.getName(), (Object)mIBObject);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addModule(MIBModule o2) {
        void var1_1;
        this.modules.put(o2.getModuleName(), o2);
        this.moduleIDs.put(o2.getModuleID(), (MIBModule)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addObject(MIBObject o2) {
        this.removeObject(o2.getModuleID(), o2);
        if (!o2.getOid().isEmpty()) {
            this.oids.add((Object)o2.getOid(), (Object)o2);
        }
        this.onames.add((Object)o2.getName(), (Object)o2);
        if (o2 instanceof MIBModule) {
            this.addModule((MIBModule)o2);
            ((MIBModule)o2).add(o2);
            return;
        }
        MIBModule mIBModule = this.moduleIDs.get(o2.getModuleID());
        if (mIBModule != null) {
            void var1_1;
            mIBModule.add((MIBObject)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addObject(MIBObject o2, MIBModule module, boolean removeExisting) {
        void var2_3;
        Serializable serializable = this;
        synchronized (serializable) {
            MIBObject mIBObject;
            MIBObject mIBObject2;
            void var3_4;
            if (var3_4 != false) {
                this.removeObject(o2.getModuleID(), o2);
            }
            if (!(o2.getOid() == null || o2.getOid().isEmpty() || (mIBObject2 = (MIBObject)this.oids.get((Object)o2.getOid())) != null && mIBObject2.equals(o2))) {
                this.oids.add((Object)o2.getOid(), (Object)o2);
            }
            if ((mIBObject = (MIBObject)this.onames.get((Object)o2.getName())) == null || !mIBObject.equals(o2)) {
                this.onames.add((Object)o2.getName(), (Object)o2);
            }
        }
        if (o2 instanceof MIBModule) {
            this.addModule((MIBModule)o2);
            ((MIBModule)o2).add(o2);
            return;
        }
        serializable = var2_3;
        if (serializable == null) {
            serializable = this.moduleIDs.get(o2.getModuleID());
        }
        if (serializable != null) {
            void var1_1;
            ((MIBModule)serializable).add((MIBObject)var1_1);
        }
    }

    public synchronized void addObject(MIBObject o2, boolean addModuleObjects) {
        this.addObject(o2);
        if (o2 instanceof MIBModule) {
            MIBModule mIBModule;
            mIBModule = mIBModule;
            for (MIBObject mIBObject : mIBModule.objects.values()) {
                this.addObject(mIBObject);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addAllObjects(MIBObject[] objects, MIBModule module, boolean removeExisting, Map<String, Integer> importedModules) {
        void var1_1;
        MIBObject[] mIBObjectArray = objects;
        int n2 = objects.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MIBObject mIBObject = mIBObjectArray[i2];
            this.addObject(mIBObject, module, removeExisting);
            if (module != null || !(mIBObject instanceof MIBModule)) continue;
            importedModules.put(mIBObject.getName(), mIBObject.getModuleID());
        }
        for (MIBObject mIBObject : var1_1) {
            if (!(mIBObject instanceof MIBObjectType)) continue;
            this.initColumnarObjectInfoOnTable((MIBObjectType)mIBObject);
        }
    }

    public void addAllObjects(MIBObject[] objects) {
        MIBObject[] mIBObjectArray = objects;
        int n2 = objects.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MIBObject mIBObject = mIBObjectArray[i2];
            this.addObject(mIBObject);
        }
        this.structureChanged();
    }

    public String getObjectName(ObjectID oid) {
        MIBObject mIBObject;
        if ((mIBObject = (MIBObject)this.oids.get((Object)mIBObject)) != null) {
            return mIBObject.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String getUniqueObjectName(MIBObject o2) {
        void var1_1;
        Object object = this.getObjectsByName(o2.getName());
        if (object == null || ((MIBObject[])object).length <= 1) {
            return o2.getName();
        }
        object = this.getModuleName(o2.getModuleID());
        if (object == null) {
            return o2.getName();
        }
        return (String)object + "." + var1_1.getName();
    }

    public ObjectID getObjectID(String name) {
        MIBObject mIBObject;
        if ((mIBObject = (MIBObject)this.onames.get((Object)mIBObject)) != null) {
            return mIBObject.getOid();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID getObjectID(String moduleName, String name) {
        void var2_2;
        MIBObject mIBObject;
        if ((mIBObject = this.getModule((String)((Object)mIBObject))) == null) {
            return null;
        }
        if ((mIBObject = ((MIBModule)mIBObject).getObjectByName((String)var2_2)) != null) {
            return mIBObject.getOid();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getObject(String moduleName, String name) {
        void var2_2;
        MIBModule mIBModule = this.getModule(moduleName);
        if (mIBModule == null) {
            MIBObject[] mIBObjectArray = this.getObjectsByName((String)name);
            name = mIBObjectArray;
            name = mIBObjectArray;
            int n2 = mIBObjectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MIBObject mIBObject = name[i2];
                if (!moduleName.equals(this.getModuleName(mIBObject.getModuleID()))) continue;
                return mIBObject;
            }
            return null;
        }
        return mIBModule.getObjectByName((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getScopedObject(String moduleName, String name) {
        void var2_2;
        if (name.isEmpty()) {
            return null;
        }
        if (Character.isUpperCase(name.charAt(0)) && name.indexOf(46) > 0) {
            return this.getObject((String)name);
        }
        MIBModule mIBModule = this.getModule(moduleName);
        if (mIBModule == null) {
            MIBObject[] mIBObjectArray;
            name = mIBObjectArray = this.getObjectsByName((String)name);
            int n2 = mIBObjectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MIBObject mIBObject = name[i2];
                if (!moduleName.equals(this.getModuleName(mIBObject.getModuleID()))) continue;
                return mIBObject;
            }
            return null;
        }
        String string = mIBModule.getImportSource((String)name);
        if (string != null) {
            return this.getObject(string, (String)name);
        }
        return mIBModule.getObjectByName((String)var2_2);
    }

    public Vector<? extends MIBObject> getChildren(String objectName) {
        MIBObject mIBObject;
        if ((mIBObject = (MIBObject)this.onames.get((Object)mIBObject)) == null) {
            return null;
        }
        return this.getChildren(mIBObject);
    }

    /*
     * WARNING - void declaration
     */
    public Vector<? extends MIBObject> getChildren(ObjectID oid) {
        void var1_1;
        return this.getChildren((ObjectID)var1_1, true);
    }

    public Vector<? extends MIBObject> getChildren(ObjectID oid, boolean uniqueOIDs) {
        Vector<MIBObject> vector = new Vector<MIBObject>();
        OrderedMapIterator orderedMapIterator = this.oids.find((Object)oid);
        if (orderedMapIterator.atEnd()) {
            return vector;
        }
        MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
        if (!mIBObject.getOid().equals(oid)) {
            return vector;
        }
        orderedMapIterator.advance();
        while (!orderedMapIterator.atEnd()) {
            block7: {
                block9: {
                    MIBObject mIBObject2;
                    block8: {
                        mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
                        if (mIBObject.getOid().equals(oid) || uniqueOIDs && !vector.isEmpty() && mIBObject.getOid().equals(((MIBObject)vector.lastElement()).getOid())) break block7;
                        if (!mIBObject.getOid().isChildOf(oid)) break block8;
                        vector.add(mIBObject);
                        break block9;
                    }
                    if (!oid.isRootOf(mIBObject.getOid())) break block9;
                    if (!vector.isEmpty() && (mIBObject2 = (MIBObject)vector.lastElement()).getOid().isRootOf(mIBObject.getOid())) break block7;
                    vector.addElement(mIBObject);
                }
                if (!oid.isRootOf(mIBObject.getOid())) {
                    return vector;
                }
            }
            orderedMapIterator.advance();
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    public Vector<? extends MIBObject> getChildren(MIBObject o2) {
        void var1_1;
        return this.getChildren(var1_1.getOid());
    }

    public void removeChildren(MIBObject o2) {
        Object object;
        if ((object = this.getChildren((MIBObject)object)) == null) {
            return;
        }
        object = ((Vector)object).elements();
        while (object.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)object.nextElement();
            this.removeObject(mIBObject);
        }
    }

    public Vector<? extends MIBObject> getDescendants(MIBObject o2) {
        Object object;
        Vector<MIBObject> vector = new Vector<MIBObject>(10, 10);
        if ((object = this.getChildren((MIBObject)object)) == null) {
            return vector;
        }
        object = ((Vector)object).elements();
        while (object.hasMoreElements()) {
            Object object2 = (MIBObject)object.nextElement();
            vector.add((MIBObject)object2);
            object2 = this.getDescendants((MIBObject)object2);
            object2 = ((Vector)object2).elements();
            while (object2.hasMoreElements()) {
                vector.add((MIBObject)object2.nextElement());
            }
        }
        return vector;
    }

    public boolean hasDescendants(MIBObject o2) {
        ObjectID objectID;
        if (o2.getOid() == null) {
            return false;
        }
        OrderedMapIterator orderedMapIterator = this.oids.find((Object)(objectID = ((MIBObject)((Object)objectID)).getOid()));
        if (orderedMapIterator.atEnd()) {
            return false;
        }
        MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
        if (!mIBObject.getOid().equals(objectID)) {
            return false;
        }
        orderedMapIterator.advance();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(objectID)) {
                if (mIBObject.getOid().isChildOf(objectID)) {
                    return true;
                }
                if (objectID.isRootOf(mIBObject.getOid())) {
                    return true;
                }
                if (!objectID.isRootOf(mIBObject.getOid())) {
                    return false;
                }
            }
            orderedMapIterator.advance();
        }
        return false;
    }

    public MIBObject getParent(String objectName) {
        MIBObject mIBObject;
        if ((mIBObject = (MIBObject)this.onames.get((Object)mIBObject)) == null) {
            return null;
        }
        return this.getParent(mIBObject);
    }

    public MIBObject getNextParent(ObjectID oid) {
        ObjectID objectID;
        if (oid.size() <= 1 || this.oids.find((Object)oid) == null) {
            return null;
        }
        MIBObject mIBObject = null;
        objectID = ObjectID.trim(objectID);
        while (mIBObject == null && !objectID.isEmpty()) {
            mIBObject = (MIBObject)this.oids.get((Object)objectID);
            objectID = ObjectID.trim(objectID);
            objectID = ObjectID.trim(objectID);
        }
        return mIBObject;
    }

    public MIBObject getParent(MIBObject o2) {
        ObjectID objectID;
        if (this.oids.find((Object)o2.getOid()) == null || o2.getOid().isEmpty()) {
            return null;
        }
        objectID = ObjectID.trim(((MIBObject)((Object)objectID)).getOid());
        MIBObject mIBObject = null;
        while (mIBObject == null && !objectID.isEmpty()) {
            mIBObject = (MIBObject)this.oids.get((Object)objectID);
            objectID = ObjectID.trim(objectID);
        }
        return mIBObject;
    }

    public MIBObject getParentInSameModule(MIBObject o2) {
        if (this.oids.find((Object)o2.getOid()) == null || o2.getOid().isEmpty()) {
            return null;
        }
        ObjectID objectID = ObjectID.trim(o2.getOid());
        MIBObject mIBObject = null;
        while (!objectID.isEmpty()) {
            MIBObject[] mIBObjectArray = this.getObjectsByOid(objectID);
            MIBObject[] mIBObjectArray2 = mIBObjectArray;
            mIBObjectArray2 = mIBObjectArray;
            int n2 = mIBObjectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MIBObject mIBObject2 = mIBObjectArray2[i2];
                if (!mIBObject2.getModuleID().equals(o2.getModuleID())) continue;
                mIBObject = mIBObject2;
                break;
            }
            objectID = ObjectID.trim(objectID);
        }
        return mIBObject;
    }

    /*
     * WARNING - void declaration
     */
    public Pair getSplittedObjectID(ObjectID oid) throws ObjectIDFormatException {
        void var1_1;
        Pair pair = new Pair();
        Object object = this.oids.lowerBound((Object)oid);
        if (object.atEnd()) {
            return new Pair((Object)oid, (Object)new ObjectID());
        }
        if (((Pair)object.get()).first.equals(oid)) {
            pair.first = oid;
            pair.second = new ObjectID();
            return pair;
        }
        object.retreat();
        if (object.atBegin() || object.get() == null) {
            return new Pair((Object)oid, (Object)new ObjectID());
        }
        object = (MIBObject)((Pair)object.get()).second;
        if (!((MIBObject)object).getOid().isRootOf(oid)) {
            pair.first = oid;
            pair.second = new ObjectID();
            return pair;
        }
        pair.first = ((MIBObject)object).getOid();
        void v0 = var1_1;
        pair.second = v0.getSuffix(v0.size() - ((MIBObject)object).getOid().size());
        return pair;
    }

    public ObjectID[] getIndexObjectIDs(ObjectID oid) {
        try {
            Object object;
            object = this.getSplittedObjectID((ObjectID)object);
            Comparable comparable = ObjectID.trim((ObjectID)object.first);
            object = (ObjectID)object.second;
            comparable = (MIBObjectType)this.getObject((ObjectID)comparable);
            if (comparable == null || !((MIBObjectType)comparable).hasIndexPart()) {
                return null;
            }
            comparable = ((MIBObjectType)comparable).getIndexPart().getIndexStruct(this);
            return this.getIndexObjectIDs((ObjectID)object, (IndexStruct[])comparable);
        }
        catch (ObjectIDFormatException objectIDFormatException) {
            return null;
        }
    }

    public ObjectID[] getIndexObjectIDs(ObjectID index, IndexStruct[] is) {
        try {
            ObjectID[] objectIDArray = new ObjectID[is.length];
            for (int i2 = 0; i2 < is.length; ++i2) {
                if (is[i2].impliedLength) {
                    objectIDArray[i2] = index;
                    break;
                }
                if (!is[i2].impliedLength && is[i2].minLength != is[i2].maxLength) {
                    ObjectID objectID = index;
                    objectIDArray[i2] = objectID.getPrefix((int)objectID.getSubIDAsLong(0) + 1);
                } else {
                    objectIDArray[i2] = index.getPrefix(is[i2].maxLength);
                }
                ObjectID objectID = index;
                index = objectID.getSuffix(objectID.size() - objectIDArray[i2].size());
            }
            return objectIDArray;
        }
        catch (ObjectIDFormatException | ArrayIndexOutOfBoundsException exception) {
            return null;
        }
    }

    public MIBObject[] getObjectsByName(String name) {
        OrderedMapIterator orderedMapIterator;
        MIBObject[] mIBObjectArray = new MIBObject[this.onames.count((Object)name)];
        if (mIBObjectArray.length == 0) {
            return mIBObjectArray;
        }
        orderedMapIterator = this.onames.lowerBound((Object)orderedMapIterator);
        for (int i2 = 0; !orderedMapIterator.atEnd() && i2 < mIBObjectArray.length; ++i2) {
            mIBObjectArray[i2] = (MIBObject)((Pair)orderedMapIterator.get()).second;
            orderedMapIterator.advance();
        }
        return mIBObjectArray;
    }

    public MIBObject[] getObjectsByNamePrefix(String namePrefix, int maxCount) {
        MIBObject mIBObject;
        ArrayList<MIBObject> arrayList = new ArrayList<MIBObject>();
        OrderedMapIterator orderedMapIterator = this.onames.lowerBound((Object)namePrefix);
        for (int i2 = 0; !orderedMapIterator.atEnd() && (maxCount > 0 || i2 < maxCount) && (mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second).getName().startsWith(namePrefix); ++i2) {
            arrayList.add(mIBObject);
            orderedMapIterator.advance();
        }
        return arrayList.toArray(new MIBObject[0]);
    }

    public MIBObject[] getObjectsByOid(ObjectID oid) {
        OrderedMapIterator orderedMapIterator;
        MIBObject[] mIBObjectArray = new MIBObject[this.oids.count((Object)oid)];
        if (mIBObjectArray.length == 0) {
            return mIBObjectArray;
        }
        orderedMapIterator = this.oids.lowerBound((Object)orderedMapIterator);
        for (int i2 = 0; !orderedMapIterator.atEnd() && i2 < mIBObjectArray.length; ++i2) {
            mIBObjectArray[i2] = (MIBObject)((Pair)orderedMapIterator.get()).second;
            orderedMapIterator.advance();
        }
        return mIBObjectArray;
    }

    public synchronized void remove(MIBModule m2) {
        MIBObject mIBObject;
        this.modules.remove(m2.getModuleName());
        this.moduleIDs.remove(m2.getModuleID());
        OrderedMapIterator orderedMapIterator = this.oids.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && mIBObject.getModuleID().equals(m2.getModuleID())) {
                this.oids.remove((Enumeration)orderedMapIterator);
                orderedMapIterator = this.oids.lowerBound((Object)mIBObject.getOid());
                continue;
            }
            orderedMapIterator.advance();
        }
        orderedMapIterator = this.onames.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && mIBObject.getModuleID().equals(m2.getModuleID())) {
                this.onames.remove((Enumeration)orderedMapIterator);
                orderedMapIterator = this.onames.lowerBound((Object)mIBObject.getName());
                continue;
            }
            orderedMapIterator.advance();
        }
    }

    public Map<String, String> getImportDependencies(Collection<String> importingModules, String importedModuleFilter) {
        Iterator iterator;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = this.getModule(string);
            if (object == null) continue;
            if (importedModuleFilter != null) {
                if ((object = ((MIBModule)object).getImports(importedModuleFilter)) == null) continue;
                for (String string2 : ((MIBImport)object).getImportsVector()) {
                    hashMap.put(string2, string);
                }
                continue;
            }
            if (((MIBModule)object).getImportsVector() == null) continue;
            for (MIBImport mIBImport : ((MIBModule)object).getImportsVector()) {
                if (mIBImport == null) continue;
                for (String string3 : mIBImport.getImportsVector()) {
                    hashMap.put(string3, string);
                }
            }
        }
        return hashMap;
    }

    public synchronized int remove(MIBModule moduleToRemove, Collection<String> modulesToRetain) {
        MIBObject mIBObject;
        Map<String, String> map;
        int n2 = 0;
        this.modules.remove(moduleToRemove.getModuleName());
        this.moduleIDs.remove(moduleToRemove.getModuleID());
        map = this.getImportDependencies((Collection<String>)((Object)map), null);
        OrderedMapIterator orderedMapIterator = this.oids.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && !map.containsKey(mIBObject.getName())) {
                if (mIBObject.getModuleID().equals(moduleToRemove.getModuleID()) || moduleToRemove.imports(mIBObject.getName()) && !map.containsKey(mIBObject.getName())) {
                    this.oids.remove((Enumeration)orderedMapIterator);
                    orderedMapIterator = this.oids.lowerBound((Object)mIBObject.getOid());
                    continue;
                }
                orderedMapIterator.advance();
                continue;
            }
            orderedMapIterator.advance();
        }
        orderedMapIterator = this.onames.begin();
        while (!orderedMapIterator.atEnd()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (mIBObject != null && !map.containsKey(mIBObject.getName())) {
                if (mIBObject.getModuleID().equals(moduleToRemove.getModuleID()) || moduleToRemove.imports(mIBObject.getName())) {
                    if (this.onames.remove((Enumeration)orderedMapIterator) != null) {
                        ++n2;
                    }
                    orderedMapIterator = this.onames.lowerBound((Object)mIBObject.getName());
                    continue;
                }
                orderedMapIterator.advance();
                continue;
            }
            orderedMapIterator.advance();
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public void removeObject(Integer moduleID, MIBObject o2) {
        MIBObject mIBObject;
        MIBObject mIBObject2;
        Serializable serializable;
        if (moduleID != null && (serializable = this.moduleIDs.get(moduleID)) != null) {
            ((MIBModule)serializable).remove(o2);
        }
        if (o2.getOid() != null && !o2.getOid().isEmpty()) {
            serializable = this;
            synchronized (serializable) {
                mIBObject2 = (MIBObject)this.oids.get((Object)o2.getOid());
                if (mIBObject2 != null) {
                    mIBObject2 = this.oids.lowerBound((Object)o2.getOid());
                    while (!mIBObject2.atEnd() && (mIBObject = (MIBObject)((Pair)mIBObject2.get()).second).getOid().equals(o2.getOid())) {
                        if (mIBObject.getModuleID().equals(moduleID) && mIBObject.getName().equals(o2.getName())) {
                            this.oids.remove((Enumeration)((Object)mIBObject2));
                            break;
                        }
                        mIBObject2.advance();
                    }
                }
            }
        }
        serializable = this;
        synchronized (serializable) {
            mIBObject2 = (MIBObject)this.onames.get((Object)o2.getName());
            if (mIBObject2 != null) {
                mIBObject2 = this.onames.lowerBound((Object)o2.getName());
                while (!mIBObject2.atEnd() && (mIBObject = (MIBObject)((Pair)mIBObject2.get()).second).getName().equals(o2.getName())) {
                    if (mIBObject.getModuleID().equals(moduleID) && (o2.getOid() == null && mIBObject.getOid() == null || o2.getOid() != null && o2.getOid().equals(mIBObject.getOid()))) {
                        this.onames.remove((Enumeration)((Object)mIBObject2));
                        break;
                    }
                    mIBObject2.advance();
                }
            }
        }
        if (o2 instanceof MIBModule) {
            void var2_4;
            this.modules.remove(((MIBModule)o2).getModuleName());
            this.moduleIDs.remove(var2_4.getModuleID());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeObject(MIBObject o2) {
        if (o2.getModuleID() != null) {
            this.removeObject(o2.getModuleID(), o2);
            return;
        }
        MIBRepository mIBRepository = this;
        synchronized (mIBRepository) {
            void var1_1;
            this.oids.remove((Object)o2.getOid());
            this.onames.remove((Object)var1_1.getName());
            return;
        }
    }

    public synchronized boolean removeModule(String moduleName) {
        MIBModule mIBModule;
        if ((mIBModule = this.modules.get(mIBModule)) != null) {
            this.remove(mIBModule);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public MIBModule getModule(String moduleName) {
        void var1_1;
        return this.modules.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public MIBModule getModule(Integer moduleID) {
        void var1_1;
        return this.moduleIDs.get(var1_1);
    }

    public MIBObject getObject(String name) {
        String[] stringArray = MIBRepository.splitObjectName(name);
        if (stringArray[0] != null) {
            return this.getObject(stringArray[0], stringArray[1]);
        }
        return (MIBObject)this.onames.get((Object)stringArray[1]);
    }

    private static String[] splitObjectName(String name) {
        String string;
        if (name != null && name.length() > 2 && Character.isUpperCase(name.charAt(0)) && name.indexOf(46) > 0) {
            String string2 = name.substring(0, name.indexOf(46));
            String string3 = name;
            string = string3.substring(string3.indexOf(46) + 1);
            return new String[]{string2, string};
        }
        return new String[]{null, string};
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getObject(ObjectID oid) {
        void var1_1;
        return (MIBObject)this.oids.get((Object)var1_1);
    }

    public Enumeration<MIBModule> modules() {
        return new EnumerationIterator<MIBModule>(this.modules.values().iterator());
    }

    public Iterator<MIBModule> modulesIterator() {
        return this.modules.values().iterator();
    }

    public Enumeration<? extends MIBModule> getModulesSortedByName() {
        OrderedMap orderedMap = new OrderedMap((BinaryPredicate)LexicographicPredicate.instance);
        Enumeration<MIBModule> enumeration = this.modules();
        while (enumeration.hasMoreElements()) {
            MIBModule mIBModule = enumeration.nextElement();
            orderedMap.put((Object)mIBModule.getModuleName(), (Object)mIBModule);
        }
        return orderedMap.elements();
    }

    public Vector<String> getModuleNames() {
        Vector<String> vector = new Vector<String>(this.modules.size() + 1);
        for (MIBModule mIBModule : this.modules.values()) {
            vector.add(mIBModule.getModuleName());
        }
        return vector;
    }

    public Enumeration<? extends MIBObject> objects() {
        return this.oids.elements();
    }

    public Enumeration<? extends MIBObject> objectsByName() {
        return this.onames.elements();
    }

    /*
     * WARNING - void declaration
     */
    public OrderedMapIterator find(ObjectID oid) {
        void var1_1;
        return this.oids.find((Object)var1_1);
    }

    public OrderedMapIterator firstOID() {
        return this.oids.begin();
    }

    /*
     * WARNING - void declaration
     */
    private void addToModule(MIBObject o2) throws ObjectIDFormatException {
        MIBModule mIBModule = this.moduleIDs.get(o2.getModuleID());
        if (mIBModule != null) {
            mIBModule.add(o2);
        }
        if (o2 instanceof MIBObjectType) {
            void var1_1;
            this.initColumnarObjectInfoOnTable((MIBObjectType)var1_1);
        }
    }

    private void initColumnarObjectInfoOnTable(MIBObjectType ot) {
        if (ot.isTable()) {
            Object object;
            Object[] objectArray = ot.getTableEntries();
            Arrays.sort(objectArray);
            object = this.getChildren((MIBObject)object);
            object = object.iterator();
            while (object.hasNext()) {
                MIBObject mIBObject = (MIBObject)object.next();
                if (!(mIBObject instanceof MIBObjectType)) continue;
                ((MIBObjectType)mIBObject).setColumnarObject(Arrays.binarySearch(objectArray, (mIBObject = (MIBObjectType)mIBObject).getName()) >= 0);
            }
        }
    }

    public synchronized void structureChanged() {
        Object object;
        Object object2 = this.oids.elements();
        while (object2.hasMoreElements()) {
            object = (MIBObject)object2.nextElement();
            try {
                this.addToModule((MIBObject)object);
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.out.println("Repository: could not add object " + ((MIBObject)object).getName() + " because of invalid oid " + ((MIBObject)object).getOid().toString() + ".");
            }
        }
        object2 = new MIBObject();
        object = this.onames.elements();
        while (object.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)object.nextElement();
            if (!(mIBObject instanceof MIBTextualConvention) && !mIBObject.getClass().equals(object2.getClass())) continue;
            try {
                this.addToModule(mIBObject);
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                System.out.println("Repository: could not add object " + mIBObject.getName() + " because of invalid oid " + mIBObject.getOid().toString() + ".");
            }
        }
    }

    public String getPath(ObjectID oid, boolean withID) {
        StringTokenizer stringTokenizer;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (oid == null) {
            return "";
        }
        stringTokenizer = new StringTokenizer(((ObjectID)((Object)stringTokenizer)).toString(), ".", false);
        int n2 = stringTokenizer.countTokens();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(".");
                stringBuilder2.append(".");
            }
            String string = stringTokenizer.nextToken();
            stringBuilder.append(string);
            String string2 = stringBuilder.toString();
            String string3 = this.getObjectName(new ObjectID(string2));
            if (string3 == null && "1".equals(string2)) {
                string3 = "iso";
            }
            if (string3 == null) {
                stringBuilder2.append(string);
                continue;
            }
            if (withID) {
                stringBuilder2.append(string3);
                stringBuilder2.append('(');
                stringBuilder2.append(string);
                stringBuilder2.append(')');
                continue;
            }
            stringBuilder2.append(string3);
        }
        return stringBuilder2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getPath(ObjectID oid) {
        void var1_1;
        return this.getPath((ObjectID)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public String getPathSuffix(ObjectID oid) {
        void var1_1;
        return this.getPathSuffix((ObjectID)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public String getPathSuffix(ObjectID oid, boolean unique) {
        MIBObject mIBObject;
        void var2_2;
        Object object;
        MIBObject[] mIBObjectArray;
        StringTokenizer stringTokenizer;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        if (oid == null) {
            return "";
        }
        ObjectID objectID = null;
        stringTokenizer = new StringTokenizer(((ObjectID)((Object)stringTokenizer)).toString(), ".", false);
        int n2 = stringTokenizer.countTokens();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(".");
                stringBuilder2.append(".");
            }
            mIBObjectArray = stringTokenizer.nextToken();
            stringBuilder.append((String)mIBObjectArray);
            object = new ObjectID(stringBuilder.toString());
            String string = this.getObjectName((ObjectID)object);
            if (string == null) {
                stringBuilder2.append((String)mIBObjectArray);
                continue;
            }
            stringBuilder2 = new StringBuilder(string);
            objectID = object;
        }
        if (var2_2 != false && objectID != null && (mIBObject = this.getObject(objectID)) != null && (mIBObjectArray = this.getObjectsByName(mIBObject.getName())) != null && mIBObjectArray.length > 1 && (object = this.getModuleName(mIBObject.getModuleID())) != null) {
            stringBuilder2 = new StringBuilder((String)object + "." + stringBuilder2.toString());
        }
        return stringBuilder2.toString();
    }

    public static MIBRepository loadFromFile(File path) {
        MIBRepository mIBRepository = null;
        try {
            InputStream inputStream = new FileInputStream(path);
            inputStream = new ObjectInputStream(inputStream);
            mIBRepository = new MIBRepository();
            int n2 = ((ObjectInputStream)inputStream).readInt();
            for (int i2 = 0; i2 < n2; ++i2) {
                MIBObject mIBObject = (MIBObject)((ObjectInputStream)inputStream).readObject();
                if (mIBObject instanceof MIBModule) {
                    ((MIBModule)mIBObject).reinit();
                }
                mIBRepository.addObject(mIBObject);
            }
            ((ObjectInputStream)inputStream).close();
            mIBRepository.structureChanged();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("MIB repository " + path + " not found.");
        }
        catch (StreamCorruptedException streamCorruptedException) {
            System.out.println("MIB repository " + path + " corrupted.");
        }
        catch (IOException iOException) {
            System.out.println("IO error while reading MIB repository " + path + ".");
        }
        catch (ClassNotFoundException classNotFoundException) {
            File file;
            System.out.println("Class not found (" + classNotFoundException.getMessage() + ") while reading MIB repository " + file + ".");
        }
        return mIBRepository;
    }

    public static boolean saveToFile(MIBRepository rep, File path) {
        try {
            MIBRepository mIBRepository;
            OutputStream outputStream;
            outputStream = new FileOutputStream((File)((Object)outputStream));
            outputStream = new ObjectOutputStream(outputStream);
            Object object = rep.getTextualConventions();
            ((ObjectOutputStream)outputStream).writeInt(rep.oids.size() + ((Vector)object).size());
            object = ((Vector)object).elements();
            while (object.hasMoreElements()) {
                ((ObjectOutputStream)outputStream).writeObject(object.nextElement());
            }
            object = mIBRepository.oids.elements();
            while (object.hasMoreElements()) {
                ((ObjectOutputStream)outputStream).writeObject(object.nextElement());
            }
            ((ObjectOutputStream)outputStream).flush();
            ((ObjectOutputStream)outputStream).close();
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return false;
        }
        return true;
    }

    public Vector<? extends MIBTextualConvention> getTextualConventions() {
        return this.getNonOidObjects(true);
    }

    public Vector<? extends MIBObject> getNonOidObjects(boolean textualConventionsOnly) {
        Vector<MIBObject> vector = new Vector<MIBObject>(this.onames.size() / 50, 50);
        Enumeration enumeration = this.onames.elements();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            if ((textualConventionsOnly || !mIBObject.getOid().isEmpty()) && !(mIBObject instanceof MIBTextualConvention)) continue;
            vector.add(mIBObject);
        }
        return vector;
    }

    public MIBSyntax resolveTC(String name) {
        Object object;
        MIBSyntax mIBSyntax = null;
        while ((object = (MIBObject)this.onames.get((Object)name)) != null) {
            if (object instanceof MIBTextualConvention) {
                if (((MIBTextualConvention)(object = (MIBTextualConvention)object)).getSyntax().getType() == 3) {
                    mIBSyntax = ((MIBTextualConvention)object).getSyntax();
                    object = ((MIBTextualConvention)object).getSyntax().getSyntax();
                    continue;
                }
                return ((MIBTextualConvention)object).getSyntax();
            }
            return mIBSyntax;
        }
        return mIBSyntax;
    }

    /*
     * WARNING - void declaration
     */
    public ObjectID resolveOID(ObjectID oid) {
        String string = oid.getFirstUnresolvedSubId();
        if (string == null) {
            return oid;
        }
        Object object = this.getObjectID(string);
        if (object != null) {
            int n2 = oid.toString().indexOf(string) + string.length();
            object = ((ObjectID)object).toString();
            if (n2 >= 0 && n2 < oid.toString().length()) {
                void var1_1;
                object = (String)object + var1_1.toString().substring(n2);
            }
            return new ObjectID((String)object);
        }
        return null;
    }

    public MIBSyntax getBaseSyntax(MIBSyntax syntax) {
        MIBSyntax mIBSyntax = syntax;
        if (mIBSyntax.getType() == 3) {
            try {
                MIBTextualConvention mIBTextualConvention = (MIBTextualConvention)this.getObject(mIBSyntax.getSyntax());
                if (mIBTextualConvention != null) {
                    mIBSyntax = mIBTextualConvention.getSyntax();
                }
            }
            catch (ClassCastException classCastException) {
                return mIBSyntax;
            }
        }
        return mIBSyntax;
    }

    private MIBObject getBestObject(String syntax) {
        Range range = this.onames.equalRange((Object)syntax);
        if (range == null || range.begin.atEnd()) {
            return null;
        }
        MIBObject mIBObject = null;
        MIBObject mIBObject2 = null;
        while (range.begin.hasMoreElements()) {
            if (((Pair)range.begin.get()).first.equals(syntax)) {
                MIBObject mIBObject3 = (MIBObject)((Pair)range.begin.get()).second;
                MIBModule mIBModule = this.getModule(mIBObject3.getModuleID());
                if (mIBModule != null && mIBModule.getSMIVersion() > 1) {
                    mIBObject = mIBObject3;
                    break;
                }
                mIBObject2 = mIBObject3;
            }
            range.begin.advance();
        }
        if (mIBObject != null) {
            return mIBObject;
        }
        return mIBObject2;
    }

    /*
     * WARNING - void declaration
     */
    public MIBTextualConvention getEffectiveSyntax(MIBSyntax syntax) {
        void var1_1;
        return this.getEffectiveSyntax((ISyntax)var1_1);
    }

    public MIBTextualConvention getEffectiveSyntax(ISyntax syntax) {
        MIBObject mIBObject;
        MIBSyntax mIBSyntax = new MIBSyntax();
        Object object = syntax;
        MIBTextualConvention mIBTextualConvention = new MIBTextualConvention();
        if (syntax.hasEnums()) {
            mIBSyntax.setEnums((MIBEnum[])object.getEnums());
        }
        if (mIBObject.hasRanges()) {
            mIBSyntax.setRanges((MIBRange[])object.getRanges());
        }
        mIBTextualConvention.setSyntax(mIBSyntax);
        while ((mIBObject = this.getBestObject(object.getSyntax())) != null) {
            if (mIBObject instanceof MIBTextualConvention) {
                Serializable serializable;
                mIBObject = (MIBTextualConvention)mIBObject;
                if (mIBTextualConvention.getName() == null) {
                    mIBTextualConvention.setName(mIBObject.getName());
                }
                if (((MIBTextualConvention)mIBObject).hasDisplayHint()) {
                    mIBTextualConvention.setDisplayHint(((MIBTextualConvention)mIBObject).getDisplayHint());
                }
                if (((MIBTextualConvention)mIBObject).getSyntax().hasEnums()) {
                    object = ((MIBTextualConvention)mIBObject).getSyntax().getEnumsVector().elements();
                    while (object.hasMoreElements()) {
                        serializable = (MIBEnum)((Object)object.nextElement());
                        if (!mIBSyntax.hasEnums()) {
                            mIBSyntax.addEnum(new MIBEnum((SMIEnum)((Object)serializable)));
                            continue;
                        }
                        mIBSyntax.getEnumsVector().removeElement(serializable);
                        mIBSyntax.addEnum(new MIBEnum((SMIEnum)((Object)serializable)));
                    }
                } else if (((MIBTextualConvention)mIBObject).getSyntax().hasRanges()) {
                    object = ((MIBTextualConvention)mIBObject).getSyntax().getRangesVector().elements();
                    while (object.hasMoreElements()) {
                        serializable = (MIBRange)object.nextElement();
                        if (mIBSyntax.containsRange((MIBRange)serializable) || !mIBSyntax.isRestrictiveRange((MIBRange)serializable)) continue;
                        mIBSyntax.addRange((MIBRange)serializable);
                    }
                }
                if (((MIBTextualConvention)mIBObject).getSyntax().getType() == 3) {
                    object = ((MIBTextualConvention)mIBObject).getSyntax();
                    continue;
                }
                mIBSyntax.setSyntax(((MIBTextualConvention)mIBObject).getSyntax().getSyntax());
                mIBSyntax.setType(((MIBTextualConvention)mIBObject).getSyntax().getType());
                return mIBTextualConvention;
            }
            return mIBTextualConvention;
        }
        mIBSyntax.setSyntax(object.getSyntax());
        mIBSyntax.setType(object.getType());
        return mIBTextualConvention;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReferencedBy(String objectName, MIBModule module, MIBComplianceModule complianceModule) {
        void var2_2;
        Object object = MIBRepository.splitObjectName(objectName);
        Iterator iterator = object[0];
        object = object[1];
        if (iterator != null && (module.getModuleName() != null ? !((String)((Object)iterator)).equals(module.getModuleName()) : !((String)((Object)iterator)).equals(module.getModuleName()))) {
            return false;
        }
        if (complianceModule.hasMandatory()) {
            for (Object object2 : complianceModule.getMandatoryVector()) {
                if (!((object2 = var2_2.getObject((String)object2)) instanceof MIBGroup) || !((MIBGroup)(object2 = (MIBGroup)object2)).contains((String)object)) continue;
                return true;
            }
        }
        if (complianceModule.hasVariations()) {
            void var3_3;
            for (Object object2 : var3_3.getVariationsVector()) {
                if (!(object2 instanceof MIBCondGroup) || !((object2 = var2_2.getObject(((MIBVariation)object2).getVariation())) instanceof MIBGroup) || !((MIBGroup)(object2 = (MIBGroup)object2)).contains((String)object)) continue;
                return true;
            }
        }
        return false;
    }

    public String printModule(String moduleName) {
        MIBModule mIBModule;
        if ((mIBModule = this.getModule((String)((Object)mIBModule))) == null) {
            return "";
        }
        return mIBModule.toSMI(1, this, MIBObject.getLineSeparator());
    }

    public static <T> Vector<T> buildVector(T[] objects) {
        T[] TArray;
        if (objects == null) {
            return null;
        }
        Vector<T> vector = new Vector<T>(objects.length > 0 ? objects.length : 1);
        vector.addAll(Arrays.asList(TArray));
        return vector;
    }

    public static String buildStringEnumeration(Enumeration en, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        while (en.hasMoreElements()) {
            stringBuilder.append(prefix).append(en.nextElement().toString());
            if (!en.hasMoreElements()) continue;
            stringBuilder.append(",\n");
        }
        return stringBuilder.toString();
    }

    public static String buildStringEnumeration(Iterator it, String prefix) {
        StringBuilder stringBuilder = new StringBuilder();
        while (it.hasNext()) {
            stringBuilder.append(prefix + it.next().toString());
            if (!it.hasNext()) continue;
            stringBuilder.append(",\n");
        }
        return stringBuilder.toString();
    }

    public static String buildStringEnumeration(Enumeration en) {
        StringBuilder stringBuilder = new StringBuilder();
        while (en.hasMoreElements()) {
            stringBuilder.append((String)en.nextElement());
            if (!en.hasMoreElements()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void renameModule(MIBModule oldModule, String newModuleName) {
        void var1_1;
        void var2_2;
        this.modules.remove(oldModule.getModuleName());
        oldModule.setModuleName(newModuleName);
        this.modules.put((String)var2_2, (MIBModule)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void renameObject(MIBObject oldObject, ObjectID newObjectID, String newObjectName) {
        Object object;
        Object object2;
        if (!oldObject.getName().equals(newObjectName)) {
            void var3_3;
            if (oldObject.getModuleID() != null) {
                object2 = this.moduleIDs.get(oldObject.getModuleID());
                if (object2 != null) {
                    ((MIBModule)object2).remove(oldObject);
                    if (!oldObject.getName().equals(newObjectName)) {
                        ((MIBModule)object2).changeObjectReferences(oldObject.getName(), newObjectName);
                    }
                }
                object = this.onames.begin();
                while (object.hasMoreElements()) {
                    object2 = (MIBObject)((Pair)object.get()).second;
                    if (((MIBObject)object2).equals(oldObject)) {
                        this.onames.remove((Enumeration)object);
                        break;
                    }
                    object.advance();
                }
            }
            oldObject.setName(newObjectName);
            this.onames.add((Object)var3_3, (Object)oldObject);
        }
        if (!oldObject.getOid().equals(newObjectID)) {
            void var1_1;
            void var2_2;
            object2 = this.oids.begin();
            while (object2.hasMoreElements()) {
                object = (MIBObject)((Pair)object2.get()).second;
                if (object == oldObject) {
                    this.oids.remove((Enumeration)object2);
                    break;
                }
                object2.advance();
            }
            oldObject.setOid(newObjectID);
            this.oids.add((Object)var2_2, (Object)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Vector<MIBObjectType> getColumnarObjectsOfTable(MIBModule m2, MIBObjectType ot, boolean includeIndex, boolean includeColumns) {
        Object object;
        void var3_3;
        if (ot == null || !ot.isTable()) {
            return null;
        }
        Vector<MIBObjectType> vector = new Vector<MIBObjectType>();
        if (m2 == null) {
            return null;
        }
        if (var3_3 != false) {
            Object object2;
            Object object3 = ot;
            if (ot.getIndexPart().isAugment()) {
                int n2;
                object = this.getObjectsByName(ot.getIndexPart().getIndexPart()[0]);
                object3 = null;
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    if (!((MIBObject)object[n2]).getModuleID().equals(ot.getModuleID())) continue;
                    object3 = object[n2];
                    break;
                }
                if (object3 == null) {
                    for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                        object2 = this.getModuleName(((MIBObject)object[n2]).getModuleID());
                        if (object2 == null || !m2.imports(((MIBObject)object[n2]).getName(), (String)object2)) continue;
                        object3 = object[n2];
                        break;
                    }
                } else if (((Object)object).length == 1) {
                    object3 = object[0];
                }
                object3 = (MIBObjectType)object3;
            }
            if (object3 != null && ((MIBObjectType)object3).hasIndexPart()) {
                object = ((MIBObjectType)object3).getIndexPart().getIndexPartVector().elements();
                while (object.hasMoreElements()) {
                    object3 = this.getObjectsByName((String)object.nextElement());
                    MIBObject mIBObject = null;
                    if (((MIBObject[])object3).length > 1) {
                        MIBObject mIBObject2;
                        int n3;
                        object2 = object3;
                        int n4 = ((MIBObject[])object3).length;
                        for (n3 = 0; n3 < n4; ++n3) {
                            mIBObject2 = object2[n3];
                            if (!mIBObject2.getModuleID().equals(ot.getModuleID()) || !(mIBObject2 instanceof MIBObjectType)) continue;
                            mIBObject = mIBObject2;
                            break;
                        }
                        if (mIBObject == null) {
                            object2 = object3;
                            n4 = ((MIBObject[])object3).length;
                            for (n3 = 0; n3 < n4; ++n3) {
                                mIBObject2 = object2[n3];
                                object3 = this.getModule(mIBObject2.getModuleID());
                                if (object3 == null || !m2.imports(mIBObject2.getName(), ((MIBModule)object3).getModuleName()) || !(mIBObject2 instanceof MIBObjectType)) continue;
                                mIBObject = mIBObject2;
                                break;
                            }
                        }
                    } else if (((MIBObject[])object3).length == 1) {
                        mIBObject = object3[0];
                    }
                    if (mIBObject == null) continue;
                    vector.add((MIBObjectType)mIBObject);
                }
            } else {
                return null;
            }
        }
        if (includeColumns) {
            void var2_2;
            Enumeration enumeration = var2_2.getTableEntriesVector().elements();
            while (enumeration.hasMoreElements()) {
                object = (MIBObjectType)this.getObject(m2.getModuleName(), (String)enumeration.nextElement());
                if (object == null || SMI.accessType(((MIBObjectType)object).getAccess()) == 0) continue;
                vector.add((MIBObjectType)object);
            }
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    public Vector<? extends MIBObjectType> getColumnarObjectsOfTable(MIBObjectType ot, boolean includeIndex, boolean includeColumns) {
        void var3_3;
        void var2_2;
        void var1_1;
        MIBModule mIBModule = this.getModule(ot.getModuleID());
        return this.getColumnarObjectsOfTable(mIBModule, (MIBObjectType)var1_1, (boolean)var2_2, (boolean)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public List<MIBObject> getNotificationObjects(INotificationType nt) {
        void var1_1;
        MIBModule mIBModule = this.getModule(nt.getModuleID());
        return this.getNotificationObjects(mIBModule, (INotificationType)var1_1);
    }

    public List<MIBObject> getNotificationObjects(MIBModule module, INotificationType nt) {
        ArrayList<MIBObject> arrayList = new ArrayList<MIBObject>();
        if (nt.getVariablesVector() == null) {
            return arrayList;
        }
        for (String mIBObjectArray : nt.getVariablesVector()) {
            MIBObject[] n2 = this.getObjectsByName(mIBObjectArray);
            MIBObject mIBObject = null;
            if (n2.length > 1) {
                for (int mIBObjectArray2 = 0; mIBObjectArray2 < n2.length; ++mIBObjectArray2) {
                    if (!n2[mIBObjectArray2].getModuleID().equals(nt.getModuleID())) continue;
                    mIBObject = n2[mIBObjectArray2];
                    break;
                }
                if (mIBObject == null) {
                    MIBObject[] mIBObjectArray2 = n2;
                    int n3 = n2.length;
                    for (int i2 = 0; i2 < n3; ++i2) {
                        MIBObject mIBObject2 = mIBObjectArray2[i2];
                        MIBModule mIBModule = this.getModule(mIBObject2.getModuleID());
                        if (mIBModule == null || !module.imports(mIBObject2.getName(), mIBModule.getModuleName())) continue;
                        mIBObject = mIBObject2;
                        break;
                    }
                }
            } else if (n2.length == 1) {
                mIBObject = n2[0];
            }
            if (mIBObject != null) {
                arrayList.add(mIBObject);
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public Vector<? extends MIBObjectType> getAugmentingTables(MIBObjectType table) {
        MIBModule mIBModule = this.getModule(table.getModuleID());
        Vector<MIBObjectType> vector = new Vector<MIBObjectType>();
        Enumeration<? extends MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            if (!(mIBObject instanceof MIBObjectType) || !((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject)).isTable() || !((MIBObjectType)mIBObject).hasIndexPart() || !((MIBObjectType)mIBObject).getIndexPart().isAugment() || !((MIBObjectType)mIBObject).getIndexPart().getIndexPart()[0].equals(table.getName())) continue;
            this.getParentTables(table, mIBModule, vector, (MIBObjectType)mIBObject);
        }
        return vector;
    }

    public boolean isExpandingIndex(MIBIndexPart parent, MIBIndexPart expansion) {
        Vector vector;
        Vector vector2;
        if (parent == null || expansion == null) {
            return false;
        }
        vector2 = ((MIBIndexPart)((Object)vector2)).getIndexPartVector();
        if ((vector = ((MIBIndexPart)((Object)vector)).getIndexPartVector()).size() < vector2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            if (vector2.elementAt(i2).equals(vector.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public Vector<? extends MIBObjectType> getParentTables(MIBObjectType table) {
        MIBModule mIBModule = this.getModule(table.getModuleID());
        Vector<MIBObjectType> vector = new Vector<MIBObjectType>();
        Enumeration<? extends MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            if (!(mIBObject instanceof MIBObjectType)) continue;
            if (((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject)).isTable() && ((MIBObjectType)mIBObject).hasIndexPart() && ((MIBObjectType)mIBObject).getIndexPart().isAugment() && ((MIBObjectType)mIBObject).getIndexPart().getIndexPart()[0].equals(table.getName())) {
                this.getParentTables(table, mIBModule, vector, (MIBObjectType)mIBObject);
                continue;
            }
            if (!((MIBObjectType)mIBObject).isTable() || !((MIBObjectType)mIBObject).hasIndexPart() || mIBObject.getName().equals(table.getName()) || !this.isExpandingIndex(((MIBObjectType)mIBObject).getIndexPart(), table.getIndexPart())) continue;
            vector.addElement((MIBObjectType)mIBObject);
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    private void getParentTables(MIBObjectType table, MIBModule module, Vector<MIBObjectType> parentTableObjectTypes, MIBObjectType parentTableObjectType) {
        MIBModule mIBModule = this.getModule(parentTableObjectType.getModuleID());
        if (module != null && mIBModule != null) {
            void var2_2;
            void var1_1;
            if (mIBModule.getModuleID().equals(module.getModuleID()) || mIBModule.imports(var1_1.getName(), var2_2.getModuleName())) {
                parentTableObjectTypes.addElement(parentTableObjectType);
                return;
            }
        } else {
            void var3_3;
            var3_3.addElement(parentTableObjectType);
        }
    }

    public MIBObjectType getObjectType(ObjectID instanceID) {
        try {
            Object object;
            object = this.getSplittedObjectID((ObjectID)object);
            if (object == null) {
                return null;
            }
            object = (ObjectID)object.first;
            if ((object = this.getObject((ObjectID)object)) instanceof MIBObjectType) {
                return (MIBObjectType)object;
            }
        }
        catch (ObjectIDFormatException objectIDFormatException) {}
        return null;
    }

    public MIBObjectType getTableEntry(MIBObject o2) {
        if (o2 instanceof MIBObjectType) {
            Serializable serializable;
            if (((MIBObjectType)(serializable = (MIBObjectType)serializable)).isTable()) {
                return serializable;
            }
            if (((Vector)(serializable = this.getChildren((MIBObject)serializable))).size() == 0) {
                return null;
            }
            if ((serializable = (MIBObject)((Vector)serializable).firstElement()) instanceof MIBObjectType && ((MIBObjectType)serializable).isTable()) {
                return (MIBObjectType)serializable;
            }
        }
        return null;
    }

    public MIBObject getNextObject(ObjectID oid) {
        OrderedMapIterator orderedMapIterator = this.oids.lowerBound((Object)oid);
        while (!orderedMapIterator.atEnd()) {
            MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(oid)) {
                return mIBObject;
            }
            orderedMapIterator.advance();
        }
        return null;
    }

    public MIBObject getPrevObject(ObjectID oid) {
        MIBObject mIBObject;
        OrderedMapIterator orderedMapIterator = this.oids.upperBound((Object)oid);
        while (!(orderedMapIterator.atBegin() || orderedMapIterator.get() != null && (mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second).getOid().equals(oid))) {
            orderedMapIterator.retreat();
        }
        while (!orderedMapIterator.atEnd() && !orderedMapIterator.atBegin()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(oid)) {
                return mIBObject;
            }
            orderedMapIterator.retreat();
        }
        return null;
    }

    public MIBObject getNextSiblingObject(ObjectID oid) {
        OrderedMapIterator orderedMapIterator = this.oids.lowerBound((Object)oid);
        while (!orderedMapIterator.atEnd()) {
            MIBObject mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(oid) && mIBObject.getOid().isPeerOf(oid)) {
                return mIBObject;
            }
            orderedMapIterator.advance();
        }
        return null;
    }

    public MIBObject getPrevSibblingObject(ObjectID oid) {
        MIBObject mIBObject;
        OrderedMapIterator orderedMapIterator = this.oids.upperBound((Object)oid);
        if (!orderedMapIterator.atBegin() && orderedMapIterator.atEnd()) {
            orderedMapIterator.retreat();
        }
        while (!orderedMapIterator.atBegin() && !(mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second).getOid().equals(oid)) {
            orderedMapIterator.retreat();
        }
        while (!orderedMapIterator.atBegin()) {
            mIBObject = (MIBObject)((Pair)orderedMapIterator.get()).second;
            if (!mIBObject.getOid().equals(oid) && mIBObject.getOid().isPeerOf(oid)) {
                return mIBObject;
            }
            orderedMapIterator.retreat();
        }
        return null;
    }

    private static <K, V> Map<V, K> invertMap(Map<K, V> map) {
        HashMap<V, K> hashMap = new HashMap<V, K>(map.size());
        for (K k2 : map.keySet()) {
            V v = map.get(k2);
            hashMap.put(v, k2);
        }
        return hashMap;
    }

    public Map<Integer, String> getImportedModuleIDs() {
        return this.importedModuleIDs;
    }

    public Map<Integer, String> addImportedModuleIDsInverted(Map<String, Integer> moduleIDs) {
        Map<Integer, String> map = MIBRepository.invertMap(moduleIDs);
        this.addImportedModuleIDs(map);
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public void removeImportedModuleID(Integer moduleID) {
        void var1_1;
        this.importedModuleIDs.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void addImportedModuleIDs(Map<Integer, String> moduleIDs) {
        void var1_1;
        this.importedModuleIDs.putAll((Map<Integer, String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String getModuleName(Integer moduleID) {
        void var1_1;
        MIBModule mIBModule = this.moduleIDs.get(moduleID);
        if (mIBModule != null) {
            return mIBModule.getModuleName();
        }
        return this.importedModuleIDs.get(var1_1);
    }

    public void freeUserObjects() {
        Enumeration<? extends MIBObject> enumeration = this.objectsByName();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            mIBObject.freeUserObjects();
        }
    }
}

