/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.CompareResult;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IObjectID;
import com.agentpp.smi.ext.SMIObject;
import com.agentpp.smiparser.SMI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class MIBObject
implements SMIObject,
Serializable {
    public static final long serialVersionUID = 1000L;
    public String name = null;
    protected String descr = null;
    protected String reference = null;
    protected String status = null;
    protected ObjectID oid = null;
    public Integer moduleID = -1;
    public transient Object userObject = null;
    private int type = 10;
    protected String asn1Comment = null;
    protected int released = 0;
    protected Integer sequenceID = null;
    protected int id;
    protected String asn1CommentInline;
    protected static String lineSeparator = System.getProperty("line.separator", "\n");
    protected static int nextID = MIBObject.nextID();

    public MIBObject() {
        this.oid = new ObjectID();
    }

    public static final String getLineSeparator() {
        return lineSeparator;
    }

    protected static synchronized int nextID() {
        return nextID++;
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject(IObject other) {
        void var1_1;
        if (other.getObjectID() != null) {
            this.oid = new ObjectID(other.getPrintableOid());
        }
        this.name = other.getName();
        if (other.hasDescription()) {
            this.descr = other.getDescription();
        }
        if (other.hasReference()) {
            this.reference = other.getReference();
        }
        if (other.hasStatus()) {
            this.status = other.getStatus();
        }
        this.moduleID = new Integer(other.getModuleID());
        if (other instanceof MIBObject) {
            MIBObject mIBObject = (MIBObject)other;
            if (mIBObject.userObject != null) {
                this.userObject = mIBObject.userObject;
            }
            this.released = mIBObject.released;
            this.sequenceID = mIBObject.sequenceID;
            this.id = mIBObject.id;
        }
        this.type = other.getType();
        this.asn1Comment = other.getComment();
        this.setInlineComment(var1_1.getInlineComment());
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject(String name) {
        this(new ObjectID(), (String)var1_1, -1);
        void var1_1;
    }

    public MIBObject(Object moduleID) {
        this(new ObjectID(), null, -1);
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject(ObjectID oid, String name) {
        this((ObjectID)var1_1, (String)var2_2, -1);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject(String name, Integer moduleID) {
        this(new ObjectID(), (String)var1_1, (Integer)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject(ObjectID oid, String name, Integer moduleID) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.moduleID = var3_3;
        this.oid = var1_1;
        this.name = var2_2;
        this.type = 10;
    }

    public int compareTo(Object o2) {
        MIBObject mIBObject = (MIBObject)o2;
        if (this.getOid() != null) {
            return this.getOid().compareTo(mIBObject.getOid());
        }
        return this.getName().compareTo(mIBObject.getName());
    }

    public MIBObject getClone() {
        return new MIBObject(this);
    }

    @Override
    public IObject getDeepClone() {
        return this.getClone();
    }

    @Override
    public String getTypeString() {
        return SMI.ENTRY_TYPES[this.type];
    }

    @Override
    public int getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setStatus(String status) {
        void var1_1;
        this.status = var1_1;
        if (this.status != null && this.status.length() > 0) {
            this.type = 0;
        }
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public final Integer getModuleID() {
        return this.moduleID;
    }

    /*
     * WARNING - void declaration
     */
    public final void setModuleID(Integer id) {
        void var1_1;
        this.moduleID = var1_1;
    }

    public final boolean hasValidModuleID() {
        return this.moduleID >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setName(String name) {
        void var1_1;
        this.name = var1_1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDescription(String descr) {
        void var1_1;
        this.descr = var1_1;
    }

    @Override
    public String getDescription() {
        return this.descr;
    }

    public void setDescrAsChars(Character[] d2) {
        if (d2 != null) {
            char[] cArray = new char[d2.length];
            for (int i2 = 0; i2 < d2.length; ++i2) {
                cArray[i2] = d2[i2].charValue();
            }
            this.descr = new String(cArray);
            return;
        }
        this.descr = null;
    }

    @Override
    public final boolean hasDescription() {
        return this.descr != null;
    }

    @Override
    public final boolean hasReference() {
        return this.reference != null;
    }

    public Character[] getDescrAsChars() {
        if (this.descr == null) {
            return null;
        }
        char[] cArray = new char[this.descr.length()];
        this.descr.getChars(0, this.descr.length(), cArray, 0);
        Character[] characterArray = new Character[cArray.length];
        for (int i2 = 0; i2 < characterArray.length; ++i2) {
            characterArray[i2] = new Character(cArray[i2]);
        }
        return characterArray;
    }

    /*
     * WARNING - void declaration
     */
    public final void setReference(String ref) {
        void var1_1;
        this.reference = var1_1;
    }

    @Override
    public final String getReference() {
        return this.reference;
    }

    /*
     * WARNING - void declaration
     */
    public final void setOid(ObjectID oid) {
        void var1_1;
        this.oid = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setOid(String oid_str) {
        void var1_1;
        this.oid = new ObjectID((String)var1_1);
    }

    public final ObjectID getOid() {
        return this.oid;
    }

    @Override
    public final IObjectID getObjectID() {
        return this.oid;
    }

    @Override
    public final String getPrintableOid() {
        return this.oid.toString();
    }

    public final Integer getSequenceID() {
        return this.sequenceID;
    }

    public final boolean hasSequenceID() {
        return this.sequenceID != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSequenceID(Integer sequenceID) {
        void var1_1;
        this.sequenceID = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected String getSMIDefBegin(int mode, String lineSeparator) {
        MIBObject mIBObject = this.comparable(mode);
        StringBuffer stringBuffer = new StringBuffer("\t");
        MIBObject.addKeyWord(mode, stringBuffer, "STATUS  ");
        if (this.status == null || this.status.length() == 0) {
            stringBuffer.append("current");
        } else if (mode == 8) {
            stringBuffer.append(SMI.convertStatusToSMIv2(this.status));
        } else {
            if (mIBObject != null && mIBObject.status != null && !mIBObject.status.equals(this.status)) {
                stringBuffer.append("<u>");
            }
            stringBuffer.append(this.status);
            if (mIBObject != null && mIBObject.status != null && !mIBObject.status.equals(this.status)) {
                stringBuffer.append("</u>");
            }
        }
        stringBuffer.append(lineSeparator);
        stringBuffer.append("\t");
        MIBObject.addKeyWord(mode, stringBuffer, "DESCRIPTION");
        if (this.descr == null) {
            stringBuffer.append(" \"\"" + lineSeparator);
        } else {
            stringBuffer.append(lineSeparator);
            MIBObject.addText(lineSeparator, mode, stringBuffer, MIBObject.formatLines("\t\t", this.descr), mIBObject == null ? null : MIBObject.formatLines("\t\t", mIBObject.descr));
            stringBuffer.append(lineSeparator);
        }
        String string = this.getSMIBeforeReference(mode, lineSeparator, mIBObject);
        if (string != null) {
            stringBuffer.append(string);
        }
        if (this.reference != null) {
            void var2_2;
            void var1_1;
            stringBuffer.append("\t");
            MIBObject.addKeyWord(mode, stringBuffer, "REFERENCE");
            stringBuffer.append(lineSeparator);
            MIBObject.addText(lineSeparator, (int)var1_1, stringBuffer, MIBObject.formatLines("\t\t", this.reference), mIBObject == null ? null : mIBObject.reference);
            stringBuffer.append((String)var2_2);
        }
        return stringBuffer.toString();
    }

    protected String getSMIBeforeReference(int mode, String lineSeparator, MIBObject c2) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static int minWhiteSpacePrefix(String lines, boolean countFirstLine) {
        void var1_1;
        Object object;
        int n2 = Integer.MAX_VALUE;
        if (((StringTokenizer)(object = new StringTokenizer((String)object, "\r\n"))).hasMoreTokens() && var1_1 == false) {
            ((StringTokenizer)object).nextToken();
        }
        block0: while (n2 > 0 && ((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken();
            for (int i2 = 0; i2 < string.length() && i2 < n2; ++i2) {
                if (Character.isWhitespace(string.charAt(i2))) continue;
                n2 = i2;
                continue block0;
            }
        }
        return n2;
    }

    public static String trimLines(String lines) {
        StringTokenizer stringTokenizer;
        lines = MIBObject.getUnquotedString(lines);
        int n2 = MIBObject.minWhiteSpacePrefix(lines, false);
        stringTokenizer = new StringTokenizer((String)((Object)stringTokenizer), "\r\n", true);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ((string = MIBObject.addStringWithInternalLineSeparation(stringBuffer, string, stringTokenizer)) == null) continue;
            if (!bl) {
                string = MIBObject.cutTrailingWhiteSpaces(string);
            }
            if (bl) {
                stringBuffer.append(string.trim());
                bl = false;
                continue;
            }
            if (string.length() > n2) {
                stringBuffer.append(string.substring(n2));
                continue;
            }
            stringBuffer.append(string);
        }
        return MIBObject.getQuotedString(stringBuffer.toString());
    }

    protected static String cutTrailingWhiteSpaces(String s) {
        for (int i2 = s.length() - 1; i2 >= 0; --i2) {
            if (Character.isWhitespace(s.charAt(i2))) continue;
            return s.substring(0, i2 + 1);
        }
        return "";
    }

    public static String formatLines(String prefix, String lines) {
        StringTokenizer stringTokenizer;
        if (lines == null) {
            return prefix + "\"\"";
        }
        stringTokenizer = new StringTokenizer((String)((Object)stringTokenizer), "\n", true);
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\n")) {
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(prefix + string);
        }
        return stringBuilder.toString();
    }

    public static String formatObjectRefs(int mode, String prefix, Iterator en, String lineSeparator) {
        StringBuilder stringBuilder = new StringBuilder();
        while (en.hasNext()) {
            String string = en.next().toString();
            stringBuilder.append(prefix);
            if ((mode & 4) > 0) {
                stringBuilder.append("<a href=\"#").append(string).append("\">").append(string).append("</a>");
            } else {
                stringBuilder.append(string);
            }
            if (!en.hasNext()) continue;
            stringBuilder.append(",");
            stringBuilder.append(lineSeparator);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getGeneratedInlineComment(int mode) {
        if ((mode & 0x20) > 0) {
            void var1_1;
            String string = "-- " + this.getPrintableOid();
            if ((var1_1 & 0x400) > 0) {
                return string + " --";
            }
            return string;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected String getSMIDefEnd(int mode, MIBRepository rep, String inlineComment, String lineSeparator) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasInlineComment()) {
            if (this.getType() == 10 && (mode & 0x20) <= 0) {
                stringBuffer.append(lineSeparator);
            }
            MIBObject.addComment(mode, stringBuffer, MIBObject.formatLines("\t", inlineComment.trim()), lineSeparator);
            stringBuffer.append(lineSeparator);
        }
        if ((mode & 0x20) > 0) {
            void var3_3;
            object = "-- " + this.getPrintableOid();
            if ((mode & 0x400) <= 0) {
                if (!this.hasInlineComment() || !inlineComment.trim().endsWith((String)object)) {
                    stringBuffer.append('\t');
                    MIBObject.addComment(mode, stringBuffer, (String)object, lineSeparator);
                    stringBuffer.append(lineSeparator);
                    stringBuffer.append('\t');
                }
            } else if (!this.hasInlineComment() || !inlineComment.trim().endsWith((String)object) && !var3_3.trim().endsWith((String)object + " --")) {
                object = (String)object + " --";
                MIBObject.addComment(mode, stringBuffer, (String)object + " ", lineSeparator);
                stringBuffer.append(' ');
            } else {
                stringBuffer.append('\t');
            }
        } else {
            stringBuffer.append("\t");
        }
        MIBObject.addKeyWord(mode, stringBuffer, "::= ");
        object = rep.getParent(this);
        if (object == null) {
            stringBuffer.append(this.getOid().toSMI());
        } else if (this instanceof MIBModule && ((MIBObject)object).getModuleID() == this.getModuleID()) {
            while (object != null && ((MIBObject)object).getModuleID() == this.getModuleID()) {
                object = rep.getParent((MIBObject)object);
            }
            if (object == null) {
                stringBuffer.append(this.getOid().toSMI());
            } else {
                stringBuffer.append(this.genSMIOidDef(mode, (MIBObject)object, rep));
            }
        } else {
            void var2_2;
            void var1_1;
            stringBuffer.append(this.genSMIOidDef((int)var1_1, (MIBObject)object, (MIBRepository)var2_2));
        }
        stringBuffer.append(lineSeparator);
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String genSMIOidDef(int mode, MIBObject parent, MIBRepository rep) {
        void var2_2;
        void var1_1;
        void var3_3;
        Object object = rep.getObjectsByName(parent.getName());
        if (object == null || ((MIBObject[])object).length <= 1) {
            return this.getOid().toSMI(rep, mode, parent, null);
        }
        object = rep.getModuleName(parent.getModuleID());
        if (object == null) {
            return this.getOid().toSMI(rep, mode, parent, null);
        }
        return this.getOid().toSMI((MIBRepository)var3_3, (int)var1_1, (MIBObject)var2_2, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    public static void addString(int mode, StringBuffer buf, String s, String os) {
        if ((mode & 2) > 0) {
            void var3_3;
            if (os != null && !os.equals(s)) {
                buf.append("<u>");
            }
            buf.append(s);
            if (os != null && !var3_3.equals(s)) {
                buf.append("</u>");
                return;
            }
        } else {
            void var2_2;
            void var1_1;
            var1_1.append((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String getNavigationLink(int mode, MIBRepository rep, String lineSeparator) {
        void var3_3;
        void var2_2;
        void var1_1;
        StringBuffer stringBuffer = new StringBuffer();
        MIBObject.addNavigationLinks(this, (int)var1_1, stringBuffer, (MIBRepository)var2_2, (String)var3_3);
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String needsFullQualification(MIBRepository rep, MIBObject o2) {
        if (rep.getObjectsByName(o2.getName()).length > 1) {
            void var1_1;
            MIBRepository mIBRepository;
            return mIBRepository.getModuleName(var1_1.getModuleID());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void addNavigationLinks(MIBObject o2, int mode, StringBuffer buf, MIBRepository rep, String lineSeparator) {
        if ((mode & 0x200) > 0) {
            void var2_2;
            void var1_1;
            Object object;
            Object object2;
            StringBuffer stringBuffer = new StringBuffer();
            Object object3 = rep.getParent(o2);
            if (object3 != null) {
                stringBuffer.append("-- ");
                stringBuffer.append("Parent:   ");
                object2 = MIBObject.needsFullQualification(rep, (MIBObject)object3);
                if (object2 != null) {
                    MIBObject.addObjectLink(mode, stringBuffer, (String)object2 + "." + ((MIBObject)object3).getName());
                } else {
                    MIBObject.addObjectLink(mode, stringBuffer, ((MIBObject)object3).getName());
                }
                stringBuffer.append(lineSeparator);
            }
            if ((object2 = rep.getPrevObject(o2.getOid())) != null) {
                stringBuffer.append("-- Previous: ");
                object3 = MIBObject.needsFullQualification(rep, (MIBObject)object2);
                if (object3 != null) {
                    MIBObject.addObjectLink(mode, stringBuffer, (String)object3 + "." + ((MIBObject)object2).getName());
                } else {
                    MIBObject.addObjectLink(mode, stringBuffer, ((MIBObject)object2).getName());
                }
                object = rep.getPrevSibblingObject(o2.getOid());
                if (object != null && !((MIBObject)object).getName().equals(((MIBObject)object2).getName())) {
                    stringBuffer.append(" - Sibbling: ");
                    object3 = MIBObject.needsFullQualification(rep, (MIBObject)object);
                    if (object3 != null) {
                        MIBObject.addObjectLink(mode, stringBuffer, (String)object3 + "." + ((MIBObject)object).getName());
                    } else {
                        MIBObject.addObjectLink(mode, stringBuffer, ((MIBObject)object).getName());
                    }
                }
                stringBuffer.append(lineSeparator);
            }
            if ((object3 = rep.getNextObject(o2.getOid())) != null) {
                MIBObject mIBObject;
                stringBuffer.append("-- Next:     ");
                object = MIBObject.needsFullQualification(rep, (MIBObject)object3);
                if (object != null) {
                    MIBObject.addObjectLink(mode, stringBuffer, (String)object + "." + ((MIBObject)object3).getName());
                } else {
                    MIBObject.addObjectLink(mode, stringBuffer, ((MIBObject)object3).getName());
                }
                mIBObject = rep.getNextSiblingObject(mIBObject.getOid());
                if (mIBObject != null && !mIBObject.getName().equals(((MIBObject)object3).getName())) {
                    void var3_3;
                    stringBuffer.append(" - Sibbling: ");
                    object = MIBObject.needsFullQualification((MIBRepository)var3_3, mIBObject);
                    if (object != null) {
                        MIBObject.addObjectLink(mode, stringBuffer, (String)object + "." + mIBObject.getName());
                    } else {
                        MIBObject.addObjectLink(mode, stringBuffer, mIBObject.getName());
                    }
                }
                stringBuffer.append(lineSeparator);
            }
            buf.append(lineSeparator);
            MIBObject.addComment((int)var1_1, buf, stringBuffer.toString(), lineSeparator);
            var2_2.append(lineSeparator);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        void var3_4;
        void var1_1;
        MIBObject mIBObject = this.comparable(mode);
        StringBuffer stringBuffer = new StringBuffer();
        MIBObject.addNavigationLinks(this, mode, stringBuffer, rep, lineSeparator);
        if (this.hasComment()) {
            MIBObject.addComment(mode, stringBuffer, this.asn1Comment, lineSeparator);
            stringBuffer.append(lineSeparator);
        }
        MIBObject.addObjectRef(null, mode, stringBuffer, this.name, mIBObject == null ? null : mIBObject.name);
        if (this.type == 0 && this.status != null) {
            MIBObject.addKeyWord(mode, stringBuffer, " OBJECT-IDENTITY");
            stringBuffer.append(lineSeparator);
            stringBuffer.append(this.getSMIDefBegin(mode, lineSeparator));
        } else {
            MIBObject.addKeyWord(mode, stringBuffer, " OBJECT IDENTIFIER ");
            if ((mode & 0x20) > 0) {
                stringBuffer.append(lineSeparator);
            }
        }
        stringBuffer.append(this.getSMIDefEnd((int)var1_1, (MIBRepository)var3_4, this.asn1CommentInline, lineSeparator));
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setComment(String comment) {
        void var1_1;
        this.asn1Comment = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setInlineComment(String comment) {
        void var1_1;
        if (comment == null || comment.trim().length() == 0) {
            this.asn1CommentInline = null;
            return;
        }
        this.asn1CommentInline = var1_1;
    }

    @Override
    public String getComment() {
        return this.asn1Comment;
    }

    @Override
    public String getInlineComment() {
        return this.asn1CommentInline;
    }

    @Override
    public boolean hasComment() {
        return this.asn1Comment != null;
    }

    public boolean hasInlineComment() {
        return this.asn1CommentInline != null && this.asn1CommentInline.trim().length() > 0;
    }

    public int getReleased() {
        return this.released;
    }

    public boolean isReleased() {
        return this.released > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setReleased(int released) {
        void var1_1;
        this.released = var1_1;
    }

    public static String getUnquotedString(String s) {
        String string;
        if (s == null || s.equals("\"\"")) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(s, "\"");
        if (stringTokenizer.hasMoreTokens()) {
            return stringTokenizer.nextToken();
        }
        return string;
    }

    public static String getQuotedString(String s) {
        return MIBObject.getQuotedString(s, true);
    }

    /*
     * WARNING - void declaration
     */
    private static String addStringWithInternalLineSeparation(StringBuffer buf, String s, StringTokenizer st) {
        void var1_1;
        int n2 = "\r\n".indexOf(s);
        if (n2 >= 0) {
            buf.append("\n");
            for (int i2 = n2; i2 < 2 && st.hasMoreTokens(); ++i2) {
                s = st.nextToken();
                n2 = "\r\n".indexOf(s);
                if (n2 <= i2) {
                    if (n2 < 0) break;
                    if (n2 == i2) {
                        buf.append("\n");
                        return null;
                    }
                }
                s = null;
            }
            return s;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static String getQuotedString(String s, boolean allowNull) {
        CharSequence charSequence;
        if (s.length() == 0) {
            void var1_1;
            if (var1_1 != false) {
                return null;
            }
            return "\"\"";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(s, "\r\n", true);
        charSequence = new StringBuffer(((String)charSequence).length() + 2);
        ((StringBuffer)charSequence).append('\"');
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if ((string = MIBObject.addStringWithInternalLineSeparation((StringBuffer)charSequence, string, stringTokenizer)) == null) continue;
            ((StringBuffer)charSequence).append(string.replace('\"', '\''));
        }
        ((StringBuffer)charSequence).append('\"');
        return ((StringBuffer)charSequence).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static void addText(String lineSeparator, int mode, StringBuffer buf, String text) {
        void var3_3;
        void var2_2;
        void var1_1;
        MIBObject.addText(lineSeparator, (int)var1_1, (StringBuffer)var2_2, (String)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void addText(String lineSeparator, int mode, StringBuffer buf, String text, String ctext) {
        String string;
        void var3_4;
        void var2_3;
        if ((mode & 2) > 0) {
            boolean bl = false;
            if (ctext != null && !ctext.equals(text)) {
                bl = true;
                buf.append("<u>");
            }
            buf.append("<I><font color=\"#666699\">");
            if (text != null) {
                buf.append(text.substring(0));
            }
            buf.append("</font></I>");
            if (bl) {
                buf.append("</u>");
            }
            return;
        }
        MIBObject.addLines((StringBuffer)var2_3, (String)var3_4, string);
    }

    /*
     * WARNING - void declaration
     */
    public static void addObjectRef(String moduleName, int mode, StringBuffer buf, String objectName) {
        void var3_3;
        void var2_2;
        void var1_1;
        MIBObject.addObjectRef(moduleName, (int)var1_1, (StringBuffer)var2_2, (String)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void addObjectRef(String moduleName, int mode, StringBuffer buf, String objectName, String cobjectName) {
        void var1_1;
        boolean bl = false;
        if (cobjectName != null && (mode & 2) > 0 && !objectName.equals(cobjectName)) {
            bl = true;
            buf.append("<u>");
        }
        if ((var1_1 & 4) > 0) {
            if (moduleName != null) {
                String string;
                buf.append("<a name=\"" + string + "." + objectName + "\">" + objectName + "</a>");
            } else {
                buf.append("<a name=\"" + objectName + "\">" + objectName + "</a>");
            }
        } else {
            void var3_3;
            buf.append((String)var3_3);
        }
        if (bl) {
            void var2_2;
            var2_2.append("</u>");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addObjectLink(int mode, StringBuffer buf, String objectName) {
        void var2_2;
        void var1_1;
        MIBObject.addObjectLink(mode, (StringBuffer)var1_1, (String)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void addObjectLink(int mode, StringBuffer buf, String objectName, String cobjectName) {
        int n2;
        void var3_3;
        boolean bl = false;
        if (cobjectName != null && (mode & 2) > 0 && !objectName.equals(var3_3)) {
            bl = true;
            buf.append("<u>");
        }
        if ((n2 & 4) > 0) {
            buf.append("<a href=\"#" + objectName + "\">" + objectName + "</a>");
        } else {
            void var2_2;
            buf.append((String)var2_2);
        }
        if (bl) {
            void var1_1;
            var1_1.append("</u>");
        }
    }

    private static void addLines(StringBuffer buf, String text, String lineSeparator) {
        StringTokenizer stringTokenizer;
        if (text == null) {
            return;
        }
        stringTokenizer = new StringTokenizer((String)((Object)stringTokenizer), "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equals("\n")) {
                buf.append(lineSeparator);
                continue;
            }
            buf.append(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addComment(int mode, StringBuffer buf, String comment, String lineSeparator) {
        void var3_3;
        void var2_2;
        void var1_1;
        if ((mode & 2) > 0) {
            buf.append("<font color=\"#408080\">");
            buf.append(comment);
            buf.append("</font>");
            return;
        }
        MIBObject.addLines((StringBuffer)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static void addKeyWord(int mode, StringBuffer buf, String keyWord) {
        void var2_2;
        void var1_1;
        if ((mode & 2) > 0) {
            buf.append("<strong>");
            buf.append(keyWord);
            buf.append("</strong>");
            return;
        }
        var1_1.append((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static void addNum(int mode, StringBuffer buf, String num) {
        void var2_2;
        void var1_1;
        MIBObject.addNum(mode, (StringBuffer)var1_1, (String)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void addNum(int mode, StringBuffer buf, String num, String cnum) {
        if ((mode & 2) > 0) {
            void var3_3;
            if (cnum != null && !num.equals(cnum)) {
                buf.append("<u>");
            }
            buf.append("<font color=\"#999999\">");
            buf.append(num);
            buf.append("</font>");
            if (cnum != null && !num.equals(var3_3)) {
                buf.append("</u>");
                return;
            }
        } else {
            void var2_2;
            void var1_1;
            var1_1.append((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void addNum(int mode, StringBuffer buf, long num) {
        void var2_2;
        void var1_1;
        MIBObject.addNum(mode, (StringBuffer)var1_1, "" + (long)var2_2);
    }

    public static int getMaxLength(Iterator en) {
        int n2 = 0;
        while (en.hasNext()) {
            int n3 = en.next().toString().length();
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    public static String getFlatString(String s) {
        StringTokenizer stringTokenizer;
        stringTokenizer = new StringTokenizer((String)((Object)stringTokenizer), MIBObject.getLineSeparator() + "\t", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (MIBObject.getLineSeparator().indexOf(string) >= 0) {
                stringBuffer.append(" ");
                continue;
            }
            if (string.equals("\t")) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String space(int len) {
        char[] cArray = new char[len];
        for (int i2 = 0; i2 < len; ++i2) {
            cArray[i2] = 32;
        }
        return new String(cArray);
    }

    public static void beginDiff(int mode, StringBuffer buf) {
        buf.append("<strike>");
    }

    public static void endDiff(int mode, StringBuffer buf) {
        buf.append("</strike>");
    }

    protected MIBObject comparable(int mode) {
        if ((mode & 2) > 0 && this.userObject != null && this.userObject instanceof CompareResult && ((CompareResult)this.userObject).other != null && ((CompareResult)this.userObject).other.getClass().equals(this.getClass())) {
            return ((CompareResult)this.userObject).other;
        }
        return null;
    }

    @Override
    public boolean isStructural() {
        return this.getType() != 0;
    }

    public static String makeASN1Comment(String comment) {
        StringTokenizer stringTokenizer;
        if (comment == null || comment.trim().length() == 0) {
            return null;
        }
        stringTokenizer = new StringTokenizer((String)((Object)stringTokenizer), "\n", true);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!string.equals("\n") && !string.trim().startsWith("--")) {
                stringBuffer.append("--");
                stringBuffer.append(string);
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object o2) {
        if (o2 instanceof MIBObject) {
            MIBObject mIBObject;
            mIBObject = mIBObject;
            return MIBObject.saveCompare(this.moduleID, mIBObject.moduleID) && MIBObject.saveCompare(this.oid, mIBObject.oid) && MIBObject.saveCompare(this.name, mIBObject.name) && MIBObject.saveCompare(this.status, mIBObject.status) && MIBObject.saveCompare(this.descr, mIBObject.descr) && MIBObject.saveCompare(this.reference, mIBObject.reference);
        }
        return false;
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    protected static final boolean saveCompare(Object a2, Object b2) {
        void var1_1;
        Object object;
        return a2 == null && b2 == null || a2 != null && object.equals(var1_1);
    }

    public int getID() {
        return this.id;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.id = MIBObject.nextID();
        this.status = SMI.getCommonIdentifier(this.status);
    }

    public void freeUserObjects() {
        this.userObject = null;
    }
}

