/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.LexicographicPredicate;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.ObjectIDPredicate;
import com.agentpp.mib.util.EnumerationIterator;
import com.agentpp.smi.IImport;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IRevision;
import com.agentpp.smi.ext.SMIModule;
import com.agentpp.smiparser.SMI;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.OrderedMap;
import com.objectspace.jgl.Pair;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class MIBModule
extends MIBObject
implements SMIModule,
Serializable {
    public static final long serialVersionUID = 1000L;
    protected String pathName = null;
    protected String moduleName;
    protected Vector<MIBRevision> revisions = null;
    protected Vector<MIBImport> imports = null;
    protected String organization;
    protected String lastUpdated;
    protected String contactInfo;
    protected Date lastChange = null;
    protected int smiVersion = 1;
    protected String copyrightComment;
    protected String copyrightCommentEnd;
    protected transient Map<String, MIBObject> objects = null;
    protected int parseMode = 0;
    protected transient int startPosition = 0;
    private static final String[] STANDARD_MIBS = new String[]{"SNMPv2-SMI", "SNMPv2-TC", "SNMPv2-CONF", "RFC1155-SMI", "RFC1215"};

    public MIBModule() {
        this.objects = new ConcurrentHashMap<String, MIBObject>();
    }

    /*
     * WARNING - void declaration
     */
    public MIBModule(String newModuleName, Integer newModuleID) {
        this();
        void var2_2;
        void var1_1;
        this.moduleName = var1_1;
        this.moduleID = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public MIBModule(ObjectID oid, String name) {
        super((ObjectID)var1_1, (String)var2_2);
        void var2_2;
        void var1_1;
        this.objects = new ConcurrentHashMap<String, MIBObject>();
    }

    /*
     * WARNING - void declaration
     */
    public MIBModule(IModule other) {
        super(other);
        Object object;
        this.moduleName = other.getModuleName();
        this.revisions = new Vector<IRevision>(Arrays.asList(other.getRevisions()));
        if (other.hasImports()) {
            object = other.getImports();
            for (int i2 = 0; i2 < ((IImport[])object).length; ++i2) {
                this.addImport(new MIBImport(object[i2].getSource(), new Vector<String>(Arrays.asList(object[i2].getImports())), object[i2].getComment()));
            }
        }
        this.organization = other.getOrganization();
        this.lastChange = new Date();
        this.lastUpdated = other.getLastUpdated();
        this.contactInfo = other.getContactInfo();
        this.smiVersion = other.getSMIVersion();
        this.moduleID = other.getModuleID();
        this.copyrightComment = other.getCopyrightComment();
        this.copyrightCommentEnd = other.getCopyrightCommentEnd();
        this.objects = new ConcurrentHashMap<String, MIBObject>();
        object = other.objects();
        while (object.hasMoreElements()) {
            IObject iObject = (IObject)object.nextElement();
            if (!(iObject instanceof MIBObject)) continue;
            this.objects.put(iObject.getName(), (MIBObject)iObject);
        }
        if (this.objects.containsKey(other.getName())) {
            void var1_1;
            this.objects.remove(var1_1.getName());
            MIBModule mIBModule = this;
            mIBModule.add(mIBModule);
        }
    }

    /*
     * WARNING - void declaration
     */
    public MIBModule(MIBModule other) {
        super(other);
        this.pathName = other.pathName;
        this.moduleName = other.moduleName;
        this.revisions = other.revisions;
        if (other.hasImports()) {
            Enumeration<MIBImport> enumeration = other.imports.elements();
            while (enumeration.hasMoreElements()) {
                this.addImport(new MIBImport(enumeration.nextElement()));
            }
        }
        this.organization = other.organization;
        this.lastChange = new Date(other.lastChange.getTime());
        this.lastUpdated = other.lastUpdated;
        this.contactInfo = other.contactInfo;
        this.smiVersion = other.smiVersion;
        this.moduleID = other.moduleID;
        this.copyrightComment = other.copyrightComment;
        this.copyrightCommentEnd = other.copyrightCommentEnd;
        this.objects = new ConcurrentHashMap<String, MIBObject>(other.objects);
        if (this.objects.containsKey(other.getName())) {
            void var1_1;
            this.objects.remove(var1_1.getName());
            MIBModule mIBModule = this;
            mIBModule.add(mIBModule);
        }
    }

    @Override
    public MIBObject getClone() {
        return new MIBModule(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(Object o2) {
        void var1_1;
        MIBObject mIBObject = (MIBObject)o2;
        if (mIBObject instanceof MIBModule) {
            return this.getModuleName().compareTo(((MIBModule)mIBObject).getModuleName());
        }
        return super.compareTo((Object)var1_1);
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    @Override
    public String getTypeString() {
        return SMI.ENTRY_TYPES[5];
    }

    public void reinit() {
        this.objects = new ConcurrentHashMap<String, MIBObject>();
    }

    /*
     * WARNING - void declaration
     */
    public void add(MIBObject o2) {
        void var1_1;
        this.objects.put(o2.getName(), (MIBObject)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(MIBObject o2) {
        void var1_1;
        return this.objects.remove(var1_1.getName()) != null;
    }

    public MIBObject get(ObjectID oid) {
        for (MIBObject mIBObject : this.objects.values()) {
            if (!mIBObject.getOid().equals(oid)) continue;
            return mIBObject;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IObject getObject(String objectName) {
        void var1_1;
        return this.getObjectByName((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IObject getObjectByOID(String oid) {
        void var1_1;
        return this.get(new ObjectID((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public MIBObject getObjectByName(String objectName) {
        void var1_1;
        return this.objects.get(var1_1);
    }

    @Override
    public int hashCode() {
        return this.moduleID.hashCode();
    }

    @Override
    public Enumeration<MIBObject> objects() {
        return new EnumerationIterator<MIBObject>(this.objects.values().iterator());
    }

    public Iterator<MIBObject> objectsIterator() {
        return this.objects.values().iterator();
    }

    @Override
    public OrderedMap objectsByOid() {
        return this.objectsByOid(false);
    }

    /*
     * WARNING - void declaration
     */
    public OrderedMap objectsByOid(boolean returnDuplicates) {
        void var1_1;
        Iterator<MIBObject> iterator = this.objects.values().iterator();
        OrderedMap orderedMap = new OrderedMap((BinaryPredicate)ObjectIDPredicate.instance, (boolean)var1_1);
        while (iterator.hasNext()) {
            MIBObject mIBObject = iterator.next();
            if (mIBObject.getOid().isEmpty()) continue;
            orderedMap.put((Object)mIBObject.getOid(), (Object)mIBObject);
        }
        return orderedMap;
    }

    @Override
    public OrderedMap objectsByName() {
        Iterator<MIBObject> iterator = this.objects.values().iterator();
        OrderedMap orderedMap = new OrderedMap((BinaryPredicate)new LexicographicPredicate());
        while (iterator.hasNext()) {
            MIBObject mIBObject = iterator.next();
            orderedMap.put((Object)mIBObject.getName(), (Object)mIBObject);
        }
        return orderedMap;
    }

    @Override
    public Vector<MIBObject> getObjectsVector() {
        Vector<MIBObject> vector = new Vector<MIBObject>(this.objects.size());
        vector.addAll(this.objects.values());
        return vector;
    }

    public MIBObject[] getObjects() {
        Vector<MIBObject> vector = this.getObjectsVector();
        Object[] objectArray = new MIBObject[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setObjectsVector(Vector objs) {
        Enumeration enumeration;
        this.objects = new ConcurrentHashMap<String, MIBObject>(objs.size());
        enumeration = ((Vector)((Object)enumeration)).elements();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = (MIBObject)enumeration.nextElement();
            this.add(mIBObject);
        }
    }

    public List<MIBGroup> getMemberGroups(String objectName) {
        ArrayList<MIBGroup> arrayList = new ArrayList<MIBGroup>();
        Iterator<MIBObject> iterator = this.objectsIterator();
        while (iterator.hasNext()) {
            MIBObject mIBObject = iterator.next();
            if (!(mIBObject instanceof MIBGroup) || !((MIBGroup)(mIBObject = (MIBGroup)mIBObject)).contains(objectName)) continue;
            arrayList.add((MIBGroup)mIBObject);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setModuleName(String newModuleName) {
        void var1_1;
        this.moduleName = var1_1;
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    /*
     * WARNING - void declaration
     */
    public void setFileName(String name) {
        void var1_1;
        this.pathName = var1_1;
    }

    public String getFileName() {
        return this.pathName;
    }

    /*
     * WARNING - void declaration
     */
    public void addImport(MIBImport imp) {
        void var1_1;
        if (this.imports == null) {
            this.imports = new Vector(5);
        }
        this.imports.add((MIBImport)var1_1);
    }

    @Override
    public IImport[] getImports() {
        if (this.imports == null) {
            return null;
        }
        Object[] objectArray = new MIBImport[this.imports.size()];
        this.imports.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public boolean imports(String objectName) {
        if (!this.hasImports()) {
            return false;
        }
        Enumeration<MIBImport> enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = enumeration.nextElement();
            if (!mIBImport.imports(objectName)) continue;
            return true;
        }
        return false;
    }

    public boolean imports(String objectName, String moduleName) {
        if (!this.hasImports()) {
            return false;
        }
        Enumeration<MIBImport> enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = enumeration.nextElement();
            if (!mIBImport.imports(objectName) || !mIBImport.getSource().equals(moduleName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getImportSources() {
        if (this.imports == null) {
            return new String[0];
        }
        String[] stringArray = new String[this.imports.size()];
        int n2 = 0;
        Enumeration<MIBImport> enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n2] = enumeration.nextElement().getSource();
            ++n2;
        }
        return stringArray;
    }

    public boolean importsFrom(String moduleName) {
        if (this.imports == null) {
            return false;
        }
        Enumeration<MIBImport> enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            if (!moduleName.equals(enumeration.nextElement().getSource())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setImports(MIBImport[] imports) {
        void var1_1;
        this.imports = MIBRepository.buildVector(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setImportsVector(Vector v) {
        void var1_1;
        this.imports = var1_1;
    }

    public Vector<MIBImport> getImportsVector() {
        return this.imports;
    }

    @Override
    public boolean hasImports() {
        return this.imports != null && this.imports.size() > 0;
    }

    @Override
    public String toString() {
        return this.moduleName;
    }

    public boolean isUsedSyntax(MIBTextualConvention tc) {
        for (MIBObject mIBObject : this.objects.values()) {
            if (!(mIBObject instanceof MIBObjectType ? ((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject)).getSyntax().getSyntax().equals(tc.getName()) : mIBObject instanceof MIBTextualConvention && ((MIBTextualConvention)(mIBObject = (MIBTextualConvention)mIBObject)).getSyntax().getSyntax().equals(tc.getName()))) continue;
            return true;
        }
        return false;
    }

    public boolean isUsedSyntax(String syntax) {
        Enumeration<MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            if (mIBObject.getTypeString().equals(syntax) || mIBObject instanceof MIBObjectType && ((MIBObjectType)mIBObject).getSyntax().getSyntax().equals(syntax) || mIBObject instanceof MIBTextualConvention && ((MIBTextualConvention)mIBObject).getSyntax().getSyntax().equals(syntax)) {
                return true;
            }
            if (!(mIBObject instanceof MIBObjectType ? ((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject)).getSyntax().getSyntax().equals(syntax) : mIBObject instanceof MIBTextualConvention && ((MIBTextualConvention)(mIBObject = (MIBTextualConvention)mIBObject)).getSyntax().getSyntax().equals(syntax))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        Object object = (MIBModule)this.comparable(mode);
        StringBuffer stringBuffer = new StringBuffer();
        MIBModule.addNavigationLinks(this, mode, stringBuffer, rep, lineSeparator);
        if (this.hasComment()) {
            MIBModule.addComment(mode, stringBuffer, this.asn1Comment, lineSeparator);
            stringBuffer.append(lineSeparator);
        }
        if (this.smiVersion != 1 && this.oid.size() > 0 || mode == 8) {
            void var3_5;
            void var1_1;
            void var2_2;
            MIBModule.addObjectRef(null, mode, stringBuffer, this.name, object == null ? null : ((MIBModule)object).name);
            MIBModule.addKeyWord(mode, stringBuffer, " MODULE-IDENTITY");
            stringBuffer.append(lineSeparator);
            stringBuffer.append(this.toPIB(mode, (int)var2_2));
            stringBuffer.append("\t");
            MIBModule.addKeyWord(mode, stringBuffer, "LAST-UPDATED ");
            if (mode == 8) {
                MIBModule.addText(lineSeparator, mode, stringBuffer, "\"\"");
            } else {
                String string;
                MIBModule.addText(lineSeparator, mode, stringBuffer, this.lastUpdated, object == null ? null : ((MIBModule)object).lastUpdated);
                if ((mode & 0x20) > 0 && (string = MIBModule.getTimeFromUTC(MIBModule.getUnquotedString(this.lastUpdated))) != null) {
                    stringBuffer.append("\t");
                    MIBModule.addComment(mode, stringBuffer, "-- " + string, lineSeparator);
                }
            }
            stringBuffer.append(lineSeparator);
            stringBuffer.append("\t");
            MIBModule.addKeyWord(mode, stringBuffer, "ORGANIZATION ");
            if (mode == 8) {
                MIBModule.addText(lineSeparator, mode, stringBuffer, "\"\"");
            } else {
                MIBModule.addText(lineSeparator, mode, stringBuffer, this.organization, object == null ? null : ((MIBModule)object).organization);
            }
            stringBuffer.append(lineSeparator);
            stringBuffer.append("\t");
            MIBModule.addKeyWord(mode, stringBuffer, "CONTACT-INFO");
            stringBuffer.append(lineSeparator);
            if (mode == 8) {
                stringBuffer.append("\t\t");
                MIBModule.addText(lineSeparator, mode, stringBuffer, "\"\"");
            } else {
                MIBModule.addText(lineSeparator, mode, stringBuffer, MIBModule.formatLines("\t\t", this.contactInfo), object == null ? null : MIBModule.formatLines("\t\t", ((MIBModule)object).contactInfo));
            }
            stringBuffer.append(lineSeparator);
            stringBuffer.append("\t");
            MIBModule.addKeyWord(mode, stringBuffer, "DESCRIPTION");
            stringBuffer.append(lineSeparator);
            if (mode == 8) {
                stringBuffer.append("\t\t");
                MIBModule.addText(lineSeparator, mode, stringBuffer, "\"\"");
            } else {
                MIBModule.addText(lineSeparator, mode, stringBuffer, MIBModule.formatLines("\t\t", this.descr), object == null ? null : MIBModule.formatLines("\t\t", ((MIBModule)object).descr));
            }
            stringBuffer.append(lineSeparator);
            if (this.hasRevisions()) {
                Enumeration<MIBRevision> enumeration = null;
                if (object != null) {
                    enumeration = ((MIBModule)object).hasRevisions() ? ((MIBModule)object).revisions.elements() : new Vector().elements();
                }
                object = this.revisions.elements();
                while (object.hasMoreElements()) {
                    MIBRevision mIBRevision = null;
                    if (enumeration != null) {
                        mIBRevision = enumeration.hasMoreElements() ? enumeration.nextElement() : new MIBRevision("", "");
                    }
                    stringBuffer.append(((MIBRevision)object.nextElement()).toSMI(mode, mIBRevision, lineSeparator));
                }
            }
            stringBuffer.append(this.getSMIDefEnd((int)var1_1, (MIBRepository)var3_5, this.asn1CommentInline, lineSeparator));
            stringBuffer.append(lineSeparator);
        }
        return stringBuffer.toString();
    }

    protected String toPIB(int mode, int smiversion) {
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public Pair toSMI(int mode, MIBRepository rep, int maxBytes, String lineSeparator) {
        void var1_1;
        Serializable serializable;
        Enumeration<Serializable> enumeration;
        StringBuffer stringBuffer = new StringBuffer(65535);
        if (this.hasCopyrightComment()) {
            MIBModule.addComment(mode, stringBuffer, this.copyrightComment, lineSeparator);
            stringBuffer.append(lineSeparator);
        }
        stringBuffer.append(this.getModuleName());
        if (stringBuffer.length() >= maxBytes) {
            return new Pair((Object)this, (Object)0);
        }
        this.toSMIDefinitionsBegin(mode, stringBuffer);
        stringBuffer.append(lineSeparator);
        stringBuffer.append(lineSeparator);
        if (stringBuffer.length() >= maxBytes) {
            return new Pair((Object)this, (Object)0);
        }
        if (this.hasImports()) {
            MIBModule.addKeyWord(mode, stringBuffer, "IMPORTS");
            enumeration = this.imports.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(lineSeparator);
                serializable = enumeration.nextElement();
                stringBuffer.append(((MIBImport)serializable).toSMI(rep, mode, lineSeparator));
                if (enumeration.hasMoreElements() || !((MIBImport)serializable).hasComment()) continue;
                stringBuffer.append(lineSeparator);
            }
            stringBuffer.append(";");
            stringBuffer.append(lineSeparator);
            stringBuffer.append(lineSeparator);
        }
        int n2 = stringBuffer.length();
        stringBuffer.append(this.toSMI(mode, this.smiVersion, rep, lineSeparator));
        if (stringBuffer.length() >= maxBytes) {
            return new Pair((Object)this, (Object)n2);
        }
        enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            serializable = (MIBObject)enumeration.nextElement();
            if (!(serializable instanceof MIBTextualConvention)) continue;
            stringBuffer.append(lineSeparator);
            n2 = stringBuffer.length();
            stringBuffer.append(((MIBObject)serializable).toSMI(mode, this.smiVersion, rep, lineSeparator));
            if (stringBuffer.length() < maxBytes) continue;
            return new Pair((Object)serializable, (Object)n2);
        }
        enumeration = this.objectsByOid().elements();
        while (enumeration.hasMoreElements()) {
            serializable = (MIBObject)enumeration.nextElement();
            if (!(serializable instanceof MIBModule) && !(serializable instanceof MIBTextualConvention)) {
                stringBuffer.append(lineSeparator);
                n2 = stringBuffer.length();
                stringBuffer.append(((MIBObject)serializable).toSMI(mode, this.smiVersion, rep, lineSeparator));
                if (stringBuffer.length() < maxBytes) continue;
                return new Pair((Object)serializable, (Object)n2);
            }
            if (!(serializable instanceof MIBModule) || this.smiVersion != 1 || !((MIBObject)serializable).getOid().isValid()) continue;
            stringBuffer.append(lineSeparator);
            n2 = stringBuffer.length();
            stringBuffer.append(super.toSMI(mode, this.smiVersion, rep, lineSeparator));
            if (stringBuffer.length() < maxBytes) continue;
            return new Pair((Object)this, (Object)n2);
        }
        stringBuffer.append(lineSeparator);
        MIBModule.addKeyWord((int)var1_1, stringBuffer, "END");
        stringBuffer.append(lineSeparator);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void toSMIDefinitionsBegin(int mode, StringBuffer buf) {
        void var2_2;
        MIBModule.addKeyWord(mode, (StringBuffer)var2_2, " DEFINITIONS ::= BEGIN");
    }

    @Override
    public Collection<MIBObject> objectsOrderedByOccurance() {
        TreeMap<MIBObject, MIBObject> treeMap = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(128));
        Enumeration<MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject;
            MIBObject mIBObject2 = mIBObject = enumeration.nextElement();
            treeMap.put(mIBObject2, mIBObject2);
        }
        return treeMap.values();
    }

    private void objectsToSMI(int mode, StringBuffer buf, MIBRepository rep, String lineSeparator) {
        MIBObject[] mIBObjectArray = new TreeMap(new MIBObjectOrderComparator(mode));
        Enumeration<MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject;
            MIBObject mIBObject2 = mIBObject = enumeration.nextElement();
            mIBObjectArray.put((MIBObject)mIBObject2, mIBObject2);
        }
        for (MIBObject mIBObject : mIBObjectArray.values()) {
            if (!(mIBObject instanceof MIBModule)) {
                buf.append(lineSeparator);
                buf.append(mIBObject.toSMI(mode, this.smiVersion, rep, lineSeparator));
                if (mIBObject instanceof MIBTextualConvention || mIBObject == null) continue;
                mIBObjectArray = rep.getObjectsByOid(mIBObject.getOid());
                for (int i2 = 0; i2 < mIBObjectArray.length; ++i2) {
                    if (mIBObject == mIBObjectArray[i2] || !mIBObject.getModuleID().equals(mIBObjectArray[i2].getModuleID())) continue;
                    buf.append(lineSeparator);
                    buf.append(mIBObjectArray[i2].toSMI(mode, this.smiVersion, rep, lineSeparator));
                }
                continue;
            }
            if (!(mIBObject instanceof MIBModule) || this.smiVersion != 1 || !mIBObject.getOid().isValid()) continue;
            buf.append(lineSeparator);
            buf.append(super.toSMI(mode, this.smiVersion, rep, lineSeparator));
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toSMI(int mode, MIBRepository rep, String lineSeparator) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.toSMI((int)var1_1, (MIBRepository)var2_2, (String)var3_3, "Object Definitions");
    }

    /*
     * WARNING - void declaration
     */
    public String toSMI(int mode, MIBRepository rep, String lineSeparator, String objectsComment) {
        void var4_4;
        Serializable serializable;
        Enumeration<Serializable> enumeration;
        StringBuffer stringBuffer = new StringBuffer(65535);
        if (this.hasCopyrightComment()) {
            MIBModule.addComment(mode, stringBuffer, this.copyrightComment, lineSeparator);
            stringBuffer.append(lineSeparator);
        }
        stringBuffer.append(this.getModuleName());
        this.toSMIDefinitionsBegin(mode, stringBuffer);
        stringBuffer.append(lineSeparator);
        stringBuffer.append(lineSeparator);
        if (this.hasImports()) {
            MIBModule.addKeyWord(mode, stringBuffer, "IMPORTS");
            enumeration = this.imports.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(lineSeparator);
                serializable = enumeration.nextElement();
                stringBuffer.append(((MIBImport)serializable).toSMI(rep, mode, lineSeparator));
                if (enumeration.hasMoreElements() || !((MIBImport)serializable).hasComment()) continue;
                stringBuffer.append(lineSeparator);
            }
            stringBuffer.append(";");
            stringBuffer.append(lineSeparator);
            stringBuffer.append(lineSeparator);
        }
        stringBuffer.append(this.toSMI(mode, this.smiVersion, rep, lineSeparator));
        if ((mode & 0x40) == 0) {
            if ((mode & 0x180) > 0) {
                this.objectsToSMI(mode, stringBuffer, rep, lineSeparator);
            } else {
                enumeration = this.objects();
                while (enumeration.hasMoreElements()) {
                    serializable = (MIBObject)enumeration.nextElement();
                    if (!(serializable instanceof MIBTextualConvention)) continue;
                    stringBuffer.append(lineSeparator);
                    stringBuffer.append(((MIBObject)serializable).toSMI(mode, this.smiVersion, rep, lineSeparator));
                }
                enumeration = this.objectsByOid().elements();
                while (enumeration.hasMoreElements()) {
                    serializable = (MIBObject)enumeration.nextElement();
                    if (!(serializable instanceof MIBModule) && !(serializable instanceof MIBTextualConvention)) {
                        stringBuffer.append(lineSeparator);
                        stringBuffer.append(((MIBObject)serializable).toSMI(mode, this.smiVersion, rep, lineSeparator));
                        objectsComment = rep.getObjectsByOid(((MIBObject)serializable).getOid());
                        for (int i2 = 0; i2 < ((void)var4_4).length; ++i2) {
                            if (serializable == var4_4[i2] || !((MIBObject)serializable).getModuleID().equals(var4_4[i2].getModuleID())) continue;
                            stringBuffer.append(lineSeparator);
                            stringBuffer.append(var4_4[i2].toSMI(mode, this.smiVersion, rep, lineSeparator));
                        }
                        continue;
                    }
                    if (!(serializable instanceof MIBModule) || this.smiVersion != 1 || !((MIBObject)serializable).getOid().isValid()) continue;
                    stringBuffer.append(lineSeparator);
                    stringBuffer.append(super.toSMI(mode, this.smiVersion, rep, lineSeparator));
                }
            }
        } else {
            MIBModule.addComment(mode, stringBuffer, "-- " + lineSeparator + "-- " + (String)var4_4 + lineSeparator + "-- " + lineSeparator, lineSeparator);
        }
        stringBuffer.append(lineSeparator);
        MIBModule.addKeyWord(mode, stringBuffer, "END");
        stringBuffer.append(lineSeparator);
        if (this.hasCopyrightCommentEnd()) {
            void var3_3;
            void var1_1;
            MIBModule.addComment((int)var1_1, stringBuffer, this.copyrightCommentEnd, lineSeparator);
            stringBuffer.append((String)var3_3);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void setOrganization(String newOrganization) {
        void var1_1;
        this.organization = var1_1;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastUpdated(String newLastUpdated) {
        void var1_1;
        this.lastUpdated = var1_1;
    }

    @Override
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    /*
     * WARNING - void declaration
     */
    public void setContactInfo(String newContactInfo) {
        void var1_1;
        this.contactInfo = var1_1;
    }

    @Override
    public String getContactInfo() {
        return this.contactInfo;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSMIVersion(int newSmiVersion) {
        void var1_1;
        this.smiVersion = var1_1;
    }

    @Override
    public int getSMIVersion() {
        return this.smiVersion;
    }

    /*
     * WARNING - void declaration
     */
    public void addRevision(MIBRevision revision) {
        void var1_1;
        if (this.revisions == null) {
            this.revisions = new Vector(2);
        }
        this.revisions.addElement((MIBRevision)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setRevisions(MIBRevision[] refs) {
        void var1_1;
        this.revisions = MIBRepository.buildVector(var1_1);
    }

    @Override
    public boolean hasCopyrightComment() {
        return this.copyrightComment != null && this.copyrightComment.length() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public void setCopyrightComment(String copyrightComment) {
        void var1_1;
        this.copyrightComment = var1_1;
    }

    @Override
    public String getCopyrightCommentEnd() {
        return this.copyrightCommentEnd;
    }

    @Override
    public boolean hasCopyrightCommentEnd() {
        return this.copyrightCommentEnd != null && this.copyrightCommentEnd.length() > 0;
    }

    /*
     * WARNING - void declaration
     */
    public void setCopyrightCommentEnd(String copyrightCommentEnd) {
        void var1_1;
        this.copyrightCommentEnd = var1_1;
    }

    @Override
    public String getCopyrightComment() {
        return this.copyrightComment;
    }

    @Override
    public IRevision[] getRevisions() {
        if (this.revisions == null) {
            return null;
        }
        Object[] objectArray = new MIBRevision[this.revisions.size()];
        this.revisions.copyInto(objectArray);
        return objectArray;
    }

    /*
     * WARNING - void declaration
     */
    public void setRevisionsVector(Vector v) {
        void var1_1;
        this.revisions = var1_1;
    }

    public Vector getRevisionsVector() {
        return this.revisions;
    }

    @Override
    public boolean hasRevisions() {
        return this.revisions != null && this.revisions.size() > 0;
    }

    public Date getLastChange() {
        return this.lastChange;
    }

    public int getParseMode() {
        return this.parseMode;
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    /*
     * WARNING - void declaration
     */
    public void setLastChange(Date d2) {
        void var1_1;
        this.lastChange = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setParseMode(int parseMode) {
        void var1_1;
        this.parseMode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setStartPosition(int startPosition) {
        void var1_1;
        this.startPosition = var1_1;
    }

    public boolean isInitialized() {
        return this.objects != null;
    }

    public Vector<MIBTextualConvention> getTextualConventions() {
        Vector<MIBTextualConvention> vector = new Vector<MIBTextualConvention>(this.objects.size() / 50, 10);
        for (MIBObject mIBObject : this.objects.values()) {
            if (!(mIBObject instanceof MIBTextualConvention)) continue;
            vector.add((MIBTextualConvention)mIBObject);
        }
        return vector;
    }

    public boolean isValid() {
        boolean bl = this.smiVersion == 1;
        if (bl) {
            return true;
        }
        if (this.getOid() == null || this.getOid().size() == 0) {
            return false;
        }
        Enumeration<MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            if (!(mIBObject instanceof MIBModule) || !mIBObject.equals(this)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public String getImportSource(String objectName) {
        if (!this.hasImports()) {
            return null;
        }
        Enumeration<MIBImport> enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = enumeration.nextElement();
            if (!mIBImport.imports(objectName)) continue;
            return mIBImport.getSource();
        }
        return null;
    }

    @Override
    public Vector getImportSources(String objectName) {
        if (!this.hasImports()) {
            return new Vector(1);
        }
        Vector<String> vector = new Vector<String>(2);
        Enumeration<MIBImport> enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = enumeration.nextElement();
            if (!mIBImport.imports(objectName)) continue;
            vector.add(mIBImport.getSource());
        }
        return vector;
    }

    public MIBImport getImports(String source) {
        if (this.imports == null) {
            return null;
        }
        Enumeration<MIBImport> enumeration = this.imports.elements();
        while (enumeration.hasMoreElements()) {
            MIBImport mIBImport = enumeration.nextElement();
            if (!mIBImport.getSource().equals(source)) continue;
            return mIBImport;
        }
        return null;
    }

    public void releaseChangedObjects(int releaseNumber) {
        Enumeration<MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            if (mIBObject.isReleased()) continue;
            mIBObject.setReleased(releaseNumber);
        }
    }

    public void unreleaseObjects(int releasedNumber) {
        Enumeration<MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            MIBObject mIBObject = enumeration.nextElement();
            if (mIBObject.getReleased() < releasedNumber) continue;
            mIBObject.setReleased(0);
        }
    }

    public static GregorianCalendar getDateAndTimeFromUTC(String utc) {
        int n2 = 0;
        if (utc.length() == 11 || utc.length() == 13) {
            String string;
            int n3 = 2;
            if (utc.length() == 13) {
                n3 = 4;
            } else {
                n2 = 1900;
            }
            n2 += Integer.parseInt(utc.substring(0, n3));
            int n4 = n3;
            int n5 = Integer.parseInt(utc.substring(n4, n4 + 2)) - 1;
            int n6 = Integer.parseInt(utc.substring(n3 + 2, n3 + 4));
            int n7 = Integer.parseInt(utc.substring(n3 + 4, n3 + 6));
            int n8 = Integer.parseInt(string.substring(n3 + 6, n3 + 8));
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n5, n6, n7, n8);
            return gregorianCalendar;
        }
        return null;
    }

    public static Date getDateFromUTC(String utc) {
        GregorianCalendar gregorianCalendar = MIBModule.getDateAndTimeFromUTC(utc);
        if (gregorianCalendar == null) {
            return null;
        }
        return gregorianCalendar.getTime();
    }

    public static String getTimeFromUTC(String utc) {
        Date date = MIBModule.getDateFromUTC(utc);
        if (date != null) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
            return dateFormat.format(date);
        }
        return null;
    }

    public void changeObjectReferences(String oldObjectName, String newObjectName) {
        Enumeration<MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            MIBObject mIBObject = enumeration.nextElement();
            if (mIBObject instanceof MIBGroup) {
                mIBObject = (MIBGroup)mIBObject;
                for (int i2 = 0; i2 < ((MIBGroup)mIBObject).getObjectsVector().size(); ++i2) {
                    object2 = ((MIBGroup)mIBObject).getObjectsVector().elementAt(i2);
                    if (!((String)object2).equals(oldObjectName)) continue;
                    ((MIBGroup)mIBObject).getObjectsVector().setElementAt(newObjectName, i2);
                }
                continue;
            }
            if (mIBObject instanceof MIBNotifyType) {
                if (!((MIBNotifyType)(mIBObject = (MIBNotifyType)mIBObject)).hasVariables()) continue;
                for (int i3 = 0; i3 < ((MIBNotifyType)mIBObject).getVariablesVector().size(); ++i3) {
                    object2 = (String)((MIBNotifyType)mIBObject).getVariablesVector().get(i3);
                    if (!((String)object2).equals(oldObjectName)) continue;
                    ((MIBNotifyType)mIBObject).getVariablesVector().setElementAt(newObjectName, i3);
                }
                continue;
            }
            if (mIBObject instanceof MIBObjectType) {
                if (((MIBObjectType)(mIBObject = (MIBObjectType)mIBObject)).isTable()) {
                    for (int i4 = 0; i4 < ((MIBObjectType)mIBObject).getTableEntriesVector().size(); ++i4) {
                        object2 = (String)((MIBObjectType)mIBObject).getTableEntriesVector().get(i4);
                        if (!((String)object2).equals(oldObjectName)) continue;
                        ((MIBObjectType)mIBObject).getTableEntriesVector().setElementAt(newObjectName, i4);
                    }
                }
                if (!((MIBObjectType)mIBObject).hasIndexPart()) continue;
                for (int i5 = 0; i5 < ((MIBObjectType)mIBObject).getIndexPart().getIndexPartVector().size(); ++i5) {
                    object2 = (String)((MIBObjectType)mIBObject).getIndexPart().getIndexPartVector().get(i5);
                    if (!((String)object2).equals(oldObjectName)) continue;
                    ((MIBObjectType)mIBObject).getIndexPart().getIndexPartVector().setElementAt(newObjectName, i5);
                }
                continue;
            }
            if (mIBObject instanceof MIBAgentCaps) {
                mIBObject = (MIBAgentCaps)mIBObject;
                Enumeration<MIBSupportedModule> enumeration2 = ((MIBAgentCaps)mIBObject).getModules().elements();
                while (enumeration2.hasMoreElements()) {
                    int n2;
                    object2 = enumeration2.nextElement();
                    for (n2 = 0; n2 < ((MIBSupportedModule)object2).includes.size(); ++n2) {
                        object = ((MIBSupportedModule)object2).includes.elementAt(n2);
                        if (!((String)object).equals(oldObjectName)) continue;
                        ((MIBSupportedModule)object2).includes.setElementAt(newObjectName, n2);
                    }
                    if (!((MIBSupportedModule)object2).hasVariations()) continue;
                    for (n2 = 0; n2 < ((MIBSupportedModule)object2).getVariationsVector().size(); ++n2) {
                        object = (MIBVariation)((MIBSupportedModule)object2).getVariationsVector().elementAt(n2);
                        if (!((MIBVariation)object).getVariation().equals(oldObjectName)) continue;
                        ((MIBVariation)object).setVariation(newObjectName);
                    }
                }
                continue;
            }
            if (!(mIBObject instanceof MIBCompliance)) continue;
            mIBObject = (MIBCompliance)mIBObject;
            Enumeration enumeration3 = ((MIBCompliance)mIBObject).getModules().elements();
            while (enumeration3.hasMoreElements()) {
                object2 = (MIBComplianceModule)enumeration3.nextElement();
                if (((MIBComplianceModule)object2).hasMandatory()) {
                    for (int i6 = 0; i6 < ((MIBComplianceModule)object2).getMandatoryVector().size(); ++i6) {
                        object = (String)((MIBComplianceModule)object2).getMandatoryVector().elementAt(i6);
                        if (!((String)object).equals(oldObjectName)) continue;
                        ((MIBComplianceModule)object2).getMandatoryVector().setElementAt(newObjectName, i6);
                    }
                }
                if (!((MIBComplianceModule)object2).hasVariations()) continue;
                for (int i7 = 0; i7 < ((MIBComplianceModule)object2).getVariationsVector().size(); ++i7) {
                    object = (MIBVariation)((MIBComplianceModule)object2).getVariationsVector().elementAt(i7);
                    if (((MIBVariation)object).getVariation() == null || !((MIBVariation)object).getVariation().equals(oldObjectName)) continue;
                    ((MIBVariation)object).setVariation(newObjectName);
                }
            }
        }
    }

    public void convertToSMIv1(MIBRepository rep) {
        MIBObject mIBObject;
        if (this.getSMIVersion() == 1) {
            return;
        }
        this.setSMIVersion(1);
        Serializable serializable = new MIBObject(this.getOid(), this.getName(), this.getModuleID());
        this.add((MIBObject)serializable);
        rep.removeObject(this);
        this.oid = new ObjectID();
        rep.addObject(this);
        rep.addObject((MIBObject)serializable);
        rep.structureChanged();
        serializable = new Vector();
        Enumeration<MIBObject> enumeration = this.objects();
        while (enumeration.hasMoreElements()) {
            Object object;
            Comparable comparable;
            mIBObject = enumeration.nextElement();
            if (mIBObject.getStatus() != null && mIBObject.getStatus().equals(SMI.STATUS[5])) {
                mIBObject.setStatus(SMI.STATUS[1]);
            }
            MIBSyntax mIBSyntax = null;
            if (mIBObject instanceof MIBObjectType) {
                comparable = (MIBObjectType)mIBObject;
                if (((MIBObjectType)comparable).hasIndexPart() && ((MIBObjectType)comparable).getIndexPart().isAugment() && (object = rep.getObject(((MIBObjectType)comparable).getIndexPart().getIndexPart()[0])) != null && object instanceof MIBObjectType) {
                    ((MIBObjectType)comparable).setIndexPart(new MIBIndexPart(((MIBObjectType)object).getIndexPart()));
                }
                ((MIBObjectType)comparable).setUnits(null);
                if (((MIBObjectType)comparable).getAccess().equals(SMI.ACCESS[3])) {
                    ((MIBObjectType)comparable).setAccess(SMI.ACCESS[2]);
                }
                mIBSyntax = ((MIBObjectType)comparable).getSyntax();
            }
            if (mIBObject instanceof MIBTextualConvention) {
                mIBSyntax = ((MIBTextualConvention)mIBObject).getSyntax();
                ((MIBTextualConvention)mIBObject).setStatus(null);
            }
            if (mIBSyntax != null) {
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[5]) || mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[6])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[3]);
                }
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[7])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[4]);
                }
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[13])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[4]);
                }
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[8])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[0]);
                }
                if (mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    mIBSyntax.setSyntax(SMI.SMI_SYNTAX[1]);
                    if (mIBSyntax.hasEnums()) {
                        comparable = new StringBuffer();
                        object = mIBSyntax.getEnumsVector().elements();
                        while (object.hasMoreElements()) {
                            ((StringBuffer)comparable).append("-- " + object.nextElement().toString() + "\n");
                        }
                        object = "";
                        if (mIBObject.hasComment()) {
                            object = mIBObject.getComment();
                        }
                        mIBObject.setComment((String)object + "\n-- BITS: " + "\n" + ((StringBuffer)comparable).toString());
                        if (mIBObject instanceof MIBObjectType && ((MIBObjectType)(comparable = (MIBObjectType)mIBObject)).hasDefaultValue()) {
                            object = mIBSyntax.getBitsEnum(((MIBObjectType)comparable).getDefaultValue());
                            StringBuffer stringBuffer = new StringBuffer("'");
                            if (object != null) {
                                for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                                    stringBuffer.append(Integer.toHexString((int)object[i2]));
                                }
                            }
                            stringBuffer.append("'h");
                            ((MIBObjectType)comparable).setDefaultValue(stringBuffer.toString());
                        }
                        mIBSyntax.setEnumsVector(null);
                    }
                }
            }
            if (mIBObject instanceof MIBNotifyType) {
                ((MIBNotifyType)mIBObject).setTrapType(2);
                try {
                    comparable = rep.getObject(mIBObject.getOid().getPrefix(mIBObject.getOid().size() - 2));
                    if (comparable != null) {
                        ((MIBNotifyType)mIBObject).setEnterprise(((MIBObject)comparable).getName());
                    } else {
                        ((MIBNotifyType)mIBObject).setEnterprise(mIBObject.getOid().getPrefix(mIBObject.getOid().size() - 2).toString());
                    }
                }
                catch (ObjectIDFormatException objectIDFormatException) {}
            }
            if (!(mIBObject instanceof MIBGroup) && !(mIBObject instanceof MIBCompliance) && !(mIBObject instanceof MIBAgentCaps)) continue;
            ((Vector)serializable).addElement(mIBObject);
        }
        enumeration = ((Vector)serializable).elements();
        while (enumeration.hasMoreElements()) {
            mIBObject = enumeration.nextElement();
            rep.removeObject(mIBObject);
            this.remove(mIBObject);
        }
        this.autoImportSMIMacros();
    }

    private void autoImportSMIMacros() {
        int n2;
        String[] stringArray;
        int n3;
        for (n3 = 0; n3 < STANDARD_MIBS.length; ++n3) {
            if (!this.getModuleName().equals(STANDARD_MIBS[n3])) continue;
            return;
        }
        n3 = this.getSMIVersion();
        String[][] stringArray2 = this.getImportsVector().elements();
        while (stringArray2.hasMoreElements()) {
            stringArray = stringArray2.nextElement();
            for (n2 = 0; n2 < stringArray.getImportsVector().size(); ++n2) {
                String string = stringArray.getImportsVector().get(n2);
                if (SMI.getKeyWordType(1, string) >= 0) {
                    stringArray.getImportsVector().remove(n2);
                    --n2;
                } else if (SMI.getKeyWordType(2, string) >= 0) {
                    stringArray.getImportsVector().remove(n2);
                    --n2;
                }
                if (n3 >= 0 || SMI.getKeyWordType(n3, string) < 0) continue;
                stringArray.getImportsVector().remove(n2);
                --n2;
            }
        }
        stringArray2 = n3 > 0 ? SMI.smiConstructs[n3 - 1] : SMI.pibConstructs[Math.abs(n3) - 1];
        stringArray = n3 > 0 ? SMI.smiMIBs[n3 - 1] : SMI.pibMIBs[Math.abs(n3) - 1];
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            block4: for (int i2 = 0; i2 < stringArray2[n2].length; ++i2) {
                Object object = this.objects();
                while (object.hasMoreElements()) {
                    MIBObject mIBObject = object.nextElement();
                    if (!mIBObject.getTypeString().equals(stringArray2[n2][i2]) && (!(mIBObject instanceof MIBObjectType) || !((MIBObjectType)mIBObject).getSyntax().getSyntax().equals(stringArray2[n2][i2])) && (!(mIBObject instanceof MIBTextualConvention) || !((MIBTextualConvention)mIBObject).getSyntax().getSyntax().equals(stringArray2[n2][i2]))) continue;
                    object = this.getImports(stringArray[n2]);
                    if (object == null) {
                        object = new MIBImport(stringArray[n2]);
                        this.getImportsVector().add((MIBImport)object);
                    }
                    ((MIBImport)object).addImport(stringArray2[n2][i2]);
                    continue block4;
                }
            }
        }
        for (n2 = 0; n2 < this.getImportsVector().size(); ++n2) {
            MIBImport mIBImport = this.getImportsVector().get(n2);
            if (mIBImport.getImportsVector().size() != 0) continue;
            this.getImportsVector().remove(n2);
            --n2;
        }
    }

    public Collection<String> getLowerCaseNames() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.imports != null) {
            for (int i2 = 0; i2 < this.imports.size(); ++i2) {
                object = this.imports.get(i2);
                object = object.getImports();
                for (int i3 = 0; i3 < ((String[])object).length; ++i3) {
                    if (object[i3].length() <= 0 || !Character.isLowerCase(object[i3].charAt(0))) continue;
                    hashSet.add(object[i3]);
                }
            }
        }
        Iterator<MIBObject> iterator = this.objectsIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object.getName().length() <= 0 || !Character.isLowerCase(object.getName().charAt(0))) continue;
            hashSet.add(object.getName());
        }
        return hashSet;
    }

    public Collection<String> getUpperCaseNames() {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.imports != null) {
            for (int i2 = 0; i2 < this.imports.size(); ++i2) {
                object = this.imports.get(i2);
                object = object.getImports();
                for (int i3 = 0; i3 < ((String[])object).length; ++i3) {
                    if (object[i3].length() <= 0 || !Character.isUpperCase(object[i3].charAt(0))) continue;
                    hashSet.add(object[i3]);
                }
            }
        }
        Iterator<MIBObject> iterator = this.objectsIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object.getName().length() <= 0 || !Character.isUpperCase(object.getName().charAt(0))) continue;
            hashSet.add(object.getName());
        }
        return hashSet;
    }

    private static int getTimezoneOffsetGMT() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        int n2 = TimeZone.getDefault().getOffset(1, gregorianCalendar.get(1), gregorianCalendar.get(2), gregorianCalendar.get(5), gregorianCalendar.get(7), gregorianCalendar.get(14));
        return n2;
    }

    public static String getUTCTime(long time) {
        long l2;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        String string = simpleDateFormat.format(new Date(l2 - (long)MIBModule.getTimezoneOffsetGMT()));
        string = string + "Z";
        return string;
    }
}

