/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smi;

import com.snmp4j.smi.SmiSyntax;
import com.snmp4j.smi.SmiSyntaxElement;
import com.snmp4j.smi.SmiSyntaxType;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;

public class SmiSyntaxImpl
implements SmiSyntax,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String lineSeparator = System.getProperty("line.separator");
    private final String syntaxClause;
    private final SmiSyntaxType syntaxType;
    private final List<SmiSyntaxElement> elementList;
    private SmiSyntax resolvedSyntax;
    private String resolvedDisplayHint;
    private final int smiSyntax;

    public SmiSyntaxImpl(String syntaxClause, SmiSyntaxType smiSyntaxType, int smiSyntax, List<SmiSyntaxElement> smiSyntaxElements) {
        this.syntaxClause = syntaxClause;
        this.smiSyntax = smiSyntax;
        this.elementList = smiSyntaxElements;
        this.syntaxType = smiSyntaxType;
    }

    public SmiSyntaxImpl(String syntaxClause, SmiSyntaxType syntaxType, int smiSyntax, List<SmiSyntaxElement> elementList, SmiSyntax resolvedSyntax, String resolvedDisplayHint) {
        this(syntaxClause, syntaxType, smiSyntax, elementList);
        this.resolvedSyntax = resolvedSyntax;
        this.resolvedDisplayHint = resolvedDisplayHint;
    }

    @Override
    public String getSyntaxClause() {
        return this.syntaxClause;
    }

    @Override
    public List<SmiSyntaxElement> getElements() {
        return this.elementList;
    }

    @Override
    public boolean isEnumeration() {
        List<SmiSyntaxElement> baseElements = this.resolvedSyntax == null ? this.elementList : this.resolvedSyntax.getElements();
        return baseElements != null && !baseElements.isEmpty() && baseElements.get(0).getType() == SmiSyntaxElement.Type.Enumeration;
    }

    @Override
    public SmiSyntaxType getType() {
        return this.syntaxType;
    }

    @Override
    public SmiSyntax getResolvedSyntax() {
        return this.resolvedSyntax;
    }

    @Override
    public String getResolvedDisplayHint() {
        return this.resolvedDisplayHint;
    }

    @Override
    public int getSyntax() {
        return this.smiSyntax;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        switch (this.syntaxType) {
            case SEQUENCE: {
                buf.append("SEQUENCE OF ");
                buf.append(this.syntaxClause);
                break;
            }
            case SIMPLE: 
            case APPLICATION: 
            case CONVENTION: {
                buf.append(this.syntaxClause);
                if (this.isEnumeration() || this.elementList == null || this.elementList.isEmpty()) break;
                SmiSyntax baseSyntax = this.getResolvedSyntax();
                if (baseSyntax == null) {
                    baseSyntax = this;
                }
                boolean isSize = false;
                switch (baseSyntax.getSyntax()) {
                    case 3: 
                    case 4: 
                    case 68: {
                        isSize = true;
                        buf.append(" (SIZE");
                    }
                }
                buf.append(" (");
                Iterator<SmiSyntaxElement> it = this.elementList.iterator();
                while (it.hasNext()) {
                    SmiSyntaxElement range = it.next();
                    buf.append(range.toString());
                    if (!it.hasNext()) continue;
                    buf.append(" | ");
                }
                buf.append(")");
                if (!isSize) break;
                buf.append(")");
                break;
            }
        }
        if (this.isEnumeration() && this.elementList != null && !this.elementList.isEmpty()) {
            buf.append(" {");
            buf.append(lineSeparator);
            for (SmiSyntaxElement syntaxElement : this.elementList) {
                buf.append("\t\t\t");
                buf.append(syntaxElement.toString());
                buf.append(lineSeparator);
            }
            buf.append("}");
        }
        return buf.toString();
    }
}

