/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smi;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.util.OIDComparator;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smi.IEnum;
import com.agentpp.smi.IRange;
import com.agentpp.smi.IRevision;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.IVariation;
import com.agentpp.smi.event.ExtRepsitoryListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.snmpvalue.IndexConverter;
import com.agentpp.snmpvalue.Val;
import com.agentpp.snmpvalue.ValueConverter;
import com.objectspace.jgl.Pair;
import com.snmp4j.smi.CompilationMonitor;
import com.snmp4j.smi.CompilationResult;
import com.snmp4j.smi.NamedInputStream;
import com.snmp4j.smi.RepositoryDriver;
import com.snmp4j.smi.RepositoryIO;
import com.snmp4j.smi.SmiAccess;
import com.snmp4j.smi.SmiAgentCapabilities;
import com.snmp4j.smi.SmiCompiler;
import com.snmp4j.smi.SmiComplianceModule;
import com.snmp4j.smi.SmiComplianceType;
import com.snmp4j.smi.SmiError;
import com.snmp4j.smi.SmiGroup;
import com.snmp4j.smi.SmiGroupType;
import com.snmp4j.smi.SmiImport;
import com.snmp4j.smi.SmiIndexInfo;
import com.snmp4j.smi.SmiModule;
import com.snmp4j.smi.SmiModuleCompliance;
import com.snmp4j.smi.SmiModuleIdentity;
import com.snmp4j.smi.SmiNotificationType;
import com.snmp4j.smi.SmiObject;
import com.snmp4j.smi.SmiObjectCompliance;
import com.snmp4j.smi.SmiObjectFilter;
import com.snmp4j.smi.SmiObjectType;
import com.snmp4j.smi.SmiObjectTypeIndex;
import com.snmp4j.smi.SmiObjectVariation;
import com.snmp4j.smi.SmiParseException;
import com.snmp4j.smi.SmiRevision;
import com.snmp4j.smi.SmiStatus;
import com.snmp4j.smi.SmiSupportedModule;
import com.snmp4j.smi.SmiSyntax;
import com.snmp4j.smi.SmiSyntaxElement;
import com.snmp4j.smi.SmiSyntaxElementImpl;
import com.snmp4j.smi.SmiSyntaxImpl;
import com.snmp4j.smi.SmiSyntaxType;
import com.snmp4j.smi.SmiTextualConvention;
import com.snmp4j.smi.SmiType;
import com.snmp4j.smi.SmiValueType;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.MaxAccess;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.OIDTextFormat;
import org.snmp4j.util.SimpleOIDTextFormat;
import org.snmp4j.util.VariableTextFormat;

public final class SmiManager
implements OIDTextFormat,
VariableTextFormat,
SmiCompiler {
    private static final LogAdapter logger = LogFactory.getLogger(SmiManager.class);
    private static final String MIB_REPOSITORY_STORE_FILENAME = "com.agentpp.smi.storeMIBFileName";
    private DefaultRepositoryManager repositoryManager;
    private final MIBRepository repository = new MIBRepository();
    private final Set<String> loadedModules = new HashSet<String>();
    private OctetStringDefaultFormat octetStringDisplayHint = OctetStringDefaultFormat.MIB;
    private OIDFormat oidFormat = OIDFormat.ObjectNameAndDecodedIndex4RoundTrip;
    private NonPrintableStringFormat oidFormatNonPrintableStrings = NonPrintableStringFormat.asIs;
    private int fileCount = 1;
    private RepositoryDriver repositoryDriver;
    private transient boolean limited = true;
    private transient boolean proEdition = false;
    private char oidFixedLengthStringQuote = (char)39;
    private char oidVariableLengthStringQuote = (char)34;
    private String oidFixedLengthStringQuoteEscapeSequence = "\\'";
    private String oidVariableLengthStringQuoteEscapeSequence = "\\\"";
    private char oidStringQuoteEscapeCharacter = (char)92;

    public SmiManager(String licenseKey, File repositoryDirectory) throws IOException {
        this(licenseKey);
        if (!(repositoryDirectory.isDirectory() && repositoryDirectory.canRead() && repositoryDirectory.canWrite())) {
            throw new IOException("MIB repository directory is not accessible: " + repositoryDirectory);
        }
        this.octetStringDisplayHint = OctetStringDefaultFormat.ASCII;
        this.repositoryManager = new DefaultRepositoryManager();
        this.repositoryManager.verbose = false;
        this.repositoryManager.addRepositoryListener(new RepositoryAdapter());
        this.repositoryManager.open(repositoryDirectory);
        String[] files = repositoryDirectory.list();
        this.fileCount = files == null ? 0 : files.length;
    }

    public SmiManager(String licenseKey, RepositoryDriver repositoryDriver) {
        this(licenseKey);
        this.repositoryDriver = repositoryDriver;
        this.octetStringDisplayHint = OctetStringDefaultFormat.ASCII;
        this.repositoryManager = new DefaultRepositoryManager();
        this.repositoryManager.verbose = false;
        this.repositoryManager.setUseCompression(true);
        RepositoryAdapter repositoryAdapter = new RepositoryAdapter();
        this.repositoryManager.addRepositoryListener(repositoryAdapter);
    }

    public SmiManager useCompression(boolean enableCompressionOfCompiledModules) {
        this.repositoryManager.setUseCompression(enableCompressionOfCompiledModules);
        return this;
    }

    public boolean isUseCompression() {
        return this.repositoryManager.isUseCompression();
    }

    private SmiManager(String licenseKey) {
        if (licenseKey == null) {
            this.limited = true;
        } else {
            block7: {
                try {
                    byte[] lic;
                    String[] licFragments = licenseKey.split("/");
                    if (licFragments[0].startsWith("bf 6 5d 61 f ec b0 b4")) {
                        System.err.println("Invalid license, aborting!");
                        System.exit(1);
                    }
                    if (this.getTime(lic = Val.fromHexString(licFragments[0].trim()), licFragments[1].trim().getBytes())) break block7;
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.err.println("Invalid license, aborting!");
                    System.exit(1);
                }
                catch (Exception ex) {
                    System.err.println("Invalid license, aborting!");
                    System.exit(1);
                }
            }
            this.limited = false;
        }
    }

    public OIDFormat getOidFormat() {
        return this.oidFormat;
    }

    public void setOidFormat(OIDFormat oidFormat) {
        this.oidFormat = oidFormat;
    }

    public OctetStringDefaultFormat getOctetStringDisplayHint() {
        return this.octetStringDisplayHint;
    }

    public void setOctetStringDisplayHint(OctetStringDefaultFormat octetStringDisplayHint) {
        this.octetStringDisplayHint = octetStringDisplayHint;
    }

    private boolean getTime(byte[] l, byte[] k) {
        byte[] lic = Val.decrypt(l, new String(k).toCharArray());
        if (lic == null || lic.length < 7 || lic[0] != 7 && lic[0] != 8 || lic[1] != 1) {
            return false;
        }
        if (lic[0] == 8) {
            this.proEdition = true;
        }
        GregorianCalendar licGC = new GregorianCalendar(2000 + lic[4], lic[5] - 1, lic[6]);
        GregorianCalendar now = new GregorianCalendar();
        return lic[4] == 0 && lic[5] == 0 && lic[6] == 0 || !licGC.getTime().before(now.getTime());
    }

    public final String[] listModules() throws IOException {
        try {
            return this.repositoryManager.getModuleNames();
        }
        catch (IOException iox) {
            throw new IOException(iox.getMessage());
        }
    }

    public final String[] getLoadedModuleNames() {
        Vector<String> moduleNames = this.repository.getModuleNames();
        return moduleNames.toArray(new String[0]);
    }

    public final String[] getExplicitlyLoadedModuleNames() {
        return this.loadedModules.toArray(new String[0]);
    }

    public final List<SmiModule> getLoadedSmiModules() throws IOException {
        String[] modules = this.getLoadedModuleNames();
        ArrayList<SmiModule> smiModules = new ArrayList<SmiModule>(modules.length);
        for (String moduleName : modules) {
            SmiModule loadedModule = this.findSmiModule(moduleName);
            if (loadedModule != null) {
                smiModules.add(loadedModule);
                continue;
            }
            logger.warn((Serializable)((Object)("Loaded MODULE '" + moduleName + "' could not be found in repository, inconsistent state detected")));
        }
        return smiModules;
    }

    public synchronized boolean loadModule(String moduleName) {
        MIBModule module = null;
        try {
            module = this.repositoryManager.getModule(moduleName, true);
        }
        catch (IOException e) {
            return false;
        }
        return this.loadModuleInternally(module, true);
    }

    private boolean loadModuleInternally(MIBModule module, boolean removeExistingObjects) {
        if (module == null) {
            return false;
        }
        HashMap<String, Integer> importedModules = new HashMap<String, Integer>();
        try {
            MIBObject[] imported = this.repositoryManager.getImportedObjects(module.getModuleName());
            this.repository.addAllObjects(imported, null, removeExistingObjects, importedModules);
            this.repository.addObject(module);
            this.repository.addAllObjects(module.getObjects(), module, removeExistingObjects, importedModules);
            this.repository.addImportedModuleIDsInverted(importedModules);
            this.loadedModules.add(module.getModuleName());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean[] loadModules(String[] moduleNames, int maxThreads, boolean overwriteExistingObjects) {
        int threadCount = Math.min(moduleNames.length, maxThreads);
        if (threadCount < 1) {
            boolean[] result = new boolean[moduleNames.length];
            for (int i = 0; i < moduleNames.length; ++i) {
                MIBModule module = this.loadModuleOnly(moduleNames[i]);
                result[i] = this.loadModuleInternally(module, overwriteExistingObjects);
            }
            return result;
        }
        ExecutorService executor = Executors.newFixedThreadPool(threadCount, (ThreadFactory)SNMP4JSettings.getThreadFactory());
        ArrayList<Callable<MIBModule>> moduleTasks = new ArrayList<Callable<MIBModule>>();
        for (String moduleName : moduleNames) {
            moduleTasks.add(() -> this.loadModuleOnly(moduleName));
        }
        MIBModule[] modules = new MIBModule[moduleNames.length];
        try {
            List futures = executor.invokeAll(moduleTasks);
            for (int i = 0; i < futures.size(); ++i) {
                modules[i] = (MIBModule)futures.get(i).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error loading modules", e);
        }
        ArrayList<Callable<Boolean>> tasks = new ArrayList<Callable<Boolean>>();
        for (MIBModule module : modules) {
            tasks.add(() -> this.loadModuleInternally(module, true));
        }
        boolean[] result = new boolean[moduleNames.length];
        try {
            List futures = executor.invokeAll(tasks);
            for (int i = 0; i < futures.size(); ++i) {
                result[i] = (Boolean)futures.get(i).get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Error loading modules", e);
        }
        finally {
            executor.shutdown();
        }
        return result;
    }

    private MIBModule loadModuleOnly(String moduleName) {
        try {
            return this.repositoryManager.getModule(moduleName, true);
        }
        catch (IOException e) {
            return null;
        }
    }

    public synchronized boolean unloadModule(String moduleName) {
        if (this.repository.removeModule(moduleName)) {
            this.loadedModules.remove(moduleName);
            return true;
        }
        return false;
    }

    public synchronized void resetModules() {
        this.repository.clear();
        this.loadedModules.clear();
    }

    public final synchronized int unloadModuleWithDependencies(String moduleName) {
        MIBModule mibModule = this.repository.getModule(moduleName);
        this.loadedModules.remove(moduleName);
        if (mibModule != null) {
            return this.repository.remove(mibModule, this.loadedModules);
        }
        return 0;
    }

    public final boolean isModuleLoaded(String moduleName) {
        return this.repository.getModule(moduleName) != null;
    }

    public final List<String> deleteModule(String moduleName, boolean forceDeletion) {
        ArrayList<String> dependentModuleNames = new ArrayList<String>();
        try {
            if (!forceDeletion) {
                ModuleInfo[] moduleInfos;
                for (ModuleInfo info : moduleInfos = this.repositoryManager.getModuleInfos()) {
                    if (moduleName.equals(info.getModuleName()) || !info.importsFrom(moduleName)) continue;
                    dependentModuleNames.add(info.getModuleName());
                }
            }
            if (dependentModuleNames.isEmpty() && !this.repositoryManager.removeModule(moduleName)) {
                dependentModuleNames.add(moduleName);
            }
        }
        catch (IOException e) {
            logger.error((CharSequence)("IO error while deleting MIB module '" + moduleName + "': " + e.getMessage()), (Throwable)e);
            dependentModuleNames.add(moduleName);
        }
        return dependentModuleNames;
    }

    public final String[] compile(File textOrZipFile) throws SmiParseException, FileNotFoundException {
        NamedInputStream namedInputStream = this.createNamedInputStream(textOrZipFile);
        String[] moduleNames = this.compile(namedInputStream);
        try {
            namedInputStream.getInputStream().close();
        }
        catch (IOException e) {
            logger.error((CharSequence)"IOException while closing FileInputStream in compile(File): ", (Throwable)e);
        }
        return moduleNames;
    }

    public void resetOidQuoting() {
        this.oidFixedLengthStringQuote = (char)39;
        this.oidVariableLengthStringQuote = (char)34;
        this.oidFixedLengthStringQuoteEscapeSequence = "\\'";
        this.oidVariableLengthStringQuoteEscapeSequence = "\\\"";
        this.oidStringQuoteEscapeCharacter = (char)92;
    }

    public char getOidFixedLengthStringQuote() {
        return this.oidFixedLengthStringQuote;
    }

    public void setOidFixedLengthStringQuote(char oidFixedLengthStringQuote) {
        this.oidFixedLengthStringQuote = oidFixedLengthStringQuote;
    }

    public char getOidVariableLengthStringQuote() {
        return this.oidVariableLengthStringQuote;
    }

    public void setOidVariableLengthStringQuote(char oidVariableLengthStringQuote) {
        this.oidVariableLengthStringQuote = oidVariableLengthStringQuote;
    }

    public String getOidFixedLengthStringQuoteEscapeSequence() {
        return this.oidFixedLengthStringQuoteEscapeSequence;
    }

    public void setOidFixedLengthStringQuoteEscapeSequence(String oidFixedLengthStringQuoteEscapeSequence) {
        this.oidFixedLengthStringQuoteEscapeSequence = oidFixedLengthStringQuoteEscapeSequence;
    }

    public String getOidVariableLengthStringQuoteEscapeSequence() {
        return this.oidVariableLengthStringQuoteEscapeSequence;
    }

    public void setOidVariableLengthStringQuoteEscapeSequence(String oidVariableLengthStringQuoteEscapeSequence) {
        this.oidVariableLengthStringQuoteEscapeSequence = oidVariableLengthStringQuoteEscapeSequence;
    }

    public char getOidStringQuoteEscapeCharacter() {
        return this.oidStringQuoteEscapeCharacter;
    }

    public void setOidStringQuoteEscapeCharacter(char oidStringQuoteEscapeCharacter) {
        this.oidStringQuoteEscapeCharacter = oidStringQuoteEscapeCharacter;
    }

    private NamedInputStream createNamedInputStream(File textOrZipFile) throws FileNotFoundException {
        NamedInputStream.ZipFormat zipFormat = NamedInputStream.ZipFormat.none;
        if (textOrZipFile.getName().toLowerCase().endsWith(".zip")) {
            zipFormat = NamedInputStream.ZipFormat.ZIP;
        }
        FileInputStream fileInputStream = new FileInputStream(textOrZipFile);
        return new NamedInputStream(fileInputStream, textOrZipFile.getPath(), zipFormat);
    }

    public String[] compile(NamedInputStream mibFile) throws SmiParseException {
        String fileName = "SNMP4J-SMI_" + this.fileCount++;
        if (mibFile.getName() != null) {
            fileName = mibFile.getName();
        }
        try {
            ModuleInfo[] moduleInfos = this.repositoryManager.addModules(mibFile.getInputStream(), fileName);
            String[] moduleNames = new String[moduleInfos.length];
            for (int i = 0; i < moduleInfos.length; ++i) {
                moduleNames[i] = moduleInfos[i].getModuleName();
            }
            return moduleNames;
        }
        catch (SMIParseException parseException) {
            throw this.createSmiParseException(parseException, fileName);
        }
    }

    public List<CompilationResult> compile(File[] files, CompilationMonitor compilationMonitor, boolean loadIntoRepository, boolean updateExistent, boolean compileLeniently) throws IOException {
        NamedInputStream[] namedInputStreams = new NamedInputStream[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                namedInputStreams[i] = this.createNamedInputStream(files[i]);
            }
            List<CompilationResult> i = this.compile(namedInputStreams, compilationMonitor, loadIntoRepository, updateExistent, compileLeniently);
            return i;
        }
        catch (IOException iox) {
            throw iox;
        }
        finally {
            for (NamedInputStream namedInputStream : namedInputStreams) {
                namedInputStream.getInputStream().close();
            }
        }
    }

    @Override
    public List<CompilationResult> compile(NamedInputStream[] files, CompilationMonitor compilationMonitor, SmiCompiler.TargetMode compilerTargetMode, SmiCompiler.OverwriteMode overwriteMode, SmiCompiler.Strictness strictness) throws IOException {
        ArrayList cachedFiles = new ArrayList(files.length);
        int n = 1;
        for (NamedInputStream namedInputStream : files) {
            if (compilationMonitor != null && !compilationMonitor.loadingProgress(namedInputStream.getName(), n++, files.length)) break;
            cachedFiles.addAll(CachedNamedInputStream.createCachedStreams(namedInputStream));
        }
        ArrayList<CompilationResult> results = new ArrayList<CompilationResult>();
        int total = 0;
        ArrayList<ModuleInfo> v = new ArrayList<ModuleInfo>(cachedFiles.size());
        boolean cancelled = false;
        for (int j = 0; !cancelled && j < cachedFiles.size(); ++j) {
            ModuleInfo[] file = (ModuleInfo[])cachedFiles.get(j);
            try {
                ModuleInfo[] info;
                cancelled = compilationMonitor != null && !compilationMonitor.sortingProgress(file.getName(), j + 1, cachedFiles.size());
                for (ModuleInfo moduleInfo : info = this.repositoryManager.getModuleInfo(file.getCachedInputStream(), file.getName())) {
                    moduleInfo.userObject = file;
                    Collections.addAll(v, info);
                }
                continue;
            }
            catch (Exception ex) {
                ModuleInfo inf = new ModuleInfo("invalid ");
                inf.path = new File(file.getName());
                inf.userObject = file;
                v.add(inf);
            }
        }
        if (cancelled) {
            return Collections.emptyList();
        }
        ModuleInfo[] existent = this.repositoryManager.getModuleInfos();
        if (overwriteMode != SmiCompiler.OverwriteMode.overwriteAlways) {
            for (ModuleInfo anExistent : existent) {
                for (int j = 0; j < v.size(); ++j) {
                    ModuleInfo inf = (ModuleInfo)v.get(j);
                    if (!inf.getModuleName().equals(anExistent.getModuleName()) || overwriteMode == SmiCompiler.OverwriteMode.overwriteIfNewer && this.isModuleInfoNewer(anExistent, inf)) continue;
                    v.remove(j);
                    --j;
                }
            }
        }
        LinkedHashMap<String, ModuleInfo> h = new LinkedHashMap<String, ModuleInfo>();
        for (ModuleInfo inf : v) {
            ModuleInfo prev = (ModuleInfo)h.get(inf.getModuleName());
            if (prev != null && !this.isModuleInfoNewer(prev, inf)) continue;
            h.put(inf.getModuleName(), inf);
        }
        ModuleInfo[] list = h.values().toArray(new ModuleInfo[0]);
        v = null;
        ModuleInfoSorter s = new ModuleInfoSorter(list);
        s.setPool(existent);
        s.setBackupPool(this.repositoryManager.getBuiltinModuleNames());
        s.sort();
        ModuleInfo[] sorted = s.getSortedList();
        ModuleInfo[] failed = s.getFailedList();
        ArrayList<CachedNamedInputStream> files4Parsing = new ArrayList<CachedNamedInputStream>(sorted.length + failed.length);
        for (ModuleInfo sm : sorted) {
            files4Parsing.add((CachedNamedInputStream)sm.userObject);
        }
        for (ModuleInfo fm : failed) {
            files4Parsing.add((CachedNamedInputStream)fm.userObject);
        }
        CachedNamedInputStream currentFile = null;
        HashSet<CachedNamedInputStream> parsed = new HashSet<CachedNamedInputStream>();
        Iterator iterator = files4Parsing.iterator();
        while (iterator.hasNext()) {
            CachedNamedInputStream file2Parse;
            currentFile = file2Parse = (CachedNamedInputStream)iterator.next();
            if (parsed.contains(file2Parse)) {
                ++total;
                continue;
            }
            parsed.add(file2Parse);
            ++total;
            try {
                ModuleInfo[] info = compilerTargetMode == SmiCompiler.TargetMode.dryRun || compilerTargetMode == SmiCompiler.TargetMode.dryRunWithoutErrorLimit ? this.repositoryManager.checkModules(file2Parse.getCachedInputStream(), strictness == SmiCompiler.Strictness.lenient, compilerTargetMode == SmiCompiler.TargetMode.dryRunWithoutErrorLimit) : (strictness == SmiCompiler.Strictness.lenient ? this.repositoryManager.addModulesLeniently(file2Parse.getCachedInputStream(), file2Parse.getName()) : this.repositoryManager.addModules(file2Parse.getCachedInputStream(), file2Parse.getName()));
                ArrayList<String> m = new ArrayList<String>();
                for (ModuleInfo anInfo : info) {
                    m.add(anInfo.moduleName);
                    if (compilerTargetMode != SmiCompiler.TargetMode.storeIntoRepositoryAndLoad) continue;
                    this.loadModuleInternally(this.repositoryManager.getModule(anInfo.moduleName, true), false);
                }
                if (compilationMonitor != null && !compilationMonitor.compilationProgress(m.isEmpty() ? null : (String)m.get(0), total, files4Parsing.size())) break;
                results.add(new CompilationResult(file2Parse.getName(), m, null, file2Parse.zipFileName));
            }
            catch (SMIParseException pex) {
                pex.freeUnusedTokens();
                results.add(new CompilationResult(currentFile.getName(), null, this.createSmiParseException(pex, currentFile.getName()).getErrorList(), currentFile.zipFileName));
            }
        }
        return results;
    }

    private boolean isModuleInfoNewer(ModuleInfo existing, ModuleInfo checkIfNewer) {
        return existing.getLastUpdated() == null && checkIfNewer.getLastUpdated() != null || existing.getLastUpdated() != null && checkIfNewer.getLastUpdated() != null && checkIfNewer.getLastUpdated().after(existing.getLastUpdated());
    }

    public List<CompilationResult> compile(NamedInputStream[] files, CompilationMonitor compilationMonitor, boolean loadIntoRepository, boolean updateExistent, boolean compileLeniently) throws IOException {
        return this.compile(files, compilationMonitor, loadIntoRepository ? SmiCompiler.TargetMode.storeIntoRepositoryAndLoad : SmiCompiler.TargetMode.storeIntoRepositoryNoLoad, updateExistent ? SmiCompiler.OverwriteMode.overwriteAlways : SmiCompiler.OverwriteMode.addNewOnly, compileLeniently ? SmiCompiler.Strictness.lenient : SmiCompiler.Strictness.standard);
    }

    private ValueConverter createValueConverter(MIBObjectType ot) {
        MIBTextualConvention tc = this.repository.getEffectiveSyntax(ot.getSyntax());
        String displayHint = tc.getDisplayHint();
        if (displayHint == null && this.octetStringDisplayHint != null && !this.octetStringDisplayHint.getDisplayHint().isEmpty()) {
            displayHint = this.octetStringDisplayHint.getDisplayHint();
        }
        return new ValueConverter(ot, tc.getSyntax(), displayHint);
    }

    private SmiParseException createSmiParseException(SMIParseException parseException, String fileName) {
        ArrayList<SmiError> errorList = new ArrayList<SmiError>();
        List<SMIParseException> parseExceptionList = parseException.getErrorList() != null && !parseException.getErrorList().isEmpty() ? parseException.getErrorList() : Collections.singletonList(parseException);
        for (SMIParseException pex : parseExceptionList) {
            String errorText = "[" + fileName + "] " + DefaultRepositoryManager.getErrorText(pex);
            String shortErrorText = DefaultRepositoryManager.getErrorText(pex, false, false);
            int row = -1;
            int col = -1;
            int endRow = -1;
            int endCol = -1;
            String offendingText = null;
            int position = -1;
            int errorNumber = pex.errorType;
            String[] expectedText = null;
            if (pex.fileError != null) {
                row = pex.fileError.getLine();
                col = pex.fileError.getColumn();
                endRow = pex.fileError.getEndLine();
                endCol = pex.fileError.getEndColumn();
                errorNumber = pex.fileError.getErrorType();
                offendingText = pex.fileError.getFoundTokenImage() == null ? pex.fileError.getFound() : pex.fileError.getFoundTokenImage();
                position = pex.fileError.getEndPosition();
                if (offendingText != null) {
                    position = Math.max(0, position - offendingText.length());
                }
                expectedText = pex.fileError.getLastExpectedImages();
            }
            errorList.add(new SmiError(fileName, row, col, endRow, endCol, position, errorNumber, errorText, shortErrorText, offendingText, expectedText));
        }
        Collections.sort(errorList, new SmiErrorComparator());
        return new SmiParseException(errorList);
    }

    public final String format(OID instanceOID, Variable variable, boolean withOID) {
        Object o;
        MIBObjectType ot;
        StringBuilder buf = new StringBuilder();
        if (withOID) {
            buf.append(this.format(instanceOID.getValue()));
            buf.append(" = ");
        }
        ValueConverter vc = (ot = this.repository.getObjectType(new ObjectID(instanceOID.getValue()))) != null ? this.createValueConverter(ot) : new ValueConverter(variable.getClass());
        if (this.octetStringDisplayHint != null && this.octetStringDisplayHint.getDisplayHint().length() > 0) {
            vc.setDisplayHint(this.octetStringDisplayHint.getDisplayHint());
        }
        if ((o = vc.toNative(variable, true)) != null) {
            buf.append(o.toString());
        } else {
            buf.append(variable.toString());
        }
        return buf.toString();
    }

    public final VariableBinding parseVariableBinding(String text) throws ParseException {
        int assignmentPos = text.indexOf(" = ");
        if (assignmentPos <= 0) {
            throw new ParseException("Could not locate assignment ' = ' string in '" + text, 0);
        }
        OID oid = new OID(this.parse(text.substring(0, assignmentPos)));
        Variable var = this.parse(oid, text.substring(assignmentPos + 3));
        return new VariableBinding(oid, var);
    }

    public final Variable parse(OID classOrInstanceOID, String text) throws ParseException {
        ValueConverter vc = null;
        MIBObjectType ot = this.repository.getObjectType(new ObjectID(classOrInstanceOID.getValue()));
        if (ot != null) {
            vc = this.createValueConverter(ot);
        }
        if (vc == null) {
            return null;
        }
        Variable value = vc.fromString(text);
        return value;
    }

    public final Variable parse(int smiSyntax, String text) throws ParseException {
        ValueConverter vc = new ValueConverter(ValueConverter.getSmiSyntax(smiSyntax));
        return vc.fromString(text);
    }

    public final String format(int[] value) {
        ObjectID oid = new ObjectID(value);
        switch (this.oidFormat) {
            case ObjectNameNumIndex: {
                return this.repository.getPathSuffix(oid);
            }
            case ObjectNameAndDecodedIndex: {
                return this.getPathSuffixWithIndex(oid);
            }
            case ObjectNameAndDecodedIndex4RoundTrip: {
                return this.getPathSuffixWithIndex4RoundTrip(oid);
            }
            case NameAndNumber: {
                return this.repository.getPath(new ObjectID(value), true);
            }
        }
        return oid.toString();
    }

    public String formatForRoundTrip(int[] value) {
        switch (this.oidFormat) {
            case ObjectNameNumIndex: 
            case ObjectNameAndDecodedIndex: {
                return this.repository.getPathSuffix(new ObjectID(value));
            }
            case ObjectNameAndDecodedIndex4RoundTrip: {
                return this.getPathSuffixWithIndex4RoundTrip(new ObjectID(value));
            }
            case NameAndNumber: {
                return this.repository.getPath(new ObjectID(value), true);
            }
        }
        return SimpleOIDTextFormat.formatOID((int[])value);
    }

    public final int[] parse(String text) throws ParseException {
        ObjectID oid;
        int pos;
        String oidText = text;
        if (oidText.length() == 0) {
            return new int[0];
        }
        String moduleName = null;
        if (Character.isUpperCase(oidText.charAt(0))) {
            pos = oidText.indexOf(58);
            if (pos < 0) {
                pos = oidText.indexOf(46);
            }
            if (pos > 0) {
                moduleName = oidText.substring(0, pos);
                if (!this.isModuleLoaded(moduleName) && !this.loadModule(moduleName)) {
                    throw new ParseException("MIB module '" + moduleName + "' not found", 0);
                }
                oidText = oidText.substring(pos + 1);
            }
        }
        if (this.oidFormat == OIDFormat.NameAndNumber) {
            String[] subIdentifiers = oidText.split("\\.");
            int[] subIDs = new int[subIdentifiers.length];
            for (int i = 0; i < subIdentifiers.length; ++i) {
                if (subIdentifiers[i].endsWith(")")) {
                    int startPos = subIdentifiers[i].indexOf(40);
                    if (startPos < 0) {
                        throw new ParseException(subIdentifiers[i], i);
                    }
                    subIDs[i] = Long.valueOf(subIdentifiers[i].substring(startPos + 1, subIdentifiers[i].length() - 1)).intValue();
                    continue;
                }
                subIDs[i] = Long.valueOf(subIdentifiers[i]).intValue();
            }
            return subIDs;
        }
        if (this.oidFormat == OIDFormat.ObjectNameAndDecodedIndex4RoundTrip) {
            pos = oidText.indexOf(46);
            char c = oidText.charAt(0);
            if (pos >= 0 && (Character.isLetter(c) || c == this.oidFixedLengthStringQuote || c == this.oidVariableLengthStringQuote)) {
                MIBObject o;
                String indexSuffix = oidText.substring(pos + 1);
                oidText = oidText.substring(0, pos);
                MIBObject mIBObject = o = moduleName != null ? this.repository.getObject(moduleName, oidText) : this.repository.getObject(oidText);
                if (o instanceof MIBObjectType) {
                    MIBObjectType ot = (MIBObjectType)o;
                    if (ot.isColumnarObject()) {
                        MIBObject entry = this.repository.getParent(ot);
                        if (entry instanceof MIBObjectType) {
                            MIBObjectType table = (MIBObjectType)entry;
                            try {
                                int i;
                                OID oid2 = new OID(ot.getOid().asIntArray());
                                IndexStruct[] indexStructs = table.getIndexPart().getIndexStruct(this.repository);
                                List<String> subIndexes = SmiManager.tokenizeQuotedString(indexSuffix, "" + this.oidVariableLengthStringQuote + this.oidFixedLengthStringQuote, this.oidStringQuoteEscapeCharacter, ".", true);
                                ValueConverter[] vcs = IndexConverter.getIndexValueConverter(this.repository, table);
                                int offset = 0;
                                boolean parseComplete = false;
                                for (i = 0; i < Math.min(subIndexes.size(), Math.min(vcs.length, indexStructs.length)); ++i) {
                                    String s = subIndexes.get(i + offset);
                                    if (s.charAt(0) == this.oidVariableLengthStringQuote || s.charAt(0) == this.oidFixedLengthStringQuote) {
                                        Variable variable;
                                        if ((s = s.substring(1, s.length() - 1)).length() > 2) {
                                            if (s.charAt(0) == '#') {
                                                IndexConverter.StringFormat format = IndexConverter.StringFormat.getFormat(s.substring(0, 2));
                                                OctetString os = OctetString.fromString((String)s.substring(2, s.length()), (char)format.getDelimiter(), (int)format.getRadix());
                                                s = new String(os.getValue());
                                            } else if (s.charAt(0) == this.oidStringQuoteEscapeCharacter) {
                                                s = s.substring(1);
                                            }
                                        }
                                        if ((variable = vcs[i].fromString(s)) == null) continue;
                                        oid2.append(variable.toSubIndex(indexStructs[i].impliedLength));
                                        continue;
                                    }
                                    if (indexStructs[i].impliedLength) {
                                        for (int j = i + offset; j < subIndexes.size(); ++j) {
                                            oid2.append(subIndexes.get(j));
                                        }
                                        parseComplete = true;
                                        break;
                                    }
                                    if (indexStructs[i].minLength == indexStructs[i].maxLength) {
                                        int count = indexStructs[i].minLength;
                                        for (int j = i + offset; j < subIndexes.size() && j < i + offset + count; ++j) {
                                            oid2.append(subIndexes.get(j));
                                        }
                                        offset += count - 1;
                                        continue;
                                    }
                                    int count = Integer.parseInt(s);
                                    for (int j = i + offset; j < subIndexes.size() && j < i + offset + count + 1; ++j) {
                                        oid2.append(subIndexes.get(j));
                                    }
                                    offset += count;
                                }
                                if (!parseComplete && subIndexes.size() > i + offset) {
                                    this.parseIndex(indexSuffix, i, oid2);
                                }
                                return oid2.getValue();
                            }
                            catch (ObjectIDFormatException objectIDFormatException) {
                                // empty catch block
                            }
                        }
                        oidText = oidText + '.' + indexSuffix;
                    } else if (ot.isScalar()) {
                        oidText = oidText + '.' + indexSuffix;
                    }
                } else if (o != null) {
                    try {
                        OID oid3 = new OID(o.getOid().asIntArray());
                        this.parseIndex(indexSuffix, 0, oid3);
                        return oid3.getValue();
                    }
                    catch (ObjectIDFormatException objectIDFormatException) {
                        // empty catch block
                    }
                }
            }
        }
        if ((oid = this.repository.resolveOID(new ObjectID(oidText))) == null) {
            throw new ParseException("Could not resolve OID '" + text + "'", 0);
        }
        try {
            return oid.asIntArray();
        }
        catch (ObjectIDFormatException ex) {
            throw new ParseException("Could not resolve OID '" + oid + "'", 0);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseIndex(String indexSuffix, int subIndexOffset, OID oid) {
        subIndexes = SmiManager.tokenizeQuotedString(indexSuffix, "" + this.oidFixedLengthStringQuote + this.oidVariableLengthStringQuote, this.oidStringQuoteEscapeCharacter, ".", true);
        prefix = "" + this.oidStringQuoteEscapeCharacter + "#";
        while (subIndexOffset < subIndexes.size()) {
            block5: {
                block6: {
                    subIndex = subIndexes.get(subIndexOffset);
                    if (subIndex.isEmpty()) break block5;
                    sc = subIndex.charAt(0);
                    if (sc != this.oidFixedLengthStringQuote && sc != this.oidVariableLengthStringQuote) break block6;
                    if (subIndex.length() <= 2) ** GOTO lbl-1000
                    if (subIndex.charAt(1) == '#') {
                        format = IndexConverter.StringFormat.getFormat(subIndex.substring(1, 3));
                        os = OctetString.fromString((String)subIndex.substring(3, subIndex.length() - 1), (char)format.getDelimiter(), (int)format.getRadix());
                        oid.append(os.toSubIndex(sc == '\''));
                    } else if (subIndex.startsWith(prefix, 1)) {
                        oid.append(new OctetString(subIndex.substring(2, subIndex.length() - 1)).toSubIndex(sc == this.oidFixedLengthStringQuote));
                    } else lbl-1000:
                    // 2 sources

                    {
                        oid.append(new OctetString(subIndex.substring(1, subIndex.length() - 1)).toSubIndex(sc == this.oidFixedLengthStringQuote));
                    }
                    break block5;
                }
                oid.append(new OID(subIndex));
            }
            ++subIndexOffset;
        }
    }

    public static List<String> tokenizeQuotedString(String text, String quotes, char escapeChar, String delimiter, boolean includeQuotes) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int posEscape = -1;
        boolean inQuotes = false;
        Character lastQuote = null;
        boolean inEscape = false;
        StringBuilder buffer = new StringBuilder();
        for (int current = 0; current < text.length(); ++current) {
            boolean atLastChar;
            char c = text.charAt(current);
            if (c == escapeChar) {
                if (inEscape) {
                    inEscape = false;
                    buffer.append(text.substring(start, posEscape)).append(c);
                    start = current + 1;
                    continue;
                }
                inEscape = true;
                posEscape = current;
                continue;
            }
            if (inEscape) {
                inEscape = false;
                buffer.append(text.substring(start, posEscape)).append(c);
                start = current + 1;
                continue;
            }
            if (quotes.indexOf(c) >= 0) {
                if (lastQuote == null) {
                    inQuotes = true;
                    lastQuote = Character.valueOf(c);
                    if (!includeQuotes) {
                        buffer.append(text.substring(start, current));
                        start = current + 1;
                    }
                } else if (lastQuote.charValue() == c) {
                    inQuotes = false;
                    lastQuote = null;
                    if (!includeQuotes) {
                        buffer.append(text.substring(start, current));
                        start = current + 1;
                    }
                }
            }
            boolean bl = atLastChar = current == text.length() - 1;
            if (atLastChar) {
                result.add(buffer.toString() + text.substring(start));
                buffer.setLength(0);
                continue;
            }
            if (delimiter.indexOf(text.charAt(current)) < 0 || inQuotes) continue;
            result.add(buffer.toString() + text.substring(start, current));
            start = current + 1;
            buffer.setLength(0);
        }
        return result;
    }

    private String getPathSuffixWithIndex(ObjectID oid) {
        try {
            Pair p = this.repository.getSplittedObjectID(oid);
            if (p.second != null && ((ObjectID)p.second).size() > 0) {
                ObjectID entry = (ObjectID)p.first;
                ObjectID index = (ObjectID)p.second;
                MIBObject o = this.repository.getObject(entry);
                MIBObjectType ot = (MIBObjectType)this.repository.getParent(o);
                if (ot != null) {
                    IndexStruct[] ind;
                    if (ot.getIndexPart().isAugment()) {
                        ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
                    }
                    if ((ind = ot.getIndexPart().getIndexStruct(this.repository)) != null) {
                        try {
                            ObjectID[] iIDs = this.repository.getIndexObjectIDs(index, ind);
                            ValueConverter[] indexValueConverter = this.getIndexValueConverter(ot);
                            return o.getName() + "." + IndexConverter.getIndexString(indexValueConverter, ind, iIDs);
                        }
                        catch (NullPointerException npex) {
                            npex.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.repository.getPathSuffix(oid);
    }

    private String getPathSuffixWithIndex4RoundTrip(ObjectID oid) {
        block6: {
            try {
                IndexStruct[] ind;
                Pair p = this.repository.getSplittedObjectID(oid);
                if (p.second == null || ((ObjectID)p.second).isEmpty()) break block6;
                ObjectID entry = (ObjectID)p.first;
                ObjectID index = (ObjectID)p.second;
                MIBObject o = this.repository.getObject(entry);
                MIBObject parent = this.repository.getParent(o);
                if (!(parent instanceof MIBObjectType)) break block6;
                MIBObjectType ot = (MIBObjectType)parent;
                if (ot.getIndexPart().isAugment()) {
                    ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
                }
                if ((ind = ot.getIndexPart().getIndexStruct(this.repository)) == null) break block6;
                try {
                    ObjectID[] iIDs = this.repository.getIndexObjectIDs(index, ind);
                    ValueConverter[] indexValueConverter = this.getIndexValueConverter(ot);
                    if (iIDs != null && indexValueConverter != null) {
                        return o.getName() + "." + IndexConverter.getIndexString(indexValueConverter, ind, iIDs, true, "" + this.oidFixedLengthStringQuote, "" + this.oidVariableLengthStringQuote, this.oidFixedLengthStringQuoteEscapeSequence, this.oidVariableLengthStringQuoteEscapeSequence, IndexConverter.StringFormat.getFormat(this.oidFormatNonPrintableStrings.getRadix()));
                    }
                }
                catch (NullPointerException npex) {
                    npex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.repository.getPathSuffix(oid);
    }

    public NonPrintableStringFormat getOidFormatNonPrintableStrings() {
        return this.oidFormatNonPrintableStrings;
    }

    public void setOidFormatNonPrintableStrings(NonPrintableStringFormat oidFormatNonPrintableStrings) {
        if (oidFormatNonPrintableStrings == null) {
            throw new NullPointerException();
        }
        this.oidFormatNonPrintableStrings = oidFormatNonPrintableStrings;
    }

    public Variable[] getIndexVariables(OID table, OID index) {
        MIBObjectType ot;
        MIBObject o = this.repository.getObject(new ObjectID(table.getValue()));
        if (o instanceof MIBObjectType && (ot = (MIBObjectType)o).getIndexPart() != null) {
            IndexStruct[] ind;
            if (ot.getIndexPart().isAugment()) {
                ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
            }
            if ((ind = ot.getIndexPart().getIndexStruct(this.repository)) != null) {
                ObjectID[] iIDs = this.repository.getIndexObjectIDs(new ObjectID(index.getValue()), ind);
                return IndexConverter.getIndexVariables(ind, iIDs);
            }
        }
        return null;
    }

    public String getIndexStringFromVariables(OID table, List<VariableBinding> indexObjects) {
        MIBObjectType ot;
        MIBObject o = this.repository.getObject(new ObjectID(table.getValue()));
        if (o instanceof MIBObjectType && (ot = (MIBObjectType)o).getIndexPart() != null) {
            if (ot.getIndexPart().isAugment()) {
                ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
            }
            Variable[] variables = new Variable[indexObjects.size()];
            int i = 0;
            for (VariableBinding vb : indexObjects) {
                variables[i++] = vb.getVariable();
            }
            return IndexConverter.getIndexValueString(this.repository, ot, variables, true, "" + this.oidFixedLengthStringQuote, "" + this.oidVariableLengthStringQuote, this.oidFixedLengthStringQuoteEscapeSequence, this.oidVariableLengthStringQuoteEscapeSequence, IndexConverter.StringFormat.getFormat(this.oidFormatNonPrintableStrings.getRadix()));
        }
        return null;
    }

    public SmiObject findSmiObject(OID oid) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBObject mibObject = this.repository.getObject(new ObjectID(oid.getValue()));
        if (mibObject != null) {
            return this.createSmiObject(mibObject, oid);
        }
        return null;
    }

    public SmiObjectType findSmiObjectType(OID oidInstance) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBObjectType mibObjectType = this.repository.getObjectType(new ObjectID(oidInstance.getValue()));
        if (mibObjectType != null) {
            try {
                return (SmiObjectType)this.createSmiObject(mibObjectType, new OID(mibObjectType.getOid().asIntArray()));
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public SmiObject findRootSmiObject() {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBObject mibObject = this.repository.getNextObject(new ObjectID());
        if (mibObject != null) {
            return this.createSmiObject(mibObject, new OID(mibObject.getPrintableOid()));
        }
        return null;
    }

    public SmiObject findRootSmiObject(String moduleName) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBModule mibModule = this.repository.getModule(moduleName);
        if (mibModule != null) {
            Integer moduleID = mibModule.getModuleID();
            ObjectID searchOID = new ObjectID();
            MIBObject mibObject = null;
            do {
                if ((mibObject = this.repository.getNextObject(searchOID)) == null || mibObject.getOid() == null) continue;
                searchOID = mibObject.getOid();
            } while (mibObject != null && !((Object)moduleID).equals(mibObject.getModuleID()));
            if (mibObject != null) {
                return this.createSmiObject(mibObject, new OID(mibObject.getPrintableOid()));
            }
        }
        return null;
    }

    public SmiModule findSmiModule(String moduleName) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBModule mibModule = this.repository.getModule(moduleName);
        if (mibModule != null) {
            return new SmiModuleIdentityImpl(mibModule, new OID(mibModule.getPrintableOid()));
        }
        return null;
    }

    public List<SmiModule> findSmiModules(OID smiObjectIdentifier) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBObject[] mibObjects = this.repository.getObjectsByOid(new ObjectID(smiObjectIdentifier.getValue()));
        if (mibObjects != null && mibObjects.length > 0) {
            HashSet<SmiModuleIdentityImpl> smiModules = new HashSet<SmiModuleIdentityImpl>(mibObjects.length);
            for (MIBObject mibObject : mibObjects) {
                MIBModule mibModule = this.repository.getModule(mibObject.getModuleID());
                if (mibModule == null) continue;
                smiModules.add(new SmiModuleIdentityImpl(mibModule, new OID(mibModule.getPrintableOid())));
                System.out.println("smiModule=" + mibModule.getModuleID() + "=" + mibModule.getOid() + "|" + mibObject.getOid() + "=" + mibObject.getName());
            }
            return new ArrayList<SmiModule>(smiModules);
        }
        return null;
    }

    public SmiObject findSmiObject(String moduleName, String objectName) {
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBObject mibObject = this.repository.getObject(moduleName, objectName);
        if (mibObject != null) {
            return this.createSmiObject(mibObject, mibObject.getOid() != null ? new OID(mibObject.getPrintableOid()) : null);
        }
        return null;
    }

    public SmiObject findSmiObject(String moduleName, String objectName, boolean includeImportedModules) {
        String importedModule;
        MIBModule mibModule;
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        MIBObject mibObject = this.repository.getObject(moduleName, objectName);
        if (mibObject != null) {
            return this.createSmiObject(mibObject, mibObject.getOid() != null ? new OID(mibObject.getPrintableOid()) : null);
        }
        if (includeImportedModules && (mibModule = this.repository.getModule(moduleName)) != null && (importedModule = mibModule.getImportSource(objectName)) != null) {
            return this.findSmiObject(importedModule, objectName, true);
        }
        return null;
    }

    public <S extends SmiObject> List<S> findSmiObject(String moduleName, SmiObjectFilter<S> filter) {
        MIBModule mibModule;
        if (!this.proEdition) {
            throw new UnsupportedOperationException();
        }
        ArrayList<SmiObject> result = new ArrayList<SmiObject>();
        Enumeration<? extends MIBObject> objectEnumeration = this.repository.objects();
        if (moduleName != null && (mibModule = this.repository.getModule(moduleName)) != null) {
            objectEnumeration = mibModule.objects();
        }
        while (objectEnumeration.hasMoreElements()) {
            SmiObject smiObject;
            MIBObject mibObject = objectEnumeration.nextElement();
            SmiType smiType = mibObject instanceof MIBObjectType ? this.getSmiType((MIBObjectType)mibObject) : SmiType.fromJasmiType(mibObject.getType());
            if (!filter.passesFilter(smiType) || !filter.passesFilter(smiObject = this.createSmiObject(mibObject, mibObject.getOid() != null ? new OID(mibObject.getPrintableOid()) : null))) continue;
            result.add(smiObject);
        }
        return result;
    }

    public void setIncludeUnknownErrorsCause(boolean includeUnknownErrorsCause) {
        DefaultRepositoryManager.setForwardUnknownErrors(includeUnknownErrorsCause);
    }

    public boolean isIncludeUnknownErrorsCause() {
        SmiManager smiManager = this;
        return smiManager.repositoryManager.isForwardUnknownErrors();
    }

    public void setSmiErrorTextResourceBundle(String resourceBundleClassName) {
        DefaultRepositoryManager.setResourceClassName(resourceBundleClassName);
    }

    public void setStoreFilenamesInRepository(boolean storeFilenameInRepository) {
        System.setProperty(MIB_REPOSITORY_STORE_FILENAME, Boolean.toString(storeFilenameInRepository));
    }

    public boolean isStoreFilenamesInRepository() {
        return Boolean.getBoolean(MIB_REPOSITORY_STORE_FILENAME);
    }

    private SmiObject createSmiObject(MIBObject mibObject, OID oid) {
        if (this.proEdition) {
            if (mibObject instanceof MIBObjectType) {
                return new SmiObjectTypeImpl((MIBObjectType)mibObject, oid);
            }
            if (mibObject instanceof MIBTextualConvention) {
                return new SmiTextualConventionImpl((MIBTextualConvention)mibObject);
            }
            if (mibObject instanceof MIBGroup) {
                return new SmiGroupImpl((MIBGroup)mibObject, oid);
            }
            if (mibObject instanceof MIBModule) {
                return new SmiModuleIdentityImpl((MIBModule)mibObject, oid);
            }
            if (mibObject instanceof MIBNotifyType) {
                return new SmiNotificationTypeImpl((MIBNotifyType)mibObject, oid);
            }
            if (mibObject instanceof MIBCompliance) {
                return new SmiModuleComplianceImpl((MIBCompliance)mibObject, oid);
            }
            if (mibObject instanceof MIBAgentCaps) {
                return new SmiAgentCapabilitiesImpl((MIBAgentCaps)mibObject, oid);
            }
            return new SmiObjectImpl(mibObject, oid);
        }
        return null;
    }

    private String[] getIndexStrings(ObjectID instanceOID) {
        try {
            Pair p = this.repository.getSplittedObjectID(instanceOID);
            if (p.second != null && ((ObjectID)p.second).size() > 0) {
                ObjectID entry = (ObjectID)p.first;
                ObjectID index = (ObjectID)p.second;
                MIBObject o = this.repository.getObject(entry);
                MIBObjectType ot = (MIBObjectType)this.repository.getParent(o);
                if (ot != null) {
                    IndexStruct[] ind;
                    if (ot.getIndexPart().isAugment()) {
                        ot = (MIBObjectType)this.repository.getObject(ot.getIndexPart().getIndexPart()[0]);
                    }
                    if ((ind = ot.getIndexPart().getIndexStruct(this.repository)) != null) {
                        try {
                            ObjectID[] iIDs = this.repository.getIndexObjectIDs(index, ind);
                            ValueConverter[] indexValueConverter = this.getIndexValueConverter(ot);
                            Variable[] variables = IndexConverter.getIndexVariables(ind, iIDs);
                            String[] result = new String[variables.length];
                            for (int i = 0; i < variables.length; ++i) {
                                result[i] = "" + indexValueConverter[i].toNative(variables[i], true);
                            }
                            return result;
                        }
                        catch (NullPointerException npex) {
                            npex.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private ValueConverter[] getIndexValueConverter(MIBObjectType table) {
        if (!table.isTable()) {
            return null;
        }
        Vector<? extends MIBObjectType> v = this.repository.getColumnarObjectsOfTable(table, true, false);
        if (table.userObject instanceof ValueConverter[]) {
            return (ValueConverter[])table.userObject;
        }
        ValueConverter[] vc = new ValueConverter[v.size()];
        for (int i = 0; i < vc.length; ++i) {
            MIBObjectType ot = v.elementAt(i);
            MIBTextualConvention tc = this.repository.getEffectiveSyntax(ot.getSyntax());
            vc[i] = new ValueConverter(ot, tc.getSyntax(), tc.getDisplayHint());
        }
        table.userObject = vc;
        return vc;
    }

    private static int getSnmpSyntax(int smiSyntax) {
        int snmpSyntax;
        switch (smiSyntax) {
            case 0: 
            case 8: {
                snmpSyntax = 2;
                break;
            }
            case 3: 
            case 5: {
                snmpSyntax = 65;
                break;
            }
            case 6: {
                snmpSyntax = 70;
                break;
            }
            case 10: {
                snmpSyntax = 68;
                break;
            }
            case 1: {
                snmpSyntax = 4;
                break;
            }
            case 2: {
                snmpSyntax = 6;
                break;
            }
            case 9: 
            case 15: {
                snmpSyntax = 64;
                break;
            }
            case 4: 
            case 7: 
            case 13: {
                snmpSyntax = 66;
                break;
            }
            case 11: {
                snmpSyntax = 67;
                break;
            }
            case 12: {
                snmpSyntax = 4;
                break;
            }
            default: {
                snmpSyntax = 5;
            }
        }
        return snmpSyntax;
    }

    private SmiSyntaxImpl createSmiSyntaxImpl(ISyntax mibSyntax) {
        SmiSyntaxType smiSyntaxType = SmiManager.getSyntaxType(mibSyntax);
        SmiSyntaxImpl resolvedSyntax = null;
        String resolvedDisplayHint = null;
        if (mibSyntax != null) {
            MIBTextualConvention effectiveSyntax = this.repository.getEffectiveSyntax(mibSyntax);
            if (smiSyntaxType == SmiSyntaxType.CONVENTION && effectiveSyntax != null) {
                resolvedSyntax = new SmiSyntaxImpl(effectiveSyntax.getSyntax().getSyntax(), SmiManager.getSyntaxType(effectiveSyntax.getSyntax()), this.getSmiSyntax(mibSyntax), this.getSmiSyntaxElementList(effectiveSyntax.getSyntax()));
                resolvedDisplayHint = effectiveSyntax.getDisplayHint();
            }
            List<SmiSyntaxElement> elementList = this.getSmiSyntaxElementList(mibSyntax);
            return new SmiSyntaxImpl(mibSyntax.getSyntax(), smiSyntaxType, this.getSmiSyntax(mibSyntax), elementList, resolvedSyntax, resolvedDisplayHint);
        }
        return null;
    }

    private int getSmiSyntax(ISyntax mibSyntax) {
        if (mibSyntax != null) {
            MIBTextualConvention effectiveSyntax = this.repository.getEffectiveSyntax(mibSyntax);
            return SmiManager.getSnmpSyntax(SMI.smiSyntax(effectiveSyntax.getSyntax().getSyntax()));
        }
        return 0;
    }

    private SmiType getSmiType(MIBObjectType mibObject) {
        if (mibObject.isTable()) {
            return SmiType.OBJECT_TYPE_TABLE_ENTRY;
        }
        if (mibObject.isColumnarObject()) {
            return SmiType.OBJECT_TYPE_COLUMN;
        }
        if (mibObject.isTableSequence()) {
            return SmiType.OBJECT_TYPE_TABLE;
        }
        return SmiType.OBJECT_TYPE_SCALAR;
    }

    private List<SmiSyntaxElement> getSmiSyntaxElementList(ISyntax mibSyntax) {
        List<SmiSyntaxElement> elementList = null;
        ArrayList<SmiSyntaxElementImpl> elements = new ArrayList<SmiSyntaxElementImpl>();
        if (mibSyntax.hasEnums()) {
            for (IEnum e : mibSyntax.getEnums()) {
                elements.add(new SmiSyntaxElementImpl(SmiSyntaxElement.Type.Enumeration, e.getLabel(), e.getLongValue(), null));
            }
        } else if (mibSyntax.hasRanges()) {
            for (IRange mibRange : mibSyntax.getRanges()) {
                elements.add(new SmiSyntaxElementImpl(SmiSyntaxElement.Type.Range, null, mibRange.getLowerValue(), mibRange.getUpper()));
            }
        }
        elementList = Collections.unmodifiableList(elements);
        return elementList;
    }

    private static SmiSyntaxType getSyntaxType(ISyntax mibSyntax) {
        if (mibSyntax == null) {
            return null;
        }
        switch (mibSyntax.getType()) {
            case 1: {
                return SmiSyntaxType.APPLICATION;
            }
            case 3: {
                return SmiSyntaxType.CONVENTION;
            }
            case 2: {
                return SmiSyntaxType.SEQUENCE;
            }
            case 0: {
                return SmiSyntaxType.SIMPLE;
            }
        }
        return null;
    }

    public static enum OctetStringDefaultFormat {
        MIB(""),
        ASCII("255a"),
        Hexadecimal("1x:"),
        Decimal("1d."),
        Binary("1b:");

        private final String displayHint;

        private OctetStringDefaultFormat(String displayHint) {
            this.displayHint = displayHint;
        }

        public String getDisplayHint() {
            return this.displayHint;
        }
    }

    private class RepositoryAdapter
    implements ExtRepsitoryListener {
        private RepositoryAdapter() {
        }

        @Override
        public void writeModule(RepositoryEvent repositoryEvent) {
            this.afterReadModule(repositoryEvent);
            RepositoryIO repositoryIO = new RepositoryIO(this, repositoryEvent.getModuleName());
            if (SmiManager.this.repositoryDriver != null) {
                SmiManager.this.repositoryDriver.writeModule(repositoryIO);
                repositoryEvent.setUseDefaults(false);
                repositoryEvent.setOutputStream(repositoryIO.getOutputStream());
            } else {
                repositoryEvent.setUseDefaults(true);
            }
        }

        @Override
        public void readModule(RepositoryEvent repositoryEvent) {
            RepositoryIO repositoryIO = new RepositoryIO(this, repositoryEvent.getModuleName());
            if (SmiManager.this.repositoryDriver != null) {
                SmiManager.this.repositoryDriver.readModule(repositoryIO);
                repositoryEvent.setInputStream(repositoryIO.getInputStream());
                repositoryEvent.setUseDefaults(false);
            } else {
                repositoryEvent.setUseDefaults(true);
            }
        }

        @Override
        public void deleteModule(RepositoryEvent repositoryEvent) {
            RepositoryIO repositoryIO = new RepositoryIO(this, repositoryEvent.getModuleName());
            if (SmiManager.this.repositoryDriver != null) {
                SmiManager.this.repositoryDriver.deleteModule(repositoryIO);
                repositoryEvent.setModuleDeleted(repositoryIO.isModuleDeleted());
                repositoryEvent.setUseDefaults(false);
            } else {
                repositoryEvent.setUseDefaults(true);
            }
        }

        @Override
        public String[] listModuleNames() {
            if (SmiManager.this.repositoryDriver != null) {
                return SmiManager.this.repositoryDriver.listModuleNames();
            }
            try {
                return SmiManager.this.repositoryManager.getModuleNamesFromDirectory();
            }
            catch (IOException iox) {
                logger.error((CharSequence)("Unable to read MIB repository: " + iox.getMessage()), (Throwable)iox);
                return null;
            }
        }

        @Override
        public void afterReadModule(RepositoryEvent repositoryEvent) {
            if (SmiManager.this.limited && repositoryEvent.getModule().getPrintableOid().startsWith("1.3.6.1.4")) {
                throw new RuntimeException("Please purchase the full SNMP4J-SMI version to use enterprise specific MIB modules");
            }
        }
    }

    public static enum OIDFormat {
        Numbers,
        ObjectNameNumIndex,
        ObjectNameAndDecodedIndex,
        ObjectNameAndDecodedIndex4RoundTrip,
        NameAndNumber;

    }

    public static enum NonPrintableStringFormat {
        asIs('\u0000', 0),
        hex(':', 16),
        decimal('.', 10),
        octal(':', 8),
        binary(':', 2);

        private final char separator;
        private final int radix;

        private NonPrintableStringFormat(char separator, int radix) {
            this.separator = separator;
            this.radix = radix;
        }

        public int getRadix() {
            return this.radix;
        }

        public char getSeparator() {
            return this.separator;
        }
    }

    private static class CachedNamedInputStream
    extends NamedInputStream {
        private static final int BUF_SIZE = 16384;
        private byte[] fileContent;
        private String zipFileName;

        private static List<CachedNamedInputStream> createCachedStreams(NamedInputStream namedInputStream) throws IOException {
            if (namedInputStream.getZipFormat() == NamedInputStream.ZipFormat.ZIP) {
                ZipEntry zipEntry;
                ArrayList<CachedNamedInputStream> zipEntries = new ArrayList<CachedNamedInputStream>();
                ZipInputStream zipInputStream = new ZipInputStream(namedInputStream.getInputStream());
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    zipEntries.add(new CachedNamedInputStream(CachedNamedInputStream.getFileContent(zipInputStream), zipEntry.getName(), namedInputStream.getName()));
                }
                return zipEntries;
            }
            return Collections.singletonList(new CachedNamedInputStream(CachedNamedInputStream.getFileContent(namedInputStream.getInputStream()), namedInputStream.getName(), null));
        }

        private CachedNamedInputStream(InputStream inputStream, String name, NamedInputStream.ZipFormat zipFormat) {
            super(inputStream, name, zipFormat);
        }

        private CachedNamedInputStream(byte[] fileContent, String name, String zipFileName) {
            super(null, name, NamedInputStream.ZipFormat.none);
            this.fileContent = fileContent;
            this.zipFileName = zipFileName;
        }

        private static byte[] getFileContent(InputStream inputStream) throws IOException {
            int read;
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((read = bis.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, read);
            }
            buffer.flush();
            return buffer.toByteArray();
        }

        public InputStream getCachedInputStream() throws IOException {
            if (this.fileContent == null) {
                this.fileContent = CachedNamedInputStream.getFileContent(this.getInputStream());
            }
            return new ByteArrayInputStream(this.fileContent);
        }
    }

    private static class SmiErrorComparator
    implements Comparator<SmiError> {
        private SmiErrorComparator() {
        }

        @Override
        public int compare(SmiError o1, SmiError o2) {
            return o1.getPosition() - o2.getPosition();
        }
    }

    private class SmiModuleIdentityImpl
    extends SmiObjectImpl
    implements SmiModuleIdentity {
        private List<String> textualConventions;
        private List<String> objectNames;
        private Collection<OID> objectIdentifiers;

        private SmiModuleIdentityImpl(MIBModule mibModule, OID oid) {
            super(mibModule, oid);
        }

        private MIBModule getMIBModule() {
            return (MIBModule)this.mibObject;
        }

        @Override
        public String getOrganization() {
            return MIBObject.getUnquotedString(this.getMIBModule().getOrganization());
        }

        @Override
        public String getContactInfo() {
            return MIBObject.getUnquotedString(this.getMIBModule().getContactInfo());
        }

        @Override
        public String getLastUpdatedString() {
            return MIBObject.getUnquotedString(this.getMIBModule().getLastUpdated());
        }

        @Override
        public GregorianCalendar getLastUpdated() {
            return MIBModule.getDateAndTimeFromUTC(this.getLastUpdatedString());
        }

        @Override
        public List<SmiRevision> getRevisions() {
            IRevision[] iRevisions = this.getMIBModule().getRevisions();
            ArrayList<SmiRevisionImpl> revisionList = new ArrayList<SmiRevisionImpl>(iRevisions.length);
            for (IRevision revision : iRevisions) {
                revisionList.add(new SmiRevisionImpl(revision));
            }
            return Collections.unmodifiableList(revisionList);
        }

        @Override
        public List<SmiImport> getImports() {
            ArrayList<SmiImportImpl> smiImports = new ArrayList<SmiImportImpl>();
            for (MIBImport mibImport : this.getMIBModule().getImportsVector()) {
                smiImports.add(new SmiImportImpl(mibImport));
            }
            return Collections.unmodifiableList(smiImports);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getObjectNames() {
            if (this.objectNames == null) {
                SmiModuleIdentityImpl smiModuleIdentityImpl = this;
                synchronized (smiModuleIdentityImpl) {
                    if (this.objectNames == null) {
                        Vector<MIBObject> mibObjects = this.getMIBModule().getObjectsVector();
                        ArrayList<String> smiObjectName = new ArrayList<String>(mibObjects.size());
                        for (MIBObject mibObject : mibObjects) {
                            smiObjectName.add(mibObject.getName());
                        }
                        this.objectNames = Collections.unmodifiableList(smiObjectName);
                    }
                }
            }
            return this.objectNames;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<OID> getObjectIdentifiers(OIDComparator.OIDOrder orderBy) {
            if (this.objectIdentifiers == null) {
                SmiModuleIdentityImpl smiModuleIdentityImpl = this;
                synchronized (smiModuleIdentityImpl) {
                    if (this.objectIdentifiers == null) {
                        Vector<MIBObject> mibObjects = this.getMIBModule().getObjectsVector();
                        TreeSet<OID> oidTreeSet = new TreeSet<OID>();
                        for (MIBObject mibObject : mibObjects) {
                            ObjectID objectID = mibObject.getOid();
                            if (objectID == null || objectID.size() <= 0) continue;
                            try {
                                oidTreeSet.add(new OID(objectID.asIntArray()));
                            }
                            catch (ObjectIDFormatException objectIDFormatException) {}
                        }
                        this.objectIdentifiers = Collections.unmodifiableCollection(oidTreeSet);
                    }
                }
            }
            if (orderBy == OIDComparator.OIDOrder.breadthFirstOrder) {
                TreeSet<OID> oidTreeSet = new TreeSet<OID>(new OIDComparator(OIDComparator.OIDOrder.breadthFirstOrder));
                oidTreeSet.addAll(this.objectIdentifiers);
                return Collections.unmodifiableCollection(oidTreeSet);
            }
            return this.objectIdentifiers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getTextualConventionNames() {
            if (this.textualConventions == null) {
                SmiModuleIdentityImpl smiModuleIdentityImpl = this;
                synchronized (smiModuleIdentityImpl) {
                    if (this.textualConventions == null) {
                        Vector<MIBTextualConvention> mibTextualConventions = this.getMIBModule().getTextualConventions();
                        ArrayList<String> smiTextualConventions = new ArrayList<String>(mibTextualConventions.size());
                        for (MIBTextualConvention tc : mibTextualConventions) {
                            smiTextualConventions.add(tc.getName());
                        }
                        this.textualConventions = Collections.unmodifiableList(smiTextualConventions);
                    }
                }
            }
            return this.textualConventions;
        }

        @Override
        public String getSourceFilename() {
            return this.getMIBModule().getFileName();
        }

        @Override
        public String getSmiModuleDefinition() {
            return ((MIBModule)this.mibObject).toSMI(1, SmiManager.this.repository, "\n");
        }

        @Override
        public String getModuleName() {
            return this.getMIBModule().getModuleName();
        }

        @Override
        public String[] getAsn1Comments() {
            return new String[]{this.getMIBModule().getCopyrightComment(), this.getMIBModule().getComment(), this.getMIBModule().getInlineComment(), this.getMIBModule().getCopyrightCommentEnd()};
        }
    }

    private class SmiObjectTypeImpl
    extends SmiObjectImpl
    implements SmiObjectType {
        private SmiSyntax syntax;

        private SmiObjectTypeImpl(MIBObjectType mibObject, OID oid) {
            super(mibObject, oid);
        }

        @Override
        public MaxAccess getMaxAccess() {
            return MaxAccess.fromSmiValue((String)((MIBObjectType)this.mibObject).getAccess());
        }

        @Override
        public String getUnits() {
            return MIBObject.getUnquotedString(((MIBObjectType)this.mibObject).getUnits());
        }

        @Override
        public int getMaxValueLength() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            if (ot.getSyntax() != null) {
                MIBTextualConvention tc = SmiManager.this.repository.getEffectiveSyntax(ot.getSyntax());
                MIBSyntax s = tc.getSyntax();
                if (s.getSyntax().equals("INTEGER") || s.getSyntax().equals("Integer32") || s.getSyntax().equals("Counter") || s.getSyntax().equals("Counter32") || s.getSyntax().equals("Counter64") || s.getSyntax().equals("UInteger32") || s.getSyntax().equals("Unsigned32") || s.getSyntax().equals("Gauge") || s.getSyntax().equals("Gauge32") || s.getSyntax().equals("TimeTicks") || s.getSyntax().equals("TimeStamp")) {
                    if (s.hasEnums() && OctetStringDefaultFormat.MIB == SmiManager.this.getOctetStringDisplayHint()) {
                        return s.getMaxEnumLabelLength();
                    }
                    long maxValue = (long)(Math.pow(2.0, 32.0) - 1.0);
                    if (s.hasRanges()) {
                        maxValue = s.getMaxOfRanges();
                    }
                    if (tc.hasDisplayHint()) {
                        String txt = ValueConverter.formatLong(maxValue, MIBObject.getUnquotedString(tc.getDisplayHint()));
                        if (txt == null) {
                            return (int)Math.log10(maxValue) + 1;
                        }
                        return txt.length();
                    }
                    Variable value = AbstractVariable.createFromSyntax((int)this.getSmiSyntax());
                    if (value instanceof AssignableFromInteger) {
                        ((AssignableFromInteger)value).setValue((int)maxValue);
                    } else if (value instanceof AssignableFromLong) {
                        ((AssignableFromLong)value).setValue(maxValue);
                    }
                    String txt = SmiManager.this.format(this.getOID(), value, false);
                    return txt.length();
                }
                if (s.getSyntax().equals("IpAddress")) {
                    return 15;
                }
                if (s.getSyntax().equals("NetworkAddress")) {
                    return 15;
                }
                if (s.getSyntax().startsWith("OBJECT IDENTIFIER")) {
                    switch (SmiManager.this.getOidFormat()) {
                        case ObjectNameNumIndex: {
                            return 74;
                        }
                    }
                    return 1279;
                }
                if (s.getSyntax().startsWith("OCTET") || s.getSyntax().startsWith("BITS") || s.getSyntax().startsWith("Opaque")) {
                    long maxValue = 32767L;
                    if (s.hasRanges()) {
                        maxValue = s.getMaxOfRanges();
                    }
                    return (int)maxValue;
                }
            }
            return -1;
        }

        @Override
        public int getMinValueLength() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            if (ot.getSyntax() != null) {
                MIBTextualConvention tc = SmiManager.this.repository.getEffectiveSyntax(ot.getSyntax());
                MIBSyntax s = tc.getSyntax();
                if (s.getSyntax().equals("INTEGER") || s.getSyntax().equals("Integer32") || s.getSyntax().equals("Counter") || s.getSyntax().equals("Counter32") || s.getSyntax().equals("Counter64") || s.getSyntax().equals("UInteger32") || s.getSyntax().equals("Unsigned32") || s.getSyntax().equals("Gauge") || s.getSyntax().equals("Gauge32") || s.getSyntax().equals("TimeTicks") || s.getSyntax().equals("TimeStamp")) {
                    if (s.hasEnums() && OctetStringDefaultFormat.MIB == SmiManager.this.getOctetStringDisplayHint()) {
                        return s.getMinEnumLabelLength();
                    }
                    long minValue = 0L;
                    if (s.hasRanges()) {
                        minValue = s.getMinOfRanges();
                    }
                    if (tc.hasDisplayHint()) {
                        String txt = ValueConverter.formatLong(minValue, tc.getDisplayHint());
                        if (txt == null) {
                            return 0;
                        }
                        return txt.length();
                    }
                    Variable value = AbstractVariable.createFromSyntax((int)this.getSmiSyntax());
                    if (value instanceof AssignableFromInteger) {
                        ((AssignableFromInteger)value).setValue((int)minValue);
                    } else if (value instanceof AssignableFromLong) {
                        ((AssignableFromLong)value).setValue(minValue);
                    }
                    String txt = SmiManager.this.format(this.getOID(), value, false);
                    return txt.length();
                }
                if (s.getSyntax().equals("IpAddress")) {
                    return 7;
                }
                if (s.getSyntax().equals("NetworkAddress")) {
                    return 7;
                }
                if (s.getSyntax().startsWith("OBJECT IDENTIFIER")) {
                    return 1;
                }
                if (s.getSyntax().startsWith("OCTET") || s.getSyntax().startsWith("BITS") || s.getSyntax().startsWith("Opaque")) {
                    long minValue = 0L;
                    if (s.hasRanges()) {
                        minValue = s.getMinOfRanges();
                    }
                    return (int)minValue;
                }
            }
            return -1;
        }

        @Override
        public String getDefaultValue() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            return ot.getDefaultValue();
        }

        @Override
        public Variable getDefaultVariable() {
            return this.getVariable(true);
        }

        @Override
        public Variable createNewVariable() {
            return this.getVariable(false);
        }

        private Variable getVariable(boolean onlyDefault) {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            ValueConverter vc = SmiManager.this.createValueConverter(ot);
            Variable variable = ValueConverter.getDefaultValue(SmiManager.this.repository, ot, vc.getEffectiveSyntax());
            if (!onlyDefault && variable == null) {
                variable = AbstractVariable.createFromSyntax((int)ValueConverter.getSnmpSyntax(vc.getSMISyntax()));
            }
            return variable;
        }

        @Override
        public SmiType getType() {
            return SmiManager.this.getSmiType((MIBObjectType)this.mibObject);
        }

        @Override
        public SmiSyntax getSyntax() {
            if (this.syntax == null) {
                MIBSyntax mibSyntax = ((MIBObjectType)this.mibObject).getSyntax();
                this.syntax = SmiManager.this.createSmiSyntaxImpl(mibSyntax);
            }
            return this.syntax;
        }

        @Override
        public List<SmiObjectType> getColumns() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            if (ot.hasIndexPart()) {
                Vector<? extends MIBObjectType> columns = SmiManager.this.repository.getColumnarObjectsOfTable(ot, false, true);
                ArrayList<SmiObjectTypeImpl> colSmiObjects = new ArrayList<SmiObjectTypeImpl>(columns.size());
                for (MIBObjectType mIBObjectType : columns) {
                    colSmiObjects.add(new SmiObjectTypeImpl(mIBObjectType, new OID(mIBObjectType.getPrintableOid())));
                }
                return Collections.unmodifiableList(colSmiObjects);
            }
            return null;
        }

        @Override
        public List<SmiObjectTypeIndex> getIndexObjects() {
            MIBObjectType ot = (MIBObjectType)this.mibObject;
            if (ot.hasIndexPart()) {
                IndexStruct[] indexStructs = ot.getIndexPart().getIndexStruct(SmiManager.this.repository);
                Vector<? extends MIBObjectType> columns = SmiManager.this.repository.getColumnarObjectsOfTable(ot, true, false);
                ArrayList<SmiObjectTypeIndexImpl> colSmiObjects = new ArrayList<SmiObjectTypeIndexImpl>(columns.size());
                for (int i = 0; i < columns.size() && i < indexStructs.length; ++i) {
                    MIBObjectType mibObjectType = (MIBObjectType)columns.get(i);
                    IndexStruct indexStruct = indexStructs[i];
                    colSmiObjects.add(new SmiObjectTypeIndexImpl(this, mibObjectType, indexStruct, new OID(mibObjectType.getPrintableOid())));
                }
                return Collections.unmodifiableList(colSmiObjects);
            }
            return null;
        }
    }

    private class SmiTextualConventionImpl
    extends SmiObjectImpl
    implements SmiTextualConvention,
    SmiValueType {
        private SmiSyntax syntax;

        private SmiTextualConventionImpl(MIBTextualConvention mibObject) {
            super(mibObject, null);
        }

        @Override
        public SmiSyntax getSyntax() {
            MIBSyntax mibSyntax;
            if (this.syntax == null && (mibSyntax = ((MIBTextualConvention)this.mibObject).getSyntax()) != null) {
                this.syntax = new SmiSyntaxImpl(mibSyntax.getSyntax(), SmiManager.getSyntaxType(mibSyntax), this.getSmiSyntax(), SmiManager.this.getSmiSyntaxElementList(mibSyntax));
            }
            return this.syntax;
        }

        @Override
        public String getDisplayHint() {
            return MIBObject.getUnquotedString(((MIBTextualConvention)this.mibObject).getDisplayHint());
        }

        @Override
        public List<SmiObject> getChildren() {
            return null;
        }

        @Override
        public SmiObject getParent() {
            return null;
        }
    }

    private class SmiGroupImpl
    extends SmiObjectImpl
    implements SmiGroup {
        public SmiGroupImpl(MIBGroup mibObject, OID oid) {
            super(mibObject, oid);
        }

        @Override
        public SmiGroupType getGroupType() {
            return ((MIBGroup)this.mibObject).isObjectGroup() ? SmiGroupType.OBJECT_GROUP : SmiGroupType.NOTIFICATION_GROUP;
        }

        @Override
        public List<String> getObjectNames() {
            return Arrays.asList(((MIBGroup)this.mibObject).getObjects());
        }
    }

    private class SmiNotificationTypeImpl
    extends SmiObjectImpl
    implements SmiNotificationType {
        private List<SmiObjectType> objectTypeList;

        private SmiNotificationTypeImpl(MIBNotifyType mibObject, OID oid) {
            super(mibObject, oid);
        }

        @Override
        public synchronized List<SmiObjectType> getObjects() {
            if (this.objectTypeList == null) {
                Integer moduleID = this.mibObject.getModuleID();
                MIBModule mibModule = SmiManager.this.repository.getModule(moduleID);
                if (mibModule != null && ((MIBNotifyType)this.mibObject).getVariables() != null) {
                    this.objectTypeList = new ArrayList<SmiObjectType>(((MIBNotifyType)this.mibObject).getVariables().length);
                    for (String object : ((MIBNotifyType)this.mibObject).getVariables()) {
                        SmiObject smiObject = SmiManager.this.findSmiObject(mibModule.getModuleName(), object);
                        if (!(smiObject instanceof SmiObjectType)) continue;
                        this.objectTypeList.add((SmiObjectType)smiObject);
                    }
                } else {
                    this.objectTypeList = new ArrayList<SmiObjectType>(0);
                }
            }
            return this.objectTypeList;
        }

        @Override
        public List<String> getObjectNames() {
            if (((MIBNotifyType)this.mibObject).hasVariables()) {
                return Arrays.asList(((MIBNotifyType)this.mibObject).getVariables());
            }
            return Collections.emptyList();
        }
    }

    private class SmiModuleComplianceImpl
    extends SmiObjectImpl
    implements SmiModuleCompliance {
        private List<SmiComplianceModule> modules;

        public SmiModuleComplianceImpl(MIBCompliance mibObject, OID oid) {
            super(mibObject, oid);
        }

        @Override
        public synchronized List<SmiComplianceModule> getModules() {
            if (this.modules == null) {
                MIBCompliance mibCompliance = (MIBCompliance)this.mibObject;
                this.modules = new ArrayList<SmiComplianceModule>(mibCompliance.getModules().size());
                for (Object mibComplianceModule : mibCompliance.getModules()) {
                    this.modules.add(new SmiComplianceModuleImpl((MIBComplianceModule)mibComplianceModule));
                }
            }
            return this.modules;
        }
    }

    private class SmiAgentCapabilitiesImpl
    extends SmiObjectImpl
    implements SmiAgentCapabilities {
        private List<SmiSupportedModule> supportedModules;

        public SmiAgentCapabilitiesImpl(MIBAgentCaps agentCaps, OID oid) {
            super(agentCaps, oid);
        }

        @Override
        public String getProductRelease() {
            return MIBObject.getUnquotedString(((MIBAgentCaps)this.mibObject).getProductRelease());
        }

        @Override
        public synchronized List<SmiSupportedModule> getSupportedModules() {
            if (this.supportedModules == null) {
                MIBAgentCaps agentCaps = (MIBAgentCaps)this.mibObject;
                this.supportedModules = new ArrayList<SmiSupportedModule>(agentCaps.getModules().size());
                for (MIBSupportedModule mibSupportedModule : agentCaps.getModules()) {
                    this.supportedModules.add(new SmiSupportedModuleImpl(mibSupportedModule));
                }
            }
            return this.supportedModules;
        }
    }

    private class SmiObjectImpl
    implements SmiObject {
        protected MIBObject mibObject;
        private final OID oid;
        private Integer smiSyntax;

        private SmiObjectImpl(MIBObject mibObject, OID oid) {
            this.mibObject = mibObject;
            this.oid = oid;
        }

        @Override
        public String getObjectName() {
            return this.mibObject.getName();
        }

        @Override
        public OID getOID() {
            return this.oid;
        }

        @Override
        public int getSmiSyntax() {
            MIBObjectType ot;
            if (this.smiSyntax == null && this.mibObject instanceof MIBObjectType && (ot = (MIBObjectType)this.mibObject).getSyntax() != null) {
                MIBTextualConvention effectiveSyntax = SmiManager.this.repository.getEffectiveSyntax(ot.getSyntax());
                this.smiSyntax = SmiManager.getSnmpSyntax(SMI.smiSyntax(effectiveSyntax.getSyntax().getSyntax()));
            }
            return this.smiSyntax == null ? 0 : this.smiSyntax;
        }

        @Override
        public String getDescription() {
            return MIBObject.getUnquotedString(this.mibObject.getDescription());
        }

        @Override
        public SmiType getType() {
            return SmiType.fromJasmiType(this.mibObject.getType());
        }

        public List<SmiObject> getChildren() {
            ArrayList<SmiObject> children = new ArrayList<SmiObject>();
            for (MIBObject mIBObject : SmiManager.this.repository.getChildren(this.mibObject)) {
                children.add(SmiManager.this.createSmiObject(mIBObject, new OID(mIBObject.getOid().toString())));
            }
            return Collections.unmodifiableList(children);
        }

        @Override
        public SmiObject getParent() {
            ObjectID objectID = this.mibObject.getOid();
            MIBObject parent = SmiManager.this.repository.getNextParent(objectID);
            if (parent != null) {
                return SmiManager.this.createSmiObject(parent, new OID(parent.getPrintableOid()));
            }
            return null;
        }

        @Override
        public String getReference() {
            return this.mibObject.getReference();
        }

        @Override
        public SmiStatus getStatus() {
            return SmiStatus.valueOf(this.mibObject.getStatus());
        }

        @Override
        public String[] getAsn1Comments() {
            return new String[]{this.mibObject.getComment(), this.mibObject.getInlineComment()};
        }

        public String toString() {
            return this.mibObject.toSMI(1, 2, SmiManager.this.repository, "\n");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SmiObjectImpl smiObject = (SmiObjectImpl)o;
            return !(this.mibObject == null ? smiObject.mibObject != null : !this.mibObject.equals(smiObject.mibObject));
        }

        public int hashCode() {
            return this.mibObject != null ? this.mibObject.hashCode() : 0;
        }

        @Override
        public int compareTo(SmiObject o) {
            if (o == null) {
                throw new IllegalArgumentException("Cannot compare to a null object.");
            }
            OID otherOid = o.getOID();
            if (this.oid == null) {
                return otherOid == null ? 0 : -1;
            }
            int c = this.oid.compareTo((Variable)otherOid);
            if (c == 0) {
                if (this.smiSyntax.intValue() == o.getSmiSyntax()) {
                    if (o instanceof SmiObjectImpl) {
                        return this.mibObject.compareTo(((SmiObjectImpl)o).mibObject);
                    }
                    return this.getObjectName().compareTo(o.getObjectName());
                }
                return this.smiSyntax.compareTo(o.getSmiSyntax());
            }
            return c;
        }
    }

    private class SmiImportImpl
    implements SmiImport {
        private MIBImport mibImport;

        private SmiImportImpl(MIBImport mibImport) {
            this.mibImport = mibImport;
        }

        @Override
        public String getSourceModuleName() {
            return this.mibImport.getSource();
        }

        @Override
        public String getAsn1Comment() {
            return this.mibImport.getComment();
        }

        @Override
        public List<String> getImportedObjectNames() {
            return Collections.unmodifiableList(this.mibImport.getImportsVector());
        }

        public String toString() {
            return this.mibImport.toSMI(SmiManager.this.repository, 1, "\n");
        }
    }

    private class SmiRevisionImpl
    implements SmiRevision {
        private IRevision mibRevision;

        private SmiRevisionImpl(IRevision mibRevision) {
            this.mibRevision = mibRevision;
        }

        @Override
        public String getRevisionString() {
            return MIBObject.getUnquotedString(this.mibRevision.getRevision());
        }

        @Override
        public GregorianCalendar getRevision() {
            return MIBModule.getDateAndTimeFromUTC(this.getRevisionString());
        }

        @Override
        public String getDescription() {
            return MIBObject.getUnquotedString(this.mibRevision.getDescription());
        }

        public String toString() {
            return this.mibRevision.getRevision();
        }
    }

    private class SmiObjectComplianceImpl
    implements SmiObjectCompliance {
        private IVariation variation;

        protected SmiObjectComplianceImpl(IVariation variation) {
            this.variation = variation;
        }

        @Override
        public String getName() {
            return this.variation.getVariation();
        }

        @Override
        public SmiComplianceType getComplianceType() {
            return this.variation instanceof MIBCondGroup ? SmiComplianceType.GroupCompliance : SmiComplianceType.ObjectCompliance;
        }

        @Override
        public SmiSyntax getSyntax() {
            return SmiManager.this.createSmiSyntaxImpl(this.variation.getSyntaxDef());
        }

        @Override
        public SmiSyntax getWriteSyntax() {
            return SmiManager.this.createSmiSyntaxImpl(this.variation.getWriteSyntaxDef());
        }

        @Override
        public SmiAccess getAccess() {
            return SmiAccess.fromSmiValue(this.variation.getAccess());
        }

        @Override
        public String getDescription() {
            return MIBObject.getUnquotedString(this.variation.getDescription());
        }
    }

    private class SmiObjectVariationImpl
    implements SmiObjectVariation {
        private IVariation mibVariation;

        public SmiObjectVariationImpl(IVariation mibVariation) {
            this.mibVariation = mibVariation;
        }

        @Override
        public String getDefaultValue() {
            return this.mibVariation.getDefval();
        }

        @Override
        public List<String> getCreationRequirements() {
            return Arrays.asList(this.mibVariation.getCreationRequires());
        }

        @Override
        public SmiSyntax getSyntax() {
            return SmiManager.this.createSmiSyntaxImpl(this.mibVariation.getSyntaxDef());
        }

        @Override
        public SmiSyntax getWriteSyntax() {
            return SmiManager.this.createSmiSyntaxImpl(this.mibVariation.getWriteSyntaxDef());
        }

        @Override
        public SmiAccess getAccess() {
            return SmiAccess.fromSmiValue(this.mibVariation.getAccess());
        }

        @Override
        public String getDescription() {
            return MIBObject.getUnquotedString(this.mibVariation.getDescription());
        }

        @Override
        public String getName() {
            return this.mibVariation.getVariation();
        }

        @Override
        public SmiComplianceType getComplianceType() {
            return SmiComplianceType.Variation;
        }
    }

    private class SmiSupportedModuleImpl
    implements SmiSupportedModule {
        private MIBSupportedModule mibSupportedModule;
        private List<SmiObjectVariation> variations;

        public SmiSupportedModuleImpl(MIBSupportedModule mibSupportedModule) {
            this.mibSupportedModule = mibSupportedModule;
        }

        @Override
        public String getModuleName() {
            return MIBObject.getUnquotedString(this.mibSupportedModule.getSupports());
        }

        @Override
        public List<String> getIncludedGroupNames() {
            return Arrays.asList(this.mibSupportedModule.getIncludedGroups());
        }

        @Override
        public synchronized List<SmiObjectVariation> getVariations() {
            if (this.variations == null) {
                this.variations = new ArrayList<SmiObjectVariation>(this.mibSupportedModule.getVariationsVector().size());
                for (IVariation mibVariation : this.mibSupportedModule.getVariations()) {
                    this.variations.add(new SmiObjectVariationImpl(mibVariation));
                }
            }
            return this.variations;
        }
    }

    private class SmiComplianceModuleImpl
    implements SmiComplianceModule {
        private MIBComplianceModule mibComplianceModule;
        private List<SmiGroup> smiGroups;
        private List<SmiObjectCompliance> objectCompliances;

        public SmiComplianceModuleImpl(MIBComplianceModule mibComplianceModule) {
            this.mibComplianceModule = mibComplianceModule;
        }

        @Override
        public List<String> getMandatoryGroupNames() {
            return Collections.unmodifiableList(this.mibComplianceModule.getMandatoryVector());
        }

        @Override
        public synchronized List<SmiGroup> getMandatoryGroups() {
            if (this.smiGroups == null && this.mibComplianceModule.getMandatoryVector() != null) {
                this.smiGroups = new ArrayList<SmiGroup>(this.mibComplianceModule.getMandatoryVector().size());
                for (String group : this.mibComplianceModule.getMandatory()) {
                    SmiObject smiObject = SmiManager.this.findSmiObject(this.mibComplianceModule.getModuleName(), group);
                    if (!(smiObject instanceof SmiGroup)) continue;
                    this.smiGroups.add((SmiGroup)((Object)smiObject));
                }
            }
            return this.smiGroups;
        }

        @Override
        public synchronized List<SmiObjectCompliance> getObjectCompliances() {
            if (this.objectCompliances == null && this.mibComplianceModule.getVariationsVector() != null) {
                this.objectCompliances = new ArrayList<SmiObjectCompliance>(this.mibComplianceModule.getVariationsVector().size());
                for (IVariation mibVariation : this.mibComplianceModule.getVariations()) {
                    this.objectCompliances.add(new SmiObjectComplianceImpl(mibVariation));
                }
            }
            return this.objectCompliances;
        }
    }

    private class SmiObjectTypeIndexImpl
    extends SmiObjectTypeImpl
    implements SmiObjectTypeIndex {
        private SmiObjectType tableEntry;
        private SmiIndexInfo indexInfo;

        private SmiObjectTypeIndexImpl(SmiObjectType tableEntry, MIBObjectType mibObjectType, IndexStruct indexStruct, OID oid) {
            super(mibObjectType, oid);
            this.tableEntry = tableEntry;
            this.indexInfo = new SmiIndexInfoImpl(indexStruct);
        }

        @Override
        public SmiIndexInfo getIndexInfo() {
            return this.indexInfo;
        }

        private class SmiIndexInfoImpl
        implements SmiIndexInfo {
            private IndexStruct indexStruct;

            private SmiIndexInfoImpl(IndexStruct indexStruct) {
                this.indexStruct = indexStruct;
            }

            public boolean hasImpliedLength() {
                return this.indexStruct.impliedLength;
            }

            public int getMinLength() {
                return this.indexStruct.minLength;
            }

            public int getMaxLength() {
                return this.indexStruct.maxLength;
            }

            public int getSnmpSyntax() {
                return ValueConverter.getSnmpSyntax(this.indexStruct.baseType);
            }

            @Override
            public SmiObjectType getTableEntry() {
                return SmiObjectTypeIndexImpl.this.tableEntry;
            }
        }
    }
}

