/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smi;

public enum SmiAccess {
    notImplemented("not-implemented"),
    notAccessible("not-accessible"),
    accessibleForNotify("accessible-for-notify"),
    writeOnly("write-only"),
    readOnly("read-only"),
    readWrite("read-write"),
    readCreate("read-create");

    private final String smiValue;

    private SmiAccess(String smiValue) {
        this.smiValue = smiValue;
    }

    public String getSmiValue() {
        return this.smiValue;
    }

    public static SmiAccess fromSmiValue(String smiValue) {
        for (SmiAccess v : SmiAccess.values()) {
            if (!v.getSmiValue().equals(smiValue)) continue;
            return v;
        }
        return null;
    }

    public boolean isAccessible() {
        return this != notAccessible && this.isImplemented();
    }

    public boolean isImplemented() {
        return this != notImplemented;
    }

    public boolean isReadOnly() {
        return this == readOnly;
    }

    public boolean isWritable() {
        return this.ordinal() >= readWrite.ordinal();
    }

    public boolean isCreatable() {
        return this == readCreate;
    }
}

