/*
 * Decompiled with CFR 0.152.
 */
package com.snmp4j.smi;

import com.snmp4j.smi.SmiError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CompilationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final List<String> moduleNames;
    private final List<SmiError> smiErrorList;
    private String zipFileName;

    public CompilationResult(String fileName, List<String> moduleNames, List<SmiError> smiErrorList) {
        this.fileName = fileName;
        this.moduleNames = moduleNames;
        this.smiErrorList = smiErrorList;
    }

    public CompilationResult(String fileName, List<String> moduleNames, List<SmiError> smiErrorList, String zipFileName) {
        this(fileName, moduleNames, smiErrorList);
        this.zipFileName = zipFileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getZipFileName() {
        return this.zipFileName;
    }

    public List<String> getModuleNames() {
        return this.moduleNames;
    }

    public List<SmiError> getSmiErrorList() {
        return this.smiErrorList;
    }

    public boolean hasErrors() {
        return this.smiErrorList != null && !this.smiErrorList.isEmpty();
    }

    public static boolean hasErrors(List<CompilationResult> compilationResults) {
        for (CompilationResult compilationResult : compilationResults) {
            if (!compilationResult.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public static List<String> getFailedFiles(List<CompilationResult> compilationResults) {
        ArrayList<String> failedFiles = new ArrayList<String>();
        for (CompilationResult compilationResult : compilationResults) {
            if (!compilationResult.hasErrors()) continue;
            failedFiles.add(compilationResult.getFileName());
        }
        return failedFiles;
    }

    public static List<String> getModuleNames(List<CompilationResult> compilationResults) {
        ArrayList<String> moduleNames = new ArrayList<String>();
        for (CompilationResult compilationResult : compilationResults) {
            moduleNames.addAll(compilationResult.getModuleNames());
        }
        return moduleNames;
    }

    public String toString() {
        return "CompilationResult{fileName='" + this.fileName + '\'' + ", moduleNames=" + this.moduleNames + ", smiErrorList=" + this.smiErrorList + ", zipFileName='" + this.zipFileName + '\'' + '}';
    }
}

