/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.ObjectArray;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class ObjectIterator
implements RandomAccessIterator,
Serializable {
    ObjectArray buffer;
    int index;
    static final long serialVersionUID = 2615219073404665807L;

    public static ObjectIterator begin(Object[] objectArray) {
        return new ObjectIterator(objectArray, 0);
    }

    public static ObjectIterator end(Object[] objectArray) {
        return new ObjectIterator(objectArray, objectArray.length);
    }

    public ObjectIterator() {
        this(new ObjectArray(), 0);
    }

    public ObjectIterator(ObjectIterator objectIterator) {
        this.buffer = objectIterator.buffer;
        this.index = objectIterator.index;
    }

    public ObjectIterator(Object[] objectArray, int n) {
        this(new ObjectArray(objectArray), n);
    }

    public ObjectIterator(ObjectArray objectArray, int n) {
        this.buffer = objectArray;
        this.index = n;
    }

    public Object clone() {
        return new ObjectIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof ObjectIterator)) break block2;
                ObjectIterator objectIterator = (ObjectIterator)object;
                if (objectIterator.index == this.index && (objectIterator.buffer.array == this.buffer.array || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(ObjectIterator objectIterator) {
        return objectIterator.index == this.index && objectIterator.buffer.array == this.buffer.array;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((ObjectIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.buffer.array.length;
    }

    public boolean hasMoreElements() {
        return this.index < this.buffer.array.length;
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }

    public Object nextElement() {
        try {
            Object object = this.buffer.array[this.index];
            ++this.index;
            return object;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("ObjectIterator");
        }
    }

    public Object get() {
        return this.buffer.array[this.index];
    }

    public Object get(int n) {
        return this.buffer.array[this.index + n];
    }

    public void put(Object object) {
        this.buffer.array[this.index] = object;
    }

    public void put(int n, Object object) {
        this.buffer.array[this.index + n] = object;
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof ObjectIterator) || this.buffer.array != ((ObjectIterator)forwardIterator2).buffer.array && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((ObjectIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.buffer;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof ObjectIterator && this.buffer.array == ((ObjectIterator)inputIterator).buffer.array;
    }
}

