/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.IntArray;
import com.objectspace.jgl.adapters.IntIterator;
import java.io.Serializable;
import java.util.Enumeration;

public class IntBuffer
implements Sequence {
    static final int defaultValue = 0;
    int[] storage;
    int length;
    static final long serialVersionUID = 145694562369360504L;

    public IntBuffer() {
        this.clear();
    }

    public IntBuffer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to create an IntBuffer with a negative size");
        }
        this.length = n;
        this.storage = new int[this.length];
    }

    public IntBuffer(int n, int n2) {
        this(n);
        int n3 = 0;
        while (n3 < this.length) {
            this.storage[n3] = n2;
            ++n3;
        }
    }

    public IntBuffer(int[] nArray) {
        this(nArray, true);
    }

    IntBuffer(int[] nArray, boolean bl) {
        int[] nArray2 = nArray;
        synchronized (nArray2) {
            this.length = nArray.length;
            if (bl) {
                this.storage = new int[this.length];
                System.arraycopy(nArray, 0, this.storage, 0, this.length);
            } else {
                this.storage = nArray;
            }
            return;
        }
    }

    public IntBuffer(IntBuffer intBuffer) {
        this(intBuffer.storage);
    }

    public synchronized Object clone() {
        return new IntBuffer(this);
    }

    public boolean equals(Object object) {
        return object instanceof IntBuffer && this.equals((IntBuffer)object) || object instanceof IntArray && this.equals((IntArray)object);
    }

    public boolean equals(IntBuffer intBuffer) {
        return this.equals(new IntArray(intBuffer.storage));
    }

    public synchronized boolean equals(IntArray intArray) {
        return intArray.equals(this.storage);
    }

    public boolean equals(int[] nArray) {
        return this.equals(new IntArray(nArray));
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "IntBuffer");
    }

    public synchronized void copy(IntBuffer intBuffer) {
        if (this == intBuffer) {
            return;
        }
        IntBuffer intBuffer2 = intBuffer;
        synchronized (intBuffer2) {
            if (intBuffer.length > this.storage.length) {
                this.storage = intBuffer.get();
            } else {
                System.arraycopy(intBuffer.storage, 0, this.storage, 0, intBuffer.length);
                int n = intBuffer.length;
                while (n < this.length) {
                    this.storage[n] = 0;
                    ++n;
                }
            }
            this.length = intBuffer.length;
            return;
        }
    }

    public synchronized void copyTo(int[] nArray) {
        int[] nArray2 = nArray;
        synchronized (nArray2) {
            System.arraycopy(this.storage, 0, nArray, 0, Math.min(this.length, nArray.length));
            return;
        }
    }

    public synchronized int[] get() {
        int[] nArray = new int[this.length];
        this.copyTo(nArray);
        return nArray;
    }

    public synchronized int hashCode() {
        return Algorithms.Hashing.orderedHash(this.begin(), this.length);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object back() {
        return this.at(this.size() - 1);
    }

    public Object front() {
        return this.at(0);
    }

    public int size() {
        return this.length;
    }

    public int capacity() {
        return this.storage.length;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public Object at(int n) {
        return new Integer(this.intAt(n));
    }

    public synchronized int intAt(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        return this.storage[n];
    }

    public synchronized void put(int n, Object object) {
        this.put(n, ((Number)object).intValue());
    }

    public synchronized void put(int n, int n2) {
        ArrayAdapter.checkIndex(n, this.length);
        this.storage[n] = n2;
    }

    public synchronized void clear() {
        this.storage = new int[10];
        this.length = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof IntIterator)) {
            throw new IllegalArgumentException("Enumeration not an IntIterator");
        }
        if (((IntIterator)enumeration).buffer != this.storage) {
            throw new IllegalArgumentException("Enumeration not for this IntBuffer ");
        }
        Serializable serializable = (IntIterator)enumeration;
        serializable = new Integer(serializable.buffer[serializable.index]);
        this.remove(((IntIterator)enumeration).index);
        return serializable;
    }

    public synchronized Object remove(int n) {
        ArrayAdapter.checkIndex(n, this.length);
        Integer n2 = new Integer(this.storage[n]);
        System.arraycopy(this.storage, n + 1, this.storage, n, this.length - n - 1);
        this.storage[--this.length] = 0;
        return n2;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        block5: {
            block4: {
                if (!(enumeration instanceof IntIterator) || !(enumeration2 instanceof IntIterator)) {
                    throw new IllegalArgumentException("Enumeration not an IntIterator");
                }
                if (((IntIterator)enumeration).buffer != this.storage) break block4;
                IntIterator intIterator = (IntIterator)enumeration;
                IntIterator intIterator2 = (IntIterator)enumeration2;
                if (!(intIterator2 instanceof IntIterator) || intIterator.buffer != intIterator2.buffer && !false) break block5;
            }
            throw new IllegalArgumentException("Enumeration not compatible");
        }
        return this.remove(((IntIterator)enumeration).index, ((IntIterator)enumeration2).index - 1);
    }

    public synchronized int remove(int n, int n2) {
        if (n2 < n) {
            return 0;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        n3 = n2 - n + 1;
        System.arraycopy(this.storage, n2 + 1, this.storage, n, this.length - n2 - 1);
        int n4 = this.length - n3;
        while (n4 < this.length) {
            this.storage[n4] = 0;
            ++n4;
        }
        this.length -= n3;
        return n3;
    }

    public synchronized Object popBack() {
        if (this.length == 0) {
            throw new InvalidOperationException("IntBuffer is empty");
        }
        Integer n = new Integer(this.storage[--this.length]);
        this.storage[this.length] = 0;
        return n;
    }

    public synchronized Object add(Object object) {
        this.add(((Number)object).intValue());
        return null;
    }

    public synchronized void add(int n) {
        if (this.length == this.storage.length) {
            int[] nArray = this.getNextStorage(1);
            this.copyTo(nArray);
            this.storage = nArray;
        }
        this.storage[this.length++] = n;
    }

    public void pushBack(Object object) {
        this.add(((Number)object).intValue());
    }

    public void pushBack(int n) {
        this.add(n);
    }

    public IntIterator insert(IntIterator intIterator, Object object) {
        return this.insert(intIterator, ((Number)object).intValue());
    }

    public IntIterator insert(IntIterator intIterator, int n) {
        this.insert(intIterator.index, n);
        return new IntIterator(this, intIterator.index);
    }

    public void insert(int n, Object object) {
        this.insert(n, ((Number)object).intValue());
    }

    public synchronized void insert(int n, int n2) {
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.length != this.storage.length) {
            if (n != this.length) {
                System.arraycopy(this.storage, n, this.storage, n + 1, this.length - n);
            }
        } else {
            int[] nArray = this.getNextStorage(1);
            System.arraycopy(this.storage, 0, nArray, 0, n);
            System.arraycopy(this.storage, n, nArray, n + 1, this.length - n);
            this.storage = nArray;
        }
        this.storage[n] = n2;
        ++this.length;
    }

    public void insert(IntIterator intIterator, int n, Object object) {
        this.insert(intIterator, n, ((Number)object).intValue());
    }

    public void insert(IntIterator intIterator, int n, int n2) {
        this.insert(intIterator.index, n, n2);
    }

    public void insert(int n, int n2, Object object) {
        this.insert(n, n2, ((Number)object).intValue());
    }

    public synchronized void insert(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n2 == 0) {
            return;
        }
        ArrayAdapter.checkIndex(n, this.length + 1);
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            int[] nArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, nArray, 0, n);
            System.arraycopy(this.storage, n, nArray, n + n2, this.length - n);
            this.storage = nArray;
        }
        int n4 = n;
        while (n4 < n + n2) {
            this.storage[n4] = n3;
            ++n4;
        }
        this.length += n2;
    }

    public void insert(IntIterator intIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(intIterator.index, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        int n2 = forwardIterator.distance(forwardIterator2);
        if (n2 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.storage.length - this.length >= n2) {
            System.arraycopy(this.storage, n, this.storage, n + n2, this.length - n);
        } else {
            int[] nArray = this.getNextStorage(n2);
            System.arraycopy(this.storage, 0, nArray, 0, n);
            System.arraycopy(this.storage, n, nArray, n + n2, this.length - n);
            this.storage = nArray;
        }
        this.length += n2;
        int n3 = n;
        while (n3 < n + n2) {
            this.put(n3, forwardIterator3.nextElement());
            ++n3;
        }
    }

    public synchronized void swap(IntBuffer intBuffer) {
        IntBuffer intBuffer2 = intBuffer;
        synchronized (intBuffer2) {
            int n = this.length;
            int[] nArray = this.storage;
            this.length = intBuffer.length;
            this.storage = intBuffer.storage;
            intBuffer.length = n;
            intBuffer.storage = nArray;
            return;
        }
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized IntIterator begin() {
        return new IntIterator(this, 0);
    }

    public synchronized IntIterator end() {
        return new IntIterator(this, this.length);
    }

    public synchronized void trimToSize() {
        if (this.length < this.storage.length) {
            this.storage = this.get();
        }
    }

    public synchronized void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.storage.length < n) {
            int[] nArray = new int[n];
            if (this.length > 0) {
                System.arraycopy(this.storage, 0, nArray, 0, this.length);
            }
            this.storage = nArray;
        }
    }

    public synchronized Object popFront() {
        if (this.length == 0) {
            throw new InvalidOperationException("IntBuffer is empty");
        }
        Integer n = new Integer(this.storage[0]);
        this.remove(0);
        return n;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public void pushFront(int n) {
        this.insert(0, n);
    }

    public int remove(Object object) {
        return this.remove(object, this.length);
    }

    public synchronized int remove(Object object, int n) {
        int n2 = ((Number)object).intValue();
        int n3 = 0;
        while (n > 0) {
            int n4 = this.indexOf(n2);
            if (n4 < 0) break;
            --n;
            ++n3;
            this.remove(n4);
        }
        return n3;
    }

    public synchronized int remove(int n, int n2, Object object) {
        ((Number)object).intValue();
        if (n2 < n) {
            return 0;
        }
        int n3 = this.length;
        ArrayAdapter.checkIndex(n, n3);
        ArrayAdapter.checkIndex(n2, n3);
        IntIterator intIterator = new IntIterator(this, n);
        IntIterator intIterator2 = new IntIterator(this, n2 + 1);
        IntIterator intIterator3 = (IntIterator)Algorithms.Removing.remove(intIterator, intIterator2, object);
        return this.remove(intIterator3.index, n2);
    }

    public int replace(Object object, Object object2) {
        return this.replace(((Number)object).intValue(), ((Number)object2).intValue());
    }

    public int replace(int n, int n2) {
        return this.replace(0, this.length - 1, n, n2);
    }

    public int replace(int n, int n2, Object object, Object object2) {
        return this.replace(n, n2, ((Number)object).intValue(), ((Number)object2).intValue());
    }

    public synchronized int replace(int n, int n2, int n3, int n4) {
        int n5 = this.length;
        ArrayAdapter.checkIndex(n, n5);
        ArrayAdapter.checkIndex(n2, n5);
        n5 = 0;
        while (n < n2) {
            if (this.storage[n] == n3) {
                this.storage[n] = n4;
                ++n5;
            }
            ++n;
        }
        return n5;
    }

    public int count(Object object) {
        return this.count(((Number)object).intValue());
    }

    public int count(int n) {
        return this.count(0, this.length - 1, n);
    }

    public int count(int n, int n2, Object object) {
        return this.count(n, n2, ((Number)object).intValue());
    }

    public synchronized int count(int n, int n2, int n3) {
        int n4 = this.length;
        ArrayAdapter.checkIndex(n, n4);
        ArrayAdapter.checkIndex(n2, n4);
        n4 = 0;
        while (n < n2) {
            if (this.storage[n] == n3) {
                ++n4;
            }
            ++n;
        }
        return n4;
    }

    public int indexOf(Object object) {
        return this.indexOf(((Number)object).intValue());
    }

    public int indexOf(int n) {
        return this.indexOf(0, this.length - 1, n);
    }

    public int indexOf(int n, int n2, Object object) {
        return this.indexOf(n, n2, ((Number)object).intValue());
    }

    public synchronized int indexOf(int n, int n2, int n3) {
        if (n2 < n) {
            return -1;
        }
        int n4 = this.length;
        ArrayAdapter.checkIndex(n, n4);
        ArrayAdapter.checkIndex(n2, n4);
        while (n < n2) {
            if (this.storage[n] == n3) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.length > n) {
            this.remove(n, this.length - 1);
            return;
        }
        if (this.length < n) {
            this.insert(this.length, n - this.length, 0);
        }
    }

    public boolean contains(Object object) {
        return this.contains(((Number)object).intValue());
    }

    public boolean contains(int n) {
        return this.indexOf(n) != -1;
    }

    private int[] getNextStorage(int n) {
        int n2 = Math.max(ArrayAdapter.getNextSize(this.length), this.length + n);
        int[] nArray = new int[n2];
        return nArray;
    }

    static int asInt(Object object) {
        return ((Number)object).intValue();
    }
}

