/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.RandomAccessIterator;
import com.objectspace.jgl.adapters.FloatArray;
import com.objectspace.jgl.adapters.FloatBuffer;
import java.io.Serializable;
import java.util.NoSuchElementException;

public final class FloatIterator
implements RandomAccessIterator,
Serializable {
    float[] buffer;
    Container original;
    int index;
    static final long serialVersionUID = -4831335176103843922L;

    public static FloatIterator begin(float[] fArray) {
        return new FloatIterator(fArray, 0);
    }

    public static FloatIterator end(float[] fArray) {
        return new FloatIterator(fArray, fArray.length);
    }

    public FloatIterator() {
        this(new FloatArray(), 0);
    }

    public FloatIterator(FloatIterator floatIterator) {
        this.buffer = floatIterator.buffer;
        this.original = floatIterator.original;
        this.index = floatIterator.index;
    }

    public FloatIterator(float[] fArray, int n) {
        this(new FloatArray(fArray), n);
    }

    public FloatIterator(FloatArray floatArray, int n) {
        this.buffer = floatArray.array;
        this.original = floatArray;
        this.index = n;
    }

    public FloatIterator(FloatBuffer floatBuffer, int n) {
        this.buffer = floatBuffer.storage;
        this.original = floatBuffer;
        this.index = n;
    }

    public Object clone() {
        return new FloatIterator(this);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof FloatIterator)) break block2;
                FloatIterator floatIterator = (FloatIterator)object;
                if (floatIterator.index == this.index && (floatIterator.buffer == this.buffer || false)) break block3;
            }
            return false;
        }
        return true;
    }

    public boolean equals(FloatIterator floatIterator) {
        return floatIterator.index == this.index && floatIterator.buffer == this.buffer;
    }

    public boolean less(RandomAccessIterator randomAccessIterator) {
        return this.index < ((FloatIterator)randomAccessIterator).index;
    }

    public boolean atBegin() {
        return this.index == 0;
    }

    public boolean atEnd() {
        return this.index == this.original.size();
    }

    public boolean hasMoreElements() {
        return this.index < this.original.size();
    }

    public void advance() {
        ++this.index;
    }

    public void advance(int n) {
        this.index += n;
    }

    public void retreat() {
        --this.index;
    }

    public void retreat(int n) {
        this.index -= n;
    }

    public Object nextElement() {
        try {
            Float f = new Float(this.buffer[this.index]);
            ++this.index;
            return f;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new NoSuchElementException("FloatIterator");
        }
    }

    public Object get() {
        return new Float(this.buffer[this.index]);
    }

    public float getFloat() {
        return this.buffer[this.index];
    }

    public Object get(int n) {
        return new Float(this.buffer[this.index + n]);
    }

    public float getFloat(int n) {
        return this.buffer[this.index + n];
    }

    public void put(Object object) {
        float f;
        this.buffer[this.index] = f = ((Number)object).floatValue();
    }

    public void put(float f) {
        this.buffer[this.index] = f;
    }

    public void put(int n, Object object) {
        float f;
        this.buffer[this.index + n] = f = ((Number)object).floatValue();
    }

    public void put(int n, float f) {
        this.buffer[this.index + n] = f;
    }

    public int distance(ForwardIterator forwardIterator) {
        ForwardIterator forwardIterator2 = forwardIterator;
        if (!(forwardIterator2 instanceof FloatIterator) || this.buffer != ((FloatIterator)forwardIterator2).buffer && !false) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        return ((FloatIterator)forwardIterator).index - this.index;
    }

    public int index() {
        return this.index;
    }

    public Container getContainer() {
        return this.original;
    }

    public boolean isCompatibleWith(InputIterator inputIterator) {
        return inputIterator instanceof FloatIterator && this.buffer == ((FloatIterator)inputIterator).buffer;
    }
}

