/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.OrderedSetIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import com.objectspace.jgl.Set;
import com.objectspace.jgl.Tree;
import com.objectspace.jgl.algorithms.SetOperations;
import com.objectspace.jgl.util.InsertIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;

public class OrderedSet
implements Set {
    Tree myTree;
    int version = 30100;
    static final long serialVersionUID = -4993180520108826183L;

    public OrderedSet() {
        this.myTree = new Tree(false, false, this);
    }

    public OrderedSet(boolean bl) {
        this.myTree = new Tree(false, bl, this);
    }

    public OrderedSet(BinaryPredicate binaryPredicate) {
        this.myTree = new Tree(false, false, binaryPredicate, this);
    }

    public OrderedSet(BinaryPredicate binaryPredicate, boolean bl) {
        this.myTree = new Tree(false, bl, binaryPredicate, this);
    }

    public OrderedSet(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            this.myTree = new Tree(orderedSet.myTree, this);
            return;
        }
    }

    public boolean allowsDuplicates() {
        return this.myTree.myInsertAlways;
    }

    public synchronized Object clone() {
        return new OrderedSet(this);
    }

    public synchronized void copy(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            Tree tree = this.myTree;
            Tree tree2 = orderedSet.myTree;
            if (tree != tree2) {
                tree.clear();
                tree.copyTree(tree2);
            }
            return;
        }
    }

    public synchronized String toString() {
        return Algos.Printing.toString(this, "OrderedSet");
    }

    public synchronized Enumeration elements() {
        Tree tree = this.myTree;
        return new OrderedSetIterator(tree, tree.myHeader.left, (OrderedSet)tree.myContainer);
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized OrderedSetIterator begin() {
        Tree tree = this.myTree;
        return new OrderedSetIterator(tree, tree.myHeader.left, (OrderedSet)tree.myContainer);
    }

    public synchronized OrderedSetIterator end() {
        Tree tree = this.myTree;
        return new OrderedSetIterator(tree, tree.myHeader, (OrderedSet)tree.myContainer);
    }

    public boolean isEmpty() {
        return this.myTree.size == 0;
    }

    public int size() {
        return this.myTree.size;
    }

    public int maxSize() {
        Tree tree = this.myTree;
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object object) {
        return object instanceof OrderedSet && this.equals((OrderedSet)object);
    }

    public synchronized boolean equals(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            boolean bl = Algos.Comparing.equal(this, orderedSet);
            Object var4_4 = null;
            return bl;
        }
    }

    public synchronized int hashCode() {
        return Algos.Hashing.orderedHash(this.begin(), this.myTree.size);
    }

    public synchronized void swap(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            Tree tree = this.myTree;
            this.myTree = orderedSet.myTree;
            orderedSet.myTree = tree;
            return;
        }
    }

    public synchronized void clear() {
        this.myTree.clear();
    }

    public synchronized int remove(Object object) {
        Pair pair = this.myTree.remove(object);
        return ((Number)pair.second).intValue();
    }

    public synchronized int remove(Object object, int n) {
        Pair pair = this.myTree.remove(object, n);
        return ((Number)pair.second).intValue();
    }

    public synchronized Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof OrderedSetIterator)) {
            throw new IllegalArgumentException("Enumeration not a OrderedSetIterator");
        }
        if (((OrderedSetIterator)enumeration).myOrderedSet != this) {
            throw new IllegalArgumentException("Enumeration not for this OrderedSet");
        }
        Tree.TreeNode treeNode = this.myTree.remove(((OrderedSetIterator)enumeration).myNode);
        if (treeNode == null) {
            return null;
        }
        return treeNode.object;
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof OrderedSetIterator) || !(enumeration2 instanceof OrderedSetIterator)) {
            throw new IllegalArgumentException("Enumeration not a OrderedSetIterator");
        }
        if (((OrderedSetIterator)enumeration).myOrderedSet != this || ((OrderedSetIterator)enumeration2).myOrderedSet != this) {
            throw new IllegalArgumentException("Enumeration not for this OrderedSet");
        }
        Serializable serializable = this.myTree;
        Tree.TreeNode treeNode = ((OrderedSetIterator)enumeration).myNode;
        Tree.TreeNode treeNode2 = ((OrderedSetIterator)enumeration2).myNode;
        serializable = serializable.remove(treeNode, treeNode2, serializable.size);
        return ((Number)((Pair)serializable).second).intValue();
    }

    public synchronized OrderedSetIterator find(Object object) {
        return new OrderedSetIterator(this.myTree, this.myTree.find(object), this);
    }

    public synchronized int count(Object object) {
        return this.myTree.count(object);
    }

    public synchronized OrderedSetIterator lowerBound(Object object) {
        Tree tree = this.myTree;
        return new OrderedSetIterator(this.myTree, (Tree.TreeNode)tree.equalRange((Object)object).first, this);
    }

    public synchronized OrderedSetIterator upperBound(Object object) {
        Tree tree = this.myTree;
        return new OrderedSetIterator(this.myTree, (Tree.TreeNode)tree.equalRange((Object)object).second, this);
    }

    public synchronized Range equalRange(Object object) {
        Pair pair = this.myTree.equalRange(object);
        return new Range(new OrderedSetIterator(this.myTree, (Tree.TreeNode)pair.first, this), new OrderedSetIterator(this.myTree, (Tree.TreeNode)pair.second, this));
    }

    public BinaryPredicate getComparator() {
        return this.myTree.myComparator;
    }

    public synchronized Object add(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = this.myTree;
        object2 = ((Tree)object2).insertAux(object, true);
        if (((Tree.InsertResult)object2).ok) {
            return null;
        }
        return ((Tree.InsertResult)object2).node.object;
    }

    public synchronized Object get(Object object) {
        Tree.TreeNode treeNode = this.myTree.find(object);
        if (treeNode.object == null) {
            return null;
        }
        if (treeNode.object.equals(object)) {
            return treeNode.object;
        }
        return null;
    }

    public synchronized Object put(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        Object object2 = this.myTree;
        object2 = ((Tree)object2).insertAux(object, false);
        if (((Tree.InsertResult)object2).ok) {
            return null;
        }
        Object object3 = ((Tree.InsertResult)object2).node.object;
        ((Tree.InsertResult)object2).node.object = object;
        return object3;
    }

    public synchronized OrderedSet union(OrderedSet orderedSet) {
        if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
            throw new InvalidOperationException("union operation invalid on multisets");
        }
        OrderedSet orderedSet2 = new OrderedSet(this.getComparator(), this.allowsDuplicates());
        OrderedSet orderedSet3 = this;
        OrderedSet orderedSet4 = orderedSet;
        InsertIterator insertIterator = new InsertIterator(orderedSet2);
        BinaryPredicate binaryPredicate = this.getComparator();
        SetOperations.setUnion(orderedSet3.start(), orderedSet3.finish(), orderedSet4.start(), orderedSet4.finish(), insertIterator, binaryPredicate);
        return orderedSet2;
    }

    public synchronized OrderedSet intersection(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("intersection operation invalid on multisets");
            }
            OrderedSet orderedSet3 = new OrderedSet(this.getComparator(), this.allowsDuplicates());
            OrderedSet orderedSet4 = this;
            OrderedSet orderedSet5 = orderedSet;
            InsertIterator insertIterator = new InsertIterator(orderedSet3);
            BinaryPredicate binaryPredicate = this.getComparator();
            SetOperations.setIntersection(orderedSet4.start(), orderedSet4.finish(), orderedSet5.start(), orderedSet5.finish(), insertIterator, binaryPredicate);
            OrderedSet orderedSet6 = orderedSet3;
            Object var4_9 = null;
            return orderedSet6;
        }
    }

    public synchronized OrderedSet difference(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("difference operation invalid on multisets");
            }
            OrderedSet orderedSet3 = new OrderedSet(this.getComparator(), this.allowsDuplicates());
            OrderedSet orderedSet4 = this;
            OrderedSet orderedSet5 = orderedSet;
            InsertIterator insertIterator = new InsertIterator(orderedSet3);
            BinaryPredicate binaryPredicate = this.getComparator();
            SetOperations.setDifference(orderedSet4.start(), orderedSet4.finish(), orderedSet5.start(), orderedSet5.finish(), insertIterator, binaryPredicate);
            OrderedSet orderedSet6 = orderedSet3;
            Object var4_9 = null;
            return orderedSet6;
        }
    }

    public synchronized OrderedSet symmetricDifference(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("symmetricDifference operation invalid on multisets");
            }
            OrderedSet orderedSet3 = new OrderedSet(this.getComparator(), this.allowsDuplicates());
            OrderedSet orderedSet4 = this;
            OrderedSet orderedSet5 = orderedSet;
            InsertIterator insertIterator = new InsertIterator(orderedSet3);
            BinaryPredicate binaryPredicate = this.getComparator();
            SetOperations.setSymmetricDifference(orderedSet4.start(), orderedSet4.finish(), orderedSet5.start(), orderedSet5.finish(), insertIterator, binaryPredicate);
            OrderedSet orderedSet6 = orderedSet3;
            Object var4_9 = null;
            return orderedSet6;
        }
    }

    public synchronized boolean subsetOf(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("subsetOf operation invalid on multisets");
            }
            OrderedSet orderedSet3 = orderedSet;
            OrderedSet orderedSet4 = this;
            BinaryPredicate binaryPredicate = this.getComparator();
            boolean bl = SetOperations.includes(orderedSet3.start(), orderedSet3.finish(), orderedSet4.start(), orderedSet4.finish(), binaryPredicate);
            Object var4_7 = null;
            return bl;
        }
    }

    public synchronized boolean properSubsetOf(OrderedSet orderedSet) {
        OrderedSet orderedSet2 = orderedSet;
        synchronized (orderedSet2) {
            if (this.myTree.myInsertAlways || orderedSet.myTree.myInsertAlways) {
                throw new InvalidOperationException("properSubsetOf operation invalid on multisets");
            }
            boolean bl = this.size() < orderedSet.size() && this.subsetOf(orderedSet);
            Object var4_4 = null;
            return bl;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.version == 0) {
            boolean bl = objectInputStream.readBoolean();
            BinaryPredicate binaryPredicate = (BinaryPredicate)objectInputStream.readObject();
            this.myTree = new Tree(false, bl, binaryPredicate, this);
            int n = objectInputStream.readInt();
            while (n-- > 0) {
                this.add(objectInputStream.readObject());
            }
        }
    }
}

