/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.snmpvalue;

import com.agentpp.mib.IndexStruct;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.smiparser.SMI;
import com.agentpp.snmpvalue.IndexConverter;
import com.agentpp.snmpvalue.types.ComparableIpAddress;
import com.objectspace.jgl.Pair;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.StringTokenizer;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.Counter64;
import org.snmp4j.smi.Gauge32;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Opaque;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class ValueConverter
implements Comparator,
Serializable {
    public static final long serialVersionUID = -9073989472934609617L;
    protected MIBObjectType ot;
    protected MIBSyntax effectiveSyntax;
    protected String displayHint;
    protected String overrideDisplayHint;
    protected int smiSyntax = -1;

    public ValueConverter(ValueConverter other) {
        this.ot = other.ot;
        this.effectiveSyntax = other.effectiveSyntax;
        this.displayHint = other.displayHint;
        this.smiSyntax = other.smiSyntax;
        this.overrideDisplayHint = other.overrideDisplayHint;
    }

    public ValueConverter(MIBObjectType objectType, MIBSyntax effectiveSyntax, String displayHint) {
        this.ot = objectType;
        this.effectiveSyntax = effectiveSyntax;
        if (displayHint != null) {
            displayHint = MIBObject.getUnquotedString(displayHint);
        }
        this.displayHint = displayHint;
        this.smiSyntax = SMI.smiSyntax(effectiveSyntax.getSyntax());
        if (this.smiSyntax < 0) {
            this.smiSyntax = 11;
        }
    }

    public ValueConverter(Class snmpClass) {
        this(ValueConverter.getSmiSyntax(snmpClass));
    }

    public ValueConverter(int smiSyntax) {
        this.smiSyntax = smiSyntax;
        this.displayHint = null;
        this.effectiveSyntax = new MIBSyntax(SMI.SMI_SYNTAX[smiSyntax], 0);
        this.ot = null;
    }

    private static int getSmiSyntax(Class snmpClass) {
        int smiSyntax = 0;
        smiSyntax = snmpClass.equals(Integer32.class) ? 0 : (snmpClass.equals(Counter32.class) ? 3 : (snmpClass.equals(Counter64.class) ? 6 : (snmpClass.equals(OctetString.class) ? 1 : (snmpClass.equals(OID.class) ? 2 : (snmpClass.equals(IpAddress.class) ? 9 : (snmpClass.equals(Gauge32.class) ? 4 : (snmpClass.equals(TimeTicks.class) ? 11 : 14)))))));
        return smiSyntax;
    }

    public static int getSmiSyntax(int snmpSyntax) {
        int smiSyntax = 0;
        switch (snmpSyntax) {
            case 2: {
                smiSyntax = 0;
                break;
            }
            case 65: {
                smiSyntax = 3;
                break;
            }
            case 70: {
                smiSyntax = 6;
                break;
            }
            case 4: {
                smiSyntax = 1;
                break;
            }
            case 6: {
                smiSyntax = 2;
                break;
            }
            case 64: {
                smiSyntax = 9;
                break;
            }
            case 66: {
                smiSyntax = 7;
                break;
            }
            case 67: {
                smiSyntax = 11;
                break;
            }
            default: {
                smiSyntax = 14;
            }
        }
        return smiSyntax;
    }

    public static int getSnmpSyntax(int smiSyntax) {
        int snmpSyntax = 0;
        switch (smiSyntax) {
            case 0: 
            case 8: {
                snmpSyntax = 2;
                break;
            }
            case 3: 
            case 5: {
                snmpSyntax = 65;
                break;
            }
            case 6: {
                snmpSyntax = 70;
                break;
            }
            case 10: {
                snmpSyntax = 68;
                break;
            }
            case 1: {
                snmpSyntax = 4;
                break;
            }
            case 2: {
                snmpSyntax = 6;
                break;
            }
            case 9: 
            case 15: {
                snmpSyntax = 64;
                break;
            }
            case 4: 
            case 7: 
            case 13: {
                snmpSyntax = 66;
                break;
            }
            case 11: {
                snmpSyntax = 67;
                break;
            }
            case 12: {
                snmpSyntax = 4;
                break;
            }
            default: {
                snmpSyntax = 5;
            }
        }
        return snmpSyntax;
    }

    public void setObjectType(MIBObjectType ot) {
        this.ot = ot;
    }

    public MIBObjectType getObjectType() {
        return this.ot;
    }

    public String getDisplayHint() {
        return this.overrideDisplayHint != null ? this.overrideDisplayHint : this.displayHint;
    }

    public String getNativeDisplayHint() {
        return this.displayHint;
    }

    public String getOverrideDisplayHint() {
        return this.overrideDisplayHint;
    }

    public void setOverrideDisplayHint(String displayHint) {
        this.overrideDisplayHint = displayHint;
    }

    public void setDisplayHint(String displayHint) {
        this.displayHint = displayHint;
    }

    public void setEffectiveSyntax(MIBSyntax effectiveSyntax) {
        this.effectiveSyntax = effectiveSyntax;
    }

    public Object toNative(Variable variable) {
        return this.toNative(variable, false);
    }

    public Object toNative(Variable variable, boolean withLabels) {
        if (this.getDisplayHint() != null) {
            if (variable instanceof OctetString) {
                return ValueConverter.formatString((OctetString)variable, this.getDisplayHint());
            }
            if (variable instanceof Integer32) {
                return ValueConverter.formatLong(new Long(((Integer32)variable).getValue()), this.getDisplayHint());
            }
            if (variable instanceof UnsignedInteger32) {
                return ValueConverter.formatLong(new Long(((UnsignedInteger32)variable).getValue()), this.getDisplayHint());
            }
            if (variable instanceof Counter64) {
                return ValueConverter.formatLong(new Long(((Counter64)variable).getValue()), this.getDisplayHint());
            }
        } else {
            if (variable instanceof Integer32) {
                MIBEnum e;
                if (withLabels && this.getEffectiveSyntax().hasEnums() && (e = this.getEffectiveSyntax().getEnum(((Integer32)variable).getValue())) != null) {
                    return e.toString();
                }
                return new Integer(((Integer32)variable).getValue());
            }
            if (variable instanceof UnsignedInteger32) {
                return new Long(((UnsignedInteger32)variable).getValue());
            }
            if (variable instanceof OctetString) {
                if (this.smiSyntax == 12) {
                    return ValueConverter.toBinaryString((OctetString)variable);
                }
                return new String(((OctetString)variable).toHexString());
            }
            if (variable instanceof Counter64) {
                return new BigDecimal(new BigInteger(variable.toString()));
            }
            if (variable instanceof IpAddress) {
                return new ComparableIpAddress(variable.toString());
            }
            if (variable instanceof OID) {
                return new ObjectID(variable.toString());
            }
        }
        return null;
    }

    public static String toBinaryString(OctetString os) {
        byte[] bytes = os.getValue();
        StringBuffer buf = new StringBuffer(bytes.length * 9);
        for (int i = 0; i < bytes.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if ((bytes[i] & 1 << 7 - j) > 0) {
                    buf.append('1');
                    continue;
                }
                buf.append('0');
            }
            if (i + 1 >= bytes.length) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String getPrintableString(OctetString os) {
        if (os == null) {
            return "";
        }
        byte[] bytes = os.getValue();
        StringBuffer buf = new StringBuffer(bytes.length + 1);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 32 && bytes[i] < 127) {
                buf.append((char)bytes[i]);
                continue;
            }
            buf.append('.');
        }
        return buf.toString();
    }

    public static OctetString fromBinaryString(String binString) {
        try {
            StringTokenizer st = new StringTokenizer(binString, " ");
            OctetString os = new OctetString();
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                for (int i = 0; i < t.length(); i += 8) {
                    String val = i + 8 < t.length() ? t.substring(i, i + 8) : t.substring(i);
                    if (val.length() < 8) {
                        StringBuffer buf = new StringBuffer(8);
                        buf.append(val);
                        while (buf.length() < 8) {
                            buf.append('0');
                        }
                        val = buf.toString();
                    }
                    os.append((byte)Integer.parseInt(val, 2));
                }
            }
            return os;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Variable fromString(String object) {
        switch (this.smiSyntax) {
            case 0: 
            case 8: {
                if (this.effectiveSyntax.hasEnums() && object != null && !object.isEmpty() && !Character.isDigit(object.charAt(0))) {
                    try {
                        return this.fromNative(this.effectiveSyntax.getEnumValue(object));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    return this.fromNative(Integer.valueOf(object));
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case 1: 
            case 10: 
            case 12: {
                return this.fromNative(object);
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 13: {
                try {
                    return this.fromNative(Long.valueOf(object));
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case 6: {
                try {
                    return this.fromNative(new BigDecimal(object));
                }
                catch (Exception ex) {
                    return null;
                }
            }
            case 2: 
            case 9: {
                return this.fromNative(object);
            }
        }
        return null;
    }

    public Variable fromNative(Object object) {
        block48: {
            try {
                if (object instanceof Integer) {
                    return new Integer32(((Integer)object).intValue());
                }
                if (object instanceof Long) {
                    switch (this.smiSyntax) {
                        case 0: 
                        case 8: {
                            return new Integer32(((Long)object).intValue());
                        }
                        case 3: 
                        case 5: {
                            return new Counter32(((Long)object).longValue());
                        }
                        case 11: {
                            return new TimeTicks(((Long)object).longValue());
                        }
                    }
                    return new Gauge32(((Long)object).longValue());
                }
                if (object instanceof BigDecimal) {
                    return new Counter64(((BigDecimal)object).longValue());
                }
                if (object instanceof String) {
                    String s = (String)object;
                    if (this.effectiveSyntax.hasEnums()) {
                        if (this.effectiveSyntax.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                            if (s.indexOf(123) >= 0) {
                                byte[] v = this.effectiveSyntax.getBitsEnum(s);
                                if (v != null) {
                                    return new OctetString(v);
                                }
                                return null;
                            }
                            return new OctetString(ValueConverter.fromBinaryString(s));
                        }
                        if (!s.isEmpty()) {
                            if (Character.getType(s.charAt(0)) == 9) {
                                return new Integer32(Integer.parseInt(s));
                            }
                            int i = this.effectiveSyntax.getEnumValue(s);
                            if (i != Integer.MIN_VALUE) {
                                return new Integer32(i);
                            }
                        }
                        break block48;
                    }
                    if (this.getDisplayHint() != null) {
                        switch (this.smiSyntax) {
                            case 1: 
                            case 10: 
                            case 12: {
                                return ValueConverter.scanString(this.getDisplayHint(), s);
                            }
                            case 3: 
                            case 5: {
                                Long l = ValueConverter.scanLong(this.getDisplayHint(), s);
                                if (l == null) {
                                    return null;
                                }
                                return new Counter32(l.longValue());
                            }
                            case 4: 
                            case 7: 
                            case 13: {
                                Long l = ValueConverter.scanLong(this.getDisplayHint(), s);
                                if (l == null) {
                                    return null;
                                }
                                return new Gauge32(l.longValue());
                            }
                            case 0: 
                            case 8: {
                                Long l = ValueConverter.scanLong(this.getDisplayHint(), s);
                                if (l == null) {
                                    return null;
                                }
                                return new Integer32(l.intValue());
                            }
                            case 6: {
                                Long l = ValueConverter.scanLong(this.getDisplayHint(), s);
                                if (l == null) {
                                    return null;
                                }
                                return new Counter64(l.longValue());
                            }
                        }
                        break block48;
                    }
                    switch (this.smiSyntax) {
                        case 10: {
                            Opaque os = new Opaque();
                            OctetString oss = ValueConverter.fromHexString((String)object);
                            if (oss == null) {
                                return null;
                            }
                            os.setValue(oss.getValue());
                            return os;
                        }
                        case 12: {
                            return ValueConverter.fromBinaryString((String)object);
                        }
                        case 1: {
                            return ValueConverter.fromHexString((String)object);
                        }
                        case 9: {
                            ObjectID id = new ObjectID((String)object);
                            try {
                                if (!id.isValid() || id.size() != 4 || id.getSubIDAsLong(0) > 255L || id.getSubIDAsLong(1) > 255L || id.getSubIDAsLong(2) > 255L || id.getSubIDAsLong(3) > 255L) {
                                    return null;
                                }
                            }
                            catch (ObjectIDFormatException ex) {
                                return null;
                            }
                            return new IpAddress(id.asByteArray());
                        }
                        case 2: {
                            return new OID((String)object);
                        }
                        case 0: 
                        case 8: {
                            return new Integer32(Integer.parseInt(object.toString()));
                        }
                        case 3: 
                        case 5: {
                            return new Counter32(Long.parseLong(object.toString()));
                        }
                        case 11: {
                            TimeTicks t = new TimeTicks();
                            t.setValue(object.toString());
                            return t;
                        }
                        case 4: 
                        case 7: {
                            return new Gauge32(Long.parseLong(object.toString()));
                        }
                    }
                    return null;
                }
                if (object instanceof ComparableIpAddress) {
                    return new IpAddress(object.toString());
                }
                if (object instanceof ObjectID) {
                    if (this.smiSyntax == 9) {
                        return new IpAddress(object.toString());
                    }
                    return new OID(((ObjectID)object).toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String formatLong(Long value, String displayHint) {
        String s = null;
        if (displayHint == null || displayHint.length() < 1) {
            return null;
        }
        char c = displayHint.charAt(0);
        switch (c) {
            case 'd': {
                int dec = -1;
                if (displayHint.length() > 2 && displayHint.charAt(1) == '-') {
                    dec = Integer.parseInt(displayHint.substring(2));
                }
                s = value.toString();
                if (dec <= 0) break;
                int pos = s.length() - dec;
                if (pos <= 0) {
                    s = "." + s;
                    break;
                }
                s = s.substring(0, pos) + "." + s.substring(pos);
                break;
            }
            case 'b': {
                s = Long.toBinaryString(value);
                break;
            }
            case 'o': {
                s = Long.toOctalString(value);
                break;
            }
            case 'x': {
                s = Long.toHexString(value);
            }
        }
        return s;
    }

    public static String formatString(OctetString value, String displayHint) {
        if (displayHint == null) {
            return value.toString();
        }
        OctetString output = new OctetString();
        int pd = 0;
        int pv = 0;
        block6: while (pv < value.length() && pd < displayHint.length()) {
            int end;
            int repetition = 1;
            Character sep = null;
            Character repTerm = null;
            if (displayHint.charAt(pd) == '*') {
                repetition = 0xFF & value.get(pv++);
            }
            for (end = ++pd; end < displayHint.length() && Character.isDigit(displayHint.charAt(end)); ++end) {
            }
            if (end == pd) {
                return value.toString();
            }
            String str = null;
            if (end >= displayHint.length()) {
                return value.toString();
            }
            str = displayHint.substring(pd, end);
            int n = Math.min(Integer.parseInt(str), 65535);
            pd = end;
            char mode = displayHint.charAt(pd++);
            if (pd < displayHint.length() && !Character.isDigit(displayHint.charAt(pd)) && displayHint.charAt(pd) != '*') {
                sep = new Character(displayHint.charAt(pd));
                if (++pd < displayHint.length() && !Character.isDigit(displayHint.charAt(pd)) && displayHint.charAt(pd) != '*') {
                    repTerm = new Character(displayHint.charAt(pd));
                    ++pd;
                }
            }
            for (int k = 0; k < repetition; ++k) {
                if (pv + n >= value.length()) {
                    n = value.length() - pv;
                }
                if (n <= 0 || pv >= value.length()) continue block6;
                byte[] val = new byte[n];
                for (int z = 0; z < n; ++z) {
                    val[z] = value.get(pv + z);
                }
                pv += n;
                if (mode == 'a' || mode == 't') {
                    output.append(val);
                } else {
                    long l = 0L;
                    int len = val.length;
                    for (int i = 0; i < len; ++i) {
                        l = l * 256L + (long)(val[i] & 0xFF);
                    }
                    switch (mode) {
                        case 'd': {
                            output.append(Long.toString(l));
                            break;
                        }
                        case 'b': {
                            output.append(Long.toBinaryString(l));
                            break;
                        }
                        case 'o': {
                            output.append(Long.toOctalString(l));
                            break;
                        }
                        case 'x': {
                            String h = Long.toHexString(l);
                            if (h.length() == 1) {
                                h = "0" + h;
                            }
                            output.append(h);
                            break;
                        }
                    }
                }
                if (sep != null && pv < value.length()) {
                    output.append((byte)sep.charValue());
                }
                if (k + 1 < repetition) {
                    output.append((byte)repTerm.charValue());
                }
                if (pd < displayHint.length()) continue;
                pd = 0;
            }
        }
        return new String(output.getValue());
    }

    public static OctetString scanString(String format, String value) {
        if (format == null) {
            return new OctetString(value);
        }
        int i = 0;
        boolean valid = false;
        int fmt = 0;
        int last = 0;
        boolean have_pfx = false;
        int pfx = 0;
        int vv = 0;
        if (value == null || format == null) {
            return null;
        }
        OctetString out = new OctetString();
        while (fmt < format.length() && i < value.length()) {
            last = fmt;
            have_pfx = false;
            pfx = 0;
            while (fmt < format.length() && Character.isDigit(format.charAt(fmt))) {
                pfx = pfx * 10 + format.charAt(fmt) - 48;
                have_pfx = true;
                ++fmt;
            }
            if (!have_pfx) {
                pfx = 1;
            }
            valid = false;
            switch (format.charAt(fmt)) {
                case 'a': 
                case 't': {
                    if (pfx < value.length() - i) {
                        out.append(value.substring(i, i + pfx).getBytes());
                        i += pfx;
                        break;
                    }
                    out.append(value.substring(i).getBytes());
                    i = value.length();
                    break;
                }
                case 'b': {
                    int start = i;
                    while (i < value.length() && (value.charAt(i) == '0' || value.charAt(i) == '1')) {
                        ++i;
                    }
                    try {
                        vv = Integer.parseInt(value.substring(start, i), 2);
                        valid = true;
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                    }
                    break;
                }
                case 'd': {
                    int start = i;
                    while (i < value.length() && Character.isDigit(value.charAt(i))) {
                        ++i;
                    }
                    try {
                        vv = Integer.parseInt(value.substring(start, i), 10);
                        valid = true;
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                    }
                    break;
                }
                case 'o': {
                    int start = i;
                    while (i < value.length() && value.charAt(i) >= '0' && value.charAt(i) <= '7') {
                        ++i;
                    }
                    try {
                        vv = Integer.parseInt(value.substring(start, i), 8);
                        valid = true;
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                    }
                    break;
                }
                case 'x': {
                    int start = i;
                    while (i < value.length() && (value.charAt(i) >= '0' && value.charAt(i) <= '9' || value.charAt(i) >= 'A' && value.charAt(i) <= 'F' || value.charAt(i) >= 'a' && value.charAt(i) <= 'f')) {
                        ++i;
                    }
                    try {
                        vv = Integer.parseInt(value.substring(start, i), 16);
                        valid = true;
                    }
                    catch (NumberFormatException nfe) {
                        valid = false;
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
            ++fmt;
            if (valid) {
                while (pfx > 0) {
                    byte c = (byte)(vv >> (pfx - 1) * 8 & 0xFF);
                    out.append(c);
                    --pfx;
                }
            }
            if (fmt < format.length() && format.charAt(fmt) != '*') {
                if (!Character.isDigit(format.charAt(fmt))) {
                    ++fmt;
                }
                if (i < value.length() && !Character.isDigit(value.charAt(i))) {
                    ++i;
                }
            }
            if (fmt < format.length() || i >= value.length()) continue;
            if (valid) {
                fmt = last;
                continue;
            }
            return null;
        }
        return out;
    }

    public static Long scanLong(String format, String value) throws NumberFormatException {
        if (format == null) {
            return new Long(value);
        }
        Long out = null;
        long l = 0L;
        int v = 0;
        int dpt = 0;
        int i = 0;
        boolean sign = false;
        if (format == null || format.length() < 1 || value == null || value.length() < 1) {
            return null;
        }
        switch (format.charAt(0)) {
            case 'd': {
                if (format.length() == 1) {
                    out = new Long(value);
                    break;
                }
                if (format.length() < 2) {
                    return null;
                }
                if (format.charAt(1) != '-') break;
                if (Character.isDigit(format.charAt(2))) {
                    dpt = 0;
                    i = 0;
                    while (i + 2 < format.length() && Character.isDigit(format.charAt(2 + i))) {
                        dpt = dpt * 10 + (format.charAt(2 + i) - 48);
                        ++i;
                    }
                }
                if (2 + i < format.length()) break;
                if (value.charAt(0) == '-') {
                    sign = true;
                    ++v;
                }
                int frac = -1;
                l = 0L;
                while (v < value.length() && (Character.isDigit(value.charAt(v)) || value.charAt(v) == '.')) {
                    if (value.charAt(v) == '.') {
                        if (frac >= 0) break;
                        frac = 0;
                    } else {
                        l = l * 10L + (long)(value.charAt(v) - 48);
                        if (frac >= 0) {
                            ++frac;
                        }
                    }
                    ++v;
                }
                if (v < value.length()) break;
                while (frac < dpt) {
                    l *= 10L;
                    ++frac;
                }
                while (frac > dpt) {
                    l /= 10L;
                    --frac;
                }
                out = new Long(sign ? -1L * l : l);
                break;
            }
            case 'x': {
                if (format.length() > 1) break;
                out = new Long(Long.parseLong(value, 16));
                break;
            }
            case 'o': {
                if (format.length() > 1) break;
                out = new Long(Long.parseLong(value, 8));
                break;
            }
            case 'b': {
                if (format.length() > 1) break;
                out = new Long(Long.parseLong(value, 2));
                break;
            }
        }
        return out;
    }

    public static OctetString fromHexString(String hexString) {
        try {
            boolean deliFound = hexString.length() % 2 == 1;
            for (int i = 0; i < hexString.length(); ++i) {
                char c = hexString.charAt(i);
                switch (c) {
                    case ' ': 
                    case '\"': 
                    case ':': {
                        deliFound = true;
                    }
                }
            }
            OctetString val = new OctetString();
            if (!deliFound) {
                for (int i = 0; i < hexString.length(); i += 2) {
                    String t = hexString.substring(i, i + 2);
                    int iv = Integer.valueOf(t, 16);
                    if (iv < 0 || iv > 255) {
                        return null;
                    }
                    byte c = (byte)(iv & 0xFF);
                    val.append(c);
                }
            } else {
                boolean escaped = false;
                StringTokenizer st = new StringTokenizer(hexString, " :\"", true);
                while (st.hasMoreTokens()) {
                    String t = st.nextToken();
                    if (t.equals("\"")) {
                        if (!(escaped = !escaped) || !st.hasMoreTokens()) continue;
                        val.append(st.nextToken());
                        continue;
                    }
                    if (t.equals(" ") || t.equals(":")) continue;
                    int iv = Integer.valueOf(t, 16);
                    if (iv < 0 || iv > 255) {
                        return null;
                    }
                    byte c = (byte)(iv & 0xFF);
                    val.append(c);
                }
            }
            return val;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public MIBSyntax getEffectiveSyntax() {
        return this.effectiveSyntax;
    }

    public int compare(Object a, Object b) {
        try {
            if (a instanceof Comparable) {
                return ((Comparable)a).compareTo(b);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static long parseLongConstant(String value) throws NumberFormatException {
        if (value.endsWith("h") || value.endsWith("H")) {
            StringTokenizer st = new StringTokenizer(value, "'");
            if (!st.hasMoreTokens()) {
                throw new NumberFormatException("Hex string must be enclosed in '.");
            }
            return Long.parseLong(st.nextToken(), 16);
        }
        if (value.endsWith("o") || value.endsWith("O")) {
            StringTokenizer st = new StringTokenizer(value, "'");
            if (!st.hasMoreTokens()) {
                throw new NumberFormatException("Octal string must be enclosed in '.");
            }
            return Long.parseLong(st.nextToken(), 8);
        }
        if (value.endsWith("b") || value.endsWith("B")) {
            StringTokenizer st = new StringTokenizer(value, "'");
            if (!st.hasMoreTokens()) {
                throw new NumberFormatException("Binary string must be enclosed in '.");
            }
            return Long.parseLong(st.nextToken(), 2);
        }
        return Long.parseLong(value, 10);
    }

    public static OctetString parseStringConstant(String value) throws NumberFormatException {
        int radix = 10;
        int step = 3;
        if (value.startsWith("\"")) {
            StringTokenizer st = new StringTokenizer(value, "\"");
            if (!st.hasMoreTokens()) {
                return new OctetString();
            }
            return new OctetString(st.nextToken());
        }
        if (value.startsWith("'")) {
            StringTokenizer st;
            if (value.endsWith("h") || value.endsWith("H")) {
                radix = 16;
                step = 2;
            }
            if (value.endsWith("o") || value.endsWith("O")) {
                radix = 8;
                step = 4;
            }
            if (value.endsWith("b") || value.endsWith("B")) {
                radix = 2;
                step = 8;
            }
            if (!(st = new StringTokenizer(value, "'")).hasMoreTokens()) {
                throw new NumberFormatException("String must be enclosed in '.");
            }
            String s = st.nextToken();
            if (s.length() == 0) {
                return new OctetString();
            }
            try {
                OctetString buf = new OctetString();
                for (int i = 0; i < s.length(); i += step) {
                    byte c = (byte)Integer.parseInt(s.substring(i, i + step), radix);
                    buf.append(c);
                }
                return buf;
            }
            catch (StringIndexOutOfBoundsException siobe) {
                return new OctetString();
            }
        }
        return new OctetString(value);
    }

    public static Variable getDefaultValue(MIBRepository rep, MIBObjectType ot, MIBSyntax syn) {
        try {
            if (!ot.hasDefaultValue()) {
                return null;
            }
            String defValue = ot.getDefaultValue();
            if (syn.hasEnums()) {
                if (!syn.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    String en = syn.getEnum(defValue);
                    if (en == null) {
                        return null;
                    }
                    return new Integer32((int)ValueConverter.parseLongConstant(en));
                }
                byte[] b = syn.getBitsEnum(defValue);
                if (b == null) {
                    return null;
                }
                return new OctetString(b);
            }
            if (syn.getSyntax().equals("INTEGER") || syn.getSyntax().equals("Integer32")) {
                return new Integer32((int)ValueConverter.parseLongConstant(defValue));
            }
            if (syn.getSyntax().equals("Counter") || syn.getSyntax().equals("Counter32")) {
                return new Counter32(ValueConverter.parseLongConstant(defValue));
            }
            if (syn.getSyntax().equals("UInteger32") || syn.getSyntax().equals("Unsigned32") || syn.getSyntax().equals("Gauge") || syn.getSyntax().equals("Gauge32")) {
                return new Gauge32(ValueConverter.parseLongConstant(defValue));
            }
            if (syn.getSyntax().equals("Counter64")) {
                return new Counter64(ValueConverter.parseLongConstant(defValue));
            }
            if (syn.getSyntax().equals("TimeTicks")) {
                return new TimeTicks(ValueConverter.parseLongConstant(defValue));
            }
            if (syn.getSyntax().equals("IpAddress") || syn.getSyntax().equals("NetworkAddress")) {
                IpAddress ipAddress = new IpAddress();
                try {
                    ipAddress.setAddress(ValueConverter.parseStringConstant(defValue).getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ipAddress;
            }
            if (syn.getSyntax().equals("Opaque")) {
                Opaque opaque = new Opaque();
                opaque.setValue(ValueConverter.parseStringConstant(defValue));
                return opaque;
            }
            if (syn.getSyntax().startsWith("OCTET STRING")) {
                return ValueConverter.parseStringConstant(defValue);
            }
            if (syn.getSyntax().equals("OBJECT-IDENTITY") || syn.getSyntax().equals("OBJECT IDENTIFIER")) {
                if (defValue.indexOf(123) >= 0) {
                    StringTokenizer st = new StringTokenizer("{ }");
                    StringBuffer buf = new StringBuffer();
                    while (st.hasMoreTokens()) {
                        buf.append(st.nextToken());
                        if (!st.hasMoreTokens()) continue;
                        buf.append('.');
                    }
                    return new OID(buf.toString());
                }
                ObjectID id = new ObjectID(defValue);
                if (id.isValid()) {
                    return new OID(id.toString());
                }
                id = rep.getObjectID(defValue);
                if (id != null) {
                    return new OID(id.toString());
                }
                return new OID();
            }
            return new OctetString(defValue);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public int getSMISyntax() {
        return this.smiSyntax;
    }

    public Object getNativeExample() {
        switch (this.smiSyntax) {
            case 0: 
            case 8: {
                return new Integer(0);
            }
            case 1: 
            case 10: 
            case 12: {
                return new String();
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 11: 
            case 13: {
                return new Long(0L);
            }
            case 6: {
                return new BigDecimal(0);
            }
            case 9: {
                return new ComparableIpAddress("0.0.0.0");
            }
            case 2: {
                return new ObjectID("0.0");
            }
        }
        return new String();
    }

    public boolean isNumber() {
        switch (this.smiSyntax) {
            case 0: 
            case 8: {
                return true;
            }
            case 1: 
            case 10: 
            case 12: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: {
                return true;
            }
            case 2: 
            case 9: {
                return false;
            }
        }
        return false;
    }

    public boolean isSyntaxCompatible(int snmpSyntax) {
        switch (this.smiSyntax) {
            case 0: 
            case 8: {
                return snmpSyntax == 2;
            }
            case 1: 
            case 12: {
                return snmpSyntax == 4;
            }
            case 10: {
                return snmpSyntax == 68;
            }
            case 3: 
            case 5: {
                return snmpSyntax == 65;
            }
            case 11: {
                return snmpSyntax == 67;
            }
            case 4: 
            case 7: 
            case 13: {
                return snmpSyntax == 66;
            }
            case 6: {
                return snmpSyntax == 70;
            }
            case 9: {
                return snmpSyntax == 64;
            }
            case 2: {
                return snmpSyntax == 6;
            }
            case 14: {
                return snmpSyntax == 5;
            }
        }
        return true;
    }

    public static String getExceptionString(int snmpSyntax) {
        switch (snmpSyntax) {
            case 129: {
                return "noSuchInstance";
            }
            case 128: {
                return "noSuchObject";
            }
            case 130: {
                return "endOfMibView";
            }
        }
        return null;
    }

    public boolean isWritable() {
        if (this.ot != null) {
            return SMI.isWritable(this.ot.getAccess());
        }
        return false;
    }

    public static String[] toString(MIBRepository rep, VariableBinding vb, ValueConverter vc, Object nativeValue) {
        String[] result = new String[3];
        ObjectID id = new ObjectID(vb.getOid().getValue());
        Pair p = null;
        try {
            p = rep.getSplittedObjectID(id);
            if (p == null) {
                return null;
            }
            ObjectID obj = (ObjectID)p.first;
            ObjectID ins = (ObjectID)p.second;
            if (obj != null && ins != null) {
                MIBObject mobj;
                MIBObject mIBObject = mobj = vc != null ? vc.getObjectType() : rep.getObject(obj);
                if (mobj instanceof MIBObjectType) {
                    MIBObject ot = mobj;
                    if (((MIBObjectType)ot).isColumnarObject()) {
                        MIBObjectType table = (MIBObjectType)rep.getParent(ot);
                        if (table != null) {
                            if (vc == null) {
                                MIBTextualConvention tc = rep.getEffectiveSyntax(((MIBObjectType)ot).getSyntax());
                                vc = new ValueConverter((MIBObjectType)ot, tc.getSyntax(), tc.getDisplayHint());
                            }
                            IndexStruct[] indexStruct = table.getIndexPart().getIndexStruct(rep);
                            ObjectID[] index = rep.getIndexObjectIDs(ins, indexStruct);
                            ValueConverter[] indexVCs = IndexConverter.getIndexValueConverter(rep, table);
                            result[0] = IndexConverter.getIndexString(indexVCs, indexStruct, index);
                            result[1] = "" + vc.toNative(vb.getVariable());
                            result[2] = ot.getOid().toString();
                        }
                    } else if (((MIBObjectType)ot).isScalar()) {
                        result[0] = null;
                        MIBTextualConvention tc = rep.getEffectiveSyntax(((MIBObjectType)ot).getSyntax());
                        if (vc == null) {
                            vc = new ValueConverter((MIBObjectType)ot, tc.getSyntax(), tc.getDisplayHint());
                        }
                        result[1] = nativeValue == null ? "" + vc.toNative(vb.getVariable()) : "" + nativeValue;
                        result[2] = ot.getOid().toString();
                    }
                }
            }
            return result;
        }
        catch (ObjectIDFormatException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ValueConverter create(MIBObjectType ot, MIBRepository rep) {
        MIBTextualConvention tc = rep.getEffectiveSyntax(ot.getSyntax());
        return new ValueConverter(ot, tc.getSyntax(), tc.getDisplayHint());
    }

    public String toString() {
        return "ValueConverter{objectType=" + this.ot + ",effectiveSyntax=" + this.effectiveSyntax + ",displayHint=" + this.displayHint + ",smiSyntax=" + this.smiSyntax + "}";
    }
}

