/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.ModuleInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class ModuleInfoSorter {
    private ModuleInfo[] list = new ModuleInfo[0];
    private List<ModuleInfo> sorted = new ArrayList<ModuleInfo>();
    private List<ModuleInfo> source = new ArrayList<ModuleInfo>();
    private HashSet<String> missing = new HashSet();
    private Hashtable<String, ModuleInfo> pool = null;
    private HashSet<String> backupPool = null;

    public ModuleInfoSorter(ModuleInfo[] list) {
        this.list = list;
        this.resetPool();
    }

    public static ModuleInfo[] difference(ModuleInfo[] a, ModuleInfo[] b) {
        ArrayList<ModuleInfo> v = new ArrayList<ModuleInfo>(a.length);
        for (ModuleInfo moduleInfo : a) {
            boolean match = false;
            for (ModuleInfo info : b) {
                if (!moduleInfo.moduleName.equals(info.moduleName)) continue;
                match = true;
                break;
            }
            if (match) continue;
            v.add(moduleInfo);
        }
        return v.toArray(new ModuleInfo[0]);
    }

    public void setPool(ModuleInfo[] poolList) {
        this.pool = new Hashtable(this.list.length + poolList.length);
        for (ModuleInfo moduleInfo : poolList) {
            this.putInPoolIfNewer(moduleInfo);
        }
    }

    public void resetPool() {
        this.pool = new Hashtable(this.list.length + 1);
    }

    public void setBackupPool(String[] moduleNames) {
        this.backupPool = new HashSet<String>(Arrays.asList(moduleNames));
    }

    public boolean sort() {
        this.source = new ArrayList<ModuleInfo>(this.list.length);
        this.source.addAll(Arrays.asList(this.list));
        this.sorted = new ArrayList<ModuleInfo>(this.list.length);
        this.missing = new HashSet();
        boolean foundAny = true;
        boolean useBackupPool = false;
        while (foundAny && this.source.size() > 0) {
            foundAny = false;
            Iterator<ModuleInfo> en = this.source.iterator();
            while (en.hasNext()) {
                ModuleInfo m = en.next();
                boolean found = true;
                for (int i = 0; i < m.getImports().length; ++i) {
                    if (this.pool.get(m.getImports()[i]) != null || useBackupPool && this.backupPool.contains(m.getImports()[i])) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                foundAny = true;
                en.remove();
                this.pool.put(m.moduleName, m);
                this.sorted.add(m);
            }
            if (!foundAny && this.backupPool != null && !useBackupPool) {
                useBackupPool = true;
                foundAny = true;
                continue;
            }
            useBackupPool = false;
        }
        Hashtable<String, ModuleInfo> failed = new Hashtable<String, ModuleInfo>(this.source.size() + 1);
        for (ModuleInfo m : this.source) {
            failed.put(m.moduleName, m);
        }
        return this.source.size() == 0;
    }

    private boolean putInPoolIfNewer(ModuleInfo moduleInfo) {
        ModuleInfo prev = this.pool.put(moduleInfo.moduleName, moduleInfo);
        if (prev != null && (prev.getLastUpdated() != null && moduleInfo.getLastUpdated() != null && prev.getLastUpdated().after(moduleInfo.getLastUpdated()) || prev.getLastUpdated() != null && moduleInfo.getLastUpdated() == null)) {
            this.pool.put(prev.moduleName, prev);
            return false;
        }
        return true;
    }

    public ModuleInfo[] getSortedList() {
        return this.sorted.toArray(new ModuleInfo[0]);
    }

    public ModuleInfo[] getFailedList() {
        return this.source.toArray(new ModuleInfo[0]);
    }

    public String[] getMissingModules() {
        Object[] o = this.missing.toArray();
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = o[i].toString();
        }
        return s;
    }
}

