/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IModule;
import com.agentpp.smi.IObject;
import com.agentpp.smi.IObjectID;
import com.agentpp.smi.IObjectType;
import com.agentpp.smi.IRepository;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ITextualConvention;
import com.objectspace.jgl.Pair;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class SMIRepository
implements IRepository {
    protected MIBRepository rep = new MIBRepository(false);

    @Override
    public int size() {
        return this.rep.size();
    }

    @Override
    public int moduleCount() {
        return this.rep.moduleCount();
    }

    @Override
    public void addObject(IObject object) {
        this.rep.addObject(SMIRepository.makeObject(object));
    }

    private static ObjectID makeObjectID(IObjectID oid) {
        if (oid instanceof ObjectID) {
            return (ObjectID)oid;
        }
        return new ObjectID(oid.toString());
    }

    private static MIBObject makeObject(IObject object) {
        if (object instanceof MIBObject) {
            return (MIBObject)object;
        }
        throw new IllegalArgumentException("Only JASMI created instances of IObject are currently supported");
    }

    @Override
    public String getObjectName(IObjectID oid) {
        return this.rep.getObjectName(SMIRepository.makeObjectID(oid));
    }

    @Override
    public IObjectID getObjectID(String name) {
        return this.rep.getObjectID(name);
    }

    @Override
    public IObjectID getObjectID(String moduleName, String name) {
        return this.rep.getObjectID(moduleName, name);
    }

    @Override
    public IObject getObject(String moduleName, String name) {
        return this.rep.getObject(moduleName, name);
    }

    @Override
    public Vector getChildren(String objectName) {
        return this.rep.getChildren(objectName);
    }

    @Override
    public Vector getChildren(IObjectID oid) {
        return this.rep.getChildren(SMIRepository.makeObjectID(oid));
    }

    @Override
    public Vector getChildren(IObject object) {
        return this.getChildren(SMIRepository.makeObject(object));
    }

    @Override
    public Vector getDescendants(IObject object) {
        return this.rep.getDescendants(SMIRepository.makeObject(object));
    }

    @Override
    public IObject getParent(IObject object) {
        return this.rep.getParent(SMIRepository.makeObject(object));
    }

    @Override
    public IObject[] getObjectsByName(String name) {
        return this.rep.getObjectsByName(name);
    }

    @Override
    public IObject[] getObjectsByOid(IObjectID oid) {
        return this.rep.getObjectsByOid(SMIRepository.makeObjectID(oid));
    }

    @Override
    public void remove(IModule module) {
        this.rep.removeModule(module.getModuleName());
    }

    @Override
    public void removeObject(IObject object) {
        this.rep.removeObject(SMIRepository.makeObject(object));
    }

    @Override
    public boolean removeModule(String name) {
        return this.rep.removeModule(name);
    }

    @Override
    public IModule getModule(String moduleName) {
        return this.rep.getModule(moduleName);
    }

    @Override
    public IObject getObject(String name) {
        return this.rep.getObject(name);
    }

    @Override
    public IObject getObject(IObjectID oid) {
        return this.rep.getObject(SMIRepository.makeObjectID(oid));
    }

    @Override
    public Enumeration modules() {
        return this.rep.modules();
    }

    @Override
    public Iterator modulesIterator() {
        return this.rep.modulesIterator();
    }

    @Override
    public Enumeration getModulesSortedByName() {
        return this.rep.getModulesSortedByName();
    }

    @Override
    public Vector getModuleNames() {
        return this.rep.getModuleNames();
    }

    @Override
    public Enumeration objects() {
        return this.rep.objects();
    }

    @Override
    public Enumeration objectsByName() {
        return this.rep.objectsByName();
    }

    @Override
    public Iterator objectsOrderedByOccurance() {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(128));
        Enumeration en = this.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        return orderedObjects.values().iterator();
    }

    @Override
    public void structureChanged() {
        this.rep.structureChanged();
    }

    @Override
    public String getPath(IObjectID oid, boolean withID) {
        return this.rep.getPath(SMIRepository.makeObjectID(oid), withID);
    }

    @Override
    public Vector getNonOidObjects(boolean textualConventionsOnly) {
        return this.rep.getNonOidObjects(textualConventionsOnly);
    }

    @Override
    public String printModule(String moduleName) {
        return this.rep.printModule(moduleName);
    }

    @Override
    public IObjectID makeObjectID(String oid) {
        ObjectID id = new ObjectID(oid);
        if (!id.isValid()) {
            return this.rep.resolveOID(id);
        }
        return id;
    }

    @Override
    public String getPath(String oid, boolean withID) {
        IObjectID id = this.makeObjectID(oid);
        if (id == null) {
            return null;
        }
        return this.getPath(oid, withID);
    }

    @Override
    public IObject getObjectByOID(String oid) {
        ObjectID id = (ObjectID)this.makeObjectID(oid);
        if (id == null) {
            return null;
        }
        return this.rep.getObject(id);
    }

    @Override
    public IObject[] getObjectsByOid(String oid) {
        ObjectID id = (ObjectID)this.makeObjectID(oid);
        if (id == null) {
            return null;
        }
        return this.getObjectsByOid(id);
    }

    @Override
    public ITextualConvention getEffectiveSyntax(ISyntax syntax) {
        if (syntax instanceof MIBSyntax) {
            return this.rep.getEffectiveSyntax((MIBSyntax)syntax);
        }
        return this.rep.getEffectiveSyntax(new MIBSyntax(syntax));
    }

    @Override
    public Vector getObjectClassOID(String oid) {
        ObjectID id = (ObjectID)this.makeObjectID(oid);
        if (id == null) {
            throw new IllegalArgumentException("Invalid OID given: " + oid);
        }
        try {
            Pair p = this.rep.getSplittedObjectID(id);
            Vector<String> v = new Vector<String>(2);
            v.add(p.first != null ? p.first.toString() : null);
            v.add(p.second != null ? p.second.toString() : null);
            return v;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Invalid OID given: " + oid);
        }
    }

    @Override
    public IObjectType getObjectClass(String oid) {
        try {
            Vector v = this.getObjectClassOID(oid);
            MIBObjectType ot = this.rep.getObjectType((ObjectID)v.firstElement());
            return ot;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

