/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smi.event.RepositoryListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InMemoryRepository
implements RepositoryListener {
    private Map repository = new HashMap();

    @Override
    public void deleteModule(RepositoryEvent event) {
        event.setModuleDeleted(this.repository.remove(event.getModuleName()) != null);
    }

    @Override
    public void readModule(RepositoryEvent event) {
        ByteArray bytes = (ByteArray)this.repository.get(event.getModuleName());
        if (bytes == null) {
            event.setUseDefaults(false);
            return;
        }
        event.setInputStream(new ByteArrayInputStream(bytes.bytes));
    }

    @Override
    public void writeModule(RepositoryEvent event) {
        event.setOutputStream(new CacheOutputStream(event.getModuleName()));
    }

    public Set getModuleNames() {
        return this.repository.keySet();
    }

    @Override
    public String[] listModuleNames() {
        return this.repository.keySet().toArray(new String[this.repository.size()]);
    }

    private class ByteArray {
        byte[] bytes;

        ByteArray(byte[] b) {
            this.bytes = b;
        }
    }

    class CacheOutputStream
    extends ByteArrayOutputStream {
        private String moduleName;

        CacheOutputStream(String moduleName) {
            this.moduleName = moduleName;
        }

        @Override
        public void close() throws IOException {
            super.close();
            byte[] b = super.toByteArray();
            InMemoryRepository.this.repository.put(this.moduleName, new ByteArray(b));
        }
    }
}

