/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.util;

import java.util.Comparator;
import org.snmp4j.smi.OID;

public class OIDComparator
implements Comparator<OID> {
    private OIDOrder order;

    public OIDComparator() {
        this.order = OIDOrder.depthFirstOrder;
    }

    public OIDComparator(OIDOrder order) {
        this.order = order;
    }

    @Override
    public int compare(OID o1, OID o2) {
        if (this.order == OIDOrder.breadthFirstOrder) {
            int szDiff = o1.size() - o2.size();
            if (szDiff == 0) {
                return o1.leftMostCompare(o1.size(), o2);
            }
            return szDiff;
        }
        int size = o1.size();
        int c = o1.leftMostCompare(size, o2);
        if (c == 0) {
            if (size < o2.size()) {
                return -1;
            }
            if (size > o2.size()) {
                return 1;
            }
            return 0;
        }
        return c;
    }

    public static enum OIDOrder {
        depthFirstOrder,
        breadthFirstOrder;

    }
}

